"""
    ColormapSelect.py
    ColormapFilter parameters control widget.
"""

from PyDVT import __version__,__date__,__author__


################################################################################
import EventHandler
from Binding import *



class ColormapSelect(Container):
    """
    Accessory class, that manages changing of the colormap parameters
    and triggers ColormapChange events to all linked ColormapFilter
    Contains a ColormapEditorWidget from Binding.
    Linked to ColormapFilter objects thrugh ColormapFilter.ConnectColormap
    method.
    """

    def __init__(self, parent,initial_colormap):
        """
        Constructor
        Parameters:
        root: parent widget
        initial_colormap: Initial colormap parameters, as returned by
                         ImageView.GetImageParameters
        """        
        self.eh = EventHandler.EventHandler()
        self.ImagePar=initial_colormap
        self.ColormapChange = self.eh.create("ColormapChange")
        Container.__init__(self,parent)
        
        self.Widget=ColormapEditorWidget(self,initial_colormap)        

    def Apply(self,ImageParameters):
        """
        Called by ColormapEditorWidget then change takes place
        """
        self.eh.event(self.ColormapChange,ImageParameters)

        


class ColormapDialog(Dialog):
    """
    Accessory class, dialog containing ColormapSelect widget
    """
    def __init__(self, parent,initial_colormap):
        self.ImagePar=initial_colormap
        Dialog.__init__(self,parent,"Colormap Editor",0)
        self.Colormap=ColormapSelect(self,self.ImagePar)
        self.AddContainer(self.Colormap)
        self.Show()
        
        """
        import Numeric
        scale_width=self.Colormap.GetWidth()
        scale_height=30
        label=Label(self.Colormap)
       
        from ImageView import ImageView,Image
        self.ViewScale=ImageView(label,{"ZoomMode":"OFF","ScrollMode":"OFF"})
        arr = Numeric.zeros ((scale_height,scale_width))
        interval= initial_colormap["AbsoluteMinMax"]
        for i in range(scale_width): arr[:,i]= interval[0]+(float(interval[1])-interval[0])*float(i)/scale_width
        
        
        image=Image(arr)
        image.SetColormapParameters(self.ImagePar)
        image.ConnectColormap(self.Colormap)
        self.ViewScale.SetSource(image)
        self.ViewScale.SetSize(scale_width,scale_height)
        self.ViewScale.Show()
        label.Show()
        """

