"""
This module implements the application menu bar.
"""
from Tkinter import *
from Tkinter import _cnfmerge
import tkMessageBox
from ScriptOption import *

DEBUG=0

COMMAND   = 1
SEPARATOR = 2
CASCADE   = 3
MAXMENUENTRIES = 40

class BasicMenu(Frame):
     def __init__(self,master,cnf={},**kw):
        if DEBUG:
            print 'BasicMenu : init'

        cnf = _cnfmerge((cnf,kw))
        Frame.__init__(self,master,cnf)
        self.master         = master
        self.menulist={}

        self.build()

     def build(self):
        """
        Build the item list of each menu and then call create_menu.
        """
        if DEBUG:
	        print "BasicMenu :Building this"
	       
                         
        help_menu  = [  "Help" , None,
                          [COMMAND, "Version",    self.version],
                          [COMMAND, "Author",     self.author], 
                          [COMMAND, "Contact",    self.contact]       ]

        #self.configmenu  = self.create_menu(config_menu)
        #self.helpmenu  = self.create_menu(help_menu,side='right')
        self.create_menu(help_menu,side='right')

     def create_menu(self,menudesc,side='left'):
          """
          Create each menu from the description menudesc.
          """
          if DEBUG:
                print 'WMenubar : creating menu'

          button = Menubutton(self, text = menudesc[0], underline = None) 
          button.bind('<Enter>',self.__relief)
          button.bind('<Leave>',self.__unrelief)
          button.bind('<Button-1>',self.__unrelief)
          if len(menudesc) > 2:
            menu   = Menu(button, tearoff = 0)
            if menudesc[1]:
                menu.configure(postcommand=menudesc[1])
            button['menu'] = menu
            for item in menudesc[2:]:
                if item[0]   == COMMAND:
                    menu.add_command(label=item[1], underline=None,command= item[2])
                elif item[0] == CASCADE:
                    newmenu = item[2](menu)
                    menu.add_cascade(label=item[1], menu=newmenu )
                elif item[0] == SEPARATOR:
                    menu.add_separator()
            button.pack(side=side)
            self.menulist[menudesc[0]]  = menu
          else:
            button.bind('<Button-1>',menudesc[1])
            button.pack(side=side)



     def update_menu(self,menudesc):
        if self.menulist.has_key(menudesc[0]):
            #delete a huge number of entries
            try:
                self.menulist[menudesc[0]].delete(0,MAXMENUENTRIES+1)                
            except:
                return
                
        if menudesc[1]:                
            self.menulist[menudesc[0]].configure(postcommand=menudesc[1])
        for item in menudesc[2:]:
            if item[0]   == COMMAND:
                self.menulist[menudesc[0]].add_command(label=item[1], underline=0,command= item[2])
            elif item[0] == CASCADE:
                newmenu = item[2](self.menulist[menudesc[0]])
                self.menulist[menudesc[0]].add_cascade(label=item[1], menu=newmenu )
            elif item[0] == SEPARATOR:
                self.menulist[menudesc[0]].add_separator()

     #Method not yet implemented
     #def update_entry(self,menudesc,entrylabel):
     #   #First get the entry index
     #   idx=self.get_entry_index(menudesc,entrylabel)
     #   if idx is not None:
     #     self.menulist[menudesc[0]].entryconfigure(idx,label=entrylabel,

     def get_entry_index(self,menudesc,entrylabel):
        """
        get_entry_index(self,menudesc,entrylabel)
        Given a menudescription and a potential entry label
        gives back the index of that label or None if the label
        is not present            
        """
        for i in range(MAXMENUENTRIES):
            if self.menulist[menudesc[0]].entrycget(i,'label') == entrylabel:
                return i
                                
        return None          

     def __relief(self,event):
          """
          Give relief to a menu button when mouse passes on it.
          """
          event.widget.configure(relief='raise')

     def __unrelief(self,event):
          """
          Unrelief a menu button when is clicked, or when the mouse leaves its
          area.
          """
          event.widget.configure(relief='flat')

     def version(self):
        line = 'This is the %s version of Specfit (February 2002)' % "development"
        tkMessageBox.showinfo('Version',line)

     def author(self):
        line = 'Written by V. Armando Sole'
        tkMessageBox.showinfo('Author',line)

     def contact(self):
        line = 'For feedback, please contact : sole@esrf.fr'
        tkMessageBox.showinfo('Contact',line)

if __name__ == '__main__':
    root = Tk()
    menu=BasicMenu(root)
    item = 10
    def test(item='default'):
        print "Hello from test function"
        print "Received argument = ",item
        testdialog()
    config_menu  = [  "Config", None,
                          [COMMAND, "Configure",  lambda i=item:test(i)],
                          [SEPARATOR, ],
                          [COMMAND, "Load Config",  None],
                          [COMMAND, "Save Config",  None],
                          [SEPARATOR,],
                          [COMMAND, "Load Defaults",  None],
                          [COMMAND, "Save Defaults", None],
                          [SEPARATOR, ],
                          [COMMAND, "Exit",       None]   ]
    menu.create_menu(config_menu)
    #help_menu = [ "Help",None,
    #                    [COMMAND, "Configure",  lambda i=20:test(i)]]
    #menu.update_menu(help_menu)

    menu.pack()
    root.mainloop()
