/***************************************************************************
                          estraiasfhfs.cc  -  description
                             -------------------
    begin                : Thu Jan 13 2000
    copyright            : (C) 2000 by Alessandro MIRONE
    email                : mirone@lure.u-psud.fr
 ***************************************************************************/


#include<stdio.h>
#include<iostream.h>
#include<string.h>
#include<math.h>
#include<complex.h>
#include<nMatrix/nMatrix.h>
#include <nMatrix/nLapack.h>
#include"../atomosferico/fichier.h"
#include"../atomosferico/hfs.h"
#include"../atomosferico/integrate.h"
#include"../atomosferico/wigner.h"

#include"../libasfhfs/asfhfs.h"

#define DEBUG

#define Abs(a) ( ((a)>0)?  (a):(-(a)) )
#define Min(a,b) ( ((a)<(b))?  (a):(b) )
#define Max(a,b) ( ((a)>(b))?  (a):(b) 


class uscita {
public:
  
#define uENERGIA 1
#define uLL      2
#define usLL     3
#define uSS      4
#define usSS     5

#define uMz      6
#define uSz      7
#define uJz      8
#define uJJ      9
#define uSLpar      -1
#define uLLpar      -2
#define uSSpar      -3
#define uQUIT      0
  
  int tipo;
  int indice;
  int pos;
  uscita *next;
  
  static uscita *chiedi();
  void stampa(asfhfs &atomo);
};
char *risp[]={"ENERGIA","LL","sLL","SS","sSS",
	      "Mz","Sz", "Jz", "JJ",
	      "SLpar","LLpar","SSpar","QUIT"
};

char opzioni[]="non c e bisogno di opzioni qua";
int tiporisp[]={uENERGIA,  uLL, usLL ,uSS, usSS,
		uMz, uSz, uJz, uJJ,
		uSLpar, uLLpar, uSSpar , uQUIT};

void uscita::stampa(asfhfs &a)
{
  FILE *f;
  cout << " dammi il nome del file di uscita\n";
  char nome[80];
  cin >> nome;
  f=fopen(nome,"w");
  {
    uscita *ptr=this;
    fprintf(f,"#");
    while(ptr)
      {
	fprintf(f, " ");
	
	fprintf(f,risp[ptr->pos]);
	if(ptr->tipo<0) fprintf(f,"%d",ptr->indice);
	ptr=ptr->next;
      }
    fprintf(f,"\n");
  }
  
  for(int i=0; i<a.eVal.rows();i++)
    {
      uscita *ptr=this;
      while(ptr)
	{
	  fprintf(f," ");;
	  
	  if(ptr->tipo==uLL)  fprintf(f, "%e", a.LL(i));
	  if(ptr->tipo==uENERGIA) fprintf(f,"%30.15e", a.eVal(i));
	  if(ptr->tipo==uSS) fprintf(f, "%e",a.SS(i));
	  if(ptr->tipo==usLL) fprintf(f, "%e", a.srmqdLL(i));
	  if(ptr->tipo==usSS) fprintf(f, "%e", a.srmqdSS(i));
	  
	  if(ptr->tipo==uMz) fprintf(f, "%e", a.mzz(i));
	  if(ptr->tipo==uSz) fprintf(f, "%e", a.szz(i));
	  if(ptr->tipo==uJz) fprintf(f, "%e", a.mzz(i)+a.szz(i));
	  if(ptr->tipo==uJJ) fprintf(f, "%e", a.JJ(i)   );


	  if(ptr->tipo==uSSpar) fprintf(f, "%e", a.SSpar(i,ptr->indice));
	  if(ptr->tipo==uLLpar) fprintf(f, "%e",a.LLpar(i,ptr->indice));
	  if(ptr->tipo==uSLpar) fprintf(f, "%e", a.SLpar(i,ptr->indice));
	  ptr=ptr->next;
	}
      fprintf(f,"\n");
    }
  fclose(f);
};

uscita *uscita::chiedi()
{
  uscita *res;
  char rep[80];
 
  int good=0;
  int gottipo=0,gotindice=0, gotpos=0;
  while(good==0)
    {
      cout << " ENERGIA  LL sLL SS sSS  Mz Sz  Jz JJ   SLpar LLpar SSpar  QUIT\n";
      cin >> rep;
      for(int i=0; i< 13; i++)
	{
	  if(strcmp(rep,risp[i])==0)
	    {
	      gottipo=tiporisp[i];
	      good=1;
	      if(gottipo<0)
		  {
		    cout << " numero guscio????\n";
		    cin >> gotindice ;
		  }
	      gotpos=i;
	      break;
	    }
	}
    }
  if(gottipo==uQUIT)
    {
      return NULL;
    }
  else
    {
      res=new uscita;
      res->indice=gotindice;
      res->tipo=gottipo;
      res->pos=gotpos;
      res->next=chiedi();
    }
  return res;
}
  
  
main(int argc, char **argv)
{
  
  // ******************************************
  asfhfs atomo;
  fichier f;
  f.aprilecture(argv[1]);
  
  atomo.serializza(f);
  cout << " fine lettura \n";
  f.chiudi();
  cout << " chiusura OK\n";
  
  uscita *ptru;
  ptru=uscita::chiedi();
  ptru->stampa(atomo);
  
  
}
  
  
  
   
    
