/****************************************************************************

                     uMatrix C++ Matrix Library

    Copyright (C) 1996  David Weber, Michael Sipe and Rajesh Shenoy

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    David Weber can be contacted at weber@ece.cmu.edu or 
    http://www.ece.cmu.edu/afs/ece/usr/weber/.home-page.html

****************************************************************************/

#include <nMath.h>

#ifdef explicit_instantiations

//template uMatrix<float> sin( const uMatrix<float>& data );

#define InstantiateAll(func)\
template uMatrix<float> func( const uMatrix<float>& data);\
template uMatrix<double> func( const uMatrix<double>& data);\
template uMatrix<fComplex> func( const uMatrix<fComplex>& data);\
template uMatrix<Complex> func( const uMatrix<Complex>& data);

#define InstantiateReal(func)\
template uMatrix<float> func( const uMatrix<float>& data);\
template uMatrix<double> func( const uMatrix<double>& data);\

InstantiateAll(sqrt);
InstantiateAll(log);
InstantiateAll(exp);
InstantiateAll(sin);
InstantiateAll(cos);
InstantiateAll(sinh);
InstantiateAll(cosh);

InstantiateReal(tan);
InstantiateReal(atan);
InstantiateReal(asin);
InstantiateReal(acos);
InstantiateReal(log10);
InstantiateReal(floor);
InstantiateReal(ceil);
InstantiateReal(tanh);

#endif



