"""
    MccdFile.py
    Generic class for mccd files manipulation.    

    Interface:
    ===========================
    class MccdFile:          
        __init__(self,FileName)	
        GetNumImages(self)
        GetData(self)
        #WriteImage (self,Data)

    mccd format assumptions:
    ===========================
    The following details were assumed for this implementation:
    - Each mccd file contains only one image.
    - Data is stored in an one, two or three-dimensional array.
"""


__author__ =  'Anne-Cecile Gendrin'
__date__=  '18/02/03'


import Numeric, threading, time, random, os, os.path, pprint, time
import odm as odm
from utils import TRUE
from Py4datDisplay import Py4datDisplay
from EdfFile import GetRegion


class MccdFile:
	def __init__(self,FileName):
        	""" Constructor
            	FileName:   Name of the file (either existing or to be created)  
        	"""
        	self.FileName=FileName
        	self.File = 0
        
        	try: 
			os.path.isfile(self.FileName)
        	except: raise "MccdFile: Error opening file"
        
        	
	
	def GetNumImages(self):
        	""" Returns number of images of the object : 1 for a Mccd File
        	"""
        	return 1
	
	def GetData(self,Pos=None,Size=None):
        	mar = odm.ODMMarCCDImageA(alloc=TRUE, gfp=self.FileName)
		array=mar.a
		
		self.size=mar.a.shape
		if len(self.size)==1:
			self.NumDim=1
			self.Dim1=self.size[0]
		if len(self.size)==2:
			self.NumDim=2
			self.Dim1=self.size[0]
			self.Dim2=self.size[1]
		if len(self.size)==3:
			self.NumDim=3
			self.Dim1=self.size[0]
			self.Dim2=self.size[1]
			self.Dim3=self.size[2]
		
		if Pos is not None and Size is not None:
			return GetRegion(array,Pos,Size)
		else: return array

#--------------------------------------------------------------------------------
if __name__ == "__main__":   
    import time
    t1=time.time()
    f=MccdFile('../data/main_mac_0001.mccd')
    arr=f.GetData()
    print arr.shape
    t2=time.time()
    print (t2-t1)
    
