"""
    MLabAsciiWrite.py
"""

import os, time, types

__version__='1.0.0'
__date__=  '19/03/03'
__author__ =  'Anne-Cecile Gendrin'
    
DEBUG=1

def MLabAsciiWrite(directory='.', filename=None, data=None):
	"""
	MLabAsciiWrite function allows to write given data in an ascii file.
	Parameters:
	- directory: directory where to find or create the file
	- filename: a given filename. If the file exits, it will be overridden.
	- data: a data to write in the file
	"""
	if DEBUG: print 'Write in Ascii file...'
	filepath=os.path.join(directory,filename)
	file=open(filepath,'w')
	file.write('# MLab Ascii Save'+'\n')
	file.write('# Date:'+ time.asctime() +'\n')
	file.write('###########################################\n')
	if data.has_key('pos'): pos=data['pos']
	else: pos=(0,0)
	if type(data)==types.DictionaryType:
		keys=data.keys()
		keys.sort()
		for key in keys:
			if key=='pos' or key=='size': break
			file.write(str(key)+'\n')
			dic=data[key].GetOutput()
			file.write('   Max Value:'+str(dic['maxValue'])+', x: '+str(int(dic['maxCoordX'])+pos[0])+', y: '+str(int(dic['maxCoordY'])+pos[1])+'\n'+'\n')
	else:	file.write(str(data))
	file.close()
	
