"""
    AsciiParametersDialog.py
    
"""
from qt import *
from PyDVT.Binding import *

__version__=  '1.0.0'
__date__='27/02/2003'
__author__ =  'Anne-Cecile Gendrin'


class AsciiParametersDialog(QMainWindow):
	def __init__(self, parent,initial_parameters):
        	QMainWindow.__init__(self,parent,"Tracking Parameters Editor",0)  

		self.dlg=Dialog(self,"Ascii Save",1,0)
        	box=QVBox( self.dlg )
		self.OneFileFlag=initial_parameters['OneFileFlag']
		self.SeveralFilesFlag=initial_parameters['SeveralFilesFlag']
		self.Display=initial_parameters['Display']
		
        	box1 = QHBox( box )
        	box2 = QHBox( box )
		box3 = QHBox( box )
		
		group=QVButtonGroup(box1)
		group.setFixedWidth(180)
		self.OneFileCheck=QRadioButton(group)
		self.SeveralFilesCheck=QRadioButton(group)
		   
		self.OneFileCheck.setText("Save in one file")
		self.OneFileCheck.setChecked(self.OneFileFlag)
		self.OneFileCheck.setFixedWidth(160)
		self.SeveralFilesCheck.setText("Save in several files")
		self.SeveralFilesCheck.setChecked(self.SeveralFilesFlag)
		self.SeveralFilesCheck.setFixedWidth(160)
		
		self.DisplayCheck=QCheckBox(box2)
		self.DisplayCheck.setText("Display Results")
		self.DisplayCheck.setChecked(self.Display)
		self.DisplayCheck.setFixedWidth(200)
		
        	button=QPushButton(box3)
        	button.setText("OK")
		button.setFixedWidth(80)
		CancelButton=QPushButton(box3)
		CancelButton.setFixedWidth(80)
        	CancelButton.setText("Cancel")
        	
		self.connect(button,SIGNAL("clicked()"),self.dlg.accept)
		self.connect(CancelButton,SIGNAL("clicked()"),self.dlg.reject)
        	box.resize( 200, 130 )
        	if self.dlg.exec_loop():
            		try:
				self.OneFileFlag=self.OneFileCheck.isChecked()
				self.SeveralFilesFlag=self.SeveralFilesCheck.isChecked()
				self.Display=self.DisplayCheck.isChecked()
            		except: pass
		

#####################################################################

if __name__ == "__main__": 
    app = QApplication(sys.argv)
    app.connect(app,SIGNAL('lastWindowClosed()'),app,SLOT('quit()'))
    win=AsciiParametersDialog(None,{'OneFileFlag':1,'SeveralFilesFlag':0,'Display':0})
    app.setMainWidget (win)
    app.exec_loop()

