"""
    DataInfoView.py
    View derived class for data info displaying
"""

from PyDVT import __version__,__date__,__author__

    
from View import *




class DataInfoView(View):
    """
    This view class uses a DrawableTable to display information
    about the Data object.
    The SetSource for this class can be called with:
    - Any Filter/DataSelection object (it's Data is going to be taken)
    - Any Data object 


    Interface:
    ===========================
    View interface
    """
    def __init__(self, parent=None, pars={}, **kw):       
        """
        See View.__init__
        Parameters:
          parent: Parent window
          pars:   Dictionary with View initialization options
                  New options defined by this class (in addiction to base class options):
                    No new option
          kw:     keywords to Container initializatregisterion                
        """
        View.__init__(self, parent, pars, **kw)
        self.CreateMenu()


    def CreateDrawable(self):
        """
        Virtual: Implements creation of  a Drawable object (which implements the
        Drawable interface)
        """        
        self.Drawable= Drawable_Table(self,vertical_header=0)
        self.Drawable.Show()


    def CreateMenu(self):
        """
        Can be overwritten by derived classes to create a
        different popup menu
        """
        pass                
        

    def DataChanged(self,source=None):
        """
        Virtual: See View.DataChanged
        """
        self.Drawable.SetCols(3)
        self.Drawable.SetRows(0)
        
        self.Drawable.SetHHeaderText(0,"Page")
        self.Drawable.SetHHeaderText(1,"Item")
        self.Drawable.SetHHeaderText(2,"Value")
        if self.Source != ():
            #sel=self.Selection[0].GetData()
            if hasattr (self.Source[0],"GetData"):
                data=self.Source[0].GetData()
            else:
                data=self.Source[0]
            row=rows=0

            info=data.GetInfo()
            rows=rows+len(info)
            self.Drawable.SetRows(rows)
            self.Drawable.SetText(row,0, "Header")            
            for key in info.keys():
                if str(key)[0] == "_": continue
                self.Drawable.SetText(row,1, key)
                self.Drawable.SetText(row,2, info[key])
                row=row+1
            self.Drawable.MergeCells(0,0,row,1)
                
            for i in range (data.GetNumberPages()):
                info=data.GetPageInfo(i)

                len_info=0
                for key in info.keys():
                    if str(key)[0] != "_": len_info=len_info+1                    
                rows=rows+len_info
                
                self.Drawable.SetRows(rows)
                self.Drawable.SetText(row,0, i)
                firstrow=row

                keys = info.keys()
                keys.sort()
                for key in keys:    

                
                #for key in info.keys():
                    if str(key)[0] == "_": continue
                    self.Drawable.SetText(row,1, key)
                    self.Drawable.SetText(row,2, info[key])
                    row=row+1
                self.Drawable.MergeCells(firstrow,0,row-firstrow,1)
        else:
            self.Drawable.SetRows(0)
        self.Drawable.AdjustColumn(0)
        self.Drawable.AdjustColumn(1)       

    def Redraw(self):   
        """
        Virtual: See View.Redraw
        """
        pass
        


