import  NumericA
from Numeric import *
from  PyFullerton import *
from Dabax import *
from Minimiser import *
import string
List=list
tf0=Dabax_f0_Table("f0_WaasKirf.dat",)

tf12=Dabax_f1f2_Table("f1f2_Sasaki.dat",)

Ti_a=ScattererFromTable(tf0,tf12,"Ti",DWsigma=DW2sigma(0.0),convention="-iKx",)

Ba_a=ScattererFromTable(tf0,tf12,"Ba",DWsigma=DW2sigma(0.0),convention="-iKx",)

O_a=ScattererFromTable(tf0,tf12,"O",DWsigma=DW2sigma(0.0),convention="-iKx",)

Sr_a=ScattererFromTable(tf0,tf12,"Sr",DWsigma=DW2sigma(0.0),convention="-iKx",)

SrTiO3_Plane=Fuller_PerovskitePlane(Oxygen=O_a,External=Sr_a,Internal=Ti_a,Spacing=3.92,)

BaTiO3_Plane=Fuller_PerovskitePlane(Oxygen=O_a,External=Ba_a,Internal=Ti_a,Spacing=3.975,)

inter1=Free_Strain_Diffusion(TopSpacingsD=[-0.006,-0.003,0.0],BottomSpacingsD=[0.43,0.2,0.0],TopInterdiffusion=[],BottomInterdiffusion=[],)

inter2=Free_Strain_Diffusion(TopSpacingsD=[0.43,0.2],BottomSpacingsD=[-0.006,-0.003],TopInterdiffusion=[],BottomInterdiffusion=[],)

SrTiO3_Layer=Fuller_LayerM_XXI(Plane=SrTiO3_Plane,Nplanes=13.3,SigmaNplanes=0.001,)

BaTiO3_Layer=Fuller_LayerM_XXI(Plane=BaTiO3_Plane,Nplanes=4.1,SigmaNplanes=0.001,)

i1=Fuller_Interface(I_Planes=inter1,)

i2=Fuller_Interface(I_Planes=inter2,)

period=SumThings(SrTiO3_Layer,BaTiO3_Layer,)

scan=ScanReader(energy_col=15996.0,angles_col=[1.,90, 0.01],angle_factor=math.pi/180.0,)

fit=Fuller_ComparisonTheoryExperiment(period,[scan],[1.0],normlist=[1.0],noise=[0.0],M=15,Ds=0,sigmatheta=0.0001,pol="Nothing",CRough=0,)

fit.error()

