import beans
from beans import *
from dabax import *
class BEAN_AtomicProperties(      instruction_base):

  help="I can tell you about %s  \n call function  getProperty with two args: atom name and property name" %( string.join(AtomicPropertiesList()) ) 

  type="AtomicProperties"
  supertype="Optical Tables"

  generatedtype="numeric_f"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Element",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Name of the Element. Dont forget the \" \" around the filename.",
                                  default="pippo"
                                ),
                                self 
                               )
                             )

    plist_=AtomicPropertiesList()
    plist=[]
    for tok in plist_:
      plist.append( '"'+tok+'"'    )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Property",
                                  type         ="notipe", 
                                  additionaloptions=plist,
                                  value="None" ,             
                                  argument_key="None",
				  help="Lot of choices... open the menu... ",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="AtomicProperties"

  
class BEAN_Dabax_f0_Table(      instruction_base):
  help="object  of the class of type  Dabax_f0_Table"
  type="Dabax_f0_Table"
  supertype="Optical Tables"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  additionaloptions=("\"f0_WaasKirf.dat\"",),
                                  value="\"f0_WaasKirf.dat\"" ,             
                                  argument_key="None",
				  help="Name of the file to read.  ",
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Dabax_f0_Table"












class BEAN_Dabax_f1f2_Table(      instruction_base):
  help="object  of the class of type  Dabax_f1f2_Table"
  type="Dabax_f1f2_Table"
  supertype="Optical Tables"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  additionaloptions=("\"f1f2_Henke.dat\"","\"f1f2_Sasaki.dat\"","\"f1f2_Windt.dat\"","\"f1f2_asf_Kissel.dat\""),
                                  value="\"f1f2_Henke.dat\"" ,             
                                  argument_key="None",
				  help="Name of the file to read.  ",
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Dabax_f1f2_Table"






class BEAN_KK_ForPlot(      instruction_base):
  help="Allows to plot KK results"
  type="KK_ForPlot"
  supertype="Fits"

  def __init__(self):

    self.generatedtype="KK_ForPlot"


    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="KK object",
                                  type         ="KK", 
                                  value="None" ,             
                                  argument_key="None",
				  help="KK object",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="minE",
                                  type         ="numeric_f", 
                                  value="None" ,             
                                  argument_key="None",
				  help="starting energy for plotting",
                                  default="None"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="maxE",
                                  type         ="numeric_f", 
                                  value="None" ,             
                                  argument_key="None",
				  help="end energy for plotting",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="n",
                                  type         ="numeric_i", 
                                  value="None" ,             
                                  argument_key="None",
				  help="npoints to plot",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="print partial",
                                  type         ="List",
                                  additionaloptions=("0","1"),
                                  value="None" ,             
                                  argument_key="printpartial",
				  help="if you want to save  results to files choose 1",
                                  default="None"
                                ),
                                self 
                               )
                             )






    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="KK_ForPlot"
    

class BEAN_BetaManipulator_ScanReader(  instruction_base):
  help=  """ given a filename in input it reads the scan.

       If Np is 'automatic' the number of points will be determined
          automatically.
       If it is an integer, that will be. Finally if it is 'first line'
         it will be read from the first line.

       The other entries, if integer, will tell the column to read for
       that property. Otherwise one can specify a float number, and that will be.

       The return of this function is :

           return [res.energies, res.data, Polarisation, res.weight]   

       Polarisation is an object like
            [ (weighta, pola),(weightb, polb)....   ]
       where pol are the columns numbers. An average is done when several columns are specified
  """  
  type      = "Beta_Reader"
  supertype = "Beta Manipulators"
   

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="file_or_object",
                                  type         =["string","Beta_ContributionsFromFile","Beta_ContributionsFromContinuum",
                                                 "Beta_ContributionsFromLorentz","Beta_SumOfContributions" , "Beta_Filter"], 
                                  value="None" ,             
                                  argument_key="None",
				  help="Name of the file to read. Dont forget the \" \" around the filename. Leave it equal to NonDont write anything if you want to sythetize a scan. You can input a beta Object",
                                  default="pippo"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Npoints",
                                  type         ="notipe", 
                                  additionaloptions=["\"first line\"", "\"automatic\""],
                                  value="None" ,             
                                  argument_key="Np",
				  help="Number of points in the scan to read. Either input an integer, or ""first line"" or ""automatic""  ",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Polarisation",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="Polarisation",
				  help=("A List of the form \n"
                                        "[ (weighta, pola),(weightb, polb)....   ] \n"),
                                  default="pippo"
                                ),
                                self 
                               )
                             )


    for name_col in ["energies_col",  "data_col","weight_col"]:
      self.properties_list_fixed.append(
                               property_container(
                                property(property_name=name_col,
                                  type         =("numeric_f","numeric_i"), 
                                  value="None" ,             
                                  argument_key=name_col,
				  help=("An integer to tell the columns number (1,2,3..), or a float to tell a fixed value."+
                                        " if you want to sythetise it write a list like [min,max,stride].\n "+
                                        " Weight col is used when doing fitting. Set it to 1 if you dont need fits.\n "),
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="applyPol",
                                  type         ="notipe", 
                                  additionaloptions=["\"applyPol\"", "\"noApplyPol\""],
                                  value="None" ,             
                                  argument_key="applyPol",
				  help="If an object is given instead of a filename, this variable determines if the polarisation description has to be applied when retrieving the data from the object",
                                  default="None"
                                ),
                                self 
                               )
                             )





    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="BetaManipulator_ScanReader"






class BEAN_BetaManipulator_ContributionsFromFile(  instruction_base):

  help = """
      reads a file containing up to three polarisations.
      Initialised with shift, factor, saturation for 
      dichroism ( they can be variables ).

      It provides the function contributions(energies, pol)


      Rescale X lambda is set to one when one has raw data
      for absorption. In that case beta is proportional to absorption
      time lambda/lambda0 where lambda0 is the
      middle of the scan.

      The first column of filename is the energy 


      def __init__( self, filename, shift, factor, saturation, rescaleXlambda=1 ):  


  """
  type = "Beta_ContributionsFromFile"
  supertype = "Beta Manipulators"


  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Name of the file to read. Dont forget the \" \" around the filename. Leave it equal to NonDont write anything if you want to sythetize a scan",
                                  default="pippo"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="shift",
                                  type         =["numeric_f", "Variable"], 
                                  value="None" ,             
                                  argument_key="shift",
				  help=("Shift the data by this amount in energy ( subtract shift from the energies columns)"),
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="factor",
                                  type         =["numeric_f", "Variable"], 
                                  value="1" ,             
                                  argument_key="factor",
				  help=("Multiply the data by this factor."),
                                  default="1"
                                ),
                                self 
                               )
                             )





    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="rescaleXlambda",
                                  type         =None, 
                                  additionaloptions=("0","1"),
                                  value="1" ,             
                                  argument_key="rescaleXlambda",
				  help=  """    Rescale X lambda is set to one when one has raw data
      for absorption. In that case beta is proportional to absorption
      time lambda/lambda0 where lambda0 is the
      middle of the scan.("Multiply the data by this factor""" ,
                                  default="1"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Three_Files",
                                  type         ="List",
                                  additionaloptions=("0","1"),
                                  value="None" ,             
                                  argument_key="Three_Files",
				  help="",
                                  default="0"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="File2",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="File2",
				  help="Name of the file to read. Dont forget the \" \" around the filename",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="File3",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="File3",
				  help="Name of the file to read. Dont forget the \" \" around the filename",
                                  default="None"
                                ),
                                self 
                               )
                             )




    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="saturation",
                                  type         =["numeric_f", "Variable"], 
                                  value="1.0" ,             
                                  argument_key="saturation",
				  help=("Magnetic saturation."),
                                  default="1"
                                ),
                                self 
                               )
                             )

    

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="BetaManipulator_ContributionsFromFile"





class BEAN_BetaManipulator_ContributionsFromContinuum(  instruction_base):

  help = """
           A function specified by :
              E0
              step
              pente
           it is 0 for E<E0

           step+pente*(E-E0) 


  """

  type = "Beta_ContributionsFromContinuum"
  supertype = "Beta Manipulators"


  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="E0",
                                  type         =["numeric_f", "Variable"], 
                                  value="None" ,             
                                  argument_key="E0",
				  help=("Function is 0 for E<E0 and step+pente*(E-E0)"),
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="step",
                                  type         =["numeric_f", "Variable"], 
                                  value="None" ,             
                                  argument_key="step",
				  help=("Function is 0 for E<E0 and step+pente*(E-E0)"),
                                  default="None"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="pente",
                                  type         =["numeric_f", "Variable"], 
                                  value="0" ,             
                                  argument_key="pente",
				  help=("Function is 0 for E<E0 and step+pente*(E-E0)"),
                                  default="0"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="min",
                                  type         =("numeric_f"), 
                                  value="0" ,             
                                  argument_key="min",
				  help=("left margin of  range"),
                                  default="0"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="max",
                                  type         =("numeric_f"), 
                                  value="0" ,             
                                  argument_key="max",
				  help=("right  margin of the  range"),
                                  default="0"
                                ),
                                self 
                               )
                             )


    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="BetaManipulator_ContributionsFromContinuum"




class BEAN_BetaManipulator_ContributionsFromInterpolation(  instruction_base):

  help = """
           A function specified by :
             - a Beta object for initialisation
             - one or more array of variables like those created by 
                 CreateVariableArray.
           Each variable in the arrays has an energy (X in CreateVariableArray)
           an initial value ( generally 1 ) a min ( generally 1-tol)
           and a max.

           The initialisation process converts 1 to beta(X) etc. etc.
  """

  type = "Beta_ContributionsFromInterpolation"
  supertype = "Beta Manipulators"


  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="betaobject",
                                  type         =["Beta_ContributionsFromFile","Beta_ContributionsFromContinuum","Beta_ContributionsFromLorentz","Beta_SumOfContributions","Beta_ContributionsFromInterpolation" ], 
                                  value="None" ,             
                                  argument_key="None",
				  help=("betaobject"),
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="shift",
                                  type         =["numeric_f", "Variable"], 
                                  value="None" ,             
                                  argument_key="shift",
				  help=("energy shift"),
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="VariableArraysList",
                                  type         ="List", 
                                  value="[]" ,             
                                  argument_key="arrs",
				  help="List of VariableArrays",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="nameForView",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="nameForView",
				  help="""If a filename is set, the interpolation will be written
at each iteration on such file. 
""",
                                  default="None"
                                ),
                                self 
                               )
                             )




    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="BetaManipulator_ContributionsFromInterpolation"




class BEAN_BetaManipulator_ContributionsFromLorentz(  instruction_base):

  help = """
           A function specified by :
              E0
              gammaL
              gammaR
              height
  """

  type = "Beta_ContributionsFromLorentz"
  supertype = "Beta Manipulators"


  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="E0",
                                  type         =["numeric_f", "Variable"], 
                                  value="None" ,             
                                  argument_key="E0",
				  help=("Lorentzian center"),
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="height",
                                  type         =["numeric_f", "Variable"], 
                                  value="None" ,             
                                  argument_key="height",
				  help=("Lorentzian height"),
                                  default="None"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="GammaL",
                                  type         =["numeric_f", "Variable"], 
                                  value="0" ,             
                                  argument_key="gammaL",
				  help=("Lorentzian HWHM , left side"),
                                  default="0"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="GammaR",
                                  type         =["numeric_f", "Variable"], 
                                  value="0" ,             
                                  argument_key="gammaR",
				  help=("Lorentzian HWHM , right side"),
                                  default="0"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="min",
                                  type         =("numeric_f"), 
                                  value="0" ,             
                                  argument_key="min",
				  help=("left margin of the lorentzian range"),
                                  default="0"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="max",
                                  type         =("numeric_f"), 
                                  value="0" ,             
                                  argument_key="max",
				  help=("right  margin of the lorentzian range"),
                                  default="0"
                                ),
                                self 
                               )
                             )




    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="BetaManipulator_ContributionsFromLorentz"







class BEAN_BetaManipulator_BetaJoin(  instruction_base):
  help="""
              joins an absorption spectra
        to tabulated optical index ( imaginary part, beta)
        to obtain   a beta on the wider range given by
        the tabulated values, but having more precised
        data, given by betaobject, in the shorter range given by betaobject
  """
  type      = "Beta_Join"
  supertype = "Beta Manipulators"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="betaobject",
                                  type         =["Beta_ContributionsFromFile","Beta_ContributionsFromContinuum","Beta_ContributionsFromLorentz","Beta_SumOfContributions" ,"Beta_ContributionsFromInterpolation" ], 
                                  value="None" ,             
                                  argument_key="None",
				  help=("betaobject"),
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Material",
                                  type         =["IndexFromTable","IndexFromFile","ComposedIndex"], 
                                  value="None" ,             
                                  argument_key="material",
				  help=("Optical Material from tables ( see function IndexFromTable)\n"
                                        " , The indexes outside the experimental extrema\n"
                                        "are given by the tabulated material\n"),
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="trim_left",
                                  type         =("numeric_f"), 
                                  value="0" ,             
                                  argument_key="trim_left",
				  help=("Reduce the inserted interval on by this extent at the left"),
                                  default="0"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="trim_right",
                                  type         =("numeric_f"), 
                                  value="0" ,             
                                  argument_key="trim_right",
				  help=("Reduce the inserted interval on by this extent at the right"),
                                  default="0"
                                ),
                                self 
                               )
                             )


   
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="BetaManipulator_BetaJoin"
    




class BEAN_BetaManipulator_SumOfContributions(  ListLike_instruction):
  help="""
       just memorizes a series of contribution object
       Provides a contribution function that returns
       the sum of all contributions
  """
  type      = "Beta_SumOfContributions"
  supertype = "Beta Manipulators"

  def __init__(self):
    beans.ListLike_instruction.__init__(self)
    self.associated_variable="None"


    self.groupedproperties=[
      ["Contribution",["Beta_ContributionsFromFile",
                       "Beta_ContributionsFromContinuum",
                       "Beta_ContributionsFromLorentz",
                       ], [], "Contribution, " ],
      ]

    self.variable_is_active=1
    self.properties_list=[]	
    self.option=0
    self.option_dic={}
    for i in range(10):
       self.option_dic[i]= "%s contributions"%i
    self.constructor="BetaManipulator_SumOfContributions"





class BEAN_BetaManipulator_Comparison(      instruction_base):
  help=""" 
       this object is aware of a stack model and of a set of experimental data,
      (eventually void data, where just the scan are specified).
       
  """
  type="Beta_Comparison"
  supertype="Fits"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="Beta_Comparison"
   
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Beta model",
                                  type         =["Beta_ContributionsFromFile","Beta_ContributionsFromContinuum","Beta_ContributionsFromlorentz",
                                            "Beta_SumOfContributions", "Beta_Join"], 
                                  value="None" ,             
                                  argument_key="None",
				  help="Beta model",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of scans",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="None",
				  help="List of scans",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of weights",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="None",
				  help="List of weight",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="List of norms",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="normlist",
				  help="List of norms",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="print partial",
                                  type         ="List",
                                  additionaloptions=("0","1"),
                                  value="None" ,             
                                  argument_key="printpartial",
				  help="if you want to save partial resulta to files choose 1",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="BetaManipulator_Comparison"
    










class BEAN_BetaManipulator_BetaFilter(      instruction_base):
  help=""" 
        Allows to access multicolumn beta object ( polarisation dependent )
        with a pre-selected polarisation       
  """

  type="Beta_Filter"
  supertype="Beta Manipulators"

  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.generatedtype="Beta_Filter"

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Beta to filter  ",
                                  type         =["Beta_ContributionsFromFile","Beta_ContributionsFromContinuum","Beta_ContributionsFromlorentz",
                                            "Beta_SumOfContributions", "Beta_Join"], 
                                  value="None" ,             
                                  argument_key="None",
				  help="Beta model",
                                  default="None"
                                ),
                                self 
                               )
                             )
   

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Polarisation",
                                  type         ="List",
                                  additionaloptions=("0","1","3"),
                                  value="None" ,             
                                  argument_key="Polarisation",
				  help="1 2 or three",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="BetaManipulator_BetaFilter"
    









class BEAN_KK(      instruction_base):
  help="""object  of the class of type  KK.    
     CLASS:

      it returns index(wavelenghts) as the result of a KK
      transformation.
  
      *** def __init__(self, nomefile_or_betaObject=None, material=None,
                   E1=None, E2=None, N=None,
                    e1=None, e2=None, 
                    Fact=None, Dx=None, maglia=None, Nmaglia=10):

      --- nomefil_or_betaObjecte may also be a Beta Manipulator object

      --- material is an object like res returned by IndexFromTable :

         res.DabaxList = DabaxList
         res.DensityList = DensityList
         res.MassList= MassList

      --- E1 E2 are the extrema between which the KK has to be done.
          A file containing N energy points and their beta is generated
          from material object
          and given in input to the kk program

      --- e1 e2 specify an interval contained into E1,E2.
          Doing the KK transforms, beta value inside e1,e2
          are read from file named nomefile.

      --- Fact is a factor multiplying the betas read from nomefile.
  """
  type="KK"
  supertype="Optical Tables"

  def __init__(self):
    self.generatedtype="KK"
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="filename_or_betaObject",
                                  type         =["string","Beta_ContributionsFromFile","Beta_Join",
                       "Beta_ContributionsFromContinuum", "Beta_ContributionsFromLorentz",	"Beta_SumOfContributions" ,"Beta_ContributionsFromInterpolation" ], 
                                  value="\"something.dat\"" ,             
                                  argument_key="filename_or_betaObject",
				  help=("If a filename is passed:\n"
                                        "This file must contain two columns\n  "
                                        " First column is the energy(eV), second\n"
                                        " columns is beta \n"
                                        " I an object is passed \n"
                                        " the beta are obtained by the contribution\n"
                                        " method of the object\n"
                                        ),
                                  default="pippo"
                                ),
                                self 
                               )
                             )
    
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Material",
                                  type         =["IndexFromTable","IndexFromFile","ComposedIndex"], 
                                  value="None" ,             
                                  argument_key="material",
				  help=("Optical Material from tables ( see function IndexFromTable)\n"
                                        " , The indexes outside the experimental extrema\n"
                                        "are given by the tabulated material\n"),
                                  default="None"
                                ),
                                self 
                               )
                             )

  
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="E1",
                                  type         ="numeric_f", 
                                  value="None" ,             
                                  argument_key="E1",
				  help="starting energy for KK transformation",
                                  default="None"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="E2",
                                  type         ="numeric_f", 
                                  value="None" ,             
                                  argument_key="E2",
				  help="starting energy for KK transformation",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="N",
                                  type         ="numeric_i", 
                                  value="None" ,             
                                  argument_key="N",
				  help="N of point for the integration grid external to the experimental interval",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="e1",
                                  type         ="numeric_f", 
                                  value="None" ,             
                                  argument_key="e1",
				  help="Between e1 and e2, experimental betas are used \n"
                                       "( and joined to the tabulated ones)",
                                  default="None"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="e2",
                                  type         ="numeric_f", 
                                  value="None" ,             
                                  argument_key="e2",
				  help="Between e1 and e2, experimental betas are used \n"
                                       "( and joined to the tabulated ones)",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Fact",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="Fact",
				  help="The experimental Beta is multilied by fact and Joined to the  \n"
                                       "Tables",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Dx",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="Dx",
				  help="Experimental beta is shifted By Dx",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="maglia",
                                  type         ="List", 
                                  value="None" ,             
                                  argument_key="maglia",
				  help="List interpolation points",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Nmaglia",
                                  type         ="numeric_i", 
                                  value="10" ,   
                                  argument_key="Nmaglia",
				  help="N of points for the integration grid between interpolation points (if given)",
                                  default="None"
                                ),
                                self 
                               )
                             )


    self.properties_list={}
    self.properties_list[1]=[]	

    self.option=1

    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="KK"




class BEAN_IndexFromTable(  ListLike_instruction):
  help="Create an optical  material from tables"
  type="IndexFromTable"
  supertype="Create an optical  material from tables"


  def __init__(self):
    beans.ListLike_instruction.__init__(self)
    self.associated_variable="None"

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Table F0",
                                  type         ="Dabax_f0_Table", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Table to use for f0 ",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Table F1F2",
                                  type         ="Dabax_f1f2_Table", 
                                  value="None" ,             
                                  argument_key="None",
				  help="Table to use for f12 ",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.groupedproperties=[
      ["Name of the element","string", [], "Name of the element. Remeber the \"'s around the name" ],
      ["Density",["numeric_f","Variable"],[],"Density"  ]
      ]

##     self.properties_list_fixed.append(
##                                property_container(
##                                 property(property_name="Name of the element",
##                                   type         ="string", 
##                                   value="None" ,             
##                                   argument_key="None",
## 				  help="Name of the element",
##                                   default="None"
##                                 ),
##                                 self 
##                                )
##                              )

##     self.properties_list_fixed.append(
##                                property_container(
##                                 property(property_name="Density",
##                                   type         =["numeric_f","Variable"], 
##                                   value="None" ,             
##                                   argument_key="None",
## 				  help="Density",
##                                   default="None"
##                                 ),
##                                 self 
##                                )
##                              )




    self.variable_is_active=1
    self.properties_list=[]	
    self.option=0
    self.option_dic={}
    for i in range(10):
       self.option_dic[i]= "%s elements"%i
    self.constructor="IndexFromTable"


class BEAN_IndexFromFile(  instruction_base ):
  help="""Reads index data from one file. It has the method index(self, wavelenghts)"""
  type="IndexFromFile"
  supertype="Create an optical  material from tables"


  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="NameFile",
                                  type         ="string", 
                                  value="None" ,             
                                  argument_key="NameFile",
				  help=("Name of a file containing three colums: energy(eV), Real(n), Imag(n)."
                                       "it gives the index n as function of energy for positive elicity"),
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="RelativeDensity",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="RelativeDensity",
				  help=("A factor to rescale 1-n"),
                                  default="1.0"
                                ),
                                self 
                               )
                             )



    self.variable_is_active=1
    self.properties_list={}
    self.properties_list[1]=[]	
    self.option=1
    self.constructor={}
    self.constructor[1]="IndexFromFile"




class BEAN_IndexFromObject(  instruction_base ):
  help=""" filters an index object  adding a multiplicative
        factor for the density. Handy to filter object like KK 
        It has the method index(self, wavelenghts)
    """  

  type="IndexFromObject"
  supertype="Create an optical  material from an index object"


  def __init__(self):
    beans.instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Object",
                                  type         =["KK"], 
                                  value="None" ,             
                                  argument_key="Object",
				  help=("Index Object"),
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="RelativeDensity",
                                  type         =["numeric_f","Variable"], 
                                  value="None" ,             
                                  argument_key="RelativeDensity",
				  help=("A factor to rescale 1-n"),
                                  default="1.0"
                                ),
                                self 
                               )
                             )



    self.variable_is_active=1
    self.properties_list={}
    self.properties_list[1]=[]	
    self.option=1
    self.constructor={}
    self.constructor[1]="IndexFromObject"




class BEAN_ComposedIndex(  ListLike_instruction):
  help="Create an optical  material mixing magnetic materials with other magnetic or scalar ones"
  type="ComposedIndex"
  supertype="Create an optical  material from tables"


  def __init__(self):
    beans.ListLike_instruction.__init__(self)
    self.associated_variable="None"


    self.groupedproperties=[
      ["Material",["KK","IndexFromTable", "IndexFromFile"], [], "material, " ],
      ]

    self.variable_is_active=1
    self.properties_list=[]	
    self.option=0
    self.option_dic={}
    for i in range(10):
       self.option_dic[i]= "%s elements"%i
    self.constructor="ComposedIndex"


