/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.utils.SingleGlobalResourceSet;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xtend.typesystem.emf.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.edna.datamodel.DatamodelInjector;
import org.edna.datamodel.datamodel.ComplexType;
import org.edna.datamodel.datamodel.DatamodelPackage;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExtensions {
    @Inject
    private IResourceDescriptions index;
    private static final Log LOG = LogFactory.getLog(JavaExtensions.class);

    public JavaExtensions() {
        ((Injector)DatamodelInjector.injector.get()).injectMembers((Object)this);
    }

    public static void setQNamePrefix(XSDSchema schema, String prefix, String namespace) {
        schema.getQNamePrefixToNamespaceMap().put(prefix, namespace);
    }

    public static XSDSimpleTypeDefinition resolvePrimitiveTypeDefinition(XSDSchema schema, String typeName) {
        return schema.getSchemaForSchema().resolveSimpleTypeDefinition(typeName);
    }

    public static List<EObject> toList(List<EObject> col) {
        if (col instanceof Iterator) {
            ArrayList<EObject> result = new ArrayList<EObject>();
            Iterator it = (Iterator)((Object)col);
            while (it.hasNext()) {
                result.add((EObject)it.next());
            }
            return result;
        }
        return col;
    }

    public static XSDAnnotation createDocumentation(XSDElementDeclaration elementDeclaration, org.eclipse.uml2.uml.Element umlElement) {
        String text = JavaExtensions.getDocumentationText(umlElement);
        return JavaExtensions.createDocumentation(elementDeclaration, text);
    }

    public static XSDAnnotation createDocumentation(XSDElementDeclaration elementDeclaration, String documentation) {
        if (documentation != null) {
            XSDAnnotation annotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            elementDeclaration.setAnnotation(annotation);
            Element docElement = annotation.createUserInformation(null);
            annotation.getElement().appendChild(docElement);
            docElement.appendChild(docElement.getOwnerDocument().createTextNode(documentation));
            return annotation;
        }
        return null;
    }

    public static XSDAnnotation createAppInfo(XSDElementDeclaration elementDeclaration, String appInfo) {
        if (appInfo != null) {
            XSDAnnotation annotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            elementDeclaration.setAnnotation(annotation);
            Element element = annotation.createApplicationInformation("http://www.edna-site.org/dsl2xsd");
            annotation.getElement().appendChild(element);
            element.appendChild(element.getOwnerDocument().createTextNode(appInfo));
            return annotation;
        }
        return null;
    }

    public static String getDocumentationText(XSDAnnotation annotation) {
        Element docElement = (Element)annotation.getUserInformation().get(0);
        String doc = docElement.getTextContent();
        return doc;
    }

    public static String getDocumentationText(org.eclipse.uml2.uml.Element umlElement) {
        if (!umlElement.getOwnedComments().isEmpty()) {
            return ((Comment)umlElement.getOwnedComments().get(0)).getBody();
        }
        EAnnotation topcasedDocAnnotation = umlElement.getEAnnotation("http://www.topcased.org/documentation");
        if (topcasedDocAnnotation != null) {
            return (String)topcasedDocAnnotation.getDetails().get((Object)"documentation");
        }
        for (EObject obj : EcoreUtil2.findAllByType((Iterator)umlElement.getModel().eAllContents(), Comment.class)) {
            Comment c = (Comment)obj;
            for (EObject annotatedObject : c.getAnnotatedElements()) {
                if (annotatedObject != umlElement) continue;
                return c.getBody();
            }
        }
        return null;
    }

    public static XSDInclude createInclude(Resource referringResource, Resource res) {
        XSDInclude result = XSDFactory.eINSTANCE.createXSDInclude();
        String path = res.getURI().lastSegment().replace(".uml", ".xsd");
        result.setSchemaLocation(path);
        return result;
    }

    public static List<XSDSchema> allSchemas(XSDSchema s, List<String> includeUri) {
        HashSet result = Sets.newHashSet();
        result.add(s);
        for (XSDInclude inc : Iterables.filter((Iterable)s.getContents(), XSDInclude.class)) {
            XSDSchema resolved = inc.getResolvedSchema();
            if (resolved == null) {
                resolved = JavaExtensions.resolve(inc, includeUri);
            }
            result.addAll(JavaExtensions.allSchemas(resolved, includeUri));
        }
        return Lists.newArrayList((Iterable)result);
    }

    private static XSDSchema resolve(XSDInclude include, List<String> includeUri) {
        for (String baseUri : includeUri) {
            Resource r = include.eResource().getResourceSet().createResource(URI.createURI((String)include.getSchemaLocation()).resolve(URI.createURI((String)baseUri)));
            try {
                r.load(null);
            }
            catch (IOException iOException) {
                continue;
            }
            return (XSDSchema)r.getContents().get(0);
        }
        return null;
    }

    public static void registerResource(Resource res) {
        if (res != null) {
            LOG.debug((Object)("Adding " + res.getURI() + " to resource set"));
            SingleGlobalResourceSet.get().getResources().add((Object)res);
        }
    }

    public static List<PrimitiveType> getXsdPrimitiveTypes() {
        ResourceSet rs = SingleGlobalResourceSet.get();
        Resource primitiveTypesLibrary = null;
        try {
            primitiveTypesLibrary = rs.getResource(URI.createURI((String)"platform:/resource/edna/kernel/datamodel/XSDPrimitiveTypes.uml"), true);
        }
        catch (Exception exception) {
            primitiveTypesLibrary = rs.getResource(URI.createURI((String)"platform:/resource/kernel/datamodel/XSDPrimitiveTypes.uml"), true);
        }
        ArrayList result = Lists.newArrayList();
        Model m = (Model)primitiveTypesLibrary.getContents().get(0);
        for (EObject p : EcoreUtil2.findAllByType((Iterator)m.eAllContents(), PrimitiveType.class)) {
            result.add((PrimitiveType)p);
        }
        return result;
    }

    public static void resolveAll(Resource resource) {
        EcoreUtil.resolveAll((ResourceSet)resource.getResourceSet());
    }

    public static void attachToDummyResource(EObject model) {
        URI uri = URI.createURI((String)"platform:/resource/dummy.xmi");
        Resource r = SingleGlobalResourceSet.get().createResource(uri);
        r.getContents().add((Object)model);
    }

    public List<ComplexType> getComplexTypes() {
        ArrayList types = Lists.newArrayList();
        for (IResourceDescription resourceDescription : this.index.getAllResourceDescriptions()) {
            for (IEObjectDescription objDesc : resourceDescription.getExportedObjects(DatamodelPackage.eINSTANCE.getComplexType())) {
                types.add((ComplexType)objDesc.getEObjectOrProxy());
            }
        }
        return types;
    }
}

