/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.workflow;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.edna.datamodel.transformations.m2m.AbstractDatamodelTransformation;

public class TransformationComponent
extends AbstractWorkflowComponent2 {
    private AbstractDatamodelTransformation transformation;
    private boolean serializeTransformedModel = true;
    private String outputSlot;

    public void setTransformation(AbstractDatamodelTransformation transformation) {
        this.transformation = transformation;
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        try {
            if (ctx.get("resourceSet") != null) {
                ResourceSet rs = (ResourceSet)ctx.get("resourceSet");
                for (Resource r : rs.getResources()) {
                    this.transformation.getResourceSet().getResource(r.getURI(), true);
                }
            }
            this.transformation.setMonitor(monitor);
            Resource sourceModel = this.transformation.loadSourceModel();
            this.transformation.apply(sourceModel.getContents().get(0));
            if (this.serializeTransformedModel) {
                this.transformation.writeTargetResource();
            }
            if (this.outputSlot != null) {
                ctx.set(this.outputSlot, this.transformation.getTargetModel());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            issues.addError((WorkflowComponent)this, e.getMessage());
        }
    }

    public void setSerializeTransformedModel(boolean serializeTransformedModel) {
        this.serializeTransformedModel = serializeTransformedModel;
    }

    public void setOutputSlot(String outputSlot) {
        if (!"".equals(outputSlot)) {
            this.outputSlot = outputSlot;
        }
    }
}

