/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.transformations.m2m;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.edna.datamodel.datamodel.ComplexType;
import org.edna.datamodel.datamodel.ElementDeclaration;
import org.edna.datamodel.datamodel.Model;
import org.edna.datamodel.datamodel.Package;
import org.edna.datamodel.datamodel.util.DatamodelSwitch;
import org.edna.datamodel.transformations.m2m.AbstractDatamodelTransformation;
import org.edna.datamodel.transformations.m2m.Comparators;
import org.edna.datamodel.transformations.m2m.EmfCreateFunction;
import org.edna.datamodel.transformations.util.JavaExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dsl2XsdTransformation
extends AbstractDatamodelTransformation<Model, XSDSchema> {
    private IQualifiedNameProvider nameProvider = new DefaultDeclarativeQualifiedNameProvider();
    private EmfCreateFunction<ComplexType, XSDComplexTypeDefinition> createXSDComplexTypeDefinition = new EmfCreateFunction<ComplexType, XSDComplexTypeDefinition>(XSDPackage.eINSTANCE.getXSDComplexTypeDefinition()){

        @Override
        public XSDComplexTypeDefinition configure(ComplexType source, XSDComplexTypeDefinition target) {
            target.setName(source.getName());
            if (source.getBaseType() != null) {
                XSDTypeDefinition baseType = (XSDTypeDefinition)Dsl2XsdTransformation.this.createXSDComplexTypeDefinition.apply(source.getBaseType());
                target.setBaseTypeDefinition(baseType);
                target.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
            }
            XSDParticle complexTypeContent = XSDFactory.eINSTANCE.createXSDParticle();
            target.setContent((XSDComplexTypeContent)complexTypeContent);
            XSDModelGroup sequenceForAttributes = XSDFactory.eINSTANCE.createXSDModelGroup();
            complexTypeContent.setContent((XSDParticleContent)sequenceForAttributes);
            sequenceForAttributes.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            for (ElementDeclaration p : source.getElements()) {
                XSDParticle particle = (XSDParticle)Dsl2XsdTransformation.this.createXSDParticle.apply(p);
                sequenceForAttributes.getContents().add((Object)particle);
            }
            return target;
        }
    };
    private EmfCreateFunction<ElementDeclaration, XSDParticle> createXSDParticle = new EmfCreateFunction<ElementDeclaration, XSDParticle>(XSDPackage.eINSTANCE.getXSDParticle()){

        @Override
        public XSDParticle configure(ElementDeclaration source, XSDParticle target) {
            target.setMaxOccurs(source.isMultiple() ? -1 : 1);
            target.setMinOccurs(source.isOptional() ? 0 : 1);
            XSDElementDeclaration content = (XSDElementDeclaration)Dsl2XsdTransformation.this.createXSDElementDeclarationFromElementDeclaration.apply(source);
            target.setContent((XSDParticleContent)content);
            return target;
        }
    };
    private EmfCreateFunction<ComplexType, XSDElementDeclaration> createXSDElementCreationFromComplexType = new EmfCreateFunction<ComplexType, XSDElementDeclaration>(XSDPackage.eINSTANCE.getXSDElementDeclaration()){

        @Override
        public XSDElementDeclaration configure(ComplexType from, XSDElementDeclaration target) {
            target.setName(from.getName());
            target.setTypeDefinition((XSDTypeDefinition)Dsl2XsdTransformation.this.createXSDComplexTypeDefinition.apply(from));
            return target;
        }
    };
    private EmfCreateFunction<ElementDeclaration, XSDElementDeclaration> createXSDElementDeclarationFromElementDeclaration = new EmfCreateFunction<ElementDeclaration, XSDElementDeclaration>(XSDPackage.eINSTANCE.getXSDElementDeclaration()){

        @Override
        public XSDElementDeclaration configure(ElementDeclaration from, XSDElementDeclaration target) {
            target.setName(from.getName());
            if (from.getRef() != null) {
                XSDTypeDefinition typedef = (XSDTypeDefinition)Dsl2XsdTransformation.this.createXSDComplexTypeDefinition.apply(from.getRef());
                target.setTypeDefinition(typedef);
            } else {
                XSDSimpleTypeDefinition typedef = JavaExtensions.resolvePrimitiveTypeDefinition((XSDSchema)Dsl2XsdTransformation.this.targetModel, from.getType().getName());
                target.setTypeDefinition((XSDTypeDefinition)typedef);
            }
            return target;
        }
    };

    @Override
    public XSDSchema transform(Model sourceModel) {
        this.sourceModel = sourceModel;
        this.targetModel = XSDFactory.eINSTANCE.createXSDSchema();
        ((XSDSchema)this.targetModel).getQNamePrefixToNamespaceMap().put(null, this.nsUri);
        ((XSDSchema)this.targetModel).getQNamePrefixToNamespaceMap().put("xs", "http://www.w3.org/2001/XMLSchema");
        ((XSDSchema)this.targetModel).setSchemaForSchemaQNamePrefix("xs");
        ((XSDSchema)this.targetModel).setTargetNamespace(this.nsUri);
        EcoreUtil.resolveAll((Resource)sourceModel.eResource());
        this.createIncludes();
        new DatamodelSwitch<Object>(){

            public Object caseModel(Model object) {
                ArrayList content = Lists.newArrayList((Iterable)object.eContents());
                Collections.sort(content, Comparators.nameResolverComparator);
                for (EObject obj : content) {
                    this.doSwitch(obj);
                }
                return Dsl2XsdTransformation.this.targetModel;
            }

            public EObject casePackage(Package object) {
                ArrayList content = Lists.newArrayList((Iterable)object.eContents());
                Collections.sort(content, Comparators.nameResolverComparator);
                for (EObject obj : content) {
                    this.doSwitch(obj);
                }
                return (EObject)Dsl2XsdTransformation.this.targetModel;
            }

            public EObject caseComplexType(ComplexType object) {
                if (Dsl2XsdTransformation.this.monitor.isCanceled()) {
                    return null;
                }
                Dsl2XsdTransformation.this.monitor.subTask(object.getName());
                XSDElementDeclaration clsElement = (XSDElementDeclaration)Dsl2XsdTransformation.this.createXSDElementCreationFromComplexType.apply(object);
                ((XSDSchema)Dsl2XsdTransformation.this.targetModel).getContents().add((Object)clsElement);
                ((XSDSchema)Dsl2XsdTransformation.this.targetModel).getContents().add((Object)((XSDSchemaContent)Dsl2XsdTransformation.this.createXSDComplexTypeDefinition.apply(object)));
                Dsl2XsdTransformation.this.monitor.worked(1);
                return (EObject)Dsl2XsdTransformation.this.targetModel;
            }
        }.doSwitch((EObject)sourceModel);
        this.transformDocumentation(sourceModel);
        this.addTransformationTrace(sourceModel);
        return (XSDSchema)this.targetModel;
    }

    private void addTransformationTrace(Model sourceModel) {
        new DatamodelSwitch<Object>(){

            public Object caseModel(Model object) {
                for (EObject obj : object.eContents()) {
                    this.doSwitch(obj);
                }
                return Dsl2XsdTransformation.this.targetModel;
            }

            public EObject casePackage(Package object) {
                for (EObject obj : object.eContents()) {
                    this.doSwitch(obj);
                }
                return (EObject)Dsl2XsdTransformation.this.targetModel;
            }

            public EObject caseComplexType(ComplexType object) {
                if (object.getDoc() != null) {
                    XSDElementDeclaration xsdElement = (XSDElementDeclaration)Dsl2XsdTransformation.this.createXSDElementCreationFromComplexType.apply(object);
                    JavaExtensions.createAppInfo(xsdElement, Dsl2XsdTransformation.this.nameProvider.getQualifiedName((EObject)object));
                }
                return (EObject)Dsl2XsdTransformation.this.targetModel;
            }
        }.doSwitch((EObject)sourceModel);
        this.monitor.worked(1);
    }

    protected void transformDocumentation(Model sourceModel) {
        new DatamodelSwitch<Object>(){

            public Object caseModel(Model object) {
                for (EObject obj : object.eContents()) {
                    this.doSwitch(obj);
                }
                return Dsl2XsdTransformation.this.targetModel;
            }

            public EObject caseComplexType(ComplexType object) {
                if (object.getDoc() != null) {
                    XSDElementDeclaration xsdElement = (XSDElementDeclaration)Dsl2XsdTransformation.this.createXSDElementCreationFromComplexType.apply(object);
                    JavaExtensions.createDocumentation(xsdElement, object.getDoc());
                }
                for (ElementDeclaration element : object.getElements()) {
                    if (element.getDoc() == null) continue;
                    XSDElementDeclaration xsdElement = (XSDElementDeclaration)Dsl2XsdTransformation.this.createXSDElementDeclarationFromElementDeclaration.apply(element);
                    JavaExtensions.createDocumentation(xsdElement, element.getDoc());
                }
                return (EObject)Dsl2XsdTransformation.this.targetModel;
            }

            public EObject casePackage(Package object) {
                for (EObject obj : object.eContents()) {
                    this.doSwitch(obj);
                }
                return (EObject)Dsl2XsdTransformation.this.targetModel;
            }
        }.doSwitch((EObject)sourceModel);
        this.monitor.worked(1);
    }

    private void createIncludes() {
        final Resource sourceResource = ((Model)this.sourceModel).eResource();
        Iterable resources = Iterables.filter((Iterable)sourceResource.getResourceSet().getResources(), (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return !input.getURI().lastSegment().equals(sourceResource.getURI().lastSegment()) && input.getURI().lastSegment().endsWith("edml");
            }
        });
        for (Resource r : resources) {
            XSDInclude include = XSDFactory.eINSTANCE.createXSDInclude();
            String path = r.getURI().lastSegment().replace(".edml", ".xsd");
            include.setSchemaLocation(path);
            ((XSDSchema)this.targetModel).getContents().add((Object)include);
        }
    }

    @Override
    protected int getAmountOfWork(Model sourceModel) {
        int numberOfClasses = EcoreUtil2.eAllOfType((EObject)sourceModel, ComplexType.class).size();
        return numberOfClasses + 2;
    }
}

