/*
 * Decompiled with CFR 0.152.
 */
package org.edna.datamodel.datamodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PrimitiveType implements Enumerator
{
    UNDEFINED(0, "undefined", "undefined"),
    STRING(1, "string", "string"),
    INTEGER(2, "integer", "integer"),
    BOOLEAN(3, "boolean", "boolean"),
    FLOAT(4, "float", "float"),
    DOUBLE(5, "double", "double");

    public static final int UNDEFINED_VALUE = 0;
    public static final int STRING_VALUE = 1;
    public static final int INTEGER_VALUE = 2;
    public static final int BOOLEAN_VALUE = 3;
    public static final int FLOAT_VALUE = 4;
    public static final int DOUBLE_VALUE = 5;
    private static final PrimitiveType[] VALUES_ARRAY;
    public static final List<PrimitiveType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveType[]{UNDEFINED, STRING, INTEGER, BOOLEAN, FLOAT, DOUBLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveType get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return INTEGER;
            }
            case 3: {
                return BOOLEAN;
            }
            case 4: {
                return FLOAT;
            }
            case 5: {
                return DOUBLE;
            }
        }
        return null;
    }

    private PrimitiveType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

