lexer grammar InternalDatamodel;
@header {
package org.edna.datamodel.ui.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer;
}

T11 : 'undefined' ;
T12 : 'string' ;
T13 : 'integer' ;
T14 : 'boolean' ;
T15 : 'float' ;
T16 : 'double' ;
T17 : 'targetNamespace' ;
T18 : 'import' ;
T19 : 'package' ;
T20 : '{' ;
T21 : '}' ;
T22 : 'complex' ;
T23 : 'type' ;
T24 : 'extends' ;
T25 : ':' ;
T26 : '.' ;
T27 : '.*' ;
T28 : '[]' ;
T29 : 'optional' ;

// $ANTLR src "../org.edna.datamodel.language.ui/src-gen/org/edna/datamodel/ui/contentassist/antlr/internal/InternalDatamodel.g" 1762
RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

// $ANTLR src "../org.edna.datamodel.language.ui/src-gen/org/edna/datamodel/ui/contentassist/antlr/internal/InternalDatamodel.g" 1764
RULE_INT : ('0'..'9')+;

// $ANTLR src "../org.edna.datamodel.language.ui/src-gen/org/edna/datamodel/ui/contentassist/antlr/internal/InternalDatamodel.g" 1766
RULE_STRING : ('"' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'"')))* '"'|'\'' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'\'')))* '\'');

// $ANTLR src "../org.edna.datamodel.language.ui/src-gen/org/edna/datamodel/ui/contentassist/antlr/internal/InternalDatamodel.g" 1768
RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

// $ANTLR src "../org.edna.datamodel.language.ui/src-gen/org/edna/datamodel/ui/contentassist/antlr/internal/InternalDatamodel.g" 1770
RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

// $ANTLR src "../org.edna.datamodel.language.ui/src-gen/org/edna/datamodel/ui/contentassist/antlr/internal/InternalDatamodel.g" 1772
RULE_WS : (' '|'\t'|'\r'|'\n')+;

// $ANTLR src "../org.edna.datamodel.language.ui/src-gen/org/edna/datamodel/ui/contentassist/antlr/internal/InternalDatamodel.g" 1774
RULE_ANY_OTHER : .;


