/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf.java;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.xtend.expression.TypeNameUtil;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.type.impl.java.JavaMetaModel;
import org.eclipse.xtend.type.impl.java.JavaTypeStrategy;
import org.eclipse.xtend.type.impl.java.TypeFinder;
import org.eclipse.xtend.type.impl.java.beans.JavaBeansStrategy;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.emf.java.EMFJavaTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFJavaMetaModel
extends JavaMetaModel
implements MetaModel,
TypeFinder {
    private JavaTypeStrategy _strategy;
    private final Cache<Class<?>, Type> cache = new Cache<Class<? extends Object>, Type>(){

        protected Type createNew(Class<?> clazz) {
            TypeSystem typeSystem = EMFJavaMetaModel.this.getTypeSystem();
            EMFJavaTypeImpl impl = new EMFJavaTypeImpl(EMFJavaMetaModel.this, clazz, TypeNameUtil.getName(clazz), EMFJavaMetaModel.this._strategy);
            if (List.class.isAssignableFrom(clazz)) {
                return typeSystem.getListType(typeSystem.getObjectType());
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return typeSystem.getSetType(typeSystem.getObjectType());
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return typeSystem.getCollectionType(typeSystem.getObjectType());
            }
            return impl;
        }
    };
    private final Cache<String, EPackage> packageCache = new Cache<String, EPackage>(){

        protected EPackage createNew(String packageName) {
            for (Object registryEntry : EPackage.Registry.INSTANCE.values()) {
                EPackage pck = null;
                if (!(registryEntry instanceof EPackage)) continue;
                pck = (EPackage)registryEntry;
                if (packageName.equals(pck.getClass().getPackage().getName())) {
                    return pck;
                }
                Class<?>[] classArray = pck.getClass().getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> itf = classArray[n2];
                    if (packageName.equals(itf.getPackage().getName())) {
                        return pck;
                    }
                    ++n2;
                }
            }
            return null;
        }
    };

    public EMFJavaMetaModel() {
        this("EMFJavaMetaModel", (JavaTypeStrategy)new JavaBeansStrategy());
    }

    public EMFJavaMetaModel(String name, JavaTypeStrategy strategy) {
        super(name, strategy);
        this._strategy = strategy;
    }

    public Type getTypeForClass(Class<?> clazz) {
        return (Type)this.cache.get(clazz);
    }

    public Set<Type> getKnownTypes() {
        Collection col = this.cache.getValues();
        return (Set)(col instanceof Set ? col : new HashSet(col));
    }

    protected EClass getEClassForType(Class<?> clazz) {
        EPackage pck;
        EPackage ePackage = pck = clazz.getPackage() != null ? (EPackage)this.packageCache.get((Object)clazz.getPackage().getName()) : null;
        if (pck != null) {
            for (EClassifier clz : pck.getEClassifiers()) {
                if (!(clz instanceof EClass)) continue;
                if (clazz.isInterface()) {
                    if (!clazz.equals(clz.getInstanceClass())) continue;
                    return (EClass)clz;
                }
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> itf = classArray[n2];
                    if (itf.equals(clz.getInstanceClass())) {
                        return (EClass)clz;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }
}

