! FDMNES subroutines

! Calculation of the cartesian tensors

      subroutine tenseur_car(Atom_comp,green,hubb,
     &            i_self,ie,lmoins1,lplus1,m_hubb,mpinodes,mpirank,
     &            n_atom_0_self,n_atom_ind_self,
     &            nbseuil,nlmam,nself,nspin,nspinr,numat,rof,rot,
     &            rot_atom_abs,secdd,secdo,secdq,secmd,secmm,secqq,
     &            singul,solsing,solsing_only,spinorbite,taull) 

      use declarations  
      implicit real(kind=db) (a-h,o-z)

      parameter( lomax = 3, lmomax = ( lomax + 1 )**2 )

      complex(kind=db), dimension(nspin):: Ten, Tens
      complex(kind=db), dimension(nspinr):: Te, Tens_sr
      complex(kind=db), dimension(3,3) :: mat2
      complex(kind=db), dimension(3,3,3) :: mat3
      complex(kind=db), dimension(3,3,3,3) :: mat4
      complex(kind=db), dimension(3,3,nbseuil,nspinr,0:mpinodes-1)::
     &                                            secdd, secmd, secmm
      complex(kind=db), dimension(3,3,3,nbseuil,nspinr,0:mpinodes-1)::
     &                                            secdq
      complex(kind=db), dimension(3,3,3,3,nbseuil,nspinr,0:mpinodes-1)::
     &                                            secdo, secqq
      complex(kind=db), dimension(lmomax,lmomax,nspin,nbseuil) :: 
     &                                                           Tens_lm
      complex(kind=db), dimension(nlmam,nspin,nspin,0:3,nbseuil):: rof
      complex(kind=db), dimension(nlmam,nspin,nspin,3,nbseuil):: singul
      complex(kind=db), dimension(nlmam,nspin,nlmam,nspin):: taull
      complex(kind=db), dimension(:,:), allocatable:: d, u, ut
      complex(kind=db), dimension(:,:,:,:,:,:),allocatable:: singul_ext
      complex(kind=db),dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,
     &               nspin,n_atom_0_self:n_atom_ind_self):: rot

      logical Atom_comp, base_spin, comp_dd, comp_md, comp_do, comp_dq,   
     &        comp_mm, comp_qq, green, hubb, lmoins1, lplus1, solsing,
     &        solsing_only, spin_resolved, spinorbite 

      real(kind=db), dimension(nspinr):: Tensi, Tensr
      real(kind=db), dimension(0:lomax,3,3,3,lmomax):: clm
      real(kind=db), dimension(3,3):: rot_atom_abs, rot_tem

      common/base_spin/ base_spin
      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq 
      common/icheck/ icheck(24)
      common/ldip/ ldip(3), loct(3,3,3), lqua(3,3)
      common/msym/ msymdd(3,3), msymddi(3,3), msymdq(3,3,3), 
     &             msymdqi(3,3,3), msymdo(3,3,3,3), msymdoi(3,3,3,3),
     &             msymqq(3,3,3,3), msymqqi(3,3,3,3)
      common/rot_int/ rot_int(3,3)
      common/spin_resolved/ spin_resolved

      if( icheck(21) > 1 ) write(3,100)

! ici: taull est dans la bonne base (la routine rottaull est appellee apres); on envisage
!    de rendre singul dans la bonne base aussi

! Rotation de la solution singuliere dans le cas Hubbard: singul sert au calcul du XANES,
!          du coup singul correspond a l'atome centrale

      if( hubb .and. nself /= 0 .and. i_self > 1 ) then
        lhubb = l_hubbard( numat )
        lmi = lhubb**2 + 1
        lmf = (lhubb + 1)**2

        if( (icheck(21) > 1 .and. ie == 1) .or. icheck(21) > 3 ) then
          write(3,659)
          do isp1 = 1, nspin
           do isp2 = 1, nspin     
            do idim = 1,3
             do iseuil = 1, nbseuil
              write(3,701) isp1,isp2,idim,iseuil
              do lm = lmi, lmf
                write(3,703) lm, singul(lm,isp1,isp2,idim,iseuil) 
              end do
             end do
            end do
           end do
          end do
        end if

! si pas SO, singul est diagonal en spin
! si SO, le premier indice porte sur le spin et le deuxieme sur la solution

        allocate( d(-lhubb:lhubb,-lhubb:lhubb) )
        allocate( u(-lhubb:lhubb,-lhubb:lhubb) )
        allocate( ut(-lhubb:lhubb,-lhubb:lhubb) )
        allocate( singul_ext(nlmam,nlmam,nspin,nspin,3,nbseuil) )
        singul_ext(:,:,:,:,:,:) = (0._db, 0._db)
           
        do isp = 1, nspin

         if( spinorbite ) then

          do isol = 1, nspin
! Recopies dans un sens:
           u(-lhubb:lhubb,-lhubb:lhubb) 
     &                    = rot(-lhubb:lhubb,-lhubb:lhubb,isp,1)
           ut = transpose( u )

           do idim = 1,3
            do iseuil = 1, nbseuil

             d(:,:) = (0._db, 0._db)
             n = -lhubb-1
             do lm = lmi, lmf
              n = n + 1
              d(n,n) = singul(lm,isp,isol,idim,iseuil)
             end do

! Rotations:
             d = matmul(u,matmul(d,ut))

! Recopies dans l'autre sens:
             n1 = -lhubb-1
             do lm1 = lmi, lmf
              n1 = n1 + 1
              n2 = -lhubb-1
              do lm2 = lmi, lmf
               n2 = n2 + 1
               singul_ext(lm1,lm2,isp,isol,idim,iseuil) = d(n1,n2)
              end do
             end do

            end do
           end do

! On ecrase le mauvais singul:
           do lm = lmi, lmf
            singul(lm,isp,isol,:,:) = singul_ext(lm,lm,isp,isol,:,:)                      
           end do

           if( (icheck(21) > 1 .and. ie == 1) .or. icheck(21) > 3 ) then
             write(3,700)
             do idim = 1,3
              do iseuil = 1, nbseuil
               write(3,701) isp,isol,idim,iseuil
               do lm = lmi, lmf
                 write(3,704) singul_ext(lm,lmi:lmf,
     &                                           isp,isol,idim,iseuil) 
               end do
              end do
             end do
           end if
           
          end do

         else

! Recopies dans un sens:
            u(-lhubb:lhubb,-lhubb:lhubb) 
     &                          = rot(-lhubb:lhubb,-lhubb:lhubb,isp,1)
            ut = transpose( u )

            do idim = 1,3
             do iseuil = 1, nbseuil

              d(:,:) = (0._db, 0._db)
              n = -lhubb-1
              do lm = lmi, lmf
               n = n + 1
               d(n,n) = singul(lm,isp,isp,idim,iseuil)
              end do

! Rotations:
              d = matmul(u,matmul(d,ut))
! Recopies dans l'autre sens:

              n1 = -lhubb-1
              do lm1 = lmi, lmf
               n1 = n1 + 1
               n2 = -lhubb-1
               do lm2 = lmi, lmf
                n2 = n2 + 1
                singul_ext(lm1,lm2,isp,isp,idim,iseuil) = d(n1,n2)
               end do
              end do

             end do
            end do

! On ecrase le mauvais singul:
            do lm = lmi, lmf
             singul(lm,isp,isp,:,:) = singul_ext(lm,lm,isp,isp,:,:)                      
            end do

            if((icheck(21) > 1 .and. ie == 1) .or. icheck(21) > 3) then
             write(3,700)
             do idim = 1,3
              do iseuil = 1, nbseuil
               write(3,702) isp,idim,iseuil
               do lm = lmi, lmf
                 write(3,704) singul_ext(lm,lmi:lmf,isp,isp,idim,iseuil) 
               end do
              end do
             end do
            end if

         end if
        end do
        deallocate( d ); deallocate( u ); deallocate( ut )
        deallocate( singul_ext )
      end if

      if( comp_do ) then
        nrang = 3
      elseif( comp_dq .or. comp_qq ) then
        nrang = 2
      else
        nrang = 1
      endif
      if( comp_md .or. comp_mm ) then
        irang1 = 0
      else
        irang1 = 1
      endif

      if( nrang > lomax .and. mpirank == 0 ) then
        call write_error
        do ipr = 6,9,3
          write(ipr,'(/A)') ' nrang > lomax in coabs.f !'
        end do
        stop
      endif


! Calcul des composantes de la transf base-cartesienne - base-spherique:
  
      do irang = irang1,nrang

        clm(irang,:,:,:,:) = 0._db

        select case(irang)

          case(0)
! Magnetic dipole
            c = sqrt( 4 * pi )
! Dans ce cas, correspond a l=0,m=0 mais sert a definir x, y ou z.
            clm(irang,1,:,:,4) = c
            clm(irang,2,:,:,2) = c
            clm(irang,3,:,:,3) = c

          case(1)
! Dipole
            c = sqrt( 4 * pi / 3 )
            clm(irang,1,:,:,4) = - c
            clm(irang,2,:,:,2) = - c
            clm(irang,3,:,:,3) = c

          case(2)
! Quadrupole
            c0 = sqrt( 4 * pi ) / 3
            c = sqrt( 4 * pi / 15 )
            c3 = c / sqrt( 3._db )

            clm(irang,1,1,:,1) = c0
            clm(irang,1,1,:,7) = - c3;   clm(irang,1,1,:,9) = c
            clm(irang,1,2,:,5) = c
            clm(irang,1,3,:,db) = - c
            clm(irang,2,2,:,1) = c0
            clm(irang,2,2,:,7) = - c3;   clm(irang,2,2,:,9) = - c
            clm(irang,2,3,:,6) = - c
            clm(irang,3,3,:,1) = c0
            clm(irang,3,3,:,7) = 2 * c3

            do i = 1,3
              do j = i+1,3
                clm(irang,j,i,:,:) = clm(irang,i,j,:,:)
              end do
            end do

          case(3)
! Octupole
            c1 = sqrt( 4 * pi / 75 )

            c = sqrt( 4 * pi / 35 )
            c5 = c / sqrt( 5._db )
            c8 = c / sqrt( 8._db )
            c12 = c / sqrt( 12._db )
            c120 = c / sqrt( 120._db )

            clm(irang,1,1,1,4) = - 3 * c1
            clm(irang,1,1,1,14) = 3 * c120;  clm(irang,1,1,1,16) = - c8
            clm(irang,2,2,2,2) = - 3 * c1
            clm(irang,2,2,2,12) = 3 * c120;  clm(irang,2,2,2,10) = c8
            clm(irang,3,3,3,3) = 3 * c1
            clm(irang,3,3,3,12) = 2 * c5
            clm(irang,1,1,2,2) = - c1
            clm(irang,1,1,2,10) = - c8;      clm(irang,1,1,2,12) = c120
            clm(irang,1,2,2,4) = - c1
            clm(irang,1,2,2,16) = c8;        clm(irang,1,2,2,14) = c120
            clm(irang,1,1,3,3) = c1
            clm(irang,1,1,3,13) = - c5;      clm(irang,1,1,3,15) = c12
            clm(irang,2,2,3,3) = c1
            clm(irang,2,2,3,13) = - c5;      clm(irang,2,2,3,15) = - c12
            clm(irang,2,3,3,2) = - c1
            clm(irang,2,3,3,12) = - 4 * c120
            clm(irang,1,3,3,4) = - c1
            clm(irang,1,3,3,14) = - 4 * c120
            clm(irang,1,2,3,11) = c12

            do i = 1,3
              do j = i,3
                do k = j,3
                  if( i == j .and. i == k ) cycle
                  clm(irang,i,k,j,:) = clm(irang,i,j,k,:)
                  clm(irang,j,i,k,:) = clm(irang,i,j,k,:)
                  clm(irang,k,i,j,:) = clm(irang,i,j,k,:)
                  clm(irang,j,k,i,:) = clm(irang,i,j,k,:)
                  clm(irang,k,j,i,:) = clm(irang,i,j,k,:)
                end do
              end do
            end do

        end select

      end do

      secdd(:,:,:,:,mpirank) = (0._db,0._db)
      secmm(:,:,:,:,mpirank) = (0._db,0._db) 
      secmd(:,:,:,:,mpirank) = (0._db,0._db)
      secdq(:,:,:,:,:,mpirank) = (0._db,0._db) 
      secqq(:,:,:,:,:,:,mpirank) = (0._db,0._db) 
      secdo(:,:,:,:,:,:,mpirank) = (0._db,0._db)
 
! Boucles sur le rang des tenseurs

      do irang = irang1,nrang
        do jrang = irang,nrang
          Tens_lm(:,:,:,:) = (0._db,0._db)
          if( .not. comp_dd .and. irang == 1 .and. jrang == 1 ) cycle
          if( .not. comp_dq .and. irang == 1 .and. jrang == 2 ) cycle
          if( .not. comp_qq .and. irang == 2 .and. jrang == 2 ) cycle
          if( .not. comp_do .and. irang == 1 .and. jrang == 3 ) cycle
          if( .not. comp_mm .and. irang == 0 .and. jrang == 0 ) cycle
          if( .not. comp_md .and. irang == 0 .and. jrang == 1 ) cycle
          if( irang == 0 .and. jrang > 1 ) cycle
          if( jrang == 3 .and. irang > 1 ) cycle

! Boucles sur les indices des tenseurs

          do ke = 1,3

            if( irang == 1 .and. ldip(ke) /= 1 ) cycle

            if( irang <= 1 ) then
              nje = ke
            else
              nje = 3
            endif

            do je = ke,nje

              if( irang == 2 .and. lqua(ke,je) /= 1 ) cycle

              if( irang == 3 ) then
                nj2e = 3
              else
                nj2e = je
              endif
              do j2e = je,nj2e

                if( irang == 3 .and. loct(ke,je,j2e) /= 1 ) cycle

                do ks = 1,3
 
                  if( jrang == 1 .and. ldip(ks) /= 1 ) cycle

                  if( jrang <= 1 ) then
                    njs = ks
                  else
                    njs = 3
                  endif

                  do js = ks,njs

                    if( jrang == 2 .and. lqua(ks,js) /= 1 ) cycle

                    if( jrang == 3 ) then
                      nj2s = 3
                    else
                      nj2s = js
                    endif
                    do j2s = js,nj2s

                      if( jrang == 3 .and. loct(ks,js,j2s) /= 1 ) cycle

                      if( irang == 0 .and. jrang == 0 ) then 
                        if( ks < ke ) cycle
                      elseif( irang == 1 .and. jrang == 1 ) then 
                        if( ks < ke ) cycle
                        if( msymdd(ke,ks) == 0 
     &                                .and. msymddi(ke,ks) == 0 ) cycle
                      elseif( irang == 1 .and. jrang == 2 ) then 
                        if( msymdq(ke,ks,js) == 0 
     &                             .and. msymdqi(ke,ks,js) == 0 ) cycle
                      elseif( irang == 2 .and. jrang == 2 ) then 
                        if( msymqq(ke,je,ks,js) == 0 
     &                          .and. msymqqi(ke,je,ks,js) == 0 ) cycle
                      elseif( irang == 1 .and. jrang == 3 ) then 
                        if( msymdo(ke,ks,js,j2s) == 0
     &                         .and. msymdoi(ke,ks,js,j2s) == 0 ) cycle
                      endif

                      do iseuil = 1,nbseuil

                        if( irang == 2 .and. jrang == 2 .and.
     &        sum(abs(secqq(ke,je,ks,js,iseuil,:,mpirank))) > 1.e-15_db)
     &                    cycle

                        Tens(:) = (0._db,0._db)

! Boucles sur les composantes spheriques des tenseurs
                        lme = 0
                        do le = 0,max(irang,1)
                          do me = -le,le
                            lme = lme + 1

                            clme = clm(irang,ke,je,j2e,lme)
                            if( abs(clme) < eps10 ) cycle

                            lms = 0
                            do ls = 0,max(jrang,1)
                              do ms = -ls,ls
                                lms = lms + 1
 
                                clms = clm(jrang,ks,js,j2s,lms)
                                if( abs(clms) < eps10 ) cycle

! Calcul de la composante du tenseur
                                if( sum(abs(Tens_lm(lme,lms,:,iseuil)))
     &                              < 1.e-15_db ) then
                                  call tens_ab(Atom_comp,irang,le,me,
     &                               jrang,ls,ms,lmoins1,lplus1,green,
     &                               iseuil,nlmam,nbseuil,nspin,rof,
     &                               singul,solsing,solsing_only,
     &                               spinorbite,taull,Ten)
                                  Tens_lm(lme,lms,:,iseuil) = Ten(:)
                                endif

                                Tens(:) = Tens(:) + clme * clms
     &                                  * Tens_lm(lme,lms,:,iseuil)
                              end do       
                            end do       
                          end do       
                       end do ! fin boucle le       

! Cas de la sortie resolue en spin
                        do ispinr = 1,nspinr   
                          if( spin_resolved ) then
                            Tens_sr(ispinr) = Tens(ispinr)
                          else
                            Tens_sr(ispinr) = sum( Tens(1:nspin) )
                          endif
                        end do

! Remplissage de la valeur calculee dans tous les elements du tenseur
! equivalent par symetrie.

                        Tensr(:) = real( Tens_sr(:),db )  
                        Tensi(:) = aimag( Tens_sr(:) )  

! M1-M1 (dipole magnetique - dipole magnetique)
                        if( irang == 0 .and. jrang == 0 ) then
                          Te(:) = Tens_sr(:)
                          secmm(ke,ks,iseuil,:,mpirank) = Te(:)
                          secmm(ks,ke,iseuil,:,mpirank) = conjg( Te(:) )
                        endif

! M1-E1 (dipole magnetique - dipole electrique)
                        if( irang == 0 .and. jrang == 1 ) then
                          Te(:) = Tens_sr(:)
                          secmd(ke,ks,iseuil,:,mpirank) = Te(:)
                          secmd(ks,ke,iseuil,:,mpirank) = conjg( Te(:) )
                        endif

! E1-E1 (Dipole-dipole)
                        if( irang == 1 .and. jrang == 1 ) then
                          do kke = 1,3
                            do kks = kke,3
                              if( abs(msymdd(kke,kks)) 
     &                         /= abs(msymdd(ke,ks)) .or.
     &                            abs(msymddi(kke,kks)) 
     &                         /= abs(msymddi(ke,ks)) ) cycle
                              if( msymdd(kke,kks) /= 0 ) then
                                is = msymdd(kke,kks) / msymdd(ke,ks)
                              else
                                is = 0
                              endif
                              if( msymddi(kke,kks) /= 0 ) then
                                isi = msymddi(kke,kks) / msymddi(ke,ks)
                              else
                                isi = 0
                              endif
                              Te(:) = cmplx(is*Tensr(:),isi*Tensi(:),db)
                              secdd(kke,kks,iseuil,:,mpirank) = Te(:) 
                              secdd(kks,kke,iseuil,:,mpirank)
     &                                                 = conjg( Te(:) )
                            end do
                          end do

! Dipole-quadrupole
                        elseif( irang == 1 .and. jrang == 2 ) then
                          do kke = 1,3
                            do kks = 1,3
                              do jjs = kks,3
                                if( abs(msymdq(kke,kks,jjs)) 
     &                           /= abs(msymdq(ke,ks,js)) .or.
     &                              abs(msymdqi(kke,kks,jjs))
     &                           /= abs(msymdqi(ke,ks,js)) ) cycle
                                if( msymdq(kke,kks,jjs) /= 0 ) then
                                  is = msymdq(kke,kks,jjs)
     &                               / msymdq(ke,ks,js)
                                else
                                  is = 0
                                endif
                                if( msymdqi(kke,kks,jjs) /= 0 ) then
                                  isi = msymdqi(kke,kks,jjs)
     &                                / msymdqi(ke,ks,js)
                                else
                                  isi = 0
                                endif
                                Te(:)=cmplx(is*Tensr(:),isi*Tensi(:),db)
                           secdq(kke,kks,jjs,iseuil,:,mpirank) = Te(:)
                           secdq(kke,jjs,kks,iseuil,:,mpirank) = Te(:)
                              end do
                            end do
                          end do

! Dipole-octupole
                        elseif( irang == 1 .and. jrang == 3 ) then
                          do kke = 1,3
                            do kks = 1,3
                              do jjs = 1,3
                                do jj2s = jjs,3
                                  if( abs(msymdo(kke,kks,jjs,jj2s))
     &                             /= abs(msymdo(ke,ks,js,j2s)) 
     &                           .or. abs(msymdoi(kke,kks,jjs,jj2s)) 
     &                             /= abs(msymdoi(ke,ks,js,j2s))) cycle
                                  if( msymdo(kke,kks,jjs,jj2s)/=0 ) then
                                    is = msymdo(kke,kks,jjs,jj2s) 
     &                                 / msymdo(ke,ks,js,j2s)
                                  else
                                    is = 0
                                  endif
                                  if( msymdoi(kke,kks,jjs,jj2s)/=0) then
                                    isi = msymdoi(kke,kks,jjs,jj2s)
     &                                  / msymdoi(ke,ks,js,j2s)
                                  else
                                    isi = 0
                                  endif
                             Te(:) = cmplx( is*Tensr(:),isi*Tensi(:),db)
                        secdo(kke,kks,jjs,jj2s,iseuil,:,mpirank) = Te(:)
                        secdo(kke,kks,jj2s,jjs,iseuil,:,mpirank) = Te(:)
                        secdo(kke,jjs,kks,jj2s,iseuil,:,mpirank) = Te(:)
                        secdo(kke,jj2s,kks,jjs,iseuil,:,mpirank) = Te(:)
                        secdo(kke,jjs,jj2s,kks,iseuil,:,mpirank) = Te(:)
                        secdo(kke,jj2s,jjs,kks,iseuil,:,mpirank) = Te(:)
                                end do
                              end do
                            end do
                          end do

! Quadrupole-quadrupole
                        elseif( irang == 2 .and. jrang == 2 ) then
                          do kke = 1,3
                            do jje = kke,3
                              do kks = 1,3
                                do jjs = kks,3
                                  if( sum(abs(
     &      secqq(kke,jje,kks,jjs,iseuil,:,mpirank))) > 1.e-15_db) cycle
                                  if( abs(msymqq(kke,jje,kks,jjs))
     &                             /= abs(msymqq(ke,je,ks,js))
     &                           .or. abs(msymqqi(kke,jje,kks,jjs)) 
     &                             /= abs(msymqqi(ke,je,ks,js)) ) cycle
                                  if( msymqq(kke,jje,kks,jjs)/=0 ) then
                                    is = msymqq(kke,jje,kks,jjs) 
     &                                 / msymqq(ke,je,ks,js)
                                  else
                                    is = 0
                                  endif  
                                  if( msymqqi(kke,jje,kks,jjs)/=0 ) then
                                    isi = msymqqi(kke,jje,kks,jjs) 
     &                                  / msymqqi(ke,je,ks,js)
                                  else
                                    isi = 0
                                  endif
                     Te(:) = cmplx( is*Tensr(:), isi*Tensi(:),db )
                secqq(kke,jje,kks,jjs,iseuil,:,mpirank) = Te(:)
                secqq(jje,kke,kks,jjs,iseuil,:,mpirank) = Te(:)
                secqq(kke,jje,jjs,kks,iseuil,:,mpirank) = Te(:)
                secqq(jje,kke,jjs,kks,iseuil,:,mpirank) = Te(:)
                secqq(kks,jjs,kke,jje,iseuil,:,mpirank) = conjg( Te(:) )
                secqq(jjs,kks,kke,jje,iseuil,:,mpirank) = conjg( Te(:) )
                secqq(kks,jjs,jje,kke,iseuil,:,mpirank) = conjg( Te(:) )
                secqq(jjs,kks,jje,kke,iseuil,:,mpirank) = conjg( Te(:) )
                                end do
                              end do
                            end do
                          end do
                        endif

                      end do ! Fin de la boucle sur les seuils       

                    end do       
                  end do       
                end do       
              end do       
            end do       
          end do       

          if( icheck(21) < 2 ) cycle

          do iseuil = 1,nbseuil
            if( .not. comp_dq .and. irang == 1 .and. jrang == 2 ) cycle
            if( jrang == 3 .and. irang > 1 ) cycle
            if( irang == 0 .and. jrang > 1 ) cycle
            write(3,110) iseuil
            lme = 0
            do le = 0,irang
              do me = -le,le
               lme = lme + 1
               lms = 0
               do ls = 0,jrang
                  do ms = -ls,ls
                    lms = lms + 1
                    if( sum( abs( Tens_lm(lme,lms,:,iseuil) ) ) 
     &                < 1.e-15_db ) cycle
                    write(3,120) irang, jrang, le, me, ls, ms,
     &                           Tens_lm(lme,lms,:,iseuil) 
                  end do       
                end do       
              end do       
            end do       
          end do       

        end do       
      end do       

! Rotation pour avoir les tenseurs dans la base R1

      if( .not. base_spin ) then

        rot_tem = matmul( rot_int, transpose(rot_atom_abs) )

        do iseuil = 1,nbseuil
          do ispinr = 1,nspinr

            if( comp_dd ) then
              mat2(:,:) = secdd(:,:,iseuil,ispinr,mpirank) 
              call rot_tensor_2( mat2, rot_tem )
              secdd(:,:,iseuil,ispinr,mpirank) = mat2(:,:) 
            endif

            if( comp_dq ) then
              mat3(:,:,:) = secdq(:,:,:,iseuil,ispinr,mpirank) 
              call rot_tensor_3( mat3, rot_tem )
              secdq(:,:,:,iseuil,ispinr,mpirank) = mat3(:,:,:) 
            endif

            if( comp_qq ) then
              mat4(:,:,:,:) = secqq(:,:,:,:,iseuil,ispinr,mpirank) 
              call rot_tensor_4( mat4, rot_tem )
              secqq(:,:,:,:,iseuil,ispinr,mpirank) = mat4(:,:,:,:) 
            endif

            if( comp_do ) then
              mat4(:,:,:,:) = secdo(:,:,:,:,iseuil,ispinr,mpirank) 
              call rot_tensor_4( mat4, rot_tem )
              secdo(:,:,:,:,iseuil,ispinr,mpirank) = mat4(:,:,:,:) 
            endif

            if( comp_md ) then
              mat2(:,:) = secmd(:,:,iseuil,ispinr,mpirank) 
              call rot_tensor_2( mat2, rot_tem )
              secmd(:,:,iseuil,ispinr,mpirank) = mat2(:,:) 
            endif

            if( comp_mm ) then
              mat2(:,:) = secmm(:,:,iseuil,ispinr,mpirank) 
              call rot_tensor_2( mat2, rot_tem )
              secmm(:,:,iseuil,ispinr,mpirank) = mat2(:,:) 
            endif

          end do
        end do

      endif

      return
  100 format(/' ---- Tens_ab --------',100('-'))
  110 format(/' Tensor by harmonics (basis R4), iseuil =',i2,' :'/,
     &' ir jr   l  m  lp mp       Tens(Ylm,ispin=1,nspin)')
  120 format(2i3,2(i4,i3),1p,4e13.5)
  659 format(/'Singul before the Hubbard rotation:')
  700 format(/'Singul after the Hubbard rotation:')
  701 format(/'isp1 = ',i1,'  isp2 = ',i1,'  idim = ',i1,
     &       '  iseuil = ',i1)
  702 format(/'isp = ',i1,'  idim = ',i1,'  iseuil = ',i1)
  703 format('lm = ',i3,2e13.5)
  704 format(20e13.5)

      end

!***********************************************************************

      subroutine tens_ab(Atom_comp,irang,le,me,jrang,ls,ms,lmoins1,
     &                   lplus1,green,iseuil,nlmam,nbseuil,nspin,rof,
     &                   singul,solsing,solsing_only,spinorbite,taull,
     &                   Ten)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db) :: cfe, cfs, Cg

      complex(kind=db):: Gaunte, Gauntm, Gauntmag, Gaunts
      complex(kind=db), dimension(nspin):: Ten
      complex(kind=db), dimension(nlmam,nspin,nspin,0:3,nbseuil):: rof
      complex(kind=db), dimension(nlmam,nspin,nspin,3,nbseuil):: singul
      complex(kind=db), dimension(nlmam,nspin,nlmam,nspin):: taull

      logical Atom_comp, green, green_int, lmoins1, lplus1, solsing, 
     &        solsing_only,  spinorbite, Ylm_comp 

      real(kind=db):: J_initl, Jz

      common/green_int/ green_int
      common/icheck/ icheck(24)
      common/lseuil/ jseuil, lseuil, nseuil

      Ylm_comp = spinorbite .or. Atom_comp

! Coefficients de l'etat initial
      select case(jseuil)
        case(1,3,5,7)
          isinitl = 1
        case default
          isinitl = -1
      end select
      if( iseuil == 2 ) isinitl = - isinitl
      li = lseuil
      J_initl = li + 0.5_db * isinitl
      ninitl = nint( 2*J_initl  + 1 )

      Ten(:) = (0._db,0._db)

      if( icheck(21) > 2 ) write(3,110) le, me, ls, ms, li

! Boucle sur le spin
      do isping = 1,2  ! C'est le spin de l'etat initial 

        if( nspin == 2 ) then
          ispin = isping
        else
          ispin = 1
        endif

! Boucle sur les etats initiaux
        do initl = 1,ninitl

          Jz = - J_initl + initl - 1
! Ci2 est le carre du coefficient de l'orbitale initiale
          if( isping == 1 ) then
            spin = 0.5_db
          else
            spin = - 0.5_db
          endif
          mi = nint( Jz - spin )
          if( abs(mi) > li ) cycle
          Ci2 = ( li + 0.5_db + 2*isinitl*spin*Jz ) / ( 2*li + 1 )
          if( icheck(21) > 2 ) write(3,120) ispin,initl,Jz,mi,Ci2
          if( Ci2 < eps6 ) cycle

          if( irang == 0 ) then
            lfe1 = li
            lfe2 = li
          else
            lfe1 = abs(li - le)
!            lfe1 = li - le
!            do i = 1,5
!              if( lfe1 >= 0 ) exit
!              lfe1 = lfe1 + 2
!            end do
            lfe2 = li + le
          endif
          if( lplus1 ) lfe1 = lfe2
          if( lmoins1 ) lfe2 = lfe1

          do l = lfe1,lfe2,2
            lm0 = l**2 + l + 1 
            do m = -l,l
              lm = lm0 + m
              if( lm > nlmam ) cycle

              do ispingf = 1,2  ! spin de l'etat final en entree
             
                if( ispingf /= isping .and. irang /= 0 ) cycle

                if( nspin == 2 ) then
                  ispinf = ispingf
                else
                  ispinf = 1
                endif

! Boucle sur les 2 solutions
                do isg = 1,2

                  if( nspin == 2 ) then
                    is = isg
                  else
                    is = 1
                  endif
                  if( spinorbite ) then
                    mv = m + ispingf - isg
                    if( mv > l .or. mv < -l ) cycle
                    lmv = lm0 + mv
                  else
                    if( isg /= ispingf ) cycle
                    mv = m
                    lmv = lm
                  endif

                  if( irang == 0 ) then
                    Gaunte = Gauntmag(isping,ispingf,me,l,mv,li,mi,
     &                                Ylm_comp)
                  else
                    Gaunte = Gauntm(l,mv,le,me,li,mi,Ylm_comp)
                  endif

                  if( abs(Gaunte) < eps10 ) cycle

                  if( jrang == 0 ) then
                    lf1 = li
                    lf2 = li
                  else
                    lf1 = abs(li - ls)
!                    lf1 = li - ls
!                    do i = 1,5
!                      if( lf1 >= 0 ) exit
!                      lf1 = lf1 + 2
!                    end do
                    lf2 = li + ls
                  endif
                  if( lplus1 ) lf1 = lf2
                  if( lmoins1 ) lf2 = lf1

                  do lp = lf1,lf2,2
                    lmp0 = lp**2 + lp + 1 
                    do mp = -lp,lp
                      lmp = lmp0 + mp
                      if( lmp > nlmam ) cycle

                      do ispingfp = 1,2  ! spin etat final en sortie
             
                        if( ispingfp /= isping .and. jrang /= 0 ) cycle

                        if( nspin == 2 ) then
                          ispinfp = ispingfp
                        else
                          ispinfp = 1
                        endif

                        do ispg = 1,2

                          if( nspin == 2 ) then
                            isp = ispg
                          else
                            isp = 1
                          endif
                          if( spinorbite ) then
                            mpv = mp + ispingfp - isp
                            if( mpv > lp .or. mpv < -lp ) cycle
                            lmpv = lmp0 + mpv
                          else
                            if( ispg /= ispingfp ) cycle
                            mpv = mp
                            lmpv = lmp
                          endif

                          if( jrang == 0 ) then
                            Gaunts = Gauntmag(isping,ispingfp,ms,lp,mpv,
     &                                        li,mi,Ylm_comp)
                          else
                            Gaunts = Gauntm(lp,mpv,ls,ms,li,mi,
     &                                      Ylm_comp)
                          endif

                          if( abs(Gaunts) < eps10 ) cycle

                          Cg = - Ci2 * conjg( Gaunte ) * Gaunts 

                          if( .not. solsing_only ) then

! Si le potentiel est reel, rof est reel
!                            if( .not. green ) then

!                              Ten(ispin) = Ten(ispin) + Cg
!     &                          * conjg(rof(lmv,ispinf,is,irang,iseuil))
!     &                          * rof(lmpv,ispinfp,isp,jrang,iseuil)
!     &                          * taull(lmp,isp,lm,is)

!                            else

! Comme on ne divise pas par pi, le resultat apparait comme multiplie
! par pi, si on calcule ensuite le facteur de structure. La
! normalisation par pi n'est donc pas a faire dans coabs sur l'amplitude
! dafs.
                              cfe = rof(lmv,ispinf,is,irang,iseuil)
     &                            * rof(lmpv,ispinfp,isp,jrang,iseuil)
     &                            * taull(lmp,isp,lm,is)

                              if( green_int ) then
                                Ten(ispin) = Ten(ispin) + cfe
                              else
                                cfs = rof(lmpv,ispinfp,isp,jrang,iseuil)
     &                              * rof(lmv,ispinf,is,irang,iseuil)
     &                              * taull(lm,is,lmp,isp)
                                Ten(ispin) = Ten(ispin) + 0.5_db * Cg
     &                       * cmplx(real(cfe-cfs,db),aimag(cfe+cfs),db)
                              endif

!                            endif

                          endif

! Soustraction de la solution singuliere
! Dans cas octupole-octupole, la solution singuliere n'est pas calculee
! (voir routine sphere).
! Dans le cas du dipole magnetique, je ne sais pas.
!           if( solsing .and. green ) then
           if( solsing ) then

                            ijrang = irang + jrang
                            if( ijrang /= 3 .and. ijrang /= 5 
     &                         .and. ijrang /= 6 .and. irang /= 0
     &                         .and. jrang /= 0 ) then
                              if( lmv == lmpv .and. isp == is 
     &                                 .and. isp == ispinf )
     &                          Ten(ispin) = Ten(ispin) - Cg
     &   * cmplx(0._db,aimag(singul(lmv,ispinf,ispinf,jrang,iseuil)),db)
                            endif

                          endif


                          if( icheck(21) > 2 ) write(3,130) l, m, is,
     &                      lp, mp, isp, Ten(ispin), Cg,
     &                      rof(lmv,ispinf,is,irang,iseuil),
     &                      rof(lmpv,ispinfp,isp,jrang,iseuil),
     &                      taull(lm,is,lmp,isp), Gaunts, Gaunte

                        end do ! fin boucle sur spin d'etat final sortie
                      end do
                    end do

                  end do
                end do

              end do  ! fin boucle sur spin d'etat final en entree
            end do
          end do

        end do    ! fin boucle sur les etats initiaux
      end do   ! fin boucle sur le spin d'etat initial

! On multiplie par -i pour que ce soit la partie reelle du tenseur qui
! soit l'absorption.
      Ten(:) = - img * Ten(:)

      return
  110 format(/' le, me =',2i3,',  ls, ms =',2i3,', li =',i2) 
  120 format(' ispin, initl =',2i2,', Jz =',f5.1,', mi =',i2,
     &       ', Ci2 =',f7.3)
  130 format(' l,m,is,lp,mp,isp=',6i3,1p,
     &       ' Ten=',2e13.5,' Cg=',2e13.5,' rof,rof=',4e13.5,
     &       ' Tau=',2e13.5,' Gaunts,Gaunte=',4e13.5) 
      end

!***********************************************************************

! Calcule le coefficient de Gaunt avec Y(li,mi) complexe, Y(lo,mo) reel
! et Y(l,m) complexe ou reel.
 
      complex(kind=db) function Gauntm(l,m,lo,mo,li,mi,Ylmcomp)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      logical Ylmcomp

      if( Ylmcomp ) then

        if( mo == 0 ) then  
          gr = gauntcp(l,m,lo,mo,li,mi)
          gi = 0._db
        elseif( mo > 0 ) then
          gr = (   gauntcp(l,m,lo,mo,li,mi)
     &         + (-1)**mo * gauntcp(l,m,lo,-mo,li,mi) ) / sqrt( 2._db ) 
          gi = 0._db
        else
          gi = ( (-1)**mo * gauntcp(l,m,lo,mo,li,mi)
     &                    - gauntcp(l,m,lo,-mo,li,mi) ) / sqrt( 2._db )
          gr = 0._db
        endif

      else

        if( mi == 0 ) then  
          gr = gauntc(l,m,lo,mo,li,mi)
          gi = 0._db
        elseif( mi > 0 ) then
          gr = gauntc(l,m,lo,mo,li,mi) / sqrt( 2._db )
          gi = gauntc(l,m,lo,mo,li,-mi) / sqrt( 2._db )
        else
          gr = (-1)**mi * gauntc(l,m,lo,mo,li,-mi) / sqrt( 2._db )
          gi = - (-1)**mi * gauntc(l,m,lo,mo,li,mi) / sqrt( 2._db )
        endif

      endif 

      Gauntm = cmplx( gr, gi,db )

      return
      end

!***********************************************************************

! Calcule le coefficient de Gaunt modifie pour la transition dipole
! magnetique
 
      complex(kind=db) function Gauntmag(isping,ispingf,me,l,mv,li,mi,
     &                                  spinorbite)


      use declarations
      implicit real(kind=db) (a-h,o-z)
      
      complex(kind=db):: Gaunt, Gauntm

      logical:: spinorbite

      select case(me)

        case(-1)     ! Ly + 2*Sy
          if( isping == ispingf ) then
            Gaunt = - 0.5_db * img * ( sqrt( li*(li+1._db) - mi*(mi+1) )
     &                    * Gauntm(l,mv,0,0,li,mi+1,spinorbite)
     &            - sqrt( li*(li+1._db) - mi*(mi-1) )
     &                    * Gauntm(l,mv,0,0,li,mi-1,spinorbite) )
          else
            if( isping == 1 ) then
              Gaunt = img * Gauntm(l,mv,0,0,li,mi,spinorbite)
            else
              Gaunt = - img * Gauntm(l,mv,0,0,li,mi,spinorbite)
            endif
          endif

        case(0)     ! Lz + 2*Sz
          if( isping /= ispingf ) then
            Gaunt = (0._db,0._db)
          else
            if( isping == 1 ) then
              Gaunt = ( mi + 1 ) * Gauntm(l,mv,0,0,li,mi,spinorbite) 
            else
              Gaunt = ( mi - 1 ) * Gauntm(l,mv,0,0,li,mi,spinorbite) 
            endif 
          endif 

        case(1)     ! Lx + 2*Sx
          if( isping == ispingf ) then
            Gaunt = 0.5_db * ( sqrt( li*(li+1._db) - mi*(mi+1) )
     &                    * Gauntm(l,mv,0,0,li,mi+1,spinorbite)
     &            + sqrt( li*(li+1._db) - mi*(mi-1) )
     &                    * Gauntm(l,mv,0,0,li,mi-1,spinorbite) )
          else
            Gaunt = Gauntm(l,mv,0,0,li,mi,spinorbite)
          endif

      end select

      Gauntmag = Gaunt

      return
      end

!***********************************************************************

      subroutine rot_tensor_2( mat2, rot_int )

      use declarations
      complex(kind=db):: cmat
      complex(kind=db), dimension(3,3):: mat, mat2

      real(kind=db), dimension(3,3):: rot_int

      mat(:,:) = (0._db, 0._db) 
      do i = 1,3
        do j = 1,3
          do k = 1,3
            cmat = sum( rot_int(j,:) * mat2(k,:) ) 
            mat(i,j) = mat(i,j) + rot_int(i,k) * cmat  
          end do
        end do
      end do
      mat2(:,:) = mat(:,:)

      return
      end 

!***********************************************************************

      subroutine rot_tensor_3( mat3, rot_int )

      use declarations
      complex(kind=db):: cmas, cmat
      complex(kind=db), dimension(3,3,3):: mat, mat3

      real(kind=db), dimension(3,3):: rot_int

      mat(:,:,:) = (0._db, 0._db) 
      do i = 1,3
        do j = 1,3
          do k = 1,3
            do l = 1,3
              cmas = (0._db, 0._db) 
              do m = 1,3
                cmat = sum( rot_int(k,:) * mat3(l,m,:) ) 
                cmas = cmas + rot_int(j,m) * cmat  
              end do
              mat(i,j,k) = mat(i,j,k) + rot_int(i,l) * cmas  
            end do
          end do
        end do
      end do
      mat3(:,:,:) = mat(:,:,:) 

      return
      end 

!***********************************************************************

      subroutine rot_tensor_4( mat4, rot_int )
     
      use declarations
      complex(kind=db):: cmar, cmas, cmat
      complex(kind=db), dimension(3,3,3,3):: mat, mat4

      real(kind=db), dimension(3,3):: rot_int

      mat(:,:,:,:) = (0._db, 0._db) 

      do i = 1,3
        do j = 1,3
          do k = 1,3
            do l = 1,3
              do m = 1,3
                cmar = (0._db, 0._db) 
                do n = 1,3
                  cmas = (0._db, 0._db) 
                  do n1 = 1,3
                    cmat = sum( rot_int(l,:) * mat4(m,n,n1,:) ) 
                    cmas = cmas + rot_int(k,n1) * cmat  
                  end do
                  cmar = cmar + rot_int(j,n) * cmas  
                end do
                mat(i,j,k,l) = mat(i,j,k,l) + rot_int(i,m) * cmar  
              end do
            end do
          end do
        end do
      end do

      mat4(:,:,:,:) = mat(:,:,:,:) 

      return
      end 

!***********************************************************************

      subroutine extract_coabs(ie,isymext,nbseuil,nenerg,
     &            nspin,nom_fich_extract,nspinr,
     &            secdd,secdo,secdq,secqq)

 
      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=132) mot, nom_fich_extract

      complex(kind=db), dimension(3,3,nbseuil,nspinr,0:0) :: secdd
      complex(kind=db), dimension(3,3,3,nbseuil,nspinr,0:0) :: secdq
      complex(kind=db), dimension(3,3,3,3,nbseuil,nspinr,0:0) :: secdo, 
     &                                                          secqq
      complex(kind=db), dimension(3,3) :: secdd_t
      complex(kind=db), dimension(3,3,3) :: secdq_t
      complex(kind=db), dimension(3,3,3,3) :: secdo_t, secqq_t
      complex(kind=db), dimension(3,3,nspin) :: secddspr
      complex(kind=db), dimension(3,3,3,nspin) :: secdqspr
      complex(kind=db), dimension(3,3,3,3,nspin) :: secdospr, secqqspr

      logical comp_dd, comp_md, comp_mm, comp_do, comp_dq, comp_qq,
     &        spin_resolved, tensor_rot

      real(kind=db), dimension(3,3):: rot_tem

      common/ang_rotsup/ ang_rotsup(3)
      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq 
      common/icheck/ icheck(24)
      common/tensor_rot/ tensor_rot
      common/rotsup/ rotsup(3,3)
      common/spin_resolved/ spin_resolved

      if( ie == 1 ) then
        open(1, file = nom_fich_extract, status='old', iostat=istat) 
        if( istat /= 0 ) call write_open_error(nom_fich_extract,istat,1)

! Si les tenseurs importes doivent subir une rotation
        tensor_rot = .false.
        rotsup = 0._db
        do i = 1,3
          rotsup(i,i) = 1._db
        end do
        do i = 1,3
          if( abs( ang_rotsup(i) ) < eps6 ) cycle
          tensor_rot = .true. 
          ang_rotsup(i) = ang_rotsup(i) * pi / 180
          cosa = cos( ang_rotsup(i) )
          sina = sin( ang_rotsup(i) )
          j = mod(i+2,3) + 1
          k = mod(i,3) + 1
          l = mod(i+1,3) + 1
          rot_tem(j,j) = cosa; rot_tem(j,k) = sina; rot_tem(j,l) = 0._db 
          rot_tem(k,j) = -sina; rot_tem(k,k) = cosa; 
          rot_tem(k,l) = 0._db; rot_tem(l,j) = 0._db  
          rot_tem(l,k) = 0._db; rot_tem(l,l) = 1._db 

          rotsup = matmul( rot_tem, rotsup )
        end do

        if( tensor_rot .and. icheck(21) > 0 ) then
          write(3,110)
          write(3,120) ( rotsup(i,1:3), i = 1,3 )
        endif

      endif

      do iseuil = 1,nbseuil    ! ---------> Boucle sur les seuils

        do l = 1,100000
          read(1,'(A)') mot
          if( mot(7:11) == 'Coabs' ) exit
        end do

        call extract_tens(isymext,nspin,secddspr,secdospr,
     &                    secdqspr,secqqspr)

        do ispinr = 1,nspinr   ! ---> boucle pour sortie resolue en spin

          if( comp_dd ) then
            if( spin_resolved .or. nspin == 1 ) then
              secdd(:,:,iseuil,ispinr,0) = secddspr(:,:,ispinr)
            else
              secdd(:,:,iseuil,ispinr,0) =
     &                    ( secddspr(:,:,1) + secddspr(:,:,nspin) ) 
            endif
          endif

          if( comp_dq ) then
            if( spin_resolved .or. nspin == 1 ) then
              secdq(:,:,:,iseuil,ispinr,0) = secdqspr(:,:,:,ispinr)
            else
              secdq(:,:,:,iseuil,ispinr,0) =  
     &                 ( secdqspr(:,:,:,1) + secdqspr(:,:,:,nspin) ) 
            endif
          endif

          if( comp_qq ) then
            if( spin_resolved .or. nspin == 1 ) then
              secqq(:,:,:,:,iseuil,ispinr,0) = secqqspr(:,:,:,:,ispinr)
            else
              secqq(:,:,:,:,iseuil,ispinr,0) = 
     &              ( secqqspr(:,:,:,:,1) + secqqspr(:,:,:,:,nspin) ) 
            endif
          endif

          if( comp_do ) then
            if( spin_resolved .or. nspin == 1 ) then
              secdo(:,:,:,:,iseuil,ispinr,0) = secdospr(:,:,:,:,ispinr)
            else
              secdo(:,:,:,:,iseuil,ispinr,0) =
     &               ( secdospr(:,:,:,:,1) + secdospr(:,:,:,:,nspin) ) 
            endif
          endif

          if( tensor_rot ) then

            if( comp_dd ) then
              secdd_t(:,:) = secdd(:,:,iseuil,ispinr,0)
              call rot_tensor_2( secdd_t, rotsup )
              secdd(:,:,iseuil,ispinr,0) = secdd_t(:,:)
            endif

            if( comp_dq ) then
              secdq_t(:,:,:) = secdq(:,:,:,iseuil,ispinr,0)
              call rot_tensor_3( secdq_t, rotsup )
              secdq(:,:,:,iseuil,ispinr,0) = secdq_t(:,:,:)
            endif

            if( comp_qq ) then
              secqq_t(:,:,:,:) = secqq(:,:,:,:,iseuil,ispinr,0)
              call rot_tensor_4( secqq_t, rotsup )
              secqq(:,:,:,:,iseuil,ispinr,0) = secqq_t(:,:,:,:)
            endif

            if( comp_do ) then
              secdo_t(:,:,:,:) = secdo(:,:,:,:,iseuil,ispinr,0)
              call rot_tensor_4( secdo_t, rotsup )
              secdo(:,:,:,:,iseuil,ispinr,0) = secdo_t(:,:,:,:)
            endif

          endif

        end do

      end do

      if( ie == nenerg ) Close(1)

      return
  110 format(/' Matrix rotation for the extracted tensors, rot_sup :')
  120 format(3x,3f9.5)
      end

!***********************************************************************

      subroutine extract_tens(isymext,nspin,secdd,secdo,secdq,
     &                        secqq)


      use declarations
      implicit real(kind=db) (a-h,o-z)

      character(len=132) mot

      logical comp, comp_dd, comp_md, comp_do, comp_dq, comp_mm, comp_qq

      real(kind=db), dimension(3):: wi, wr
      real(kind=db), dimension(3,3):: matopsym

      complex(kind=db), dimension(3,3):: mat2
      complex(kind=db), dimension(3,3,3):: mat3
      complex(kind=db), dimension(3,3,3,3):: mat4
      complex(kind=db), dimension(3,3,nspin):: secdd
      complex(kind=db), dimension(3,3,3,nspin):: secdq
      complex(kind=db), dimension(3,3,3,3,nspin):: secdo, secqq

      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq 

      if( comp_dd ) secdd(:,:,:) = (0._db,0._db)
      if( comp_dq ) secdq(:,:,:,:) = (0._db,0._db)
      if( comp_qq ) secqq(:,:,:,:,:) = (0._db,0._db)
      if( comp_do ) secdo(:,:,:,:,:) = (0._db,0._db)

      do l = 1,100000
        read(1,'(A)') mot
        if( mot(2:4) == 'sec' .or. mot(2:7) == 'Tensor' ) exit
      end do

      backspace(1)
      backspace(1)
      backspace(1)
      read(1,'(A)') mot
      if( mot(2:8) == 'Spin Up') then
        nspinr = 2
      else
        nspinr = 1
      endif

      do ispinr = 1,nspinr

        if( comp_dd ) then
          do l = 1,100000
            read(1,'(A)',iostat=istat) mot
            if( istat /= 0 ) then
              call write_error
              do ipr = 6,9,3
                write(ipr,110) ' Dipole-dipole '
              end do
              stop
            endif
            if( mot(2:6) == 'secdd' .or. mot(2:10) == 'Tensor_dd' ) exit
          end do

          n = nnombre(1,1320)
          if( n  == 6 ) then
            comp = .true.
          else
            comp = .false.
            wi(:) = 0._db
          endif

          do ke = 1,3
            if( comp ) then
              read(1,*) ( wr(k), wi(k), k = 1,3 )
            else
              read(1,*) wr(1:3)
            endif
            if( nspin <= nspinr ) then
              secdd(ke,:,ispinr) = secdd(ke,:,ispinr)
     &                           + cmplx( wr(:), wi(:),db )
            else
              secdd(ke,:,1) = 0.5_db * cmplx( wr(:), wi(:),db )
              secdd(ke,:,2) = secdd(ke,:,1)
            endif
          end do
        endif

        if( comp_dq ) then
          do l = 1,10000
            read(1,'(A)',iostat=istat) mot
            if( istat /= 0 ) then
              call write_error
              do ipr = 6,9,3
                write(ipr,110) ' Dipole-quadrupole '
              end do
              stop
            endif
            if( mot(2:6) == 'secdq' .or. mot(2:10) == 'Tensor_dq') exit
            if( mot(2:4) == 'sec' .or. ( mot(2:7) == 'Tensor' .and.
     &          mot(2:10) /= 'Tensor_dd' )
     &           .or. mot(2:4) == '---' ) then
              secdq(:,:,:,:) = ( 0._db, 0._db )
              goto 1010
            endif
          end do
          n = nnombre(1,1320)
          if( n  == 6 ) then
            comp = .true.
          else
            comp = .false.
            wi(:) = 0._db
          endif
          do ke = 1,3
            do ks = 1,3
              if( comp ) then
                read(1,*) ( wr(k), wi(k), k = 1,3 )
              else
                read(1,*) wr(1:3)
              endif
              if( nspin <= nspinr ) then
                secdq(ke,ks,:,ispinr) = secdq(ke,ks,:,ispinr)
     &                                + cmplx( wr(:), wi(:),db )
              else
                secdq(ke,ks,:,1) = 0.5_db * cmplx( wr(:), wi(:),db )
                secdq(ke,ks,:,2) = secdq(ke,ks,:,1)
              endif
            end do
            read(1,*)
            read(1,*)
          end do
 1010     backspace(1)
        endif

        if( comp_qq ) then

          do l = 1,10000
            read(1,'(A)',iostat=istat) mot
            if( istat /= 0 ) then
              call write_error
              do ipr = 6,9,3
                write(ipr,110) ' Quadrupole-quadrupole '
              end do
              stop
            endif
            if(mot(2:6) == 'secqq' .or. mot(2:10) == 'Tensor_qq') exit
          end do
          n = nnombre(1,1320)
          if( n  == 6 ) then
            comp = .true.
          else
            comp = .false.
            wi(:) = 0._db
          endif
          do js = 1,3
            do ks = 1,3
              do ke = 1,3
                if( comp ) then
                  read(1,*) ( wr(k), wi(k), k = 1,3 )
                else
                  read(1,*) wr(1:3)
                endif
                if( nspin <= nspinr ) then
                  secqq(ke,:,ks,js,ispinr) = secqq(ke,:,ks,js,ispinr)
     &                                   + cmplx( wr(:), wi(:),db )
                else
                  secqq(ke,:,ks,js,1) = 0.5_db * cmplx(wr(:),wi(:),db)
                  secqq(ke,:,ks,js,2) = secqq(ke,:,ks,js,1)
                endif
              end do
              read(1,*)
              read(1,*)
            end do
          end do
          backspace(1)
        endif

        if( comp_do ) then

          do l = 1,10000
            read(1,'(A)',iostat=istat) mot
            if( istat /= 0 ) then
              call write_error
              do ipr = 6,9,3
                write(ipr,110) ' Dipole-octupole '
              end do
              stop
            endif
            if(mot(2:6) == 'secdo' .or. mot(2:10) == 'Tensor_do') exit
          end do

          do ke = 1,3
            do ks = 1,3
              do j1 = 1,3
                if( comp ) then
                  read(1,*) ( wr(k), wi(k), k = 1,3 )
                else
                  read(1,*) wr(1:3)
                endif
                if( nspin <= nspinr ) then
                  secdo(ke,ks,j1,:,ispinr) = secdo(ke,ks,j1,:,ispinr)
     &                                     + cmplx( wr(:), wi(:),db )
                else
                  secdo(ke,ks,j1,:,1) = 0.5_db * cmplx( wr(:), wi(:),db)
                  secdo(ke,ks,j1,:,2) = secdo(ke,ks,j1,:,1)
                endif
              end do
              read(1,*)
              read(1,*)
            end do
          end do
          backspace(1)
        endif

      end do

      do ispin = 1,nspin

        if( isymext == 1 ) cycle
        isym = abs( isymext )
        call opsym(isym,matopsym)

        if( comp_dd ) then
          mat2(:,:) = secdd(:,:,ispin)
          call rot_tensor_2( mat2, matopsym )
          if( isymext < 0 ) mat2(:,:) = conjg( mat2(:,:) )
          secdd(:,:,ispin) = mat2(:,:)
        endif

        if( comp_dq ) then
          mat3(:,:,:) = secdq(:,:,:,ispin)
          call rot_tensor_3( mat3, matopsym )
          if( isymext < 0 ) mat3(:,:,:) = conjg( mat3(:,:,:) )
          secdq(:,:,:,ispin) = mat3(:,:,:)
        endif

        if( comp_qq ) then
          mat4(:,:,:,:) = secqq(:,:,:,:,ispin)
          call rot_tensor_4( mat4, matopsym )
          if( isymext < 0 ) mat4(:,:,:,:) = conjg( mat4(:,:,:,:) )
          secqq(:,:,:,:,ispin) = mat4(:,:,:,:)
        endif

        if( comp_do ) then
          mat4(:,:,:,:) = secdo(:,:,:,:,ispin)
          call rot_tensor_4( mat4, matopsym )
          if( isymext < 0 ) mat4(:,:,:,:) = conjg( mat4(:,:,:,:) )
          secdo(:,:,:,:,ispin) = mat4(:,:,:,:)
        endif

      end do

      return
  110 format(//A,' not found in the extract file !'//)
      end
