! FDMNES subroutines
! Resolution de l'equation de Schrodinger dans la partie spherique
! des atomes. Calcul de ces fonctions sur les points en bordures.

      subroutine sphere(Absorbeur,Axe_Atom_Clui,cal_xanes,
     &          ecinetic,eimag,energ,
     &          enervide,Full_atom,green,green_plus,hubb,
     &          hubbard,iaabsi,iapr,iaprotoi,ibord,id0,id,
     &          Int_dens_all,ipr,ipr0,konde,lmax,
     &          m_hubb,n_atom_0,n_atom_0_self,n_atom_ind,
     &          n_atom_ind_self,natome,nbord,nbtm,nlmam,nlmagm,nlmmax,
     &          nphiato1,nphiato20,nphiato2,nphiato3,nphiato4,nphiato5,
     &          nphiato6,npoint,npsom,nbseuil,nrato,nrm,
     &          nrm_self,nspin,nspino,numat,octupole,phiato,posi,
     &          psii,rato,relativiste,rhov_self,rmtg,
     &          rmtsd,rof,rofsd,rofsd_hd,sing_self,singul,singulsd,
     &          solsing,spinorbite,state_dens,state_all,tauabs,
     &          V_hubbard,vr,vrato,v0bd,xyz)

 
      use declarations
      implicit real(kind=db) (a-h,o-z)

      logical Absorbeur, ecomp, ecompe, ecompr, Full_atom,
     &        green, green_plus, hubb, hubb_m, hubbard, 
     &        octupole, relativiste,    
     &        solsing, spherical_tensor, spinorbite, solsing_bess

      complex(kind=db):: fnormc, integr_sing, z
      complex(kind=db), dimension(0:lmax):: bess, neum
      complex(kind=db), dimension(nspin):: e1, e2, konde, s1, s2
      complex(kind=db), dimension(nspin,nspin):: ampl, taug, uu
      complex(kind=db), dimension(nlmam,nspin,nspin):: amplitg
      complex(kind=db), dimension(nspin):: sing
      complex(kind=db), dimension(nlmam,nspin,nspin,3,nbseuil):: singul
      complex(kind=db), dimension(2,0:lmax,nspin):: bs, bssing, neuing,
     &                                              nm
      complex(kind=db),
     &     dimension(nlmagm,nspin,nspin,n_atom_0:n_atom_ind):: tauabs
      complex(kind=db), dimension(nlmam,nspin,nspin,0:3,nbseuil):: rof
      complex(kind=db), dimension(0:nrm_self,id0:id,nspin,
     &    nspino,nspino,n_atom_0_self:n_atom_ind_self):: rhov_self
      complex(kind=db), dimension(n_atom_0:n_atom_ind,nlmmax,nspin, 
     &                           nspino,nspino):: rofsd

      complex(kind=db), dimension(:,:,:), allocatable :: us
      complex(kind=db), dimension(:), allocatable:: f_reg, f_irg 
      complex(kind=db), dimension(-m_hubb:m_hubb,nspino,-m_hubb:m_hubb,
     &        nspino,nspin,n_atom_0_self:n_atom_ind_self):: rofsd_hd

      integer mm(2), mmh(2)
      integer, dimension(nspino):: iso
      integer, dimension(natome):: iaprotoi, nbord
      integer, dimension(nbtm,natome):: ibord
      
      logical:: cal_xanes, hubb_pot, hubb_self, self, State_dens,
     &          State_all

      real(kind=db):: konder
      real(kind=db), dimension(2):: faa
      real(kind=db), dimension(3):: ps, w, x
      real(kind=db), dimension(0:lmax):: bessr, neumr
      real(kind=db), dimension(nspin):: ecinetic, vmax, v0bd
      real(kind=db), dimension(nbseuil):: vecond
      real(kind=db), dimension(nrm):: psii
      real(kind=db), dimension(npoint,nspin):: vr
      real(kind=db), dimension(3,natome):: Axe_Atom_Clui, posi
      real(kind=db), dimension(4,npsom):: xyz
      real(kind=db), dimension(0:nrm):: rato
      real(kind=db), dimension(-m_hubb:m_hubb,nspin):: V_hubb
      real(kind=db), dimension (-m_hubb:m_hubb,-m_hubb:m_hubb,
     &    nspin,n_atom_0_self:n_atom_ind_self) :: Int_dens_all
      real(kind=db), dimension(0:nrm,nspin):: vrato 
      real(kind=db), dimension(nlmmax,nspin,n_atom_0:n_atom_ind)::
     &                                                    singulsd
      real(kind=db), dimension(0:nrm_self,id0:id,nspin, 
     &                      n_atom_0_self:n_atom_ind_self):: sing_self
      real(kind=db), dimension(nphiato1,nphiato20:nphiato2,nphiato3,
     &                 nphiato4,nphiato5,nphiato6):: phiato
      real(kind=db), dimension(:,:), allocatable :: g0, gm, gp, gso
      real(kind=db), dimension(:), allocatable ::
     &      cgradm, cgradp, cgrad0, claplm, claplp, clapl0, fct, f2,
     &      phi, r, rr, tcent, t, tt
      real(kind=db), dimension(:,:), allocatable:: ui, ur, v
      real(kind=db), dimension(:,:,:), allocatable:: uis, urs
      real(kind=db), dimension(:,:,:,:), allocatable:: uiss, urss

      common/ad/ ad
      common/eseuil/ eseuil(2)
      common/icheck/ icheck(24)
      common/iopsymp/ iopsymp(nopsm)
      common/lseuil/ jseuil, lseuil, nseuil
      common/solsing_bess/ solsing_bess 
      common/spheric/ spherical_tensor 
      common/v_intmax/ v_intmax

      if( ( icheck(18) > 0 .and. cal_xanes  ) .or.
     &         ( .not. cal_xanes .and. icheck(18) > 1) ) then
        if( absorbeur ) write(3,110)
        write(3,120) iapr, numat, lmax
      endif

      solsing_bess = .false.
!      solsing_bess = .true.
      self = .not. cal_xanes
      hubb_pot = iapr <= n_atom_ind_self .and. hubb
      hubb_self = hubb_pot .and. self 

      if( abs(eimag) > eps10 .or. ecinetic(1) < eps10
     &     .or. ecinetic(nspin) < eps10 ) then
        ecomp = .true.
      else
        ecomp = .false.
      endif
      ecompe = ecomp
      ecompr = ecomp

      if( octupole ) then
        ip_max = 3
      else
        ip_max = 2
      endif

      iso(1) = 2
      iso(nspino) = 1

! alfa = e*e/(2*epsilon0*h*c) = 0.0072973531 = 1/137.036 est la
! constante de structure fine.
      alfa = 0.0072973531
      a2s4 = 0.25 * alfa**2

      if( Full_atom ) then
        ia = iapr
      else
        do ia = 1,natome
          if( iaprotoi(ia) == ipr ) exit
        end do
        if( ia == natome+1 ) then
          do ia = 1,natome
            if( iaprotoi(ia) == ipr0 ) exit
          end do
        endif
      endif

      if( hubb_pot ) then

        V_hubb(:,:) = 0._db
        l = l_hubbard( numat )
        do m = - l,l 
          do isp = 1,nspin
            V_hubb(m,isp) = - 0.5_db * V_hubbard 
     &                    * ( nspin * Int_dens_all(m,m,isp,iapr) - 1 )
          end do
        end do

        if( ( icheck(18) > 0 .and. cal_xanes  ) .or.
     &         ( .not. cal_xanes .and. icheck(18) > 1) ) then
          write(3,130) l
          do m = - l,l 
            write(3,140) m, V_hubb(m,:)*rydb
          end do
        endif

      end if

! Maillage du rayon et potentiel

      nr = nrato

! Il faut eventuellement extrapoler jusqu'au point le plus loin
      rmax = max( rmtsd, rmtg ) + eps10

      if( .not. green ) then
        do ia = 1,natome
          if( iaprotoi(ia) == ipr ) then
            ps(1:3) = posi(1:3,ia)
            do ib = 1,nbord(ia)
              i = ibord(ib,ia)
              x(1:3) = xyz(1:3,i)
              call posrel(x,ps,w,rrel,isym)
              if( rrel > rmax ) then
                rmax = rrel
                iii = i
              endif
            end do
          endif
        end do
      else
        iii = nr
      endif

      if( rmax > rato(nr) ) then
        rextra = rmax - rato(nr)
        vmax(:) = vr(iii,:)
        n = int( rextra / ( rato(nr) - rato(nr-1) ) ) + 1
        nr = nr + n
      endif

      allocate( r(0:nr+1) )
      allocate( g0(nr,nspin) ); allocate( gm(nr,nspin) )
      allocate( gp(nr,nspin) );
      allocate( cgradm(nr) ); allocate( cgradp(nr) )
      allocate( cgrad0(nr) ); allocate( claplm(nr) )
      allocate( claplp(nr) ); allocate( clapl0(nr) )
      allocate( f2(nr) )
      allocate( tcent(nr) )
      allocate( v(nr,nspin) )
      if( spinorbite )  allocate( gso(nr,nspino) )

      r(1:nrato) = rato(1:nrato)
      r(0) = r(1)**2 / r(2)
      v(1:nrato,:) = vrato(1:nrato,:)

      if( rmax > rato(nrato) ) then
        dh = rextra / n
        do ir = nr-n+1, nr
          r(ir) = r(ir-1) + dh
          p2 = ( r(ir) - rato(nrato) ) / rextra
          p1 = 1._db - p2
          v(ir,:) = p1 * v(nrato,:) + p2 * vmax(:)
        end do
      endif

      if( v_intmax < 1000._db ) then
        do ispin = 1,nspin
          do ir = 1,nr
            v(ir,ispin) = min( v(ir,ispin), v_intmax )
          end do
        end do 
      endif

      do ir = 1,nr
        if( r(ir) > rmtsd + eps10 ) exit
      end do
      nrmtsd = ir

      rmtgg = rmtg
      do ir = 1,nr
        if( r(ir) > rmtgg-eps10 ) exit
      end do
      nrmtgg = ir
      if( green ) then
        do ispin = 1,nspin
          v(nrmtgg:nr,ispin) = v0bd(ispin)
        end do
      endif

      if( icheck(18) > 2 ) then
        if( nspin == 2 ) then
          write(3,'(/A)') '    Radius         V(up)         V(dn)'
        else
          write(3,'(/A)') '    Radius           V'
        endif
        do ir = 1,nr
          write(3,150) r(ir)*bohr, v(ir,:)*rydb
        end do
      endif

      do ir = 1,nr
        rp = r(ir+1)
        rm = r(ir-1)
        r0 = r(ir)
        dr = 0.5 * ( rp - rm )
        claplm(ir) = 1 / ( ( r0 - rm ) * dr )
        claplp(ir) = 1 / ( ( rp - r0 ) * dr )
        clapl0(ir) = - claplm(ir) - claplp(ir)
        if( spinorbite .or. relativiste ) then
          cgradm(ir) = ( rp - r0 ) / ( ( rm - r0 ) * ( rp - rm ) )
          cgradp(ir) = ( rm - r0 ) / ( ( rp - r0 ) * ( rm - rp ) )
          cgrad0(ir) = - cgradm(ir) - cgradp(ir)
        endif
        f2(ir) = 1 / r(ir)**2
      end do

      if( icheck(18) > 3 .and. spinorbite ) write(3,160)

      do ir = 1,nr
        do is = 1,nspin

          vme = v(ir,is) - enervide
          g0(ir,is) = - clapl0(ir) + vme
          gm(ir,is) = - claplm(ir)
          gp(ir,is) = - claplp(ir)
          if( ir == nr ) cycle

          if( relativiste .or. spinorbite ) then

            bder = 1 / ( 1 - a2s4 * vme )
            if( ir == 1 ) then
              dvr = 2 * numat / r(1)**2
            else
              dvr = cgradm(ir) * v(ir-1,is)
     &            + cgrad0(ir) * v(ir,is)
     &            + cgradp(ir) * v(ir+1,is)
            endif
            fac = a2s4 * bder * dvr

            if( relativiste ) then
              g0(ir,is) = g0(ir,is) - a2s4 * vme**2
     &                   - fac * ( cgrad0(ir) - 1 / r(ir) )
              gm(ir,is) = gm(ir,is) - fac * cgradm(ir)
              gp(ir,is) = gp(ir,is) - fac * cgradp(ir)
            endif
            if( spinorbite ) gso(ir,is) = fac / r(ir)

            if( icheck(18) > 3 .and. is == 1 ) then
              x1 = g0(ir,is) * r(ir)
              x2 = vme * r(ir)
              x3 = f2(ir) * r(ir)
              x4 = - a2s4 * vme**2 * r(ir)
              x5 = - fac * ( cgrad0(ir) - 1 / r(ir) ) * r(ir)
              if( spinorbite ) then
                x6 = gso(ir,is) * r(ir)
              else
                x6 = 0._db
              endif
              x7 = gm(ir,is) * r(ir)
              x8 = - fac * cgradm(ir) * r(ir)
              write(3,170) r(ir)*bohr, x1, x2, x3, x4, x5, x6, x7, x8,
     &                     dvr, bder
            endif

          endif

        end do
      end do

      if( nspin == 2 .and. .not. spinorbite ) then
        nspinorb = 2
      else
        nspinorb = 1
      endif

      do iseuil = 1,nbseuil
        ephoton = energ + eseuil(iseuil)
! Terme multiplicatif pour les transitions quadrupolaires
! En S.I. vecond = k = E*alfa*4*pi*epsilon0 / (e*e)
! En ua et rydb : k = 0.5 * alfa * E
        vecond(iseuil) = 0.5 * alfa * ephoton
      end do

      amplitg(:,:,:) = (0._db,0._db)

      if( ( state_dens .and. Absorbeur ) .or. State_all .or. self ) then
        rofsd(iapr,:,:,:,:) = (0._db,0._db)
        if( solsing ) singulsd(:,:,iapr) = 0._db
      endif

      if( self ) then
        rhov_self(:,:,:,:,:,iapr) = (0._db,0._db)
        sing_self(:,:,:,iapr) = 0._db
      endif

      allocate( ur(0:nr,nspin) )
      allocate( urs(0:nr,nspin,nspin) )
      allocate( uis(0:nr,nspin,nspin) )
      uis(:,:,:) = 0._db
      if( ecomp ) allocate( ui(0:nr,nspin) )

      if( hubb_self ) then
        rofsd_hd(:,:,:,:,:,iapr) = (0._db,0._db)
        allocate( urss(nr,-m_hubb-1:m_hubb,nspin,nspin) ) 
        allocate( uiss(nr,-m_hubb-1:m_hubb,nspin,nspin) )
        urss(:,:,:,:) = 0._db 
        if( ecomp) uiss(:,:,:,:) = 0._db
      endif

! Bessel et Neuman aux rayons Rmtg et Rmtsd

      do isp = 1,nspin

        if( ecompe ) then
          konder = real( abs(konde(isp)),db )
        else
          konder = sqrt( ecinetic(isp) )
        endif
        fnorm = sqrt( konder / pi )
        fnormc = sqrt( konde(isp) / pi )

        j = 0
        dh = 0.0001_db
        do i = -1,1,2
          j = j + 1
          if( ecomp ) then
            z = konde(isp) * ( rmtgg + i * 0.5_db * dh )
            call cbessneu(fnormc,z,lmax,lmax,bess,neum)
            bs(j,0:lmax,isp) = bess(0:lmax)
            nm(j,0:lmax,isp) = neum(0:lmax)
          else
            zr = konder * ( rmtgg + i * 0.5_db * dh )
            call cbessneur(fnorm,zr,lmax,lmax,bessr,neumr)
            bs(j,0:lmax,isp) = cmplx( bessr(0:lmax), 0._db,db )
            nm(j,0:lmax,isp) = cmplx( neumr(0:lmax), 0._db,db )
          endif
        end do
        do l = 0,lmax
          bs(2,l,isp) = ( bs(2,l,isp) - bs(1,l,isp) ) / dh
          nm(2,l,isp) = ( nm(2,l,isp) - nm(1,l,isp) ) / dh
        end do

        if( ecomp ) then
          z = konde(isp) * rmtgg
          call cbessneu(fnormc,z,lmax,lmax,bess,neum)
          bs(1,0:lmax,isp) = bess(0:lmax)
          nm(1,0:lmax,isp) = neum(0:lmax)
        else
          zr = konder * rmtgg
          call cbessneur(fnorm,zr,lmax,lmax,bessr,neumr)
          bs(1,0:lmax,isp) = cmplx( bessr(0:lmax), 0._db,db )
          nm(1,0:lmax,isp) = cmplx( neumr(0:lmax), 0._db,db )
        endif

        if( solsing ) then

          n = max(nrmtsd,nrmtgg)
          do jr = 1,2
            if( ecomp ) then
              z = konde(isp) * r(n-1+jr)
              call cbessneu(fnormc,z,lmax,lmax,bess,neum)
              bssing(jr,0:lmax,isp) = bess(0:lmax)
              neuing(jr,0:lmax,isp) = neum(0:lmax)
            else
              zr = konder * r(n-1+jr)
              call cbessneur(fnorm,zr,lmax,lmax,bessr,neumr)
              bssing(jr,0:lmax,isp) = cmplx( bessr(0:lmax), 0._db,db )
              neuing(jr,0:lmax,isp) = cmplx( neumr(0:lmax), 0._db,db )
            endif
          end do

        endif

      end do

      do l = 0,lmax

        if( hubb_pot .and. l == l_hubbard( numat ) )  then
          hubb_m = .true.
        else
          hubb_m = .false.
        endif  

        l2 = l * ( l + 1 )
        lm0 = l2 + 1
        tcent(1:nr) = l2 * f2(1:nr)

        ur1 = r(1)**(l+1)

! La continuite est : amp * ur(r) = bessel(r) - i * tau * hankel_sortant
! Donc tau = k * tau_habituel
        do isp = 1,nspin
          e1(isp) = bs(1,l,isp)
          e2(isp) = bs(2,l,isp)
          s1(isp) = - img * bs(1,l,isp) + nm(1,l,isp)
          s2(isp) = - img * bs(2,l,isp) + nm(2,l,isp)
        end do

        if( spinorbite ) then
          nm1 = - l - 1
          nm2 = l
        elseif( hubb_m ) then
          nm1 = - l
          nm2 = l
        else
          nm1 = 0
          nm2 = 0
        endif
               
        do m = nm1,nm2

          if( hubb_m ) then
            lm1 = lm0 + m
            lm2 = lm0 + m
          else
            lm1 = lm0 - l
            lm2 = lm0 + l
          endif

          mm(1) = m
          mmh(1) = m
          if( spinorbite ) then
            mm(2) = - ( m + 1 )
            mmh(2) = m + 1
          else
            mm(2) = m
            mmh(2) = m
          endif

          if( m == nm1 .or. m == nm2 .or. .not. spinorbite ) then
            nsol = 1
          else
            nsol = 2
          endif

          urs(:,:,:) = 0._db
          if( ecomp ) uis(:,:,:) = 0._db

          do isol = 1,nsol   ! boucle sur les 2 solutions a l'origine

            if( relativiste ) then
              if( .not. spinorbite ) then
                p = sqrt( l**2 + l + 1 - ( alfa * numat )**2 )
              elseif( isol == 1 .or. nsol == 1 ) then
                p = sqrt( ( l + 1 )**2 - ( alfa * numat )**2 )
              else
                p = sqrt( l**2 - ( alfa * numat )**2 )
              endif
            else
              if( nsol == 1 ) then
                p = l + 1._db
              elseif( isol == 1 ) then
                p = 0.5 + 0.5 * sqrt( 1. + 4*(l**2) + 8*l )
              else
                if( l == 1 ) then
! En fait, il n'y a pas de solution pour l=1 avec spin-orbite non
! relativiste !
!                  p = 1._db * l
                  p = l + 1._db
                else
                  p = 0.5 + 0.5 * sqrt( -5._db + 4*(l**2) )
                endif
              endif
            endif

            if( nsol == 1 ) then

              do ispinorb = 1,nspinorb

                if( spinorbite ) then
                  if( m == nm1 ) then
                    isp = nspino
                  else
                    isp = 1
                  endif
                else
                  isp = ispinorb
                endif

                br = - numat / ( l + 1._db )
                Er = sum( ecinetic(:) ) / nspin
                cr = - ( 2 * numat * br + Er ) / ( 4 * l + 6 )  
                ur(0,isp) = ur1 * ( 1._db + br * r(0) + cr * r(0)**2 )
     &                          * ( r(0) / r(1) )**p
                ur(1,isp) = ur1 * ( 1._db + br * r(1) + cr * r(1)**2  )
                if( ecomp ) then
                  ci = - Eimag / ( 4 * l + 6 )  
                  ui(0,isp) = ur1 * ci * r(0)**2 * ( r(0) / r(1) )**p
                  ui(1,isp) = ur1 * ci * r(1)**2
                endif 

                do ir = 1,nr-1
                  im = ir - 1
                  ip = ir + 1
                  if( spinorbite .and. mm(isp) /= 0 ) then
                    td = g0(ir,isp) + tcent(ir) + mm(isp) * gso(ir,isp)
                  else
                    td = g0(ir,isp) + tcent(ir)
                  endif
                  if( hubb_m ) td = td + V_hubb(mmh(isp),isp)

                  if( ecomp .and. .not. ecompr ) then
                    ur(ip,isp) = - ( td * ur(ir,isp)  
     &                         + gm(ir,isp) * ur(im,isp) ) / gp(ir,isp)
                    ui(ip,isp) = - ( td * ui(ir,isp)  
     &                         + gm(ir,isp) * ui(im,isp) ) / gp(ir,isp)

                  elseif( ecomp ) then
                    ur(ip,isp) = - ( td * ur(ir,isp) + eimag *ui(ir,isp) 
     &                         + gm(ir,isp) * ur(im,isp) ) / gp(ir,isp)
                    ui(ip,isp) = - ( td * ui(ir,isp) - eimag *ur(ir,isp) 
     &                         + gm(ir,isp) * ui(im,isp) ) / gp(ir,isp)

                  else
                    ur(ip,isp) = - ( td * ur(ir,isp)
     &                         + gm(ir,isp) * ur(im,isp) ) / gp(ir,isp)
                  endif

                end do

                urs(1:nr,isp,isp) = ur(1:nr,isp)
                if( ecomp ) uis(1:nr,isp,isp) = ui(1:nr,isp)

              end do

            else

              faa(1) = sqrt( ( l - mm(isol) ) / ( 2*l + 1. ) )
              faa(2) = ( (-1)**isol )
     &               * sqrt( ( l + mm(isol) + 1. ) / ( 2*l + 1. ) )

              do isp = 1,2
                ur(1,isp) = ur1
                ur(0,isp) = ur1 * ( r(0) / r(1) )**p
                ur(0:1,isp) = faa(isp) * ur(0:1,isp)
              end do
              if( ecomp ) ui(0:1,:) = 0._db

              fac = sqrt( ( l - m ) * ( l + m + 1._db ) )

              do ir = 1,nr-1
                im = ir - 1
                ip = ir + 1
                do isp = 1,2
                  if( mm(isp) == 0 ) then
                    td = g0(ir,isp) + tcent(ir)
                  else
                    td = g0(ir,isp) + tcent(ir) + mm(isp) * gso(ir,isp)
                  endif
                  if( hubb_m ) td = td + V_hubb(mmh(isp),isp)

                  if( ecomp .and. .not. ecompr ) then
                    ur(ip,isp) = - ( td * ur(ir,isp)  
     &                         + gm(ir,isp) * ur(im,isp) 
     &                         + fac * gso(ir,isp) * ur(ir,iso(isp)) )
     &                         / gp(ir,isp)
                    ui(ip,isp) = - ( td * ui(ir,isp)  
     &                         + gm(ir,isp) * ui(im,isp) 
     &                         + fac * gso(ir,isp) * ui(ir,iso(isp)) )
     &                         / gp(ir,isp)

                  elseif( ecomp ) then
                    ur(ip,isp) = - ( td * ur(ir,isp) + eimag *ui(ir,isp) 
     &                         + gm(ir,isp) * ur(im,isp) 
     &                         + fac * gso(ir,isp) * ur(ir,iso(isp)) )
     &                         / gp(ir,isp)
                    ui(ip,isp) = - ( td * ui(ir,isp) - eimag *ur(ir,isp) 
     &                         + gm(ir,isp) * ui(im,isp) 
     &                         + fac * gso(ir,isp) * ui(ir,iso(isp)) )
     &                         / gp(ir,isp)

                  else
                    ur(ip,isp) = - ( td * ur(ir,isp)
     &                         + gm(ir,isp) * ur(im,isp)
     &                         + fac * gso(ir,isp) * ur(ir,iso(isp)) )
     &                         / gp(ir,isp)
                  endif


                end do
              end do

              do isp = 1,nspino
                urs(1:nr,isp,isol) = ur(1:nr,isp)
                if( ecomp ) uis(1:nr,isp,isol) = ui(1:nr,isp)
              end do

            endif

          end do   ! fin de la boucle sur les solutions

          if( icheck(18) > 2 ) then
            ipas = 10
            if( icheck(18) > 3 ) ipas = 1
            if( spinorbite .or. hubb_m ) then
              write(3,180) l, m, numat
            else
              write(3,190) l, numat
            endif
            if( spinorbite ) then
              if( ecomp ) then
                write(3,200)
              else
                write(3,210)
              endif
            else
              if( ecomp ) then
                write(3,'(A)') '     Radius          ur          ui'
              else
                write(3,'(A)') '     Radius          ur'
              endif
            endif
            do ir = 1,nr,ipas
              if( spinorbite ) then
                if( ecomp ) then
                  write(3,220) r(ir)*bohr, ( ( urs(ir,isp,i),
     &                    uis(ir,isp,i), isp = 1,nspin ), i = 1,nspin)
                else
                  write(3,220) r(ir)*bohr,
     &                        ( urs(ir,1:nspin,i), i = 1,nspin )
                endif
              else
                if( ecomp ) then
                  write(3,220) r(ir)*bohr, ( urs(ir,isp,isp),
     &                    uis(ir,isp,isp), isp = 1,nspin )
                else
                  write(3,220) r(ir)*bohr,
     &                        ( urs(ir,isp,isp), isp = 1,nspin )
                endif
              endif
            end do
          endif

          if( spinorbite ) then
            do isol = 1,nspino  ! boucle sur les 2 solutions a l'origine
              do isp = 1,nspino
                if( ( ( m == nm1 .and. isp == 1 ) .or.
     &               ( m == nm2 .and. isp == 2 ) ) ) cycle
                urs(1:nr,isp,isol) = urs(1:nr,isp,isol) / r(1:nr)
                if(ecomp) uis(1:nr,isp,isol) =uis(1:nr,isp,isol)/r(1:nr)
              end do
            end do   ! fin de la boucle sur les solutions
          else
            do isp = 1,nspin
              urs(1:nr,isp,isp) = urs(1:nr,isp,isp) / r(1:nr)
              if( ecomp ) uis(1:nr,isp,isp) = uis(1:nr,isp,isp) /r(1:nr)
            end do
          endif

          if( ecomp ) then
            call renormalc(ampl,taug,m,nm1,nm2,nspin,uis,urs,r,
     &                      nrmtgg,nr,rmtgg,s1,s2,e1,e2,spinorbite)
          else
            call renormal(ampl,taug,m,nm1,nm2,nspin,urs,r,
     &                      nrmtgg,nr,rmtgg,s1,s2,e1,e2,spinorbite)
          endif
 
! Renormalisation des fonctions d'onde :
! Le deuxieme indice va correspondre a la solution correspondant au spin
! d'attaque.
          if( spinorbite ) then
            do ir = 1,nr
              if( ecomp ) then
                uu(:,:) = cmplx( urs(ir,:,:), uis(ir,:,:),db )
              else
                uu(:,:) = cmplx( urs(ir,:,:), 0._db,db )
              endif
              do isp = 1,nspino  ! spin de la fonction d'onde
                do isq = 1,nspino ! spin d'attaque (du bessel attaquant)
                  z = sum( ampl(isq,:) * uu(isp,:) )
                  urs(ir,isp,isq) = real( z,db )
                  if( ecomp ) uis(ir,isp,isq) = aimag( z )
                end do
              end do
            end do
          else
            do ir = 1,nr
              do isp = 1,nspin
                if( ecomp ) then
                  z = cmplx( urs(ir,isp,isp), uis(ir,isp,isp),db )
     &              * ampl(isp,isp) 
                  urs(ir,isp,isp) = real( z,db )  
                  uis(ir,isp,isp) = aimag( z )
                else
                  urs(ir,isp,isp) = urs(ir,isp,isp)
     &                            * real( ampl(isp,isp),db )  
                endif
              end do
            end do
          endif
      
          if( spinorbite ) then
            do isp1 = 1,nspino
              m1 = m + isp1 - 1
              if( m1 < -l .or. m1 > l ) cycle
              lm1 = lm0 + m1
              do isp2 = 1,nspino
                m2 = m + isp2 - 1
                if( m2 < -l .or. m2 > l ) cycle
                tauabs(lm1,isp1,isp2,iapr) = taug(isp1,isp2)
                if( Absorbeur .and. green )
     &              amplitg(lm1,isp1,isp2) = ampl(isp1,isp2)
              end do
            end do
          else
            do lm = lm1,lm2
              do isp = 1,nspin
                tauabs(lm,isp,isp,iapr) = taug(isp,isp)
                if( Absorbeur .and. green )
     &            amplitg(lm,isp,isp) = ampl(isp,isp)
              end do
            end do
          endif

! Integrale radiale pour la regle d'or de Fermi
          if( Absorbeur ) call radial_matrix(ecomp,green_plus,
     &          ip_max,lm0,lm1,lm2,m,nbseuil,nlmam,nm1,nm2,nr,nrm,
     &          nrmtsd,nspin,nspino,psii,r,rmtsd,rof,Spinorbite,uis,urs,
     &          vecond)

! Integrale radiale pour la densite d'etat
          if( ( state_dens .and. Absorbeur ) .or. State_all .or. self )
     &      call radial_stdens(Ecomp,hubbard,iapr,id0,id,l,
     &           lm,lm0,lm1,lm2,m,n_atom_0,n_atom_0_self,n_atom_ind,
     &           n_atom_ind_self,nlmmax,nm1,nm2,nr,
     &           nrm_self,nrmtsd,nspin,nspino,r,rhov_self,rmtsd,rofsd,
     &           self,Spinorbite,uis,urs)

! Recopies pour Hubbard:
          if( hubb_m .and. hubb_self ) then
            urss(1:nr,m,:,:) = urs(1:nr,:,:)
            if( ecomp ) uiss(1:nr,m,:,:) = uis(1:nr,:,:)
          end if

! Calcul de la solution singuliere
          if( solsing .and. (Absorbeur .or. self .or. state_all) ) then
!          if( ( solsing .and. Absorbeur ) .or. 
!     &        ( ecomp .and. ( self .or. ( state_dens .and. Absorbeur)
!     &            .or. state_all ) ) ) then

            n = max(nrmtsd,nrmtgg) 
            allocate( f_reg(n) )
            allocate( f_irg(n) )
            allocate( rr(n) )
            allocate( phi(n) )
            allocate( us(n+1,nspin,nspin) )

            rr(1:n) = r(1:n) 

            us(:,:,:) = (0._db,0._db)

            if( nsol == 1 ) then

              do ispinorb = 1,nspinorb

                if( spinorbite .and. m == nm1 ) then
                  isp = nspino
                else
                  isp = ispinorb
                endif

                if( solsing_bess ) then
                  us(n,isp,isp) = - bssing(1,l,isp) * r(n) 
                  us(n+1,isp,isp) = - bssing(2,l,isp) * r(n+1)
                else
                  us(n,isp,isp) = taug(isp,isp) * ( neuing(1,l,isp)
     &                          - img * bssing(1,l,isp) ) * r(n) 
                  us(n+1,isp,isp) = taug(isp,isp) * ( neuing(2,l,isp)
     &                            - img * bssing(2,l,isp) ) * r(n+1)
                endif

                do ir = n,2,-1
                  im = ir - 1
                  ip = ir + 1
                  td = g0(ir,isp) + tcent(ir)
                  if( hubb_m .and. ir < n )
     &              td = td + V_hubb(mmh(isp),isp)
                  if( ecomp .and. .not. ecompr ) then  
                    us(im,isp,isp) = - ( td * us(ir,isp,isp) 
     &                      + gp(ir,isp) * us(ip,isp,isp) ) / gm(ir,isp)
                  elseif( ecomp ) then  
                    us(im,isp,isp) = - ( (td - img*eimag)*us(ir,isp,isp) 
     &                      + gp(ir,isp) * us(ip,isp,isp) ) / gm(ir,isp)
                  else
                    us(im,isp,isp) = - ( td * us(ir,isp,isp) 
     &                      + gp(ir,isp) * us(ip,isp,isp) ) / gm(ir,isp)
                  endif
                end do

              end do

            else
              
              fac = sqrt( ( l - m ) * ( l + m + 1._db ) )

              do isp = 1,nspino  ! spin d'attaque

                if( solsing_bess ) then
                  us(n,isp,isp) = - bssing(1,l,isp) * r(n)
                  us(n+1,isp,isp) = - bssing(2,l,isp) * r(n+1)
                  ispp = 3 - isp
                  us(n,ispp,isp) = - bssing(1,l,ispp) * r(n)
                  us(n+1,ispp,isp) = - bssing(2,l,ispp) * r(n+1)
                else
! Attention que la solution singuliere est deja multipliee par tau !
                  us(n,isp,isp) = taug(isp,isp) * ( neuing(1,l,isp)
     &                          - img * bssing(1,l,isp) ) * r(n)
                  us(n+1,isp,isp) = taug(isp,isp) * ( neuing(2,l,isp)
     &                          - img * bssing(2,l,isp) ) * r(n+1)
                  ispp = 3 - isp
                  us(n,ispp,isp) = taug(isp,ispp)  * ( neuing(1,l,ispp)
     &                           - img * bssing(1,l,ispp) ) * r(n)
                  us(n+1,ispp,isp) = taug(isp,ispp) * ( neuing(2,l,ispp)
     &                           - img * bssing(2,l,ispp) ) * r(n+1)
                endif

                do ir = n,2,-1
                  im = ir - 1
                  ip = ir + 1
 
                  do isq = 1,2   ! spin interne (spin reel)

                    td = g0(ir,isq) + tcent(ir)
                    if( mm(isq) /= 0 ) td = td  + mm(isq) * gso(ir,isq) 

                    if( hubb_m .and. ir < n )
     &                td = td + V_hubb(mmh(isq),isq)

                    if( ecomp .and. .not. ecompr ) then
                      us(im,isq,isp) =
     &                     - ( td * us(ir,isq,isp) 
     &                           + gp(ir,isq) * us(ip,isq,isp) 
     &              + fac * gso(ir,isq) * us(ir,iso(isq),isp) )
     &                               / gm(ir,isq)

                    elseif( ecomp ) then
                      us(im,isq,isp) =
     &                     - ( ( td - img * eimag ) * us(ir,isq,isp) 
     &                           + gp(ir,isq) * us(ip,isq,isp) 
     &              + fac * gso(ir,isq) * us(ir,iso(isq),isp) )
     &                               / gm(ir,isq)

                    else
                      us(im,isq,isp) = - ( td * us(ir,isq,isp) 
     &                         + gp(ir,isq) * us(ip,isq,isp) 
     &              + fac * gso(ir,isq) * us(ir,iso(isq),isp) )
     &                               / gm(ir,isq)
                    endif

                  end do

                end do
              end do

            endif

            if( solsing .and. Absorbeur ) then
! Le cas du dipole-octupole, c'est dipole bra - octupole ket.
              do ip = 1,ip_max  ! boucle sur dipole, quadrupole, octupole

                sing(:) = (0._db,0._db)

                phi(1:n) = psii(1:n) * r(1:n)**ip

                do isp = 1,nspin
                  if( spinorbite ) then
                    mv = m + isp - 1
                    if( mv < - l .or. mv > l ) cycle
                    lm = lm0 + mv  ! correspond au lm vrai
                  endif
! us est en fait r*us, mais urs n'est pas multiplie par r.
                  do isq = 1,nspin
                    if( spinorbite .and. ( m == nm1 .or. m == nm2 )
     &                    .and. isq /= isp ) cycle

! Solutions regulieres et irregulieres multipliees par r.
                    if( ecomp ) then
                      f_reg(1:n) = cmplx( urs(1:n,isp,isq),
     &                                    uis(1:n,isp,isq),db ) * r(1:n)
                    else
                      f_reg(1:n) = cmplx( urs(:,isp,isq), 0._db,db )
     &                             * r(1:n)
                    endif
! La solution irreguliere est multipliee par tau.
                    f_irg(1:n) = us(1:n,isp,isq)  
                    sing(isp) = sing(isp)
     &                        + integr_sing(n,phi,f_reg,f_irg,rmtsd,rr)

                  end do 
                end do 
                
                do iseuil = 1,nbseuil
                  if( ip == 1 ) then
                    f = 1._db
                  elseif( ip == 2 ) then
                    f = (0.5 * vecond(iseuil))**2
                  else
! Pour ip = 3, correspond en fait a la normalisation du terme
! dipole-octupole
                    f = - ( 1._db / 6 ) * vecond(iseuil)**2 
                  endif
                  do isp = 1,nspin
                    if( spinorbite ) then
                      mv = m + isp - 1
                      if( mv < - l .or. mv > l ) cycle
                      lm = lm0 + mv  ! correspond au lm vrai
                      singul(lm,isp,isp,ip,iseuil) = f * sing(isp)
                    else 
                      singul(lm1:lm2,isp,isp,ip,iseuil) = f * sing(isp)
                    endif
                  end do
                end do

              end do ! fin boucle dipole, quadrupole

            endif

            deallocate( phi )
            deallocate( f_reg )
            deallocate( f_irg )

! Calcul de la partie singuliere de la densite d'etat
            if( ecomp .and. ( self .or. ( state_dens .and. Absorbeur)
     &            .or. state_all ) ) then

              allocate( fct(n) )
              allocate( t(n) ) ; allocate( tt(n) )
              do isp = 1,nspin
                if( spinorbite ) then
                  mv = m + isp - 1
                  if( mv < - l .or. mv > l ) cycle
                  lm = lm0 + mv  ! correspond au lm vrai
                endif
! us est en fait r*us, mais urs n'est pas multiplie par r.
                do isq = 1,nspin
                  if( spinorbite .and. ( m == nm1 .or. m == nm2 )
     &                  .and. isq /= isp ) cycle
! La solution singuliere contient la multiplication par tau !
! Ici on prend r = r', car on calcule la trace de G(r,r')
! On ne calcule que la partie imaginaire.
                  t(1:n) = ( urs(1:n,isp,isq) * aimag(us(1:n,isp,isq))
     &                  + uis(1:n,isp,isq) * real(us(1:n,isp,isq),db) )
                  fct(1:n) = t(1:n) * r(1:n)
                  tt(1:n) = t(1:n) / ( quatre_pi * r(1:n) )
                  
                  radl = f_integr3(rr,fct,n,1,n,rmtsd)

                  if( spinorbite ) then
                    singulsd(lm,isp,iapr) =
     &                       singulsd(lm,isp,iapr) - radl
                    if( self ) sing_self(1:n,lm,isp,iapr) =
     &                       sing_self(1:n,lm,isp,iapr) - tt(1:n)
                  else
                    singulsd(lm1:lm2,isp,iapr) = 
     &                        singulsd(lm1:lm2,isp,iapr) - radl
                    if( self ) then
                      do ir = 1, n
                        if ( hubbard ) then
                          sing_self(ir,lm1:lm2,isp,iapr) =
     &                    sing_self(ir,lm1:lm2,isp,iapr) - tt(ir)
                        else
                          sing_self(ir,l,isp,iapr) =
     &                      sing_self(ir,l,isp,iapr) - tt(ir)
                       end if
                      end do
                    endif
                  endif  

                end do
              end do
              deallocate( fct )
              deallocate( t ); deallocate( tt )

            endif
           
            if( icheck(18) > 3 ) then
              if( spinorbite ) then
                write(3,250) l, m, numat
              else
                write(3,260) l, numat
              endif
              do ir = 1,n
                if( spinorbite ) then
                  write(3,220) r(ir)*bohr, (us(ir,:,isp), isp =1,nspino)
                else
                  write(3,220) r(ir)*bohr, (us(ir,isp,isp), isp=1,nspin)
                endif
              end do
            endif
            if( icheck(18) > 1 .and. self ) then
              if( spinorbite ) then
                write(3,180) l, m, numat
              else
                write(3,190) l, numat
              endif
              if( nspin == 2 ) then
                write(3,263)
              else
                write(3,264)
              endif
              if( spinorbite ) then
                lms = lm
              elseif( hubbard ) then
                lms = l**2 + l + 1 + m
              else
                lms = l
              endif
              do ir = 1,n
                f = quatre_pi* r(ir)**2 
                write(3,220) r(ir)*bohr, 
     &            ( f * sing_self(ir,lms,isp,iapr),
     &              isp = 1,nspin ),
     &            ( f * rhov_self(ir,lms,isp,isp,isp,iapr),
     &              isp = 1,nspin )
              end do
            endif

            deallocate( us )
            deallocate( rr )

          endif

! Interpolation pour avoir les fonctions radiales phiato.
          if( .not. green ) then
            if( m == nm2 .and. l == lmax ) then
              iwrite = 1
            else
              iwrite = 0
            endif
            do ib = 1,natome
              if( Full_atom ) then
                if( ib > 1 ) exit
                ia = iapr
              else
                ia = ib
                if( iaprotoi(ia) /= ipr ) cycle
              endif
              if( nspin == 2 ) then
                cosang =sum(Axe_Atom_Clui(:,ia)*Axe_Atom_Clui(:,iaabsi)) 
                if( abs(cosang - 1) < eps4 ) then
                  iang = 1
                elseif( abs(cosang + 1) < eps4 ) then
                  iang = -1
                else
                  iang = 0
                endif
              else
                iang = 1
              endif
              call cal_phiato(hubb_m,hubbard,ia,iang,ibord,iwrite,
     &              l,lm0,lm1,lm2,lmax,m,natome,nbord(ia),nbtm,nm1,nm2,
     &              nphiato1,nphiato20,nphiato2,nphiato3,nphiato4,
     &              nphiato5,nphiato6,npsom,nr,nspin,
     &              phiato,posi,r,spinorbite,uis,urs,xyz)
            end do
          endif
        end do   ! fin de la boucle sur m

      end do   ! fin de la boucle sur l

      if( hubb_self ) then

        l = l_hubbard(numat) 
! Integrale radiale non diagonale pour la densite d'etat en cas de
! Hubbard
        call radial_stdens_hubb(Ecomp,iapr,l,m_hubb,n_atom_0_self,
     &               n_atom_ind_self,nr,nrmtsd,nspin,nspino,r,Rmtsd,
     &               rofsd_hd,uiss,urss,Spinorbite)

        deallocate( urss )
        deallocate( uiss )

      endif

      if( ( ( icheck(18) > 0 .and. cal_xanes ) .or.  
     &      ( icheck(18) > 2 .and. self ) ) .and. Absorbeur  ) then

        do iseuil = 1,nbseuil
          if( ecomp ) then
            if( octupole ) then
              write(3,270) iseuil
            else
              write(3,275) iseuil
            endif
          else
            if( octupole ) then
              write(3,280) iseuil
            else
              write(3,285) iseuil
            endif
          endif
          do l = 0,lmax
            if( hubb_pot .and. l == l_hubbard( numat ) )
     &        then
              hubb_m = .true.
            else
              hubb_m = .false.
            endif
            lm0 = l**2 + l + 1
            do m = -l,l
              if( .not. ( spinorbite .or. hubb_m ) .and. m /= 0 ) cycle                                           
              lm = lm0 + m
              do isp = 1,nspin
                do isol = 1,nspin
                  if( .not. spinorbite .and. isp /= isol ) cycle
                  if( ecomp ) then
                    write(3,290) l, m, isp, isol,
     &                           rof(lm,isp,isol,0:ip_max,iseuil)
                  else
                    write(3,300) l, m, isp, isol,
     &                       real(rof(lm,isp,isol,0:ip_max,iseuil),db)
                  endif
                end do
              end do
            end do
          end do
        end do
      endif

      if( icheck(18) > 1 .and. green .and. Absorbeur ) then
        write(3,310)
        do l = 0,lmax
          lm0 = l**2 + l + 1
          if( hubb_pot .and. l == l_hubbard(numat) ) then
            hubb_m = .true.
          else
            hubb_m = .false.
          endif
          do m = -l,l
            if( .not. ( spinorbite .or. hubb_m ) .and. m /= 0 ) cycle                                 
            lm = lm0 + m
            do isp = 1,nspin
              if( spinorbite ) then
                write(3,320) l, m, isp, amplitg(lm,isp,1:nspin)
              else
                write(3,320) l, m, isp, amplitg(lm,isp,isp)
              endif
            end do
          end do
        end do
      endif

      if( icheck(18) > 1 ) then
        if( spinorbite ) then
          write(3,330) 
        else
          write(3,335)
        endif
        do l = 0,lmax
          if( hubb_pot .and. l == l_hubbard( numat ) ) then
            hubb_m = .true.
          else
            hubb_m = .false.
          endif
          lm0 = l**2 + l + 1
          do m = -l,l
            if( .not. ( spinorbite .or. hubb_m ) .and. m /= 0 ) cycle
            lm = lm0 + m
            do isp = 1,nspin
              if( spinorbite ) then
                write(3,320) l, m, isp, tauabs(lm,isp,1:nspin,iapr)
              else
                write(3,320) l, m, isp, tauabs(lm,isp,isp,iapr)
              endif
            end do
          end do
        end do
      endif

      if( icheck(18) > 1 .and. solsing .and. Absorbeur ) then
        do iseuil = 1,nbseuil
          if( octupole ) then
            write(3,340) iseuil
          else
            write(3,345) iseuil
          endif
          do l = 0,lmax
            if( hubb_pot .and. l == l_hubbard( numat ) ) then
              hubb_m = .true.
            else
              hubb_m = .false.
            endif
            lm0 = l**2 + l + 1
            do m = -l,l
              if( .not. ( spinorbite .or. hubb_m ) .and. m /= 0 ) cycle            
              lm = lm0 + m
              do isp = 1,nspin
                if( spinorbite ) then
                  do isol = 1,nspin
                    write(3,290) l, m, isp, isol,
     &                           singul(lm,isp,isol,1:ip_max,iseuil)
                  end do
                else
                  write(3,290) l, m, isp, isp,
     &                           singul(lm,isp,isp,1:ip_max,iseuil)
                endif
              end do
            end do
          end do
        end do
      endif
      if( icheck(18) > 1 .and. ( ( state_dens .and. Absorbeur )
     &                         .or. State_all .or. self ) ) then
        if( solsing ) then
          if( nspin == 2 ) then
            write(3,350)
          else 
            write(3,352)
          endif 
          do l = 0,lmax
            if( hubb_pot .and. l == l_hubbard( numat ) ) then
              hubb_m = .true.
            else
              hubb_m = .false.
            endif
            lm0 = l**2 + l + 1
            do m = -l,l
              if( .not. ( spinorbite .or. hubb_m ) .and. m /= 0 ) cycle                 
              lm = lm0 + m
              write(3,355) l, m, singulsd(lm,1:nspin,iapr)
            end do
          end do
        endif
        if( spinorbite ) then
          write(3,360) 
        else
          write(3,365) 
        endif
        do l = 0,lmax
          if( hubb_pot .and. l == l_hubbard( numat ) ) then
            hubb_m = .true.
          else
            hubb_m = .false.
          endif
          lm0 = l**2 + l + 1
          do m = -l,l
            if( .not. ( spinorbite .or. hubb_m ) .and. m /= 0 )  cycle                             
            lm = lm0 + m
            do isp = 1,nspin
              write(3,370) l, m, isp, rofsd(iapr,lm,isp,:,:)
            end do
          end do
        end do
      endif

      if( icheck(18) > 1 .and. hubb_self ) then
        write(3,705) iapr
        if( spinorbite ) then
          write(3,706)
        else
          write(3,707)
        end if
        do isp = 1, nspin
         do m1 = -m_hubb, m_hubb
          do m2 = -m_hubb, m_hubb
            do i1 = 1, nspino
              do i2 = 1, nspino
                if( spinorbite ) then
                  write(3,710) m1, m2, i1, i2, isp,
     &                        rofsd_hd(m1,i1,m2,i2,isp,iapr)
                else
                  write(3,711) m1, m2, isp,
     &                        rofsd_hd(m1,1,m2,1,isp,iapr)
                end if
              end do
            end do
          end do
         end do
        end do
      end if

      deallocate( r )
      deallocate( g0 );     deallocate( gm )
      deallocate( gp );
      if( spinorbite ) deallocate( gso )
      deallocate( cgradm ); deallocate( cgradp )
      deallocate( cgrad0 ); deallocate( claplm )
      deallocate( claplp ); deallocate( clapl0 )
      deallocate( f2 )
      deallocate( tcent )
      deallocate( ur )
      deallocate( urs )
      deallocate( uis )
      deallocate( v )
      if( ecomp ) deallocate( ui )

      return
  110 format(/' ---- Sphere -------',100('-'))
  120 format(/' iapr =',i3,', Z =',i3,', lmax =',i2)
  130 format(/' Hubbard shifts for l =',i2/'   m       Shift spin up',
     &'    Shift spin down (eV)')
  140 format(i4,2f17.3) 
  150 format(1p,3e14.6)
  160 format(/6x,'r',10x,'g0',8x,'V-E',8x,'1/r2 (a(V-E)/2)**2',
     &        ' f*(d/dr-1/r)   gso         gm      f*cgradm     dvr',
     &'   B(r)    fois r sauf dvr et B(r)')
  170 format(1p,13e11.3)
  180 format(/'  l =',i2,', m =',i2,', Z =',i3)
  190 format(/'  l =',i2,', Z =',i3)
  200 format('     Radius   ',
     &  '    ur(spup,1)    ui(spup,1)    ur(spdn,1)    ui(spdn,1)',
     &  '    ur(spup,2)    ui(spup,2)    ur(spdn,2)    ui(spdn,2)')
  210 format(/5x,'Radius         ur(spup,1)    ur(spdn,1)',
     &           '    ur(spup,2)    ur(spdn,2)')
  220 format(1p,9e14.6)
  250 format(/'  l =',i2,', m =',i2,/
     &  '   Radius',9x,'u_sing(up,up)',11x,'u_sing(dn,up)',11x,
     &  'u_sing(dn,up)',11x,'u_sing(dn,dn)')
  260 format(/'  l =',i2,', Z =',i3,/
     &        '   Radius        u_irreg_r      u_irreg_i')
  263 format(/5x,'Radius',2x,'4pi*r2*sing_self(up)',2x,
     &        '4pi*r2*sing_self(dn)',3x,'4pi*r2*rhov_self(up)',8x,
     &        '4pi*r2*rhov_self(dn)')
  264 format(/5x,'Radius',2x,'4pi*r2*sing_self',1x,'4pi*r2*rhov_self_r',
     &          1x,'4pi*r2*rhov_self_i')
  270 format(/' Radial integral'/,'  l  m  isp isol',10x,'monopole',
     &    17x,'dipole',15x,'quadrupole',15x,'octupole',9x,'iseuil =',i2)
  275 format(/' Radial integral'/,'  l  m  isp isol',10x,'monopole',
     &    17x,'dipole',15x,'quadrupole',9x,'iseuil =',i2)
  280 format(/' Radial integral'/,'  l  m  isp isol',4x,'monopole',
     &    4x,'dipole',4x,'quadrupole',4x,'octupole',5x,'iseuil =',i2)
  285 format(/' Radial integral'/,'  l  m  isp isol',4x,'monopole',
     &    4x,'dipole',4x,'quadrupole',5x,'iseuil =',i2)
  290 format(2i3,2x,2i3,2x,1p,4(2x,2e11.3))
  300 format(2i3,2x,2i3,2x,1p,4e12.3)
  310 format(/' amplitg(isol)',/'  l  m isp',10x,'(1)',18x,'(2)')
  320 format(3i3,1x,1p,4e11.3)
  330 format(/' Atomic scattering amplitude:',/
     &    '  l  m isp',6x,'tauabs(isp,1)',9x,'tauabs(isp,2)')
  335 format(/' Atomic scattering amplitude:',/
     &        '  l  m isp',9x,'tauabs')
  340 format(/' Singular solution :',/'  l  m isp1 isp2',6x,
     &         ' dipole-dipole       quadrupole-quadrupole       ',
     &         'dipole-octupole       iseuil =',i2)
  345 format(/' Singular solution :',/'  l  m isp1 isp2',6x,
     &         ' dipole-dipole       quadrupole-quadrupole       ',
     &         'iseuil =',i2)
  350 format(/' Singular solution for the density of states:',
     &        /'  l  m    Singulsd(1)     Singulsd(2)')
  352 format(/' Singular solution for the density of states:',
     &        /'  l  m      Singulsd')
  355 format(2i3,1p,2e14.3)
  360 format(/' Radial integral for the density of states:',
     &        /'  l  m isp     Rofsd(isp,1,1)',10x,'Rofsd(isp,1,2)',
     &         10x,'Rofsd(isp,2,1)',10x,'Rofsd(isp,2,2)')
  365 format(/' Radial integral for the density of states:',
     &        /'  l  m isp',9x,'Rofsd')
  370 format(3i3,1x,1p,4(2e11.3,2x))
  705 format(/'Rofsd_hd (radial part of the occupation matrix) for ',
     &       /' atom iapr = ',i3)
  706 format(/' m    m    isol   isol  spin         Rofsd_hd  ')
  707 format(/' m    m    spin   Rofsd_hd  ')
  710 format(i2,3x,i2,6x,i2,6x,i2,6x,i2,6x,1p,2e11.3)
  711 format(i2,3x,i2,6x,i2,6x,1p,2e11.3)
      end

!**********************************************************************

      subroutine renormal(ampl,taug,m,nm1,nm2,nspin,urs,r,nrmtg,nr,
     &                    rmtgg,s1,s2,e1,e2,spinorbite)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db):: den
      complex(kind=db), dimension(nspin):: e1, e2, s1, s2
      complex(kind=db), dimension(nspin,nspin):: ampl, amplo, taug,
     &                                            wronsk

      integer iso(nspin)

      logical spinorbite

      real(kind=db), dimension(0:nr+1) :: r
      real(kind=db), dimension(nspin,nspin):: u1, u2
      real(kind=db), dimension(0:nr,nspin,nspin) :: urs

      common/icheck/ icheck(24)

      iso(1) = 2
      iso(nspin) = 1

      inr = min( nrmtg+1, nr )
      d12 = r(inr-1) - r(inr-2)
      d01 = r(inr) - r(inr-1)
      d02 = r(inr) - r(inr-2)

      u1(:,:) = 0._db
      u2(:,:) = 0._db

      do isp = 1,nspin  ! spin d'attaque
        do isol = 1,nspin  ! spin d'attaque
          if( .not. spinorbite .and. isp /= isol ) cycle

          if( spinorbite .and. ( ( m == nm1 .and. isp == 1 ) .or.
     &                          ( m == nm2 .and. isp == 2 ) )  ) cycle

          a = ( urs(inr-2,isp,isol) * d01 - urs(inr-1,isp,isol) * d02
     &        + urs(inr,isp,isol) * d12 ) / ( d12 * d01 * d02 )
          b = ( urs(inr-1,isp,isol) - urs(inr-2,isp,isol) ) / d12
     &      - a * ( r(inr-1) + r(inr-2) )
          c = urs(inr,isp,isol) - a * r(inr)**2 - b * r(inr)

          u1(isp,isol) = a * rmtgg**2 + b * rmtgg + c
          u2(isp,isol) = 2 * a * rmtgg + b

        end do
      end do

      ampl(:,:) = (0._db,0._db)
      taug(:,:) = (0._db,0._db)
      wronsk(:,:) = (0._db,0._db)
      wronskout = 1 / ( pi * rmtgg**2 )

! wronskout = 1 / ( pi * rmtg**2 ) a cause de la normalisation en
! rac(k/pi) des fonctions de bessel et hankel

      if( m > nm1 .and. m < nm2 .and. spinorbite ) then

        do isp = 1,nspin
          wronsk(isp,:) = u1(isp,:)*s2(isp) - u2(isp,:)*s1(isp)
        end do

        do isp = 1,nspin   ! spin d'attaque
          is = iso(isp)

          den =  wronsk(is,1) / wronsk(is,nspin) 

          ampl(isp,1) = wronskout / ( wronsk(isp,1)
     &                               - wronsk(isp,nspin) * den )

          ampl(isp,nspin) = wronskout / ( wronsk(isp,nspin)
     &                                  - wronsk(isp,1) / den )


          taug(isp,isp) = ( sum( ampl(isp,:) * u1(isp,:) )
     &                                       - e1(isp)  ) / s1(isp)
          taug(isp,is) = sum( ampl(isp,:) * u1(is,:) ) / s1(is)
        end do

        if( icheck(18) > 2 ) then
          write(3,110) m, den
          write(3,120) ( ampl(:,isol), isol = 1, nspin )
          write(3,130) ( wronskout / wronsk(isp,isp), isp=1,nspin)
        endif

! On recommence en normalisation neuman bessel

         amplo(:,:) = ampl(:,:)
         den =  1 / ( taug(1,1) * taug(2,2) - taug(1,2) * taug(2,1) ) 
         do isp = 1,nspin
           is = iso(is)
           ampl(isp,isp) = ( taug(is,is) * amplo(isp,isp) -
     &                       taug(isp,is) * amplo(is,isp) ) * den
           ampl(isp,is) = ( taug(is,is) * amplo(isp,is) -
     &                      taug(isp,is) * amplo(is,is) ) * den
         end do

      else

        do isp = 1,nspin

          if( spinorbite ) then
            if( m == nm2 ) then
              if( isp == 2 ) cycle
            else
              if( isp == 1 ) cycle
            endif
          endif

          wronsk(isp,isp) = u1(isp,isp) * s2(isp) - u2(isp,isp) *s1(isp)

          den = u2(isp,isp) * e1(isp) - u1(isp,isp) * e2(isp) 
          taug(isp,isp) = den / wronsk(isp,isp)
! En fait, il faut l'amplitude ampp correspondant a la normalisation
! neuman-bessel
          ampl(isp,isp) = wronskout / den
        end do

      endif

      if( icheck(18) > 2 ) then
        write(3,140) s1(:)
        write(3,150) s2(:)
        write(3,160) e1(:)
        write(3,170) e2(:)
        write(3,180) wronskout
        write(3,190) den
        if( spinorbite ) then
          write(3,200) ( wronsk(:,isol), isol = 1,nspin )
          write(3,210) ( u1(:,isol), isol = 1,nspin )
          write(3,220) ( u2(:,isol), isol = 1,nspin )
          write(3,120) ( ampl(:,isol), isol = 1,nspin )
          write(3,230) ( taug(:,isol), isol = 1,nspin )
        else
          write(3,200) ( wronsk(isp,isp), isp = 1,nspin )
          write(3,210) ( u1(isp,isp), isp = 1,nspin )
          write(3,220) ( u2(isp,isp), isp = 1,nspin )
          write(3,120) ( ampl(isp,isp), isp = 1,nspin )
          write(3,230) ( taug(isp,isp), isp = 1,nspin )
        endif
      endif

      return
  110 format(//' m = ',i3,'  den =',1p,8e11.3) 
  120 format(' ampl      =',1p,8e11.3) 
  130 format(' rap       =',1p,8e11.3) 
  140 format(/' s1        =',1p,8e11.3) 
  150 format(' s2        =',1p,8e11.3) 
  160 format(' e1        =',1p,8e11.3) 
  170 format(' e2        =',1p,8e11.3) 
  180 format(' wronskout =',1p,8e11.3) 
  190 format(' den       =',1p,8e11.3) 
  200 format(' wronsk    =',1p,8e11.3) 
  210 format(' u1        =',1p,8e11.3) 
  220 format(' u2        =',1p,8e11.3) 
  230 format(' taug      =',1p,8e11.3) 

      end

!**********************************************************************

      subroutine renormalc(ampl,taug,m,nm1,nm2,nspin,uis,urs,r,
     &                     nrmtg,nr,rmtgg,s1,s2,e1,e2,spinorbite)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db):: den
      complex(kind=db), dimension(nspin):: e1, e2, s1, s2
     &                                     
      complex(kind=db), dimension(nspin,nspin):: ampl, amplo, taug, u1,
     &                                        u2, wronsk

      integer iso(nspin)

      logical spinorbite

      real(kind=db), dimension(0:nr+1) :: r
      real(kind=db), dimension(0:nr,nspin,nspin) :: uis, urs

      common/icheck/ icheck(24)

      iso(1) = 2
      iso(nspin) = 1

      inr = min( nrmtg+1, nr )
      d12 = r(inr-1) - r(inr-2)
      d01 = r(inr) - r(inr-1)
      d02 = r(inr) - r(inr-2)

      u1(:,:) = (0._db,0._db)
      u2(:,:) = (0._db,0._db)

      do isp = 1,nspin  ! spin 
        do isol = 1,nspin  ! solution
          if( .not. spinorbite .and. isp /= isol ) cycle

          if( spinorbite .and. ( ( m == nm1 .and. isp == 1 ) .or.
     &                          ( m == nm2 .and. isp == 2 ) )  ) cycle

          ar = ( urs(inr-2,isp,isol) * d01 - urs(inr-1,isp,isol) * d02
     &        + urs(inr,isp,isol) * d12 ) / ( d12 * d01 * d02 )
          br = ( urs(inr-1,isp,isol) - urs(inr-2,isp,isol) ) / d12
     &       - ar * ( r(inr-1) + r(inr-2) )
          cr = urs(inr,isp,isol) - ar * r(inr)**2 - br * r(inr)

          ai = ( uis(inr-2,isp,isol) * d01 - uis(inr-1,isp,isol) * d02
     &        + uis(inr,isp,isol) * d12 ) / ( d12 * d01 * d02 )
          bi = ( uis(inr-1,isp,isol) - uis(inr-2,isp,isol) ) / d12
     &      - ai * ( r(inr-1) + r(inr-2) )
          ci = uis(inr,isp,isol) - ai * r(inr)**2 - bi * r(inr)

          u1r = ar * rmtgg**2 + br * rmtgg + cr
          u2r = 2 * ar * rmtgg + br
          u1i = ai * rmtgg**2 + bi * rmtgg + ci
          u2i = 2 * ai * rmtgg + bi
          u1(isp,isol) = cmplx(u1r,u1i,db)
          u2(isp,isol) = cmplx(u2r,u2i,db)

        end do
      end do

      ampl(:,:) = (0._db,0._db)
      taug(:,:) = (0._db,0._db)
      wronsk(:,:) = (0._db,0._db)
      wronskout = 1 / ( pi * rmtgg**2 )

! wronskout = 1 / ( pi * rmtg**2 ) a cause de la normalisation en
! rac(k/pi) des fonctions de bessel et hankel

      if( m > nm1 .and. m < nm2 .and. spinorbite ) then

        do isp = 1,nspin
          wronsk(isp,:) = u1(isp,:)*s2(isp) - u2(isp,:)*s1(isp)
        end do

        do isp = 1,nspin   ! spin d'attaque
          is = iso(isp)

          den =  wronsk(is,1) / wronsk(is,nspin) 

          ampl(isp,1) = wronskout / ( wronsk(isp,1)
     &                               - wronsk(isp,nspin) * den )

          ampl(isp,nspin) = wronskout / ( wronsk(isp,nspin)
     &                                  - wronsk(isp,1) / den )

          taug(isp,isp) = ( sum( ampl(isp,:) * u1(isp,:) )
     &                                       - e1(isp)  ) / s1(isp)
          taug(isp,is) = sum( ampl(isp,:) * u1(is,:) ) / s1(is)
        end do

        if( icheck(18) > 2 ) then
          write(3,110) m, den
          write(3,120) ( ampl(:,isol), isol = 1, nspin )
          write(3,130) ( wronskout / wronsk(isp,isp), isp=1,nspin)
        endif

        amplo(:,:) = ampl(:,:)
        den =  1 / ( taug(1,1) * taug(2,2) - taug(1,2) * taug(2,1) ) 
        do isp = 1,nspin
          is = iso(is)
          ampl(isp,isp) = ( taug(is,is) * amplo(isp,isp) -
     &                     taug(isp,is) * amplo(is,isp) ) * den
          ampl(isp,is) = ( taug(is,is) * amplo(isp,is) -
     &                    taug(isp,is) * amplo(is,is) ) * den
        end do

      else

        do isp = 1,nspin

          if( spinorbite ) then
            if( m == nm2 ) then
              if( isp == 2 ) cycle
            else
              if( isp == 1 ) cycle
            endif
          endif

          wronsk(isp,isp) = u1(isp,isp) * s2(isp) - u2(isp,isp) *s1(isp)

          den = u2(isp,isp) * e1(isp) - u1(isp,isp) * e2(isp) 
          taug(isp,isp) = den / wronsk(isp,isp)

! En fait, il faut l'amplitude ampp correspondant a la normalisation
! neuman-bessel
          ampl(isp,isp) = wronskout / den 

        end do

      endif

      if( icheck(18) > 2 ) then
        write(3,140) s1(:)
        write(3,150) s2(:)
        write(3,160) e1(:)
        write(3,170) e2(:)
        write(3,180) wronskout
        write(3,190) den
        if( spinorbite ) then
          write(3,200) ( wronsk(:,isol), isol = 1,nspin )
          write(3,210) ( u1(:,isol), isol = 1,nspin )
          write(3,220) ( u2(:,isol), isol = 1,nspin )
          write(3,120) ( ampl(:,isol), isol = 1,nspin )
          write(3,230) ( taug(:,isol), isol = 1,nspin )
        else
          write(3,200) ( wronsk(isp,isp), isp = 1,nspin )
          write(3,210) ( u1(isp,isp), isp = 1,nspin )
          write(3,220) ( u2(isp,isp), isp = 1,nspin )
          write(3,120) ( ampl(isp,isp), isp = 1,nspin )
          write(3,230) ( taug(isp,isp), isp = 1,nspin )
        endif
      endif

      return
  110 format(//' m = ',i3,'  den =',1p,8e11.3) 
  120 format(' ampl      =',1p,8e11.3) 
  130 format(' rap       =',1p,8e11.3) 
  140 format(/' s1        =',1p,8e11.3) 
  150 format(' s2        =',1p,8e11.3) 
  160 format(' e1        =',1p,8e11.3) 
  170 format(' e2        =',1p,8e11.3) 
  180 format(' wronskout =',1p,8e11.3) 
  190 format(' den       =',1p,8e11.3) 
  200 format(' wronsk    =',1p,8e11.3) 
  210 format(' u1        =',1p,8e11.3) 
  220 format(' u2        =',1p,8e11.3) 
  230 format(' taug      =',1p,8e11.3) 
      end

!**********************************************************************

! Calcul de l'integrale radiale de la regle d'or de Fermi.
! psii, urs et uis sont les fonctions d'onde fois r.

      subroutine radial_matrix(ecomp,green_plus,
     &          ip_max,lm0,lm1,lm2,m,nbseuil,nlmam,nm1,nm2,nr,nrm,
     &          nrmtsd,nspin,nspino,psii,r,rmtsd,rof,Spinorbite,uis,urs,
     &          vecond)

      use declarations
      implicit none

      integer ip, ip_max, ipp, iseuil, isol, isp, ispp, lm, lm0, lm1,
     &        lm2, m, mp, nbseuil, n, nlmam, nm1, nm2, nr, nrm, nrmtsd,
     &        nspin, nspino

      complex(kind=db), dimension(nlmam,nspin,nspin,0:3,nbseuil):: rof

      logical Ecomp, Green_plus, Spinorbite

      real(kind=db):: alfa, f_integr3, fac, radl, radli, rmtsd
      real(kind=db), dimension(nbseuil):: vecond
      real(kind=db), dimension(0:nr+1):: r
      real(kind=db), dimension(nrmtsd):: fct, rr
      real(kind=db), dimension(nrm):: psii
      real(kind=db), dimension(0:nr,nspin,nspin):: uis, urs

! alfa = e*e/(2*epsilon0*h*c) = 0.0072973531 = 1/137.036 est la
! constante de structure fine.
      alfa = 0.0072973531_db

      n = nrmtsd
      rr(1:n) = r(1:n)

      do isol = 1,nspin   ! boucle sur les 2 solutions a l'origine

        do ispp = 1,nspino
          if( spinorbite ) then
            isp = ispp
            if( ( m == nm1 .and. isp == 1 ) .or.
     &          ( m == nm2 .and. isp == 2 ) ) cycle
          else
            isp = isol
          endif
          do ip = 0,ip_max
            ipp = ip + 1
            fct(1:n) = psii(1:n) * urs(1:n,isp,isol) * r(1:n)**ipp
            radl = f_integr3(rr,fct,n,1,n,rmtsd)
            if( ecomp ) then
              fct(1:n) = psii(1:n) * uis(1:n,isp,isol)*r(1:n)**ipp
              radli = f_integr3(rr,fct,n,1,n,rmtsd)
            else
              radli = 0._db
            endif
            do iseuil = 1,nbseuil
              if( ip /= 1 ) then
                if( ip == 0 ) fac = - 0.5_db * alfa 
                if( ip == 2 ) then
                  fac = 0.5_db * vecond(iseuil)
                  if( .not. green_plus ) fac = - fac
                endif 
                if( ip == 3 ) fac = - ( 1._db / 6 ) * vecond(iseuil)**2 
                radl = fac * radl
                if( ecomp ) radli = fac * radli
              endif
              if( spinorbite ) then
                mp = m + isp - 1
                lm = lm0 + mp   ! correspond au lm vrai
                rof(lm,isp,isol,ip,iseuil) = cmplx(radl,radli,db)
              else
                rof(lm1:lm2,isp,isol,ip,iseuil)
     &                                     = cmplx(radl,radli,db)
              endif
            end do
          end do
        end do

      end do

      return
      end

!***********************************************************************

      subroutine radial_stdens(Ecomp,hubbard,iapr,id0,id,l,
     &           lm,lm0,lm1,lm2,m,n_atom_0,n_atom_0_self,n_atom_ind,
     &           n_atom_ind_self,nlmmax,nm1,nm2,nr,
     &           nrm_self,nrmtsd,nspin,nspino,r,rhov_self,rmtsd,rofsd,
     &           self,Spinorbite,uis,urs)

      use declarations

      implicit none

      integer iapr, id0, id, iop, iopp, ioq, ioqq, ir, isp, l, lm, lm0,
     &        lm1, lm2, m, n, n_atom_0, n_atom_0_self, n_atom_ind,
     &        n_atom_ind_self, nlmmax,
     &        nm1, nm2, nr, nrm_self, nrmtsd, nspin, nspino

      complex(kind=db), dimension(0:nrm_self,id0:id,nspin,
     &    nspino,nspino,n_atom_0_self:n_atom_ind_self):: rhov_self
      complex(kind=db), dimension(n_atom_0:n_atom_ind,nlmmax,nspin, 
     &                           nspino,nspino):: rofsd

      logical Ecomp, hubbard, self, Spinorbite

      real(kind=db):: f_integr3, radl, radli, rmtsd
      real(kind=db), dimension(0:nr+1):: r
      real(kind=db), dimension(nrmtsd):: a, b, fct, rr, u12s, u21s, 
     &                                   uis2, urs2
      real(kind=db), dimension(0:nr,nspin,nspin) :: uis, urs

      n = nrmtsd
      rr(1:n) = r(1:n)

      boucle_spin: do isp = 1,nspin
        if( spinorbite ) then
          lm = lm0 + m + isp - 1  ! correspond au lm vrai
          if( ( m == nm1 .and. isp == 1 ) .or.
     &        ( m == nm2 .and. isp == 2 ) ) cycle
        endif

        do iopp = 1,nspino
          if( spinorbite ) then
            iop = iopp
          else
            iop = isp
          endif

          do ioqq = 1,nspino
            if( spinorbite ) then
              ioq = ioqq
            else
              ioq = isp
            endif

            urs2(1:n) = urs(1:n,isp,iop) * urs(1:n,isp,ioq)
            if( ecomp ) then
              uis2(1:n) = uis(1:n,isp,iop) * uis(1:n,isp,ioq)
              u12s(1:n) = urs(1:n,isp,iop) * uis(1:n,isp,ioq)
              u21s(1:n) = uis(1:n,isp,iop) * urs(1:n,isp,ioq)
            endif
       
            a(1:n) = urs2(1:n)
            fct(1:n) = urs2(:) * r(1:n)**2
   
            if( ecomp ) then
              fct(1:n) = fct(1:n) - uis2(1:n) * r(1:n)**2    
              a(1:n) = a(1:n) - uis2(1:n)
            end if 
            radl = f_integr3(rr,fct,n,1,n,rmtsd)
            if( ecomp ) then
              b(1:n) = u12s(1:n) + u21s(1:n)
              fct(1:n) = b(1:n) * r(1:n)**2
              radli = f_integr3(rr,fct,n,1,n,rmtsd)
            else
              b(:) = 0._db
              radli = 0._db
            endif

! Pour le calcul auto coherent on travaille toujours avec un potentiel
! complexe 
            if( spinorbite ) then
              rofsd(iapr,lm,isp,iop,ioq) = cmplx(radl,radli,db)
              if( self ) rhov_self(1:n,lm,isp,iop,ioq,iapr) 
     &                          = cmplx(a(1:n),b(1:n),db) / quatre_pi
            else
              rofsd(iapr,lm1:lm2,isp,1,1) = cmplx(radl,radli,db)
              if( self ) then
                do ir = 1,n
                  if( hubbard ) then 
                    rhov_self(ir,lm1:lm2,isp,1,1,iapr) = 
     &                             cmplx(a(ir),b(ir),db) / quatre_pi
                  else
                    rhov_self(ir,l,isp,1,1,iapr) = 
     &                             cmplx(a(ir),b(ir),db) / quatre_pi
                  end if
                end do
              endif
            endif

          end do

        end do

      end do boucle_spin

      return
      end

!***********************************************************************

! Calcul des integrales radiales, y compris non diagonales en (m,m'),
! pour la densite d'etat des termes de hubbard.

      subroutine radial_stdens_hubb(Ecomp,iapr,l,m_hubb,n_atom_0_self,
     &               n_atom_ind_self,nr,nrmtsd,nspin,nspino,r,Rmtsd,
     &               rofsd_hd,uiss,urss,Spinorbite)

      use declarations
      implicit none

      integer:: iapr, ioq, ior, isp, l, m_hubb, m1, m2, mv1, mv2, n, 
     &      n_atom_0_self, n_atom_ind_self,nr, nrmtsd, nspin, nspino

      complex(kind=db), dimension(-m_hubb:m_hubb,nspino,-m_hubb:m_hubb,
     &        nspino,nspin,n_atom_0_self:n_atom_ind_self):: rofsd_hd

      logical Ecomp, Spinorbite

      real(kind=db):: f_integr3, radl, radli, Rmtsd
      real(kind=db), dimension(0:nr+1):: r
      real(kind=db), dimension(nrmtsd):: fct, rr
      real(kind=db), dimension(nr,-m_hubb-1:m_hubb,nspin,nspin):: uiss,
     &                                                            urss
 
      n = nrmtsd
      rr(1:n) = r(1:n)

      if( Spinorbite ) then
!  c'est le vrai m qui intervient dans les recopies urss et uiss
        do isp = 1,nspin
          do m1 = -l-1,l   ! le faux
            mv1 = m1 + isp - 1 ! le vrai
            if( mv1 < -l .or. mv1 > l ) cycle 
            do m2 = -l-1,l
              mv2 = m2 + isp - 1
              if( mv2 < -l .or. mv2 > l ) cycle          
              do ioq = 1,nspino    
                do ior = 1,nspino
                  fct(1:n) = urss(1:n,m1,isp,ioq) * urss(1:n,m2,isp,ior) 
                  if( ecomp ) fct(1:n) = fct(1:n) 
     &                    - uiss(1:n,m1,isp,ioq) * uiss(1:n,m2,isp,ior)
                  fct(1:n) = fct(1:n) * r(1:n)**2
                  radl = f_integr3(rr,fct,n,1,n,rmtsd)
                  if( ecomp) then
                    fct(1:n) = urss(1:n,m1,isp,ioq)*uiss(1:n,m2,isp,ior) 
     &                       + urss(1:n,m2,isp,ior)*uiss(1:n,m1,isp,ioq)
                    fct(1:n) = fct(1:n) * r(1:n)**2
                    radli = f_integr3(rr,fct,n,1,n,rmtsd)
                  else
                    radli = 0._db
                  end if
                  rofsd_hd(mv1,ioq,mv2,ior,isp,iapr)
     &                                      = cmplx(radl, radli, db)
                end do
              end do
            end do                            
          end do
        end do
      else
        do isp = 1,nspin
          do m1 = -l,l 
            do m2 = -l,l
              fct(1:n) = urss(1:n,m1,isp,isp) * urss(1:n,m2,isp,isp)
              if( ecomp ) fct(1:n) = fct(1:n) 
     &                   - uiss(1:n,m1,isp,isp) * uiss(1:n,m2,isp,isp)
              fct(1:n) = fct(1:n) * r(1:n)**2
              radl = f_integr3(rr,fct,n,1,n,rmtsd)
              if( ecomp) then
                fct(1:n) = urss(1:n,m1,isp,isp) * uiss(1:n,m2,isp,isp)
     &                   + urss(1:n,m2,isp,isp) * uiss(1:n,m1,isp,isp)
                fct(1:n) = fct(1:n) * r(1:n)**2
                radli = f_integr3(rr,fct,n,1,n,rmtsd)
              else
                radli = 0._db
              end if
              rofsd_hd(m1,1,m2,1,isp,iapr)= cmplx(radl,radli,db)                                
            end do                            
          end do
        end do
      end if

      return
      end

!***********************************************************************

      subroutine cal_phiato(hubb,hubbard,ia,iang,ibord,iwrite,
     &              l,lm0,lm1,lm2,lmax,m,natome,nbord,nbtm,nm1,nm2,
     &              nphiato1,nphiato20,nphiato2,nphiato3,nphiato4,
     &              nphiato5,nphiato6,npsom,nr,nspin,
     &              phiato,posi,r,spinorbite,uis,urs,xyz)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(nbtm,natome):: ibord

      logical hubb, hubbard, spinorbite

      real(kind=db), dimension(3):: ps, x, w
      real(kind=db), dimension(0:nr+1):: r
      real(kind=db), dimension(3,natome):: posi
      real(kind=db), dimension(0:nr,nspin,nspin) :: uis, urs
      real(kind=db), dimension(4,npsom):: xyz
      real(kind=db), dimension(nphiato1,nphiato20:nphiato2,nphiato3,
     &                 nphiato4,nphiato5,nphiato6):: phiato

      common/icheck/ icheck(24)

      ps(1:3) = posi(1:3,ia)

      if( spinorbite ) then
        nspin2 = 2
      else
        nspin2 = 1
      endif

      do ib = 1,nbord
        i = ibord(ib,ia)
        x(1:3) = xyz(1:3,i)
        call posrel(x,ps,w,rrel,isym)

        do i = 2,nr
          if( r(i) > rrel ) exit
        end do
        i = min(i,nr)

        rm = r(i-2)
        r0 = r(i-1)
        rp = r(i)

        do isp = 1,nspin
          if( spinorbite ) then
            if( ( m == nm1 .and. isp == 1 ) .or.
     &          ( m == nm2 .and. isp == 2 ) ) cycle
            if( iang == 1 ) then
              mp = m + isp - 1
            elseif( iang == - 1 ) then
              mp = - m - isp - 1
            endif
            lm = lm0 + mp
            lm1 = lm
            lm2 = lm
            nspin2 = nspin
          endif
          if( iang == 1 ) then
            ispp = isp
          elseif( iang == - 1 ) then
            ispp = 3 - isp
          else
            ispp = isp
          endif

          do isol = 1,nspin

            if( spinorbite ) then
              if( iang == 1 ) then
                isolp = isol
              elseif( iang == - 1 ) then
                isolp = 3 - isol
              endif
            else
              isolp = isol
            endif

            if( isolp /= ispp .and. (.not. spinorbite .or. iang == 0 ) )
     &                                            cycle

            do icp = 1,nphiato6
              if( icp == 1 ) then
                um = urs(i-2,isp,isol)
                u0 = urs(i-1,isp,isol)
                up = urs(i,isp,isol)
              else
                um = uis(i-2,isp,isol)
                u0 = uis(i-1,isp,isol)
                up = uis(i,isp,isol)
              endif
              phi = finterp2(um,u0,up,rm,r0,rp,rrel)

              if( spinorbite ) then
                phiato(ib,lm1:lm2,ispp,isolp,ia,icp) = phi
              elseif( hubbard ) then
                phiato(ib,lm1:lm2,ispp,1,ia,icp) = phi
              else
                phiato(ib,l,ispp,1,ia,icp) = phi
              endif

              if( iang == 0 .and. isol == 2 ) then
                if( spinorbite .or. hubbard ) then
                  do lm = lm1,lm2
                    phi = 0.5 * ( phiato(ib,lm,1,1,ia,icp)
     &                          + phiato(ib,lm,nspin,nspin2,ia,icp) )
                    phiato(ib,lm,1,1,ia,icp) = phi
                    phiato(ib,lm,nspin,nspin2,ia,icp) = phi
                  end do
                else
                  phi = 0.5 * ( phiato(ib,l,1,1,ia,icp)
     &                        + phiato(ib,l,nspin,nspin2,ia,icp) )
                  phiato(ib,l,1,1,ia,icp) = phi
                  phiato(ib,l,nspin,nspin2,ia,icp) = phi
                endif
              endif

            end do

         end do

        end do
      end do

      if( icheck(18) > 2 .and. iwrite == 1 ) then
        write(3,110) ia
        do ll = 0,lmax
          if( spinorbite .or. hubb ) then
            lm0 = ll**2 + ll + 1
            do mm = -ll,ll
              if( spinorbite ) then
                write(3,120) ll, mm
              else
                write(3,130) ll, mm
              endif
              lm = lm0 + mm
              do ib = 1,nbord
                write(3,140) ibord(ib,ia),
     &   ( phiato(ib,lm,1:nspin,isol,ia,1:nphiato6), isol = 1,nspin2 )
              end do
            end do
          else
            write(3,150) ll
            do ib = 1,nbord
              write(3,140) ibord(ib,ia),
     &                     phiato(ib,ll,1:nspin,1,ia,1:nphiato6)
            end do
          endif
        end do
      endif

      return
  110 format(/' ia =',i3)
  120 format(/' ibord phiato(u,1)  phiato(d,1)  phiato(u,2)  ',
     &        'phiato(d,2)   l =',i3,', m =',i3)
  130 format(/' ibord  phiato(u)    phiato(d)   l =',i3,', m =',i3)
  140 format(i5,8e13.4)
  150 format(/' ibord    phiato   l =',i3)
      end

!***********************************************************************

! Calcul de Integrale_sur_r_et_r' de conj(phi(r) * f_reg( min(r,r') ) * f_irg( max(r,r') ) * phi(r') * dr * dr' ) 
! = Integrale_sur_r ( phi(r) * f_irg(r) * Integrale_sur_r'_de_0_a_r ( f_reg(r') * phi(r') * dr' )
!                   + phi(r) * f_reg(r) * Integrale_sur_r'_de_r_a_Rmax ( f_irg(r') * phi(r') * dr' ) * dr 
!
! f_reg = r * solution reguliere
! f_irg = r * solution irreguliere
! phi = r * fonction initiale * r^p    ou   r * solution reguliere

      function integr_sing(n,phi,f_reg,f_irg,rmtsd,r) 

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db):: integr_sing

      complex(kind=db), dimension(n):: f_irg, f_reg, fct, phi_irg,
     &                                phi_reg, s_phi_irg, s_phi_reg 

      real(kind=db), dimension(n):: fct_r, phi, r

      common/icheck/ icheck(24)

      phi_reg(:) = phi(:) * f_reg(:)
      call ffintegr2(s_phi_reg,phi_reg,r,n,1,rmtsd)

      phi_irg(:) = phi(:) * f_irg(:)
      call ffintegr2(s_phi_irg,phi_irg,r,n,-1,rmtsd)

      fct(:) = phi_irg(:) * s_phi_reg(:) + phi_reg(:) * s_phi_irg(:)

      fct_r(:) = real( fct(:),db )
      fr = f_integr3(r,fct_r,n,1,n,rmtsd)

      fct_r(:) = aimag( fct(:) )
      fi = f_integr3(r,fct_r,n,1,n,rmtsd)

      integr_sing = - cmplx(fr,fi,db)

      if( icheck(18) > 4 ) then
        write(3,110)
        do ir = 1,n
          write(3,120) r(ir)*bohr, f_reg(ir), phi_reg(ir),s_phi_reg(ir),  
     &                 phi_irg(ir), s_phi_irg(ir), fct(ir)
        end do
        write(3,130) integr_sing 
      endif

      return
  110 format(/5x,'Radius',15x,'f_reg',23x,'phi_reg',19x,'s_phi_reg',19x,
     &          'phi_irg',21x,'s_phi_irg',22x,'fct')
  120 format(1p,13e14.6)
  130 format(/' Integr_sing =',1p,2e14.6)
      end

!***********************************************************************

! Calcul l'integrale de 0 a r (is=1) ou r a Rmax (is=-1) de fct
! Cas complexe

      subroutine ffintegr2(fint,fct,r,n,is,rmtsd)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      complex(kind=db):: a, a_tiers, b, b_demi, c, f0, fm, fp
      complex(kind=db), dimension(2):: dintegr
      complex(kind=db), dimension(n):: fct, fint

      real(kind=db), dimension(n):: r

      tiers = 1._db / 3._db

      if( is == 1 ) then
        i1 = 1
        i2 = n - 1
      else
        i1 = n - 1
        i2 = 1
        fint(n) = (0._db, 0._db)
      endif

      do i = i1,i2,is
        if( i == 1 ) then
          rm = r(i)
          r0 = r(i+1)
          rp = r(i+2)
          fm = fct(i)
          f0 = fct(i+1)
          fp = fct(i+2)
          xm = 0._db
          x0 = rm
          xp = 0.5 * ( rm + r0 )
        else
          rm = r(i-1)
          r0 = r(i)
          rp = r(i+1)
          fm = fct(i-1)
          f0 = fct(i)
          fp = fct(i+1)
          xm = 0.5 * ( rm + r0 )
          x0 = r0
          xp = 0.5 * ( r0 + rp )
        endif

        if( is == 1 .and. r0 > rmtsd ) exit
        if( is == - 1 .and. r0 > rmtsd ) cycle
        if( xp > rmtsd ) xp = rmtsd

        a = ( fm * ( rp - r0 ) - f0 * ( rp - rm ) + fp * ( r0 - rm ) )
     &    / ( ( r0 - rm ) * ( rp - r0 ) * ( rp - rm ) )
        b = ( f0 - fm ) / ( r0 - rm ) - a * ( r0 + rm )
        c = f0 - a * r0**2 - b * r0

        a_tiers = a * tiers
        b_demi = b * 0.5

        if( is == 1 ) then
          dintegr(1) = ( a_tiers * ( xm**2 + xm * x0  + x0**2 )
     &               + b_demi * ( xm + x0 ) + c ) * ( x0 - xm )
        else
          dintegr(1) = ( a_tiers * ( x0**2 + x0 * xp  + xp**2 )
     &               + b_demi * ( x0 + xp ) + c ) * ( xp - x0 )
        endif

        if( i == i1 ) then
          fint(i) = dintegr(1)
        else
          fint(i) = fint(i-is) + sum( dintegr(:) )
        endif

        if( is == 1 ) then
          dintegr(2) = ( a_tiers * ( x0**2 + x0 * xp  + xp**2 )
     &               + b_demi * ( x0 + xp ) + c ) * ( xp - x0 )
        else
          dintegr(2) = ( a_tiers * ( xm**2 + xm * x0  + x0**2 )
     &               + b_demi * ( xm + x0 ) + c ) * ( x0 - xm )
        endif

        if( i == i2 .and. is == 1 ) fint(i+1) = fint(i) + dintegr(2)

      end do

      return
      end

