! Routines of the FDMNES package

!***********************************************************************

! Sousprogramme elaborant la grille en energie pour le calcul du niveau
! de Fermi

      subroutine grille_coh(eimag_coh,energ_coh,enin,Green,
     &                           nenerg_coh,Pas_SCF)
     
      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer nenerg_coh

      logical Green

      real(kind=db), dimension(nenerg_coh) :: energ_coh, eimag_coh
        
      common/icheck/ icheck(24)
  
      energ_coh(1) = enin 
           
      do ie = 2,nenerg_coh
        energ_coh(ie) = energ_coh(ie-1) + Pas_SCF
      end do

      if( Green ) then
        eimag_coh(1:nenerg_coh) = 2 * Pas_SCF
      else
        eimag_coh(1:nenerg_coh) = 0._db
      endif
 
      if( icheck(3) > 1 ) then
        write(3,110)
        write(3,120)
        do ie = 1,nenerg_coh
          write(3,130) energ_coh(ie)*rydb, eimag_coh(ie)*rydb
        end do
      endif

      return
  110 format(/' ---- Grille_coh -',100('-'))
  120 format(/'   energie    eimag      en eV')
  130 format(4f9.3)
      end

!***********************************************************************

! Modification Oana
! Calcul de la charge du petit agregat

      subroutine chg_agr(chargat,chargat_self_s,ch_c,chg_cluster,
     &               chg_level,Full_atom,iaprotoi,
     &               ipr0,iprabs,itypepr,it0,lcoeur,mpirank,
     &               natome,n_atom_0_self,n_atom_ind_self,
     &               n_atom_proto,nb_eq,ncoeur,ngreq,nrato,nrm,
     &               nrm_self,nspin,ntype,numat,pop_level,psi_coeur,
     &               psi_level,rato,rho_chg,rho_coeur,rho_cor,
     &               rhoato_init,rmtsd,self_non_exc,sgn)             

      use declarations
      implicit real(kind=db) (a-h,o-z)
 
      integer:: Sum_Z
      integer, dimension(it0:ntype):: nrato, numat 
      integer, dimension(2,it0:ntype):: lcoeur, ncoeur
      integer, dimension(ipr0:n_atom_proto):: itypepr, ngreq
      integer, dimension(natome):: iaprotoi, nb_eq

      logical:: Full_atom, self_non_exc
      logical, dimension(n_atom_0_self:n_atom_ind_self):: sgn
     
      real(kind=db), dimension(ipr0:n_atom_proto):: chargat 
      real(kind=db), dimension(0:nrm,it0:ntype):: rato, rho_coeur,
     &                                            rho_cor
      real(kind=db), dimension(0:nrm_self,nspin, 
     &           n_atom_0_self:n_atom_ind_self):: rho_chg, rhoato_init
      real(kind=db), dimension(ipr0:n_atom_proto):: rmtsd
      real(kind=db), dimension(0:nrm)::  r, rh          
      real(kind=db), dimension(n_atom_0_self:n_atom_ind_self):: ch_v, 
     &                              ch_c, chargat_self_s, chargat_sup        
      real(kind=db), dimension(0:nrm,2,it0:ntype):: psi_coeur 
      real(kind=db), dimension(0:nrm,it0:ntype,2):: psi_level
      real(kind=db), dimension(it0:ntype,2):: pop_level
      real(kind=db), dimension(2):: chg_level

      common/icheck/ icheck(24)

      charge_init = 0._db
      chg_cluster = 0._db
      chg_sup = 0._db
      chg_coeur = 0._db         
      chargat_self_s(:) = 0._db
      chargat_sup(:) = 0._db
      
      if( icheck(22) > 0 ) write(3,110)       

      sum_Z = 0

      do iapr = n_atom_0_self,n_atom_ind_self
        if( Full_atom ) then
          ipr = iaprotoi(iapr)
          n = nb_eq(iapr) 
        else
          ipr = iapr
          n = ngreq(ipr) 
        endif
        it = itypepr(ipr)
        nr = nrato(it)
        rayint = rmtsd(ipr)
        r(0:nrm) = rato(0:nrm,it)
        
! Calcul de la charge totale de l'agregat: rhoato est la vraie densite
        do ispin = 1,nspin
          rh(0:nr) = rhoato_init(0:nr,ispin,iapr) * r(0:nr)**2
          res = quatre_pi * f_integr3(r,rh,nr,0,nrm,rayint)
          chargat_self_s(iapr) = chargat_self_s(iapr) + res
        end do
        chg_cluster = chg_cluster + chargat_self_s(iapr) * n
         
! Calcul de la charge totale de l'agregat: rho_chg est la densite
! venant des atomes exterieurs au petit agregat.
        do ispin = 1, nspin
          rh(0:nr) = rho_chg(0:nr,ispin,iapr) * r(0:nr)**2
          res = quatre_pi * f_integr3(r,rh,nr,0,nrm,rayint)
          chargat_sup(iapr) = chargat_sup(iapr) + res
        end do
        chg_sup = chg_sup + chargat_sup(iapr) * n
         
! Calcul de la charge des orbitales de coeur: rho_coeur est la vraie
! densite
        rh(0:nr) = rho_coeur(0:nr,it) * r(0:nr)**2
        ch_c(iapr) = quatre_pi * f_integr3(r,rh,nr,0,nrm,rayint)
! Si les orbitales de coeur sont trop approchees de celles de valence,
! on fait une correction:
        if( sgn(iapr) ) then
          rho_cor(0,it) = 0._db
          fac = ( 4 * lcoeur(1,it) + 2 ) / quatre_pi 
          rho_cor(1:nr,it) = fac * ( psi_coeur(1:nr,1,it) / r(1:nr) )**2
          rh(0:nr) = rho_cor(0:nr,it) * r(0:nr)**2
          corr = quatre_pi * f_integr3(r,rh,nr,0,nrm,rayint)
! psi_coeur sont les fct d'onde *r*(4pi)**0.5
! psi_coeur sont normees, on multiplie par la populations
          ch_c(iapr) = ch_c(iapr) - corr
        else
          rho_cor(:,it) = 0._db
        end if
 
        chg_coeur = chg_coeur + ch_c(iapr) * n
        Sum_Z = Sum_Z + n * numat(it) 
        charge_init = charge_init + n * chargat(ipr) 
      end do 

! Calcul de la charge de valence:
      chg = chg_cluster - chg_coeur

      if( icheck(22) > 0 ) then
         write(3,120) chg
         write(3,130) chg_coeur
         write(3,140) chg_cluster
         write(3,145) chg_sup
         write(3,150) Sum_Z
         write(3,160) charge_init
         write(3,170) Sum_Z - charge_init - chg_cluster
      end if

      do iprint = 3,6,3
        if( iprint == 3 .and. icheck(22) == 0 ) cycle 
        if( iprint == 6 .and. mpirank /= 0 ) cycle 
        write(iprint,300)
        ch_v(:) = chargat_self_s(:) - ch_c(:)
        do iapr = n_atom_0_self,n_atom_ind_self
          if( Full_atom ) then
            ipr = iaprotoi(iapr)
          else
            ipr = iapr
          endif
          it = itypepr(ipr)
          write(iprint,310) iapr, numat(it), ch_v(iapr), ch_c(iapr),
     &                 chargat_self_s(iapr), chargat_sup(iapr), 
     &                 numat(it) - chargat_self_s(iapr)
        end do
      end do

      Sum_Z = Sum_Z - charge_init
 
      if( icheck(22) > 1 ) then
        write(3,350)
        write(3,351) sum(ch_v(:))
        write(3,352) sum(ch_c(:))
        write(3,353) sum(chargat_self_s(:))

        do iapr = n_atom_0_self,n_atom_ind_self
          if( Full_atom ) then
            ipr = iaprotoi(iapr)
          else
            ipr = iapr
          endif
          it = itypepr(ipr)
          write(3,403) iapr
          if( nspin == 1 ) then
            write(3,401)
          else
            write(3,402)
          end if
          do ir = 1, nrato(it)
            write(3,405) rato(ir,it)*bohr, 
     &             quatre_pi * rato(ir,it)**2 * rho_chg(ir,1:nspin,iapr)
          end do
          if(sgn(iapr)) write(3,410) numat(it),ncoeur(1,it),lcoeur(1,it)
        end do
      end if

      do iapr = n_atom_0_self,n_atom_ind_self
        if( Full_atom ) then
          ipr = iaprotoi(iapr)
        else
          ipr = iapr
        endif
        it = itypepr(ipr)
        chargat_self_s(iapr) = numat(it) - chargat_self_s(iapr)
      end do
 
! coupure ad hoc au niveau de Fermi: indice 1 <=> nonexcited absorber
!                                    indice 2 <=>    excited absorber

      do i = 1,2
        r(:) = rato(:,it0)
        rh(:) = psi_level(:,it0,i)**2
        nr = nrato(it0)
        if( self_non_exc ) then
          rayint = rmtsd(iprabs) 
        else
          rayint = rmtsd(ipr0)
        end if
        chg_level(i) = f_integr3(r,rh,nr,0,nrm,rayint)
! psi_level_val etait normalise a l'unite:
        chg_level(i) = chg_level(i) * pop_level(it0,i)
      end do

      if( icheck(22) > 0 ) then
         write(3,415) chg_level(1)
         write(3,416) chg_level(2)
      end if

      if( icheck(22) > 2 ) then
         write(3,501)
         do ir = 1, nrato(it0)
           write(3,405) rato(ir,it0)*bohr,
     &           quatre_pi * rato(ir,it0)**2 * psi_level(ir,it0,1)**2
         end do
         write(3,502)
         do ir = 1, nrato(it0)
           write(3,405) rato(ir,it0)*bohr,
     &           quatre_pi * rato(ir,it0)**2 * psi_level(ir,it0,2)**2
         end do
      end if

      return
  110 format(/' ---- Chg_agr --------',100('-'))
  120 format(/' Number of valence electrons =',f9.3)  
  130 format(' Number of core electrons    =',f9.3)   
  140 format(' Total                       =',f9.3)   
  145 format(' Charge from outer sphere    =',f9.3)   
  150 format(' Sum of atomic number        =',i5)   
  160 format(' Initial charge              =',f9.3)   
  170 format(' Cluster charge              =',f9.3)   
  300 format(/' ia   Z     ch_val    ch_core   ch_total     ch_out  ',
     &        ' Atom charge')
  310 format(i3,i4,5f11.3) 
  350 format(/' Reference charges in the symmetrised cluster ')
  351 format(10x,'valence electrons: ',f9.3)
  352 format(10x,'core electrons: ',f9.3)
  353 format(10x,'total number of electrons: ',f9.3)
  401 format(/7x,'rato           4pi*r2*rho_chg') 
  402 format(/7x,'rato         4pi*r2*rho_chg(u)    4pi*r2*rho_chg(d)')  
  403 format(/7x,'ia =  ',i4) 
  405 format(1p,e13.5,3x,e13.5,3x,e13.5)
  410 format(/'For Z =',i4,2x,'orbital n =',i4,2x,'and l =',i4,
     &       2x,'is in the valence band')
  415 format(/'chg_level for neutral absorber= ',f5.3)
  416 format(/'chg_level for excited absorber= ',f5.3)
  501 format(/7x,'rato           4pi*r2*psi_level_nonexc**2') 
  502 format(/7x,'rato           4pi*r2*psi_level_exc**2') 
      end
!***********************************************************************

! Oana 
! Calcul du point du d�part en energie, pour la d�termination du niveau
! de Fermi

      subroutine en_dep(enin,Full_atom,Green,iaprotoi,ipr0,it0,
     &              itypepr,lcoeur,n_atom_0,n_atom_0_self,n_atom_ind,
     &              n_atom_ind_self,n_atom_proto,natome,ncoeur,
     &              nenerg_coh,nrato,
     &              nrm,numat,nspin,ntype,Pas_SCF,psi_coeur,rato,sgn,
     &              Vcato,Vxcato,workf)
                  
      use declarations
      implicit real(kind=db) (a-h,o-z)
      implicit integer (i-n)

      integer, dimension(2,it0:ntype):: lcoeur, ncoeur
      integer, dimension(it0:ntype):: nrato, numat
      integer, dimension(natome):: iaprotoi
      integer, dimension(ipr0:n_atom_proto):: itypepr

      logical:: Full_atom, Green
      logical, dimension(n_atom_0_self:n_atom_ind_self):: sgn

      real(kind=db), dimension(2):: epsiit_all
      real(kind=db), dimension(0:nrm,it0:ntype):: rato  
      real(kind=db), dimension(0:nrm):: r, pot, psi    
      real(kind=db), dimension(0:nrm,n_atom_0:n_atom_ind):: Vcato
      real(kind=db), dimension(0:nrm,nspin,n_atom_0:n_atom_ind):: Vxcato
      real(kind=db), dimension(0:nrm,2,it0:ntype):: psi_coeur       
      real(kind=db), dimension(2,n_atom_0_self:n_atom_ind_self):: epsiit
      
      common/icheck/ icheck(24)

! On selectione l'orbitale de coeur de plus grande energie et celle de
! valence de plus basse �nergie (valable pour les niveaux atomiques
! ordones selon la regle d'occupation. Il est possible qu'ils soient
! inverses dans le cas d'un agregat)
! ces energies sont stoquees en epsiit

! l'indice 1 correspond � la derniere orbitale de coeur
! l'indice 2 correspond � la premiere orbitale de valence 

      if( icheck(4) > 0 ) write (3,110)

      boucle_agr: do iapr = n_atom_0_self,n_atom_ind_self
        if( Full_atom ) then
          ipr = iaprotoi(iapr)
        else
          ipr = iapr
        endif 
        it = itypepr(ipr)
        r(:) = rato(:,it)
        nr = nrato(it)

        do i = 1,2
          l2 = lcoeur(i,it)**2 + lcoeur(i,it) 
          psi(:) = psi_coeur(:,i,it) 
    
 ! On fait une moyenne sur les deux spins, si besoin :
         do ir = 1, nrm
           Vxc = sum( Vxcato(ir,:,iapr) ) / nspin
           Veq =  Vcato(ir,iapr) + Vxc + l2 / rato(ir,it)**2
           pot(ir) = Veq
         end do
           Epsiit(i,iapr) =  psiHpsi(nr,nrm,pot,pp,psi,r)
        end do 
               
      end do boucle_agr
 
! recherche de Epsiit_all(2): orbitale de valence de plus basse Energie
      Epsiit_all(2) = Epsiit(2,n_atom_0_self)   
      do iapr = n_atom_0_self+1,n_atom_ind_self
        Epsiit_all(2) = min( epsiit_all(2), epsiit(2,iapr) )
      end do

      E_marge = 10._db / rydb
      Enin = Epsiit_all(2) - E_marge 

! Cas des orbitales de coeur trop proches de celles de valence
      sgn(:) = .false.
      do ib = n_atom_0_self,n_atom_ind_self
        do iapr = n_atom_0_self,n_atom_ind_self
          if( epsiit(1,iapr) < Enin + eps10 ) cycle
          sgn(iapr) = .true.
          Enin = min( epsiit(1,iapr)-E_marge, Enin) 
        end do 
      end do

! les potentiels sont references en fonction du niveau du vide alors que 
! la gamme d'energie commence dessous (workf)
      Enin = Enin + Workf

! Pas en energie
      if( Green ) then
        Pas_SCF = 0.1_db / rydb
      else
        Pas_SCF = 0.01_db / rydb
      endif
      Emax_Fermi = 30._db / rydb

! Evaluation du nombre de points pour la grille en �nergie
      nenerg_coh = nint( ( Emax_Fermi - Enin ) / Pas_SCF ) + 1      
      
      if( icheck(4) > 0 ) then
        write(3,120)
        do iapr = n_atom_0_self,n_atom_ind_self
          if( Full_atom ) then
            ipr = iaprotoi(iapr)
          else
            ipr = iapr
          endif 
          it = itypepr(ipr)
          write(3,130) iapr, numat(it), 
     &      ( ncoeur(i,it), lcoeur(i,it), epsiit(i,iapr)*rydb, i = 1,2 )
        end do
      end if

      if( icheck(4) > 2 ) then
        do it = it0,ntype
          write(3,135) numat(it), (ncoeur(i,it), lcoeur(i,it), i = 1,2)
          do ir = 1,nrato(it)
            write(3,137) ( psi_coeur(ir,i,it), i = 1,2 )
          end do
        end do
      end if
      
      if( icheck(4) > 0 ) write (3,150) enin * rydb, - Workf *rydb
      
      return
  110 format(/' ---- En_dep --------',100('-'))
  120 format(/'  ia     Z    n  l    E_core   n  l     E_val',
     &'   zero at infinity')   
  130 format(i3,4x,i3,2x,2(i3,i3,f11.3))   
  135 format(/'  Z = ',i3,3x,'n_coeur = ',i1,3x,'l_coeur = ',i1,3x,
     &         'n_val = ',i1,3x,'l_val = ',i1//
     &          4x,'psi_coeur    ','psi_val    '/)
  137 format(1p,2e14.6)
  150 format(/' Starting energy = ',f8.3,' eV,    zero at',f7.2,' eV')    
      end

!*************************************************************************
! Sous - programme qui diagonalise la matrice d'occupation et calcule la rotation qui correspond
!     dans le cas d'un calcul symmetrise 
   
      subroutine diag(Atom_comp,cal_xanes,Full_atom,hubb,i_self,
     &              iaprotoi,Int_dens_all,iato,ipr0,it0,itypepr,lato,
     &              m_hubb,mato,
     &              n_atom_0_self,n_atom_ind_self,n_atom_proto,natome,
     &              ngrph,nlmsa0,nlmsam,nspin,
     &              ntype,numat,rot,spinorbite)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(natome):: iaprotoi
      integer, dimension(it0:ntype):: numat
      integer, dimension(natome,ngrph):: nlmsa0
      integer, dimension(nlmsam,natome,ngrph):: iato, mato, lato
      integer, dimension(ipr0:n_atom_proto):: itypepr

      logical:: cal_xanes, Full_atom, spinorbite
      logical, dimension(it0:ntype):: hubb
      logical, dimension(0:natome):: Atom_comp
      logical, dimension(-m_hubb:m_hubb):: mm

      real(kind=db), dimension(:,:), allocatable:: nondiag
      real(kind=db), dimension(:,:), allocatable:: u
      complex(kind=db), dimension(:,:), allocatable:: ui
      complex(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin, 
     &                             n_atom_0_self:n_atom_ind_self):: rot
      real(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin,
     &                    n_atom_0_self:n_atom_ind_self):: Int_dens_all

      common/icheck/ icheck(24)

! j'ai programme le spinorbite meme si pour l'instant on n'entre pas dans cette
!    routine lors d'un calcul spin orbite

      if( icheck(23) > 0 ) then
        write(3,600)
        write(3,601) i_self
      end if

      mm(:) = .false.
! Si la matrice d'occupation est diagonale on ne la touche pas:
      rot(:,:,:,:) = (0._db, 0._db)

      do iapr = n_atom_0_self,n_atom_ind_self
        if( Full_atom ) then
          ipr = iaprotoi(iapr)
          ia = iapr
        else
          ipr = iapr
          do ia = 1,natome
            if( iaprotoi(ia) == ipr ) exit
          end do
        endif 
        it = itypepr(iapr)
        if( hubb(it) ) then
        l = l_hubbard( numat(it) )

! Verifions s'il existe des m qui ne sont pas calcules (lors d'un calcul xanes
!     toutes les representations ne sont pas forcement calculees). Dans ce cas les 
!     lignes et les colonnes qui y correspondent sont nulles. Pour rendre plus 
!     agreable la forme de la matrice je mets des 1 pour les element diagonaux qui
!     correspondent.... 

        if( cal_xanes ) then

          do isp = 1, nspin
            do m = -l, l
              do igrph = 1, ngrph
                do lm = 1, nlmsa0(ia,igrph)
                   if( lato(lm,ia,igrph) == l .and. ( ( spinorbite .and.
     &        iato(lm,ia,igrph) == isp ).or. ( .not. spinorbite .and. 
     &        iato(lm,ia,igrph) /= isp )) .and. mato(lm,ia,igrph) == m )
     &                                                   mm(m) = .true.        
                end do
              end do  
            end do
          end do

          do m = -l, l
            if( .not. mm(m) .and. icheck(23) > 0 ) then
              write(3,222)
              exit
            end if
          end do

          do m = -l, l
            if( .not. mm(m) .and. icheck(23) > 0 ) write(3,223) m
          end do

        end if

! Si magnetique sans spin orbite iato est rempli seulement avec 1

        boucle_spin: do isp = 1, nspin

! Si la matrice d'occupation n'est pas diagonale, on la diagonalise:

          boucle_repr: do igrph = 1, ngrph

            if( icheck(23) > 1 ) write(3,615) igrph
! Soit n la dimension de la representation igrph
            n = 0
            do lm = 1, nlmsa0(ia,igrph)
              if( lato(lm,ia,igrph) == l ) then 
                if( spinorbite .and. iato(lm,ia,igrph) == isp ) n = n +1
                if(.not. spinorbite .and. iato(lm,ia,igrph) == 1 ) n=n+1
              endif
            end do

! A cause de la summetrisation, on est oblige de faire le remplissage des matrices
!    a l'interieur de chaque representation: des m appartenant aux representations 
!    differentes ne peuvent pas se melanger

         if( icheck(23) > 1 ) write(3,616) n

          allocate( nondiag(n,n) )
          nondiag(:,:) = 0._db

          if( Atom_comp(ia) .or. spinorbite ) then
             allocate( ui(n,n) )
             ui(:,:) = (0._db, 0._db)
          else
             allocate( u(n,n) )
             u(:,:) = 0._db
          endif

! En l'entree de la sousroutine LAPACK il faut une matrice indexee a partir de 1

! logique: .not.{lato == l.and.[(SO.and.iato == isp).or.(.not.SO.and.iato == 1)]}
!           va donner la condition en bas...

          n1 = 0
          do lm1 = 1, nlmsa0(ia,igrph)
            if(   lato(lm1,ia,igrph) /= l .or. (
     &          (.not. spinorbite .or. iato(lm1,ia,igrph) /= isp ) .and. 
     &          ( spinorbite .or. iato(lm1,ia,igrph) /= 1 ) ) ) cycle
            n1 = n1 + 1 
            m1 = mato(lm1,ia,igrph)
            n2 = 0
            do lm2 =1, nlmsa0(ia,igrph)
            if(   lato(lm2,ia,igrph) /= l .or. (
     &          (.not. spinorbite .or. iato(lm2,ia,igrph) /= isp ) .and. 
     &          ( spinorbite .or. iato(lm2,ia,igrph) /= 1 ) ) ) cycle
              n2 = n2 + 1
              m2 = mato(lm2,ia,igrph)
              nondiag(n1,n2) = Int_dens_all(m1,m2,isp,iapr)
            end do  
          end do

! Test diagonalite:: si diagonale la matrice de rotation est la matrice unite
         boucle_i: do itest = 1, n
          do jtest = 1, n
           if( itest /= jtest .and. abs(nondiag(itest,jtest) ) > eps10) 
     &                                           exit boucle_i
          end do
         end do boucle_i

! Flush a 0:
    ! symptome : si la matrice d'occupation est quasiment diagonale (c.a.d. les elements
    ! diagonaux sont tres petits la matrice de rotation n'est plus la matrice unite, 
    ! mais une combinaison non diagonale de 1 et -1)

!         where( abs(nondiag) < eps10 ) nondiag = 0._db

         if( icheck(23) > 1 ) then
           write(3,708) igrph
           do i = 1, n
              write(3,710) nondiag(i,1:n)
           end do
         end if

! Si diagonale on la touche pas:

         if( itest == n + 1 .and. jtest == n + 1 ) then
           if( Atom_comp(ia) .or. spinorbite ) then
             ui(:,:) = ( 0._db, 0._db )
           else
             u(:,:) = 0._db
           end if
           do m = 1, n
             if( Atom_comp(ia) .or. spinorbite ) then
               ui(m,m) = ( 1._db, 0._db )
             else
               u(m,m) = 1._db
             end if
           end do
           if( icheck(23) > 1 ) write(3,711)
         else

! Faire attention aux problemes numeriques dus a l'incompatibilite double precision / kind=db 
! Dimensionement du workspace a l'interieur des routines LAPACK
          lwork = 5*n  
          if( .not. Atom_comp(ia) .and. .not. spinorbite ) then   
            call matrix(nondiag,u,n,lwork)
!          u = transpose( u )           ! des fois ca marche mieux     
          else
            call matrix2(nondiag,ui,n,lwork)
!           ui = transpose( ui )
          end if

          if( icheck(23) > 1 ) then
          write(3,709) igrph
            do i = 1, n
              write(3,710) nondiag(i,1:n)
            end do
          end if

         end if

! matrice diagonale:
          n1 = 0
          do lm1 = 1, nlmsa0(ia,igrph)
            if(   lato(lm1,ia,igrph) /= l .or. (
     &          (.not. spinorbite .or. iato(lm1,ia,igrph) /= isp ) .and. 
     &          ( spinorbite .or. iato(lm1,ia,igrph) /= 1 ) ) ) cycle
            n1 = n1 + 1
            m1 = mato(lm1,ia,igrph)
            n2 = 0
            do lm2 = 1, nlmsa0(ia,igrph)
            if(   lato(lm2,ia,igrph) /= l .or. (
     &          (.not. spinorbite .or. iato(lm2,ia,igrph) /= isp ) .and. 
     &          ( spinorbite .or. iato(lm2,ia,igrph) /= 1 ) ) ) cycle
              n2 = n2 + 1
              m2 = mato(lm2,ia,igrph)
              Int_dens_all(m1,m2,isp,iapr) = nondiag(n1,n2) 
            end do  
          end do  
         
! matrices de rotation; on recopie pour changer l'indexation et garder le isp
          n1 = 0
          do lm1 = 1, nlmsa0(ia,igrph)
            if(   lato(lm1,ia,igrph) /= l .or. (
     &          (.not. spinorbite .or. iato(lm1,ia,igrph) /= isp ) .and. 
     &          ( spinorbite .or. iato(lm1,ia,igrph) /= 1 ) ) ) cycle
            n1 = n1 + 1
            m1 = mato(lm1,ia,igrph)
            n2 = 0
            do lm2 = 1, nlmsa0(ia,igrph)
            if(   lato(lm2,ia,igrph) /= l .or. (
     &          (.not. spinorbite .or. iato(lm2,ia,igrph) /= isp ) .and. 
     &          ( spinorbite .or. iato(lm2,ia,igrph) /= 1 ) ) ) cycle
              n2 = n2 + 1
              m2 = mato(lm2,ia,igrph)
              if( .not. Atom_comp(ia) .and. .not. spinorbite ) then
                rot(m1,m2,isp,iapr) = cmplx(u(n1,n2), 0._db) !left..
              else
                rot(m1,m2,isp,iapr) = ui(n1,n2)
              end if       
            end do
          end do
         
          deallocate ( nondiag )

          if( Atom_comp(ia) .or. spinorbite ) then
             deallocate( ui )
          else
             deallocate( u )
          end if

         end do boucle_repr

! Regarde le commentaire du debut
         if( cal_xanes ) then
          do m = -l, l
           if( mm(m) ) then 
             rot(m,m,isp,iapr) = 1._db
! Je pense que ca sert a rien
             Int_dens_all(m,m,isp,iapr) = 0._db
           end if
          end do
         end if   

! Ecritures:
         if( icheck(23) > 0 ) then
           write(3,603) iapr, isp
           do i1 = -l, l
             write(3,605) i1, rot(i1,-l:l,isp,iapr)
           end do
           write(3,607) iapr, isp
           do i1 = -l, l
             write(3,605) i1, Int_dens_all(i1,-l:l,isp,iapr)
           end do
         end if

        end do boucle_spin
       end if
      end do

      return
  222 format('For symmetry reasons the following m are not',
     & ' calculated. Corresponding elements on the diagonal of the',
     & ' rotation matrix have been set to 1')
  223 format(7i1)
  600 format(/' ---- Diag ------',100('-')) 
  601 format(/'Cycle ',i2)
  603 format(/'Hubbard rotation matrix for ia = ',i3,' isp = ',i3)
  605 format(1p,i3,28e13.5)
  615 format(/'Representation number  ',i3)
  616 format(/'Dimension of the representation: ',i2)
  607 format(/'Diagonalised occupation matrix for ia = ',i3,' isp = ',
     &                                                          i3)
  708 format(/'nondiag avant diagonalisation pour igrph = ',i2)
  709 format(/'nondiag apres diagonalisation pour igrph = ',i2)
  710 format(1p,14e13.5)
  711 format(/'no diagonalisation is required in this case ')
      end

!************************************************************************

! Sous - programme qui diagonalise la matrice d'occupation et calcule
! la rotation qui correspond dans le cas d'un calcul sans symetrie

      subroutine diag_SO(hubb,ipr0,Full_atom,Int_dens_all,iaprotoi,
     &              it0,itypepr,m_hubb,n_atom_0_self,n_atom_ind_self,
     &              n_atom_proto,natome,natome_self,nspin,ntype,numat,
     &              rot)

      use declarations
      implicit real(kind=db) (a-h,o-z)

      integer, dimension(natome):: iaprotoi
      integer, dimension(ipr0:n_atom_proto):: itypepr
      integer, dimension(it0:ntype):: numat

      logical:: Full_atom
      logical, dimension(-m_hubb:m_hubb):: tip
      logical, dimension(it0:ntype):: hubb

      complex(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,
     &                      nspin,n_atom_0_self:n_atom_ind_self):: rot
      complex(kind=db), dimension(:,:), allocatable:: ui

      real(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin,
     &                    n_atom_0_self:n_atom_ind_self):: Int_dens_all
      real(kind=db), dimension(:,:), allocatable:: matr

      common/icheck/ icheck(24)

      if( icheck(23) > 0 ) write(3,100)

      do iapr = n_atom_0_self,n_atom_ind_self

        if( Full_atom ) then
          ipr = iaprotoi(iapr)
          ia = iapr
        else
          ipr = iapr
          do ia = 1,natome
            if( iaprotoi(ia) == ipr ) exit
          end do
! comment on fait la rotation des atomes qui n'etait pas pris en compte
! lors du calcul self consistent ?
          if( ia > natome_self ) cycle
        endif 

        it = itypepr(iapr)

        if( .not. hubb(it) ) cycle

        lhubb = l_hubbard( numat(it) )
       
        do isp = 1, nspin

          rot(:,:,isp,iapr) = (0._db,0._db)

! Test diagonalite:: si diagonale la matrice de rotation est la matrice unite
          do itest = -lhubb, lhubb
            do jtest = -lhubb, lhubb
              if( itest /= jtest .and.  
     &          abs( Int_dens_all(itest,jtest,isp,iapr) ) > eps10 ) exit 
            end do
          end do 

! Si diagonale:

          if( itest == lhubb + 1 .and. jtest == lhubb + 1 ) then 

            do m = -lhubb, lhubb
              rot(m,m,isp,iapr) = (1._db,0._db)
            end do  
            if( icheck(23) > 1 ) write(3,501)
                               
          else

            if( icheck(23) > 1 ) then
              write(3,200) iapr, isp
              do m = -lhubb, lhubb
                write(3,205) Int_dens_all(m,-lhubb:lhubb,isp,iapr)     
              end do
            end if

            tip(:) = .false. 

            do i = -lhubb, lhubb
              rot(i,i,isp,iapr) = (1._db,0._db)
            end do

! en Fortran, le premier indice corespond a celui de la colonne

            do i = -lhubb, lhubb
              do j = -lhubb, lhubb
                test = max( eps10, abs(Int_dens_all(i,j,isp,iapr)), 
     &                                 abs(Int_dens_all(j,i,isp,iapr)) )
                if( test > eps10 .and. i /= j) tip(i) = .true.      ! marque d'un element superieur a zero
              end do
            end do

! evaluation de la taille de la petite matrice; si la grande est diagonale on n'entre pas ici
            idim = 0
            do i = -lhubb, lhubb
              if( tip(i) ) idim = idim + 1
            end do

            allocate( matr(idim,idim) )
            matr(:,:) = 0._db
            allocate( ui(idim,idim) )
            ui(:,:) = (0._db,0._db)
    
            ii = 0
            do m1 = -lhubb, lhubb 
              if(.not. tip(m1) ) cycle
              ii = ii + 1
              jj = 0
              do m2 = -lhubb, lhubb
                if(.not. tip(m2) ) cycle
                jj = jj + 1
                matr(ii,jj) = Int_dens_all(m1,m2,isp,iapr)
              end do
            end do

            if( icheck(23) > 2 ) then  
              write(3,300) iapr, isp
              do i = 1, idim
                write(3,205) matr(i,1:idim)
              end do
            end if

            lwork = 5*idim
            call matrix2(matr,ui,idim,lwork)

            if( icheck(23) > 2 ) then  
              write(3,301) 
              do i = 1, idim
                write(3,205) matr(i,1:idim)
              end do
            end if

! Recopie dans le sens inverse:

         ii = 0
         do m1 = -lhubb, lhubb 
          if(.not. tip(m1) ) cycle
          ii = ii + 1  
          jj = 0
          do m2 = -lhubb, lhubb
           if(.not. tip(m2) ) cycle
           jj = jj + 1
           rot(m1,m2,isp,iapr) = ui(ii,jj)
       !   rot(m2,m1,isp,iapr) = ui(ii,jj)
           if( m1 == m2 ) then
             Int_dens_all(m1,m2,isp,iapr) = matr(ii,jj)
           else
             Int_dens_all(m1,m2,isp,iapr) = 0._db
           end if
          end do
         end do

         deallocate( matr )
         deallocate( ui )

         if( icheck(23) > 1 ) then
          write(3,201) iapr, isp
          do m = -lhubb, lhubb
           write(3,205) Int_dens_all(m,-lhubb:lhubb,isp,iapr)     
          end do
         end if

         if( icheck(23) > 1 ) then
          write(3,401) iapr, isp
          do m = -lhubb, lhubb
           write(3,205) real(rot(m,-lhubb:lhubb,isp,iapr))     
          end do
         end if

! Test:
            do m1 = -lhubb, lhubb
              do m2 = -lhubb, lhubb
                if( aimag( rot(m1,m2,isp,iapr) ) > eps10 ) then
                  write(6,*) ' Complex rotation matrix! ' 
                  write(6,*) ' Code needs to be changed '
                  stop
                end if
              end do
            end do

          end if
        end do
      end do

      return
  100 format(/' ---- Diag_SO ------',100('-'))
  200 format(/' Occupation matrix Int_dens_all before rotation', 
     &' for iapr = ',i2,' isp = ',i2)
  201 format(/' Occupation matrix Int_dens_all after rotation', 
     &' for iapr = ',i2,' isp = ',i2)
  205 format(1p,7e13.5)
  300 format(/' Diagonalisable part of Int_dens_all before', 
     &' rotation for ia = ',i2,' isp = ',i2)
  301 format(/' After rotation: ')
  401 format(/' Rotation matrix for ia = ',i2,' isp = ',i2)
  501 format(/' No diagonalisation required !')
      end

!************************************************************************
! Sous programme qui calcule les vecteurs et les valeurs propres d'une matrice
! caree, reele et symmetrique

! apparament on peut faire la meme chose en utilisant une seule routine: dsyev

      subroutine matrix(m,u,n,lwork)

      use declarations
      implicit none

      integer n, lwork, info, i
      real(kind=db), dimension(n,n)::m, u
      real(kind=db), dimension(n):: d
      real(kind=db), dimension(n-1):: e, tau 
      real(kind=db), dimension(lwork):: work
      real(kind=db), dimension(2*n - 2):: work2

! n: dimension de la matrice
! m: matrice reele n x n, symmetrique
!            en entree: la matrice cible
!            en sortie: la matrice diagonale

! u: matrice de rotation; sur ses colonnes on retrouve les vecteurs propres
!               ortogonale, car la matrice de depart etait reele et symmetrique

! dsytrd: en entree, u = matrice cible
! dsytrd: en sortie, u = forme tridiagonale qui admet les memes valeurs propres que la matrice de depart

! dorgtr: en entree, u = forme tridiagonale
! dorgtr: en sortie, u = matrice ortogonale qui diagonalise la forme tridiagonale

! dsteqr: en sortie, u = matrice ortogonale qui diagonalise la matrice de depart
!                    d = les valeurs propres 

      u(:,:) = m(:,:)
      call dsytrd('U',n,u,n,d,e,tau,work,lwork,info)
      call dorgtr('U',n,u,n,tau,work,lwork,info)
      call dsteqr('V',n,d,e,u,n,work2,info)

!     m = matmul(transpose(u),matmul(b,u))
      m(:,:) = 0._db
      do i = 1, n
        m(i,i) = d(i)
      end do
      
      return
      end  

!************************************************************************
! Sous programme qui calcule les vecteurs et les valeurs propres d'une matrice
! caree, reele et non - symmetrique

      subroutine matrix2(m,ui,n,lwork)

      use declarations
      implicit none
      integer n, lwork, info, i, j

      complex(kind=db), dimension(n,n):: ui
      real(kind=db), dimension(n,n)::m, vl, vr
      real(kind=db), dimension(n):: wr, wi
      real(kind=db), dimension(lwork):: work
 
! n: dimension de la matrice
! m: matrice reele n x n, non - symmetrique
!            en entree: la matrice cible
!            en sortie: ????

! u: matrice de rotation; sur ses colonnes on retrouve les vecteurs propres; a regarder le code pour les detail
!        d'apres la theorie elle n'est pas forcement ortogonale, car la matrice de depart n'etait symmetrique

      call dgeev('N','V',n,m,n,wr,wi,vl,n,vr,n,work,lwork,info)


! On reecrit la matrice diagonalisee:
     
      m(:,:) = 0._db
      do i = 1, n
        m(i,i) = wr(i)
      end do
  
      j = 0
      do i = 1, n
        j = j + 1
        if( abs( wi(i) ) < 1.e-10_db ) then  ! valeur propre reele
          ui(:,i) = cmplx( vr(:,i), 0, db )
        else                             ! conformement a la documentation de LAPACK
          ui(:,j) = cmplx( vr(:,j), vr(:,j+1) )
          ui(:,j+1) = cmplx( vr(:,j), - vr(:,j+1) )
          j = j + 1    
        end if
      end do
      
      return
      end

!****************************************************************************************
! Sousroutine qui corrige l'energie sortie du calcul DFT avec la formule ....
! les energies sont en rydb
      
      subroutine en_DFT(En_cluster,Energ_self,en_coeur,excato,
     &           Full_atom,iaprotoi,ipr0,it0,itypepr,n_atom_0,
     &           n_atom_0_self,n_atom_ind,n_atom_ind_self,n_atom_proto,
     &           natome,nb_eq,ngreq,nrm,nrm_self,nrato,
     &           nspin,ntype,numat,rato,rho_self,rmtsd,Vcato,Vxcato)
   
      use declarations
      implicit real(kind=db) (a-h,o-z)
      include 'mpif.h'

      integer, dimension(it0:ntype):: nrato, numat
      integer, dimension(natome):: iaprotoi, nb_eq
      integer, dimension(ipr0:n_atom_proto):: itypepr, ngreq

      logical Full_atom

      real(kind=db), dimension(0:nrm_self,nspin,
     &                   n_atom_0_self:n_atom_ind_self):: rho_self
      real(kind=db), dimension(nrm,n_atom_0:n_atom_ind):: excato
      real(kind=db), dimension(n_atom_0_self:n_atom_ind_self)::
     &                   En_coeur, Energ_self, Energ_self_KS, 
     &                   Fonc_exc, Fonc_coul, Vxc_int
      real(kind=db), dimension(0:nrm,it0:ntype):: rato
      real(kind=db), dimension(0:nrm,nspin,n_atom_0:n_atom_ind):: Vxcato
      real(kind=db), dimension(0:nrm,n_atom_0:n_atom_ind):: Vcato, 
     &                                                      Vhartree                                                       
      real(kind=db), dimension(0:nrm):: fct1, fct2, fct3, r, r2
      real(kind=db), dimension(ipr0:n_atom_proto):: rmtsd

      common/icheck/ icheck(24)

! Enragr: la somme des valeurs propres pour les orbitales Kohn Sham occup�es

      if( nrm /= nrm_self ) return  ! car rho_self n'est pas calcule

      Energ_self_KS(:) = Energ_self(:)

      boucle_ia: do iapr = n_atom_0_self,n_atom_ind_self
        if( Full_atom ) then
          ipr = iaprotoi(iapr)
        else
          ipr = iapr
        endif 
        it = itypepr(ipr)
        nr = nrato(it)   
        r(:) = rato(:,it)  
        r2(1:nr) = r(1:nr)**2
        r2(0) = 0._db  

        fct1(:) = 0._db; fct2(:) = 0._db; fct3(:) = 0._db

! le potentiel dont on a besoin pour la correction est le vrai Hartree, c'est a dire il
!    faut enlever la contribution des noyaux
       
        Vhartree(1:nr,iapr) = Vcato(1:nr,iapr) + 2 * numat(it) / r(1:nr)

        do ir = 1,nr 
          fac = sum( rho_self(ir,1:nspin,iapr) ) * r2(ir) 
          fct1(ir) = excato(ir,iapr) * fac
          fct2(ir) = Vhartree(ir,iapr) * fac
        end do 

        Fonc_exc(iapr)=quatre_pi * f_integr3(r,fct1,nr,0,nrm,Rmtsd(ipr))
        Fonc_coul(iapr)=quatre_pi *f_integr3(r,fct2,nr,0,nrm,Rmtsd(ipr))

        Vxc_int(iapr) = 0._db
        do ispin = 1, nspin
          do ir = 1,nr
            fct3(ir) = Vxcato(ir,ispin,iapr) * rho_self(ir,ispin,iapr)
     &               * r2(ir)
          end do
          Vxc_int(iapr) = Vxc_int(iapr)
     &               + quatre_pi * f_integr3(r,fct3,nr,0,nrm,Rmtsd(ipr))
        end do

! En_coeur: energie des orbitales KS correspondant aux etats de coeur,
! pour chaque atome;

! ATTENTION aux signes
        Energ_self(iapr) = Energ_self_KS(iapr) + En_coeur(iapr)  
     &               + Fonc_exc(iapr) - Fonc_coul(iapr) - Vxc_int(iapr) 

      end do boucle_ia

      Energ_self_KS_agr = 0._db
      Delta_En_coeur_agr = 0._db
      Fonc_exc_agr = 0._db
      Fonc_coul_agr = 0._db
      Vxc_int_agr = 0._db
      En_cluster = 0._db
       
      do iapr = n_atom_0_self,n_atom_ind_self
        if( Full_atom ) then
          n = nb_eq(iapr)
        else
          n = ngreq(iapr)
        endif
        Energ_self_KS_agr = Energ_self_KS_agr + n * Energ_self_KS(iapr)
        Delta_En_coeur_agr = Delta_En_coeur_agr + n * En_coeur(iapr)
        Fonc_exc_agr = fonc_exc_agr + n * Fonc_exc(iapr)
        Fonc_coul_agr = fonc_coul_agr + n * Fonc_coul(iapr)
        Vxc_int_agr = Vxc_int_agr + n * Vxc_int(iapr)
        En_cluster = En_cluster + n * Energ_self(iapr)
      end do

      if( icheck(21) > 0 ) then
        write(3,100)
        write(3,150) En_cluster * rydb
        write(3,500)
        do iapr = n_atom_0_self,n_atom_ind_self
          write(3,510) iapr, Energ_self(iapr) * rydb, 
     &       Energ_self_KS(iapr) * rydb, En_coeur(iapr) * rydb,  
     &       Fonc_exc(iapr) * rydb, Fonc_coul(iapr) * rydb,
     &       Vxc_int(iapr) * rydb
        end do 
        write(3,520) En_cluster * rydb, 
     &       Energ_self_KS_agr * rydb, Delta_En_coeur_agr * rydb, 
     &       Fonc_exc_agr * rydb, Fonc_coul_agr * rydb,  
     &       Vxc_int_agr * rydb
      end if

      return 

  100 format(/' ---- En_DFT ------',100('-'))
  150 format(/' Cluster energy: ', f12.3,' eV')
  500 format(/'  ia    Energ_atom      Energ_KS', 
     &  '   delta_En_coeur   Fonc_exc     Fonc_coul      Vxc_int')
  510 format(i4, 6(2x, f12.3))
  520 format(/' Sum',6(2x, f12.3))
      end

!********************************************************************************

! Sousprogramme qui calcule l'energie de la derniere orbitales de coeur Kohn Sham;
! On considere que pendant les iterations la fonction d'onde de cette orbitale ne
! se modifie pas, par contre le potentiel et donc son energie bougent. On fait 
! l'approximation que ce deplacement est le meme pour tous les niveaux de coeur 

! le resultat sera utilise pour le calcul de l'energie de l'agregat

      subroutine eps_coeur(ch_coeur,En_coeur,Full_atom,iaprotoi,
     &            ipr0,it0,itypepr,lcoeur,n_atom_0,n_atom_0_self,
     &            n_atom_ind,n_atom_ind_self,n_atom_proto,
     &            natome,nrato,nrm,
     &            nspin,ntype,psi_coeur,rato,Vcato,Vxcato)

      use declarations
      implicit none

      integer iapr, ipr, ipr0, ir, it, it0, l2, natome,
     &        n_atom_0, n_atom_0_self, n_atom_ind, n_atom_ind_self,
     &        n_atom_proto, nr, nrm, nspin, ntype

      logical Full_atom

      integer,dimension(2,it0:ntype):: lcoeur
      integer,dimension(natome):: iaprotoi
      integer,dimension(ipr0:n_atom_proto):: itypepr
      integer,dimension(it0:ntype):: nrato

      real(kind=db):: pp, psiHpsi, Vxc, Veq, res

      real(kind=db),dimension(n_atom_0_self:n_atom_ind_self):: ch_coeur
      real(kind=db),dimension(n_atom_0_self:n_atom_ind_self):: En_coeur
      real(kind=db),dimension(0:nrm,it0:ntype):: rato
      real(kind=db),dimension(0:nrm):: r, psi, pot
      real(kind=db),dimension(0:nrm,n_atom_0:n_atom_ind):: Vcato
      real(kind=db),dimension(0:nrm,nspin,n_atom_0:n_atom_ind):: Vxcato
      real(kind=db),dimension(0:nrm,2,it0:ntype):: psi_coeur

      En_coeur(:) = 0._db
      
      do iapr = n_atom_0_self,n_atom_ind_self
        if( Full_atom ) then
          ipr = iaprotoi(iapr)
        else
          ipr = iapr
        endif
        it = itypepr(ipr)
        l2 = lcoeur(1,it)**2 + lcoeur(1,it)
        nr = nrato(it)
        r(:) = rato(:,it)
 ! On fait une moyenne sur les deux spins, si besoin :
        do ir = 1, nrm
          Vxc = sum( Vxcato(ir,1:nspin,iapr) ) / nspin
          Veq =  Vcato(ir,iapr) + Vxc + l2 / r(ir)**2
          pot(ir) = Veq
          psi(ir) = psi_coeur(ir,1,it)
        end do
        res = psiHpsi(nr,nrm,pot,pp,psi,r)
        En_coeur(iapr) = res * ch_coeur(iapr)                         
      end do

      return
      end



