! Subroutine of the FDMNES Package
! Contain the main of the FDM-MST part of the calculation

      subroutine fdm(comt,convolution_cal,
     &      fit_cal,green_plus,ifile_notskip,indice_par,iscratch,
     &      itape1,itape4,Length_word,mpinodes,mpirank,
     &      n_atom_proto_p,ngroup_par,nnotskip,nnotskipm,
     &      nomfich,npar,nparm,param,Space_file,typepar)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      include 'mpif.h'

      parameter( n_tens_dd=9, n_tens_dq=15, n_tens_qq=25,
     &         n_tens_t = n_tens_dd + n_tens_dq + n_tens_qq,
     &         n_tens_max = 8 + 2 * n_tens_t + 2 * n_tens_dq ) 

      character(len=3) seuil
      character(len=9):: keyword
      character(len=132):: comt, identmot, mot, nomfich, nomfichbav,
     &   nomfich_s, nomstruct, nomvcoul, nomr2v, nompsii, Space_file
      character(len=6), dimension(10):: nomspr
      character(len=9), dimension(ngroup_par,nparm):: typepar
      character(len=13), dimension(:), allocatable:: ltypcal
      character(len=35), dimension(:), allocatable:: com
      character(len=Length_word), dimension(:), allocatable:: nomabs
      character(len=132), dimension(:), allocatable:: nomfich_cal_convt,
     &      nom_fich_extract, nomfile_atom, nomclm
      character(len=132), dimension(:,:), allocatable:: nomfich_cal_conv

      complex(kind=db), dimension(:), allocatable:: konde, phdf0t, phdt 
      complex(kind=db), dimension(:,:), allocatable:: phdafs,  
     &      phdf0tscan, phdtscan, ple, pls
      complex(kind=db), dimension(:,:,:), allocatable:: bessel, 
     &       neuman, poldafsescan, poldafssscan
      complex(kind=db), dimension(:,:,:,:), allocatable:: rot,  
     &      tauab, tauabs, taull_abs
      complex(kind=db), dimension(:,:,:,:,:), allocatable:: rof, rofsd, 
     &                     secdd, secmd, secmm, singul, taull
      complex(kind=db), dimension(:,:,:,:,:,:), allocatable::  
     &                           rofsd_hd, rhov_self, secdq 
      complex(kind=db), dimension(:,:,:,:,:,:,:), allocatable:: 
     &                       secdo, secqq 

      integer:: extract_nenerg, Z, Z_nospinorbite
      integer, dimension(ngroup_par) :: npar
      integer, dimension(nnotskipm) :: ifile_notskip
      integer, dimension(ngroup_par,nparm) :: indice_par

      integer, dimension(:), allocatable :: ia_eq_inv, ia_eq_inv_self,     
     &   iabsm,  iabsorig, iapot, iaproto, iaprotoi, icom, igroup,  
     &   imoy, imoy_out, isrt, isymeq, itdil, its_lapw, itype,
     &   itypei, itypep, itypepr, 
     &   ldil, lmaxa, lmaxat, lmaxt, lval, nb_eq, nbord, nbordf,  
     &   ngreq, ngreqm, nlat, nlmsa, nlmso0, norbv, nrato, 
     &   nrato_lapw, nrmtg, nsymextract, numat, numia

      integer, dimension(:,:), allocatable :: hkl_dafs, ia_eq,  
     &   ia_eq_sym, ibord, igreq, indice, iopsym_atom, is_eq, isbord,
     &   isigpi, isymqa, isvois, ivois, iso, lcoeur, lso, lvval,
     &   mso, nb_rpr, ncoeur, nlmsa0, nvval
      integer, dimension(:,:,:), allocatable ::
     &   ia_rep, iato, lato, mato, mpres, nb_rep_t

      logical Absauto, Absorbeur, allsite, Atom_nonsph, Atom_occ_mat,
     &   basereel, base_hexa, base_ortho, Biology, clementi,
     &   convergence, cal_xanes, convolution_cal,  
     &   coupelapw, dafs, E_comp, eneg, eneg_i,
     &   eneg_n_i, energphot, etatlie, extract, extract_green,  
     &   fermi, fit_cal, flapw, force_ecr, Full_atom, Full_atom_e,  
     &   green, green_plus, green_s, green_self, hubbard, key_calc,   
     &   korigimp, Level_val_abs, Level_val_exc, lmaxfree, lmoins1,
     &   lplus1, magnetic, matper, muffintin, moyenne, noncentre,    
     &   non_exc_g, nonexc, normaltau, octupole, overad, Proto_all,      
     &   quadrupole, relativiste, rydberg, self_abs, self_cons, 
     &   self_non_exc, solsing, solsing_s, solsing_only, state_all, 
     &   state_dens, spino, spinorbite, supermuf,  
     &   symauto, Taux, trace_format_wien, xan_atom, Ylm_complex

      logical, dimension(:), allocatable:: Atom_comp,
     &   Atom_mag_gr, Atom_nsph, hubb, run_done, Skip_run, sgn
     
      real(kind=db):: tp(6), tpt(10)
      real(kind=db), dimension(3,3):: rot_atom_abs
      real(kind=db), dimension(2):: chg_level
      real(kind=db), dimension(ngroup_par,nparm):: param 
      real(kind=db), dimension(:), allocatable:: cdil, ch_coeur,  
     &   chargat, chargat_init, chargat_self, chargat_self_s,  
     &   cgrad, clapl, dista, distai, dv0bdcF, dvc_ex_nex, dv_ex_nex, 
     &   ecinetic, ecinetic_out, ecrantage, eeient, energ, 
     &   ef, egamme, eimag, eimag_coh, eimag_s, eimagent,  
     &   energ_coh, energ_s, Energ_self, Energ_self_s, En_coeur,   
     &   En_coeur_s, poidso, poidsov, poidsov_out, pop_orb_val, 
     &   popatc, psii, r0_lapw, rato_e, rchimp, rhons, rlapw, rmt,
     &   rmtimp, rmtg, rmtg0, rmtsd, rs, rvol, sec_atom, Taux_eq, 
     &   Taux_ipr, Taux_oc, 
     &   v_abs_i, V_hubbard, vh, vhns, v0bd, v0bd_out, v0bdcFimp
      real(kind=db), dimension(:,:), allocatable :: 
     &   angpoldafs, Axe_atom_clu, Axe_Atom_Clui, Axe_atom_gr,
     &   drho_ex_nex, efato, excato, Int_tens, occ_mat_gr, pdp, pdpolar,
     &   poidsa, polar, poldafse, poldafsei, poldafss, poldafssi,  
     &   pop_level, pop_nonsph, popatv, popexc, pos, post,   
     &   poseq, posi, posi_self, posn, rato, rho, rho_coeur,  
     &   rho_cor, rhoit, rsato, Vcato, vcato_init, vecdafse, 
     &   vecdafss, veconde, vr, vrato_e, vxc, voe, vos, xyz, ylmso
      real(kind=db), dimension(:,:,:), allocatable:: 
     &   gradvr, hybrid, Int_statedens, popatm,popats, popval, 
     &   posq, psi_level, psi_coeur, psival, rho_chg, rho_self,  
     &   rho_self_s, rhoato_init, rot_atom, rot_atom_gr, 
     &   rotloc_lapw, singulsd, vecdafsescan, vecdafssscan,
     &   vrato, vxcato, ylmato
      real(kind=db), dimension(:,:,:,:), allocatable:: drho_self, 
     &         Int_dens_all, Int_dens_all_s, sing_self,  
     &         statedens
      real(kind=db), dimension(:,:,:,:,:), allocatable:: statedens_hd
      real(kind=db), dimension(:,:,:,:,:,:), allocatable:: phiato

      real(kind=sg) time
      
      common/Atom_nonsph/ Atom_nonsph
      common/base_hexa/ base_hexa
      common/base_ortho/ base_ortho
      common/eseuil/ eseuil(2)
      common/icheck/ icheck(24)
      common/iopsymc/ iopsymc(nopsm)
      common/iopsymr/ iopsymr(nopsm)
      common/lseuil/ jseuil, lseuil, nseuil
      common/orthmat/ orthmat(3,3), orthmati(3,3)
      common/Z_nospinorbite/ Z_nospinorbite

      data nomspr/'Lectur','Reseau','Potent','Ylm   ','Potex ',
     &   'Sphere','Mat   ','Tensor','Coabs ','Total '/

      if( mpirank == 0 ) then
        call CPU_TIME(time)
        tp1 = real(time,db)
      endif

      En_Fermi = -5._db / Rydb
      E_cut = En_Fermi
      E_Level_val_abs = En_Fermi
      E_Level_val_exc = En_Fermi
      chg_val_p = 0._db

      call lectdim(Absauto,Atom_occ_mat,Biology,extract,flapw,
     &      hubbard,itape4,magnetic,mpinodes,mpirank,
     &      n_multi_run_e,ncolm,neimagent,nenerg_s,ngamme,ngroup,
     &      ngroup_neq,nhybm,nklapw,nlatm,nlmlapwm,nmatsym,
     &      nonexc,norbdil,npldafs,nple,
     &      npltm,nspin,nspino,ntype,self_abs,Space_file,Taux,xan_atom)

      if( Atom_nonsph ) then
      ngroup_nonsph = ngroup
      else
      ngroup_nonsph = 1
      endif
      if( flapw ) then
      ngroup_lapw = ngroup_neq
      else
      ngroup_lapw = 1
      endif
      if( flapw .or. nonexc ) then
      ipr0 = 1
      it0 = 1
      else
      ipr0 = 0
      it0 = 0
      endif

      allocate( egamme(ngamme) )
      allocate( eeient(neimagent) )
      allocate( eimagent(neimagent) )
      allocate( angpoldafs(3,npldafs) )
      allocate( Atom_nsph(ngroup) )    
      allocate( Axe_atom_gr(3,ngroup) )
      allocate( com(it0:ntype) )
      allocate( cdil(norbdil) )
      allocate( ecrantage(nspin) )
      allocate( hkl_dafs(3,npldafs) )
      allocate( hybrid(nhybm,16,ngroup_nonsph) ) 
      allocate( iabsm(n_multi_run_e) )
      allocate( iabsorig(n_multi_run_e) )
      allocate( icom(it0:ntype) )
      allocate( isigpi(npldafs,2) )
      allocate( itdil(norbdil) )
      allocate( its_lapw(ngroup_lapw) )
      allocate( itype(ngroup) )
      allocate( ldil(norbdil) )
      allocate( lvval(it0:ntype,nlatm) )
      allocate( nlat(it0:ntype) )
      allocate( nom_fich_extract(n_multi_run_e) )
      allocate( nomclm(2*nspin-1) ) 
      allocate( nomfile_atom(it0:ntype) )
      allocate( norbv(0:ngroup_nonsph) )
      allocate( nrato(it0:ntype) )
      allocate( nrato_lapw(it0:ntype) )
      allocate( nsymextract(n_multi_run_e) )
      allocate( numat(it0:ntype) )
      allocate( nvval(it0:ntype,nlatm) )
      allocate( occ_mat_gr(14,ngroup) )
      allocate( pdpolar(nple,2) )
      allocate( polar(3,nple) )
      allocate( poldafse(3,npldafs) )
      allocate( poldafsei(3,npldafs) )
      allocate( poldafss(3,npldafs) )
      allocate( poldafssi(3,npldafs) )
      allocate( pop_nonsph(nhybm,ngroup_nonsph) ) 
      allocate( popatc(it0:ntype) )
      allocate( popats(ngroup,nlatm,nspin) )
      allocate( popatv(it0:ntype,nlatm) )
      allocate( popexc(nnlm,nspin) )
      allocate( popval(it0:ntype,nlatm,nspin) )
      allocate( posn(3,ngroup) ) 
      allocate( r0_lapw(it0:ntype) )
      allocate( rchimp(it0:ntype) )
      allocate( rlapw(it0:ntype) )
      allocate( rmt(it0:ntype) )
      allocate( rmtimp(it0:ntype) )
      allocate( rotloc_lapw(3,3,ngroup_lapw) )
      allocate( Rot_Atom_gr(3,3,ngroup) )
      allocate( Taux_oc(ngroup) ) 
      allocate( V_hubbard(it0:ntype) )
      allocate( hubb(it0:ntype) )
      allocate( v0bdcFimp(nspin) )
      allocate( vecdafse(3,npldafs) )
      allocate( vecdafss(3,npldafs) )
      allocate( veconde(3,nple) )

      if( mpinodes > 1 ) call MPI_BARRIER(MPI_COMM_WORLD,mpierr) 

      call lectur(allsite,angpoldafs,Atom_occ_mat,Atom_nsph,
     &  Axe_atom_gr,basereel,clementi,com,comt,coupelapw,
     &  dafs,eclie,ecrantage,eeient,egamme,eimagent,Delta_En_conv,
     &  eneg_i,eneg_n_i,energphot,etatlie,extract,fit_cal,
     &  flapw,force_ecr,Full_atom_e,green_s,green_self,
     &  hkl_dafs,hubb,hubbard,hybrid,iabsm,iabsorig,icom,
     &  indice_par,iscratch,isigpi,it0,itdil,its_lapw,iord,itape4,itype,
     &  korigimp,l_selec_max,lamstdens,ldil,
     &  lecrantage,lin_gam,lmaxfree,lmaxso0,lmaxat0,
     &  lmoins1,lplus1,lvval,magnetic,matper,mpinodes,mpirank,muffintin,
     &  multrmax,n_atom_proto,n_multi_run_e,nbseuil,nchemin,necrantage,
     &  neimagent,nenerg_s,ngamme,ngroup,ngroup_lapw,ngroup_neq,
     &  ngroup_nonsph,ngroup_par,nhybm,nlat,nlatm,nom_fich_extract,
     &  nomfich,nomfichbav,nomclm,nomfile_atom,nompsii,nomr2v,nomstruct,
     &  nomvcoul,noncentre,nonexc,norbdil,norbv,normaltau,npar,nparm,
     &  nphim,npldafs,nple,nplei,nrato,nrato_dirac,nrato_lapw,nrm,nself,
     &  nspin,nspinr,nsymextract,ntype,numat,numat_abs,nvval,occ_mat_gr,
     &  octupole,overad,overlap,p_self0,
     &  param,pdpolar,polar,poldafse,poldafsei,poldafss,poldafssi,
     &  pop_nonsph,popatc,popats,popatv,popval,posn,quadrupole,r0_lapw,
     &  rchimp,relativiste,r_self,rlapw,rmt,rmtimp,Rot_Atom_gr,
     &  rotloc_lapw,roverad,rpotmax,rydberg,rsorte_s,self_abs,
     &  self_cons,self_non_exc,seuil,solsing_s,solsing_only,Space_file,
     &  spinorbite,state_dens,state_all,supermuf,symauto,Taux,Taux_oc,
     &  temp,trace_format_wien,typepar,V_hubbard,vecdafse,vecdafss,
     &  veconde,v0bdcFimp,Ylm_complex)

      if( icheck(1) > 0 .and. mpirank == 0 ) then
        if( mpinodes > 1 ) then
          write(3,110) mpinodes
        else
          write(3,120) 
        endif  
      endif

      if( mpirank /= 0 .and. extract ) goto 1040

      if( extract ) then
        mpinodee = 1
      else
        mpinodee = mpinodes
      endif

      allocate( lcoeur(2,it0:ntype) )
      allocate( ncoeur(2,it0:ntype) )
      allocate( psi_coeur(0:nrm,2,it0:ntype) )
      allocate( psii(nrm) )
      allocate( psival(0:nrm,nlatm,it0:ntype) )
      allocate( psi_level(0:nrm,it0:ntype,2) )
      allocate( pop_level(it0:ntype,2) )
      allocate( rato(0:nrm,it0:ntype) )
      allocate( rhoit(0:nrm,it0:ntype) )
      allocate( rho_coeur(0:nrm,it0:ntype) )
      allocate( rho_cor(0:nrm,it0:ntype) )
    
      call atom(chg_val_ref,clementi,com,icom,it0,itype,lcoeur,
     &      lvval,mpinodee,mpirank,ncoeur,ngroup,nlat,nlatm,
     &      nomfile_atom,nonexc,nrato,nrato_dirac,nrato_lapw,nrm,nspin,
     &      ntype,numat,nvval,pop_level,popatc,popats,popatv,
     &      popexc,popval,psi_coeur,psii,psi_level,psival,
     &      r0_lapw,rato,rho_coeur,rhoit,rlapw,rmt)
        
      allocate( Atom_mag_gr(0:ngroup) )

      if( symauto ) then
        if( mpirank == 0 )
     &    call symsite(absauto,Atom_mag_gr,Atom_nsph,Axe_atom_gr,
     &      base_ortho,Biology,flapw,iabsm,iscratch,it0,itype,magnetic,
     &      matper,mpirank,n_atom_proto,n_multi_run_e,ngroup,nlat,nlatm,
     &      nspin,ntype,numat,numat_abs,popats,posn)
        if( mpinodee > 1 ) then
          call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
          call MPI_Bcast(n_atom_proto,1,MPI_INTEGER,0,MPI_COMM_WORLD,
     &             mpierr)
          call MPI_Bcast(Atom_mag_gr,ngroup+1,MPI_LOGICAL,0,
     &             MPI_COMM_WORLD,mpierr)
          call MPI_Bcast(base_ortho,1,MPI_LOGICAL,0,MPI_COMM_WORLD,
     &             mpierr)
        endif
      endif

      call esdata(nbseuil,numat_abs,workf,mpirank)
      if( flapw ) workf = 0._db

      allocate( igreq(ipr0:n_atom_proto,ngroup) )
      allocate( isymqa(ipr0:n_atom_proto,ngroup) )
      allocate( ngreq(ipr0:n_atom_proto) )
      allocate( posq(3,n_atom_proto,ngroup) )  

      if( mpirank == 0 ) then
        Rewind(iscratch)
        do ipr = 1,n_atom_proto
          read(iscratch,*) ngreq(ipr)
          do i = 1,ngreq(ipr)
            read(iscratch,*) igreq(ipr,i), posq(:,ipr,i), isymqa(ipr,i)
          end do
        end do
        Close(iscratch)
      endif

      if( mpinodee > 1 ) then
        nn = n_atom_proto - ipr0 + 1 
        ndim = nn * ngroup
        n = 3 * n_atom_proto * ngroup
        call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(igreq,ndim,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(ngreq,nn,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(isymqa,ndim,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
        call MPI_Bcast(posq,n,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
      endif

      if( absauto ) then
        multi_run = 0
        do ipr = 1,n_atom_proto
          it = abs( itype(igreq(ipr,1)) ) 
          if( numat( it ) /= numat_abs ) cycle
          multi_run = multi_run + 1
        end do 
        n_multi_run = multi_run
      else
        n_multi_run = n_multi_run_e 
      endif
 
      allocate( chargat(ipr0:n_atom_proto) )
      allocate( ngreqm(n_multi_run) )
      allocate( nomfich_cal_conv(n_multi_run,nbseuil) )
      allocate( nomfich_cal_convt(nbseuil) )
      allocate( popatm(ipr0:n_atom_proto,nlatm,nspin) )
      allocate( run_done(n_multi_run) )
      run_done(:) = .false.
      allocate( Skip_run(n_multi_run) )
      Skip_run(:) = .false.

      if( absauto ) then
        deallocate( iabsm )
        deallocate( iabsorig )
        allocate( iabsm(n_multi_run) )
        allocate( iabsorig(n_multi_run) )
        multi_run = 0
        do ipr = 1,n_atom_proto
          it = abs( itype(igreq(ipr,1)) ) 
          if( numat( it ) /= numat_abs ) cycle
          multi_run = multi_run + 1
          iabsm(multi_run) = igreq(ipr,1) 
          iabsorig(multi_run) = ipr 
        end do 
      endif

      call pop_proto(chargat,chargm,flapw,iabsm,igreq,ipr0,
     &      it0,itype,mpirank,n_atom_proto,n_multi_run,ngreq,ngreqm,
     &      ngroup,nlat,nlatm,nspin,ntype,numat,popatc,popatm,
     &      popats,run_done)

      if( nnotskip > 0 .and. extract .and.
     &                 n_atom_proto_p == n_atom_proto ) then
        do multi_run = 1,n_multi_run
          Skip_run(multi_run) = .true.
          do i = 1,nnotskip
            if( ifile_notskip(i) == iabsorig(multi_run) ) 
     &                      Skip_run(multi_run) = .false.
          end do
        end do
      endif

      n_atom_proto_p = n_atom_proto

      if( .not. extract ) then
        allocate( energ_s(nenerg_s) )
        allocate( eimag_s(nenerg_s) )
        call grille_xanes(eeient,eimag_s,eimagent,egamme,energ_s,
     &      lin_gam,ngamme,neimagent,nenerg_s)
      endif

      deallocate( egamme )
      deallocate( eeient )
      deallocate( eimagent )

      if( mpirank == 0 ) then
        call CPU_TIME(time)
        tp2 = real(time,db)
        tpt(1) = tp2 - tp1
      endif

! Boucle sur tous les absorbeurs nonequivalents selon le groupe d'espace 

      do multi_run = 1,n_multi_run

        if( mpirank == 0 ) then
          tpt(2:9) = 0._db
          tpt1 = 0._db
          tpt2 = 0._db
          call CPU_TIME(time)
          tp(1) = real(time,db)
          tp_init = tp(1)
        endif

        if( extract ) then
          Epsii = extract_Epsii(nom_fich_extract(multi_run)) 
          v0bdcF = extract_v0bdcF(nom_fich_extract(multi_run))
          v0muf = workF + v0bdcF
        endif 

        if( run_done(multi_run) .or. Skip_run(multi_run) ) cycle

        if( extract ) then
          green_s = extract_green(nom_fich_extract(multi_run)) 
          nenerg_s = extract_nenerg(nbseuil,nom_fich_extract(multi_run))
          E_cut = extract_E_cut(nom_fich_extract(multi_run)) 
        endif 

        iabsorbeur = iabsm(multi_run)
        it_abs = abs(itype(iabsorbeur)) 
        numat_abs = numat( it_abs )

        nomfich_s = nomfich
        m = min( multi_run, n_multi_run_e )

        call init_run(chg_val_ref,com,ecrantage,Epsii,
     &    extract,force_ecr,hubb,iabsm(multi_run),
     &    iabsorig(multi_run),icom,it0,itabs,itype,lcoeur,lecrantage,
     &    lvval,mpinodee,mpirank,n_multi_run,ncoeur,necrantage,
     &    ngroup,nlat,nlatm,nom_fich_extract(m),nomfich_s,nomfichbav,
     &    nompsii,nonexc,nrato,nrato_dirac,nrm,nspin,ntype,numat,
     &    nvval,pop_level,popatc,popats,popatv,popexc,
     &    popval,psi_coeur,psii,psi_level,psival,
     &    rato,rchimp,rho_coeur,rhoit,rmt,rmtimp,V_hubbard)
    
        boucle_1: do iprabs = 1,n_atom_proto
          do i = 1,ngreq(iprabs)
            if( abs(igreq(iprabs,i)) == iabsorbeur ) exit boucle_1
          end do
        end do boucle_1

        natomsym = ngreq(iprabs)
        allocate( poseq(3,natomsym) )
        allocate( isymeq(natomsym) )
        allocate( Taux_eq(natomsym) )

        poseq(:,1:natomsym) = posq(:,iprabs,1:natomsym)
        isymeq(1:natomsym) = isymqa(iprabs,1:natomsym)
        Taux_eq(1:natomsym) = Taux_oc( abs( igreq(iprabs,1:natomsym) ) )

        if( extract ) then
          allocate( energ_s(nenerg_s) )
          allocate( eimag_s(nenerg_s) )
          call extract_energ(nbseuil,energ_s,nenerg_s,
     &                  nom_fich_extract(multi_run))
        endif

        allocate( iapot( ipr0:n_atom_proto ) )
        allocate( itypepr( ipr0:n_atom_proto ) )

        call screening(chargat,chargm,flapw,iabsorbeur,igreq,ipr0,
     &      isymqa,it0,itabs,iprabs,itype,itypepr,lvval,n_atom_proto,
     &      ngreq,ngroup,nlat,nlatm,nonexc,nspin,ntype,numat_abs,
     &      nvval,popatm,popexc)

        d_ecrant = 1 - sum( ecrantage(:) )         
        call natomp_cal(Biology,chargat,d_ecrant,flapw,iabsorbeur,
     &         igreq,ipr0,itabs,itype,matper,mpirank,multrmax,
     &         n_atom_proto,natomeq_s,natomeq_coh,natomp,ngreq,ngroup,
     &         noncentre,posn,Proto_all,r_self,rsorte_s,rmax,rpotmax,
     &         self_cons)

        allocate( Axe_atom_clu(3,natomp) )
        allocate( iaproto(natomp) )
        allocate( igroup(natomp) )
        allocate( itypep(natomp) )
        allocate( dista(natomp) )
        allocate( pos(3,natomp) )
      
! Preambule coherence: 
        if( self_cons ) then
          convergence = .false.
        else
          convergence = .true. 
        end if 

! On augmente lla_state afin de calculer les electrons des harmoniques
! superieures
        if( .not. extract ) then
          lla_state = 4               
          lla2_state = ( lla_state + 1 )**2
        end if
        if( hubbard ) then
          m_hubb = 0
          do it = it0, ntype
            lh = l_hubbard(numat(it))
            if( hubb(it) )  m_hubb = max( m_hubb, lh)
          end do
        else
          m_hubb = 0
        endif

! Boucle coherence
        boucle_coh: do i_self = 1,nself+1
                
          if( convergence .and. i_self < nself + 1 ) cycle
          if( i_self == nself + 1 ) then
            cal_xanes = .true.
          else
            cal_xanes = convergence
            fermi = .false.
            En_fermi = -5._db / Rydb
            E_cut = -5._db / Rydb
          end if   

          Level_val_abs = .false.
          Level_val_exc = .false.

! Par defaut, le calcul auto-coherent se fait en diffusion multiple
! Un calcul non auto-coherent est mene en mode donne en entree        
          if( cal_xanes ) then
            natomeq = natomeq_s
            green = green_s
            rsorte = rsorte_s
           else 
            natomeq = natomeq_coh 
            green = green_self
            rsorte = r_self
          endif
          if( green ) then
            eneg = .not. eneg_n_i
          else
            eneg = eneg_i
          endif 
          if( cal_xanes .and. icheck(1) > 0 )
     &                                write(3,520) E_cut * Rydb

          if( i_self == 1 .or. cal_xanes ) then 
            if( cal_xanes ) then
              non_exc_g = nonexc
              l_val_max = l_selec_max
            else
              non_exc_g = self_non_exc
              l_val_max = 4
            endif
            if( non_exc_g ) then
              ipr1 = 1
              itab = it_abs
            else
              ipr1 = ipr0
              itab = itabs
            endif
            call agregat(Atom_mag_gr,Atom_nsph,Axe_atom_clu,Axe_atom_gr,
     &      chargat,chargm,dista,flapw,green,hubbard,iaabs,iabsorbeur,
     &      iaproto,iapot,igreq,igroup,igrpt_nomag,ipr0,it0,itab,
     &      itype,itypep,l_val_max,magnetic,matper,mpirank,n_atom_proto,
     &      natomp,nb_rep,nb_sym_op,ngreq,ngroup,nlat,nlatm,
     &      noncentre,non_exc_g,nspin,ntype,numat,popats,pos,
     &      posn,rmax,self_non_exc,spinorbite,Rot_Atom_gr)
          endif

! Evaluation de la forme des tenseurs cartesiens
          call Tensor_shape(Atom_mag_gr,Atom_nsph,Axe_atom_clu,green,
     &         iaabs,igroup,it0,itype,itypep,magnetic,natomp,
     &         ngroup,nlat,nlatm,nspin,ntype,numat,octupole,popats,
     &         pos,quadrupole,rot_atom_abs,spinorbite)

! Oana: on calcule la diffraction seulement a la derniere iteration;
! on ne peut pas inverser l'ordre de prepdafs et agregat 

          if( cal_xanes ) then  

            allocate( poldafsescan(3,npldafs,nphim) )
            allocate( poldafssscan(3,npldafs,nphim) )
            allocate( phdafs(natomsym,npldafs) )
            allocate( phdf0t(npldafs) )
            allocate( phdf0tscan(npldafs,nphim) )
            allocate( phdt(npldafs) )
            allocate( phdtscan(npldafs,nphim) )
            allocate( vecdafsescan(3,npldafs,nphim) )
            allocate( vecdafssscan(3,npldafs,nphim) )
        
            ngrm = 0
            do ipr = 1,n_atom_proto
              ngrm = max( ngrm, ngreq(ipr) )
            end do

            allocate( Taux_ipr(n_atom_proto) ) 
            do ipr = 1,n_atom_proto
              Taux_ipr(ipr)
     &             = sum( Taux_oc(abs( igreq(ipr,1:ngreq(ipr)) )) )
     &             / ngreq(ipr) 
            end do
            fpp_avantseuil = fpp_cal(icheck(3),ipr0,it0,itypepr,
     &                n_atom_proto,ngreq,ntype,numat,self_abs,Taux_ipr)
            deallocate( Taux_ipr )

            if( dafs ) call prepdafs(angpoldafs,Axe_atom_gr,
     &        hkl_dafs,igreq,ipr0,iprabs,isigpi,it0,itabs,
     &        itypepr,lvval,magnetic,mpirank,n_atom_proto,natomsym,
     &        ngreq,ngrm,ngroup,nlat,nlatm,nphim,npldafs,nrato,nrm,
     &        nspin,ntype,numat,phdafs,phdf0t,phdf0tscan,phdt,phdtscan,
     &        poldafse,poldafsei,poldafss,poldafssi,poldafsescan,
     &        poldafssscan,popatm,posn,psival,
     &        quadrupole,rato,Taux_oc,temp,vecdafse,vecdafss,
     &        vecdafsescan,vecdafssscan)
        
            allocate( ltypcal(npltm) )
            allocate( nomabs(ncolm) )
            allocate( ple(3,npltm) )
            allocate( pls(3,npltm) )
            allocate( voe(3,npltm) )
            allocate( vos(3,npltm) )
            allocate( pdp(ncolm,2) )

! Evaluation des polarisations et vecteurs d'onde.
            call polond(angpoldafs,green_plus,hkl_dafs,isigpi,
     &        Length_word,
     &        ltypcal,moyenne,mpirank,ncolm,ncolr,ncolrd,ncolt,nomabs,
     &        nphim,nple,nplei,nplt,npltm,npldafs,nplr,nxanout,
     &        octupole,pdp,pdpolar,ple,pls,polar,poldafse,poldafsei,
     &        poldafsescan,poldafss,poldafssscan,poldafssi,quadrupole,
     &        self_abs,vecdafse,vecdafsescan,vecdafss,
     &        vecdafssscan,veconde,voe,vos,xan_atom)

            if( mpirank == 0 ) allocate(Int_tens(n_tens_max,0:natomsym)) 
                    
            if( extract ) goto 1030 ! --------> extraction

          endif

! Calcul du nombre d'atomes du petit agregat symetrise
          natome = natome_cal(igrpt_nomag,mpirank,natomeq,natomp,pos)

! Le nombre d'atomes decrivant le potentiel est defini soit par les 
! atomes prototypiques, soit par les atomes a l'interieur du petit
! agregat 
          if( i_self == 1 ) Full_atom = ( Full_atom_e
     &     .or. ( self_cons .and. .not. (self_non_exc .and. Proto_all) )
     &     .or. ( natome <= n_atom_proto - ipr0 + 1 ) )
     &     .and. .not. flapw
          if( Full_atom ) then
            n_atom_0 = 1
            n_atom_ind = natome
          else
            n_atom_0 = ipr0
            n_atom_ind = n_atom_proto
          endif
 
          if( mpirank == 0 ) then
            allocate( Int_statedens(lla2_state,nspin,
     &                                         n_atom_0:n_atom_ind) ) 
            Int_statedens(:,:,:) = 0._db
          endif  

          if( self_cons ) then
            nrm_self = nrm
          else
            nrm_self = 0
          endif

          if( i_self == 1 ) then
            if( self_non_exc ) then
              n_atom_0_self = 1
            else
              n_atom_0_self = n_atom_0
            endif
            n_atom_ind_self = n_atom_ind
            natome_self = natome
            natomeq_self = natomeq
            allocate( chargat_init(n_atom_0_self:n_atom_ind_self) )
            allocate( chargat_self(n_atom_0_self:n_atom_ind_self) )
            allocate( chargat_self_s(n_atom_0_self:n_atom_ind_self) )
            allocate( drho_ex_nex(0:nrm_self,nspin) )
            allocate( dvc_ex_nex(0:nrm_self) )
            allocate( dv_ex_nex(0:nrm_self) )
            allocate( Energ_self(n_atom_0_self:n_atom_ind_self) )
            allocate( Energ_self_s(n_atom_0_self:n_atom_ind_self) )
            allocate( En_coeur(n_atom_0_self:n_atom_ind_self) )
            allocate( En_coeur_s(n_atom_0_self:n_atom_ind_self) )
            allocate( pop_orb_val(n_atom_0_self:n_atom_ind_self) )
            allocate( rho_chg(0:nrm_self,nspin,
     &                                  n_atom_0_self:n_atom_ind_self) )
            allocate( rho_self(0:nrm_self,nspin,
     &                                  n_atom_0_self:n_atom_ind_self) )
            allocate( rho_self_s(0:nrm_self,nspin,
     &                                  n_atom_0_self:n_atom_ind_self) )
            allocate( rhoato_init(0:nrm_self,nspin,
     &                                  n_atom_0_self:n_atom_ind_self) )
            allocate( vcato_init(0:nrm_self,
     &                                  n_atom_0_self:n_atom_ind_self) )
            allocate( Int_dens_all(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin,
     &                                  n_atom_0_self:n_atom_ind_self) ) 
            allocate( Int_dens_all_s(-m_hubb:m_hubb,-m_hubb:m_hubb,
     &                            nspin,n_atom_0_self:n_atom_ind_self) ) 
            if( .not. Atom_occ_mat .and. hubbard ) then
              population = 1._db / nspin
              do m = -m_hubb, m_hubb 
                Int_dens_all_s(m,m,:,:) = population
              end do
            endif
            allocate( rot(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin,
     &                                  n_atom_0_self:n_atom_ind_self) ) 
          endif
          if( hubbard .and. .not. cal_xanes )
     &                      Int_dens_all(:,:,:,:) = 0._db
        
          allocate( dv0bdcF(nspin) )

          if( i_self > 1 .and. cal_xanes ) then
            deallocate( Atom_comp )
            deallocate( Axe_Atom_Clui )
            deallocate( distai )
            deallocate( ia_eq )
            deallocate( ia_eq_inv )
            deallocate( ia_eq_sym )
            deallocate( ia_rep )
            deallocate( iaprotoi )
            deallocate( iopsym_atom )
            deallocate( is_eq )
            deallocate( itypei )
            deallocate( nb_eq )
            deallocate( nb_rpr )
            deallocate( nb_rep_t )
            posi_self(:,:) = posi(:,:)
            deallocate( posi )
            deallocate( rot_atom )
          endif 

          if( i_self == 1 ) then
            allocate( posi_self(3,natome) )
            allocate( ia_eq_inv_self(natomeq_self) )
          endif
          if( i_self == 1 .or. cal_xanes ) then
            allocate( Atom_comp(0:natome) )
            allocate( Axe_Atom_Clui(3,natome) )
            allocate( distai(natome) )
            allocate( ia_eq(nb_sym_op,natome) )
            allocate( ia_eq_inv(natomeq) )
            allocate( ia_eq_sym(nb_sym_op,natome) )
            allocate( ia_rep(nb_sym_op,natome,natome) )
            allocate( iaprotoi(natome) )
            allocate( iopsym_atom(nopsm,natome) )
            allocate( is_eq(nb_sym_op,natome) )
            allocate( itypei(natome) )
            allocate( nb_eq(natome) )
            allocate( nb_rpr(natome,natome) )
            allocate( nb_rep_t(nb_sym_op,natome,natome) )
            allocate( posi(3,natome) )
            allocate( rot_atom(3,3,natome) )
            Energ_self_s(:) = 0._db
          endif 
       
          if( i_self == 1 .or. cal_xanes ) call Atom_selec(Atom_comp,
     &         Atom_mag_gr,Atom_nsph,Atom_occ_mat,Axe_atom_clu,
     &         Axe_Atom_clui,dista,distai,Full_atom,hubbard,
     &         ia_eq,ia_eq_inv,ia_eq_sym,ia_rep,iaabs,iaabsi,iaproto,
     &         iaprotoi,Int_dens_all_s,igreq,igroup,igrpt_nomag,
     &         iopsym_atom,iord,ipr0,is_eq,it0,
     &         itype,itypei,itypep,itypepr,magnetic,m_hubb,
     &         mpirank,natome,n_atom_0,n_atom_ind,n_atom_proto,
     &         natomeq,natomp,nb_eq,nb_rpr,nb_rep_t,
     &         nb_sym_op,ngroup,nlat,nlatm,nspin,ntype,numat,nx,
     &         occ_mat_gr,overad,popats,pos,posi,rmt,rot_atom,roverad,
     &         rsort,rsorte,spinorbite,Ylm_complex)

          if( i_self == 1 ) ia_eq_inv_self(:) = ia_eq_inv(:) 
  
! Calcul des representations utiles
          if( cal_xanes ) then
            call etafin(Atom_comp(iaabsi),lmoins1,lplus1,mpirank,nb_rep,
     &                  nbseuil,ngrph,nspino,spinorbite,state_all)
          elseif( i_self == 1 ) then
! Pour le calcul auto-coherent, il faut calculer toutes les representations
            call irep_util_all(nb_rep,ngrph,nspino,spinorbite)
          endif

          if( i_self == 1 .or. cal_xanes ) then

            nbm = 0;     nbtm = 0
            npoint = 0;  npr = 0
            nsort = 0
            nsm = 0;     nstm = 0

! Calcul des dimensions de tableaux pour le maillage

            call nbpoint(green,iaabs,igrpt_nomag,iord,mpirank,
     &                   natomp,npoint,npso,nx,pos,rsort )   
        
            nim = npoint
            npsom = npso

            if( base_hexa ) then
              nvois = 4 * iord
            else
              nvois = 3 * iord
            endif

            if( cal_xanes .and. i_self > 1 ) then
              deallocate( clapl )
              deallocate( cgrad )
              deallocate( ivois )
              deallocate( isvois )
              deallocate( numia )
              deallocate( rvol )
              deallocate( xyz )
            endif
            allocate( clapl(0:nvois) )
            allocate( cgrad(nvois) )
            allocate( ivois(npsom,nvois) )
            allocate( isvois(npsom,nvois) )
            allocate( numia(npsom) )
            allocate( rvol(nim) )
            allocate( xyz(4,npsom) )

! Elaboration du maillage

            allocate( indice(npsom,3) )
            allocate( mpres(-nx:nx,-nx:nx,-nx:nx) )

! Meme en Green, on definit des points afin de calculer le potentiel moyen
            call reseau(green,iaabs,igrpt_nomag,indice,iord,it0,itypei,
     &               mpirank,mpres,natome,natomp,nim,npoint,
     &               npr,npso,npsom,ntype,numia,nx,pos,
     &               posi,rmt,rsort,rvol,xyz)

            if( .not. green ) then
              call laplac(cgrad,clapl,igrpt_nomag,indice,iord,ivois,
     &                    isvois,mpirank,mpres,npso,npsom,nvois,nx)
              call bordure(green,iord,iscratch,ivois,
     &                     mpirank,natome,nbm,nbtm,nim,
     &                     npoint,npso,npsom,nsm,nstm,numia,
     &                     nvois,posi,rvol,xyz)
            endif
            deallocate( indice )
            deallocate( mpres )

          endif

! Oana: on calcule les rayons seulement aux premiere et derniere 
! iterations 
          if( i_self == 1 ) then
            allocate( lmaxat(ipr0:n_atom_proto) )
            allocate( nrmtg(ipr0:n_atom_proto) ) 
            allocate( rmtg(ipr0:n_atom_proto) ) 
            allocate( rmtg0(ipr0:n_atom_proto) )
            allocate( rmtsd(ipr0:n_atom_proto) )
            allocate( v_abs_i(0:nrm) )
          end if      
        
          allocate( ef(npoint) )
          allocate( efato(0:nrm,n_atom_0:n_atom_ind) )
          allocate( excato(nrm,n_atom_0:n_atom_ind) )
          allocate( ibord(nbtm,natome) )
          allocate( isbord(nbtm,natome) )
          allocate( imoy(npoint) );  allocate( imoy_out(npoint) )
          allocate( isrt(nstm) )
          allocate( nbord(natome) )
          allocate( nbordf(natome) )
          allocate( poidsa(nbm,natome) )
          allocate( poidso(nsm) )
          allocate( poidsov(npoint) ); allocate( poidsov_out(npoint) )
          allocate( rho(npoint,nspin) )
          allocate( rhons(npoint) )
          allocate( rs(npoint) )
          allocate( rsato(0:nrm,n_atom_0:n_atom_ind) )
          allocate( Vcato(0:nrm,n_atom_0:n_atom_ind) )
          allocate( Vh(npoint) )
          allocate( Vhns(npoint) )
          allocate( Vr(npoint,nspin) )
          allocate( Vrato(0:nrm,nspin,n_atom_0:n_atom_ind) )
          allocate( Vxc(npoint,nspin) )
          allocate( Vxcato(0:nrm,nspin,n_atom_0:n_atom_ind) )

          if( .not. green ) call recup_bordure(ibord,isbord,iscratch,
     &          isrt,mpinodes,mpirank,natome,nbord,nbordf,nbm,nbtm,nsm,
     &          nsort,nsortf,nstm,poidsa,poidso)

          if( mpirank == 0 ) then
            call CPU_TIME(time)
            tp(2) = real(time,db)
          endif

! Calcul du potentiel
          if( flapw ) then

            call potlapw(chargat,coupelapw,efato,Full_atom,
     &        iapot,iaproto,iaprotoi,igroup,ipr0,iprabs,it0,itabs,
     &        its_lapw,itypei,itypep,itypepr,magnetic,mpinodes,
     &        mpirank,n_atom_0,n_atom_ind,n_atom_proto,natome,natomeq,
     &        natomp,ngreq,ngroup,ngroup_lapw,
     &        nklapw,nlmlapwm,nmatsym,nomclm,nomr2v,nomvcoul,
     &        npoint,npsom,nrato,nrato_lapw,nrm,nrmtg,
     &        nspin,ntype,numat,overlap,pos,posi,rato,rchimp,rho,
     &        rlapw,rmtg,rmtg0,rmtimp,rmtsd,
     &        rotloc_lapw,rs,rsato,rsort,trace_format_wien,
     &        V_abs_i,V0bdcFimp(1),Vcato,Vh,Vxc,Vxcato,xyz)     

          else

            call potsup(Axe_atom_clu,cal_xanes,cdil,chargat,
     &        chargat_init,chargat_self,drho_ex_nex,dv_ex_nex,
     &        dvc_ex_nex,efato,excato,Full_atom,hybrid,i_self,ia_eq_inv,
     &        ia_eq_inv_self,iaabs,iaproto,iaprotoi,iapot,
     &        igreq,igroup,ipr0,iprabs,ipr1,it0,itab,itdil,
     &        itypei,itypep,itypepr,ldil,lvval,magnetic,mpirank,
     &        n_atom_0,n_atom_0_self,n_atom_ind,n_atom_ind_self,
     &        n_atom_proto,natome,natome_self,natomeq,
     &        natomeq_self,natomp,ngreq,ngroup,
     &        ngroup_nonsph,nhybm,nlat,nlatm,nonexc,norbdil,norbv,
     &        npoint,npsom,nrato,nrm,nrm_self,nrmtg,nspin,ntype,
     &        numat,overlap,pop_nonsph,popatm,popatv,pos,posi,posi_self,
     &        psival,r_self,rato,rchimp,rho,rho_chg,rho_self,
     &        rhoato_init,
     &        rhoit,rhons,rmtg,rmtimp,rmtg0,rmtsd,Rot_Atom_gr,rs,
     &        rsato,rsort,self_non_exc,v_abs_i,Vcato,Vcato_init,Vh,Vhns,
     &        Vxc,Vxcato,v0bdcFimp(1),xyz)
  
! Initialisation de rho_self, une fois avoir calcule le nouveau
! potentiel en potsup. Au dela du rayon rmtsd on initialise a zero.
            if( .not. cal_xanes ) then

              if( i_self == 1 ) then
                allocate( ch_coeur(n_atom_0_self:n_atom_ind_self) )  
                rho_self_s(:,:,:) = rhoato_init(:,:,:) 

! Calcul de l'energie de depart du comptage d'electrons; on la calcule
! une seule fois, bien que les Vcato et Vxcato changent a chaque
! iteration
                allocate( sgn(n_atom_0_self:n_atom_ind_self) )

                call en_dep(enin,Full_atom,Green,iaprotoi,ipr0,it0,
     &               itypepr,lcoeur,n_atom_0,n_atom_0_self,n_atom_ind,
     &               n_atom_ind_self,n_atom_proto,natome,ncoeur,
     &               nenerg_coh,nrato,
     &               nrm,numat,nspin,ntype,Pas_SCF,psi_coeur,rato,sgn,
     &               Vcato,Vxcato,workf)  
        
! Calcul de la charge de reference en cas de calcul auto_coherent
                call chg_agr(chargat,chargat_init,ch_coeur,chg_cluster,
     &	           chg_level,Full_atom,iaprotoi,
     &               ipr0,iprabs,itypepr,it0,lcoeur,mpirank,
     &               natome,n_atom_0_self,n_atom_ind_self,
     &               n_atom_proto,nb_eq,ncoeur,ngreq,nrato,nrm,
     &               nrm_self,nspin,ntype,numat,pop_level,psi_coeur,
     &               psi_level,rato,rho_chg,rho_coeur,rho_cor,
     &               rhoato_init,rmtsd,self_non_exc,sgn)
                chargat_self_s(:) = chargat_init(:) 
                deallocate( sgn )
! Mise en place de la grille en energie pour l'autocoherence    
                allocate( energ_coh(nenerg_coh) )
                allocate( eimag_coh(nenerg_coh) )
                call grille_coh(eimag_coh,energ_coh,enin,Green,
     &                          nenerg_coh,Pas_SCF)

              endif

              do iapr = n_atom_0_self,n_atom_ind_self
                if( Full_atom ) then
                  ipr = iaprotoi(iapr)
                else
                  ipr = iapr
                endif
                it = itypepr(ipr)
                nr = nrato(it)
                do n = 1,nr
                  if( rato(n,it) > rmtsd(ipr) ) exit
                end do
                do ispin = 1,nspin
                  do ir = 0,n             
                  rho_self(ir,ispin,iapr) = rho_chg(ir,ispin,iapr) 
     &                  + ( rho_coeur(ir,it) / nspin ) - rho_cor(ir,it)       
                  end do
                  rho_self(n+1:nr,:,iapr) = rhoato_init(n+1:nr,:,iapr)
                end do
              end do
           
            endif

          endif
    
          if( cal_xanes ) then
            nenerg = nenerg_s 
            allocate( energ(nenerg) )
            allocate( eimag(nenerg) )
            energ(:) = energ_s(:)   
            eimag(:) = eimag_s(:)         
          else
            nenerg = nenerg_coh 
            allocate( energ(nenerg) )
            allocate( eimag(nenerg) )
            energ(:) = energ_coh(:) 
            eimag(:) = eimag_coh(:)
          end if   

! Operations complementaires sur le potentiel
          call potential_comp(cal_xanes,dv0bdcF,ecineticmax,
     &        ecineticmax_out,
     &        eclie,ef,eneg,Energ(nenerg),etatlie,green,iaabs,iaproto,
     &        imoy,imoy_out,ipr0,isrt,korigimp,magnetic,mpirank,
     &        n_atom_proto,natomp,nim,noncentre,
     &        npoint,npsom,nptmoy,nptmoy_out,nsortf,nspin,nstm,
     &        poidsov,poidsov_out,pos,rmtg0,rs,rsort,rvol,
     &        v0bdcFimp,v0muf,vh,vr,vxc,xyz,workf)

! Calcul de l'energie du niveau de coeur initial.
          if( cal_xanes ) then
            itexc = abs( itype(iabsorbeur) )
            call enrgseuil(Epsii,flapw,it0,itabs,
     &          itexc,mpirank,nrato,nrm,ntype,psii,rato,v_abs_i)
          endif

! Determination du lmax
          if( .not. green ) then
            call clmax(ecineticmax_out,rsort,lmaxso0,lmaxso,2,.true.)
          else
            lmaxso = 0
          endif
          lmaxmax = 0
          if( octupole ) then
            lmax_probe = lseuil + 3
          elseif( quadrupole ) then
            lmax_probe = lseuil + 2
          else
            lmax_probe = lseuil + 1
          endif
          do ipr = ipr1,n_atom_proto
            Z = numat( itypepr(ipr) )
            call clmax(ecineticmax,rmtg(ipr),lmaxat0,lmaxat(ipr),Z,
     &               lmaxfree)
            if( Z == numat_abs )
     &         lmaxat(ipr) = max( lmax_probe, lmaxat(ipr) ) 
            lmaxmax = max(lmaxmax,lmaxat(ipr))
          end do

          nlmmax = (lmaxmax + 1 )**2
          nlmsam = nspin * nlmmax
          nlmomax = ( lmaxso + 1 )**2
          nso1 = nspino * nlmomax

          if( mpirank == 0 ) then
            call CPU_TIME(time)
            tp(3) = real(time,db)
          endif
        
          allocate( iato(nlmsam,natome,ngrph) )
          allocate( lato(nlmsam,natome,ngrph) )
          allocate( iso(nso1,ngrph) )
          allocate( lso(nso1,ngrph) )
          allocate( mato(nlmsam,natome,ngrph) )
          allocate( mso(nso1,ngrph) )
          allocate( nlmso0(ngrph) )
          allocate( nlmsa0(natome,ngrph) )

! Determination des (l,m) de chaque representation
          call lmrep(green,iaprotoi,iato,iopsym_atom,ipr0,iso,lato,
     &           lmaxat,lmaxso,lso,mato,mpirank,mso,n_atom_proto,
     &           natome,nbordf,ngrph,nlmsa0,nlmsam,nlmso0,
     &           nso1,nsortf,nspino,posi,rot_atom)

! Calcul des Ylm sur les points du maillage
          if( .not. green )  then
            allocate( ylmato(nbtm,nlmmax,natome) )
            allocate( ylmso(nsort,nlmomax) )
            call ylmpt(iaprotoi,ibord,ipr0,isrt,lmaxat,lmaxso,
     &           n_atom_proto,natome,nbord,nbtm,nlmmax,nlmomax,
     &           nsort,nstm,npsom,posi,rot_atom,rot_atom_abs,xyz,
     &           ylmato,ylmso)
          endif

          if( nspin == 1 .or. spinorbite ) then
            nspinorb = 1
          else
            nspinorb = 2
          endif

          if( green ) then
            nphiato1 = 1;      nphiato20 = 1
            nphiato2 = 1;      nphiato3 = 1
            nphiato4 = 1;      nphiato5 = 1
            nphiato6 = 1
            nbn1 = 1; nbn2 = 1; nbn3 = 1
          else
            nphiato1 = nbtm;   nphiato3 = nspin
            nphiato4 = nspino; nphiato5 = natome
            nphiato6 = 1
            do ie = 1,nenerg
            if( abs(eimag(ie)) > eps10 .or. eneg ) then
              nphiato6 = 2
              exit
            endif
            end do
            if( spinorbite .or. hubbard ) then
              nphiato20 = 1;  nphiato2 = nlmmax
            else
              nphiato20 = 0;  nphiato2 = lmaxmax
            endif
            nbn1 = nsort; nbn2 = lmaxso; nbn3 = nspin
          endif
          allocate( ecinetic(nspin) )
          allocate( ecinetic_out(nspin) )
          allocate( bessel(nbn1,0:nbn2,nbn3) )
          allocate( konde(nspin) )
          allocate( neuman(nbn1,0:nbn2,nbn3) )
          allocate( phiato(nphiato1,nphiato20:nphiato2,nphiato3,
     &                 nphiato4,nphiato5,nphiato6) )
          allocate( lmaxa(natome) )
          allocate( nlmsa(natome) )
          allocate( v0bd(nspin) );  allocate( v0bd_out(nspin) ) 
          if( .not. green ) then
            if( spinorbite .or. relativiste ) then
              nicm = nim
            else
              nicm = 1
            endif
            allocate( gradvr(nicm,3,nspin))
          endif

          allocate( drho_self(0:nrm_self,nspin,
     &                     n_atom_0_self:n_atom_ind_self,0:mpinodes-1) )
          allocate( statedens(lla2_state,nspin,n_atom_0:n_atom_ind,
     &                        0:mpinodes-1) )
          allocate( statedens_hd(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin, 
     &                     n_atom_0_self:n_atom_ind_self,0:mpinodes-1) )
          allocate( secdd(3,3,nbseuil,nspinr,0:mpinodes-1) )
          allocate( secmd(3,3,nbseuil,nspinr,0:mpinodes-1) )
          allocate( secmm(3,3,nbseuil,nspinr,0:mpinodes-1) )
          allocate( secdq(3,3,3,nbseuil,nspinr,0:mpinodes-1) )
          allocate( secdo(3,3,3,3,nbseuil,nspinr,0:mpinodes-1) )
          allocate( secqq(3,3,3,3,nbseuil,nspinr,0:mpinodes-1) )
          allocate( sec_atom(nbseuil) )
          allocate( taull(nlmmax,nspin,nlmmax,nspin,natome) )
          allocate( rofsd(n_atom_0:n_atom_ind,nlmmax,nspin,nspino,
     &                nspino) )
          allocate( singulsd(nlmmax,nspin,n_atom_0:n_atom_ind) )

! Dimensionement de rhov_self et sing_self
          if( spinorbite .or. hubbard ) then
            id0 = 1;  id = nlmmax
          else
            id0 = 0;  id = lmaxmax
          endif
          allocate( rhov_self(0:nrm_self,id0:id,nspin,
     &            nspino,nspino,n_atom_0_self:n_atom_ind_self) )
          allocate( sing_self(0:nrm_self,id0:id,nspin,
     &                    n_atom_0_self:n_atom_ind_self) )
          allocate( rofsd_hd(-m_hubb:m_hubb,nspino,-m_hubb:m_hubb, 
     &        nspino,nspin,n_atom_0_self:n_atom_ind_self) )

          if( mpirank == 0 ) then
            call CPU_TIME(time)
            tp(4) = real(time,db)
            do i = 2,4
              tpt(i) = tp(i) - tp(i-1)
            end do
          endif
        
! Initialisation de l'energie de l'agregat
          enragr = 0._db
          Energ_self(:) = 0._db
          nge = ( nenerg - 1 ) / mpinodes + 1

! Boucle sur l'energie

          boucle_energ: do je = 1,nge

            if( mpirank == 0 ) then
              call CPU_TIME(time)
              tp(1) = real(time,db)
            endif
        
            ie = ( je - 1 ) * mpinodes + mpirank + 1

            taull(:,:,:,:,:) = (0._db,0._db)    ! matrice de diffusion de l'agregat

            if( ie > nenerg ) goto 1010
            enervide = energ(ie) - workf 
        
! Calcul du potentiel dans l'etat excite
            call potex(cal_xanes,dv0bdcF,ef,efato,energ(ie),enervide,
     &        Full_atom,iaabsi,iapot,iaprotoi,imoy,imoy_out,ipr0,ipr1,
     &        ispin,it0,itab,itypepr,magnetic,mpinodes,mpirank,
     &        n_atom_0,n_atom_ind,n_atom_proto,natome,non_exc_g,npoint,
     &        npsom,
     &        nptmoy,nptmoy_out,nrato,nrm,nrmtg,nspin,ntype,poidsov,
     &        poidsov_out,rato,rho,rhons,rmtg,rs,rsato,Vcato,Vh,Vhns,
     &        Vr,Vxc,Vrato,Vxcato,V0bd,V0bd_out,xyz)

            do ispin = 1,nspin

              if( muffintin ) then
                v0bd_out(ispin) = v0bd(ispin) 
                call mdfmuf(Axe_Atom_Clu,Full_atom,iaproto,iaprotoi,
     &             ipr0,ispin,it0,itypep,n_atom_0,n_atom_ind,
     &             n_atom_proto,natome,natomp,npoint,npsom,nrato,nrm,
     &             nspin,ntype,pos,rato,rho,rhons,rmtg,Vhns,V0bd(ispin),
     &             Vr,Vrato,xyz)
              endif

              if( supermuf ) call modmuf(Full_atom,iaprotoi,it0,itypepr,
     &            ipr0,ispin,n_atom_0,n_atom_ind,n_atom_proto,natome,
     &            nrato,nrm,nspin,ntype,rato,rmtg,V0bd(ispin),Vrato)

              if( .not. green .and. ( spinorbite .or. relativiste ) )
     &          call gradpot(npoint,ispin,npsom,nspin,ivois,
     &                 iord,nvois,cgrad,nicm,gradvr,nspin,Vr)

              ecinetic(ispin) = enervide - V0bd(ispin)
              ecinetic_out(ispin) = enervide - V0bd_out(ispin)
!!!!!!!!!!
!              ecinetic_out(ispin) = ecinetic(ispin)
!!!!!!!!!!
              if( eneg ) then
! Problemes numeriques autour de 0
                em = 0.01 / rydb   
                ei0 = 0.01 / rydb
                if( ecinetic_out(ispin) < 0._db ) then
                  eimag(ie) = max( eimag(ie), ei0 )
                elseif( ecinetic_out(ispin) < em ) then 
                  eii = ei0 * ( 1 - ecinetic_out(ispin) / em ) 
                  eimag(ie) = max( eimag(ie), eii )
                endif
              elseif( etatlie ) then
                ecinetic(ispin) = max(ecinetic(ispin),eclie)
                ecinetic_out(ispin) = max(ecinetic_out(ispin),eclie)
              endif

              if( ( ecinetic(ispin) < eps10 .or.  
     &              ecinetic_out(ispin) < eps10 ).and. .not. eneg ) then
                if( mpirank == 0 ) then
                  call write_error
                  do ipr = 6,9,3
                    write(ipr,130) ecinetic(ispin) * rydb
                    if( nptmoy_out > 0 )
     &                  write(ipr,135) ecinetic_out(ispin) * rydb
                  end do
                endif
                stop
              endif

            end do  ! fin boucle sur spin

            if( abs( eimag(ie) ) > eps10 .or. ecinetic_out(1) < eps10
     &         .or. ecinetic_out(nspino) < eps10 ) then
              E_comp = .true.
            else
              E_comp = .false.
            endif
            konde(:) = sqrt( cmplx(ecinetic(:),eimag,db) )

            if( E_comp ) then
              solsing = .true.
            else
              solsing = solsing_s
            endif
            ecmax = max( ecinetic(1), ecinetic(nspin) )

            lmaxabs = 0
	      lmaxg = 0
            do ipr = ipr1,n_atom_proto
              Z = numat( itypepr(ipr) )
              call clmax(ecmax,rmtg(ipr),lmaxat0,lmaxat(ipr),Z,lmaxfree)
              if( Z == numat_abs ) then 
                 lmaxat(ipr) = max( lmax_probe, lmaxat(ipr) ) 
                 lmaxabs = max( lmaxat(ipr), lmaxabs ) 
	        end if
	        lmaxg = max( lmaxat(ipr), lmaxg)
            end do 
            nlmam = ( lmaxabs + 1 )**2
	      nlmagm = ( lmaxg + 1 )**2
            allocate( rof(nlmam,nspin,nspin,0:3,nbseuil) )
            allocate( singul(nlmam,nspin,nspin,3,nbseuil) )
            allocate( tauabs(nlmagm,nspin,nspin,n_atom_0:n_atom_ind) )
            singul(:,:,:,:,:) = (0._db,0._db)
            tauabs(:,:,:,:) = (0._db,0._db)

            if( .not. green ) then
              Z = 2
              call clmax(ecmax,rsort,lmaxso0,lmaxso,Z,.true.)
              if( cal_xanes .and. icheck(1) > 0 )
     &                           write(3,'(/a9,i4)') ' lmaxso =', lmaxso

              nlma = 0
              do ia = 1,natome
                lm = lmaxat( iaprotoi(ia) ) 
                nlma = nlma + nb_eq(ia) * (lm + 1)**2
              end do

              lmaxso = min(lmaxso,nbn2)

            endif

            do isp = 1,nspin
              if( .not. green )
     &          call phiso(bessel,ecinetic_out(isp),eclie,eimag(ie),
     &             eneg,energ(ie),enervide,etatlie,isp,isrt,lmaxso,
     &             mpirank,nbn1,nbn2,nbn3,neuman,npsom,nsort,nstm,
     &             rydberg,rsort,v0bd_out(isp),xyz)
            end do

            if( mpirank == 0 ) then
              call CPU_TIME(time)
              tp(2) = real(time,db)
            endif

! Boucle sur les atomes nonequivalents dans la maille
            if( cal_xanes ) then
              n1 = n_atom_0
            else
              n1 = n_atom_0_self
            endif 
            do iapr = n1,n_atom_ind

              if( Full_atom ) then
                ipr = iaprotoi( iapr )
              else
                ipr = iapr
              endif
              Z = numat( itypepr(ipr) )
              if( Z == Z_nospinorbite ) then
                spino = .false.
              else
                spino = spinorbite
              endif
              it = itypepr(ipr)
              lmax = lmaxat(ipr)
              if( Full_atom ) then
                Absorbeur = iapr == iaabsi .and. cal_xanes
              else
                Absorbeur = it == itabs .and. cal_xanes
              endif
              allocate( rato_e(0:nrm) )
              allocate( vrato_e(0:nrm,nspin) )
              rato_e(:) = rato(:,it)
              vrato_e(:,:) = vrato(:,:,iapr)

              call sphere(Absorbeur,Axe_Atom_Clui,cal_xanes,
     &          ecinetic,eimag(ie),energ(ie),
     &          enervide,Full_atom,green,green_plus,hubb(it),
     &          hubbard,iaabsi,iapr,iaprotoi,ibord,id0,id,
     &          Int_dens_all_s,ipr,ipr0,konde,lmax,
     &          m_hubb,n_atom_0,n_atom_0_self,n_atom_ind,
     &          n_atom_ind_self,natome,nbord,nbtm,nlmam,nlmagm,nlmmax,
     &          nphiato1,nphiato20,nphiato2,nphiato3,nphiato4,nphiato5,
     &          nphiato6,npoint,npsom,nbseuil,nrato(it),nrm,       
     &          nrm_self,nspin,nspino,numat(it),octupole,phiato,posi,
     &          psii,rato_e,relativiste,rhov_self,rmtg(ipr),
     &          rmtsd(ipr),rof,rofsd,rofsd_hd,sing_self,singul,singulsd,
     &          solsing,spino,state_dens,state_all,tauabs,
     &          V_hubbard(it),vr,vrato_e,v0bd,xyz)
   
              deallocate( rato_e )
              deallocate( vrato_e )

            end do
      
            if( mpirank == 0 ) then
              call CPU_TIME(time)
              tp(3) = real(time,db)
            endif

  ! nspinorb = 2 si magnetique sans spinorbite
  ! nspinorb = 1 si nonmagnetique ou spinorbite
  ! nspino = 2 si spinorbite

  ! igrph: boucle sur les representations
  
            do ispin = 1,nspinorb
              do igrph = 1,ngrph
        
                lmaxg = 0
                nlmsamax = 0
                do ia = 1,natome
                  lmaxa(ia) = lmaxat( iaprotoi(ia) )
                  lmaxg = max(lmaxg,lmaxa(ia))
                  n = nlmsa0(ia,igrph)
                  allocate( lval(n) )
                  lval(1:n) = lato(1:n,ia,igrph)
                  call cnlmmax(lmaxa(ia),lval,n,nlmsa(ia))
                  nlmsamax = max(nlmsamax,nlmsa(ia))
                  deallocate( lval )
                end do
                if( nlmsamax == 0 .and. igrph /= ngrph ) cycle
                if( green ) then
                  call msm(Atom_comp,Axe_Atom_Clui,cal_xanes,ecinetic,
     &             eimag(ie),Full_atom,hubb,i_self,ia_eq,ia_eq_sym,
     &             ia_rep,iaabsi,iaprotoi,iato,ie,igrph,ipr0,is_eq,
     &             ispin,it0,itypei,itypepr,konde,lato,lmaxa,lmaxg,
     &             m_hubb,mato,n_atom_proto,n_atom_0,
     &             n_atom_ind,natome,natome_self,natomp,nb_eq,
     &             nb_rpr,nb_rep_t,nb_sym_op,nchemin,ngrph,
     &             nlmagm,nlmmax,nlmsa,nlmsam,nlmsamax,
     &             normaltau,nself,nspin,nspino,ntype,numat,pos,
     &             posi,rot,rot_atom,solsing,spinorbite,state_all,
     &             tauabs,taull,tpt1,tpt2)
                else
                  n = nlmso0(igrph)
                  allocate( lval(n) )
                  lval(1:n) = lso(1:n,igrph)
                  call cnlmmax(lmaxso,lval,n,nlmso)
                  deallocate( lval )
                  allocate( post(3,natomeq) )
                  allocate( lmaxt(natomeq) )
                  post(1:3,1:natomeq) = pos(1:3,1:natomeq)
                  do ia = 1,natomeq
                    lmaxt(ia) = lmaxat( iaproto(ia) )
                  end do
                  call mat(Atom_comp,basereel,bessel,cal_xanes,cgrad,
     &              clapl,distai,E_comp,
     &              eimag(ie),enervide,Full_atom,gradvr,hubbard,
     &              iaabsi,iaprotoi,iato,ibord,igrph,isbord,iso,ispin,
     &              isrt,ivois,isvois,lato,lmaxa,lso,
     &              mato,mpirank,mso,natome,n_atom_0,n_atom_ind,
     &              nbm,nbn1,
     &              nbn2,nbn3,nbord,nbordf,nbtm,neuman,ngrph,nim,nicm,
     &              nlmagm,nlmmax,nlmomax,nlmsa,nlmsam,nlmso,
     &              nphiato1,nphiato20,nphiato2,nphiato3,nphiato4,
     &              nphiato5,nphiato6,npoint,npr,npsom,nsm,nsort,
     &              nsortf,nso1,nspin,nspino,nstm,numia,nvois,phiato,
     &              poidsa,poidso,relativiste,solsing,
     &              spinorbite,rvol,state_all,tauabs,taull,
     &              tpt1,tpt2,vr,xyz,ylmato,ylmso)
                  deallocate( post )
                  deallocate( lmaxt )
                endif

              end do
    
            end do  ! fin de la boucle sur le spin

            if( mpirank == 0 ) then
              call CPU_TIME(time)
              tp(4) = real(time,db)
            endif

            if( xan_atom .and. cal_xanes ) then

              allocate( tauab(nlmam,nspin,nlmam,nspin) )
              tauab(:,:,:,:) = (0._db,0._db)

              if( Full_atom ) then
                iapr = iaabsi
              else
                iapr = ipr0
              endif
              do isp = 1,nspin
                do lm = 1,nlmam
                  tauab(lm,isp,lm,isp) = tauabs(lm,isp,isp,iapr)
                end do
              end do

              call tenseur_car(Atom_comp(iaabsi),.true.,hubb(it0),
     &            i_self,ie,lmoins1,lplus1,m_hubb,mpinodes,
     &            mpirank,n_atom_0_self,n_atom_ind_self,
     &            nbseuil,nlmam,nself,nspin,nspinr,numat(it0),rof,rot,
     &            rot_atom_abs,secdd,secdo,secdq,secmd,secmm,secqq,
     &            singul,solsing,solsing_only,spinorbite,tauab)

              deallocate( tauab )

              do iseuil = 1,nbseuil
                sec_atom(iseuil) = 0._db
                do ispin = 1,nspinr
                  do i = 1,3
                    sec_atom(iseuil) = sec_atom(iseuil)
     &                  + Real( secdd(i,i,iseuil,ispin,mpirank), db )
                  end do
                end do
                sec_atom(iseuil) = sec_atom(iseuil) / ( 3 * nspinr )
              end do

            endif
        
            deallocate( tauabs )

            if( cal_xanes ) then
        
              allocate( taull_abs(nlmam,nspin,nlmam,nspin) )

              taull_abs(1:nlmam,:,1:nlmam,:)
     &              = taull(1:nlmam,:,1:nlmam,:,iaabsi)

              call tenseur_car(Atom_comp(iaabsi),green,hubb(it0),
     &             i_self,ie,lmoins1,lplus1,m_hubb,mpinodes,mpirank,
     &             n_atom_0_self,n_atom_ind_self,
     &             nbseuil,nlmam,nself,nspin,nspinr,numat(it0),rof,rot,
     &             rot_atom_abs,secdd,secdo,secdq,secmd,secmm,secqq,
     &             singul,solsing,solsing_only,spinorbite,taull_abs)
    
              deallocate( taull_abs )
          
            end if
          
 
            deallocate( rof )
            deallocate( singul )

            if( hubbard .and. i_self > 1 )
     &          call rottaull(hubb,it0,itypei,m_hubb,natome,natome_self,
     &                 nlmmax,nspin,ntype,numat,rot,taull)

            if( state_dens .or. .not. cal_xanes )
     &        call cal_data(cal_xanes,drho_self,Full_atom,hubbard,
     &            iaabsi,iaprotoi,id0,id,ipr0,it0,itypei,itypepr,
     &            lla2_state,lmaxat,mpinodes,mpirank,n_atom_0,
     &            n_atom_0_self,n_atom_ind,n_atom_ind_self,n_atom_proto,
     &            natome,nlmmax,nrato,nrm,nrm_self,
     &            nspin,nspino,ntype,numat,rato,rhov_self,rmtsd,
     &            rofsd,sing_self,singulsd,solsing,solsing_only,
     &            spinorbite,state_all,statedens,taull)
         
            if( hubbard .and. .not. cal_xanes ) 
     &        call cal_data_hub(Full_atom,hubb,i_self,
     &            iaprotoi,icheck(24),it0,itypei,
     &            m_hubb,mpinodes,n_atom_0,
     &            n_atom_ind,natome,n_atom_0_self,n_atom_ind_self,
     &            natome_self,nlmmax,nspin,nspino,ntype,
     &            numat,rofsd_hd,rot,singulsd,solsing,statedens_hd,
     &            spinorbite,taull)

 1010       continue

            if( mpirank == 0 ) then        
              call CPU_TIME(time)
              tp(5) = real(time,db)
            endif

            if( mpinodes > 1 ) then

              if( cal_xanes )
     &          call MPI_RECV_all(mpinodes,mpirank,nbseuil,   
     &               nspinr,secdd,secdo,secdq,secmd,secmm,secqq)      

              if( .not. cal_xanes .or. state_dens ) then
                call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
                call MPI_RECV_statedens(ipr0,lla2_state,lmaxat,mpinodes,
     &                      mpirank,n_atom_0,n_atom_ind,
     &                      n_atom_proto,nspin,statedens)
              endif

              if( .not. cal_xanes .and. hubbard ) then
                call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
                call MPI_RECV_statedens_hd(m_hubb,mpinodes,mpirank,
     &                n_atom_0_self,n_atom_ind_self,nspin,statedens_hd)
              endif

              if( .not. cal_xanes ) then
                call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
                call MPI_RECV_self(drho_self,mpinodes,mpirank,
     &                    n_atom_0_self,n_atom_ind_self,nrm_self,nspin)
              endif
    
            endif

            do ie_computer = 0,mpinodes-1

              ie = ( je - 1 ) * mpinodes + ie_computer + 1
              if( ie > nenerg ) exit      

              if( mpirank == 0 ) then

                if( cal_xanes ) call write_coabs(allsite,angpoldafs,
     &           dafs,E_cut,energ,energphot,extract,Epsii,
     &           fpp_avantseuil,green_plus,hkl_dafs,ie,ie_computer,
     &           Int_tens,isigpi,isymeq,length_word,ltypcal,
     &           moyenne,mpinodee,natomsym,nbseuil,ncolm,
     &           ncolr,ncolrd,ncolt,nenerg,nomabs,
     &           nomfich_cal_convt,nomfich_s,npldafs,nphim,nplr,nplt,
     &           npltm,nspin,nspinr,numat_abs,nxanout,pdp,phdafs,
     &           phdf0t,phdf0tscan,phdt,phdtscan,ple,pls,poldafsescan,
     &           poldafssscan,sec_atom,secdd,secdq,secdo,secmd,
     &           secmm,secqq,self_abs,spinorbite,Taux_eq,v0muf,
     &           vecdafsescan,vecdafssscan,voe,vos,xan_atom)

                if( ( state_dens .and. cal_xanes) 
     &                                   .or. .not. convergence ) then
                  call write_state(chg_cluster,chg_val_p,
     &              chg_val_ref,cal_xanes,chargat_self,
     &              d_ecrant,drho_self,E_cut,
     &              E_level_val_abs,E_level_val_exc,energ,energphot,
     &              En_fermi,enragr,Energ_self,ephseuil,
     &              fermi,Full_atom,hubb,iaabsi,iaprotoi,
     &              ie,ie_computer,Int_dens_all,Int_statedens,ipr0,
     &              i_self,it0,itypei,itypepr,lamstdens,
     &              Level_val_abs,Level_val_exc,lla_state,lla2_state,
     &              lmaxat,m_hubb,mpinodes,n_atom_0,n_atom_0_self,
     &              n_atom_ind,n_atom_ind_self,
     &              n_atom_proto,natome,nb_eq,nenerg,
     &              ngreq,nomfich_s,non_exc_g,nrato,nrm,nrm_self,nspin,       
     &              ntype,numat,pop_orb_val,rato,rho_self,rmtsd,
     &              state_all,state_dens,statedens,statedens_hd)
                endif    

                if( ie == 1 ) nomfich_cal_conv(multi_run,:)
     &                            = nomfich_cal_convt(:)

              endif
   
              if( .not. cal_xanes ) then
                call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
                call MPI_Bcast(Fermi,1,MPI_LOGICAL,0,MPI_COMM_WORLD,
     &                 mpierr)
 ! Si on a atteint le niveau de Fermi on sort de la boucle
                if( Fermi ) exit boucle_energ
              endif 

            end do
                
            if( mpirank == 0 ) then        
              call CPU_TIME(time)
              tp(6) = real(time,db)
              do i = 5,9
                tpt(i) = tpt(i) + tp(i-3) - tp(i-4)
              end do
            endif

          end do boucle_energ   ! Fin de la boucle sur l'energie.

! Calcul de l'energie de l agregat

          if( .not. cal_xanes .and. mpirank == 0 ) then

            call eps_coeur(ch_coeur,En_coeur,Full_atom,iaprotoi,
     &            ipr0,it0,itypepr,lcoeur,n_atom_0,n_atom_0_self,
     &            n_atom_ind,n_atom_ind_self,n_atom_proto,
     &            natome,nrato,nrm,
     &            nspin,ntype,psi_coeur,rato,Vcato,Vxcato)

            if( i_self == 1 ) then
              En_coeur_s(:) = En_coeur(:)
              En_coeur(:) = 0._db
            else
              En_coeur(:) = En_coeur(:) - En_coeur_s(:)    
            end if  

            call en_DFT(En_cluster,Energ_self,En_coeur,excato,
     &           Full_atom,iaprotoi,ipr0,it0,itypepr,n_atom_0,
     &           n_atom_0_self,n_atom_ind,n_atom_ind_self,n_atom_proto,
     &           natome,nb_eq,ngreq,nrm,nrm_self,nrato,
     &           nspin,ntype,numat,rato,rho_self,rmtsd,Vcato,Vxcato)
          
            if( i_self == 1 ) then
              En_coeur(:) = 0._db
            else
              En_coeur(:) = En_coeur(:) - En_coeur_s(:)    
            end if  

          end if

! Ecriture Hubbard
          if( hubbard .and. .not. cal_xanes ) then
            write(3,555) i_self
            do iapr = n_atom_0_self,n_atom_ind_self
              if( Full_atom ) then
                it = itypei(iapr)
              else
                it = itypepr(iapr)
              endif
              if( hubb(it) ) then
                l = l_hubbard( numat(it) ) 
                write(3,573) iapr
                do isp = 1,nspin
                  if( nspin == 2 ) write(3,574) isp
                  do m1 = -l, l
                    write(3,575) m1, Int_dens_all(m1,-l:l,isp,iapr)
                  end do
                end do
              else
                write(3,569) iapr
              end if
            end do
          end if

! Echange des grandeurs liees a l'auto-coherence
          if( mpinodes > 1 .and. .not. cal_xanes ) then
            m = n_atom_ind_self - n_atom_0_self + 1
            n = ( 1 + nrm_self ) * nspin * m
            call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
            call MPI_Bcast(rho_self,n,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
            call MPI_Bcast(chargat_self,m,MPI_REAL8,0,
     &                                            MPI_COMM_WORLD,mpierr)
            call MPI_Bcast(Energ_self,m,MPI_REAL8,0,
     &                                            MPI_COMM_WORLD,mpierr)
            call MPI_Bcast(enragr,1,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
            if( hubbard ) then                
              ndim = m * nspin * ( 2 * m_hubb + 1 )**2
              call MPI_Bcast(Int_dens_all,ndim,MPI_REAL8,0,
     &                     MPI_COMM_WORLD,mpierr)
            endif
          endif

          if( hubbard .and. .not. cal_xanes ) then
            if( ngrph /= 1 ) then
              call diag(Atom_comp,cal_xanes,Full_atom,hubb,i_self,
     &              iaprotoi,Int_dens_all,iato,ipr0,it0,itypepr,lato,
     &              m_hubb,mato,
     &              n_atom_0_self,n_atom_ind_self,n_atom_proto,natome,
     &              ngrph,nlmsa0,nlmsam,nspin,
     &              ntype,numat,rot,spinorbite)
            else
              call diag_SO(hubb,ipr0,Full_atom,Int_dens_all,iaprotoi,
     &              it0,itypepr,m_hubb,n_atom_0_self,n_atom_ind_self,
     &              n_atom_proto,natome,natome_self,nspin,ntype,numat,
     &              rot)
            end if
          end if

          if( cal_xanes ) deallocate( rot )

! Cas ou le niveau de Fermi n'a pas ete trouve

          if( .not. cal_xanes ) then

            if( .not. fermi .and. mpirank == 0 ) then
              call write_error
              do ipr = 3,9,3
                if( icheck(1) > 0 .or. ipr > 3 ) write(ipr,500)
              end do
              stop
            endif

            if( mpirank == 0 ) write(6,502) En_cluster * rydb

! Interpolation d'une iteration de la boucle coherente a l'autre
            if( i_self == 1 ) then
              Delta_energ = 1000000._db
              p_self = p_self0
              p_self_s = p_self
              p_self_t = p_self_s
              En_cluster_s = En_cluster
              En_cluster_t = En_cluster
            else
! Test convergence: sur l'energie et sur la charge de l'atome central
! a faire avant l'interpolation
              Delta_energ = 0._db
              if( Full_atom ) then
                Delta_lim = Delta_En_conv * natomeq
              else
                Delta_lim = Delta_En_conv * sum( ngreq(1:n_atom_proto) )
              endif 
              do iapr = n_atom_0_self,n_atom_ind_self
                if( Full_atom ) then
                  n = nb_eq(iapr)
                else
                  n = ngreq(iapr)
                endif
                Delta_energ = Delta_energ + n
     &                   * abs( Energ_self(iapr) - Energ_self_s(iapr) )
              end do
              if( Delta_energ < Delta_lim ) convergence = .true.
              if( convergence ) then
                if( icheck(1) > 0 ) then
                  write(3,*) 
                  write(3,505) Delta_energ*rydb,Delta_lim*rydb, p_self
                endif   
                if( mpirank == 0 ) write(6,505) Delta_energ*rydb,
     &                                          Delta_lim*rydb, p_self

              else
                if( icheck(1) > 0 ) then
                  write(3,*) 
                  write(3,510) Delta_energ*rydb,Delta_lim*rydb, p_self
                endif   
                if( mpirank == 0 ) write(6,510) Delta_energ*rydb,
     &                                          Delta_lim*rydb, p_self

                if( i_self == nself .and. mpirank == 0 ) then
                  if( icheck(1) > 0 ) write(3,'(/A)')
     &                       ' Calculation has not congered !'
                  write(6,'(/A)') ' Calculation has not congered !'
                else
                  rap = 1.2 * max( p_self / p_self_s, 1._db )
                  raq = 0.8 * min( p_self / p_self_s, 1._db )
                  rar = 0.8 * min( p_self_s / p_self_t, 1._db )
                  p_self_t = p_self_s
                  p_self_s = p_self
! Si calcul divergent, on diminue le poids.
                  if( ( ( En_cluster - En_cluster_s )
     &                * ( En_cluster_s - En_cluster_t ) < - eps10 
     &               .and. Delta_energ > Delta_energ_s * raq ) .or.
     &                   ( Delta_energ > Delta_energ_s * rap ) ) then
                    p_self = max( p_self / 2, p_self0 / 8 )
                  elseif( i_self > 2
     &               .and. Delta_energ < Delta_energ_s * raq 
     &               .and. Delta_energ_s < Delta_energ_t * rar ) then
                    p_self = min( 2 * p_self, p_self0 )
                  endif
                end if
              endif
            endif

            rho_self(:,:,:) = p_self * rho_self(:,:,:) 
     &                      + ( 1 - p_self ) * rho_self_s(:,:,:)
            chargat_self(:) = p_self * chargat_self(:) 
     &                      + ( 1 - p_self ) * chargat_self_s(:)
            if( hubbard .and. .not. cal_xanes .and. nself /= 1 )
     &           Int_dens_all(:,:,:,:) = p_self * Int_dens_all(:,:,:,:)
     &                       + ( 1 - p_self ) * Int_dens_all_s(:,:,:,:)

! On stoque les valeurs de l'iteration courrante, pour les injecter
! dans la suivante
            if( .not. convergence .and. i_self /= nself ) then
              Delta_energ_t = Delta_energ_s
              Delta_energ_s = Delta_energ
              En_cluster_t = En_cluster_s
              En_cluster_s = En_cluster
              Energ_self_s(:) = Energ_self(:)   
              chargat_self_s(:) = chargat_self(:)
              rho_self_s(:,:,:) = rho_self(:,:,:)
              if( hubbard ) Int_dens_all_s(:,:,:,:) 
     &                        = Int_dens_all(:,:,:,:)
            endif

          end if

          deallocate( drho_self )
          deallocate( statedens )
          deallocate( statedens_hd )
          deallocate( secdd );      deallocate( secdq )
          deallocate( secdo );      deallocate( secqq )
          deallocate( secmd );      deallocate( secmm )
          deallocate( sec_atom )
          deallocate( sing_self )
          deallocate( singulsd )
          deallocate( rhov_self )
          deallocate( rofsd_hd )
          deallocate( rofsd )
          deallocate( taull )
          deallocate( energ )
          deallocate( eimag )
          deallocate( bessel )
          deallocate( konde )
          
          deallocate( ecinetic );  deallocate( ecinetic_out )
          deallocate( ef );      deallocate( efato )
          deallocate( excato )
          deallocate( ibord )
          deallocate( isbord );
          deallocate( imoy );      deallocate( imoy_out )
          deallocate( isrt )
          deallocate( iato )
          deallocate( lato );      deallocate( lmaxa )
          deallocate( iso );     deallocate( lso )
          deallocate( mato );      deallocate( mso )
          deallocate( nbord )
          deallocate( nbordf );    deallocate( neuman )
          deallocate( nlmsa );     deallocate( nlmsa0 )
          deallocate( nlmso0 )
          deallocate( phiato )
          deallocate( poidsa )
          deallocate( poidso );    
          deallocate( poidsov ); deallocate( poidsov_out )
          deallocate( rho )
          deallocate( rhons )
          deallocate( rs );      deallocate( rsato )
          deallocate( V0bd );    deallocate( V0bd_out )
          deallocate( Vcato )    
          deallocate( Vh );      deallocate( Vhns )
          deallocate( Vr );      deallocate( Vrato )
          deallocate( Vxc );     deallocate( Vxcato )
      
          if( .not. green ) then
            deallocate( gradvr )
            deallocate( ylmato );   deallocate( ylmso )
          endif
      
          deallocate( dv0bdcF )
          if( mpirank == 0 ) deallocate( Int_statedens ) 

        end do boucle_coh  ! fin de la boucle coherente
      
        if( self_cons  ) then
          deallocate( ch_coeur )
          deallocate( energ_coh )
          deallocate( eimag_coh )
        end if

        deallocate( Atom_comp )
        deallocate( Axe_Atom_Clui )
        deallocate( cgrad )
        deallocate( chargat_init )
        deallocate( chargat_self ); deallocate( chargat_self_s )
        deallocate( clapl )
        deallocate( distai )
        deallocate( drho_ex_nex )
        deallocate( dvc_ex_nex )
        deallocate( dv_ex_nex )
        deallocate( Energ_self ); deallocate( Energ_self_s )
        deallocate( En_coeur ); deallocate( En_coeur_s )
        deallocate( ia_eq )
        deallocate( ia_eq_inv )
        deallocate( ia_eq_inv_self )
        deallocate( ia_eq_sym )
        deallocate( ia_rep )
        deallocate( iaprotoi )
        deallocate( Int_dens_all )
        deallocate( Int_dens_all_s )
        deallocate( iopsym_atom )
        deallocate( is_eq )
        deallocate( itypei )
        deallocate( ivois );     deallocate( isvois )
        deallocate( lmaxat )
        deallocate( nb_eq )
        deallocate( nb_rpr )
        deallocate( nb_rep_t )
        deallocate( nrmtg )
        deallocate( numia )
        deallocate( pop_orb_val )
        deallocate( posi )
        deallocate( posi_self )
        deallocate( rmtg )
        deallocate( rmtg0 )
        deallocate( rmtsd )
        deallocate( rho_chg )
        deallocate( rho_self ); deallocate( rho_self_s )
        deallocate( rhoato_init )
        deallocate( rot_atom )
        deallocate( rvol )
        deallocate( v_abs_i )
        deallocate( vcato_init )
        deallocate( xyz )

 1030   continue   ! Point d'arrivee en cas d'extract

        if( extract .and. mpirank == 0 ) then
 
          allocate( secdd(3,3,nbseuil,nspinr,0:0) )
          allocate( secmd(3,3,nbseuil,nspinr,0:0) )
          allocate( secmm(3,3,nbseuil,nspinr,0:0) )
          allocate( secdq(3,3,3,nbseuil,nspinr,0:0) )
          allocate( secdo(3,3,3,3,nbseuil,nspinr,0:0) )
          allocate( secqq(3,3,3,3,nbseuil,nspinr,0:0) )
          allocate( sec_atom(nbseuil) )

          isymext = nsymextract(multi_run)
          ie_computer = 0 
          do ie = 1,nenerg_s
            call extract_coabs(ie,isymext,
     &        nbseuil,nenerg_s,nspin,nom_fich_extract(multi_run),nspinr,
     &        secdd,secdo,secdq,secqq)
            call write_coabs(allsite,angpoldafs,
     &        dafs,E_cut,energ_s,energphot,extract,Epsii,
     &        fpp_avantseuil,green_plus,hkl_dafs,ie,ie_computer,
     &        Int_tens,isigpi,isymeq,length_word,ltypcal,
     &        moyenne,mpinodee,natomsym,nbseuil,ncolm,
     &        ncolr,ncolrd,ncolt,nenerg_s,nomabs,
     &        nomfich_cal_convt,nomfich_s,npldafs,nphim,nplr,nplt,
     &        npltm,nspin,nspinr,numat_abs,nxanout,pdp,phdafs,
     &        phdf0t,phdf0tscan,phdt,phdtscan,ple,pls,poldafsescan,
     &        poldafssscan,sec_atom,secdd,secdq,secdo,secmd,
     &        secmm,secqq,self_abs,spinorbite,Taux_eq,v0muf,
     &        vecdafsescan,vecdafssscan,voe,vos,xan_atom)
            if( ie == 1 ) nomfich_cal_conv(multi_run,:)
     &                           = nomfich_cal_convt(:)     
          end do

          deallocate( energ_s )
          deallocate( eimag_s )
          deallocate( secdd );      deallocate( secdq )
          deallocate( secdo );      deallocate( secqq )
          deallocate( secmd );      deallocate( secmm )
          deallocate( sec_atom )

        endif

        deallocate( Axe_atom_clu )
        deallocate( dista )
        deallocate( iapot )
        deallocate( iaproto )
        deallocate( igroup )
        deallocate( isymeq )
        deallocate( itypep )
        deallocate( itypepr )
        deallocate( pos )
        deallocate( poseq )
        deallocate( Taux_eq )
      
        if( cal_xanes ) then
          if( mpirank == 0 ) deallocate( Int_tens )    
          deallocate( poldafsescan )
          deallocate( poldafssscan )
          deallocate( phdafs )
          deallocate( phdf0t )    
          deallocate( phdf0tscan )
          deallocate( phdt )
          deallocate( phdtscan )
          deallocate( vecdafsescan )
          deallocate( vecdafssscan )
          deallocate( ltypcal )  
          deallocate( nomabs )         
          deallocate( pdp )    
          deallocate( ple )    
          deallocate( pls )    
          deallocate( voe )    
          deallocate( vos )
        end if  

        if( .not. extract .and. icheck(1) > 0 .and. mpirank == 0 ) then
          call CPU_TIME(time)
          tp1 = real(time,db)
          tpt(10) = tp1 - tp_init + tpt(1)
          tptt = sum( tpt(1:9) )
          do i = 1,10000
            if( tpt(10) >= tptt - 0.1_db ) exit
            tpt(10) = tpt(10) + 86400.
          end do
          itph = int( tpt(10) / 3600 )
          rtph = tpt(10) - itph * 3600
          itpm = int( rtph / 60 )
          itps = nint( rtph - itpm * 60 )
          write(3,180)
          write(3,190) (nomspr(i), tpt(i), i = 1,9)
          write(3,200) tpt1, tpt2
          write(3,190) nomspr(10), tpt(10)
          if( itph > 0 .or. itpm > 0 ) write(3,210) itph, itpm, itps
        endif

        if( mpirank == 0 ) Close(3)

      end do ! Fin boucle sur sites non equivalents

      if( convolution_cal .and. mpirank == 0 ) then

        Rewind(itape1)
        key_calc = .false.
        do l = 1,10000
          read(itape1,'(A)',iostat=istat) mot
          if( istat /= 0 ) then
            backspace(itape1)
            exit
          endif
          keyword = identmot(mot,9)
          if( keyword == 'calculati' ) key_calc = .true.
          if( keyword == 'run_done' ) then
            backspace(itape1)
            exit
          endif
        end do

        if( key_calc ) then
          write(itape1,'(A)') ' run_done '
          do i = 1,n_multi_run
            if( Skip_run(i) ) then
              is = 0
            else
              is = 1
            endif
            if( run_done(i) ) then
              ir = 0
            else
              ir = 1
            endif
            write(itape1,'(2i2)') ir, is
          end do
        else
          write(itape1,'(A)') ' calculation'
          do iseuil = 1,nbseuil
            do multi_run = 1,n_multi_run
              if( run_done(multi_run) ) cycle
              write(itape1,'(A)') nomfich_cal_conv(multi_run,iseuil)
            end do
          end do
        endif
      endif

! desallocation des tableaux attribues avant la boucle multi_run

      deallocate( Atom_mag_gr )
      deallocate( chargat )
      if( .not. extract ) then
        deallocate( energ_s )
        deallocate( eimag_s )
      endif
      deallocate( igreq )
      deallocate( isymqa )
      deallocate( lcoeur )
      deallocate( ncoeur )
      deallocate( ngreq )
      deallocate( ngreqm )
      deallocate( nomfich_cal_conv )
      deallocate( nomfich_cal_convt )
      deallocate( popatm )
      deallocate( posq )
      deallocate( psi_coeur )
      deallocate( psii )
      deallocate( psival )
      deallocate( psi_level )
      deallocate( pop_level )
      deallocate( rato )
      deallocate( rho_coeur )
      deallocate( rho_cor )
      deallocate( rhoit )
      deallocate( run_done )
      deallocate( Skip_run )                    

 1040 continue  ! Point d'arrivee en cas de mpirank /= 0 avec extract

      if( mpirank /= 0 .and. extract ) then
        deallocate( egamme )
        deallocate( eeient )
        deallocate( eimagent )
      endif
         
! Desallocation des tableaux alloues avant la sousroutine lectur
      deallocate( angpoldafs )
      deallocate( Atom_nsph )    
      deallocate( Axe_atom_gr )
      deallocate( com )
      deallocate( cdil )
      deallocate( ecrantage )
      deallocate( hkl_dafs )
      deallocate( hybrid )
      deallocate( iabsm )
      deallocate( iabsorig )
      deallocate( icom )
      deallocate( isigpi )
      deallocate( itdil )
      deallocate( itype )
      deallocate( its_lapw )
      deallocate( ldil )
      deallocate( lvval )
      deallocate( nlat )
      deallocate( nom_fich_extract )
      deallocate( nomclm )
      deallocate( nomfile_atom )
      deallocate( norbv )
      deallocate( nrato )
      deallocate( nrato_lapw )
      deallocate( nsymextract )
      deallocate( numat )
      deallocate( nvval )
      deallocate( occ_mat_gr )
      deallocate( pdpolar )
      deallocate( polar )
      deallocate( poldafse )
      deallocate( poldafsei )
      deallocate( poldafss )
      deallocate( poldafssi )
      deallocate( pop_nonsph ) 
      deallocate( popatc )
      deallocate( popats )
      deallocate( popatv )
      deallocate( popexc )
      deallocate( popval )
      deallocate( posn )
      deallocate( r0_lapw )
      deallocate( rchimp )
      deallocate( rlapw )
      deallocate( rmt )
      deallocate( rmtimp )
      deallocate( Rot_Atom_gr )
      deallocate( rotloc_lapw )
      deallocate( Taux_oc )
      deallocate( hubb )
      deallocate( V_hubbard )
      deallocate( v0bdcFimp )
      deallocate( vecdafse )
      deallocate( vecdafss )
      deallocate( veconde )

      return
  110 format(/' Parallel computation on',i3,' processors')
  120 format(/' Sequential calculation')
  130 format(///' E_kinetic =',f7.3,' eV < 0.',/
     &' Start the calculation at higher energy !'///)
  135 format(///' or E_kinetic_ext =',f7.3,' eV < 0.',/
     &' Start the calculation at higher energy !'///)
  180 format(/,120('-')//' Subroutine time (sCPU)')
  190 format(3(4x,a6,' =',f11.3))
  200 format(4x,'Rempli =',f11.3,4x,'Triang =',f11.3)
  210 format(/' Total time =',i4,' h,',i3,' min,',i3,' sCPU')
  500 format(/' The Fermi level was not reached ! ')
  502 format(/11x,'Total Cluster energy =',f14.3,' eV')
  505 format(11x,'Delta_energ =',f11.3,
     &      ' eV < Delta =',f8.3,' eV,  Weight =',f8.5)
  510 format(11x,'Delta_energ =',f11.3,
     &      ' eV > Delta =',f8.3,' eV,  Weight =',f8.5)
  520 format(/' E_cut =',f11.5,' eV')
  555 format(/' Case Hubbard: occupation matrix Int_dens_all for cycle:'
     &                                        ,i3)
  569 format('ia =',i3, '  no Hubbard correction for this atom')
  573 format('ia = ',i3)
  574 format(/'isp = ',i2)
  575 format(1p,i3,3x,7e13.5)  
      end


!***********************************************************************

      subroutine MPI_RECV_all(mpinodes,mpirank,nbseuil,  
     &        nspinr,secdd,secdo,secdq,secmd,secmm,secqq)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      include 'mpif.h'

      complex(kind=db), dimension(3,3,nbseuil,nspinr,0:mpinodes-1)::
     &                             secdd, secmd, secmm
      complex(kind=db), dimension(3,3,3,nbseuil,nspinr,0:mpinodes-1)::
     &                             secdq
      complex(kind=db), dimension(3,3,3,3,nbseuil,nspinr,0:mpinodes-1)::
     &                             secdo, secqq

      integer:: rang

      logical:: comp_dd, comp_md, comp_do, comp_dq, comp_mm,
     &        comp_qq

      real(kind=db), dimension(3,3,nbseuil,nspinr,0:mpinodes-1) :: 
     &      secdd_er, secmd_er, secmm_er, secdd_ei, secmd_ei, secmm_ei
      real(kind=db), dimension(3,3,3,nbseuil,nspinr,0:mpinodes-1) ::
     &                             secdq_er, secdq_ei
      real(kind=db), dimension(3,3,3,3,nbseuil,nspinr,0:mpinodes-1) ::
     &                    secdo_er, secqq_er, secdo_ei, secqq_ei

      common/comp_dd/ comp_dd, comp_md, comp_do, comp_dq,comp_mm,comp_qq
  
      idim1 = 3 * 3 * nbseuil * nspinr
      idim2 = 3 * idim1
      idim3 = 3 * idim2

! Recopies afin de stoquer les parties reele et imaginaire; l'indice sur
! les processeurs est en dernier

      secdd_er(:,:,:,:,mpirank) = real( secdd(:,:,:,:,mpirank),db )
      secdd_ei(:,:,:,:,mpirank) = aimag( secdd(:,:,:,:,mpirank) )

      if( comp_md )  then
        secmd_er(:,:,:,:,mpirank) = real( secmd(:,:,:,:,mpirank),db )
        secmd_ei(:,:,:,:,mpirank) = aimag( secmd(:,:,:,:,mpirank) )
      endif

      if( comp_mm )  then
        secmm_er(:,:,:,:,mpirank) = real( secmm(:,:,:,:,mpirank),db )
        secmm_ei(:,:,:,:,mpirank) = aimag( secmm(:,:,:,:,mpirank) )
      endif

      if( comp_dq )  then
        secdq_er(:,:,:,:,:,mpirank) = real( secdq(:,:,:,:,:,mpirank),db)
        secdq_ei(:,:,:,:,:,mpirank) = aimag( secdq(:,:,:,:,:,mpirank) )
      endif

      if( comp_do )  then
        secdo_er(:,:,:,:,:,:,mpirank) = 
     &                    real( secdo(:,:,:,:,:,:,mpirank),db )
        secdo_ei(:,:,:,:,:,:,mpirank) = 
     &                    aimag( secdo(:,:,:,:,:,:,mpirank) )
      endif

      if( comp_qq )  then
        secqq_er(:,:,:,:,:,:,mpirank) = 
     &                    real( secqq(:,:,:,:,:,:,mpirank),db )
        secqq_ei(:,:,:,:,:,:,mpirank) = 
     &                    aimag( secqq(:,:,:,:,:,:,mpirank) )
      endif

      call MPI_BARRIER(MPI_COMM_WORLD,ier)

      if( mpirank == 0 ) then 
        call MPI_GATHER(MPI_IN_PLACE,idim1,MPI_REAL8,secdd_er,
     &                idim1,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        call MPI_GATHER(MPI_IN_PLACE,idim1,MPI_REAL8,secdd_ei,
     &                idim1,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        if( comp_md )  then
          call MPI_GATHER(MPI_IN_PLACE,idim1,MPI_REAL8,secmd_er,
     &               idim1,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(MPI_IN_PLACE,idim1,MPI_REAL8,secmd_ei,
     &               idim1,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        end if
        if( comp_mm )  then
          call MPI_GATHER(MPI_IN_PLACE,idim1,MPI_REAL8,secmm_er,
     &               idim1,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(MPI_IN_PLACE,idim1,MPI_REAL8,secmm_ei,
     &               idim1,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        end if
        if( comp_dq )  then
          call MPI_GATHER(MPI_IN_PLACE,idim2,MPI_REAL8,secdq_er,
     &               idim2,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(MPI_IN_PLACE,idim2,MPI_REAL8,secdq_ei,
     &               idim2,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        end if
        if( comp_qq )  then
          call MPI_GATHER(MPI_IN_PLACE,idim3,MPI_REAL8,secqq_er,
     &               idim3,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(MPI_IN_PLACE,idim3,MPI_REAL8,secqq_ei,
     &               idim3,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        end if
        if( comp_do )  then
          call MPI_GATHER(MPI_IN_PLACE,idim3,MPI_REAL8,secdo_er,
     &               idim3,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(MPI_IN_PLACE,idim3,MPI_REAL8,secdo_ei,
     &               idim3,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        end if

      else

        call MPI_GATHER(secdd_er(1,1,1,1,mpirank),idim1,MPI_REAL8,
     &              secdd_er,idim1,MPI_REAL8,
     &              0,MPI_COMM_WORLD,mpierr)
        call MPI_GATHER(secdd_ei(1,1,1,1,mpirank),idim1,MPI_REAL8,
     &              secdd_ei,idim1,MPI_REAL8,
     &              0,MPI_COMM_WORLD,mpierr)
        if( comp_md ) then
          call MPI_GATHER(secmd_er(1,1,1,1,mpirank),idim1,MPI_REAL8,
     &                secmd_er,idim1,MPI_REAL8,
     &                0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(secmd_ei(1,1,1,1,mpirank),idim1,MPI_REAL8,
     &              secmd_ei,idim1,MPI_REAL8,
     &              0,MPI_COMM_WORLD,mpierr)
        end if

        if( comp_mm ) then
          call MPI_GATHER(secmm_er(1,1,1,1,mpirank),idim1,MPI_REAL8,
     &              secmm_er,idim1,MPI_REAL8,
     &              0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(secmm_ei(1,1,1,1,mpirank),idim1,MPI_REAL8,
     &              secmm_ei,idim1,MPI_REAL8,
     &              0,MPI_COMM_WORLD,mpierr)
        end if

        if( comp_dq ) then
          call MPI_GATHER(secdq_er(1,1,1,1,1,mpirank),idim2,
     &              MPI_REAL8,secdq_er,
     &              idim2,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(secdq_ei(1,1,1,1,1,mpirank),idim2,
     &              MPI_REAL8,secdq_ei,
     &              idim2,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        end if

        if( comp_qq ) then
          call MPI_GATHER(secqq_er(1,1,1,1,1,1,mpirank),idim3,
     &              MPI_REAL8,secqq_er,
     &              idim3,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(secqq_ei(1,1,1,1,1,1,mpirank),idim3,
     &              MPI_REAL8,secqq_ei,
     &              idim3,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        end if

        if( comp_do ) then
          call MPI_GATHER(secdo_er(1,1,1,1,1,1,mpirank),idim3,
     &              MPI_REAL8,secdo_er,
     &              idim3,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
          call MPI_GATHER(secdo_ei(1,1,1,1,1,1,mpirank),idim3,
     &              MPI_REAL8,secdo_ei,
     &              idim3,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        end if

      end if
      
      call MPI_BARRIER(MPI_COMM_WORLD,mpierr) 

! On reconstruit les secXX; maintenant le processus central voit les
! resultats de tous les autres
      if( mpirank == 0 ) then       
        do rang = 1,mpinodes-1
          secdd(:,:,:,:,rang) = cmplx( secdd_er(:,:,:,:,rang), 
     &                         secdd_ei(:,:,:,:,rang),db )
          if( comp_md ) secmd(:,:,:,:,rang) = cmplx(
     &         secmd_er(:,:,:,:,rang), secmd_ei(:,:,:,:,rang),db )
          if( comp_mm ) secmm(:,:,:,:,rang) = cmplx(
     &         secmm_er(:,:,:,:,rang), secmm_ei(:,:,:,:,rang),db )
          if( comp_dq ) secdq(:,:,:,:,:,rang) = cmplx( 
     &       secdq_er(:,:,:,:,:,rang), secdq_ei(:,:,:,:,:,rang),db )
          if( comp_qq ) secqq(:,:,:,:,:,:,rang) = cmplx( 
     &      secqq_er(:,:,:,:,:,:,rang), secqq_ei(:,:,:,:,:,:,rang),db )
          if( comp_do ) secdo(:,:,:,:,:,:,rang) = cmplx( 
     &      secdo_er(:,:,:,:,:,:,rang), secdo_ei(:,:,:,:,:,:,rang),db )
        end do
      end if

      return
      end

!***********************************************************************

      subroutine MPI_RECV_statedens(ipr0,lla2_state,lmaxat,mpinodes,
     &                      mpirank,n_atom_0,n_atom_ind,
     &                      n_atom_proto,nspin,statedens)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      include 'mpif.h'

      integer, dimension(ipr0:n_atom_proto):: lmaxat
      integer, dimension(ipr0:n_atom_proto,0:mpinodes-1):: lmaxat_e

      real(kind=db), dimension(lla2_state,nspin,n_atom_0:n_atom_ind,
     &                        0:mpinodes-1):: statedens

      lmaxat_e(:,mpirank) = lmaxat(:) 
      idim = n_atom_proto - ipr0 + 1

      if( mpirank == 0 ) then
        call MPI_GATHER(MPI_IN_PLACE,idim,MPI_INTEGER,
     &                  lmaxat_e,idim,MPI_INTEGER,0,MPI_COMM_WORLD,
     &                  mpierr)
      else
        call MPI_GATHER(lmaxat_e(ipr0,mpirank),idim,MPI_INTEGER,
     &                  lmaxat_e,idim,MPI_INTEGER,0,MPI_COMM_WORLD,
     &                  mpierr)
      end if

! Ceux sont les lmax correspondant a l'energie la plus grande qui sont
! les plus grands.
 
      if( mpirank == 0 ) lmaxat(:) = lmaxat_e(:,mpinodes-1)

! MPI_GATHER: le choix lorsque tous les ordinateurs envoyent le meme nombre 
! d'elements a l'ordinateur central

      idim = lla2_state * nspin * ( n_atom_ind - n_atom_0 + 1 )

      if( mpirank == 0 ) then
        call MPI_GATHER(MPI_IN_PLACE,idim,MPI_REAL8,
     &                  statedens,idim,MPI_REAL8,0,MPI_COMM_WORLD,
     &                  mpierr)
      else
        call MPI_GATHER(statedens(1,1,n_atom_0,mpirank),idim,MPI_REAL8,
     &                  statedens,idim,MPI_REAL8,0,MPI_COMM_WORLD,
     &                  mpierr)
      end if
    
      return
      end

!***********************************************************************

      subroutine MPI_RECV_statedens_hd(m_hubb,mpinodes,mpirank,
     &               n_atom_0_self,n_atom_ind_self,nspin,statedens_hd)

      use declarations
      implicit real(kind=db) (a-h,o-z)
      include 'mpif.h'

      real(kind=db), dimension(-m_hubb:m_hubb,-m_hubb:m_hubb,nspin, 
     &       n_atom_0_self:n_atom_ind_self,0:mpinodes-1):: statedens_hd

! MPI_GATHER: le choix lorsque tous les ordinateurs envoyent le meme nombre 
! d'elements a l'ordinateur central

      idim = ( 2 * m_hubb + 1 )**2 * nspin * ( n_atom_ind_self -
     &            n_atom_0_self + 1 ) 

      if( mpirank == 0 ) then
        call MPI_GATHER(MPI_IN_PLACE,idim,MPI_REAL8,
     &                  statedens_hd,idim,MPI_REAL8,0,MPI_COMM_WORLD,
     &                  mpierr)
      else
        call MPI_GATHER(
     &     statedens_hd(-m_hubb,-m_hubb,1,n_atom_0_self,mpirank),idim,
     &                  MPI_REAL8,
     &                  statedens_hd,idim,MPI_REAL8,0,MPI_COMM_WORLD,
     &                  mpierr)
      end if
    
      return
      end

!***********************************************************************
! IMPORTANT: depending on the operating system, the executable may run out
!     of virtual memory as the dummy arrays (such as drho_self) and the 
!     temporary ones are created in 
!     the stack (i.e. static memory), which is subject to a limited available space. 
!     Whereas a sequential application would normally return an error message,
!     a parallel MPI one would crash without any indication. 
!     In order to avoid such problems it is advisable to force your compiler use
!     dynamic allocation even for temporary arrays, at least for those whose size
!     exceeds a certain limit that you may indicate at compilation time.
!     Should you use this trick, make sure that you compile and run the program 
!     on the very same machine. This operation might have a price to pay in
!     terms of performance.
 
!     Linux Intel compiler for Itanium based applications: -heap-array[:size]

      subroutine MPI_RECV_self(drho_self,mpinodes,mpirank,
     &                   n_atom_0_self,n_atom_ind_self,nrm_self,nspin)
       
      use declarations
      implicit real(kind=db) (a-h,o-z)
      include 'mpif.h'

      integer rang

      real(kind=db), dimension(0:nrm_self,nspin,
     &           n_atom_0_self:n_atom_ind_self,0:mpinodes-1):: drho_self
      real(kind=db), dimension(0:nrm_self,nspin,0:mpinodes-1)::
     &                                   drho_self_e

      idim1 = ( nrm_self + 1 ) * nspin 

      do ia = n_atom_0_self,n_atom_ind_self

        drho_self_e(:,:,mpirank) = drho_self(:,:,ia,mpirank)

! Ici la barriere est tres importante: si on l'ommet on risque d'utiliser le
!    meme buffer rhov_self_eX par deux processus differents aux iapr differents

        call MPI_BARRIER(MPI_COMM_WORLD,mpierr) 
          
        if( mpirank == 0 ) then 
          call MPI_GATHER(MPI_IN_PLACE,idim1,MPI_REAL8,
     &                    drho_self_e,idim1,MPI_REAL8,
     &                    0,MPI_COMM_WORLD,mpierr)
        else
          call MPI_GATHER(drho_self_e(0,1,mpirank),
     &                    idim1,MPI_REAL8,drho_self_e,
     &                    idim1,MPI_REAL8,0,MPI_COMM_WORLD,mpierr)
        end if

        call MPI_BARRIER(MPI_COMM_WORLD,mpierr)

        if( mpirank == 0 ) then
          do rang = 1,mpinodes-1
            drho_self(:,:,ia,rang) = drho_self_e(:,:,rang)
          end do
        end if

! Cette barriere est importante, car drho_self_e est utilise en tant que
! buffer et ne devrait pas etre remplie pour deux ia differents 
        call MPI_BARRIER(MPI_COMM_WORLD,mpierr) 

      end do
               
      return
      end
