/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        set.c                                  $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: set.c,v 1.5 2007/03/16 14:33:12 wilcke Exp $

****************************************************************************/

/***************************************************************************

    Changes:

Update 08/03/2007 R. Wilcke (wilcke@esrf.fr)
                  set_plot(): make set_plot_length a variable, set dimension of
                  "set_plot_menu" to "[]" and set value of set_plot_length
                  dynamically.
Update 08/01/2001 E.Vlieg (vlieg@sci.kun.nl)
                  Change command ATOMRADIUS in set.plot> to RADIUS.

    22/10/91    Limits + penalties for parameters introduced

****************************************************************************/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <ctype.h>
#define SET
#include "rod.h"

/***************************************************************************/
int     get_natom(char *prompt)
/***************************************************************************/

    /*
    Get atom serial number within allowed range
    */

    {

    int natom;


    /* Check if there is any model read in */

    if (NSURFTOT < 1)
	{
	errtype("ERROR, no atoms in surface model");
	return(0);
	}

    while (TRUE)
	{
	natom = get_int(1,prompt);
	if ((natom < 1) || (natom > NSURFTOT))
	    {
	    errtype("ERROR, illegal atom number");
	    }
	else
	    {
	    return(natom);
	    }
	}
    }


/***************************************************************************/
void    set(void)
/***************************************************************************/

    /*
    Set menu.
    */

    {

    /* define set_menu */

#define set_length 8       /* number of commands in set menu */

    static struct   MENU set_menu[set_length] =
	{
	"calculate",1,  1,  "Parameters for rod calculation",
	"fit",      1,  2,  "Model par. for fitting surface structure",
	"parameters",2, 3,  "Values of fit parameters",
	"domain",   1,  4,  "Parameters describing the domains",
	"plot",     1,  5,  "Plotting parameters",
	"symmetry", 2,  6,  "Plane group symmetry of model",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.SET>"))
	    break;
	switch (cmnd_match(token,set_menu,set_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		set_calc();
		break;
	    case 2:
		set_fit_model();
		break;
	    case 3:
		set_parameters();
		break;
	    case 4:
		set_domain();
		break;
	    case 5:
		set_plot();
		break;
	    case 6:
		set_symmetry();
		break;
	    case 20:
		list_menu("SET MENU",set_menu,set_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_calc(void)
/***************************************************************************/

    /*
    Set parameters determining the rod calculation.
    */

    {

    /* define set_calc_menu */

#define set_calc_length 17	/* number of commands in set_calc menu */

    static struct   MENU set_calc_menu[set_calc_length] =
	{
	"structure",2,  1,  "Use structure factors or intensities",
	"lstart",   2,  2,  "Start value of l",
	"lend",     2,  3,  "End value of l",
	"npoints",  1,  4,  "Number of points on rod",
	"atten",    1,  5,  "Attenuation factor of beam",
	"beta",     1,  6,  "Roughness parameter beta",
	"lbragg",   2,  7,  "l-value of nearest Bragg peak",
	"nlayers",  2,  8,  "Number of layers in bulk unit cell",
	"scale",    2,  9,  "Scale factor of theory",
	"scale2",   6,  91, "2nd scale factor of theory",
	"sfraction",2,  10,  "Fraction of surface with 1st unit cell",
	"s2fraction",2, 11, "Fraction of surface with 2nd unit cell",
	"nsurf2",   2,  12, "Number of atoms in 2nd unit cell",
	"roughness",3,  13, "(Temporary) roughness mode calculation",
	"list",     1,  20, "List parameters",
	"help",     1,  30, "Display menu",
	"return",   1,  31, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    char    *item;

    while (!stop)
	{
	if (!get_token(token,"ROD.SET.CALC>"))
	    break;
	switch (cmnd_match(token,set_calc_menu,set_calc_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,
		    "Use structure factors (else intensities) [%s]: ",
		    yesnostr(STRUCFAC));
		STRUCFAC = yesno(STRUCFAC,STRING);
		break;
	    case 2:
		sprintf(STRING,"Start value of l [%4.2f]: ",LSTART);
		LSTART = get_real(LSTART,STRING);
		break;
	    case 3:
		sprintf(STRING,"End value of l [%4.2f]: ",LEND);
		LEND = get_real(LEND,STRING);
		break;
	    case 4:
		sprintf(STRING,"Number of points on rod [%1d]: ",NL);
		NL = get_int(NL,STRING);
		if (NL < 2)
		    NL = 2;
		if (NL > MAXTHEO)
		    NL = MAXTHEO;
		break;
	    case 5:
		sprintf(STRING,
		    "Attenuation factor of X-ray beam [%5.3f]: ",ATTEN);
		ATTEN = get_real(ATTEN,STRING);
		break;
	    case 6:
		sprintf(STRING,"Roughness parameter beta [%5.3f]: ",BETA);
		BETA = get_real(BETA,STRING);
		break;
	    case 7:
		sprintf(STRING,
		    "l-value of nearest Bragg peak [%4.2f]: ",LBRAGG);
		LBRAGG = get_real(LBRAGG,STRING);
		break;
	    case 8:
		sprintf(STRING,
		    "Number of layers in bulk unit cell [%1d]: ",NLAYERS);
		NLAYERS = get_int(NLAYERS,STRING);
		break;
	    case 9:
		sprintf(STRING,"Scale factor of theory [%4.2f]: ",SCALE);
		SCALE = get_real(SCALE,STRING);
		break;
	    case 91:
		sprintf(STRING,
		    "2nd scale factor of theory (for l_bragg < 0) [%4.2f]: ",
		    SCALE2);
		SCALE2 = get_real(SCALE2,STRING);
		break;
	    case 10:
		sprintf(STRING,"Fraction of reconstructed surface [%4.2f]: ",
		    SURFFRAC);
		SURFFRAC = get_real(SURFFRAC,STRING);
		break;
	    case 11:
		sprintf(STRING,
		    "Fraction of reconstructed surface with 2nd unit cell [%4.2f]: ",
		    SURF2FRAC);
		SURF2FRAC = get_real(SURF2FRAC,STRING);
		break;
	    case 12:
		sprintf(STRING,
		    "Number atoms in structure belonging to 2nd unit cell [%1d]: ",
		    NSURF2);
		NSURF2 = get_int(NSURF2,STRING);
		if (NSURF2 > NSURFTOT)
		    {
		    errtype("ERROR, can't be larger than total # of atoms");
		    NSURF2 = 0;
		    }
		NSURF = NSURFTOT-NSURF2;
		break;
	    case 13:
                set_roughness_mode();
                break;
	    case 20:
		if (STRUCFAC)
		    type_line("Use structure factors\n");
		else
		    type_line("Use intensities\n");
		sprintf(STRING,"l-start  = %7.3f\n",LSTART);
		type_line(STRING);
		sprintf(STRING,"l-end    = %7.3f\n",LEND);
		type_line(STRING);
		sprintf(STRING,"# points = %3d\n",NL);
		type_line(STRING);
		sprintf(STRING,"attenuation factor = %8.4f\n",ATTEN);
		type_line(STRING);
		sprintf(STRING,"roughness parameter beta = %8.4f\n",BETA);
		type_line(STRING);
		sprintf(STRING,"l-bragg = %8.4f\n",LBRAGG);
		type_line(STRING);
		sprintf(STRING,"n-layers = %1d\n",NLAYERS);
		type_line(STRING);
		sprintf(STRING,"scale factor = %8.4f\n",SCALE);
		type_line(STRING);
		sprintf(STRING,"2nd scale factor = %8.4f\n",SCALE2);
		type_line(STRING);
		sprintf(STRING,"Fraction of reconstructed surface = %6.2f\n",
		    SURFFRAC);
		type_line(STRING);
		sprintf(STRING,
		    "Reconstructed fraction with 2nd surface unit cell = %6.2f\n",
		    SURF2FRAC);
		type_line(STRING);
		sprintf(STRING,
		    "Number of atoms in 2nd surface unit cell = %1d\n",NSURF2);
		type_line(STRING);
		switch(ROUGHMODEL)
		    {
		    case APPROXBETA   : item = "Approximated beta"; break;
		    case EXACTBETA    : item = "Exact beta (bulk only)"; break;
		    case NUMBETA      : item = "Numerical beta"; break;
		    case POISSONROUGH : item = "Poisson"; break;
		    case GAUSSROUGH   : item = "Gaussian"; break;
		    case LINEARROUGH  : item = "Linear"; break;
		    case COSINEROUGH  : item = "Cosine"; break;
		    case TWOLEVEL     : item = "Two-level"; break;
		    }

		sprintf(STRING,"Roughness mode: %s\n", item);
		type_line(STRING);
		break;
	    case 30:
		list_menu("SET ROD CALCULATION PARAMETERS",
			  set_calc_menu,set_calc_length);
		break;
	    case 31:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void	set_roughness_mode(void)
/***************************************************************************/
    /*
      Set roughness mode for calculation of (bulk) roughness
    */

    {

    enum idx
	{
	i_null,
	i_approx,
	i_exact,
	i_beta,
	i_poisson,
	i_gauss,
	i_linear,
	i_cosine,
	i_twolevel,
	i_help,
	i_return
	};

    static struct MENU set_roughness_menu[i_return] =
        {
	"approx",  1, i_approx, "Approximated beta model",
	"exact",   1, i_exact, 	"Exact beta model (BULK ONLY!)",
	"beta",    1, i_beta, 	"Numerical beta model",
	"poisson", 1, i_poisson,"Poisson model",
	"gaussian",1, i_gauss, 	"Gaussian model",
	"linear",  3, i_linear, "Linear model",
	"cosine",  1, i_cosine, "Cosine model",
	"twolevel",1, i_twolevel,"Two-level model",
	"help",    1, i_help, 	"Display menu",
	"return",  1, i_return,	"Return to last menu"
        };

    int stop = FALSE;
    char token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.SET.CALC.ROUGH>"))
	    break;
	switch (cmnd_match(token,set_roughness_menu,i_return))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case i_approx :
		ROUGHMODEL = APPROXBETA;
		stop = TRUE;
		break;
	    case i_exact :
		ROUGHMODEL = EXACTBETA;
		stop = TRUE;
		break;
	    case i_beta :
		ROUGHMODEL = NUMBETA;
		stop = TRUE;
		break;
	    case i_poisson:
		ROUGHMODEL = POISSONROUGH;
		stop = TRUE;
		break;
	    case i_gauss:
		ROUGHMODEL = GAUSSROUGH;
		stop = TRUE;
		break;
            case i_linear:
		ROUGHMODEL = LINEARROUGH;
		stop = TRUE;
		break;
            case i_cosine:
		ROUGHMODEL = COSINEROUGH;
		stop = TRUE;
		break;
	    case i_twolevel:
		ROUGHMODEL = TWOLEVEL;
		stop = TRUE;
		break;
            case i_help:
		list_menu("SET ROUGHNESS MODE",
			  set_roughness_menu, i_return);
		break;
            }
        }
    }

/***************************************************************************/
void    set_domain(void)
/***************************************************************************/

    /*
    Set parameters determining the structure of rotational domains of the
    reconstructed surface unit cell.
    */

    {

    /* define set_domain_menu */

#define set_domain_length 9      /* number of commands in set_domain menu */

    static struct   MENU set_domain_menu[set_domain_length] =
	{
	"ndomains",  1,  1,  "Number of rotational surface domains",
	"matrix",    1,  2,  "Matrix elements of domain n",
	"fractional",1,  3,  "Include fractional coordinates yes/no",
	"equal",     1,  4,  "All domains equal occupancy yes/no",
	"occupancy", 1,  5,  "Set occupancy parameters of domain n",
        "coherent",  1,  6,  "Add rotational domains coherently yes/no",
	"list",      1,  10, "List parameters",
	"help",      1,  20, "Display menu",
	"return",    1,  21, "Return to main menu"
	};

    char    token[100];
    int     stop = FALSE;
    int     i,ndom;

    while (!stop)
	{
	if (!get_token(token,"ROD.SET.DOMAIN>"))
	    break;
	switch (cmnd_match(token,set_domain_menu,set_domain_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,
		    "Total number of rotational surface domains [%d]: ",
		    NDOMAIN);
		NDOMAIN = get_int(NDOMAIN,STRING);
		if (NDOMAIN > MAXDOM)
		    {
		    sprintf(STRING,"ERROR, maximum number of domains = %d",
			MAXDOM);
		    errtype(STRING);
		    clear_command();
		    NDOMAIN = MAXDOM;
		    }
		if (DOMEQUAL)
		    {
		    for (i = 0; i < NDOMAIN; i++)
			{
			DOMOCCUP[i] = 1./NDOMAIN;
			}
		    }
		break;
	    case 2:
		ndom = get_int(1,"Domain to be modified [1]: ");
		if (ndom > NDOMAIN)
		    {
		    errtype("ERROR, no such domain in structure");
		    clear_command();
		    break;
		    }
		sprintf(STRING,"Matrix element 11 [%6.3f]: ",DOMMAT11[ndom-1]);
		DOMMAT11[ndom-1] = get_real(DOMMAT11[ndom-1],STRING);
		sprintf(STRING,"Matrix element 12 [%6.3f]: ",DOMMAT12[ndom-1]);
		DOMMAT12[ndom-1] = get_real(DOMMAT12[ndom-1],STRING);
		sprintf(STRING,"Matrix element 21 [%6.3f]: ",DOMMAT21[ndom-1]);
		DOMMAT21[ndom-1] = get_real(DOMMAT21[ndom-1],STRING);
		sprintf(STRING,"Matrix element 22 [%6.3f]: ",DOMMAT22[ndom-1]);
		DOMMAT22[ndom-1] = get_real(DOMMAT22[ndom-1],STRING);
		break;
	    case 3:
		sprintf(STRING,"Include fractional order indices [%s]: ",
		    yesnostr(ZEROFRACT));
		ZEROFRACT = yesno(ZEROFRACT,STRING);
		break;
	    case 4:
		sprintf(STRING,"All domains equal occupancy [%s]: ",
		    yesnostr(DOMEQUAL));
		DOMEQUAL = yesno(DOMEQUAL,STRING);
		if (DOMEQUAL)
		    {
		    for (i = 0; i < NDOMAIN; i++)
			{
			DOMOCCUP[i] = 1./NDOMAIN;
			}
		    }
		break;
	    case 5:
		if (DOMEQUAL)
		    {
		    errtype("ERROR, all domains are set equal");
		    break;
		    }
		ndom = get_int(1,"Domain to be modified [1]: ");
		if (ndom > NDOMAIN)
		    {
		    errtype("ERROR, no such domain in structure");
		    clear_command();
		    break;
		    }
		sprintf(STRING,"Occupancy of domain %d [%6.3f]: ",
		    ndom,DOMOCCUP[ndom-1]);
		DOMOCCUP[ndom-1] = get_real(DOMOCCUP[ndom-1],STRING);
		break;
            case 6:
 		sprintf(STRING,"Add domains coherently [%s]: ",
		    yesnostr(COHERENTDOMAINS));
		COHERENTDOMAINS = yesno(COHERENTDOMAINS,STRING);
                break;
	    case 10:
		sprintf(STRING,"%2s %6s %6s %6s %6s\n","#","11","12","21","22");
		type_line(STRING);
		for (i = 0; i < NDOMAIN; i++)
		    {
		    sprintf(STRING,"%2d %6.3f %6.3f %6.3f %6.3f\n",
			i+1,DOMMAT11[i],DOMMAT12[i],DOMMAT21[i],DOMMAT22[i]);
		    type_line(STRING);
		    }
		sprintf(STRING,
		    "Include fractional-order diffraction indices?: %s\n",
		    yesnostr(ZEROFRACT));
		type_line(STRING);
		sprintf(STRING,"All domains equally occupied? %s\n",
		    yesnostr(DOMEQUAL));
		type_line(STRING);
		sprintf(STRING,"Add domains coherently? %s\n",
		    yesnostr(COHERENTDOMAINS));
		type_line(STRING);
		for (i = 0; i < NDOMAIN; i++)
		    {
		    sprintf(STRING,"Occupancy domain %d: %7.4f\n",
			i+1,DOMOCCUP[i]);
		    type_line(STRING);
		    }
		break;
	    case 20:
		list_menu("SET DOMAIN PARAMETERS",
		    set_domain_menu,set_domain_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_fit_model(void)
/***************************************************************************/

    /*
    Set fit parameters of surface atoms.
    */

    {

    /* define set_fit_menu */

#define set_fit_length 22      /* number of commands in set_fit menu */

    static struct   MENU set_fit_menu[set_fit_length] =
	{
	"element",  1,  1,  "Element type of atom",
	"xstart",   1,  2,  "Start x-position",
	"xconstant",2,  3,  "Multiplication factor of x-displacement",
	"xdisplace",2,  4,  "Serial number of x-displacement parameter",
	"x2constant",3, 5,  "Multiplication factor of 2nd x-displ.",
	"x2displace",3, 6,  "Serial number of 2nd x-displacement par.",
	"ystart",   1,  7,  "Start y-position",
	"yconstant",2,  8,  "Multiplication factor of y-displacement",
	"ydisplace",2,  9,  "Serial number of y-displacement parameter",
	"y2constant",3,10,  "Multiplication factor of 2nd y-displ.",
	"y2displace",3,11,  "Serial number of 2nd y-displacement par.",
	"zstart",   1, 12,  "Start z-position",
	"zdisplace",2, 13,  "Serial number of z-displacement parameter",
	"b1",       2, 14,  "Serial # of in-plane Debye-Waller par",
	"b2",       2, 15,  "Serial # of out-of-plane Debye-Waller par",
	"occupancy",1, 16,  "Serial number of occupancy parameter",
	"add",      1, 17,  "Add an atom to model",
	"delete",   1, 18,  "Delete an atom from model",
	"fullmodel",1, 19,  "Show extended model yes/no",
	"list",     1, 30,  "List atoms",
	"help",     1, 31,  "Display menu",
	"return",   1, 32,  "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    int     natom,i,newtype;
    char    element[3];

    while (!stop)
	{
	if (!get_token(token,"ROD.SET.FIT>"))
	    break;
	switch (cmnd_match(token,set_fit_menu,set_fit_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		natom = get_natom("Atom number: ");
		get_token(element,"Element type: ");
		toupper(element[0]);
		tolower(element[1]);

		/* Check whether this is a new element type */

		newtype = TRUE;
		for (i = 0; i < NTYPES; i++)
		    {
		    if (el_equal(element,ELEMENT[i]))
			{
			newtype = FALSE;
			TS[natom-1] = i;
			}
		    }
		if (newtype)
		    {
		    if (NTYPES == MAXTYPES)
			{
			errtype("ERROR, too many atom types");
			break;
			}
		    NTYPES++;
		    get_coeff(element,F_COEFF[NTYPES-1]);
		    if (F_COEFF[NTYPES-1][0] == 0.)
			{
			NTYPES--;
			TS[natom-1] = 0;
			}
		    else
			{
			sprintf(ELEMENT[NTYPES-1],"%s",element);
			TS[natom-1] = NTYPES-1;
			}
		    }
		break;
	    case 2:
		natom = get_natom("Atom number: ");
		sprintf(STRING,"Start x-position of surface atom [%5.3f]: ",
		    XS[natom-1]);
		XS[natom-1] = get_real(XS[natom-1],STRING);
		break;
	    case 3:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Multiplication factor of x-displacement [%5.2f]: ",
		    XCONST[natom-1]);
		XCONST[natom-1] = get_real(XCONST[natom-1],STRING);
		break;
	    case 4:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Serial number of x-displacement parameter [%1d]: ",
		    NXDIS[natom-1]);
		NXDIS[natom-1] = get_int(NXDIS[natom-1],STRING);
		if (NXDIS[natom-1] > NDISTOT) NDISTOT = NXDIS[natom-1];
		break;
	    case 5:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Multiplication factor of 2nd x-displacement [%5.2f]: ",
		    X2CONST[natom-1]);
		X2CONST[natom-1] = get_real(X2CONST[natom-1],STRING);
		break;
	    case 6:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Serial number of 2nd x-displacement parameter [%1d]: ",
		    NX2DIS[natom-1]);
		NX2DIS[natom-1] = get_int(NX2DIS[natom-1],STRING);
		if (NX2DIS[natom-1] > NDISTOT)
		    NDISTOT = NX2DIS[natom-1];
		break;
	    case 7:
		natom = get_natom("Atom number: ");
		sprintf(STRING,"Start y-position of surface atom [%5.3f]: ",
		    YS[natom-1]);
		YS[natom-1] = get_real(YS[natom-1],STRING);
		break;
	    case 8:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Multiplication factor of y-displacement [%5.2f]: ",
		    YCONST[natom-1]);
		YCONST[natom-1] = get_real(YCONST[natom-1],STRING);
		break;
	    case 9:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Serial number of y-displacement parameter [%1d]: ",
		    NYDIS[natom-1]);
		NYDIS[natom-1] = get_int(NYDIS[natom-1],STRING);
		if (NYDIS[natom-1] > NDISTOT)
		    NDISTOT = NYDIS[natom-1];
		break;
	    case 10:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Multiplication factor of 2nd y-displacement [%5.2f]: ",
		    Y2CONST[natom-1]);
		Y2CONST[natom-1] = get_real(Y2CONST[natom-1],STRING);
		break;
	    case 11:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Serial number of 2nd y-displacement parameter [%1d]: ",
		    NY2DIS[natom-1]);
		NY2DIS[natom-1] = get_int(NY2DIS[natom-1],STRING);
		if (NY2DIS[natom-1] > NDISTOT)
		    NDISTOT = NY2DIS[natom-1];
		break;
	    case 12:
		natom = get_natom("Atom number: ");
		sprintf(STRING,"Start z-position of surface atom [%5.3f]: ",
		    ZS[natom-1]);
		ZS[natom-1] = get_real(ZS[natom-1],STRING);
		break;
	    case 13:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Serial number of z-displacement parameter [%1d]: ",
		    NZDIS[natom-1]);
		NZDIS[natom-1] = get_int(NZDIS[natom-1],STRING);
		if (NZDIS[natom-1] > NDISTOT)
		    NDISTOT = NZDIS[natom-1];
		break;
	    case 14:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Serial number of parallel Debye-Waller parameter [%1d]: ",
		    NDWS[natom-1]);
		NDWS[natom-1] = get_int(NDWS[natom-1],STRING);
		if (NDWS[natom-1] > NDWTOT) NDWTOT = NDWS[natom-1];
		break;
	    case 15:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Serial number of perpendicular Debye-Waller parameter [%1d]: ",
		    NDWS2[natom-1]);
		NDWS2[natom-1] = get_int(NDWS2[natom-1],STRING);
		if (NDWS2[natom-1] > NDWTOT2)
		    NDWTOT2 = NDWS2[natom-1];
		break;
	    case 16:
		natom = get_natom("Atom number: ");
		sprintf(STRING,
		    "Serial number of occupancy parameter [%1d]: ",
		    NOCCUP[natom-1]);
		NOCCUP[natom-1] = get_int(NOCCUP[natom-1],STRING);
		if (NOCCUP[natom-1] > NOCCTOT)
		    NOCCTOT = NOCCUP[natom-1];
		break;
	    case 17:
		if (NSURFTOT == MAXATOMS)
		    {
		    errtype("Maximum number of atoms in model reached");
		    break;
		    }
		NSURFTOT++;
		natom = get_natom("Atom number: ");
		if (natom <= NSURF+1)
		    NSURF++;
		else
		    NSURF2++;

		/* Make room for new atom */

		for (i = NSURFTOT-1; i > natom-1; i--)
		    {
		    TS[i] = TS[i-1];
		    XS[i] = XS[i-1];
		    XCONST[i] = XCONST[i-1];
		    NXDIS[i] = NXDIS[i-1];
		    X2CONST[i] = X2CONST[i-1];
		    NX2DIS[i] = NX2DIS[i-1];
		    YS[i] = YS[i-1];
		    YCONST[i] = YCONST[i-1];
		    NYDIS[i] = NYDIS[i-1];
		    Y2CONST[i] = Y2CONST[i-1];
		    NY2DIS[i] = NY2DIS[i-1];
		    ZS[i] = ZS[i-1];
		    NZDIS[i] = NZDIS[i-1];
		    NDWS[i] = NDWS[i-1];
		    NDWS2[i] = NDWS2[i-1];
		    NOCCUP[i] = NOCCUP[i-1];
		    }

		/* Initialize parameters for new atom */

		TS[natom-1] = 0;
		XS[natom-1] = 0;
		XCONST[natom-1] = 0;
		NXDIS[natom-1] = 0;
		X2CONST[natom-1] = 0;
		NX2DIS[natom-1] = 0;
		YS[natom-1] = 0;
		YCONST[natom-1] = 0;
		NYDIS[natom-1] = 0;
		Y2CONST[natom-1] = 0;
		NY2DIS[natom-1] = 0;
		ZS[natom-1] = 0;
		NZDIS[natom-1] = 0;
		NDWS[natom-1] = 0;
		NDWS2[natom-1] = 0;
		NOCCUP[natom-1] = 0;
		break;
	    case 18:
		natom = get_natom("Atom number: ");
		if (natom <= NSURF)
		    NSURF--;
		else
		    NSURF2--;

		/* Shift atoms with higher serial numbers */

		for (i = natom-1; i < NSURFTOT-1; i++)
		    {
		    TS[i] = TS[i+1];
		    XS[i] = XS[i+1];
		    XCONST[i] = XCONST[i+1];
		    NXDIS[i] = NXDIS[i+1];
		    X2CONST[i] = X2CONST[i+1];
		    NX2DIS[i] = NX2DIS[i+1];
		    YS[i] = YS[i+1];
		    YCONST[i] = YCONST[i+1];
		    NYDIS[i] = NYDIS[i+1];
		    Y2CONST[i] = Y2CONST[i+1];
		    NY2DIS[i] = NY2DIS[i+1];
		    ZS[i] = ZS[i+1];
		    NZDIS[i] = NZDIS[i+1];
		    NDWS[i] = NDWS[i+1];
		    NDWS2[i] = NDWS2[i+1];
		    NOCCUP[i] = NOCCUP[i+1];
		    }
		NSURFTOT--;
		break;
	    case 19:
		sprintf(STRING,"Show extended model [%s]: ",
		    yesnostr(FULLMODEL));
		FULLMODEL = yesno(FULLMODEL,STRING);
		break;
	    case 30:
		clear_screen();
		type_list(STRING,0);
		if (FULLMODEL)
		    {
		    sprintf(STRING,
			"%2s %2s %7s %5s %2s %5s %2s %7s %5s %2s %5s %2s %7s %2s %2s %2s %2s\n",
			"#","el",
			"x +","c1","d1","c2","d2",
			"y +","c1","d1","c2","d2",
			"z +","d","B1","B2","oc");
		    }
		else
		    {
		    sprintf(STRING,
			"%2s %2s %7s %6s %2s %7s %6s %2s %7s %2s %2s %2s %2s\n",
			"#","el",
			"x +","const","d",
			"y +","const","d",
			"z +","d","B1","B2","oc");
		    }
		type_list(STRING,ROWS);
		for (i = 0; i < NSURFTOT; i++)
		    {
		    if (FULLMODEL)
			{
			sprintf(STRING,
			    "%2d %2s %7.4f %5.2f %2d %5.2f%3d%8.4f%6.2f%3d%6.2f%3d%8.4f%3d%3d%3d%3d\n",
			    i+1,ELEMENT[TS[i]],
			    XS[i],XCONST[i],NXDIS[i],X2CONST[i],NX2DIS[i],
			    YS[i],YCONST[i],NYDIS[i],Y2CONST[i],NY2DIS[i],
			    ZS[i],NZDIS[i],NDWS[i],NDWS2[i],NOCCUP[i]);
			}
		    else
			{
			sprintf(STRING,
			    "%2d %2s %7.4f %6.3f %2d %7.4f %6.3f %2d %7.4f %2d %2d %2d %2d\n",
			    i+1,ELEMENT[TS[i]],
			    XS[i],XCONST[i],NXDIS[i],
			    YS[i],YCONST[i],NYDIS[i],
			    ZS[i],NZDIS[i],NDWS[i],NDWS2[i],NOCCUP[i]);
			}
		    type_list(STRING,ROWS);
		    }
		break;
	    case 31:
		list_menu("SET SURFACE MODEL PARAMETERS",
		    set_fit_menu,set_fit_length);
		break;
	    case 32:
		stop = TRUE;
	    }
	}
    update_model();
    }

/***************************************************************************/
void set_parameters(void)
/***************************************************************************/

    /*
    Set values of fit parameters.
    */

    {

    /* define set_par_menu */

#define set_par_length 11      /* number of commands in set_par menu */

    static struct   MENU set_par_menu[set_par_length] =
	{
	"scale",    2,  1,  "Scale factor of theory",
	"scale2",   6,  11, "2nd scale factor of theory",
	"beta",     1,  2,  "Roughness parameter beta",
	"surffrac", 2,  3,  "Reconstructed-surface fraction",
	"displace", 1,  4,  "Value of displacement parameter",
	"b1",       2,  5,  "Value of paral. Debye-Waller parameter",
	"b2",       2,  6,  "Value of perp. Debye-Waller parameter",
	"occupancy",1,  7,  "Value of occupancy parameter",
	"list",     1,  10, "List parameters",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    int     stop = FALSE,npar,i;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.SET.PAR>"))
	    break;
	switch (cmnd_match(token,set_par_menu,set_par_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,"Scale factor of theory [%4.2f]: ",SCALE);
		SCALE = get_real(SCALE,STRING);
		sprintf(STRING,
		    "Lower limit of scale factor [%4.2f]: ",SCALELIM[0]);
		SCALELIM[0] = get_real(SCALELIM[0],STRING);
		sprintf(STRING,
		    "Upper limit of scale factor [%4.2f]: ",SCALELIM[1]);
		SCALELIM[1] = get_real(SCALELIM[1],STRING);
		sprintf(STRING,
		    "Range checking on scale factor [%s]: ",yesnostr(SCALEPEN));
		SCALEPEN = yesno(SCALEPEN,STRING);
		break;
	    case 11:
		sprintf(STRING,
		    "2nd scale factor of theory [%4.2f]: ",SCALE2);
		SCALE2 = get_real(SCALE2,STRING);
		sprintf(STRING,
		    "Lower limit of 2nd scale factor [%4.2f]: ",SCALE2LIM[0]);
		SCALE2LIM[0] = get_real(SCALE2LIM[0],STRING);
		sprintf(STRING,
		    "Upper limit of 2nd scale factor [%4.2f]: ",SCALE2LIM[1]);
		SCALE2LIM[1] = get_real(SCALE2LIM[1],STRING);
		sprintf(STRING,"Range checking on 2nd scale factor [%s]: ",
		    yesnostr(SCALE2PEN));
		SCALE2PEN = yesno(SCALE2PEN,STRING);
		break;
	    case 2:
		sprintf(STRING,"Roughness parameter beta [%4.2f]: ",BETA);
		BETA = get_real(BETA,STRING);
		sprintf(STRING,
		    "Lower limit of roughness parameter [%4.2f]: ",BETALIM[0]);
		BETALIM[0] = get_real(BETALIM[0],STRING);
		sprintf(STRING,
		    "Upper limit of roughness parameter [%4.2f]: ",BETALIM[1]);
		BETALIM[1] = get_real(BETALIM[1],STRING);
		sprintf(STRING,"Range checking on roughness parameter [%s]: ",
		    yesnostr(BETAPEN));
		BETAPEN = yesno(BETAPEN,STRING);
		break;
	    case 3:
		sprintf(STRING,
		    "Reconstructed-surface fraction [%4.2f]: ",SURFFRAC);
		SURFFRAC = get_real(SURFFRAC,STRING);
		sprintf(STRING,
		    "Lower limit of surface fraction [%4.2f]: ",SURFFRACLIM[0]);
		SURFFRACLIM[0] = get_real(SURFFRACLIM[0],STRING);
		sprintf(STRING,
		    "Upper limit of surface fraction [%4.2f]: ",SURFFRACLIM[1]);
		SURFFRACLIM[1] = get_real(SURFFRACLIM[1],STRING);
		sprintf(STRING,"Range checking on surface fraction [%s] ",
		    yesnostr(SURFFRACPEN));
		SURFFRACPEN = yesno(SURFFRACPEN,STRING);
		break;
	    case 4:
		npar = get_int(1,"Serial number of displacement parameter: ");
		if ((npar < 1) || (npar > NDISTOT))
		    {
		    errtype("ERROR, no such serial number in model");
		    break;
		    }
		sprintf(STRING,"Value of displacement parameter %1d [%6.3f]: ",
		    npar,DISPL[npar-1]);
		DISPL[npar-1] = get_real(DISPL[npar-1],STRING);
		sprintf(STRING,"Lower limit of displacement %1d [%6.3f]: ",
		    npar,DISPLLIM[npar-1][0]);
		DISPLLIM[npar-1][0] = get_real(DISPLLIM[npar-1][0],STRING);
		sprintf(STRING,"Upper limit of displacement %1d [%6.3f]: ",
		    npar,DISPLLIM[npar-1][1]);
		DISPLLIM[npar-1][1] = get_real(DISPLLIM[npar-1][1],STRING);
		sprintf(STRING,"Range checking on displacement %1d [%s]: ",
		    npar,yesnostr(DISPLPEN[npar-1]));
		DISPLPEN[npar-1] = yesno(DISPLPEN[npar-1],STRING);
		break;
	    case 5:
		npar = get_int(1,
		    "Serial number of parallel Debye-Waller parameter: ");
		if ((npar < 1) || (npar > NDWTOT))
		    {
		    errtype("ERROR, no such serial number in model");
		    break;
		    }
		sprintf(STRING,
		    "Value of parallel Debye-Waller parameter %1d [%6.3f]: ",
		    npar,DEBWAL[npar-1]);
		DEBWAL[npar-1] = get_real(DEBWAL[npar-1],STRING);
		sprintf(STRING,
		    "Lower limit of parallel Debye Waller %1d [%6.3f]: ",
		    npar,DEBWALLIM[npar-1][0]);
		DEBWALLIM[npar-1][0] = get_real(DEBWALLIM[npar-1][0],STRING);
		sprintf(STRING,
		    "Upper limit of parallel Debye Waller %1d [%6.3f]: ",
		    npar,DEBWALLIM[npar-1][1]);
		DEBWALLIM[npar-1][1] = get_real(DEBWALLIM[npar-1][1],STRING);
		sprintf(STRING,
		    "Range checking on parallel Debye Waller %1d [%s]: ",
		    npar,yesnostr(DEBWALPEN[npar-1]));
		DEBWALPEN[npar-1] = yesno(DEBWALPEN[npar-1],STRING);
		break;
	    case 6:
		npar = get_int(1,
		    "Serial number of perpendicular Debye-Waller parameter: ");
		if ((npar < 1) || (npar > NDWTOT2))
		    {
		    errtype("ERROR, no such serial number in model");
		    break;
		    }
		sprintf(STRING,
		    "Value of perpendicular Debye-Waller parameter %1d [%6.3f]: ",
		    npar,DEBWAL2[npar-1]);
		DEBWAL2[npar-1] = get_real(DEBWAL2[npar-1],STRING);            
		sprintf(STRING,
		    "Lower limit of perpendicular Debye Waller %1d [%6.3f]: ",
		    npar,DEBWAL2LIM[npar-1][0]);
		DEBWAL2LIM[npar-1][0] = get_real(DEBWAL2LIM[npar-1][0],STRING);
		sprintf(STRING,
		    "Upper limit of perpendicular Debye Waller %1d [%6.3f]: ",
		    npar,DEBWAL2LIM[npar-1][1]);
		DEBWAL2LIM[npar-1][1] = get_real(DEBWAL2LIM[npar-1][1],STRING);
		sprintf(STRING,
		    "Range checking on perpendicular Debye Waller %1d [%s]: ",
		    npar,yesnostr(DEBWAL2PEN[npar-1]));
		DEBWAL2PEN[npar-1] = yesno(DEBWAL2PEN[npar-1],STRING);
		break;
	    case 7:
		npar = get_int(1,"Serial number of occupancy parameter: ");
		if ((npar < 1) || (npar > NOCCTOT))
		    {
		    errtype("ERROR, no such serial number in model");
		    break;
		    }
		sprintf(STRING,"Value of occupancy parameter %1d [%6.3f]: ",
		    npar,OCCUP[npar-1]);
		OCCUP[npar-1] = get_real(OCCUP[npar-1],STRING);
		sprintf(STRING,
		    "Lower limit of occupancy parameter %1d [%6.3f]: ",
		    npar,OCCUPLIM[npar-1][0]);
		OCCUPLIM[npar-1][0] = get_real(OCCUPLIM[npar-1][0],STRING);
		sprintf(STRING,
		    "Upper limit of occupancy parameter %1d [%6.3f]: ",
		    npar,OCCUPLIM[npar-1][1]);
		OCCUPLIM[npar-1][1] = get_real(OCCUPLIM[npar-1][1],STRING);
		sprintf(STRING,
		    "Range checking on occupancy parameter %1d [%s]: ",
		    npar,yesnostr(OCCUPPEN[npar-1]));
		OCCUPPEN[npar-1] = yesno(OCCUPPEN[npar-1],STRING);
		break;
	    case 10:
		type_list(STRING,0);
		sprintf(STRING,
		    "scale factor of computed rod   = %8.4f  [%8.4f,%8.4f]  %s\n",
		    SCALE,SCALELIM[0],SCALELIM[1],yesnostr(SCALEPEN));
		type_list(STRING,ROWS);
		sprintf(STRING,
		    "2nd scale factor of comp. rod  = %8.4f  [%8.4f,%8.4f]  %s\n",
		    SCALE2,SCALE2LIM[0],SCALE2LIM[1],yesnostr(SCALE2PEN));
		type_list(STRING,ROWS);
		sprintf(STRING,
		    "roughness parameter beta       = %8.4f  [%8.4f,%8.4f]  %s\n",
		    BETA,BETALIM[0],BETALIM[1],yesnostr(BETAPEN));
		type_list(STRING,ROWS);
		sprintf(STRING,
		    "reconstructed-surface fraction = %8.4f  [%8.4f,%8.4f]  %s\n",
		    SURFFRAC,SURFFRACLIM[0],SURFFRACLIM[1],
		    yesnostr(SURFFRACPEN));
		type_list(STRING,ROWS);
		type_line("Displacement parameters:\n");
		for (i = 0; i < NDISTOT; i++)
		    {
		    sprintf(STRING,"%2d %8.5f  [%8.5f,%8.5f]  %s\n",i+1,
			DISPL[i],DISPLLIM[i][0],DISPLLIM[i][1],
			yesnostr(DISPLPEN[i]));
		    type_list(STRING,ROWS);
		    }
		type_line("In-plane Debye-Waller parameters:\n");
		for (i = 0; i < NDWTOT; i++)
		    {
		    sprintf(STRING,"%2d %8.5f  [%8.5f,%8.5f]  %s\n",i+1,
			DEBWAL[i],DEBWALLIM[i][0],DEBWALLIM[i][1],
			yesnostr(DEBWALPEN[i]));
		    type_list(STRING,ROWS);
		    }
		type_line("Out-of-plane Debye-Waller parameters:\n");
		for (i = 0; i < NDWTOT2; i++)
		    {
		    sprintf(STRING,"%2d %8.5f  [%8.5f,%8.5f]  %s\n",i+1,
			DEBWAL2[i],DEBWAL2LIM[i][0],DEBWAL2LIM[i][1],
			yesnostr(DEBWAL2PEN[i]));
		    type_list(STRING,ROWS);
		    }
		type_line("Occupancy parameters:\n");
		for (i = 0; i < NOCCTOT; i++)
		    {
		    sprintf(STRING,"%2d %8.5f  [%8.5f,%8.5f]  %s\n",i+1,
			OCCUP[i],OCCUPLIM[i][0],OCCUPLIM[i][1],
			yesnostr(OCCUPPEN[i]));
		    type_list(STRING,ROWS);
		    }
		break;
	    case 20:
		list_menu("SET PARAMETERS",set_par_menu,set_par_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    update_model();
    }

/***************************************************************************/
void    set_plot(void)
/***************************************************************************/

    /*
    Set parameters used for plotting.
    */

    {

    /* define set_plot_menu */

    static struct   MENU set_plot_menu[] =
	{
	"size",     1,  1,  "Size of circles in plot of f's",
	"threshold",1,  2,  "Plotting threshold for f's",
	"radius",   2,  3,  "Radius of atom in plot of model",
	"xmincont", 3,  4,  "Lower bound on x value in patterson",
	"xmaxcont", 3,  5,  "Upper bound on x value in patterson",
	"nxcontour",2,  6,  "Number of steps along x in patterson",
	"ymincont", 3,  7,  "Lower bound on y value in patterson",
	"ymaxcont", 3,  8,  "Upper bound on y value in patterson",
	"nycontour",2,  9,  "Number of steps along y in patterson",
	"minlevel", 2, 10,  "Minimum contour level in patterson",
	"maxlevel", 2, 11,  "Maximum contour level in patterson",
	"nlevel",   1, 12,  "Number of contour levels in patterson",
//        "file",     1, 13,  "Output file name for maps",
	"list",     1, 20,  "List parameters",
	"help",     1, 21,  "Display menu",
	"return",   1, 22,  "Return to main menu"
	};

     /* number of commands in set_plot menu */
    int set_plot_length = sizeof(set_plot_menu) / sizeof(set_plot_menu[0]);

    int     stop = FALSE,nelem,i;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"ROD.SET.PLOT>"))
	    break;
	switch (cmnd_match(token,set_plot_menu,set_plot_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,
		    "Size of f-circles (fraction of x-axis) [%5.3f]: ",FSIZE);
		FSIZE = get_real(FSIZE,STRING);
		break;
	    case 2:
		sprintf(STRING,
		    "Plotting threshold of f-circles (fraction of f_max) [%5.3f]: ",
		    FTHRESHOLD);
		FTHRESHOLD = get_real(FTHRESHOLD,STRING);
		break;
	    case 3:
		nelem = get_int(1,
		    "Serial number of atom to be changed [1]: ")-1;
		if (nelem >= MAXTYPES) break;
		sprintf(STRING,"Radius of %s [%5.3f]: ",
		    ELEMENT[nelem],ATRAD[nelem]);
		ATRAD[nelem] = get_real(ATRAD[nelem],STRING);
		break;
	    case 4:
		sprintf(STRING,
		    "Lower bound on x range (reduced coordinates) [%4.2f]: ",
		    XMINCON);
		XMINCON = get_real(XMINCON,STRING);
		break;
	    case 5:
		sprintf(STRING,
		    "Upper bound on x range (reduced coordinates) [%4.2f]: ",
		    XMAXCON);
		XMAXCON = get_real(XMAXCON,STRING);
		break;
	    case 6:
		sprintf(STRING,"Number of steps in x range [%1d]: ",NXCON);
		NXCON = get_int(NXCON,STRING);
		break;
	    case 7:
		sprintf(STRING,
		    "Lower bound on y range (reduced coordinates) [%4.2f]: ",
		    YMINCON);
		YMINCON = get_real(YMINCON,STRING);
		break;
	    case 8:
		sprintf(STRING,
		    "Upper bound on y range (reduced coordinates) [%4.2f]: ",
		    YMAXCON);
		YMAXCON = get_real(YMAXCON,STRING);
		break;
	    case 9:
		sprintf(STRING,"Number of steps in y range [%1d]: ",NYCON);
		NYCON = get_int(NYCON,STRING);
		break;
	    case 10:
		sprintf(STRING,
		    "Minimum contour level (-/+ = fraction of minimum/maximum) [%4.2f]: ",
		    MINCON);
		MINCON = get_real(MINCON,STRING);
		break;
	    case 11:
		sprintf(STRING,
		    "Maximum contour level (-/+ = fraction of minimum/maximum) [%4.2f]: ",
		    MAXCON);
		MAXCON = get_real(MAXCON,STRING);
		break;
	    case 12:
		sprintf(STRING,"Number of contours [%1d]: ",NLEVEL);
		NLEVEL = get_int(NLEVEL,STRING);
		break;
/*
  case 13:
  sprintf(STRING,"Output file name [%s]: ", PATFILENAME);
  get_string(PATFILENAME, STRING);
  break;
*/
	    case 20:
		sprintf(STRING,"f-circle size = %5.3f\n",FSIZE);
		type_line(STRING);
		sprintf(STRING,"f-circle plotting threshold = %5.3f\n",
		    FTHRESHOLD);
		type_line(STRING);
		for (i = 0; i < NTYPES; i++)
		    {
		    sprintf(STRING,"Radius of %s = %4.2f\n",ELEMENT[i],
			ATRAD[i]);
		    type_line(STRING);
		    }
		sprintf(STRING,
		    "X-range of contour from %4.2f to %4.2f in %1d steps\n",
		    XMINCON,XMAXCON,NXCON);
		type_line(STRING);
		sprintf(STRING,
		    "Y-range of contour from %4.2f to %4.2f in %1d steps\n",
		    YMINCON,YMAXCON,NYCON);
		type_line(STRING);
		sprintf(STRING,
		    "Contour ranging from %4.2f to %4.2f in %1d levels\n",
		    MINCON,MAXCON,NLEVEL);
		type_line(STRING);
//                sprintf(STRING, "Output file name: %s\n", PATFILENAME);
//		type_line(STRING);
		break;
	    case 21:
		list_menu("SET PLOT PARAMETERS",set_plot_menu,set_plot_length);
		break;
	    case 22:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_symmetry(void)
/***************************************************************************/

    /*
    Set plane group symmetry of crystal structure data menu.
    When generating symmetry-equivalent reflections, the program will
    in addition look for Friedel pairs (most important for l = 0).
    */

    {

    /* Define transformation matrices that generate equivalent reflections
       for the various plane groups */

    static int  p1[4] =   {1,0,0,1};                                    /*  1 */
    static int  p2[8] =   {1,0,0,1,   -1,0,0,-1};                       /*  2 */
    static int  pm[8] =   {1,0,0,1,   1,0,0,-1};                        /*  3 */
    int *pg = pm;                                                       /*  4 */
    int *cm = pm;                                                       /*  5 */
    static int p2mm[16] = {1,0,0,1,   -1,0,0,-1, -1,0,0,1, 1,0,0,-1};   /*  6 */
    int *p2mg = p2mm;                                                   /*  7 */
    int *p2gg = p2mm;                                                   /*  8 */
    int *c2mm = p2mm;                                                   /*  9 */
    static int p4[16] =   {1,0,0,1,   -1,0,0,-1, 0,-1,1,0,  0,1,-1,0};  /* 10 */
    static int p4mm[32] = {1,0,0,1,   -1,0,0,-1, -1,0,0,1,  1,0,0,-1,   /* 11 */
			   0,1,1,0,   0,-1,-1,0, 0,1,-1,0,  0,-1,1,0};
    int *p4gm = p4mm;                                                   /* 12 */
    static int p3[12] =   {1,0,0,1,   0,1,-1,-1, -1,-1,1,0};            /* 13 */
    static int p3m1[24] = {1,0,0,1,   0,1,-1,-1, -1,-1,1,0, 0,-1,-1,0,  /* 14 */
			   1,1,0,-1,  -1,0,1,1};
    static int p31m[24] = {1,0,0,1,   0,1,-1,-1, -1,-1,1,0, 0,1,1,0,    /* 15 */
			   -1,-1,0,1, 1,0,-1,-1};
    static int p6[24] =   {1,0,0,1,   0,1,-1,-1, -1,-1,1,0, -1,0,0,-1,  /* 16 */
			   0,-1,1,1,  1,1,-1,0};
    static int p6mm[48] = {1,0,0,1,   0,1,-1,-1, -1,-1,1,0, -1,0,0,-1,  /* 17 */
			   0,-1,1,1,  1,1,-1,0,  0,1,1,0,   -1,-1,0,1,
			   1,0,-1,-1, 0,-1,-1,0, 1,1,0,-1,  -1,0,1,1};

    static int n_matrices[17] = {1,2,2,2,2,4,4,4,4,4,8,8,3,6,6,6,12};

    /* define set_sym_menu */

#define set_sym_length 20      /* number of commands in set_sym menu */

    static struct   MENU set_sym_menu[set_sym_length] =
	{
	"p1",       2,  1,  "Plane group no. 1",
	"p2",       2,  2,  "Plane group no. 2",
	"pm",       2,  3,  "Plane group no. 3",
	"pg",       2,  4,  "Plane group no. 4",
	"cm",       2,  5,  "Plane group no. 5",
	"p2mm",     4,  6,  "Plane group no. 6",
	"p2mg",     4,  7,  "Plane group no. 7",
	"p2gg",     4,  8,  "Plane group no. 8",
	"c2mm",     4,  9,  "Plane group no. 9",
	"p4",       2,  10, "Plane group no. 10",
	"p4mm",     4,  11, "Plane group no. 11",
	"p4gm",     4,  12, "Plane group no. 12",
	"p3",       2,  13, "Plane group no. 13",
	"p3m1",     4,  14, "Plane group no. 14",
	"p31m",     4,  15, "Plane group no. 15",
	"p6",       2,  16, "Plane group no. 16",
	"p6mm",     4,  17, "Plane group no. 17",
	"list",     1,  20, "List current plane group",
	"help",     1,  21, "Display menu",
	"return",   1,  22, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    int     i,ncom;
    static int  nplanegroup = 0, *matrix;

    while (!stop)
	{
	if (!get_token(token,"ROD.SET.SYMMETRY>"))
	    break;
	ncom = cmnd_match(token,set_sym_menu,set_sym_length);
	switch (ncom)
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1: case 2: case 3: case 4: case 5: case 6: case 7: case 8:
	    case 9: case 10: case 11: case 12: case 13: case 14: case 15:
	    case 16: case 17:
		nplanegroup = ncom;
		sprintf(PLANEGROUP,"%s",set_sym_menu[nplanegroup-1].COMMAND);
		NTRANS = n_matrices[nplanegroup-1];
		if (nplanegroup == 1)
		    matrix = p1;
		if (nplanegroup == 2)
		    matrix = p2;
		if (nplanegroup == 3)
		    matrix = pm;
		if (nplanegroup == 4)
		    matrix = pg;
		if (nplanegroup == 5)
		    matrix = cm;
		if (nplanegroup == 6)
		    matrix = p2mm;
		if (nplanegroup == 7)
		    matrix = p2mg;
		if (nplanegroup == 8)
		    matrix = p2gg;
		if (nplanegroup == 9)
		    matrix = c2mm;
		if (nplanegroup == 10)
		    matrix = p4;
		if (nplanegroup == 11)
		    matrix = p4mm;
		if (nplanegroup == 12)
		    matrix = p4gm;
		if (nplanegroup == 13)
		    matrix = p3;
		if (nplanegroup == 14)
		    matrix = p3m1;
		if (nplanegroup == 15)
		    matrix = p31m;
		if (nplanegroup == 16)
		    matrix = p6;
		if (nplanegroup == 17)
		    matrix = p6mm;
		for (i = 0; i < n_matrices[nplanegroup-1]; i++)
		    {
		    TRANS[i][0][0] = matrix[i*4];
		    TRANS[i][0][1] = matrix[i*4+1];
		    TRANS[i][1][0] = matrix[i*4+2];
		    TRANS[i][1][1] = matrix[i*4+3];
		    }
		break;
	    case 20:
		if (nplanegroup == 0)
		    {
		    errtype("No plane group set");
		    break;
		    }
		else
		    {
		    sprintf(STRING,"Plane group %s No. %1d\n",
			PLANEGROUP,nplanegroup);
		    type_line(STRING);
		    type_line(
			"Matrices to generate equivalent reflections:\n");
		    for (i = 0; i < n_matrices[nplanegroup-1]; i++)
			{
			sprintf(STRING,"matrix %2d %3d %3d\n",i+1,
			    matrix[i*4],matrix[i*4+1]);
			type_line(STRING);
			sprintf(STRING,"          %3d %3d\n",
			    matrix[i*4+2],matrix[i*4+3]);
			type_line(STRING);
			}
		    }
		break;
	    case 21:
		list_menu("SET PLANE GROUP SYMMETRY",
		    set_sym_menu,set_sym_length);
		break;
	    case 22:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void update_model(void)
/***************************************************************************/

    /*
    Update the parameter of the model
    */

    {

    int i;

    for (i = 0; i < NSURF+NSURF2; i++)
	{
	XSFIT[i] = XS[i];
	if (NXDIS[i] > 0)
	    XSFIT[i] += XCONST[i]*DISPL[NXDIS[i]-1];
	if (NX2DIS[i] > 0)
	    XSFIT[i] += X2CONST[i]*DISPL[NX2DIS[i]-1];

	YSFIT[i] = YS[i];
	if (NYDIS[i] > 0)
	    YSFIT[i] += YCONST[i]*DISPL[NYDIS[i]-1];
	if (NY2DIS[i] > 0)
	    YSFIT[i] += Y2CONST[i]*DISPL[NY2DIS[i]-1];

	ZSFIT[i] = ZS[i];
	if (NZDIS[i] > 0)
	    ZSFIT[i] += DISPL[NZDIS[i]-1];
	}
    }
