/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                      PGmyplot.c                                $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: PGmyplot.c,v 1.35 2006/03/28 15:40:46 wilcke Exp $

****************************************************************************/

/*
Update 22/02/2006 R. Wilcke (wilcke@esrf.fr)
                  modified code for MacIntosh MACOSX using predefined macro
                  __APPLE__ for this architecture.
Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
Update 16/04/2002 O. Svensson (svensson@esrf.fr)
                  Renamed getPlotcursorPoints to getPlotcursorPoint,
                  changed the arguments.
Update 25/03/2002 R. Wilcke (wilcke@esrf.fr)
                  aplot(), drawing(), set_axis(), set_color(), set_layout(),
                  set_text(), and get_color(): changed abbreviations for menu
                  commands to the agreed set.
Update 26/11/2001 O. Svensson (svensson@esrf.fr)
                  Replaced STRING with PSTRING.
Update 21/09/2001 O. Svensson (svensson@esrf.fr)
                  Moved declarations of META_DEVICE, HC_DEVICE,
                  X_DEVICE, PS_DEVICE, PLOT_DEV, PLOT_CURSORNPOINTS
                  and PLOT_CURSORPOINTS from PGmyplot.h to this file.
Update 12/12/2000 R. Wilcke (wilcke@esrf.fr)
                  blankpage(): removed printing of string "hello".
Update 09/11/2000 O. Svensson (svensson@esrf.fr)
                  Added new menu items and methos "pushconfig" and
                  "popconfig".
Update 03/10/2000 R. Wilcke (wilcke@esrf.fr)
                  aplot(): check that lower and upper limit for x axis are not
                  identical; same check for y axis.
Update 03/10/2000 O. Svensson (svensson@esrf.fr)
                  Added a new cursor input method which stores the selected
                  points in a global variable PLOT_CURSORPOINTS.
Update 02/10/2000 R. Wilcke (wilcke@esrf.fr)
                  set_axis()and my_cpgenv(): corrected typographical errors.
Update 21/06/2000 R. Wilcke (wilcke@esrf.fr)
                  replace UNIX by __unix and CYGWIN by __CYGWIN__ (those are
                  defined by CPP on the corresponding systems).


Series of subroutines that use cpgplot to provide graphics support for 
Elias Vliegs x-ray diffraction programs.

Written by :    Paul Howes

Based on original myplot.c 
        by:     Elias Vlieg
		AT&T Bell Laboratories
		510E Brookhaven National Laboratory
		Upton, NY 11973

address since October 1, 1990

		FOM Institute
		Kruislaan 407
		1098 SJ Amsterdam
		The Netherlands
		tel. (31)-20-6081234
		fax. (31)-20-6684106

*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/
#define EXT extern

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "menu.h"
#include <PGmyplot.h>
#include <cpgplot.h>
#if defined(__APPLE__)
#include <string.h>
#endif
#define SLEEPTIME 0
/***************************************************************************/
/*      global parameters used in plotting                                 */
/***************************************************************************/

/* alldevs - a preprocessor macro for plotting to all PGPLOT devices */

#ifdef PGMETA
int META_DEVICE;
int HC_DEVICE;
#endif

int X_DEVICE;
int PS_DEVICE;
int PLOT_DEV;

int PLOT_CURSORNPOINTS;
float PLOT_CURSORPOINTS[PLOT_CURSORMAXPOINTS][2];

#ifdef PGMETA
#define alldevs(a) { cpgslct(X_DEVICE);      \
			PLOT_DEV=X_DEVICE;    \
			a ;                   \
			cpgslct(PS_DEVICE);   \
			PLOT_DEV=PS_DEVICE;   \
			a ;                   \
			cpgslct(META_DEVICE);   \
			PLOT_DEV=META_DEVICE;   \
			a ;                   \
		    }
#elif defined(__CYGWIN__)
#define alldevs(a) { a ; }
#else
#define alldevs(a) { cpgslct(X_DEVICE);      \
			PLOT_DEV=X_DEVICE;    \
			a ;                   \
			cpgslct(PS_DEVICE);   \
			PLOT_DEV=PS_DEVICE;   \
			a ;                   \
		    }
#endif


#define METRIC                    	/* Use either inches or cm */
/* #define	METRIC */
#define DO3D			/* Allow 3D options yes/no */

#define PLOTINIT get_plot_init_name()
char    DEF_ININAME[] = "plotinit.mac"; /* Default initializing file */
char plot_file_name[100]="ana.tmp";/* file name of latest plot */
#define PI      3.141592654
#ifdef INCHES
#define XPAGE   9                       /* x-size of full-sized printout */
#define YPAGE   6.855                   /* y-size of full-sized printout */
#endif
#ifdef METRIC
#define XPAGE   22.86                   /* x-size of full-sized printout */
#define YPAGE   17.40                   /* y-size of full-sized printout */
#endif
char    PSTRING[100];                   /* To be used everywhere */

/*      status parameters */

#define XYE     0               /* 2D curve plotting mode */
#define CONT    1               /* 2D contour plotting mode */
#ifdef DO3D
#define D3	2               /* 3D surface plotting mode */
#define D3CURVE 3		/* 3D curve plotting mode */
#endif
int     PLOTMODE = XYE;         /* Flag to set plotting mode */
int     GRAPHMODE = FALSE;      /* Flag to denote graphic/text mode */
int     PLOTMADE = FALSE;       /* Flag to see if a frame has been drawn */
#define	X	0		/* Switch to indicate current axis */
#define	Y	1		/* Switch to indicate current axis */
#ifdef DO3D
#define	Z	2		/* Switch to indicate current axis */
#endif
int NPLOTS=1;                   /* Number of current plots */


float * xptr;
float * yptr;
float * eptr;

/* axis-defining parameters */
float   xmax,xmin,ymax,ymin;    /* some dummy parameters */
float   zmax,zmin;              /* some dummy parameters */
int     AXIS;                   /* AXIS parameter for cpgplot*/
float   XLOWERSC;               /* Lower value of x-scale */
float   XUPPERSC;               /* Upper value of x-scale */
float   YLOWERSC;               /* Lower value of y-scale */
float   YUPPERSC;               /* Upper value of y-scale */
int     AUTOX;                  /* Flag for autoscaling of x-axis */
int     AUTOY;                  /* Flag for autoscaling of y-axis */
int     XLOGSC;                 /* Flag denoting linear/logarithmic x-axis */
int     YLOGSC;                 /* Flag denoting linear/logarithmic y-axis */
float   ZFORCE = 0.2;           /* Zero-force: determines tendency of lower
				scale limit to be forced to zero when auto-
				scaling */
float   XTICK;                  /* Spacing between ticks on x-axis */
float   XSUBTICK;               /* Spacing between sub-tick on x-axis */
char    XFORMAT[20];            /* Output format of labels on x-axis */
float   YTICK;                  /* Spacing between ticks on y-axis */
float   YSUBTICK;               /* Spacing between sub-tick on y-axis */
char    YFORMAT[20];            /* Output format of labels on y-axis */
int     XLABEL = FALSE;         /* Flag denoting x-axis string label option */
char    XLABSTRING[20][30];     /* Tick mark labels of x-axis */
char    *XLABPOINTER[20];       /* Array of pointers to x-axis labels */
int     YLABEL = FALSE;         /* Flag denoting x-axis string label option */
char    YLABSTRING[20][30];     /* Tick mark labels of y-axis */
char    *YLABPOINTER[20];       /* Array of pointers to y-axis labels */

#ifdef DO3D
float   ZLOWERSC;               /* Lower value of z-scale 3D only */
float   ZUPPERSC;               /* Upper value of z-scale 3D only */
int     AUTOZ;                  /* Flag for autoscaling of z-axis */
float	ZTICK;			/* Tick spacing on z-axis (3D only) */
char	ZTITLE[80];		/* Title of z-axis, 3D only */
#endif

/* titles */

char    XTITLE[80];             /* Title of x-axis */
char    YTITLE[80];             /* Title of y-axis */
char    PTITLE[80];             /* Title of plot */
int     NFONTS;                 /* Number of loaded fonts */
char    FONTNAME[4][20];        /* Name of font 1-4 */
int     DEFFONT;                /* Default font number */
int     FONTFILL;               /* Flag to denote filling of fonts */

/* curve-defining parameters */

int     CURVESTYLE;             /* Type of curve through data points */
int     LINESTYLE;              /* Type of line through data points */
int     SYMSTYLE=0;             /* Symbol type of data points */
float   SYMSIZE;                /* Size of plotting symbol */
char    LINETYPE[20]="lines  "; /* line style for Gnuplot */
/* colors */

int     COLBACK;                /* Background color */
int     COLAXES;                /* Color of axes */
int     COLCURVE;               /* Color of data curves and symbols */
int     COLTEXT;                /* Color of text */
char	BACK_COLOR[20];         /* List of corresponding color names */
char	AX_COLOR[20];
char	CURVE_COLOR[20];
char	TEXT_COLOR[20];

/* layout */

float   H_Y=-2   ;            /* Header line starting height */
float   H_HEIGHT=-2;             /* Header line height */
float   H_OFFSET;             /* separation of header lines */
int     AXES;                 /* AXIS type in cpgplot */
float   PLOTWIDTH;            /* Width of plot */
float   PLOTHEIGHT;           /* Height of plot */
float   XLENGTH;                /* Length of x-axis */
float   YLENGTH;                /* Length of y-axis */
int     AXESPAR;                /* Parameter setting axis option */
char	AXESCHAR;		/* Used to set the axes parameters */
int     FRAMEPAR;               /* Parameter setting frame option */
int     GRIDPAR;                /* Parameter setting grid option */
int     SUBGRIDPAR;             /* Parameter setting subgrid option */
int     PAGEROT;                /* Parameter setting page rotation */
#ifdef DO3D
float	XBOX,YBOX,ZBOX;		/* Box parameters 3D plot */
float	XVIEW,YVIEW,ZVIEW;	/* Viewpoint parameters 3D plot */
int	NXSKIP=0;		/* Nr. of gridlines to be skipped (3D) */
int	NYSKIP=0;
#endif

/* text */

float   AXNAMSIZE=1;              /* Character size of axes labels */
float   AXNUMSIZE=1;              /* Size of numbers at axes */
float   TITLESIZE=1;              /* Character size of plot title */
float   TEXTSIZE=1;               /* Character size of text */
float   X_TEXT,Y_TEXT;             /* position of text */

/* Parameters for making multiple plots */

int	MULTIPLOT = FALSE;	/* Flag to denote multiplot mode */
int	PLOT_ROWS = 1;		/* Number of plot rows */
int	PLOT_COLUMNS = 1;	/* Number of plot columns */
int	FIRST_MULTI = FALSE;	/* Flag to denote start of multiplot mode */
int	PLOTNR = 0;		/* Serial number of present plot */
float   XSHIFTT;                /* x-shift of lower-left corner */
float   YSHIFTT;                /* y-shift of lower-left corner */


/* cursor stuff under development */
void get_xy(char * promptx, char * prompty, float defx, float defy,
	    float *x, float *y);
void get_xy_xy(char * promptx, char * prompty,
	       char * promptx2, char * prompty2, 
	       float defx, float defy, float defx2, float defy2,
	       float *x, float *y, float *x2, float *y2);

/* Temporary string */

char SHORTSTRING[16];

/* Temporary storage variables for pushconfig and popconfig */

int     TMP_AXIS;                   
float   TMP_XLOWERSC;               
float   TMP_XUPPERSC;               
float   TMP_YLOWERSC;               
float   TMP_YUPPERSC;               
int     TMP_AUTOX;                  
int     TMP_AUTOY;                  
int     TMP_XLOGSC;                 
int     TMP_YLOGSC;                 
float   TMP_ZFORCE = 0.2;           
float   TMP_XTICK;                  
float   TMP_XSUBTICK;               
char    TMP_XFORMAT[20];            
float   TMP_YTICK;                  
float   TMP_YSUBTICK;               
char    TMP_YFORMAT[20];            
int     TMP_XLABEL = FALSE;         
char    TMP_XLABSTRING[20][30];     
char    *TMP_XLABPOINTER[20];       
int     TMP_YLABEL = FALSE;         
char    TMP_YLABSTRING[20][30];     
char    *TMP_YLABPOINTER[20];       
#ifdef DO3D
float   TMP_ZLOWERSC;               
float   TMP_ZUPPERSC;               
int     TMP_AUTOZ;                  
float	TMP_ZTICK;			
char	TMP_ZTITLE[80];		
#endif
char    TMP_XTITLE[80];             
char    TMP_YTITLE[80];             
char    TMP_PTITLE[80];             
int     TMP_NFONTS;                 
char    TMP_FONTNAME[4][20];        
int     TMP_DEFFONT;                
int     TMP_FONTFILL;               
int     TMP_CURVESTYLE;             
int     TMP_LINESTYLE;              
int     TMP_SYMSTYLE=0;             
float   TMP_SYMSIZE;                
char    TMP_LINETYPE[20]="lines  "; 
int     TMP_COLBACK;                
int     TMP_COLAXES;                
int     TMP_COLCURVE;               
int     TMP_COLTEXT;                
char	TMP_BACK_COLOR[20];         
char	TMP_AX_COLOR[20];
char	TMP_CURVE_COLOR[20];
char	TMP_TEXT_COLOR[20];
float   TMP_H_Y=-2   ;            
float   TMP_H_HEIGHT=-2;             
float   TMP_H_OFFSET;             
int     TMP_AXES;                 
float   TMP_PLOTWIDTH;            
float   TMP_PLOTHEIGHT;           
float   TMP_XLENGTH;                
float   TMP_YLENGTH;                
int     TMP_AXESPAR;                
char	TMP_AXESCHAR;		
int     TMP_FRAMEPAR;               
int     TMP_GRIDPAR;                
int     TMP_SUBGRIDPAR;             
int     TMP_PAGEROT;                
#ifdef DO3D
float	TMP_XBOX,TMP_YBOX,TMP_ZBOX;		
float	TMP_XVIEW,TMP_YVIEW,TMP_ZVIEW;	
int	TMP_NXSKIP=0;		
int	TMP_NYSKIP=0;
#endif
float   TMP_AXNAMSIZE=1;              
float   TMP_AXNUMSIZE=1;              
float   TMP_TITLESIZE=1;              
float   TMP_TEXTSIZE=1;               
float   TMP_X_TEXT,TMP_Y_TEXT;             
int	TMP_MULTIPLOT = FALSE;	
int	TMP_PLOT_ROWS = 1;		
int	TMP_PLOT_COLUMNS = 1;	
int	TMP_FIRST_MULTI = FALSE;	
int	TMP_PLOTNR = 0;		
float   TMP_XSHIFTT;                
float   TMP_YSHIFTT;                




/***************************************************************************/
/*	Prototypes for functions that are non-user callable                */
/***************************************************************************/

void    aplot(float x[], float y[], float e[], int npts,
	    float zmat[], float xc[], int nxc, float yc[], int nyc,
	    float min, float step, float max, int lnstyle[], int labint,
	    float xlow, float xup, float ylow, float yup);
void    drawing(void);
void    font_switch(char string[]);
int	get_color(char color_string[], char prompt[]);
char *	get_plot_init_name(void);
void    lin_scale(float *smin, float *smax, float *tick, float *subtick,
	char *format, int autoscale);
void    list_par(void);
void    load_fonts(void);
void    log_scale(float *smin, float *smax, int autoscale);
void	set_axis (int axis);
void    set_color(void);
void    set_default(void);
void    set_layout(void);
void    set_text(void);
void    write_plotmac(void);
void    ucircle(float xpos, float ypos, float radius, float th1, float th2);
void    uradlin(float xpos,float ypos,float dummy,float radius,float th1);
void    uline (float xpos,float ypos,float xpos2,float ypos2,float dummy);
void    d3line(float xpos,float ypos,float xpos2,float ypos2,float zpos1,float zpos2);

/***************************************************************************/
void    aplot(float x[], float y[], float e[], int npts,
	    float zmat[], float xc[], int nxc, float yc[], int nyc,
	    float min, float step, float max, int lnstyle[], int labint,
	    float xlow, float xup, float ylow, float yup)
/***************************************************************************/

    /*
    General plotting facility, that allows both xy plots and contour plots,
    depending on the value of PLOTMODE.
    If PLOTMODE == XYE
	- x[]       = array of x values
	- y[]       = array of y values
	- e[]       = array of errors in y values
	- npnts     = number of points

    If PLOTMODE == CONT
	- zmat[]    = nxc*nyc matrix written as array zmat[nxc*y+x]
	- xc[]      = array with x values
	- nxc       = number of x values (must be odd)
	- yc[]      = array with y values
	- nyc       = number of y values (must be odd)
	- min       = minimum contour level
	- step      = interval between contour levels
	- max       = maximum contour level
	- lnstyle[] = array with code for contour line style
	- labint    = flag to enable/disable contour labels

    if PLOTMODE == D3
	- zmat[]    = nxc*nyc matrix containing all data
	- nxc	    = x dimension of zmat
	- nyc	    = y dimension of zmat
	- xlow      = lower x-value
	- xup       = upper x-value
	- ylow	    = lower y-value
	- yup       = upper y-value

    If PLOTMODE == D3CURVE
	- x[]       = array of x values
	- y[]       = array of y values
	- e[] = 'z' = array of z values
	- npnts     = number of points

	cpgplot is called to do the actual plotting
    */

    {

    /* define aplot_menu */

    enum i_aplot {		/* List of all switches */
		i_zero, /* All command returns should be >= 0 */
		i_plot,
		i_errors,
		i_hardcopy,
		i_overlay,
		i_replot,
		i_cursor,
		i_ncursor,
		i_drawing,
		i_multiplot,
		i_curvestyle,
		i_linestyle,
		i_symbol,
		i_symsize,
		i_color,
		i_layout,
		i_text,
		i_default,
		i_x,
		i_y,
#ifdef DO3D
		i_z,
#endif
		i_loadfonts,
		i_font,
		i_title,
		i_macro,
		i_list,
		i_tmode,
		i_pushconfig,
		i_popconfig,
		i_init,
		i_save,
		i_close,
		i_help,
		i_break,
		i_return
		};

    static struct   MENU aplot_menu[i_return] =
	{
	"plot",      1,i_plot,	  "Plot data in new frame",
	"errors",    1,i_errors,  "Plot error bars",
	"hardcopy",  2,i_hardcopy,"Send postscript to lpr",
	"overlay",   1,i_overlay, "Overlay curve in previous frame",
	"replot",    3,i_replot,  "Replot the entire graph",
	"cursor",    4,i_cursor,  "Switch on cursor",
	"ncursor",   4,i_ncursor, "Read cursor positions",
	"drawing",   1,i_drawing, "Goto drawing menu",
	"multiplot", 3,i_multiplot,   "Set to multiplot mode yes/no",
	"curvestyle",1,i_curvestyle,  "Set curve style",
	"linestyle", 3,i_linestyle,   "Set linestyle",
	"symbol",    1,i_symbol,  "Set symbol style",
	"symsize",   4,i_symsize, "Set size of symbol",
	"color",     2,i_color,   "Set colors used",
	"layout",    2,i_layout , "Define layout of plot",
	"text",      2,i_text,    "Goto text manipulation menu",
	"default",   3,i_default, "Give all parameters default values",
	"x",         1,i_x,       "Set x-axis attributes",
	"y",         1,i_y,       "Set y-axis attributes",
#ifdef DO3D
	"z",         1,i_z,       "Set z-axis attributes (3D only)",
#endif
	"loadfonts", 2,i_loadfonts,   "Load up to four fonts",
	"font",      1,i_font,    "Select font",
	"title",     1,i_title,   "Title of plot",
	"macro",     1,i_macro,   "Run macro file",
	"list",      1,i_list,    "List current settings",
	"tmode",     2,i_tmode,   "Switch to text mode",
	"pushconfig",4,i_pushconfig,  "Temporarily save plot parameters",
	"popconfig", 3,i_popconfig,   "Restore saved parameters",
	"init",      1,i_init,    "Initialize plot parameters",
	"save",      2,i_save,    "Save plot parameters",
	"close",     2,i_close,   "Close plot window",
	"help",      1,i_help,    "Display menu",
	"break",     2,i_break,   "Break out of subroutine (avoids redraw)",
	"return",    1,i_return,  "Return to main menu",
	};

    float x_log[MAXDATAPOINTS];
    float y_log[MAXDATAPOINTS];
    float e_log[MAXDATAPOINTS];

    int     stop = FALSE, found = FALSE;
    char    token[100],title[80],title2[80],title3[80],title4[80];
    int     i, j;
    float   lower,upper;
    static int  first = TRUE;
    float	cursorx,cursory;
    int		*ncursor;
    float	zsubtick = 1.;
    char	zformat[20];
    char        cursorch;
    float tr[6];
    float logmin=1e-12;

    float xmin_pos;
    float ymin_pos;
    float p_xmax,p_xmin,p_ymax,p_ymin;

    if (first)
      {
#if defined(__CYGWIN__)
	if(!(X_DEVICE=cpgopen("/GW"))){
#elif defined(__unix) || defined(__APPLE__)
	if(!(X_DEVICE=cpgopen("/XWINDOW"))){
#endif
	  errtype("X Graphics initialisation failed!\n");
	}
#if defined(__unix) || defined(__APPLE__)
	if(!(PS_DEVICE=cpgopen("/CPS"))){
	  errtype("PS Plotting initialisation failed!\n");
	}
#endif
#ifdef PGMETA
	if(!(META_DEVICE=cpgopen("/PGMF"))){
	  errtype("Meta-file plotting initialisation failed!\n");
	}
#endif
	cpgslct(X_DEVICE);
	first = FALSE;
	cpgask(0);

      }
    

    xptr=x;
    yptr=y;
    
    if (PLOTMODE == XYE && npts > 1){
      for (i=0;i<npts;i++){
	if(x[i]>0){
	  x_log[i]=log10(x[i]);
	}
	else {
	  x_log[i]=logmin;
	}
	if(y[i]>0){
	  y_log[i]=log10(y[i]);
	  e_log[i]=log10(y[i]+e[i])-log10(y[i]);
	}
	else{y_log[i]=e_log[i]=logmin;}
      }
    }

    while (!stop)
	{
	if (!get_token(token,"PLOT>")) break;
	switch (cmnd_match(token,aplot_menu,i_return))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case i_plot:
		PLOTNR++; /* keep track of number of plots on this page */
		H_HEIGHT=H_Y;
		NPLOTS=1;
		/* set up graph axes */
		if(PLOTMODE == XYE){


		  if (!YLOGSC && !XLOGSC){ /* both linear */
		    AXIS=1;
		    
		    xptr=x;
		    yptr=y;

		    /* find max and min values */
		    xmax=xmin=x[0];
		    ymax=ymin=y[0];
		    for (i=0;i<npts;i++){
		      if(x[i]>xmax)xmax    =x[i];
		      if(x[i]<xmin)xmin    =x[i];
		      if(y[i]>ymax)ymax    =y[i];
		      if(y[i]<ymin)ymin    =y[i];
		    }
		    if (AUTOX){
		      cpgrnge(xmin,xmax,&XLOWERSC,&XUPPERSC);
		      /* XUPPERSC =( (xmax+xmin) + 1.1*(xmax-xmin))/2.0;
			 XLOWERSC =( (xmax+xmin) - 1.1*(xmax-xmin))/2.0; */
		    }
		    if(AUTOY){
		      cpgrnge(ymin,ymax,&YLOWERSC,&YUPPERSC);
		      /* YUPPERSC=( (ymax+ymin) + 1.1*(ymax-ymin))/2.0;
			 YLOWERSC=( (ymax+ymin) - 1.1*(ymax-ymin))/2.0; */
		    }
		  }
		  else if(YLOGSC && !XLOGSC){
		    AXIS=20;
		    
		    xptr=x;
		    yptr=y_log;

		    for (i=0;i<npts;i++){
		      if (y[i]>logmin){
			y_log[i]=log10(y[i]);
			e_log[i]=log10(y[i]+e[i])-log10(y[i]);
		      }
		      else {
			y_log[i]=-1000;
			e_log[i]=-1000;
		      }
		    }
		   
		    /* find max and min values */
		    xmax=xmin=x[0];
		    ymax=ymin=y_log[0];
		    for (i=0;i<npts;i++){
		      if(x[i]>xmax)xmax    =x[i];
		      if(x[i]<xmin)xmin    =x[i];

		      if(y_log[i]>ymax)ymax    =y_log[i];
		      if(y_log[i]<ymin && y_log[i]>-999) ymin    =y_log[i];
		    }

		    if (AUTOX){
		      cpgrnge(xmin,xmax,&XLOWERSC,&XUPPERSC);
		      /* XUPPERSC =( (xmax+xmin) + 1.1*(xmax-xmin))/2.0;
			 XLOWERSC =( (xmax+xmin) - 1.1*(xmax-xmin))/2.0; */
		    }
		    if(AUTOY){
		      cpgrnge(ymin,ymax,&YLOWERSC,&YUPPERSC);
		      /* YUPPERSC=( (ymax+ymin) + 1.1*(ymax-ymin))/2.0;
			 YLOWERSC=( (ymax+ymin) - 1.1*(ymax-ymin))/2.0; */ 
		    }

		  }
		  else if(!YLOGSC && XLOGSC){
		    AXIS=30;
		    
		    xptr=x_log;
		    yptr=y;

		    for (i=0;i<npts;i++){
		      if (x[i]>logmin){
			x_log[i]=log10(x[i]);
		      }
		      else {
			x_log[i]=-1000;
		      }
		    }
		    /* find max and min values */
		    xmin=xmax=x_log[0];
		    ymin=ymax=y[0];
		    for (i=0;i<npts;i++){
		      if(x_log[i]>xmax)xmax=x_log[i];
		      if(x_log[i]<xmin && x_log[i]>-999 )xmin=x_log[i];

		      if(y[i]>ymax)ymax=y[i];
		      if(y[i]<ymin)ymin=y[i];
		    }

		    if (AUTOX){
		      cpgrnge(xmin,xmax,&XLOWERSC,&XUPPERSC);
		      /* XUPPERSC =( (xmax+xmin) + 1.1*(xmax-xmin))/2.0;
			 XLOWERSC =( (xmax+xmin) - 1.1*(xmax-xmin))/2.0; */
		    }
		    if(AUTOY){
		      cpgrnge(ymin,ymax,&YLOWERSC,&YUPPERSC);
		      /* YUPPERSC=( (ymax+ymin) + 1.1*(ymax-ymin))/2.0;
			 YLOWERSC=( (ymax+ymin) - 1.1*(ymax-ymin))/2.0; */ 
		    }
		  }
		  else{
		    errtype("x and y cannot both be \
log at the same time (for now).\n");
		    break;
		  }

		  if(XLOWERSC == XUPPERSC){
		    errtype("invalid x limits: XLOWER = XUPPER.");
		    break;
		  }
		  if(YLOWERSC == YUPPERSC){
		    errtype("invalid y limits: YLOWER = YUPPER.");
		    break;
		  }

		  cpgslct(X_DEVICE);
		  /* begin buffering for X_DEVICE */
		  cpgbbuf();
		  /* define background (black) color*/

#ifdef PGMETA
		  printf("PLOTNR=%d\n",PLOTNR);
		  /* Start new page on META_DEVICE when necessary */
		  if(PLOTNR==(PLOT_ROWS*PLOT_COLUMNS+1) || (PLOTNR==1)){
		    PLOTNR=1;
		    cpgslct(META_DEVICE);
		    cpgclos();
		    printf("META_DEVICE closed\n");

		    system("rm pgplot.pgmf");
		    META_DEVICE=cpgopen("/PGMF");
		    cpgslct(META_DEVICE);
		    cpgsubp(PLOT_COLUMNS,PLOT_ROWS);
		  }
#endif

		  alldevs( cpgscf(DEFFONT) );
		  
		  alldevs( cpgsci(COLAXES) );

		  alldevs( cpgsch(AXNUMSIZE) );

		  alldevs( my_cpgenv(XLOWERSC, XUPPERSC, 
				     YLOWERSC, YUPPERSC, 0, AXIS));

		  alldevs( cpgsci(COLTEXT) );

		  alldevs( cpgsch(AXNAMSIZE) );

		  alldevs( cpglab(XTITLE, YTITLE, "") );
		  
		  alldevs( cpgsch(TITLESIZE) );

		  alldevs( cpgmtxt("T",1,0.5,0.5,PTITLE) );
		  
		  alldevs( cpgsci(COLCURVE) );

		  alldevs( cpgsch(SYMSIZE) );


		  alldevs( 
			  if(CURVESTYLE==0){ /* line */
		            cpgsls(LINESTYLE);
			    cpgline(npts, xptr, yptr);
		            cpgsls(1);
			  }
			  );

		  alldevs(
			  if(CURVESTYLE<0){
			    cpgpt(npts, xptr, yptr, SYMSTYLE);
			  }
			  );

		  alldevs(
			  if(CURVESTYLE>0){
			    cpgpt(npts, xptr, yptr, SYMSTYLE);
		            cpgsls(LINESTYLE);
			    cpgline(npts, xptr, yptr);
		            cpgsls(1);
			  } 
			  );
		  
		  /* end x-buffering */
		  cpgslct(X_DEVICE);
		  cpgebuf();
		}
#ifdef DO3D
		if(PLOTMODE == D3){
		  if (AUTOZ){
		    zmin=zmax=zmat[0];
		    for (i=0;i<nxc*nyc;i++){
	      if(zmin>zmat[i])zmin=zmat[i];
	      if(zmax<zmat[i])zmax=zmat[i];
		    }
		    ZLOWERSC=zmin;
		    ZUPPERSC=zmax;
		  }
		  else{
		    zmin=ZLOWERSC;
		    zmax=ZUPPERSC;
		  }
		  tr[0]= xlow-0.5/nxc;
		  tr[1]= (xup-xlow)/nxc;
		  tr[2]= 0;
		  tr[3]= ylow-0.5/nyc;
		  tr[4]= 0;
		  tr[5]= (yup-ylow)/nyc;

#ifdef PGMETA
		  printf("PLOTNR=%d\n",PLOTNR);
		  /* Start new page on META_DEVICE when necessary */
		  if(PLOTNR==(PLOT_ROWS*PLOT_COLUMNS+1) || (PLOTNR==1)){
		    PLOTNR=1;
		    cpgslct(META_DEVICE);
		    cpgclos();
		    printf("META_DEVICE closed\n");

		    system("rm pgplot.pgmf");
		    META_DEVICE=cpgopen("/PGMF");
		    cpgslct(META_DEVICE);
		    cpgsubp(PLOT_COLUMNS,PLOT_ROWS);
		  }
#endif

		  alldevs(my_cpgenv(xlow,xup,ylow,yup,0,1););

		 alldevs(
			 cpgscf(DEFFONT);
			 /*		    cpgscr(0, 0.0, 0.3, 0.2);  */
			 cpgsci(COLAXES); 
			 cpgsci(COLTEXT);
			 cpglab(XTITLE, YTITLE, PTITLE);
			 if(PLOT_DEV == X_DEVICE) cpggray(zmat,nxc,nyc,1,nxc,1,nyc,zmax,zmin,tr);
			 else                     cpggray(zmat,nxc,nyc,1,nxc,1,nyc,zmax,zmin,tr);
			 );
		}
#endif
		/* 		if(PLOTMODE == CONT){ */
		/* 		  zmin=zmax=zmat[0]; */
		/* 		  for (i=0;i<nxc*nyc;i++){ */
		/* 		    if(zmin>z[i])zmin=z[i]; */
		/* 		    if(zmax<z[i])zmax=z[i]; */
		/* 		  } */
		/* 		  tr[0]= XLOWERSC-1.0/nxc; */
		/* 		  tr[1]= (XUPPERSC-XLOWERSC)/nxc; */
		/* 		  tr[2]= 0; */
		/* 		  tr[3]= YLOWERSC-1.0/nyc; */
		/* 		  tr[4]= 0; */
		/* 		  tr[5]= (YUPPERSC-YLOWERSC)/nyc; */
		/* 		  cpgbbuf(); */
		/* 		  for (i=0;i<NLEV;i++){ */
		/* 		    alev=(zmin+i*(zmax-zmin))/NLEV; */
		/* 		    printf("%f ",alev); */
		/* 		    cpgcont(z[0],25,25,1,25,1,25,&alev,1,tr); */
		/* 		  } */
		/* 		  cpgebuf(); */
		/* 		  cpggray(zmat,nxc,nyc,1,nxc,1,nyc,zmin,zmax,tr); */
		/* 		} */
		break;
	    case i_errors:
	      if(XLOGSC){
		xptr=x_log;
	      }
	      else{
		xptr=x;
	      }
	      if(YLOGSC){
		yptr=y_log;
		eptr=e_log;
	      }
	      else{
		yptr=y;
		eptr=e;
	      }
		alldevs(
			cpgerrb(6,npts,xptr,yptr,eptr,0);
			);
		break;
	      case i_hardcopy:
#ifdef PGMETA	
		/* put an 'E' on the end of the meta-file */
		/* This does not always work because pgplot.pgmf is not
		 always flushed before the cp */ 
		system("cp pgplot.pgmf plot.pgmf");
		system("echo \"E\" >> plot.pgmf");
		HC_DEVICE=cpgopen("/XS");
		
		cpgrdmf("plot.pgmf","D",1,HC_DEVICE);

		cpgslct(HC_DEVICE);
		cpgclos();

		break;
#endif
            case i_overlay:
	      if(XLOGSC){
		xptr=x_log;
	      }
	      else{
		xptr=x;
	      }
	      if(YLOGSC){
		yptr=y_log;
	      }
	      else{
		yptr=y;
	      }

		alldevs(
			cpgsci(COLCURVE);
			cpgsch(SYMSIZE);
			if(CURVESTYLE==0){ /* line */
			  cpgsls(LINESTYLE);
			  cpgline(npts, xptr, yptr);
			  cpgsls(1);
			}
			if(CURVESTYLE<0){
			  cpgpt(npts, xptr, yptr, SYMSTYLE);
			}
			if(CURVESTYLE>0){
			  cpgpt(npts, xptr, yptr, SYMSTYLE);
			  cpgsls(LINESTYLE);
			  cpgline(npts, xptr, yptr);
			  cpgsls(1);
			}
			);
	      break;
	    case i_replot:
	      break;
	    case i_cursor:
	      cpgslct(X_DEVICE);
	      sprintf(PSTRING,"X or right mouse button to quit\n");
	      type_line(PSTRING);
	      do{
		cpgcurs(&cursorx,&cursory,&cursorch);
		sprintf(PSTRING,
			"Cursor coordinates, (x,y): (%8.4f \t %8.4f)\n"
			,cursorx,cursory);
		type_line(PSTRING);
	      }while(cursorch!='X'); 
	      break;
	    case i_ncursor:
		sprintf(PSTRING,
			"Number of points [%1d]: ",
			PLOT_CURSORNPOINTS);
		PLOT_CURSORNPOINTS = get_int(PLOT_CURSORNPOINTS,PSTRING);
		cpgslct(X_DEVICE);
		for (i = 0; i < PLOT_CURSORNPOINTS; i++)
		    {
		    cpgcurs(&cursorx,&cursory,&cursorch);
		    sprintf(PSTRING,
			    "Cursor coordinates, (x,y): (%8.4f \t %8.4f)\n"
			    ,cursorx,cursory);
		    type_line(PSTRING);
		    if (i == 0)
			{
			PLOT_CURSORPOINTS[0][0] = cursorx;
			PLOT_CURSORPOINTS[0][1] = cursory;
			}
		    else
			{
			j = i-1;
			found = FALSE;
			while (!found)
			    {
			    if (PLOT_CURSORPOINTS[j][0] < cursorx)
				{
				found = TRUE;
				PLOT_CURSORPOINTS[j+1][0] = cursorx;
				PLOT_CURSORPOINTS[j+1][1] = cursory;
				}
			    else
				{
				PLOT_CURSORPOINTS[j+1][0] = PLOT_CURSORPOINTS[j][0];
				PLOT_CURSORPOINTS[j+1][1] = PLOT_CURSORPOINTS[j][1];
				j--;
				}
			    }
			}
		    }
		break;
	    case i_drawing:
		drawing();
		break;
	      case i_multiplot:
		if (yesno(FALSE,"Multiple plot panels? [no]: "))
		  {
		    PLOT_ROWS = get_int(1,"Number of rows? [1]: ");
		    PLOT_COLUMNS = get_int(1,"Number of columns? [1]: ");
		    PLOTNR=0;
		  }
		else {
		  PLOT_ROWS=PLOT_COLUMNS=1;
		  PLOTNR=0;
		}
		alldevs(
			cpgsubp(PLOT_COLUMNS,PLOT_ROWS);
			);
	      break;
	    case i_curvestyle:
	      sprintf(PSTRING,
		      "Curve style (<0,0,>0) = (symbol,line,both) [%1d]: ",
		      CURVESTYLE);
	      CURVESTYLE = get_int(CURVESTYLE,PSTRING);
	      break;
	    case i_linestyle:
	      sprintf(PSTRING,"Line style (1-5) [%1d]: ",LINESTYLE);
	      LINESTYLE = get_int(LINESTYLE,PSTRING);
	      if ((LINESTYLE < 1) || (LINESTYLE > 5)) LINESTYLE = 1;
	      break;
	    case i_symbol:
	      sprintf(PSTRING,"Symbol style (1-128) [%1d]: ",SYMSTYLE);
	      SYMSTYLE = get_int(SYMSTYLE,PSTRING);
	      if ((SYMSTYLE < 1) || (SYMSTYLE > 128)) SYMSTYLE = 1;
	      break;
	    case i_symsize:
	      sprintf(PSTRING,"Symbol size [%f] :",SYMSIZE);
	      SYMSIZE=get_real(SYMSIZE,PSTRING);
	      break;
	    case i_color:
	      set_color();
	      break;
	    case i_layout:
	      set_layout();
	      break;
	    case i_text:
	      set_text();
	      break;
	    case i_default:
	      set_default();
	      break;
	    case i_x:
	      set_axis(X);
	      break;
	    case i_y:
	      set_axis(Y);
	      break;
#ifdef DO3D
	    case i_z:
	      set_axis(Z);
	      break;
#endif
	    case i_loadfonts:
	      break;
	    case i_font:
	      do{
		DEFFONT = get_int(1,"Use pgplot font number (1-4)[1]:");
	      } while (!(DEFFONT<5 && DEFFONT>0));
	      break;
	    case i_title:
	      get_string(PTITLE,"Title of plot: ");
	      break;
	    case i_macro:
	      run_macro();
	      break;
	    case i_list:
	      list_par();
	      break;
	    case i_tmode:
	      break;
	    case i_pushconfig:
		pushconfig();
		break;
	    case i_popconfig:
		popconfig();
		break;
	    case i_init:
	      sprintf(PSTRING,"%s return",PLOTINIT);
	      put_command(PSTRING);
	      if (!run_macro())
		{
		  errtype("Parameters set to default values");
		  set_default();
		  return;
		}
	      pushconfig();
	      break;
	    case i_save:
	      write_plotmac();
	      return;
	    case i_close:
	      cpgend();
	      return;
	    case i_help:
	      list_menus("PLOT MENU",aplot_menu,i_return,25);
	      break;
	    case i_break:
	      return;
	    case i_return:
	      stop = TRUE;
	      break;
	    }
	}
    
    
	
    }

/***************************************************************************/
void    drawing(void)
/***************************************************************************/

    /*
    Draw various items in frame.
    */

    {
    /* define draw_menu */

#define draw_length 7      /* number of commands in draw menu */

    static struct   MENU draw_menu[draw_length] =
	{
	"circle",    1,   1, "Draw a circle segment",
	"radial",    2,   2, "Draw radial line in circle",
	"line",      3,   3, "Draw line segment",
        "fill",      1,   4, "Set fill pattern",
	"point",     1,   5, "Add a point with current symbol",
	"help",      1,  10, "Display menu",
	"return",    1,  11, "Return to main menu"
	};

    int stop = FALSE;
    static int fill = 0;
    char        token[50];
    float       xpos,ypos,xpos2,ypos2,radius,th1,th2;
#ifdef DO3D
    float	zpos,zpos2;
#endif

    while (!stop)
	{
	if (!get_token(token,"PLOT.DRAW>")) break;
	switch (cmnd_match(token,draw_menu,draw_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	      case 1:
		if ((PLOTMODE != XYE) && (PLOTMODE != CONT))
		  {
		    errtype("Not implemented in this plotting mode");
		    break;
		  }
		xpos = get_real(0.,"X-position of circle center [0]: ");
		ypos = get_real(0.,"Y-position of circle center [0]: ");
		radius = get_real(1.,"Radius of circle [1]: ");
		th1 = get_real(0.,"Start of arc [0]: ");
		th2 = get_real(2*PI,"End of arc [2*PI]: ");
		alldevs(
			cpgsfs(1);
			if (fill==0){
			  cpgsfs(2);
			}
			ucircle(xpos,ypos,radius,th1,th2);
			);
		return;
	      case 2:
		if ((PLOTMODE != XYE) && (PLOTMODE != CONT))
		    {
		    errtype("Not implemented in this plotting mode");
		    break;
		    }
		xpos = get_real(0.,"X-position of circle center [0]: ");
		ypos = get_real(0.,"Y-position of circle center [0]: ");
		radius = get_real(1.,"Radius of circle [1]: ");
		th1 = get_real(0.,"Angle of radial line [0]: ");

		uradlin(xpos,ypos,0,radius,th1);
		return;
	    case 3:
	      get_xy_xy("Start X-position of line or \"CURsor\"[0]: ",
			"Start Y-position of line [0]: ",
			"End X-position of line [0]: ",
			"End Y-position of line [0]: ",
			0,0,0,0,&xpos,&ypos,&xpos2,&ypos2);
	      
	      /* xpos = get_real(0.,"Start X-position of line [0]: ");
		 ypos = get_real(0.,"Start Y-position of line [0]: ");
		 xpos2 = get_real(1.,"End X-position of line [1]: ");
		 ypos2 = get_real(1.,"End Y-position of line [1]: ");
		 */
#ifdef DO3D
		if ((PLOTMODE == D3) || (PLOTMODE == D3CURVE))
		    {
		    zpos = get_real(0.,"Start Z-position of line [0]: ");
		    zpos2 = get_real(1.,"End Z-position of line [1]: ");
		    }
#endif
		alldevs(
		  cpgsci(COLCURVE);
		  cpgsls(LINESTYLE); 
			);
		if ((PLOTMODE == XYE) || (PLOTMODE == CONT))
		    uline(xpos,ypos,xpos2,ypos2,3);
#ifdef DO3D
		if ((PLOTMODE == D3) || (PLOTMODE == D3CURVE))
		    d3line(xpos,ypos,zpos,xpos2,ypos2,zpos2);
#endif
		return;
            case 4:
                sprintf(PSTRING, "Fill pattern (0=no fill) [%d]: ", fill);
                fill=get_int(fill, PSTRING);
                break;
	    case 5:
	      sprintf(PSTRING, "x coordinate of point: ");
	      xpos=get_real(0,PSTRING);
	      sprintf(PSTRING, "y coordinate of point: ");
	      ypos=get_real(0,PSTRING);
		alldevs(
			cpgsci(COLCURVE);
			cpgsch(SYMSIZE);
			cpgpt(1, &xpos, &ypos, SYMSTYLE);
			);

	      break;
	    case 10:
		list_menus("DRAW MENU",
		    draw_menu,draw_length,25);
		break;
	    case 11:
		stop = TRUE;
		break;
	    }
	}
    }


/***************************************************************************/
char *	get_plot_init_name(void)
/***************************************************************************/

    /*
    Get name of initialization file
    This will try to read the environment variable PLOTINIT
    If this fails, it will result to the default
    */


    {
    char * envname;


    if ((envname = getenv("PLOTINIT")) == NULL)
        {
        return (DEF_ININAME);
        }
    else
        {
        return (envname);
	}
    }


/***************************************************************************/
void    list_par(void)
/***************************************************************************/

    /*
    List current parameter values of plot on screen.
    */
{
/* Axis-defining parameters */

    type_line("x-axis: ");
    if (AUTOX) type_line("autoscaling ");
    else type_line("manual scaling ");
    if (XLOGSC) type_line("logarithmic\n");
    else type_line("linear\n");
    sprintf(PSTRING,
	"        lower: %6.3f upper %6.3f tick %6.3f subtick %6.3f\n",
	XLOWERSC,XUPPERSC,XTICK,XSUBTICK);
    type_line(PSTRING);
    sprintf(PSTRING,"        title: %s\n",XTITLE);
    type_line(PSTRING);
    type_line("y-axis: ");
    if (AUTOY) type_line("autoscaling ");
    else type_line("manual scaling ");
    if (YLOGSC) type_line("logarithmic\n");
    else type_line("linear\n");
    sprintf(PSTRING,
	"        lower: %6.3f upper %6.3f tick %6.3f subtick %6.3f\n",
	YLOWERSC,YUPPERSC,YTICK,YSUBTICK);
    type_line(PSTRING);
    sprintf(PSTRING,"        title: %s\n",YTITLE);
    type_line(PSTRING);
#ifdef DO3D
    type_line("z-axis: ");
    if (AUTOZ) type_line("autoscaling\n");
    else type_line("manual scaling\n");
    sprintf(PSTRING,
	"        lower: %6.3f upper %6.3f tick %6.3f \n",
	ZLOWERSC,ZUPPERSC,ZTICK);
    type_line(PSTRING);
    sprintf(PSTRING,"        title: %s\n",ZTITLE);
    type_line(PSTRING);
#endif

    /* curve defining parameters */

    sprintf(PSTRING,"Curve style   : %1d\n",CURVESTYLE);
    type_line(PSTRING);
    sprintf(PSTRING,"Line style    : %1d\n",LINESTYLE);
    type_line(PSTRING);
    sprintf(PSTRING,"Symbol style  : %1d\n",SYMSTYLE);
    type_line(PSTRING);
  }



/***************************************************************************/
void    plotcon(float zmat[], float xc[], int nxc, float yc[], int nyc,
	    float min, float step, float max, int lnstyle[], int labint)
/***************************************************************************/

    /*
    Make contour plot
	- zmat[]    = nxc*nyc matrix written as array zmat[nxc*y+x]
	- xc[]      = array with x values
	- nxc       = number of x values (must be odd)
	- yc[]      = array with y values
	- nyc       = number of y values (must be odd)
	- min       = minimum contour level
	- step      = interval between contour levels
	- max       = maximum contour level
	- lnstyle[] = array with code for contour line style
	- labint    = flag to enable/disable contour labels

    The actual plotting is done by pgplot
    */

    {
      float tr[6] = {0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
      float alev;
      float xsize, ysize, fmin, fmax;
      int i,j,k, lw, ci, ls;

      ysize=1.0;
/*      xsize=0.6315*(xc[nxc-1]-xc[0])/(yc[nyc-1]-yc[0]); */
      xsize=(xc[nxc-1]-xc[0])/(yc[nyc-1]-yc[0]);
      if(xsize>1.0){
	ysize=ysize/xsize;
	xsize=1.0;
      }

      tr[1]= (xc[nxc-1]-xc[0])/((float)nxc-1);
      tr[0]= xc[0]-tr[1];
      tr[5]= (yc[nyc-1]-yc[0])/((float)nyc-1);
      tr[3]= yc[0]-tr[5];
      tr[2]= 0.0;
      tr[4]= 0.0;

      alldevs(
	      /* Clear the screen. Set up window and viewport. */
	      
	      cpgpage();
	      cpgsvp(0.05, 0.95, 0.05, 0.95);
	      cpgwnad((float)xc[0], (float)xc[nxc-1], 
		      (float)yc[0], (float)yc[nyc-1]);
	      cpgsci(COLAXES);
	      cpgbox("bcts", 0.0, 0, "bcts", 0.0, 0);
	      cpgsci(COLTEXT);
	      cpgmtxt("t", 1.0, 0.0, 0.0, PTITLE);

 	      /* CJW March 2001
 		 cpggray puts a graded background on the plot ideally 
 		 this should be optional (eg for bw printing) */
              cpggray(zmat,nxc,nyc,1,nxc,1,nyc,max,min,tr);
 
	      /* Draw the map. cpgcont is called once for each contour, using
		 different line attributes to distinguish contour levels. */
	      
	      cpgbbuf();
	      cpgsci(COLCURVE);
	      for (alev=min; alev<=max; alev+=step) {
		ls = (alev < 0)   ? 2 : 1;
		cpgsls(ls);
		cpgcont(zmat, nxc, nyc, 1, nxc, 1, nyc, &alev, -1, tr);
	      }
	      cpgebuf();
	      );
      
    }

/***************************************************************************/
void    plotxye(float x[], float y[], float e[], int npts)
/***************************************************************************/

    /*
    Plot spectrum of 'npts' points where
	x[] =   array of x values,
	y[] =   array of y values,
	e[] =   array of errors in y values.

    The actual plotting is done in the general subroutine aplot
    */

    {

    float       *zmat,*xc,*yc,min,step,max;
    int         nxc,nyc,*lnstyle,labint;
    float	xlow,xup,ylow,yup;

    /* Set the appropriate flag and call aplot */

    PLOTMODE = XYE;
    aplot(x,y,e,npts,zmat,xc,nxc,yc,nyc,min,step,max,lnstyle,labint,
	xlow,xup,ylow,yup);

    }

#ifdef DO3D
/***************************************************************************/
void    plot3d(float zmat[], float xlow, float xup, int nx, float ylow,
	    float yup, int ny)
/***************************************************************************/

    /*
    Make 3D surface plot
	- zmat[]    = nx*ny matrix written as array zmat[nx*y+x]
	- xlow 	    = lower x value
	- xup	    = upper x value
	- nx	    = x dimension of zmat
	- ylow	    = lower y value
	- yup       = upper y value
	- ny        = y dimension of zmat

    The actual plotting is done in the general subroutine aplot
    */

    {

    float       *x,*y,*e;
    int         npts;
    float	*xc,*yc,min,step,max;
    int		*lnstyle,labint;


    /* Set the appropriate flag and call aplot */

    PLOTMODE = D3;
    XLOGSC = YLOGSC = FALSE;
    aplot(x,y,e,npts,zmat,xc,nx,yc,ny,min,step,max,lnstyle,labint,
	xlow,xup,ylow,yup);

   }
#endif

#ifdef DO3D
/***************************************************************************/
void    plot3dcurve(float x[], float y[], float z[], int npts)
/***************************************************************************/

    /*
    Plot spectrum of 'npts' points where
	x[] =   array of x values,
	y[] =   array of y values,
	z[] =   array of z values.

    The actual plotting is done in the general subroutine aplot
    */

    {

    float       *zmat,*xc,*yc,min,step,max;
    int         nxc,nyc,*lnstyle,labint;
    float	xlow,xup,ylow,yup;

    /* Set the appropriate flag and call aplot */

    PLOTMODE = D3CURVE;
    XLOGSC = YLOGSC = FALSE;
    aplot(x,y,z,npts,zmat,xc,nxc,yc,nyc,min,step,max,lnstyle,labint,
	xlow,xup,ylow,yup);

    }
#endif

/***************************************************************************/
void    set_axis(int axis)
/***************************************************************************/

    /*
    Set attributes of:
	x axis when axis == X,
	y axis when axis == Y.
	z axis when axis == Z.
    */

    {

    /* define set_axis_menu */

    enum i_set_axis {
	i_zero,
	i_autoscale,
	i_manual,
	i_linear,
	i_log,
	i_lower,
	i_upper,
	i_tick,
	i_subtick,
	i_labels,
	i_title,
#ifdef DO3D
	i_skip,
#endif
	i_help,
	i_return
	};

    static struct   MENU set_axis_menu[i_return] =
	{
	"autoscale", 1,i_autoscale, "Autoscaling of axis",
	"manual",    1,i_manual,  "Manual scaling of axis",
	"linear",    3,i_linear,  "Linear axis",
	"logarith",  2,i_log,     "Logarithmic axis",
	"lowerscale",3,i_lower,   "Lower axis limit for manual scaling",
	"upperscale",1,i_upper,   "Upper axis limit for manual scaling",
	"tick",      3,i_tick,    "Tick spacing of axis for manual sc.",
	"subtick",   1,i_subtick, "Subtick spacing of axis for manual sc.",
	"labels",    3,i_labels,  "Set axis labels",
	"title",     1,i_title,   "Set axis title",
#ifdef DO3D
	"skip",      2,i_skip,    "Nr. of grid lines to be skipped (3D)",
#endif
	"help",      1,i_help,    "Display menu",
	"return",    1,i_return,  "Return to main menu"
	};

    int stop = FALSE,i;
    char        token[50];

    while (!stop)
	{
	if (!get_token(token,"PLOT.AXIS>")) break;
	switch (cmnd_match(token,set_axis_menu,i_return))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case i_autoscale:
		if (axis == X) AUTOX = TRUE;
		if (axis == Y) AUTOY = TRUE;
#ifdef DO3D
		if (axis == Z) AUTOZ = TRUE;
#endif
		return;
	    case i_manual:
		if (axis == X) AUTOX = FALSE;
		if (axis == Y) AUTOY = FALSE;
#ifdef DO3D
		if (axis == Z) AUTOZ = FALSE;
#endif
		return;
	    case i_linear:
		if (axis == X) XLOGSC = FALSE;
		if (axis == Y) YLOGSC = FALSE;
#ifdef DO3D
		if (axis == Z) errtype("Not relevant");
#endif
		return;
	    case i_log:
		if (axis == X) XLOGSC = TRUE;
		if (axis == Y) YLOGSC = TRUE;
#ifdef DO3D
		if (axis == Z) errtype("Not relevant");
#endif
		return;
	    case i_lower:
		if (axis == X)
		    {
		    sprintf(PSTRING,"Lower value of x-scale [%7.3f]: ",
			XLOWERSC);
		    XLOWERSC = get_real(XLOWERSC,PSTRING);
		    }
		if (axis == Y)
		    {
		    sprintf(PSTRING,"Lower value of y-scale [%7.3f]: ",
			YLOWERSC);
		    YLOWERSC = get_real(YLOWERSC,PSTRING);
		    }
#ifdef DO3D
		if (axis == Z)
		    {
		    sprintf(PSTRING,"Lower value of z-scale [%7.3f]: ",
			ZLOWERSC);
		    ZLOWERSC = get_real(ZLOWERSC,PSTRING);
		    }
#endif
		return;
	    case i_upper:
		if (axis == X)
		    {
		    sprintf(PSTRING,"Upper value of x-scale [%7.3f]: ",
			XUPPERSC);
		    XUPPERSC = get_real(XUPPERSC,PSTRING);
		    }
		if (axis == Y)
		    {
		    sprintf(PSTRING,"Upper value of y-scale [%7.3f]: ",
			YUPPERSC);
		    YUPPERSC = get_real(YUPPERSC,PSTRING);
		    }
#ifdef DO3D
		if (axis == Z)
		    {
		    sprintf(PSTRING,"Upper value of z-scale [%7.3f]: ",
			ZUPPERSC);
		    ZUPPERSC = get_real(ZUPPERSC,PSTRING);
		    }
#endif
		return;
	    case i_tick:
		if (axis == X)
		    {
		    sprintf(PSTRING,
		    "Tick spacing of x-scale (type 0 for autoset) [%7.3f]: ",
			XTICK);
		    XTICK = get_real(XTICK,PSTRING);
		    }
		if (axis == Y)
		    {
		    sprintf(PSTRING,
		    "Tick spacing of y-scale (type 0 for autoset) [%7.3f]: ",
			YTICK);
		    YTICK = get_real(YTICK,PSTRING);
		    }
#ifdef DO3D
		if (axis == Z)
		    {
		    sprintf(PSTRING,
		    "Tick spacing of z-scale (type 0 for autoset) [%7.3f]: ",
			ZTICK);
		    ZTICK = get_real(ZTICK,PSTRING);
		    }
#endif
		return;
	    case i_subtick:
		if (axis == X)
		    {
		    sprintf(PSTRING,
		    "Subtick spacing of x-scale (type 0 for autoset) [%7.3f]: ",
			XSUBTICK);
		    XSUBTICK = get_real(XSUBTICK,PSTRING);
		    }
		if (axis == Y)
		    {
		    sprintf(PSTRING,
		    "Subtick spacing of y-scale (type 0 for autoset) [%7.3f]: ",
			YSUBTICK);
		    YSUBTICK = get_real(YSUBTICK,PSTRING);
		    }
#ifdef DO3D
		if (axis == Z) errtype("Not relevant");
#endif
		return;
	    case i_labels:
		if (axis == X)
		    {
		    if (yesno(FALSE,"Manual labels at x-axis ticks? [no]: "))
			{
			XLABEL = get_int(1,"Number of labels [1]: ");
			if (XLABEL < 0) XLABEL = 0;
			for (i = 0; i < XLABEL; i++)
			    {
			    get_token(XLABSTRING[i],"X-axis label: ");
			    XLABPOINTER[i] = XLABSTRING[i];
			    }
			}
		    }
		if (axis == Y)
		    {
		    if (yesno(FALSE,"Manual labels at y-axis ticks? [no]: "))
			{
			YLABEL = get_int(1,"Number of labels [1]: ");
			if (YLABEL < 0) YLABEL = 0;
			for (i = 0; i < YLABEL; i++)
			    {
			    get_token(YLABSTRING[i],"Y-axis label: ");
			    YLABPOINTER[i] = YLABSTRING[i];
			    }
			}
		    }
#ifdef DO3D
		if (axis == Z) errtype("Not relevant");
#endif
		return;
	    case i_title:
		if (axis == X)
		    get_string(XTITLE,"Title of x-axis: ");
		if (axis == Y)
		    get_string(YTITLE,"Title of y-axis: ");
#ifdef DO3D
		if (axis == Z)
		    get_string(ZTITLE,"Title of z-axis: ");
#endif
		return;
#ifdef DO3D
	    case i_skip:
		if (axis == X)
		    {
		    sprintf(PSTRING,
			"Nr. of x-axis grid lines to be skipped [%1d]: ",
			NXSKIP);
		    NXSKIP = get_int(NXSKIP,PSTRING);
		    return;
		    }
		if (axis == Y)
		    {
		    sprintf(PSTRING,
			"Nr. of y-axis grid lines to be skipped [%1d]: ",
			NYSKIP);
		    NYSKIP = get_int(NYSKIP,PSTRING);
		    return;
		    }
		if (axis == Z)
		    {
		    errtype("Not valid for z-axis");
		    return;
		    }
#endif
	    case i_help:
		list_menus("AXIS SET MENU",
		    set_axis_menu,i_return,25);
		break;
	    case i_return:
		stop = TRUE;
		break;
	    }
	}
    }

/***************************************************************************/
void    set_color(void)
/***************************************************************************/

/* set default colors- mostly dummy for now. */

    {

    /* define set_color_menu */

#define set_color_length 7      /* number of commands in set_color menu */

    static struct   MENU set_color_menu[set_color_length] =
	{
	"background",1,   1, "Background color",
	"axes",      1,   2, "Color of axes",
	"curve",     1,   3, "Color of curves and data points",
	"text",      2,   4, "Color of text",
	"list",      1,  10, "List parameter values",
	"help",      1,  11, "Display menu",
	"return",    1,  12, "Return to main menu"
	};

    int stop = FALSE;
    char        token[50];
    int idummy;

    alldevs(
	    cpgscrn(16,"black",&idummy);
	    );

    while (!stop)
	{
	if (!get_token(token,"PLOT.COLOR>")) break;
	switch (cmnd_match(token,set_color_menu,set_color_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(PSTRING,"Background color [%s]: ",BACK_COLOR);
		COLBACK = get_color(BACK_COLOR,PSTRING);
		break;
	    case 2:
		sprintf(PSTRING,"Axes color [%s]: ",AX_COLOR);
		COLAXES = get_color(AX_COLOR,PSTRING);
#if defined(__unix) || defined(__APPLE__)
		if (COLAXES==0) COLAXES=16;
#endif
		break;
	    case 3:
		sprintf(PSTRING,"Curve and data point color [%s]: ",
		    CURVE_COLOR);
		COLCURVE = get_color(CURVE_COLOR,PSTRING);
#if defined(__unix) || defined(__APPLE__)
		if (COLCURVE==0) COLCURVE=16;
#endif
		break;
	    case 4:
		sprintf(PSTRING,"Text color [%s]: ",TEXT_COLOR);
		COLTEXT = get_color(TEXT_COLOR,PSTRING);
#if defined(__unix) || defined(__APPLE__)
		if (COLTEXT==0) COLTEXT=16;
#endif
		break;
	    case 10:
		sprintf(PSTRING,"Background color: %1s\n",BACK_COLOR);
		type_line(PSTRING);
		sprintf(PSTRING,"Axes color: %1s\n",AX_COLOR);
		type_line(PSTRING);
		sprintf(PSTRING,"Curve color: %1s\n",CURVE_COLOR);
		type_line(PSTRING);
		sprintf(PSTRING,"Text color: %1s\n",TEXT_COLOR);
		type_line(PSTRING);
		break;
	    case 11:
		list_menus("COLOR SET MENU",
		    set_color_menu,set_color_length,25);
		break;
	    case 12:
		stop = TRUE;
		break;
	    }
	}
    }











/***************************************************************************/
void    set_default(void)
/***************************************************************************/

    /*
    Give all parameters their default values
    */

    {

    AUTOX = TRUE;
    AUTOY = TRUE;
    XLOGSC = FALSE;
    YLOGSC = TRUE;

    sprintf(XTITLE,"X");
    sprintf(YTITLE,"Y");
    PTITLE[0] = '\0';
    NFONTS = 2;
    sprintf(FONTNAME[0],"simplex.fnt");
    sprintf(FONTNAME[1],"simgrma.fnt");
    DEFFONT = 1;
    FONTFILL = TRUE;


    CURVESTYLE = -1;
    LINESTYLE = 1;
    SYMSTYLE = 1;
    SYMSIZE = 0.25;

    COLBACK = 1;
#ifdef __CYGWIN__
    // For GrWin, white is 19
    COLBACK = 19;
#endif
    sprintf(BACK_COLOR,"white");
    COLAXES = 0;
#if defined(__unix) || defined(__APPLE__)
    COLAXES = 16;
#elif __CYGWIN__
    // For GrWin, black is 1
    COLAXES = 1;
#endif
    sprintf(AX_COLOR,"black");
    COLCURVE = 2;
    sprintf(CURVE_COLOR,"red");
    COLTEXT = 4;
    sprintf(TEXT_COLOR,"blue");

#ifdef INCHES
    PLOTWIDTH = 8.5;
    PLOTHEIGHT = 6.5;
    XLENGTH = 7;
    YLENGTH = 4.2;
#endif
#ifdef METRIC
    PLOTWIDTH = 22;
    PLOTHEIGHT = 17;
    XLENGTH = 18;
    YLENGTH = 12;
#endif
    AXESPAR = 0;
    FRAMEPAR = 2;
    GRIDPAR = 0;
    SUBGRIDPAR = -1;
    PAGEROT = 0;

#ifdef INCHES
    AXNAMSIZE = 0.25;
    AXNUMSIZE = 0.2;
    TITLESIZE = 0.2;
    TEXTSIZE = 0.12;
#endif
#ifdef METRIC
    AXNAMSIZE = 1;
    AXNUMSIZE = 1;
    TITLESIZE = 1;
    TEXTSIZE = 1;
#endif

#ifdef DO3D
    AUTOZ = TRUE;
    sprintf(ZTITLE,"Z");
    XBOX = YBOX = ZBOX = 1.;
    XVIEW = YVIEW = ZVIEW = 5.;
#endif

    SYMSIZE=1;

    }


/***************************************************************************/
void set_layout(void)
/***************************************************************************/

/*define layout of gnuplot plot. These are mostly dummy functions for now */

{
    /* define set_layout_menu */

    enum i_layout {
	i_zero,
	i_width,
	i_height,
	i_xlength,
	i_ylength,
	i_axes,
	i_frame,
	i_grid,
	i_subgrid,
	i_rotate,
#ifdef DO3D
	i_box,
	i_viewpoint,
#endif
	i_list,
	i_help,
	i_return
	};

    static struct   MENU set_layout_menu[i_return] =
	{
	"width",     1,i_width,   "Width of plot",
	"height",    3,i_height,  "Height of plot",
	"xlength",   1,i_xlength, "Length of x-axis",
	"ylength",   1,i_ylength, "Length of y-axis",
	"axes",      1,i_axes,    "Axes/labels on/off",
	"frame",     1,i_frame,   "Frame on/off",
	"grid",      1,i_grid,    "Grid on/off",
	"subgrid",   1,i_subgrid, "Subgrid on/off",
	"rotate",    2,i_rotate,  "Rotate page yes/no",
#ifdef DO3D
	"box",       1,i_box,     "Box dimensions (3D only)",
	"viewpoint", 1,i_viewpoint, "Viewpoint in box units (3D only)",
#endif
	"list",      1,i_list,    "List parameter values",
	"help",      1,i_help,    "Display menu",
	"return",    1,i_return,  "Return to main menu"
	};

    int stop = FALSE;
    char        token[50];

    while (!stop)
	{
	if (!get_token(token,"PLOT.LAYOUT>")) break;
	switch (cmnd_match(token,set_layout_menu,i_return))
	    {
            case -1:
		break;
	    case 0:
		break;
	    case i_width:
		sprintf(PSTRING,"Width of plot [%6.3f]: ",
		    PLOTWIDTH);
		PLOTWIDTH = get_real(PLOTWIDTH,PSTRING);
		break;
	    case i_height:
		sprintf(PSTRING,"Height of plot [%6.3f]: ",
		    PLOTHEIGHT);
		PLOTHEIGHT = get_real(PLOTHEIGHT,PSTRING);
		break;
	    case i_xlength:
		sprintf(PSTRING,"Length of x-axis [%6.3f]: ",
		    XLENGTH);
		XLENGTH = get_real(XLENGTH,PSTRING);
		break;
	    case i_ylength:
		sprintf(PSTRING,"Length of y-axis [%6.3f]: ",
		    YLENGTH);
		YLENGTH = get_real(YLENGTH,PSTRING);
		break;
	    case i_axes:
		sprintf(PSTRING,
		"Axes parameter (0,1,2) = (normal,no axes,no labels) [%1d]: ",
		AXESPAR);
		AXESPAR = get_int(AXESPAR,PSTRING);
		if ((AXESPAR < 0) || (AXESPAR > 3))
		    {
		    errtype("Non-valid axes parameter");
		    AXESPAR = 0;
		    }
		switch (AXESPAR)
		    {
		    case 0:
/*			AXESCHAR = AXESON; */
			break;
		    case 1:
/*			AXESCHAR = AXESOFF; */
			break;
		    case 2:
/* 			AXESCHAR = XAXIS|YAXIS; */
			break;
		    }
		break;
	    case i_frame:
		sprintf(PSTRING,
		"Frame parameter (0,1,2) = (no,yes,with ticks) [%1d]: ",
		FRAMEPAR);
		FRAMEPAR = get_int(FRAMEPAR,PSTRING);
		if ((FRAMEPAR < 0) || (FRAMEPAR > 3))
		    {
		    errtype("Non-valid frame parameter");
		    FRAMEPAR = 0;
		    }
		break;
	    case i_grid:
		sprintf(PSTRING,
		"Grid line style (0 = off) [%1d]: ",
		GRIDPAR);
		GRIDPAR = get_int(GRIDPAR,PSTRING);
		if ((GRIDPAR < 0) || (GRIDPAR > 9))
		    {
		    errtype("Non-valid grid parameter");
		    GRIDPAR = 0;
		    }
		break;
	    case i_subgrid:
		sprintf(PSTRING,
		"Subgrid parameter (-1,0,int) = (ticks,no,linestyle) [%1d]: ",
		SUBGRIDPAR);
		SUBGRIDPAR = get_int(SUBGRIDPAR,PSTRING);
		if ((SUBGRIDPAR < -1) || (SUBGRIDPAR > 9))
		    {
		    errtype("Non-valid subgrid parameter");
		    SUBGRIDPAR = 0;
		    }
		break;
	    case i_rotate:
		if (PAGEROT)
		    sprintf(PSTRING,"Rotate page [yes]: ");
		else
		    sprintf(PSTRING,"Rotate page [no]: ");
		PAGEROT = yesno(PAGEROT,PSTRING);
		break;
#ifdef DO3D
	    case i_box:
		sprintf(PSTRING,"X length of 3D box [%3.1f]: ",XBOX);
		XBOX = get_real(XBOX,PSTRING);
		sprintf(PSTRING,"Y length of 3D box [%3.1f]: ",YBOX);
		YBOX = get_real(YBOX,PSTRING);
		sprintf(PSTRING,"Z length of 3D box [%3.1f]: ",ZBOX);
		ZBOX = get_real(ZBOX,PSTRING);
		break;
	    case i_viewpoint:
		sprintf(PSTRING,"X coordinate of 3D viewpoint [%3.1f]: ",
		    XVIEW);
		XVIEW = get_real(XVIEW,PSTRING);
		sprintf(PSTRING,"Y coordinate of 3D viewpoint [%3.1f]: ",
		    YVIEW);
		YVIEW = get_real(YVIEW,PSTRING);
		sprintf(PSTRING,"Z coordinate of 3D viewpoint [%3.1f]: ",
		    ZVIEW);
		ZVIEW = get_real(ZVIEW,PSTRING);
		break;
#endif
	    case i_list:
		sprintf(PSTRING,"width   = %6.3f;  height  = %6.3f\n",
		    PLOTWIDTH,PLOTHEIGHT);
		type_line(PSTRING);
		sprintf(PSTRING,"xlength = %6.3f;  ylength = %6.3f\n",
		    XLENGTH,YLENGTH);
		type_line(PSTRING);
		sprintf(PSTRING,"axes parameter = %1d\n",AXESPAR);
		type_line(PSTRING);
		sprintf(PSTRING,"frame parameter = %1d\n",FRAMEPAR);
		type_line(PSTRING);
		sprintf(PSTRING,"grid parameter = %1d\n",GRIDPAR);
		type_line(PSTRING);
		sprintf(PSTRING,"sub grid parameter = %1d\n",SUBGRIDPAR);
		type_line(PSTRING);
		if (PAGEROT)
		    type_line("page rotated\n");
		else
		    type_line("page not rotated\n");
#ifdef DO3D
		sprintf(PSTRING,"3D plotting box = (%3.1f,%3.1f,%3.1f)\n",
		    XBOX,YBOX,ZBOX);
		type_line(PSTRING);
		sprintf(PSTRING,"3D viewpoint = (%3.1f,%3.1f,%3.1f)\n",
		    XVIEW,YVIEW,ZVIEW);
		type_line(PSTRING);
#endif
		break;
	    case i_help:
		list_menus("LAYOUT MENU",
		    set_layout_menu,i_return,25);
		break;
	    case i_return:
		stop = TRUE;
		break;
	    }
	}


}


/***************************************************************************/
void    set_text(void)
/***************************************************************************/

    /*
    Set features associated with text.
    */

{

    /* define set_text_menu */

#define set_text_length 10      /* number of commands in set_text menu */

    static struct   MENU set_text_menu[set_text_length] =
	{
	"axessize",  1,   1, "Character size of axes titles",
	"numbersize",1,   2, "Size of number at axes",
	"titlesize", 2,   3, "Character size of plot title",
	"textsize",  5,   4, "Character size of text",
	"label",     2,   5, "Put text label in plot",
	"header",    3,   6, "Print next header line",
	"leftupper", 2,   7, "Put label in upper left corner of plot",
	"list",      1,  10, "List parameter values",
	"help",      1,  11, "Display menu",
	"return",    1,  12, "Return to main menu"
	};

    int stop = FALSE;
    char        token[50];
    float       xpos,ypos;
#ifdef DO3D
    float	zpos;
#endif

    while (!stop)
	{
	if (!get_token(token,"PLOT.TEXT>")) break;
	switch (cmnd_match(token,set_text_menu,set_text_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(PSTRING,"Character size of axes titles [%4.2f]: ",
		    AXNAMSIZE);
		AXNAMSIZE = get_real(AXNAMSIZE,PSTRING);
		break;
	    case 2:
		sprintf(PSTRING,"Size of numbers at axes [%4.2f]: ",
		    AXNUMSIZE);
		AXNUMSIZE = get_real(AXNUMSIZE,PSTRING);
		break;
	    case 3:
		sprintf(PSTRING,"Charactersize of plot title [%4.2f]: ",
		    TITLESIZE);
		TITLESIZE = get_real(TITLESIZE,PSTRING);
		break;
	    case 4:
		sprintf(PSTRING,"Charactersize of text [%4.2f]: ",
		    TEXTSIZE);
		TEXTSIZE = get_real(TEXTSIZE,PSTRING);
		break;
	    case 5:
		xpos = get_real(0.,
		    "X-position in plot units: ");
		ypos = get_real(0.,
		    "Y-position in plot units: ");
#ifdef DO3D
		if ((PLOTMODE == D3) || (PLOTMODE == D3CURVE))
		    {
		    zpos = get_real(0.,
			"Z-position in plot units: ");
		    }
#endif
		get_string(PSTRING,"Label : ");
		alldevs(
		  cpgsci(COLTEXT);
		  cpgsch(TEXTSIZE);
		  cpgtext(xpos,ypos,PSTRING);
			);

#ifdef DO3D
		/*		if ((PLOTMODE == D3) || (PLOTMODE == D3CURVE))
				{
				d3pltfnt(xpos,ypos,zpos,PSTRING,TEXTSIZE,0.);
				}
				*/
#endif
		break;
	    case 6:
		get_string(PSTRING,"Text: ");

		alldevs(
			cpgsci(COLTEXT);
			cpgsch(TEXTSIZE);
			cpgmtxt("T",H_HEIGHT,0.6,0,PSTRING);
			H_HEIGHT-=1;
			);
		
		break;
	    case 7:
		get_string(PSTRING,"Text: ");

		alldevs(
			cpgsci(COLTEXT);
			cpgsch(TEXTSIZE);
			cpgmtxt("T",-2,0.05,0,PSTRING);
			H_HEIGHT-=.03;
			);
		break;
	    case 10:
		sprintf(PSTRING,"Size of axes titles  = %4.2f\n",AXNAMSIZE);
		type_line(PSTRING);
		sprintf(PSTRING,"Size of axes numbers = %4.2f\n",AXNUMSIZE);
		type_line(PSTRING);
		sprintf(PSTRING,"Size of plot title   = %4.2f\n",TITLESIZE);
		type_line(PSTRING);
		sprintf(PSTRING,"Size of text         = %4.2f\n",TEXTSIZE);
		type_line(PSTRING);
		break;
	    case 11:
		list_menus("TEXT SET MENU",
		    set_text_menu,set_text_length,25);
		break;
	    case 12:
		stop = TRUE;
		break;
	    }
	}
    }

/***************************************************************************/
void    write_plotmac(void)
/***************************************************************************/

    /*
    Save global plot parameters on macro file.
    */

    {

    FILE        *plotmac;
    int i;
    char        font[40];

    /* Open macro file */

    if ((plotmac = fopen(PLOTINIT,"w")) == NULL)
	{
	sprintf(PSTRING,"Failed to open %s file",PLOTINIT);
	errtype(PSTRING);
	clear_command();
	return;
	}

    /* Save axis-defining parameters */

    if (AUTOX)
	{
	fprintf(plotmac,"x auto\n");
	}
    else
	{
	fprintf(plotmac,"x manual x lowersc %10.4e x uppersc %10.4e\n",
	    XLOWERSC,XUPPERSC);
	}
    if (AUTOY)
	{
	fprintf(plotmac,"y auto\n");
	}
    else
	{
	fprintf(plotmac,"y manual y lowersc %10.4e y uppersc %10.4e\n",
	    YLOWERSC,YUPPERSC);
	}
#ifdef DO3D
    if (AUTOZ)
	{
	fprintf(plotmac,"z auto\n");
	}
    else
	{
	fprintf(plotmac,"z manual z lowersc %10.4e z uppersc %10.4e\n",
	    ZLOWERSC,ZUPPERSC);
	}
#endif
    if (XLOGSC)
	{
	fprintf(plotmac,"x logarith\n");
	}
    else
	{
	fprintf(plotmac,"x linear\n");
	}
    if (YLOGSC)
	{
	fprintf(plotmac,"y logarith\n");
	}
    else
	{
	fprintf(plotmac,"y linear\n");
	}

    /* Save titles etc. */

/*    fprintf(plotmac,"loadfonts nfonts %1d\n",NFONTS);
    for (i = 0; i < NFONTS; i++)
	{
	sprintf(font,FONTNAME[i]);
	del_extension(font);
	fprintf(plotmac,"%s %1d\n",font,i+1);
	}
    if (FONTFILL)
	{
	fprintf(plotmac,"fill\n");
	}
    else
	{
	fprintf(plotmac,"nofill\n");
	}
	fprintf(plotmac,"return\n");
	*/
    fprintf(plotmac,"font %1d\n",DEFFONT);

    fprintf(plotmac,"x title \"%s\"\n",XTITLE);
    fprintf(plotmac,"y title \"%s\"\n",YTITLE);
#ifdef DO3D
    fprintf(plotmac,"z title \"%s\"\n",ZTITLE);
#endif
    fprintf(plotmac,"title \"%s\"\n",PTITLE);

    /* Save curve defining parameters */

    fprintf(plotmac,"curvestyle %1d\n",CURVESTYLE);



    fprintf(plotmac,"linestyle %1d\n",LINESTYLE);
    fprintf(plotmac,"symbol %1d\n",SYMSTYLE);
    fprintf(plotmac,"symsize %7.3f\n",SYMSIZE);

    /* Save color defining parameters */


    fprintf(plotmac,"color\n");
    fprintf(plotmac,"background %1s\n",BACK_COLOR);
    fprintf(plotmac,"axes %1s\n",AX_COLOR);
    fprintf(plotmac,"curve %1s\n",CURVE_COLOR);
    fprintf(plotmac,"text %1s\n",TEXT_COLOR);
    fprintf(plotmac,"return\n");

    /* Save text parameters */
    fprintf(plotmac,"text\n");    
    fprintf(plotmac,"axes %f\n",AXNAMSIZE);
    fprintf(plotmac,"number %f\n",AXNUMSIZE);
    fprintf(plotmac,"title %f\n",TITLESIZE);
    fprintf(plotmac,"textsize %f\n",TEXTSIZE);
    fprintf(plotmac,"return\n");

    fclose(plotmac);
    }

/***************************************************************************/
int	get_color(char color_string[], char prompt[])
/***************************************************************************/

    /*
    Return correct color code AND set color_string to correct color.
    */

    {

    /* define get_color_menu */

#define get_color_length 17     /* number of commands in get_color menu */

    static struct   MENU get_color_menu[get_color_length] =
	{
	"black",      3,   1, "Black",
	"white",      1,   2, "White",
	"red",        3,   3, "Red",
	"green",      4,   4, "Green",
	"blue",       3,   5, "Blue",
	"cyan",       1,   6, "Cyan",
	"magenta",    2,   7, "Magenta",
	"yellow",     1,   8, "Yellow",
	"orange",     4,   9, "Orange (Red + Yellow)",
	"lgreen",     5,  10, "Light Green (Green + Yellow)",
	"bluegreen",  5,  11, "Blue Green (Green + Cyan)",
	"lightblue",  3,  12, "Light Blue (Blue + Cyan)",
	"purple",     2,  13, "Purple (Blue + Magenta)",
	"pink",       2,  14, "Pink (Red + Magenta)",
	"grey",       4,  15, "Grey (Dark Grey)",
	"lgrey",      5,  16, "Light Grey",
	"help",       1,  20, "Display menu",
	};

    int stop = FALSE;
    int switch_code,i;
    char        token[50];

    while (!stop)
	{
	if (!get_token(token,prompt)) break;
	switch_code = cmnd_match(token,get_color_menu,get_color_length);
	switch (switch_code)
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
	    case 2:
	    case 3:
	    case 4:
	    case 5:
	    case 6:
	    case 7:
	    case 8:
	    case 9:
	    case 10:
	    case 11:
	    case 12:
	    case 13:
	    case 14:
	    case 15:
	    case 16:
		sprintf(color_string,"%s",
		    get_color_menu[switch_code-1].COMMAND);
#ifdef __CYGWIN__
                // For GrWin, black is 1 and white is 19
		if (switch_code == 1)
		{
		  switch_code = 2;
		} 
		else if (switch_code == 2)
		{
		  switch_code = 20;
		} 
#endif
		return(switch_code-1);
	    case 20:
		list_menus("COLOR CHOICES",get_color_menu,
		    get_color_length,25);
		break;
	    }
	}
    }


void ucircle(float xpos, float ypos, float radius, float th1, float th2)
     /* Plots a circle onto graph */
{
  
  float xcirc[102],ycirc[102],ecirc[102];
  int n;
  float th, th_step;
  
  alldevs(
	  
	  cpgsci(COLCURVE);
	  cpgsls(LINESTYLE);
	  
	  xcirc[0]=xpos;
	  ycirc[0]=ypos;
	  th_step=(th2-th1)/(49.0);
	  for (n=1;n<51;n++){ 
	    th=th1+(n-1)*th_step;
	    xcirc[n]=xpos+radius*cos(th);      
	    ycirc[n]=ypos+radius*sin(th);
	  }
	  xcirc[51]=xpos;
	  ycirc[51]=ypos;
	  cpgpoly(51,xcirc,ycirc);
	  );
  
  
}

void uradlin(float xpos,float ypos,float dummy,float radius,float th1)

{
  float x[2],y[2];

  x[0]=xpos;
  y[0]=ypos;
  x[1]=xpos+radius*cos(th1);
  y[1]=ypos+radius*sin(th1);

  alldevs(
	  cpgsci(COLCURVE);
	  cpgsls(LINESTYLE);
	  cpgline(2, x, y);
	);
}

void uline (float xpos,float ypos,float xpos2,float ypos2,float dummy)

{
  float x[2],y[2];

  x[0]=xpos;
  y[0]=ypos;
  x[1]=xpos2;
  y[1]=ypos2;

  alldevs(
	  cpgsci(COLCURVE);
	  cpgsls(LINESTYLE);
	  cpgline(2, x, y);
	  );

}

void d3line(float xpos,float ypos,float xpos2,float ypos2,float zpos1,float zpos2)

{

  sprintf(PSTRING,"Error: not implemented\n");
  errtype(PSTRING);

}

/***************************************************************************/
void get_xy(char * promptx, char * prompty, float defx, float defy,
	    float *x, float *y)
/***************************************************************************/

     /* 
	Get x,y using the cursor or typed coordinates.
      */
{
  char token[50];
  double value;
  char cursorch;

  *x=defx;
  *y=defy;

  get_string(token,promptx);

  if(!strcmp(token,"cur") ||
     !strcmp(token,"curs") ||
     !strcmp(token,"curso")||
     !strcmp(token,"cursor") ){
    
    cpgslct(X_DEVICE);
    sprintf(PSTRING,"Click on graph to select coordinates\n");
    type_line(PSTRING);
    cpgcurs(x,y,&cursorch);

  }
  else{
    if(yy_get_real(token,&value))
      {
	errtype("ERROR parsing number\n");
	clear_command();
	exit;
      }
    *x=value;
    *y = get_real(defy,prompty);
  }

}


/***************************************************************************/
void get_xy_xy(char * promptx, char * prompty,
	       char * promptx2, char * prompty2, 
	       float defx, float defy, float defx2, float defy2,
	       float *x, float *y, float *x2, float *y2)
/***************************************************************************/

     /* 
	Get x,y,x2,y2 using the cursor or typed coordinates.
      */
{
  char token[50];
  double value;
  char cursorch;

  *x=defx;
  *y=defy;
  *x2=defx2;
  *y2=defy2;

  get_string(token,promptx);

  if(!strcmp(token,"cur") ||
     !strcmp(token,"curs") ||
     !strcmp(token,"curso")||
     !strcmp(token,"cursor") ){
    
    cpgslct(X_DEVICE);
    sprintf(PSTRING,"Click on graph to select coordinates\n");
    type_line(PSTRING);

    cpgcurs(x,y,&cursorch);
    cpgband(1,0,*x,*y,x2,y2,&cursorch);

    /* cpgcurs(x2,y2,&cursorch); */

    sprintf(PSTRING,"draw line %f %f %f %f\n",*x,*y,*x2,*y2);
    type_line(PSTRING);
  }
  else{
    if(yy_get_real(token,&value))
      {
	errtype("ERROR parsing number\n");
	clear_command();
	exit;
      }
    *x=value;
    *y = get_real(defy,prompty);
    *x2 = get_real(defx2,promptx2);
    *y2 = get_real(defy2,prompty2);
  }

}



/***************************************************************************/
void my_cpgenv(float xmin, float xmax, float ymin, float ymax, 
	       int just, int axis)
/***************************************************************************/
{
  int i;
  char *xopts, *yopts, *xopts_env, *yopts_env; 

  cpgpage();
  cpgscrn(0,BACK_COLOR,&i);
  cpgeras();
  cpgvstd();
  if (abs((double)(xmin-xmax))<(abs((double)xmax/1.0e6)))
    errtype("invalid x limits in my_cpgenv: xmin = xmax.");
  else if (abs((double)(ymin-ymax))<abs((double)ymax/1.0e6))
    errtype("invalid y limits in my_cpgenv: ymin = ymax.");
  //
  if (just == 1) 
    cpgwnad(xmin,xmax,ymin,ymax);
  else 
    cpgswin(xmin,xmax,ymin,ymax);
  //
  yopts = "*";
  switch (axis)
  {
    case -2: 
      xopts = " ";
      break;
    case -1:
      xopts = "BC";
      break;
    case 0:
      xopts = "BCNST";
      break;
    case 1:
      xopts = "ABCNST";
      break;
    case 2:
      xopts = "ABCGNST";
      break;
    case 10:
      xopts = "BCNSTL";
      yopts = "BCNST";
      break;
    case 20:
      xopts = "BCNST";
      yopts = "BCNSTL";
      break;
    case 30:
      xopts = "BCNSTL";
      yopts = "BCNSTL";
      break;
    default:
      errtype("my_cpgenv: illegal AXIS argument.");
      break;
  }
  if (!strcmp(yopts,"*")) 
    yopts = xopts;
  if (xopts_env=getenv("XOPTS"))
    xopts = xopts_env;
  if (yopts_env=getenv("YOPTS"))
    yopts = yopts_env;
  cpgbox(xopts, 0.0, 0, yopts, 0.0, 0);
}

void plot_blankpage(void)
{
  alldevs(
	  cpgpage();
	  cpgbbuf();
	  cpglab("blank", "blank", "blank");	  
	  cpgebuf(););
}


void popconfig()
    {
    int i;

    AXIS = TMP_AXIS;                   
    XLOWERSC = TMP_XLOWERSC;               
    XUPPERSC = TMP_XUPPERSC;               
    YLOWERSC = TMP_YLOWERSC;               
    YUPPERSC = TMP_YUPPERSC;               
    AUTOX = TMP_AUTOX;                  
    AUTOY = TMP_AUTOY;                  
    XLOGSC = TMP_XLOGSC;                 
    YLOGSC = TMP_YLOGSC;                 
    ZFORCE = TMP_ZFORCE;           
    XTICK = TMP_XTICK;                  
    XSUBTICK = TMP_XSUBTICK;               
    strcpy(XFORMAT, TMP_XFORMAT);            
    YTICK = TMP_YTICK;                  
    YSUBTICK = TMP_YSUBTICK;               
    strcpy(YFORMAT, TMP_YFORMAT);            
    XLABEL = TMP_XLABEL;
    for (i = 0; i < 20; i++)
	{
	strcpy(XLABSTRING[i], TMP_XLABSTRING[i]);
	XLABPOINTER[i] = TMP_XLABPOINTER[i];
	strcpy(YLABSTRING[i], TMP_YLABSTRING[i]);     
	YLABPOINTER[i] = TMP_YLABPOINTER[i];       
	}       
    YLABEL = TMP_YLABEL;         
#ifdef DO3D
    ZLOWERSC = TMP_ZLOWERSC;               
    ZUPPERSC = TMP_ZUPPERSC;               
    AUTOZ = TMP_AUTOZ;                  
    ZTICK = TMP_ZTICK;			
    strcpy(ZTITLE, TMP_ZTITLE);		
#endif
    strcpy(XTITLE, TMP_XTITLE);             
    strcpy(YTITLE, TMP_YTITLE);             
    strcpy(PTITLE, PTITLE);             
    NFONTS = TMP_NFONTS;      
    for (i = 0; i < 4; i++) strcpy(FONTNAME[i], TMP_FONTNAME[i]);
    DEFFONT = TMP_DEFFONT;                
    FONTFILL = TMP_FONTFILL;               
    CURVESTYLE = TMP_CURVESTYLE;             
    LINESTYLE = TMP_LINESTYLE;              
    SYMSTYLE = TMP_SYMSTYLE;             
    SYMSIZE = TMP_SYMSIZE;                
    strcpy(LINETYPE, TMP_LINETYPE);
    COLBACK = TMP_COLBACK;                
    COLAXES = TMP_COLAXES;                
    COLCURVE = TMP_COLCURVE;               
    COLTEXT = TMP_COLTEXT;                
    strcpy(BACK_COLOR, TMP_BACK_COLOR);
    strcpy(AX_COLOR, TMP_AX_COLOR);
    strcpy(CURVE_COLOR, TMP_CURVE_COLOR);
    strcpy(TEXT_COLOR, TEXT_COLOR);
    H_Y = H_Y;            
    H_HEIGHT = TMP_H_HEIGHT;             
    H_OFFSET = TMP_H_OFFSET;             
    AXES = TMP_AXES;                 
    PLOTWIDTH = TMP_PLOTWIDTH;            
    PLOTHEIGHT = TMP_PLOTHEIGHT;           
    XLENGTH = TMP_XLENGTH;                
    YLENGTH = TMP_YLENGTH;                
    AXESPAR = TMP_AXESPAR;                
    AXESCHAR = TMP_AXESCHAR;		
    FRAMEPAR = TMP_FRAMEPAR;               
    GRIDPAR = TMP_GRIDPAR;                
    SUBGRIDPAR = TMP_SUBGRIDPAR;             
    PAGEROT = TMP_PAGEROT;                
#ifdef DO3D
    XBOX = TMP_XBOX;
    YBOX = TMP_YBOX;
    ZBOX = TMP_ZBOX;		
    XVIEW = TMP_XVIEW;
    YVIEW = TMP_YVIEW;
    ZVIEW = TMP_ZVIEW;
    NXSKIP = TMP_NXSKIP; 		
    NYSKIP = TMP_NYSKIP;
#endif
    AXNAMSIZE = TMP_AXNAMSIZE;             
    AXNUMSIZE = TMP_AXNUMSIZE;              
    TITLESIZE = TMP_TITLESIZE;              
    TEXTSIZE = TMP_TEXTSIZE;               
    X_TEXT = TMP_X_TEXT;
    Y_TEXT = TMP_Y_TEXT;             
    MULTIPLOT = TMP_MULTIPLOT;	
    PLOT_ROWS = TMP_PLOT_ROWS;		
    PLOT_COLUMNS = TMP_PLOT_COLUMNS;	
    FIRST_MULTI = TMP_FIRST_MULTI;	
    PLOTNR = TMP_PLOTNR;		
    XSHIFTT = TMP_XSHIFTT;                
    YSHIFTT = TMP_YSHIFTT;                


    }


void pushconfig()
    {
    int i;

    TMP_AXIS = AXIS;                   
    TMP_XLOWERSC = XLOWERSC;               
    TMP_XUPPERSC = XUPPERSC;               
    TMP_YLOWERSC = YLOWERSC;               
    TMP_YUPPERSC = YUPPERSC;               
    TMP_AUTOX = AUTOX;                  
    TMP_AUTOY = AUTOY;                  
    TMP_XLOGSC = XLOGSC;                 
    TMP_YLOGSC = YLOGSC;                 
    TMP_ZFORCE = ZFORCE;           
    TMP_XTICK = XTICK;                  
    TMP_XSUBTICK = XSUBTICK;               
    strcpy(TMP_XFORMAT, XFORMAT);            
    TMP_YTICK = YTICK;                  
    TMP_YSUBTICK = YSUBTICK;               
    strcpy(TMP_YFORMAT, YFORMAT);            
    TMP_XLABEL = XLABEL;
    for (i = 0; i < 20; i++)
	{
	strcpy(TMP_XLABSTRING[i], XLABSTRING[i]);
	TMP_XLABPOINTER[i] = XLABPOINTER[i];
	strcpy(TMP_YLABSTRING[i], YLABSTRING[i]);     
	TMP_YLABPOINTER[i] = YLABPOINTER[i];       
	}       
    TMP_YLABEL = YLABEL;         
#ifdef DO3D
    TMP_ZLOWERSC = ZLOWERSC;               
    TMP_ZUPPERSC = ZUPPERSC;               
    TMP_AUTOZ = AUTOZ;                  
    TMP_ZTICK = ZTICK;			
    strcpy(TMP_ZTITLE, ZTITLE);		
#endif
    strcpy(TMP_XTITLE, XTITLE);             
    strcpy(TMP_YTITLE, YTITLE);             
    strcpy(TMP_PTITLE, PTITLE);             
    TMP_NFONTS = NFONTS;      
    for (i = 0; i < 4; i++) strcpy(TMP_FONTNAME[i], FONTNAME[i]);
    TMP_DEFFONT = DEFFONT;                
    TMP_FONTFILL = FONTFILL;               
    TMP_CURVESTYLE = CURVESTYLE;             
    TMP_LINESTYLE = LINESTYLE;              
    TMP_SYMSTYLE = SYMSTYLE;             
    TMP_SYMSIZE = SYMSIZE;                
    strcpy(TMP_LINETYPE, LINETYPE);
    TMP_COLBACK = COLBACK;                
    TMP_COLAXES = COLAXES;                
    TMP_COLCURVE = COLCURVE;               
    TMP_COLTEXT = COLTEXT;                
    strcpy(TMP_BACK_COLOR, BACK_COLOR);
    strcpy(TMP_AX_COLOR, AX_COLOR);
    strcpy(TMP_CURVE_COLOR, CURVE_COLOR);
    strcpy(TMP_TEXT_COLOR, TEXT_COLOR);
    TMP_H_Y = H_Y;            
    TMP_H_HEIGHT = H_HEIGHT;             
    TMP_H_OFFSET = H_OFFSET;             
    TMP_AXES = AXES;                 
    TMP_PLOTWIDTH = PLOTWIDTH;            
    TMP_PLOTHEIGHT = PLOTHEIGHT;           
    TMP_XLENGTH = XLENGTH;                
    TMP_YLENGTH = YLENGTH;                
    TMP_AXESPAR = AXESPAR;                
    TMP_AXESCHAR = AXESCHAR;		
    TMP_FRAMEPAR = FRAMEPAR;               
    TMP_GRIDPAR = GRIDPAR;                
    TMP_SUBGRIDPAR = SUBGRIDPAR;             
    TMP_PAGEROT = PAGEROT;                
#ifdef DO3D
    TMP_XBOX = XBOX;
    TMP_YBOX = YBOX;
    TMP_ZBOX = ZBOX;		
    TMP_XVIEW = XVIEW;
    TMP_YVIEW = YVIEW;
    TMP_ZVIEW = ZVIEW;
    TMP_NXSKIP = NXSKIP; 		
    TMP_NYSKIP = NYSKIP;
#endif
    TMP_AXNAMSIZE = AXNAMSIZE;             
    TMP_AXNUMSIZE = AXNUMSIZE;              
    TMP_TITLESIZE = TITLESIZE;              
    TMP_TEXTSIZE = TEXTSIZE;               
    TMP_X_TEXT = X_TEXT;
    TMP_Y_TEXT = Y_TEXT;             
    TMP_MULTIPLOT = MULTIPLOT;	
    TMP_PLOT_ROWS = PLOT_ROWS;		
    TMP_PLOT_COLUMNS = PLOT_COLUMNS;	
    TMP_FIRST_MULTI = FIRST_MULTI;	
    TMP_PLOTNR = PLOTNR;		
    TMP_XSHIFTT = XSHIFTT;                
    TMP_YSHIFTT = YSHIFTT;                


    }

void getPlotcursorPoint(int point_no, int direction, float *coordinate)
{
  int i, j;
  i = point_no;
  j = direction;
  if (point_no < 0) i = 0;
  else if (point_no > PLOT_CURSORMAXPOINTS) i = PLOT_CURSORMAXPOINTS - 1;
  if (direction < 0) j = 0;
  else if (direction > 1) j = 1;
  *coordinate = PLOT_CURSORPOINTS[i][j];
}
