/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                      menu.h                         $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

#ifdef DLL
#define UNDERSCORES
#endif
#ifdef __cplusplus
#define LFLAGS extern "C"
#else
#define LFLAGS
#endif


/***************************************************************************/
/*  Include extra header files                                             */
/***************************************************************************/

#ifndef VMS
#include <setjmp.h>
#endif

/***************************************************************************/
/*  Define global variables                                                */
/***************************************************************************/

/*  General globals */

#ifndef EXPORT
#define EXPORT
#endif

#define TRUE    1
#define FALSE   0

#ifdef VMS
#define ROWS		24	/* Number of rows on text screen */
#endif

#if (defined(MSDOS) || defined(OS2)) && !defined(__BORLANDC__)
#define ROWS		25	/* Number of rows on text screen */
#endif

#if (defined(MSDOS) || defined(OS2)) && defined(__BORLANDC__)
#define ROWS 		get_rows()	/* Borland compiler can get */
#define COLUMNS		get_columns()   /* these from DOS - OS/2 */
#else
#define COLUMNS 	80	/* Number of columns on text screen */
#endif

/*  Globals defining menus  */

#define CMND_LENGTH 11              /* length of command */
#define CMNT_LENGTH 41              /* length of comment */

struct  MENU                        /* command menu */
	{
	char    COMMAND[CMND_LENGTH];   /* a single command (lower case!) */
	int     SIGNIF_CHAR;            /* # of significant chars in command */
	int     RET_NR;                 /* return code number of command */
	char    COMMENT[CMNT_LENGTH];   /* comments explaining the command */
	};

/***************************************************************************/
/*  Function prototypes                                                    */
/***************************************************************************/

#ifdef UNDERSCORES

#define add_extension    _add_extension
#define clear_command    _clear_command
#define clear_screen     _clear_screen
#define close_macro      _close_macro
#define cmnd_match       _cmnd_match
#define cmnd_match_err   _cmnd_match_err
#define cursor_big	 _cursor_big
#define del_extension    _del_extension
#define errtype          _errtype
#define get_extension    _get_extension
#define get_cursor_position _get_cursor_position
#define get_int          _get_int
#define get_real         _get_real
#define get_string       _get_string
#define get_dstring       _get_dstring
#define get_token        _get_token
#ifndef VMS
#define install_exc_handler _install_exc_handler
#endif
#define list_menu        _list_menu
#define list_menus       _list_menus
#define nomore_commands  _nomore_commands
#define opsys            _opsys
#define put_command      _put_command
#define replace_extension _replace_extension
#define restore_line     _restore_line
#define run_macro        _run_macro
#define save_line        _save_line
#define set_cursor       _set_cursor
#define set_cursor_position _set_cursor_position
#define set_output	 _set_output
#define set_scroll       _set_scroll
#define skip_white       _skip_white
#define string_tolower   _string_tolower
#define type_line        _type_line
#define type_list	 _type_list
#define typeoff          _typeoff
#define typeon           _typeon
#define yesno            _yesno
#define get_term_line    _get_term_line
#define yesnostr         _yesnostr
#define video_normal     _video_normal
#define video_reverse    _video_reverse
#define video_highlight  _video_highlight

#ifdef __BORLANDC__
#define get_rows	 _get_rows
#define get_columns	 _get_columns
#endif

#endif

void    EXPORT	get_cursor_position (int *row, int *column);
void    EXPORT	cursor_big(int flag);
void    EXPORT	add_extension(char filename[], char extension[]);
void    EXPORT	clear_command(void);
void    EXPORT	clear_screen(void);
int     EXPORT	close_macro(void);
int     EXPORT	cmnd_match(char token[], struct MENU menu[], int length);
int     EXPORT	cmnd_match_err(char command[], struct MENU menu[],
			     int menu_length, int err_flag);
void    EXPORT	del_extension(char filename[]);
void    EXPORT	errtype(char message[]);
void    EXPORT	get_extension(char filename[], char extension[]);
int     EXPORT	get_int(int dflt, char prompt[]);
double  EXPORT	get_real(double dflt, char prompt[]);
void    EXPORT	get_string(char string[], char prompt[]);
void    EXPORT	get_dstring(char string[], char dflt[], char prompt[]);
int     EXPORT	get_token(char token[], char prompt[]);
#ifndef VMS
int     EXPORT	install_exc_handler(jmp_buf jumpaddr);
#endif
void    EXPORT	list_menu(char title[], struct MENU menu[], int length);
void    EXPORT	list_menus(char title[], struct MENU menu[], int length, int scroll);
int     EXPORT	nomore_commands(void);
void    EXPORT	opsys(void);
void    EXPORT	put_command(char string[]);
void    EXPORT	replace_extension(char filename[], char extension[]);
int     EXPORT	restore_line(char *saveline);
int     EXPORT	run_macro(void);
void    EXPORT	save_line(char *saveline);
void    EXPORT	set_cursor(int column, int row);
void 	EXPORT	set_output(char *extension);
void    EXPORT	set_scroll(int start_line, int end_line);
void    EXPORT	skip_white(void);
void    EXPORT	string_tolower(char string[]);
LFLAGS  void    EXPORT	type_line(char line[]);
LFLAGS  void	EXPORT  type_list(char line[], int length);
void    EXPORT	typeoff(void);
void    EXPORT	typeon(void);
int     EXPORT	yesno(int dflt, char prompt[]);
void    EXPORT	video_normal(void);
void    EXPORT	video_reverse(void);
void    EXPORT	video_highlight(void);

char *  EXPORT	yesnostr(int flag);

void    EXPORT	get_term_line (char *term_line);
void    EXPORT	get_cursor_position (int *row, int *column);
void    EXPORT	cursor_big(int flag);
void    EXPORT	set_cursor_position (int row, int col);

#ifdef __BORLANDC__
int     EXPORT	get_rows(void);
int     EXPORT	get_columns(void);
#endif
