
%{
#include <math.h>  /* For math functions, cos(), sin(), etc. */
#include <calc.h>  /* Contains definition of `symrec'        */
#include <ctype.h> /* for isdigit */
/***************************************************************************/
/*                menu.c headers                                           */
/***************************************************************************/
/****************************************************************************

  CVS information:

  $Id: menu.y,v 1.22 2007/03/16 12:40:30 wilcke Exp $

****************************************************************************/

/*
Update 13/03/2007 R. Wilcke (wilcke@esrf.fr)
                  remove preprocessor statements for "OS2" and "VMS" (no longer
                  used).
Update 22/03/2006 R. Wilcke (wilcke@esrf.fr)
                  removed check for __CYGWIN__ since __unix is now defined
                  in Cygwin 1.X.
Update 22/02/2006 R. Wilcke (wilcke@esrf.fr)
                  modified code for MacIntosh MACOSX using predefined macro
                  __APPLE__ for this architecture.
Update 10/02/2002 R. Wilcke (wilcke@esrf.fr)
                  int_handler(): display message to user when resuming program.
Update 11/04/2005 R. Wilcke (wilcke@esrf.fr)
                  added missing semicolons ";" in the "line" grammar definition.
Update 25/03/2002 R. Wilcke (wilcke@esrf.fr)
                  main() and int_handler(): changed abbreviations for menu
                  commands to the agreed set.
Update 25/09/2001 O. Svensson (svensson@esrf.fr)
                  Moved definition of GLOBAL_PROMPT to this file.
Update 10/01/2001 R. Wilcke (wilcke@esrf.fr)
                  re-ordered the "update" comments in descending chronological
                  order;
                  fpe_handler(): modified output statement for the jump message;
                  global declarations: replaced declaration of exc_handler() by
                  declaration of int_handler() - that is the correct name of the
                  interrupt handler function, exc_handler() does not exist;
                  init_menu(): in the "curses" initialization, replaced call to
                  raw() with call to cbreak() to allow interrupt (CTRL-C)
                  handling;
                  fpe_handler() and int_handler(): for __unix and __CYGWIN__,
                  replaced calls to longjmp() by call to siglongjmp();
                  global declarations and install_exc_handler(): replaced all
                  "jmp_buf" type declarations by "JMPBUF_TYPE" type declarations
                  (this macro is defined in menu.h);
Update 25/09/2000 Paul Howes (Paul.Howes@le.ac.uk)
                  multicharacter operators added to maths parser (++ += etc)
		  yylex() updated to recognise multicharacter operators
		  "keepgoing" command added to the secret menu to cause the
		  programs to ignore macro errors and keep going.
		  changed NOTDEFINED to MENU_MAIN - turn this flag on for
		  demo program.
Update 21/06/2000 R. Wilcke (wilcke@esrf.fr)
                  replace UNIX by __unix (is defined by CPP on UNIX systems).
Update 09/06/2000 R. Wilcke (wilcke@esrf.fr)
                  set_scroll(): if SCROLL is not defined, set only the variable
                  SCROLACT and take no further action.
Update 09/06/2000 R. Wilcke (wilcke@esrf.fr)
                  opsys(): change the way the output from the command is read,
                  as on HP-UX using type_line() causes EOF on the pipe to the
                  command;
                  modify some of the #if constructs for UNIX, CYGWIN and
                  TERMBUFFER to enable the compilation with -DREADLINE.
Update 07/06/2000 R. Wilcke (wilcke@esrf.fr)
                  cmnd_match_err(): do no longer return the input commands
                  converted to lower case (messes up filenames on case sensitive
                  operating systems);
                  replaced everywhere the buffer size for filenames by
                  the ISO-C defined macro FILENAME_MAX.
Update 17/05/2000 R. Wilcke (wilcke@esrf.fr)
                  init_menu(): for __CYGWIN__, set TERM environment variable to
                  "linux" if not defined or if defined as "cygwin".
Update 12/05/2000 R. Wilcke (wilcke@esrf.fr)
                  added global variable "SCROLACT" for the actual size of the
                  scroll window, set it in set_scroll() and use it in
                  list_menus().
Update 06/04/2000 R. Wilcke (wilcke@esrf.fr)
                  moved include of "readline/readline.h" into this file from
                  "menu.h";
                  init_menu(): get the size of the terminal for UNIX with the
                  "resize" command (does not work properly for __CYGWIN__).
Update 05/04/2000 R. Wilcke (wilcke@esrf.fr)
                  int_handler(): add a call to end_menu() for the "ABORT" option
                  to clean up (needed for CURSES);
                  video_normal(): call clrtoeol() to remove highlighting on the
                  present line;
                  end_menu(): call refresh() to push the last changes to the
                  window before exiting;
                  int_handler(): reorganized the output for the "Goto main menu"
                  clause;
                  opsys(): for UNIX and __CYGWIN__ with CURSES, use a popen() -
                  fgets() - pclose() sequence instead of the system() call;
                  move definition of TERMBUFFER macro to the beginning of the
                  file, and define it for UNIX and __CYGWIN__.
Update 04/04/2000 R. Wilcke (wilcke@esrf.fr)
                  for MSDOS, OS2, UNIX and __CYGWIN__, include <signal.h>,
                  <float.h> and <memory.h>;
                  install_exc_handler(): replaced sizeof(jumpaddr[0]) by
                  sizeof(jmp_buf) in the memcpy() calls for FPE_JUMPADDR and
	          INT_JUMPADDR;
                  get_term_line(): remove the conditional getstr() call for
                  UNIX and __CYGWIN__ (no longer needed);
                  init_menu(): replace cbreak() call by raw() to ensure proper
                  handling of <CTRL-C>.
Update 03/04/2000 R. Wilcke (wilcke@esrf.fr)
                  for UNIX and __CYGWIN__, add a new typedef for *EXC_HND_F;
                  fpe_handler(): do not call _fpreset() for UNIX or __CYGWIN__.
Update 31/03/2000 R. Wilcke (wilcke@esrf.fr)
                  end_menu(): for UNIX and __CYGWIN__, return the return code of
                  endwin(); else return 0;
                  remove declarations of get_rows() and get_columns(), as they
                  are already declared in <menu.h>;
                  add the exception handler routines fpe_handler(),
                  int_handler() and install_exc_handler().
Update 30/03/2000 R. Wilcke (wilcke@esrf.fr)
                  get_term_line(): when getting "Enter", set the cursor position
                  to the end of the terminal line;
                  add function end_menu() to clean up the screen handling for
                  for CURSES when exiting.
Update 28/03/2000 R. Wilcke (wilcke@esrf.fr)
                  for UNIX and __CYGWIN__, when using CURSES use the symbolic
                  constants LINES and COLS to get ROWS and COLUMNS.
Update 28/03/2000 R. Wilcke (wilcke@esrf.fr)
                  define key input macros for MSDOS and OS/2;
                  define macros ENTERKEY and BACKSKEY;
                  get_term_line(): replace absolute numbers in "switch" by
                  key input macros, ENTERKEY and BACKSKEY;
                  get_term_line(): restructure the logic in the "TERMBUFFER"
                  part and modify the code to make it also work for CURSES; 
                  init_menu(): add calls to set the terminal correctly up:
                  cbreak(); noecho(); nodelay(win,FALSE); keypad(win,TRUE).
Update 24/03/2000 R. Wilcke (wilcke@esrf.fr)
                  change macro LINES for size of terminal editing buffer to
                  BUFLINES because of conflict with environment variable LINES;
                  get_columns(): for UNIX and __CYGWIN__, restrict width of
                  screen to <= MAXCOLUMNS;
                  get_term_line(): replace "10" by BUFLINES in handling of the
                  buffer "old_term_line".
Update 23/03/2000 R. Wilcke (wilcke@esrf.fr)
                  make "win" a global variable (for UNIX and __CYGWIN__);
                  get_cursor_position(): use the CURSES getyx() macro for UNIX
                  and __CYGWIN__;
                  cursor_big(): use CURSES curs_set() function for UNIX and
                  __CYGWIN__.
Update 22/03/2000 R. Wilcke (wilcke@esrf.fr)
                  init_menu(): test for TERM environment variable and set to
                  "vt100" if not defined or if defined as "cygwin";
                  changed the preprocessor constructs
                  #if (defined(UNIX)||defined(NT_GCC))
                  to
                  #if defined(READLINE)
                  as there is now the possibility of using CURSES without
                  "readline" on UNIX and __CYGWIN__;
                  remove definition of NT_GCC (no longer needed);
                  set_cursor_position(): use the CURSES move() and refresh()
                  functions for UNIX and __CYGWIN__.
Update 20/03/2000 R. Wilcke (wilcke@esrf.fr)
                  for UNIX and __CYGWIN__, replace the ANSI video sequence
                  definitions by the corresponding ones for CURSES;
                  video_highlight(), video_normal(), video_message(),
                  video_query(), video_trace(), video_reverse(): use CURSES
                  bkgdset() function to set attributes for UNIX and __CYGWIN__;
                  get_token(): output the end-of-line ("\n") after the
                  video_normal() call (will be ignored by CURSES otherwise);
                  BEEP macro: use CURSES beep() function for UNIX and
                  __CYGWIN__;
                  get_term_line(): use CURSES function getstr() for UNIX and
                  __CYGWIN__ when not using readline();
Update 17/03/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced test for "defined(CYGWIN)" by "defined(__CYGWIN__)";
                  include <curses.h> and <unistd.h> for UNIX and __CYGWIN__;
                  declare functions get_columns() and get_rows() also for UNIX
                  and __CYGWIN__;
                  get_columns() and get_rows(): treat __CYGWIN__ like UNIX,
                  but set default number of rows = 25 for __CYGWIN__;
                  remove references to "defined(NT)", treat this as a special
                  case of the "__CYGWIN__" environment;
                  get_token(): replace printf() for output of arithmetical
                  calculation by sprintf() and type_line();
                  opsys(): replace printf() for output of shell type by
                  sprintf() and type_line();
                  yyerror(): replace printf() for error output by sprintf()
                  and type_line();
                  add function init_menu() to initialize the screen handling
                  for CURSES;
                  clear_screen(): use the CURSES clear() function for UNIX and
                  __CYGWIN__;
                  set_cursor(): use the CURSES move() and refresh() functions
                  for UNIX and __CYGWIN__;
                  type_line(): use the CURSES printw() and refresh() functions
                  for UNIX and __CYGWIN__;
*/

/***************************************************************************/
/*  Define operating system used					   */
/***************************************************************************/

  /* The operating system define should be put in the Makefile */

  /* #define MSDOS     */   /* Program running on PC under MSDOS */
  /* #define DLL       */   /* make Dynamic Link Library */
  /* #define __APPLE__ */   /* Program running on Macintosh with MACOSX */
  /* #define __unix    */   /* Program running on UNIX systems, including */
                            /* CYGNUS / GNU */

/***************************************************************************/
/*  Define global preprocessor macros                                      */
/***************************************************************************/

#if (defined(MSDOS) || (defined(__unix) || defined(__APPLE__)) && \
   !defined(READLINE))
#define TERMBUFFER		/* Use buffer for terminal input */
#endif /* MSDOS  || (__unix || __APPLE__) && !READLINE */

/***************************************************************************/
/*  Declare include files                                                  */
/***************************************************************************/

#ifdef DLL
#define EXPORT _export
#else
#define EXPORT
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#ifdef	MSDOS
#include <dos.h>
#endif

#if (defined(MSDOS))
#include <conio.h>
#include <signal.h>
#include <float.h>
#include <memory.h>
#include <menu.h>
#endif

#if (defined(__unix) || defined(__APPLE__))
#include <signal.h>
#include <float.h>
#include <memory.h>
#include <menu.h> 
#if defined(TERMBUFFER)
#include <curses.h>
#include <unistd.h>
#else
#include "readline/readline.h"
//#include "readline/history.h"
#endif /* TERMBUFFER */
#endif /* (defined(__unix) || defined(__APPLE__)) */
/***************************************************************************/
/*  Define ANSI video sequences        					   */
/***************************************************************************/

#if defined (MSDOS)

#define VIDEO_REVERSE      "\033[0;1;31;40m"   /* for errors: red on black */
#define VIDEO_HIGHLIGHT    "\033[0;1;33;40m"   /* yellow highlight */
#define VIDEO_TRACE        "\033[0;1;36;40m"   /* cyan debug mode */
#define VIDEO_CLIQUERY     "\033[0;1;32;40m"   /* light green query attribute */
#define VIDEO_CLIMESSAGE   "\033[0;1;35;40m"   /* light magenta messages */
#define VIDEO_NORMAL       "\033[0;1;37;40m"   /* white on black */

#elif ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
/*
Use CURSES video attributes for __unix.
*/

#define VIDEO_REVERSE       A_REVERSE           /* reverse video attribute */
#define VIDEO_HIGHLIGHT     A_STANDOUT          /* intensive video attribute */
#define VIDEO_TRACE         VIDEO_HIGHLIGHT     /* debug mode attribute */
#define VIDEO_CLIQUERY      VIDEO_HIGHLIGHT     /* CLI query attribute */
#define VIDEO_CLIMESSAGE    VIDEO_HIGHLIGHT     /* CLI message attribute */
#define VIDEO_NORMAL        A_NORMAL            /* turn attributes off */

#else

#define VIDEO_REVERSE       "\033[0;7m"         /* reverse video attribute */
#define VIDEO_HIGHLIGHT     "\033[0;1m"         /* intensive video attribute */
#define VIDEO_TRACE         VIDEO_HIGHLIGHT     /* debug mode attribute */
#define VIDEO_CLIQUERY      VIDEO_HIGHLIGHT     /* CLI query attribute */
#define VIDEO_CLIMESSAGE    VIDEO_HIGHLIGHT     /* CLI message attribute */
#define VIDEO_NORMAL        "\033[0m"           /* turn attributes off */

#endif /* defined (MSDOS) */

/***************************************************************************/
/*  Define sound macro             					   */
/***************************************************************************/

#if defined(MSDOS) && defined(__BORLANDC__)
#define BEEP sound(2000);delay(30);nosound()    /* neat beep */

#elif ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
/*
Use CURSES beep() function for __unix.
*/
#define BEEP beep();

#else
#define BEEP type_line("\a")
#endif /* defined(MSDOS) && defined(__BORLANDC__) */

/***************************************************************************/
/*  Define input key macros            					   */
/***************************************************************************/

#if defined (MSDOS)

#define KEYOFFST 256

#define KEY_HOME  71 + KEYOFFST            /*  HOME key        */
#define KEY_UP    72 + KEYOFFST            /*  UP ARROW key    */
#define KEY_DOWN  80 + KEYOFFST            /*  DOWN ARROW key  */
#define KEY_LEFT  75 + KEYOFFST            /*  LEFT ARROW key  */
#define KEY_RIGHT 77 + KEYOFFST            /*  RIGHT ARROW key */
#define KEY_END   79 + KEYOFFST            /*  END key         */
#define KEY_IC    82 + KEYOFFST            /*  INSERT key      */
#define KEY_DC    83 + KEYOFFST            /*  DELETE key      */

#define ENTERKEY  13                       /*  ENTER key       */
#define BACKSKEY   8                       /*  BACKSPACE key   */

#elif ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
/*
 * For __unix, the KEY_* macros are defined by CURSES.
 * If READLINE is used, the macros are not needed.
 */

#define ENTERKEY  10             /*  ENTER key       */
#define BACKSKEY   8             /*  BACKSPACE key   */

#endif /* defined (MSDOS) */

/***************************************************************************/
/*  Exception handling definitions     					   */
/***************************************************************************/

#if !defined(_USERENTRY)
#if defined(__unix) || defined(__APPLE__)
typedef	void (*EXC_HND_F)(int);
#else
typedef void (cdecl *EXC_HND_F) (int);
#endif /* defined(__unix) || defined(__APPLE__) */
#else
typedef	void (_USERENTRY *EXC_HND_F) (int);
#endif /* !defined(_USERENTRY) */
EXC_HND_F	SAVED_FPE_HANDLER;
EXC_HND_F	SAVED_INT_HANDLER;
JMPBUF_TYPE 	FPE_JUMPADDR;
JMPBUF_TYPE	INT_JUMPADDR;

void fpe_handler(int sig);
void int_handler(int sig);

/***************************************************************************/
/*  Define global variables                                                */
/***************************************************************************/

/* General parameters */

char * GLOBAL_PROMPT;

static char *line_read = (char *) NULL; 

#define BUFLINES	30	/* Number of lines to remember */
#define MAXCOLUMN	132	/* Maximum screen width */

/*  Globals defining input buffer   */

#define MLINE_LENGTH 32768       /* length of input buffer */
#define TOK_LENGTH  1001         /* length of input token */

char    MLINE[MLINE_LENGTH];    /* command line input buffer */
int     MLINEPTR = 0;           /* current position in input buffer */
int     MLINEEND = 0;           /* last character in input buffer */

/* Parameters for running macro files */

typedef struct _MACRO {
    FILE 	*file;
    char        filename[FILENAME_MAX];
    char 	saveline[MLINE_LENGTH];
    struct 	_MACRO *root;
    } MACRO,*PMACRO;

PMACRO PACTIVE_MACRO = NULL;	/* active macro file */

/* Standard output file */

FILE		*OUTPUTFILE = NULL;
unsigned        OUTPUT2TERMINAL = TRUE;

/* Buffer used in sprintf (saves a declaration everywhere) */

char    MSTRING[1024];

#if defined(TERMBUFFER) && (defined(__unix) || defined(__APPLE__))
WINDOW *win;
#endif /* defined(TERMBUFFER) && (defined(__unix) || defined(__APPLE__)) */

int     SCREENON = TRUE;        /* Flag to denote screen output on/off */
int	TRACEON  = FALSE;       /* Flag for tracing lines in macro files */
int	SCROLACT;		/* The actual size of the scroll window */

/* pointer to journal file */
FILE * journal_file;
int IGNORE_MACRO_ERRORS=FALSE;
/* text attributes: */

/***************************************************************************/
/*     internal functions:						   */
/***************************************************************************/
void    cli_message(char *message);
void    video_message(void);
void    video_query(void);
void    video_trace(void);

/***************************************************************************/
/************** end of menu.c headers         ******************************/
/***************************************************************************/

int yyerror (char*);
char * yyInput;

float returned_real;

%}
%union {
  double     val;  /* For returning numbers.                   */
  symrec  *tptr;   /* For returning symbol-table pointers      */
}
     
%token <val>  NUM        /* Simple double precision number   */
%token <tptr> VAR FNCT   /* Variable and Function            */
%type  <val>  exp

%token PLUSPLUS MINUSMINUS
%right PLUSEQUALS MINUSEQUALS TIMESEQUALS DIVEQUALS   
%right ','
%right '='
%left '-' '+'
%left '*' '/'
%left NEG     /* Negation--unary minus */
%right '^'    /* Exponentiation        */
     
/* Grammar follows */
     
     %%
/* input:  */
/* | input line */
/* ; */
     
/* '\n' | */

line: exp   { /* printf ("\t Yes!!! %.10g\n", $1);*/ returned_real=$1; }
| error  { yyerror; YYABORT; }
;

exp:      NUM         { $$ = $1;                         }
| exp ',' exp         { $$ = $3;                         }
| VAR                 { $$ = $1->value.var;              }
| VAR '=' exp         { $$ = $3; $1->value.var = $3;     }
| VAR TIMESEQUALS exp { $$ = $1->value.var*$3; $1->value.var = $3*$1->value.var;     }
| VAR PLUSEQUALS exp  { $$ = $1->value.var+$3; $1->value.var = $3+$1->value.var;     }
| VAR MINUSEQUALS exp { $$ = $1->value.var-$3; $1->value.var = $1->value.var-$3;     }
| VAR DIVEQUALS exp   { $$ = $1->value.var/$3; $1->value.var = $1->value.var/$3;     }
| VAR PLUSPLUS        { $$ = $1->value.var++; }
| VAR MINUSMINUS      { $$ = $1->value.var--;     }
| PLUSPLUS VAR        { $$ = ++$2->value.var;     }
| MINUSMINUS VAR      { $$ = --$2->value.var;     }
| FNCT '(' exp ')'    { $$ = (*($1->value.fnctptr))($3); }
| exp '+' exp         { $$ = $1 + $3;                    }
| exp '-' exp         { $$ = $1 - $3;                    }
| exp '*' exp         { $$ = $1 * $3;                    }
| exp '/' exp         { $$ = $1 / $3;                    }
| '-' exp  %prec NEG  { $$ = -$2;                        }
| exp '^' exp         { $$ = pow ($1, $3);               }
| '(' exp ')'         { $$ = $2;                         }
;
/* End of grammar */
%%
#include <stdio.h>

#define YYMENU
/***************************************************************************/
/***************************************************************************/
/*                            Here is the original menu.c                  */
/*                   minus some header stuff which is at the top           */
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                      menu.c                         $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

    /*
    Set of subroutines for menu-driven programs, including:
    - command interpreters
    - input/output functions
    - file extension manipulation
    - capability to run a macro file

    Written by: Elias Vlieg
		AT&T Bell Laboratories
		510E Brookhaven National Laboratory
		Upton, NY 11973

    Last patch: bug fix on opsys() subroutine  		  06-nov-92
		adapted for OS/2, cleaned up cursor stuff 26-jan-94
		nested macro files feature		  27-jan-94
		CLI messages, debug (trace) mode          30-jan-94

    */


/***************************************************************************/
int EXPORT init_menu(void)
/***************************************************************************/

    /*
    Initialize the screen handling. This is at present mainly for CURSES, but
    could be used for other screen handling packages as well.
    */

    {
    char *terminfo,*termtype;
    char buffer[80],buftmp[80];
    FILE *syspipe;

    /*
     * CURSES is only used on __unix, and only if TERMBUFFER editing is used
     * (not "readline").
     */
#if defined(TERMBUFFER)
#if (defined(__unix) || defined(__APPLE__))
    /*
     * For __CYGWIN__, we have to define the location of the terminfo database
     * and set the terminal type, if needed.
     *
     * For the terminfo database, the following search strategy is used:
     * - if the environment variable TERMINFO is defined, this directory is
     *   used;
     * - otherwise, if PGPLOT_DIR is defined, this directory is used;
     * - otherwise the terminfo database is looked for in the present directory;
     * - if this all fails, an error message is printed and the program exits. 
     *
     * The terminal type is defined as follows:
     * - if the environment variable TERM is defined and is not set to "cygwin",
     *   this value is used;
     * - otherwise TERM is set to "linux" and put into the environment.
     */
#if defined(__CYGWIN__)
    termtype = getenv("TERM");
    if(termtype == NULL || !strcmp(termtype,"cygwin"))
        putenv("TERM=linux");
    /*
    printf("TERM: %s\n",termtype);
    */
    if((terminfo = getenv("TERMINFO")) == NULL)
    {
	/*
        printf("TERMINFO not defined\n");
	*/
        if((terminfo = getenv("PGPLOT_DIR")) == NULL)
        {
	    /*
            printf("PGPLOT_DIR not defined\n");
	    */
            if(access("terminfo",F_OK) == 0)
            {
                getcwd(buffer,80);
		/*
                printf("local terminfo directory found\n");
		*/
            }
            else
            {
                printf("no terminfo directory found, exit\n");
                exit(1);
            }
        }
        else
        {
	    /*
            printf("PGPLOT_DIR defined: %s\n",terminfo);
	    */
            strcpy(buffer,terminfo);
        }
        terminfo = strcat(buffer,"/terminfo");
        strcpy(buftmp,"TERMINFO=");
        terminfo = strcat(buftmp,terminfo);
	/*
        printf("TERMINFO: %s\n",terminfo);
        */
        putenv(terminfo);
    }
/*
    else
        printf("TERMINFO defined\n");

    sleep(2);
*/

#endif /* __CYGWIN__ */

#if defined(__unix) || defined(__APPLE__)
    /*
     * Get the size of the terminal and put the corresponding values for
     * LINES and COLUMNS in the environment.
     *
     * The "resize" command returns 3 lines of the form
     *    COLUMNS=80;
     *    LINES=24;
     *    export COLUMNS LINES;
     *
     * Get the lines with the equal sign (=) and put them without the 
     * trailing semicolon (;) into the environment.
     */
    syspipe = popen("resize","r");
    while(fgets(buffer,sizeof(buffer),syspipe) != NULL)
	if(strchr(buffer,'=') != NULL)
	    putenv(strtok(buffer,";"));
    pclose(syspipe);
#endif /* defined(__unix) */

    win=initscr();
    /*
     * Terminal setup:
     * - put terminal in "raw" mode (return every input character immediately
     *   without waiting for end-of-line, and pass interrupt, quit, suspend and
     *   flow control characters uninterpreted through to the application);
     * - do not echo input characters;
     * - wait indefinitely for input;
     * - return CURSES-defined token values for function keys (e.g. for "Home");
     * - enable scrolling (calls to idlok() and scrollok()).
     */
/*
    nonl();
    raw();
*/
    cbreak();
    noecho();
    nodelay(win,FALSE);
    keypad(win,TRUE);
    idlok(win,1);
    refresh();
    scrollok(win,1);
#endif /* (defined(__unix) || defined(__APPLE__)) */
#endif /* defined(TERMBUFFER) */

    return(0);
    }

/***************************************************************************/
int EXPORT end_menu(void)
/***************************************************************************/

    /*
    Clean up the screen handling for CURSES when exiting.
    */

    {
    /*
     * CURSES is only used on __unix, and only if TERMBUFFER editing is used
     * (not "readline").
     */
#if defined(TERMBUFFER)
#if (defined(__unix) || defined(__APPLE__))
    refresh();
    return(endwin());
#endif /* (defined(__unix) || defined(__APPLE__)) */
#endif /* defined(TERMBUFFER) */

    return(0);
    }

/***************************************************************************/
void EXPORT add_extension(char filename[], char extension[])
/***************************************************************************/

    /*
    If 'filename' has no extension then add 'extension', else do nothing.
    */

    {

    int i = 0, j = 0;

    /* Find out whether filename has an extension. */

    while ((filename[i] != '.') && (filename[i] != '\0')) i++;

    /* return if filename has extension */

    if (filename[i] == '.') return;

    filename[i] = '.';
    i++;
    do
	{
	filename[i] = extension[j];
	i++;
	j++;
	}
    while (extension[j-1] != '\0');
    }

/***************************************************************************/
void    EXPORT clear_command(void)
/***************************************************************************/

    /*
    Reset input buffer "MLINE"
    */

    {
    MLINE[0] = '\0';
    MLINEPTR = MLINEEND = 0;
    }

/***************************************************************************/
void    EXPORT clear_screen(void)
/***************************************************************************/

    /*
    Erase screen, set cursor at home position.
    */

    {
    video_normal();
#if ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    /*
    Use CURSES "clear()" for __unix.
    */
    if(SCREENON) clear();
#else
    /*
    This escape sequence works for MSDOS.
    */
    if(SCREENON) printf("\33[2J\33[u");
#endif /* ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE)) */
    }

/***************************************************************************/
void  cli_message(char *message)
/***************************************************************************/

    /*
    print Command Line Interpreter message
    */

    {
    video_message();
    type_line("CLI: ");
    type_line(message);
    video_normal();
    type_line("\n");
    }

/***************************************************************************/
int    EXPORT close_macro(void)
/***************************************************************************/

    /*
    If macro file is open, close it.

    Also restore contents of saveline in MLINE, return:
	0       if nothing in saveline,
	1       if something in saveline.
    */

    {

    PMACRO root;
    int	   ret_code=0;

    if(PACTIVE_MACRO != NULL)	/* macro file active ? */
	{
	if(SCREENON)
	    {
	    sprintf(MSTRING, "Closing macro file \"%s\"",
	       PACTIVE_MACRO->filename);
	    cli_message(MSTRING);
	    }
	fclose(PACTIVE_MACRO->file);
	ret_code = restore_line(PACTIVE_MACRO->saveline);
	root = PACTIVE_MACRO->root;
	free(PACTIVE_MACRO);
	PACTIVE_MACRO = root;
	if((PACTIVE_MACRO != NULL) && SCREENON)
	    {
	    sprintf(MSTRING,"Returning to macro file \"%s\"",
		PACTIVE_MACRO->filename);
	    cli_message(MSTRING);
	    }
	}
    return(ret_code);
    }

/***************************************************************************/
int EXPORT cmnd_match(char command[], struct MENU menu[], int menu_length)
/***************************************************************************/
    /*
    Compares the string in 'command' with the items in the menu. Returns:
	- return-number of command if match found
	- 0 if no match found
	- -1 if more than one match found
    */

    {
    return(cmnd_match_err(command,menu,menu_length,TRUE));
    }

/***************************************************************************/
int EXPORT cmnd_match_err(char command[],struct MENU menu[],int menu_length,
    int err_flag)
/***************************************************************************/
    /*
    Compares the string in 'command' with the items in the menu. Returns:
	- return-number of command if match found
	- 0 if no match found
	- -1 if more than one match found
    Depending on err_flag, error messages are displayed or not
    */

    {

    int i;
    int clength;    /* number of chars in command */
    int nmatch;     /* number of matching commands */
    int cnumber;    /* "serial" number of matching command */
    static char tmpcmd[CMND_LENGTH];

    /* Check length of command */

    clength = strlen(command);
    if((clength < 1) || (clength > CMND_LENGTH-1))
	{
	return(0);
	}

    /* Copy command in lowercase to a temporary buffer. */

    for(i = 0; i < clength; i++)
	{
	tmpcmd[i] = tolower(command[i]);
	}

    /* Search for a match with the lowercase input command. */

    nmatch = 0;
    for(i = 0; i < menu_length; i++)
	{
	/* only check if there are enough characters supplied */
	if(clength >= menu[i].SIGNIF_CHAR)
	    {
	    if(!strncmp(tmpcmd,menu[i].COMMAND,clength))
		{
		nmatch += 1;
		cnumber = i;
		}
	    }
	}

    /* return appropriate number */

    if(nmatch == 0)        /* no match */
	{
	if(err_flag == TRUE)
	    {
	    sprintf(MSTRING,"ERROR, command \"%s\" not recognized",command);
	    errtype(MSTRING);
	    if(MLINE[MLINEPTR])
		{
		sprintf(MSTRING,"Ignoring remainder of line \"",
		    MLINE[MLINEPTR]);
		strncat(MSTRING, MLINE, 20);
		if(strlen(MLINE) > 20)
		    strcat(MSTRING, "...\"");
		else
		    strcat(MSTRING, "\"");
		cli_message(MSTRING);
		clear_command();
		}
	    }
	return(0);
	}
    else if(nmatch == 1)   /* one match found */
	{
	return(menu[cnumber].RET_NR);
	}
    else                    /* more than one match found */
	{
	if(err_flag == TRUE)
	    {
	    if(MLINE[MLINEPTR])
		{
		sprintf(MSTRING,"Ignoring remainder of line \"",
		    MLINE[MLINEPTR]);
		strncat(MSTRING, MLINE, 20);
		if(strlen(MLINE) > 20)
		    strcat(MSTRING, "...\"");
		else
		    strcat(MSTRING, "\"");
		cli_message(MSTRING);
		clear_command();
		}
	    sprintf(MSTRING,"WARNING, ambiguous command \"%s\"",command);
	    errtype(MSTRING);
	    }
	return(-1);
	}
    }

/***************************************************************************/
void    EXPORT del_extension(char filename[])
/***************************************************************************/

    /*
    Delete extension from 'filename.
    */

    {

    int i = 0;

    while ((filename[i] != '.') && (filename[i] != '\0')) i++;
    filename[i] = '\0';
    }

/***************************************************************************/
void    EXPORT errtype(char message[])
/***************************************************************************/

    /*
    Type error message to screen
    */

    {

    char   errstring[2000], prompt[300];
       
    int    terminate;
    PMACRO pactive_macro;


    if (!SCREENON) return;

    sprintf(errstring,"%s",message);
    video_reverse();
    type_line(errstring);
    video_normal();
    type_line("\n");
    BEEP;

    /* if journal file is open, record the output but commented out */
    if (journal_file) fprintf(journal_file,"! %s\n",errstring);
    fflush(journal_file);

    if (PACTIVE_MACRO != NULL)
	{
	pactive_macro = PACTIVE_MACRO; /* save global pointer */
	PACTIVE_MACRO = NULL;          /* make sure user replies */

	clear_command();
	video_query();
	if(!IGNORE_MACRO_ERRORS){
	  sprintf(prompt, "Terminate macro file \"%s\" (%s)? ",
		  pactive_macro->filename, yesnostr(FALSE));
	  terminate = yesno(FALSE, prompt);
	  video_normal();
	}
	else{
	  terminate=FALSE;
	    }
	PACTIVE_MACRO = pactive_macro; /* restore global pointer */

	if (terminate == TRUE)
	    {
	    SCREENON = FALSE;
	    while (PACTIVE_MACRO != NULL) close_macro();
	    SCREENON = TRUE;
	    }
	}
    }

/***************************************************************************/
void    get_extension(char filename[], char extension[])
/***************************************************************************/

    /*
    Finds extension in 'filename' and puts result in 'extension'.
    The '.' is not included in the extension.
    */

    {

    int i = 0, j = 0;

    /* Search for '.' in filename */

    while ((filename[i] != '.') && (filename[i] != '\0')) i++;

    if (filename[i] == '\0') /* No extension in filename */
	{
	extension[0] = '\0';
	}
    else
	{
	i++;    /* Skip the '.' */
	do
	    {
	    extension[j] = filename[i];
	    j++;
	    i++;
	    }
	while (filename[i-1] != '\0');
	}

    }


/***************************************************************************/
int EXPORT get_int(int dflt, char prompt[])
/***************************************************************************/
    /*
    Get the next argument from the input MLINE and convert it to int.
    If no argument is present, return the default value. If an illegal
    argument is passed, reset the input MLINE and read a new value.
    */

    {

    int     value;
#ifdef YYMENU
    double   fvalue;
#endif
    char    testchar;    /* Used to trap typing errors */
    char    token[TOK_LENGTH];

    /* sscanf reads an int until the first non-valid character. In
    order to trap typing errors try to read a test character after the
    int. If this is succesfull, there was more in the token and a
    typing error was presumably made. */

    while(TRUE)    /* stay in loop until correct value read in */
	{
	if(get_token(token,prompt))
	    {
#ifdef YYMENU
/* 	      printf("token is:.%s.\n",token); */
	    if(!yy_get_real(token,&fvalue))
		{
		return(fvalue);
		}
#else
	    if(sscanf(token,"%d%c",&value,&testchar) == 1)
		{
		return(value);
		}
#endif
	    else
		{
		errtype("ERROR, illegal int value");
		clear_command();
		}
	    }
	else        /* no token on input MLINE, return default value */
	    {
	    return(dflt);
	    }
	}

    }

/***************************************************************************/
double  EXPORT get_real(double dflt, char prompt[])
/***************************************************************************/
    /*
    Get a real (i.e float or double) value. The next argument in the
    input MLINE is converted to a double. If no argument is present,
    return the default value. If an illegal argument is passed, reset
    the input MLINE and read a new value.
    The return value is a double, which is converted to float in the
    calling function if it is assigned to a float.
    */

    {

    double  value;
    char    testchar;    /* Used to trap typing errors */
    char    token[TOK_LENGTH];

    /* sscanf reads a double until the first non-valid character. In
    order to trap typing errors try to read a test-character after the
    double. If this is succesfull, there was more in the token and a
    typing error was presumably made. */

    while(TRUE)    /* stay in loop until correct value read in */
	{
	if(get_token(token,prompt))
	    {
#ifdef YYMENU
/* 	      printf("token is:.%s.\n",token); */
	    if(!yy_get_real(token,&value))
		{
		return(value);
		}
#else
	    if(sscanf(token,"%lf%c",&value,&testchar) == 1)
		{
		return(value);
		}
#endif
	    else
		{
		errtype("ERROR, illegal value");
		clear_command();
		}
	    }
	else        /* no token on input MLINE, return default value */
	    {
	    return(dflt);
	    }
	}
    }

/***************************************************************************/
void    EXPORT get_string(char string[], char prompt[])
/***************************************************************************/
    /*
    Read a string from the input line. If input buffer is empty, then all
    of the input after the prompt is assumed to be part of the string.
    Otherwise, the next token is assigned to the string (either one word
    or a sequence of words enclosed in quotes).
    */

    {

    while(TRUE)
	{
	if(MLINEPTR == MLINEEND)
	    {
#if defined(READLINE)
	    GLOBAL_PROMPT = prompt;
#else
	    sprintf(MSTRING,"%s",prompt);
	    type_line(MSTRING);
#endif
	    get_term_line(string);
	    maths_in_token(string);
	    return;
	    }
	else
	    {
	    if(get_token(string,prompt) == 1)
                {
	        maths_in_token(string);
	        return;
	        }
	    }
	}
    }

/***************************************************************************/
void    EXPORT get_dstring(char string[], char dflt[], char prompt[])
/***************************************************************************/
    /*
    Read a string from the input line. If no input on line, return
    default string.
    */

    {

    int i = 0;
    int flag = 0;

    while(TRUE)
	{
	flag = get_token(string,prompt);
	if(flag == 1) return;
	if(flag == 0)
	    {
	    do
		{
		string[i] = dflt[i];
		i++;
		}
	    while(dflt[i-1] != '\0');
	    return;
	    }
	}
    }

/***************************************************************************/
int     EXPORT get_token(char token[], char prompt[])
/***************************************************************************/
    /*
    Get next lexical entity from the input MLINE. If MLINE is empty, try
    reading a new one. Then return:
	- -1 if error in token
	-  0 if still nothing on line
	-  1 if lexical entity found.
    Also handle reserved words like DEBUG, NODEBUG, TRON, TROFF

    */

    {

    static first=1;

    enum i_reserved
	{
	i_NULL,
	i_debug,
	i_nodebug,
	i_tron,
	i_troff,
	i_journalon,
	i_journaloff,
	i_ignoremacroerrors,
	i_calc
	};

#define ITEMS i_calc   /* last menu item */

    static struct MENU reserved_menu[ITEMS] =
	{
	"debug",   5, i_debug,     "",
	"nodebug", 7, i_nodebug,   "",
	"tron",    4, i_tron,      "",
	"troff",   5, i_troff,     "",
	"journal", 7, i_journalon, "",
	"jouroff", 7, i_journaloff,"",
	"keepgoing", 6, i_ignoremacroerrors,"",
	"real",    4, i_calc,      ""
	};

    /* local variable declarations */

    int i,done,screenon;
    float a_real;
    char journal_name[100];
    double value;
    
#if defined(READLINE)
    GLOBAL_PROMPT=prompt;
#endif

#ifdef YYMENU
    if(first)
	{
        first=0;
        init_table();
	}
#endif

    /* If input buffer empty, read a new MLINE from macro file or from
    the terminal. In the latter case the prompt is displayed */

    if(MLINEPTR == MLINEEND)
	{
	clear_command();
	if(PACTIVE_MACRO != NULL)
	    {
	    done = FALSE;
	    while(!done)
		{
		if(fgets(MLINE,MLINE_LENGTH,PACTIVE_MACRO->file) == NULL)
		    {
		    /* If no items on line after macro command, display
		    prompt and wait for input */

		    if(!close_macro())
			{
			if(PACTIVE_MACRO == NULL)
			    {
#if !defined(READLINE)
			     /* readline library puts prompt for us */
			    sprintf(MSTRING,"%s",prompt);
			    type_line(MSTRING);
#endif
			    get_term_line(MLINE);
			    MLINEEND = strlen(MLINE);
			    skip_white();
			    done = TRUE;
			    }
			}
		    else
			{
			done = TRUE;	/* still something left in MLINE */
			}
		    }
		else if(MLINE[0] == '!'); /* comment in macro file */
		else    /* replace trailing '\n' by '\0' */
		    {
		    MLINEEND = strlen(MLINE)-1;
		    MLINE[MLINEEND] = '\0';
		    skip_white();
		    done = TRUE;
		    }
		}
	    }
	else
	    {
#if !defined(READLINE)
	      /* readline library puts prompt for us */
	    sprintf(MSTRING,"%s",prompt);
	    type_line(MSTRING);
#endif
	    /* if journal file is open, record the prompt but commented out */
	    if(journal_file) 
		fprintf(journal_file,"! %s\n",prompt);
	    fflush(journal_file);

	    get_term_line(MLINE);
	    MLINEEND = strlen(MLINE);
	    skip_white();
	    }

        /* show line in debug mode, if this comes from a macro file */

	if((PACTIVE_MACRO != NULL) && (TRACEON == TRUE))
	    {
	    screenon=SCREENON;
	    SCREENON=TRUE;
	    video_trace();
	    type_line(MLINE);
	    video_normal();
	    type_line("\n");
	    SCREENON=screenon;
	    }

	}

    /* Return with value 0 if still no input on MLINE */

    if(MLINEPTR == MLINEEND)
	{
	return(0);
	}

    /*
     * If first character is a double quote ("):
     *   The next token is a string which should be read in until the
     *   next double quote. Two adjacent double quotes are interpreted
     *   as one double quote in the string.
     * Otherwise:
     *   Simply read until next white character.
     */

    if(MLINE[MLINEPTR] == '\"')  /* Here the trouble starts */
	{
	MLINEPTR++;
	i = 0;
	done = FALSE;
	while(!done)   /* continue until terminating " found */
	    {
	    while((MLINE[MLINEPTR] != '\"') && (MLINEPTR != MLINEEND))
		{
		token[i] = MLINE[MLINEPTR];
		MLINEPTR++;
		i++;
		}
	    /*
	     * If next char is also a ", then put one " into token and continue.
	     * Otherwise, you are done.
	     */
	    if((MLINEPTR != MLINEEND) && (MLINE[MLINEPTR+1] == '\"'))
		{
		token[i] = MLINE[MLINEPTR];
		MLINEPTR += 2;
		i++;
		}
	    else
		{
		done = TRUE;
		}
	    }
	if(MLINEPTR == MLINEEND) /* end of MLINE reached while looking for " */
	    {
	    errtype ("ERROR, double quote (\") expected");
	    clear_command();
	    token[0] = '\0';
	    return(-1);
	    }
	else
	    {
	    MLINEPTR++;      /* skip the terminating " */
	    }
	token[i] = '\0';
	/* maths_in_token(token); */
	skip_white();
	return(1);
	}
    else    /* Token is not a string, read until next white char */
	{

	/* Check whether a mathematical expression is being evaluated */

	while(MLINE[MLINEPTR] == '$')
	    {
	    i = 0;
	    while((MLINE[MLINEPTR] != ' ') && (MLINE[MLINEPTR] != '\t')
		&& (MLINEPTR != MLINEEND))
		{
		token[i] = MLINE[MLINEPTR];
		MLINEPTR++;
		i++;
		}
	    token[i]='\0';
	    if(yy_get_real(token+1,&value) != 0)
		{
		sprintf(MSTRING,"ERROR could not parse %s\n",token);
		errtype(MSTRING);
		clear_command();
		return(0);
		}
	    skip_white();
	    }
	/*
	 * After evaluating all $ expressions continue to get the next token
	 * as usual
	 */
	i = 0;
	while((MLINE[MLINEPTR] != ' ') && (MLINE[MLINEPTR] != '\t')
	    && (MLINEPTR != MLINEEND))
	    {
	    token[i] = MLINE[MLINEPTR];
	    MLINEPTR++;
	    i++;
	    };
	token[i] = '\0';
	skip_white();

	/* check for reserved words */
	switch(cmnd_match_err(token,reserved_menu,ITEMS,FALSE))
	    {
	    case i_debug:
	    case i_tron:
		TRACEON = TRUE;
		cli_message("DEBUG set ON");
		return(0);
	    case i_nodebug:
	    case i_troff:
		TRACEON = FALSE;
		cli_message("DEBUG set OFF");
		return(0);
	    case i_journalon:
		sprintf(MSTRING,"name of journal file (.jou): ");
		get_string(journal_name,MSTRING);
		add_extension(journal_name,"jou");
		if(journal_file) fclose(journal_file);
		if((journal_file=fopen(journal_name,"w"))==NULL)
		    {
		    sprintf(MSTRING,"Error! Could not open journal file %s\n",
			journal_name);
		    errtype(MSTRING);
		    return(0);
		    }
		else
		    {
		    return(0);
		    }
		return(0);
	    case i_journaloff:
		fclose(journal_file);
		return(0);
	    case i_ignoremacroerrors:
	      sprintf(MSTRING,"Ignore macro errors (%s): ",
		yesnostr(IGNORE_MACRO_ERRORS));
	      IGNORE_MACRO_ERRORS=yesno(IGNORE_MACRO_ERRORS,MSTRING);
	      return(0);
	    case i_calc:
		a_real = get_real(0,"Input a real number expression: ");
		sprintf(MSTRING,"Expression has the value %f\n",a_real);
		type_line(MSTRING);
		return(0);
	    default:
		 return(1);     /* no reserved word, return token */
	    }
	
	}
    }

#undef ITEMS

/***************************************************************************/
void EXPORT maths_in_token(char * string)
/***************************************************************************/

     /* takes a string, scans it for any mathematical expressions
       beginning with a $ and replaces them with the appropriate
       numerical value

       Upon failure, print a warning and leave the string
       unchanged. */
{

  int i;
  int j;
  char expression[MLINE_LENGTH];
  double value;
  char newstring[MLINE_LENGTH];
  char format[MLINE_LENGTH];
  char numstring[50];
  int offset=0;

  i = 0;
  j = 0;
  offset = 0;
  /* just in case string is empty */
  newstring[0] = '\0';

  while(string[i] != '\0')
    {
      if(string[i] == '$')
	{
	  /* check for "$$" and replace it with "$" */
	  if(string[i+1] == '$'){
	    i+=2;
	    sprintf(newstring + offset,"$");
	    offset += 1;
	  }
	  else{
	    i++;
	    /* check for a c-style floating point format number string*/
	    sprintf(format,"%%");
	    j=1;
	    while(isdigit(string[i]) || string[i]=='.'){
	      format[j]=string[i];
	      i++;
	      j++;
	    }
	    
	    format[j]='f';
	    format[++j]='\0';
	    if(TRACEON){
	      sprintf(MSTRING,"format string is:%s\n",format);
	      cli_message(MSTRING);
	    }
	    j=0;
	    while(string[i]!=' ' && string[i]!='$' && string[i]!='\0' &&
		  string[i]!='\n' && string[i]!='\t')
	      {
		expression[j]=string[i];
		i++;
		j++;
	      }
	    expression[j]='\0';
	    if(TRACEON){
	      sprintf(MSTRING,"expression is:%s\n",expression);
	      cli_message(MSTRING);
	    }
	    if(yy_get_real(expression,&value) == 0)
	      {
		//	      if (format[0]!='\0'){
		sprintf(numstring,format,value);
		//}
		//else{
		/* default to float*/
		//sprintf(numstring,"%f",value);
		//}
		sprintf(newstring + offset,"%s",numstring);
		offset += strlen(numstring);
	      }
	    else
	      {
		/* print warning and exit */
		errtype("WARNING could not parse in-string maths\n");
		exit;
	      }
	  }
	}
      else
	{
	  sprintf(newstring+offset,"%c",string[i]);
	  offset++;
	  i++;
	}
    }
  /*
   * If get to here we have successfully parsed all (or no) maths so
   * replace the passed string with the new one
   */
  sprintf(string,newstring);
  exit;
}

/***************************************************************************/
void fpe_handler(int sig)
/***************************************************************************/

    /*
     * Floating point exception handler
     */

    {
    char lftblank[] = "       ";
    char *pwarptxt[] = {
        "An exception has occurred somewhere in the execution of the current\n",
        "command. I cannot recover that command and continue with execution,\n",
        "but I can restart at the main command. Be aware that no cleanup has\n",
        "been performed, we simply jumped back to the beginning of the code.\n",
        "Good Luck.\n\n",
        };
    /*
     * Call "old" handler first.
     */
    if(SAVED_FPE_HANDLER != SIG_ERR && SAVED_FPE_HANDLER != SIG_IGN &&
	SAVED_FPE_HANDLER != SIG_DFL &&
	SAVED_FPE_HANDLER != (EXC_HND_F)fpe_handler)
	{
	signal(SIGFPE,SAVED_FPE_HANDLER);
	raise(sig);
	}

#if !(defined(__unix) || defined(__APPLE__))
    _fpreset();
#endif /* !(defined(__unix) || defined(__APPLE__)) */
    signal(SIGFPE,(EXC_HND_F)fpe_handler);

    video_reverse();
    sprintf(MSTRING,"\nERROR: %s%s%s%s%s%s%s%s%s%s",
        *pwarptxt,lftblank,*(pwarptxt+1),lftblank,*(pwarptxt+2),
        lftblank,*(pwarptxt+3),lftblank,*(pwarptxt+4));
    type_line(MSTRING);
    video_normal();
    BEEP;

    /*
     * Under POSIX, the setjmp() / longjmp() routines are not guaranteed to
     * restore the signal mask, which means that further occurences of signals
     * may be blocked after the first longjmp() call.
     *
     * To restore the signal mask, the sigsetjmp() / siglongjmp() routines
     * should be used under POSIX.
     *
     * For other systems (e.g. MSDOS), the availability of sigsetjmp() /
     * siglongjmp() is not known to us. Keep the old calls for the time being.
     */
#if (defined(__unix) || defined(__APPLE__))
    siglongjmp(FPE_JUMPADDR,TRUE);
#else
    longjmp(FPE_JUMPADDR,TRUE);
#endif /* (defined(__unix) || defined(__APPLE__)) */

    }

/***************************************************************************/
void int_handler(int sig)
/***************************************************************************/

    /*
    Ctrl-C interrupt handler
    */

{
    char token[100];
    char saveline[MLINE_LENGTH];
    char lftblank[] = "            ";
    char *pwarptxt[] = {
        "*********************************************************\n",
        "*                                                       *\n",
        "*             HYPER-SPACE WARP to main menu ...         *\n",
        "*                                                       *\n",
        "*********************************************************\n\n",
        };
    int prompt,stop = 0;
    int	 screenon;
    PMACRO pactive_macro;
    enum i_int_menu { i_zero, i_resume, i_main, i_abort };

    static struct MENU int_menu[i_abort] =
	{
	"resume", 3, i_resume, "Resume current command",
	"main",   1, i_main,   "Goto main menu",
	"abort",  5, i_abort,  "ABORT program"
	};

    /*
     * Call "old" handler first.
     */
    if(SAVED_INT_HANDLER != SIG_ERR && SAVED_INT_HANDLER != SIG_IGN &&
	SAVED_INT_HANDLER != SIG_DFL &&
	SAVED_INT_HANDLER != (EXC_HND_F)int_handler)
	{
	signal(SIGINT,SAVED_INT_HANDLER);
	raise(sig);
	}

    signal(SIGINT,(EXC_HND_F)int_handler);

    pactive_macro = PACTIVE_MACRO; /* save global pointer */
    PACTIVE_MACRO = NULL;          /* make sure user replies */

    save_line(saveline);
    clear_command();

    screenon=SCREENON;
    SCREENON = TRUE;

    type_line("\n");
    video_query();
    list_menu("CTRL-C options",int_menu,i_abort);
    while(!stop)
	{
	while(!get_token(token,"CTRL-C>"));
	switch(prompt=cmnd_match(token,int_menu,i_abort))
	    {
	    case -1:
		break;
	    case i_zero:
		video_query();
		list_menu("CTRL-C options",int_menu,i_abort);
		break;
	    case i_resume:
	    case i_main:
	    case i_abort:
		stop = TRUE;
		break;
	    }
	}

    clear_command();
    video_normal();

    PACTIVE_MACRO=pactive_macro;

    if(prompt==i_abort)
        {
        end_menu();
        exit(2);
        }

    if(prompt==i_resume)
	{
	SCREENON = screenon;
	restore_line(saveline);
	type_line("resuming program execution\n");
	return;
	}


    SCREENON = FALSE;
    while (PACTIVE_MACRO != NULL) close_macro();
    SCREENON = TRUE;

    video_reverse();
    sprintf(MSTRING,"\n%s%s%s%s%s%s%s%s%s%s",
        lftblank,*pwarptxt,lftblank,*(pwarptxt+1),lftblank,*(pwarptxt+2),
        lftblank,*(pwarptxt+3),lftblank,*(pwarptxt+4));
    type_line(MSTRING);
    video_normal();

    /*
     * Under POSIX, the setjmp() / longjmp() routines are not guaranteed to
     * restore the signal mask, which means that further occurences of signals
     * may be blocked after the first longjmp() call.
     *
     * To restore the signal mask, the sigsetjmp() / siglongjmp() routines
     * should be used under POSIX.
     *
     * For other systems (e.g. MSDOS), the availability of sigsetjmp() /
     * siglongjmp() is not known to us. Keep the old calls for the time being.
     */
#if (defined(__unix) || defined(__APPLE__))
    siglongjmp(INT_JUMPADDR,TRUE);
#else
    longjmp(INT_JUMPADDR,TRUE);
#endif /* (defined(__unix) || defined(__APPLE__)) */
}

/***************************************************************************/
int EXPORT install_exc_handler(JMPBUF_TYPE jumpaddr)
/***************************************************************************/

    /*
    This function installs our exception handlers.
    Previously installed handlers are saved.
    Returns :   1 = success
		0 = error
    */

{
    SAVED_FPE_HANDLER = signal(SIGFPE,(EXC_HND_F)fpe_handler);
    if(SAVED_FPE_HANDLER == SIG_ERR) {
	errtype("Error, cannot install float exception handler");
    }
    else
    {
	memcpy(FPE_JUMPADDR,jumpaddr,sizeof(JMPBUF_TYPE));
    }

    SAVED_INT_HANDLER = signal(SIGINT,(EXC_HND_F)int_handler);
    if(SAVED_INT_HANDLER == SIG_ERR) {
	errtype("Error, cannot install Ctrl-C handler");
    }
    else
    {
	memcpy(INT_JUMPADDR,jumpaddr,sizeof(JMPBUF_TYPE));
    }

    return(SAVED_FPE_HANDLER != SIG_ERR && SAVED_INT_HANDLER != SIG_ERR);

}

/***************************************************************************/
void EXPORT list_menu(char title[],struct MENU menu[],int length)
/***************************************************************************/

    /*
    Short version of list_menus.
    */

    {
    list_menus(title,menu,length,ROWS);
    }

/******************************************************************************/
void EXPORT list_menus(char title[],struct MENU menu[],int length,int scrollin)
/******************************************************************************/

    /*
    List the commands and comments of a menu. The characters of the command that
    are needed for a match are displayed in upper case. The number of lines
    available to display the menu is given by the input parameter scrollin, but
    it is then restricted to be at maximum the size set by the last set_scroll()
    call.
    */

    {


    int i,j,k,item,remainder,tlength,start,scroll;
    char    command[CMND_LENGTH];
    char    title_bar[MAXCOLUMN+1];
    char    dummy[10];

    /* Generate title bar: *'s everywhere except the center with the
    title of the menu surrounded by a space */

    scroll = scrollin < SCROLACT ? scrollin : SCROLACT;
    tlength = strlen(title);
    start = (COLUMNS-tlength)/2; /* start postion of menu title in bar */
    for(i = 0; i < start-1; i++)
	{
	title_bar[i] = '*';
	}
    title_bar[i] = ' ';
    i++;
    for(j = 0; j < tlength; j++)
	{
	title_bar[i+j] = title[j];
	}
    title_bar[i+j] = ' ';
    for(i = start+tlength+1; i < COLUMNS-1; i++)
	{
	title_bar[i] = '*';
	}
    title_bar[COLUMNS-1] = '\n';
    title_bar[COLUMNS] = '\0';

    /* List commands and comments. The significant characters of each
    command are displayed in upper case */

    for(k = 0; length-k*(scroll-2) > scroll-2; k++)
	{
	/* clear_screen(); */
	type_line(title_bar);
	for(i = 0; i < scroll-2; i++)
	    {
	    item = k*(scroll-2)+i;
	    for(j = 0; j < menu[item].SIGNIF_CHAR; j++)
		{
		command[j] = toupper(menu[item].COMMAND[j]);
		}
	    for(; j < CMND_LENGTH; j++)
		{
		command[j] = menu[item].COMMAND[j];
		}
	    sprintf(MSTRING," %-*s: %-*s\n",CMND_LENGTH-1,command,
		CMNT_LENGTH-1,menu[item].COMMENT);
	    type_line(MSTRING);
	    }
	/*type_line(title_bar);*/
	if(get_token(dummy,"More, press <return> to continue"))
	    {
	    return;
	    }
	}

    /* Type last page of menu */

    remainder = length-k*(scroll-2);
    if(remainder > 0)
	{
	/*clear_screen();*/
	type_line(title_bar);
	}
    for(i = 0; i < remainder; i++)
	{
	item = length-remainder+i;
	for(j = 0; j < menu[item].SIGNIF_CHAR; j++)
	    {
	    command[j] = toupper(menu[item].COMMAND[j]);
	    }
	for(; j < CMND_LENGTH; j++)
	    {
	    command[j] = menu[item].COMMAND[j];
	    }
	sprintf(MSTRING," %-*s: %-*s\n",CMND_LENGTH-1,command,
	    CMNT_LENGTH-1,menu[item].COMMENT);
	type_line(MSTRING);
	}
	/*type_line(title_bar);*/

    }

/***************************************************************************/
int	EXPORT nomore_commands(void)
/***************************************************************************/

    /*
    See if there are still commands on the command line buffer.
    */

    {
    if (MLINEPTR == MLINEEND) return(TRUE);
    else return(FALSE);
    }

/***************************************************************************/
void EXPORT opsys(void)
/***************************************************************************/
    /*
    Input one command line for the operating system and execute it.
    */
    {

    char command_line[129];
    char *os,*STRING;
    int ic,i = 0;
    int ltot,linc = 200;
    FILE *syspipe;

    STRING = (char *)malloc(linc * sizeof(char));
    ltot = linc;

    get_string(command_line,"OS>");
    if (strlen(command_line) != 0)
        if (os=getenv("SHELLCMD")){
  	    sprintf(STRING,"using %s as shell\n",os);
	    type_line(STRING);
	    sprintf(STRING,"%s %s",os,command_line);
        }
        else
	    strcpy(STRING,command_line);

#if defined(TERMBUFFER) && (defined(__unix) || defined(__APPLE__))
	/*
	 * When using CURSES, the output of the system() call will mess up the
	 * CURSES window. We use popen() with a subsequent getc() to get the
	 * output of the command back into this program, and then write it out
	 * ourselves with type_line().
	 *
	 * It would have been easier to read the command output with fgets() one
	 * line at a time and write each line directly with type_line(), but on
	 * HP-UX fgets() (and getc() as well) return EOF once type_line() has
	 * been called. No idea why! Thus the output from the command is
	 * accumulated into a buffer, and then the buffer is written in one go
	 * by type_line().
         */
	syspipe = popen(command_line,"r");

	/* Loop over the command output. */
	while((ic = getc(syspipe)) != EOF)
	    {
	    STRING[i++] = ic;
	    /*
	     * Watch if the buffer reserved for the command output will
	     * overflow. Reallocate additional buffer space if necessary.
	     */
	    if(i >= ltot)
		{
		ltot += linc;
		STRING = realloc(STRING,ltot * sizeof(char));
		}
	    }
	STRING[i] = 0;
	type_line(STRING);

        pclose(syspipe);
	free(STRING);
#else
	system(STRING);
#endif /* defined(TERMBUFFER) && (defined(__unix) || defined(__APPLE__)) */
    }

/***************************************************************************/
void    EXPORT put_command(char string[])
/***************************************************************************/

    /*
    Write contents of string to input MLINE
    */

    {

    int i,slength;

    /* Clean up MLINE by moving all remaining characters to left */

    if (MLINEPTR != MLINEEND)
	{
	for (i = 0; i <= MLINEEND-MLINEPTR; i++)
	    {
	    MLINE[i] = MLINE[i+MLINEPTR];
	    }
	MLINEEND = MLINEEND-MLINEPTR;
	MLINEPTR = 0;
	}
    else
	{
	clear_command();
	}

    /* Proceed only if string is not empty */

    slength = strlen(string);
    if(slength > 0)
	{
	/*
	 * If there are remaining characters in MLINE, move these towards
	 * right to make space for the string that has to be placed there.
	 * Write a space in front of these characters.
	 * Otherwise, write string terminator at last position.
	 */
	if(MLINEEND > 0)
	    {
	    for(i = MLINEEND; i >= 0; i--)
		{
		MLINE[i+slength+1] = MLINE[i];
		}
	    MLINE[slength] = ' ';
	    }
	else
	    {
	    MLINE[slength] = '\0';
	    }

	/* Put string at leftmost postions in MLINE */

	for(i = 0; i < slength; i++)
	    {
	    MLINE[i] = string[i];
	    }
	if(MLINEEND == 0)
	    MLINEEND = slength;
	else
	    MLINEEND += slength+1;      /* Because of inserted space */
	}

    }

/***************************************************************************/
void    EXPORT replace_extension(char filename[], char extension[])
/***************************************************************************/

    /*
    Replace the extension in 'filename' by 'extension'.
    */

    {

    int i = 0, j = 0;

    /* Put i after the '.', or at last character if no extension. */

    while ((filename[i] != '.') && (filename[i] != '\0')) i++;
    if (filename[i] == '\0') filename[i] = '.';
    i++;

    do
	{
	filename[i] = extension[j];
	i++;
	j++;
	}
    while (extension[j-1] != '\0');
    }

/***************************************************************************/
int    EXPORT restore_line(char *saveline)
/***************************************************************************/

    /*
    Restore contents of saveline in MLINE, return:
	0       if nothing in saveline,
	1       if something in saveline.
    */

    {

    int length;

    length = strlen(saveline);
    if (length == 0)
	{
	return(0);
	}
    else
	{
	sprintf(MLINE,"%s",saveline);
	MLINEPTR = 0;
	MLINEEND = length;
	return(1);
	}

    }


/***************************************************************************/
int     EXPORT run_macro(void)
/***************************************************************************/

    /*
    Open macro file from where the next input is taken. Return:
	1 if successful
	0 if not successful
    */

    {

    FILE    *mac_file;
    char    filename[FILENAME_MAX];
    PMACRO  root;

    /* Get macro filename and open file */

    get_string(filename,"Give name of macro file (.mac): ");
    add_extension(filename,"mac");

/* only __unix knows the difference */
#if !defined(__unix) || defined(__APPLE__)
    strupr(filename);
#endif

    if ((mac_file = fopen(filename,"r")) == NULL)
	{
	sprintf(MSTRING,"Failed to open \"%s\"",filename);
	errtype(MSTRING);
	clear_command();
	return(0);
	}
    else
	{

	if (SCREENON)
	    {
	    if (PACTIVE_MACRO == NULL)
		{
		sprintf(MSTRING, "Opening macro file \"%s\"",
		    filename);
		}
	    else
		{
		sprintf(MSTRING, "Branching to macro file \"%s\"",
		    filename);
		}
	    cli_message(MSTRING);
	    }

	root = PACTIVE_MACRO;	/* save old macro file if any */
 	/*
	 * Allocate memory for new pointer.
	 */
	if(NULL==(PACTIVE_MACRO = malloc(sizeof(MACRO))))
	    {
	    errtype("Cannot allocate memory");
	    clear_command();
	    return(0);
	    }

	PACTIVE_MACRO->root = root;
	PACTIVE_MACRO->file = mac_file;
	strcpy(PACTIVE_MACRO->filename, filename);
	/*
	 * Save possible further tokens for later use.
	 */
	save_line(PACTIVE_MACRO->saveline);
	clear_command();
	return(1);
	}

    }

/***************************************************************************/
void    EXPORT save_line(char *saveline)
/***************************************************************************/

    /*
    Save non-used portion of MLINE in saveline.
    */

    {

    int i;

    i = 0;
    while (MLINE[i+MLINEPTR] != '\0')
	{
	saveline[i] = MLINE[i+MLINEPTR];
	i++;
	}
    saveline[i] = '\0';

    }

/***************************************************************************/
void    EXPORT set_cursor(int column, int row)
/***************************************************************************/

    /*
    Position cursor at given column and row.

    column = 1..80, row = 1..25   in general
    */

    {
    if (!SCREENON) return;

    while (column>COLUMNS)
	{
	column-=COLUMNS;
	row++;
	}
    if (column < 1)
	{
	column=1;
	row--;
	}

    if (row < 1)
	{
	row = 1;
	}

    /*
    ???? Is this correct? What happens if row == ROWS ????
    */
    if (row > ROWS)
	{
	row = ROWS-1;
	}
    /*
     * Use CURSES "move()" for __unix.
     * Note that CURSES counts rows and columns from (0,0).
     *
     * The ANSI escape sequences work for MSDOS.
     *
     * BorlandC's implentation is faster.
     */
#if ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    move(row - 1,column - 1);
    refresh(); 
#elif defined(__BORLANDC__)
    gotoxy(column,row);
#else
    printf("\033[%1d;%1dH",row,column);
#endif /* ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE)) */
    }


/***************************************************************************/
void EXPORT set_output(char *extension)
/***************************************************************************/

    /*
    Prompt user for output file, with terminal as an option.
    Redirect global output to this file.

    Parameter:  extension
                   -  some value like "DAT" will be default extension
                   -  NULL resets output to stdout
    */

{

    char filename[128], string[250];
    FILE *output;

    if (extension == NULL)
        {
        if (OUTPUTFILE != NULL) fclose (OUTPUTFILE);
        OUTPUTFILE = NULL;
        OUTPUT2TERMINAL = TRUE;
        return;
        }

    /* Ask for filename */

    sprintf(string,"Filename (.%s) (type 't' or <return> for terminal): ",
	extension);
    get_string(filename,string);
    if (!filename[0])
	{
	OUTPUT2TERMINAL = TRUE;
	}
    else if (((filename[0] == 't') || (filename[0] == 'T')) &&
	(filename[1] == '\0'))
	{
	OUTPUT2TERMINAL = TRUE;
	}
    else
	{
	add_extension(filename,extension);
	if ((output = fopen(filename,"w")) == NULL)
	    {
            OUTPUT2TERMINAL = TRUE;
            OUTPUTFILE = NULL;
	    sprintf(string,"Error, failed to open '%s'",filename);
	    errtype(string);
	    clear_command();
	    return;
	    }
	else
	    {
	    get_string(string,"Comments: ");
            if (string[0]) fprintf(output,"! %s\n",string);
	    OUTPUT2TERMINAL = FALSE;
            OUTPUTFILE = output;
	    }
	}
}

/***************************************************************************/
void    EXPORT set_scroll(int start_line, int end_line)
/***************************************************************************/

    /*
    Define a scrolling region on the screen.
    */

    {
#if defined(SCROLL)
#if defined(__BORLANDC__)
    window(1,start_line,COLUMNS,end_line);
#elif ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    /*
     * Use CURSES "setscrreg()" for __unix.
     * Note that CURSES counts LINES from 0.
     */
    setscrreg(start_line - 1,end_line - 1);
#else
    start_line; end_line;
#endif /* __BORLANDC__ */
#endif /* defined(SCROLL) */
    SCROLACT = end_line - start_line + 1;
    }

/***************************************************************************/
void    EXPORT skip_white(void)
/***************************************************************************/

    /*
    Set pointer of input MLINE to next non-white character
    */

    {
    while(((MLINE[MLINEPTR] == ' ') || (MLINE[MLINEPTR] == '\t')) &&
	(MLINEPTR != MLINEEND))
	{
	MLINEPTR++;
	}
    }

/***************************************************************************/
void    EXPORT string_tolower(char string[])
/***************************************************************************/

    /*
    Convert string to lower case.
    */

    {
    int i = 0;

    while(string[i] != '\0')
	{
	string[i] = tolower(string[i]);
	i++;
	}
    }

/***************************************************************************/
void    EXPORT type_line(char tline[])
/***************************************************************************/
    /*
    Print line to standard output.
    */

    {

/*
#if defined(__BORLANDC__)

    if(SCREENON) {
        cprintf("%s", tline);
        if (strstr(tline,"\n")) putch('\r');
        }
#else
*/
    if(SCREENON)
        {
#if ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    /*
     * Use CURSES "printw()" and "refresh()" for __unix.
     */
        printw("%s",tline);
        refresh();
#else
        printf("%s",tline);
        fflush(stdout);
#endif /* ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE)) */
        }

    /* if journal file is open, record the output but commented out */
    if (journal_file) fprintf(journal_file,"! %s",tline);
    fflush(journal_file);

/* #endif */

    }

/***************************************************************************/
void    EXPORT type_list(char tline[], int length)
/***************************************************************************/

    /*
    Print line to standard output or output file if opened, but avoid
    typing too many lines on terminal. After 'length' lines, a <return> has
    to be given to continue output.
    When length=0, the routine is initialized.
    */

    {
    static int counter = 0,all = FALSE;
    char	dummy[10];

    if (length == 0)
	{
	counter = 0;
	all = FALSE;
        }
    else if (all) type_line(tline);
    else
	{
	type_line(tline);
	counter++;
	if ((counter == length-1) && (OUTPUTFILE == NULL))
	    {
	    if ((get_token(dummy,"Type <return> to continue ")) != 0)
		all = TRUE;
	    //if (dummy[0] == 'a') all = TRUE;
	    counter = 0;
	    }
	}
    }


/***************************************************************************/
void    EXPORT type_line_no_journal(char tline[])
/***************************************************************************/

    /*
    Print line to standard output but not to journal file.
    Mainly useful for ana header lines.
    */

    {

/*
#if defined(__BORLANDC__)

    if (SCREENON) {
        cprintf("%s", tline);
        if (strstr(tline,"\n")) putch('\r');
        }
#else
*/
    if (SCREENON) printf("%s",tline);
    fflush(stdout);

/* #endif */

    }

/***************************************************************************/
void    EXPORT typeoff(void)
/***************************************************************************/

    /*
    Switch off output to screen.
    */

    {
    SCREENON = FALSE;
    }

/***************************************************************************/
void    EXPORT typeon(void)
/***************************************************************************/

    /*
    Switch on output to screen.
    */

    {
    SCREENON = TRUE;
    }

/***************************************************************************/
void    EXPORT video_highlight(void)
/***************************************************************************/

    /*
    Switch to highlight text mode.
    */

    {
#if ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    /*
     * Use CURSES "bkgdset()" for __unix and __CYGWIN__.
     */
    bkgdset(VIDEO_HIGHLIGHT);
#else
    type_line(VIDEO_HIGHLIGHT);
#endif /* ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE)) */
    }


/***************************************************************************/
void    EXPORT video_normal(void)
/***************************************************************************/

    /*
    Switch to normal text mode.
    */

    {
#if ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    /*
     * For __unix and __CYGWIN__, use CURSES "bkgdset()" to set the window back
     * to normal, and then call clrtoeol() to remove the highlighting from the
     * present line.
     */
    bkgdset(VIDEO_NORMAL);
    clrtoeol();
#else
    type_line(VIDEO_NORMAL);
#endif /* ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE)) */
    }

/***************************************************************************/
void  video_message(void)
/***************************************************************************/

    /*
    Switch to CLI message text mode.
    */

    {
#if ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    /*
     * Use CURSES "bkgdset()" for __unix.
     */
    bkgdset(VIDEO_CLIMESSAGE);
#else
    type_line(VIDEO_CLIMESSAGE);
#endif /* ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE)) */
    }

/***************************************************************************/
void  video_query(void)
/***************************************************************************/

    /*
    Switch to CLI query text mode.
    */

    {
#if ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    /*
     * Use CURSES "bkgdset()" for __unix.
     */
    bkgdset(VIDEO_CLIQUERY);
#else
    type_line(VIDEO_CLIQUERY);
#endif /* ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE)) */
    }

/***************************************************************************/
void  video_trace(void)
/***************************************************************************/

    /*
    Switch to trace (debug) text mode.
    */

    {
#if ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    /*
     * Use CURSES "bkgdset()" for __unix.
     */
    bkgdset(VIDEO_TRACE);
#else
    type_line(VIDEO_TRACE);
#endif /* ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE)) */
    }

/***************************************************************************/
void    EXPORT video_reverse(void)
/***************************************************************************/

    /*
    Switch to reverse text mode.
    */

    {
#if ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE))
    /*
     * Use CURSES "bkgdset()" for __unix.
     */
    bkgdset(VIDEO_REVERSE);
#else
    type_line(VIDEO_REVERSE);
#endif /* ((defined(__unix) || defined(__APPLE__)) && !defined(READLINE)) */
    }


/***************************************************************************/
int     EXPORT yesno(int dflt, char prompt[])
/***************************************************************************/

    /*
    Returns:
	- TRUE if input is some form of YES
	- FALSE if input is some form of NO
	- default value if no input on MLINE.
    Retries if error in input
    */

    {

    static struct MENU yesno_menu[2] =
	{
	"yes",  1,1,"Affirmative answer",
	"no",   1,2,"Negative answer"
	};

    char    token[100];

    while (1)
	{

	/* Return default value if no input on line */

	if (!get_token(token,prompt)) return(dflt);
	switch (cmnd_match(token,yesno_menu,2))
	    {
	    case 0:
		errtype ("Warning: command not recognized");
		break;
	    case 1:
		return(TRUE);
	    case 2:
		return(FALSE);
	    }
	}
    }

/****************************************************************************/
char* EXPORT yesnostr(int flag)
/****************************************************************************/

/*
   returns "YES" if flag == TRUE
   else    "NO"
*/

{

   static char answerstr[2][4] = {"YES","NO"};

   if (flag == TRUE)
	return answerstr[0];
   else
	return answerstr[1];
}

/*
The following subroutines are used to facilitate input on a PC, it enables
one to scroll back to a previously used command line, and to modify it.
For other operating systems, only one line in 'get_term_line' is important.
*/

#ifdef TERMBUFFER
/***************************************************************************/
void    EXPORT cursor_big(int flag)
/***************************************************************************/

    /*
    Set cursor to big for insert mode.
    */

    {
#if (defined(__unix) || defined(__APPLE__))
    /*
     * Use CURSES "curs_set()" function for __unix.
     */
    curs_set(flag ? 2 : 1);

#elif defined(__BORLANDC__)	/* this is what we call a decent compiler */
    _setcursortype(flag ? _SOLIDCURSOR : _NORMALCURSOR);

#else			/* Microsoft deals it more delicately ... */
    union REGS regs;

    regs.h.ah = 1;              /*  select cursor size function  */
    regs.h.cl = 7;              /*  bottom row of cursor  */
    if(flag)
	regs.h.ch = 4;          /*  larger cursor for insert mode  */
    else
	regs.h.ch = 6;          /*  normal cursor  */
    int86 (0x10,&regs,&regs);
#endif
    }

/***************************************************************************/
void    EXPORT get_cursor_position (int *row, int *column)
/***************************************************************************/

    /*
    Get the row and column of current cursor location.
    */

    {
#if (defined(__unix) || defined(__APPLE__))
    /*
     * Use CURSES "getyx()" macro for __unix.
     * Note that CURSES counts rows and columns from (0,0).
     */
    getyx(win,*row,*column);
#elif defined(__BORLANDC__)
    *row = wherey()-1;
    *column = wherex()-1;
#else
    union REGS regs;

    regs.h.ah = 3;             /*  select function  */
    regs.h.bh = 0;             /*  video page number  */
    int86 (0x10, &regs, &regs);
    *row = (int) regs.h.dh;
    *column = (int) regs.h.dl;
#endif
    }

/***************************************************************************/
void    EXPORT set_cursor_position(int row,int col)
/***************************************************************************/

    /*
    Set cursor at specified row and column.
    */

   {
#if !(defined(__unix) || defined(__BORLANDC__) || defined(__APPLE__))
    union REGS regs;
#endif

    if (!SCREENON) return;

    while (col>=COLUMNS)
	{
	col-=COLUMNS;
	row++;
	}
    if (col < 0)
	{
	col=0;
	row--;
	}

    if (row < 0)
	{
	row = 0;
	}

    if (row >= ROWS)
	{
	row = ROWS-1;
	}

    /*
     * Use CURSES "move()" for __unix.
     * Note that CURSES counts rows and columns from (0,0).
     * Borland C's implentation is faster.
     */
#if (defined(__unix) || defined(__APPLE__))
    move(row,col);
    refresh(); 
#elif defined(__BORLANDC__)
    gotoxy(col+1,row+1);
#else
    regs.h.ah = 2;            /*  select function    */
    regs.h.bh = 0;            /*  video page number  */
    regs.h.dh = row;
    regs.h.dl = col;
    int86 (0x10,&regs,&regs);
#endif
    }

#endif /* #ifdef TERMBUFFER */

#ifdef __BORLANDC__
/***************************************************************************/
int     EXPORT get_rows(void)
/***************************************************************************/
    /*
    Get number of rows on screen
    */
    {

    struct text_info ti;

    gettextinfo(&ti);
    return (ti.screenheight);

    }

/***************************************************************************/
int     EXPORT get_columns(void)
/***************************************************************************/
    /*
    Get number of columns on screen
    */
    {

    struct text_info ti;

    gettextinfo(&ti);
    return (ti.screenwidth>MAXCOLUMN ? MAXCOLUMN : ti.screenwidth);

    }

#endif /* #ifdef __BORLANDC__ */

#if (defined(__unix) || defined(__APPLE__))
/***************************************************************************/
int     EXPORT get_rows(void)
/***************************************************************************/

    /*
    Get number of rows on screen
    */

    {
#if defined(TERMBUFFER)
   /*
    * For CURSES, the symbolic constants LINES and COLS are defined.
    */
    return(LINES);
#else
    char *lines;
    if(lines=getenv("LINES"))
        return(atoi(lines));
    else
#if defined(__unix) || defined(__APPLE__)
      return(24);
#else
      return(25);
#endif /* defined(__unix) || defined(__APPLE__) */
#endif /* defined(TERMBUFFER) */
    }

/***************************************************************************/
int     EXPORT get_columns(void)
/***************************************************************************/

    /*
    Get number of columns on screen
    */

    {
#if defined(TERMBUFFER)
   /*
    * For CURSES, the symbolic constants LINES and COLS are defined.
    */
    return(COLS > MAXCOLUMN ? MAXCOLUMN : COLS);
#else
    char *columns;
    int icol;
    if(columns=getenv("COLUMNS"))
	{
        icol = atoi(columns);
        return(icol > MAXCOLUMN ? MAXCOLUMN : icol);
	}
    else
	return(80);
#endif /* defined(TERMBUFFER) */
    }

#endif /* (defined(__unix) || defined(__APPLE__)) */

/***************************************************************************/
void    EXPORT get_term_line(char *term_line)
/***************************************************************************/

    /*
    Input a line from the terminal.
    This subroutine stores several command lines in a buffer, which can
    be recalled and/or modified by using the arrow/edit keys.
    */

    {
#ifdef	TERMBUFFER
    static char old_term_line[BUFLINES][MAXCOLUMN+1];
    static int ocp = 0;    /*  ocp points to next old_term_line to be used  */
    static int last_oc;
    int insert = FALSE;
    int printline = TRUE;
    unsigned char c;
    char last_arrow = '\0';
    char *cursor, *end, *p, *q;
    int len = 0;
    int ic,start_row,start_column;

    end = cursor = term_line;
    get_cursor_position(&start_row,&start_column);
    /*
     *  Reset command line string.
     */
    *cursor = '\0';
    /*
     * Main input loop.
     */
    while(len < COLUMNS - 1)
	{
#if defined (MSDOS)
	while(!kbhit());
        /*
         * Some special keys return a zero first. Do a second getch() to get
         * the key value and add KEYOFFST to mark it as special.
         */
	if((ic = getch()) == 0)
	    ic = getch() + KEYOFFST;
#elif (defined(__unix) || defined(__APPLE__))
	/*
         * CURSES gets the special keys with its own predefined values that
         * are outside the normal character range (0 - 255). Thus they are
         * already marked as special.
         */
	if((ic = getch()) == ERR)
	    ic = -1;
#endif /* defined (MSDOS) */
	c = (char)ic;
	switch(ic)
	    {
	    case 3:                    /*  CTRL-C       */
		int_handler(SIGINT);
		printline = TRUE;
		break;
	    case ENTERKEY:             /*  ENTER        */
	    case KEY_ENTER:
		strcpy(old_term_line[ocp++ % BUFLINES],term_line);
		last_oc = ocp % BUFLINES;
		cursor_big(FALSE);
		set_cursor_position(start_row,start_column+len);
		type_line("\n");
		return;
	    case BACKSKEY:             /*  BACKSPACE    */
	    case KEY_BACKSPACE:
		if(cursor == term_line) break;
		for(p = cursor--, q = cursor; p < end; p++, q++)
		    *q = *p;
		*--end = '\0';
		len--;
		break;
	    case 27:                   /*  ESCAPE       */
		end = cursor = term_line;
		*cursor = '\0';        /*  erase line   */
		len = 0;
		set_cursor_position(start_row,start_column);
		sprintf(MSTRING,"%*s",COLUMNS-start_column-1," ");
		type_line(MSTRING);
		insert = FALSE;
		cursor_big(FALSE);
		break;
	    case KEY_HOME:             /*  HOME         */
		cursor = term_line;
		set_cursor_position(start_row,start_column);
		printline = FALSE;
		break;
	    case KEY_UP:               /*  UP ARROW     */
		if(last_arrow == 'd') last_oc--;
		if(last_oc == 0) last_oc = BUFLINES;
		while(*old_term_line[--last_oc] == '\0')
		    if(last_oc == 0) break;
		strcpy(term_line,old_term_line[last_oc]);
		len = strlen(term_line) / sizeof (char);
		cursor = end = term_line + len;
		set_cursor_position(start_row,start_column);
		/*  erase to end of line  */
		sprintf(MSTRING,"\%*s",COLUMNS-start_column-1," ");
		type_line(MSTRING);
		last_arrow = 'u';
		insert = FALSE;
		cursor_big(FALSE);
		break;
	    case KEY_DOWN:             /*  DOWN ARROW   */
		if(last_arrow == 'u') last_oc++;
		if(last_oc == BUFLINES)
		    last_oc = 0;
		else
		    while(*old_term_line[last_oc++] == '\0')
			if(last_oc == BUFLINES)
			    {
			    last_oc = 0;
			    break;
			    }
		if(last_oc != 0) last_oc--;
		strcpy(term_line,old_term_line[last_oc++]);
		len = strlen(term_line) / sizeof (char);
		cursor = end = term_line + len;
		set_cursor_position(start_row,start_column);
		sprintf(MSTRING,"\%*s",COLUMNS-start_column-1," ");
		type_line(MSTRING);
		last_arrow = 'd';
		insert = FALSE;
		cursor_big(FALSE);
		break;
	    case KEY_LEFT:             /*  LEFT ARROW   */
		cursor--;
		if(cursor < term_line) cursor = term_line;
		set_cursor_position(start_row,cursor-term_line+start_column);
		printline = FALSE;
		break;
	    case KEY_RIGHT:            /*  RIGHT ARROW  */
		cursor++;
		if(cursor > end) cursor = end;
		set_cursor_position(start_row,cursor-term_line+start_column);
		printline = FALSE;
		break;
	    case KEY_END:              /*  END          */
		cursor = end;
		set_cursor_position(start_row,cursor-term_line+start_column);
		printline = FALSE;
		break;
	    case KEY_IC:               /*  INSERT       */
		insert ^= 1;
		cursor_big(insert);
		break;
	    case KEY_DC:               /*  DELETE       */
		if(cursor == end) break;
		for(p = cursor+sizeof(char), q = cursor; p < end; p++, q++)
		    *q = *p;
		*--end = '\0';
		len--;
		break;
	    default:
		if(ic >= 0 && ic <= 255)    /* normal character */
		    {
		    if(!insert)
			{
			if(cursor == end)
			    {
			    len++;
			    *++end = '\0';
			    }
			*cursor++ = c;
			sprintf(MSTRING,"%c",c);
			type_line(MSTRING);
			printline = FALSE;
			}
		    else
			{
			*++end = '\0';
			for(p = end-2*sizeof(char), q = end-sizeof(char);
			    p >= cursor; p--, q--)
			    *q = *p;
			*cursor++ = c;
			len++;
			}
		    }
		else                        /* anything else, give warning */
		    {
		    BEEP;
		    }
	    }   /* End of switch statement */
	if(!printline)
	    {
	    printline = TRUE;
	    }
	else
	    {
	    if(len+start_column > COLUMNS)
		{
		start_column = 0;
		type_line("\n");
		}
	    set_cursor_position(start_row,start_column);

	    /* Print an extra space in case a character was deleted */

	    sprintf(MSTRING,"%s ",term_line);
	    type_line(MSTRING);
	    set_cursor_position(start_row,cursor-term_line+start_column);
	    }
	}
    type_line("\n");
    return;

#elif defined(READLINE)
    /* use the Gnu readline library */
    /*
    if (line_read){
        free (line_read); 
        line_read=(char *) NULL;
    }
    */

    line_read = readline(GLOBAL_PROMPT);
    if(line_read && *line_read)
	add_history(line_read); 

    sprintf(term_line,"%s",line_read);

    /* If journal file is open, record the command. */

    if (journal_file) fprintf(journal_file,"%s\n",term_line);
    fflush(journal_file);

    return;
#else
    gets(term_line);
    return;
#endif /* #ifdef TERMBUFFER */
    }

#ifndef __CYGWIN__ /* __CYGWIN__ version of gcc has these! */

/**********************************************************************/
void strlwr(char string[])
/**********************************************************************/
    /*
    Convert string to lower case.
    */
    {
    string_tolower(string);
    }

/**********************************************************************/
void strupr(char string[])
/**********************************************************************/
    /*
    Convert string to upper case.
    */

    {
    int i = 0;

    while (string[i] != '\0')
        {
	string[i] = toupper(string[i]);
	i++;
        }
    }

#endif

/**********************************************************************/
int yy_get_real(char *string,double* value)
/**********************************************************************/

{
    int error;
    yyInput=string;
    error=yyparse();
    *value = returned_real;
    if(TRACEON){
	sprintf(MSTRING,"Trying to parse \"%s\"\treturned valued was %f\n\n",
	    string,returned_real);
	cli_message(MSTRING);
    }
    return error;
}

#ifdef MENU_MAIN
/**********************************************************************/
main ()
/**********************************************************************/

{
    enum i_main
	{
	i_NULL,
	i_real,
	i_string,
	i_help,
	i_quit
	};

#define ITEMS i_quit   /* last menu item */

    static struct MENU main_menu[ITEMS] =
	{
	"float",  1, i_real,     "Parse a floating point expression",
	"string", 1, i_string,   "Parse maths embedded in a string",
	"help",   1, i_help,     "Print this menu",
	"quit",   4, i_quit,     "Quit"
	};

    /* local variable declarations */

    float a;
    char string[200];
    char token[200];
    int stop=FALSE;


    /* initialization */
    init_table ();
    init_menu();
    set_scroll(1,24);


      while (!stop){
	while(!stop && get_token(token,"REAL>")){
	switch(cmnd_match(token,main_menu,i_quit))
	  {
	  case i_real:
	    a=get_real(0.0,"Enter a floating point expression [0]: ");
	    sprintf(MSTRING,"%f\n",a);
	    type_line(MSTRING);	    
	    break;
	  case i_string:
	    get_string(string,"Enter a string ");
	    type_line(string);
	    type_line("\n");
	    break;
	  case i_help:
	    list_menu("MAIN MENU",main_menu,i_quit);
	    break;
	  case i_quit:
	    stop=TRUE;
	    break;
	    
	  default:
	  }
      }
      }
  end_menu();
}
#endif /* MENU_MAIN */

/**********************************************************************/
yyerror (s)
/**********************************************************************/
    /*
    Called by yyparse on error
    */

    char *s;
    {
    sprintf(MSTRING,"%s\n",s);
    type_line(MSTRING);
    }
     
struct init
{
  char *fname;
  double (*fnct)();
};

struct init arith_fncts[]
= {
  "sin", sin,
  "cos", cos,
  "tan", tan,
  "asin", asin,
  "acos", acos,
  "atan", atan,
  "cosh", cosh, 
  "sinh", sinh, 
  "tanh", tanh, 
  "ceil", ceil, 
  "fabs", fabs, 
  "floor", floor, 
  "fmod", fmod, 
  "log", log, 
  "log10", log10, 
  "ln", log,
  "exp", exp,
  "sqrt", sqrt,
  0, 0
};
     
/* The symbol table: a chain of `struct symrec'.  */
symrec *sym_table = (symrec *)0;

/**********************************************************************/
init_table ()
/**********************************************************************/
    /*
    Puts arithmetic functions in table.
    */

    {
    int i;
    symrec *ptr;
    for (i = 0; arith_fncts[i].fname != 0; i++)
        {
        ptr = putsym (arith_fncts[i].fname, FNCT);
        ptr->value.fnctptr = arith_fncts[i].fnct;
        }
    }

/**********************************************************************/
symrec * putsym (sym_name,sym_type)
/**********************************************************************/

    char *sym_name;
    int sym_type;
    {
    symrec *ptr;
    ptr = (symrec *) malloc (sizeof (symrec));
    ptr->name = (char *) malloc (strlen (sym_name) + 1);
    strcpy (ptr->name,sym_name);
    ptr->type = sym_type;
    ptr->value.var = 0; /* set value to 0 even if fctn.  */
    ptr->next = (struct symrec *)sym_table;
    sym_table = ptr;
    return ptr;
    }
     
/**********************************************************************/
symrec * getsym (sym_name)
/**********************************************************************/

    char *sym_name;
    {
    symrec *ptr;
    for (ptr = sym_table; ptr != (symrec *) 0; ptr = (symrec *)ptr->next)
       if (strcmp (ptr->name,sym_name) == 0)
           return ptr;
    return 0;
    }

#include <ctype.h>
/**********************************************************************/
yylex ()
/**********************************************************************/

{
 
  struct token {
    const char *operator;
    int token;
  };

 static int ntokens=6;
 static struct token tokentab[] = {
   {"++", PLUSPLUS},
   {"--", MINUSMINUS},
   {"-=", MINUSEQUALS},
   {"+=", PLUSEQUALS},
   {"*=", TIMESEQUALS},
   {"/=", DIVEQUALS}
 };



  int c,c2,length;
  int i;
     
  /* Ignore whitespace, get first nonwhite character.  */
  while ((c = *yyInput++) == ' ' || c == '\t' || c == '\n');
     
  if (c == '\0')
    return 0;

  /* Char starts a number => parse the number.         */
  if (c == '.' || isdigit (c))
    {
      yyInput--;
      sscanf (yyInput,"%lf%n", &yylval.val,&length);
/*       printf ("number is %f, length %d\n",yylval.val,length); */
      yyInput+=length;
      return NUM;
    }

  /* Char starts an identifier => read the name.       */
  if (isalpha (c))
    {
      symrec *s;
      static char *symbuf = 0;
      static int length = 0;
      int i;

      /* Initially make the buffer long enough
	 for a 40-character symbol name.  */
      if (length == 0)
	length = 40, symbuf = (char *)malloc (length + 1);
     
      i = 0;
      do

	{
	  /* If buffer is full, make it bigger.        */
	  if (i == length)
	    {
	      length *= 2;
	      symbuf = (char *)realloc (symbuf, length + 1);
	    }
	  /* Add this character to the buffer.         */
	  symbuf[i++] = c;
	  /* Get another character.                    */
	  c = *yyInput++;
	}

      while (c != '\0' && isalnum (c));
     
      yyInput--;

      symbuf[i] = '\0';

/*       printf("symbol is %s\n",symbuf); */

      s = getsym (symbuf);
      if (s == 0)
	s = putsym (symbuf, VAR);
      yylval.tptr = s;
      return s->type;
    }
     
  /* Any other character is a token by itself.   
   Or it could be a multicharacter token "++", "+=" etc */

  /*   printf ("character is %c\n",c); */

  c2=*(yyInput++);
  if (c2=='=' || c2=='+' ||  c2=='-' || c2=='/'){
    /*    printf ("c=%c c2=%c\n",c,c2);*/
    for (i=0;i<ntokens;i++){
      /*      printf ("%c%c\n",tokentab[i].operator[0],tokentab[i].operator[1]);*/
      if(c==tokentab[i].operator[0] && c2==tokentab[i].operator[1]){
	/*	printf ("token %d\n",tokentab[i].token);*/
	return tokentab[i].token;
      }
    }
    *yyInput--;
    return c;

  }
  else{
    *yyInput--;
    return c;
  }
}
