/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        random.c                               $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/*
Update 28/06/2007 R. Wilcke (wilcke@esrf.fr)
                  remove all code associated with the COOL preprocessor macro,
                  as this methode has now been replaced by ASA.
Update 27/02/2007 R. Wilcke (wilcke@esrf.fr)
                  created this file by moving the routines for generating
                  random numbers from the file "lsqfit.c" into it.
*/

/***************************************************************************/

/*
 * Here are two random number generators
 */

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <stdlib.h>
#include <time.h>
#include <lsqfit.h>

#ifdef ASA

/***********************************************************************
* Author: A.P.B.
* Date	 28 May 93
* Procedure:
*	double myrand(void) - returns a random number between 0 and 1
* Parameters: None
* Inputs:
* Outputs:
* Global Variables: None
* Returns: None
* Calls: None
* Description:
*	This routine returns the random number generator between 0 and 1
* Local Variables: None
* Portability:
* Other:
***********************************************************************/

#define SHUFFLE 256             /* size of random array */
double random_array[SHUFFLE];   /* random variables */

double myrand(void)

/* returns random number in {0,1} */
/* requires one call to initialize_rng to truly randomize */
{
    return ((float) rand()/RAND_MAX);
}

/***********************************************************************
* Author: Lester Ingber, Bruce Rosen (copyright) (c)
* Date	 5 Nov 92
* Procedure:
*	double randflt(void) - Shuffles random numbers in random_array[]
* Parameters: None
* Inputs:
* Outputs:
* Global Variables: None
* Returns: None
* Calls:
*	myrand()
* Description:
*	This routine initializes the random number generator
* Local Variables: None
* Portability:
* Other:
***********************************************************************/

double randflt(void)

/* shuffles random numbers in random_array[SHUFFLE] array */
{
    double rranf;
    int kranf;

    kranf = (int) (myrand() * SHUFFLE) % SHUFFLE;
    rranf = *(random_array + kranf);
    *(random_array + kranf) = myrand();
    return (rranf);
}

/***********************************************************************
* Author: A.P.B.
* Date	 28 May 93
* Procedure:
*	initialize_rng() - to initialize the random number generator
* Parameters: None
* Inputs:
* Outputs:
* Global Variables: None
* Returns: None
* Calls:
*	myrand()
*	randflt()
* Description:
*	This routine initializes the random number generator
* Local Variables: None
* Portability:
* Other:
***********************************************************************/
void initialize_rng(void)
{
    int n, seed;
    time_t now;

    /* first initialize the seed for random number generation
     * time() returns time (in sec?), on IBM clock() returns msec since
     * program began
     */

    time(&now);
    seed = ((unsigned int) now + (unsigned int) clock());
    srand(seed);

    for (n = 0; n < SHUFFLE; ++n)
	random_array[n] = myrand();
    for (n = 0; n < 1000; ++n);	/* warm up random generator */

}
//******************************************************************************
#endif /* ASA */
