/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        set.c                                  $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: set.c,v 1.4 2001/07/09 12:46:40 svensson Exp $

****************************************************************************/
/*
Update 05/07/2001 E. Vlieg (vlieg@sci.kun.nl)
                  Changed menus to follow Rainer's scheme.
Update 21/12/2000 E. Vlieg (vlieg@sci.kun.nl)
                  Introduced new symmetry "friedel".
Update 20/12/00 E. Vlieg (vlieg@sci.kun.nl)
	Small changes in menu help texts
*/
/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define EXT extern
#include "ave.h"
#undef EXT

/***************************************************************************/
void    set(void)
/***************************************************************************/

    /*
    Set menu.
    */

    {

    /* define set_menu */

#define set_length 6       /* number of commands in set menu */

    static struct   MENU set_menu[set_length] =
	{
	"read",     3,  1,  "Parameters for reading input file",
	"symmetry", 2,  2,  "Set symmetry group",
	"average",  1,  3,  "Averaging parameters",
	"weight",   1,  4,  "Weighting parameters",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"AVE.SET>")) break;
	switch (cmnd_match(token,set_menu,set_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		set_read();
		break;
	    case 2:
		set_symmetry();
		break;
	    case 3:
		set_average();
		break;
	    case 4:
		set_weight();
		break;
	    case 20:
		list_menu("SET MENU",set_menu,set_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_average(void)
/***************************************************************************/

    /*
    Set parameters determining the data averaging.
    */

    {

    /* define set_ave_menu */

#define set_ave_length 5      /* number of commands in set_ave menu */

    static struct   MENU set_ave_menu[set_ave_length] =
	{
	"sigma2mode",1, 1,  "Mode of sigma_2 calculation",
	"cutoff",   2,  2,  "Cutoff in agreement factor evaluation",
	"list",     1,  10, "List parameters",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"AVE.SET.AVERAGE>")) break;
	switch (cmnd_match(token,set_ave_menu,set_ave_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,"%s\n%s\n%s\n%s\nNew mode [%1d]: ",
			"Mode of sigma_2 calculation",
			" 0. Standard deviation of weighted average",
			" 1. Average statistical error",
			" 2. As mode 0, but times sqrt(# reflections)",
			SIG2MODE);
		SIG2MODE = get_int(SIG2MODE,STRING);
		break;
	    case 2:
		sprintf(STRING,
			"Cutoff in agreement factor evaluation with f > cutoff*sigma_2 [%3.1f]: ",
			EPSCUTOFF);
		EPSCUTOFF = get_real(EPSCUTOFF,STRING);
		break;
	    case 10:
		sprintf(STRING,"sigma_2 mode %1d\n",SIG2MODE);
		type_line(STRING);
		sprintf(STRING,"cutoff %3.1f\n",EPSCUTOFF);
		type_line(STRING);
		break;
	    case 20:
		list_menu("SET AVERAGING PARAMETERS",
			  set_ave_menu,set_ave_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_read(void)
/***************************************************************************/

    /*
    Set parameters determining the reading of the data file.
    */

    {

    /* define set_read_menu */

#define set_read_length 10      /* number of commands in set_read menu */

    static struct   MENU set_read_menu[set_read_length] =
	{
	"header",   3,  1,  "Number of header lines",
	"idcol",    1,  2,  "Column with identification (scan) number",
	"hcol",     2,  3,  "Column with diffraction index h",
	"kcol",     2,  4,  "Column with diffraction index k",
	"lcol",     2,  5,  "Column with diffraction index l",
	"fcol",     1,  6,  "Column with structure factor",
	"sigcol",   1,  7,  "Column with error in structure factor",
	"list",     1,  10, "List parameters",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"AVE.SET.READ>")) break;
	switch (cmnd_match(token,set_read_menu,set_read_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,
			"Number of header lines in file [%d]: ",NHEADER);
		NHEADER = get_int(NHEADER,STRING);
		break;
	    case 2:
		sprintf(STRING,
			"Column with id number of reflection (0 for serial id) [%d]: ",
			IDCOL);
		IDCOL = get_int(IDCOL,STRING);
		break;
	    case 3:
		sprintf(STRING,
			"Column with diffraction index h of reflection [%d]: ",HCOL);
		HCOL = get_int(HCOL,STRING);
		break;
	    case 4:
		sprintf(STRING,
			"Column with diffraction index k of reflection [%d]: ",KCOL);
		KCOL = get_int(KCOL,STRING);
		break;
	    case 5:
		sprintf(STRING,
			"Column with diffraction index l of reflection [%d]: ",LCOL);
		LCOL = get_int(LCOL,STRING);
		break;
	    case 6:
		sprintf(STRING,
			"Column with structure factor [%d]: ",FCOL);
		FCOL = get_int(FCOL,STRING);
		break;
	    case 7:
		sprintf(STRING,
			"Column with error in structure factor [%d]: ",SIGCOL);
		SIGCOL = get_int(SIGCOL,STRING);
		break;
	    case 10:
		sprintf(STRING,"# header lines %3d\n",NHEADER);
		type_line(STRING);
		sprintf(STRING,"id column    %2d\n",IDCOL);
		type_line(STRING);
		sprintf(STRING,"h column     %2d\n",HCOL);
		type_line(STRING);
		sprintf(STRING,"k column     %2d\n",KCOL);
		type_line(STRING);
		sprintf(STRING,"l column     %2d\n",LCOL);
		type_line(STRING);
		sprintf(STRING,"f column     %2d\n",FCOL);
		type_line(STRING);
		sprintf(STRING,"sigma column %2d\n",SIGCOL);
		type_line(STRING);
		break;
	    case 20:
		list_menu("SET FILE READ PARAMETERS",
			  set_read_menu,set_read_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_symmetry(void)
/***************************************************************************/

    /*
    Set space group symmetry of crystal structure data menu.
    When generating symmetry-equivalent reflections, the program will
    in addition look for Friedel pairs (most important for l = 0).
    */

    {

    /* Define transformation matrices that generate equivalent reflections
       for the various plane groups */

    static int  p1[4] = {1,0,0,1};                                   /*  1 */
//    static int  p2[8] = {1,0,0,1, -1,0,0,-1};                        /*  2 */
    static int  p2[8] = {1,0,0,1, 0,-1,-1,0};                        /*  2 */
    /* special ADP(101) version of AVE */
    static int  pm[8] = {1,0,0,1, 1,0,0,-1};                         /*  3 */
    int *pg = pm;                                                    /*  4 */
    int *cm = pm;                                                    /*  5 */
    static int p2mm[16] = {1,0,0,1, -1,0,0,-1, -1,0,0,1, 1,0,0,-1};  /*  6 */
    int *p2mg = p2mm;                                                /*  7 */
    int *p2gg = p2mm;                                                /*  8 */
    int *c2mm = p2mm;                                                /*  9 */
    static int p4[16] = {1,0,0,1, -1,0,0,-1, 0,-1,1,0, 0,1,-1,0};    /* 10 */
    static int p4mm[32] = {1,0,0,1, -1,0,0,-1, -1,0,0,1, 1,0,0,-1,   /* 11 */
			   0,1,1,0, 0,-1,-1,0, 0,1,-1,0, 0,-1,1,0};
    int *p4gm = p4mm;                                                /* 12 */
    static int p3[12] = {1,0,0,1, 0,1,-1,-1, -1,-1,1,0};             /* 13 */
    static int p3m1[24] = {1,0,0,1, 0,1,-1,-1, -1,-1,1,0, 0,-1,-1,0, /* 14 */
			   1,1,0,-1, -1,0,1,1};
    static int p31m[24] = {1,0,0,1, 0,1,-1,-1, -1,-1,1,0, 0,1,1,0,   /* 15 */
			   -1,-1,0,1, 1,0,-1,-1};
    static int p6[24] = {1,0,0,1, 0,1,-1,-1, -1,-1,1,0, -1,0,0,-1,   /* 16 */
			 0,-1,1,1, 1,1,-1,0};
    static int p6mm[48] = {1,0,0,1, 0,1,-1,-1, -1,-1,1,0, -1,0,0,-1, /* 17 */
			   0,-1,1,1, 1,1,-1,0, 0,1,1,0, -1,-1,0,1,
			   1,0,-1,-1, 0,-1,-1,0, 1,1,0,-1, -1,0,1,1};

    static int n_matrices[17] = {1,2,2,2,2,4,4,4,4,4,8,8,3,6,6,6,12};

    /* define set_sym_menu */

#define set_sym_length 21      /* number of commands in set_sym menu */

    static struct   MENU set_sym_menu[set_sym_length] =
	{
	"p1",       2,  1,  "Plane group no. 1",
	"p2",       2,  2,  "Plane group no. 2",
	"pm",       2,  3,  "Plane group no. 3",
	"pg",       2,  4,  "Plane group no. 4",
	"cm",       2,  5,  "Plane group no. 5",
	"p2mm",     4,  6,  "Plane group no. 6",
	"p2mg",     4,  7,  "Plane group no. 7",
	"p2gg",     4,  8,  "Plane group no. 8",
	"c2mm",     4,  9,  "Plane group no. 9",
	"p4",       2,  10, "Plane group no. 10",
	"p4mm",     4,  11, "Plane group no. 11",
	"p4gm",     4,  12, "Plane group no. 12",
	"p3",       2,  13, "Plane group no. 13",
	"p3m1",     4,  14, "Plane group no. 14",
	"p31m",     4,  15, "Plane group no. 15",
	"p6",       2,  16, "Plane group no. 16",
	"p6mm",     4,  17, "Plane group no. 17",
	"friedel",  2,  18, "Friedel pairs yes/no",
	"list",     1,  20, "List current plane group",
	"help",     1,  21, "Display menu",
	"return",   1,  22, "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    int     i,ncom;
    static int  nplanegroup = 0, *matrix;

    while (!stop)
	{
	if (!get_token(token,"AVE.SET.SYMMETRY>")) break;
	ncom = cmnd_match(token,set_sym_menu,set_sym_length);
	switch (ncom)
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1: case 2: case 3: case 4: case 5: case 6: case 7: case 8:
	    case 9: case 10: case 11: case 12: case 13: case 14: case 15:
	    case 16: case 17:
		nplanegroup = ncom;
		sprintf(PLANEGROUP,"%s",set_sym_menu[nplanegroup-1].COMMAND);
		NTRANS = n_matrices[nplanegroup-1];
		if (nplanegroup == 1) matrix = p1;
		if (nplanegroup == 2) matrix = p2;
		if (nplanegroup == 2)
		    errtype("Warning: special ADP(101) version!");
		if (nplanegroup == 3) matrix = pm;
		if (nplanegroup == 4) matrix = pg;
		if (nplanegroup == 5) matrix = cm;
		if (nplanegroup == 6) matrix = p2mm;
		if (nplanegroup == 7) matrix = p2mg;
		if (nplanegroup == 8) matrix = p2gg;
		if (nplanegroup == 9) matrix = c2mm;
		if (nplanegroup == 10) matrix = p4;
		if (nplanegroup == 11) matrix = p4mm;
		if (nplanegroup == 12) matrix = p4gm;
		if (nplanegroup == 13) matrix = p3;
		if (nplanegroup == 14) matrix = p3m1;
		if (nplanegroup == 15) matrix = p31m;
		if (nplanegroup == 16) matrix = p6;
		if (nplanegroup == 17) matrix = p6mm;
		for (i = 0; i < n_matrices[nplanegroup-1]; i++)
		    {
		    TRANS[i][0][0] = matrix[i*4];
		    TRANS[i][0][1] = matrix[i*4+1];
		    TRANS[i][1][0] = matrix[i*4+2];
		    TRANS[i][1][1] = matrix[i*4+3];
		    }
		break;
	    case 18:
		FRIEDEL = yesno(TRUE,"Use Friedel symmetry? [yes]: ");
		break;
	    case 20:
		if (nplanegroup == 0)
		    {
		    errtype("No plane group set");
		    break;
		    }
		else
		    {
		    sprintf(STRING,"Plane group %s No. %1d\n",
			    PLANEGROUP,nplanegroup);
		    type_line(STRING);
		    type_line(
			"Matrices to generate equivalent reflections:\n");
		    for (i = 0; i < n_matrices[nplanegroup-1]; i++)
			{
			sprintf(STRING,"matrix %2d %3d %3d\n",i+1,
				matrix[i*4],matrix[i*4+1]);
			type_line(STRING);
			sprintf(STRING,"          %3d %3d\n",
				matrix[i*4+2],matrix[i*4+3]);
			type_line(STRING);
			}
		    type_line("Friedel symmetry: ");
		    if (FRIEDEL) type_line("yes\n");
		    else type_line("no\n");
		    }
		break;
	    case 21:
		list_menu("SET PLANE GROUP SYMMETRY",
			  set_sym_menu,set_sym_length);
		break;
	    case 22:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    set_weight(void)
/***************************************************************************/

    /*
    Set parameters determining the data weighting.
    */

    {

    /* define set_weight_menu */

#define set_weight_length 8      /* number of commands in set_weight menu */

    static struct   MENU set_weight_menu[set_weight_length] =
	{
	"epsilon",  1,  1,  "Average agreement factor",
	"minimum",  1,  2,  "Minimum # of equivalent reflections",
	"lmult",    2,  3,  "Multiplication factor of l",
	"integerl", 1,  4,  "Add offset to integer l yes/no",
	"lbragg",   2,  5,  "Input nearest Bragg peak l-values",
	"list",     1,  10, "List parameters",
	"help",     1,  20, "Display menu",
	"return",   1,  21, "Return to main menu"
	};

    int     stop = FALSE,h,k,l,i,j;
    char    token[100];

    while (!stop)
	{
	if (!get_token(token,"AVE.SET.WEIGHT>")) break;
	switch (cmnd_match(token,set_weight_menu,set_weight_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		sprintf(STRING,"Average agreement factor [%5.3f]: ",
			EPSILON);
		EPSILON = get_real(EPSILON,STRING);
		break;
	    case 2:
		sprintf(STRING,
			"Minimum # equivalent refl. required to use own variance [%1d]: ",
			EQUMIN);
		EQUMIN = get_int(EQUMIN,STRING);
		break;
	    case 3:
		sprintf(STRING,
			"Multiplication factor of l [%4.2f]: ",LMULT);
		LMULT = get_real(LMULT,STRING);
		break;
	    case 4:
		sprintf(STRING,"Add offset to integer l-values [%s]: ",
			yesnostr(NOINTL));
		NOINTL = yesno(NOINTL,STRING);
		break;
	    case 5:
		sprintf(STRING,"List l-value of nearest Bragg peak [%s]: ",
			yesnostr(LIST_LBRAGG));
		LIST_LBRAGG = yesno(LIST_LBRAGG,STRING);
		if (LIST_LBRAGG)
		    {
		    if (NAVE == 0)
			{
			errtype("ERROR, do averaging first");
			break;
			}
		    for (j = 0; j < NAVE; j++)
			{
			i = SORTAVE[j];
		        h = REFAVE[i].H;
		        k = REFAVE[i].K;
			sprintf(STRING,
				"Bragg l-value of (%1d,%1d)-rod [0]: ",h,k);
			l = get_int(0,STRING);
			while ((h == REFAVE[i].H) && (k == REFAVE[i].K))
			    {
			    REFAVE[i].LBRAGG = l;
			    j++;
			    if (j == NAVE) break;
			    i = SORTAVE[j];
			    }
			j--;
			}
		    }
		break;
	    case 10:
		sprintf(STRING,"epsilon %5.3f\n",EPSILON);
		type_line(STRING);
		sprintf(STRING,"Minimum equivalents %1d\n",EQUMIN);
		type_line(STRING);
		sprintf(STRING,"l-multiplication %4.2f\n",LMULT);
		type_line(STRING);
		sprintf(STRING,"Add offset to integer l-values: %s\n",
			yesnostr(NOINTL));
		type_line(STRING);
		sprintf(STRING,"List l-value of nearest Bragg peak: %s\n",
			yesnostr(LIST_LBRAGG));
		type_line(STRING);
		break;
	    case 20:
		list_menu("SET WEIGHT PARAMETERS",
			  set_weight_menu,set_weight_length);
		break;
	    case 21:
		stop = TRUE;
	    }
	}
    }

