/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                         read.c                                $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: read.c,v 1.3 2004/01/19 16:55:25 wilcke Exp $

****************************************************************************/

/*

Update 19/01/2004 R. Wilcke (wilcke@esrf.fr) 
                  removed declarations of fopen() (is declared in "stdio.h").
*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define EXT extern
#include <ctype.h>
#include "ave.h"
#undef EXT

/***************************************************************************/
int     read_f(void)
/***************************************************************************/

    /*
    Read file with structure factor data.
    */

    {

    FILE    *infile;
    int     i;
    int     end_of_file;
    float   dummy[15];
    int	    istext;

    /* Get filename and open file, return if not successful */

    get_token(FILENAME,"Filename (.int): ");
    add_extension(FILENAME,"int");
    if ((infile = fopen(FILENAME,"r")) == NULL)
	{
	sprintf(STRING,"Failed to open file '%s'",FILENAME);
	errtype(STRING);
	clear_command();
	return(0);
	}

    /* Type header */

    for (i = 0; i < NHEADER; i++)
	{
	if (fgets(INLINE,INLLEN,infile) == NULL)
	    {
	    errtype("ERROR, file is empty");
	    fclose(infile);
	    clear_command();
	    return(0);
	    }
	else
	    {
	    type_line(INLINE);
	    }
	}

    /* Read data */

    end_of_file = FALSE;
    while ((fgets(INLINE,INLLEN,infile) != NULL) && (!end_of_file))
	{

        /* check for comment line */

        istext = FALSE;
        for (i=0; i<strlen(INLINE);i++)
            {
            if (!isdigit(INLINE[i]) && !isspace(INLINE[i]) &&
		INLINE[i] != 'e' && INLINE[i] != 'E' &&
		INLINE[i] != '.' && INLINE[i] != '-')
		{
		istext = TRUE;
		break;
		}
	    }
        if (i==0) istext=TRUE;  /* empty line */

	if (!istext) if (sscanf(INLINE,"%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f",
				&dummy[0],&dummy[1],&dummy[2],&dummy[3],&dummy[4],&dummy[5],
				&dummy[6],&dummy[7],&dummy[8],&dummy[9],&dummy[10],
				&dummy[11],&dummy[12],&dummy[13],&dummy[14]) >= 5)
	    {
	    if (IDCOL == 0)
		REFIN[NIN].ID = NIN+1;
	    else
		REFIN[NIN].ID = dummy[IDCOL-1]+0.5;
	    if (dummy[HCOL-1] > 0)
		REFIN[NIN].H = dummy[HCOL-1]+0.5;
	    else
		REFIN[NIN].H = dummy[HCOL-1]-0.5;
	    if (dummy[KCOL-1] > 0)
		REFIN[NIN].K = dummy[KCOL-1]+0.5;
	    else
		REFIN[NIN].K = dummy[KCOL-1]-0.5;
	    REFIN[NIN].L = dummy[LCOL-1];
	    REFIN[NIN].F = dummy[FCOL-1];
	    REFIN[NIN].SIG = dummy[SIGCOL-1];
	    REFIN[NIN].DONE = FALSE;
	    if (REFIN[NIN].SIG < 0.001)
		{
		errtype("Error, data point with zero error");
		NIN--;
		}
	    NIN++;
	    if (NIN == MAXDAT)
		{
		sprintf(STRING,
			"Error, number of reflections exceeds maximum of %d",
			MAXDAT);
		errtype(STRING);
		}
	    }
	else
	    {
	    end_of_file = TRUE;
	    }
	}
    fclose(infile);
    if (NIN == 0)
	{
	errtype("No data in file");
	clear_command();
	return(0);
	}
    else
	{
	sprintf(STRING,"%1d reflections read in\n",NIN);
	type_line(STRING);
	return(1);
	}

    }

