/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        util.c                                 $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: util.c,v 1.3 2001/07/09 12:43:23 svensson Exp $

****************************************************************************/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define EXT	extern
#include "ana.h"
#undef EXT


/***************************************************************************/
void    get_2inoutspec(int *in_spec1, int *in_spec2, int *out_spec)
/***************************************************************************/

    /*
    Get two input and one output spectrum numbers.
    */

    {

    int ok = FALSE;

    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec1 = get_int(1,"First input spectrum [1]: ");
	if ((*in_spec1 > 0) && (*in_spec1 <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}
    ok = FALSE;
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec2 = get_int(2,"Second input spectrum [2]: ");
	if ((*in_spec2 > 0) && (*in_spec2 <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}
    ok = FALSE;
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*out_spec = get_int(3,"Output spectrum [3]: ");
	if ((*out_spec > 0) && (*out_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}
    /* subtract 1 from spectrum numbers to account for the way C treats
       arrays */
    *in_spec1 -= 1;
    *in_spec2 -= 1;
    *out_spec -= 1;
    }

/***************************************************************************/
void    get_in2outspec(int *in_spec, int *out_spec1, int *out_spec2)
/***************************************************************************/

    /*
    Get one input and two output spectrum numbers.
    */

    {

    int ok = FALSE;

    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec = get_int(1,"Input spectrum [1]: ");
	if ((*in_spec > 0) && (*in_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}
    ok = FALSE;
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*out_spec1 = get_int(2,"First output spectrum [2]: ");
	if ((*out_spec1 > 0) && (*out_spec1 <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}
    ok = FALSE;
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*out_spec2 = get_int(3,"Second output spectrum [3]: ");
	if ((*out_spec2 > 0) && (*out_spec2 <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}
    /* subtract 1 from spectrum numbers to account for the way C treats
       arrays */
    *in_spec -= 1;
    *out_spec1 -= 1;
    *out_spec2 -= 1;
    }

/***************************************************************************/
void    get_inoutspec(int *in_spec, int *out_spec)
/***************************************************************************/

    /*
    Get input and output spectrum numbers.
    */

    {

    int ok = FALSE;

    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec = get_int(1,"Input spectrum [1]: ");
	if ((*in_spec > 0) && (*in_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}
    ok = FALSE;
    while (!ok)  /* Stay in loop until correct value read in */
	{
	*out_spec = get_int(2,"Output spectrum [2]: ");
	if ((*out_spec > 0) && (*out_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}
    /* subtract 1 from spectrum numbers to account for the way C treats
       arrays */
    *in_spec -= 1;
    *out_spec -= 1;
    }

/***************************************************************************/
void    get_inspec(int *in_spec)
/***************************************************************************/

    /*
    Get spectrum number.
    */

    {

    int ok = FALSE;

    while (!ok)  /* Stay in loop until correct value read in */
	{
	*in_spec = get_int(1,"Spectrum number [1]: ");
	if ((*in_spec > 0) && (*in_spec <= MAX_SPECTRUM))
	    ok = TRUE;
	else
	    clear_command();
	}
    /* subtract 1 from spectrum number to account for the way C treats
       arrays */
    *in_spec -= 1;
    }

/***************************************************************************/
double  sqr(double value)
/***************************************************************************/

    /*
    Returns square of value.
    */

    {
    return(value*value);
    }

/***************************************************************************/
void type_header(int flag)
/***************************************************************************/

    /*
    Type header with spectrum summary.
    Some operating systems allow setting up the terminal screen with a
    lower scroll region. If this is not the case, the header has to be typed
    all the time to simulate scrolling. The subroutine therefore does the
    following:
	flag	0	Only type header when SCROLL is not defined
	flag	1	Always type full header
    */

    {

    int i;

#ifdef SCROLL
    if (flag == 0) return;
#endif

    set_cursor(1,1);
    type_line("========================================");
    type_line("=======================================\n");
    sprintf(STRING,"%s %-*s %s %13s %13s\n",
	    "no.",TITLE_LENGTH,"title","points","min","max");
    type_line(STRING);
    for (i = 0; i < MAX_SPECTRUM; i++)
	{
	if ((DATA[i].MINY < 0.1 && DATA[i].MINY > 1e-10) ||
	    (DATA[i].MAXY > 1e9))
	    {
	    sprintf(STRING,"%2d  %-*s %6d %13.5e %13.5e\n",
		    i+1,TITLE_LENGTH,DATA[i].TITLE,DATA[i].NPNT,
		    DATA[i].MINY,DATA[i].MAXY);
	    type_line(STRING);
	    }
	else
	    {
	    sprintf(STRING,"%2d  %-*s %6d %13.3f %13.3f\n",
		    i+1,TITLE_LENGTH,DATA[i].TITLE,DATA[i].NPNT,
		    DATA[i].MINY,DATA[i].MAXY);
	    type_line(STRING);
	    }
	}
    type_line("========================================");
    type_line("=======================================\n");
    set_cursor(1,ROWS);

    flag = flag;
    }


