/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$                        plot.c                                 $$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: plot.c,v 1.10 2004/01/15 10:55:03 svensson Exp $

****************************************************************************/

/***************************************************************************/
/* Changes:                                                                */
/*	12/12/91 - flag for drawing of unit cell introduced  (M.L.)        */
/*      01/12/93 - Patterson output for CGLE added                         */
/*      03/12/93 - PLOT3D structure output                                 */
/*
Update 15/08/2003 E.Vlieg (vlieg@sci.kun.nl)
		  Make arrays for z-projected density global.
Update 14/08/2003 E.Vlieg (vlieg@sci.kun.nl)
		  Fix bug in plot_zdensity: ZS instead of ZSFIT was used.
Update 28/05/2003 E.Vlieg (vlieg@sci.kun.nl)
		  Add plot_zdensity() to plot z-projected electron density.
		  In very simple way for the time being.
Update 11/02/2003 E.Vlieg (vlieg@sci.kun.nl)
		  Fix bug in routine for making 'msi' output: now use fitted
		  position instead of starting position. Further replace
                  'msi' by 'xyz' (the company name msi no longer exits!)
Update 12/03/2002 E.Vlieg (vlieg@sci.kun.nl)
		  Add copy command to PLOT that copies data to theory array.
		  This trick allows plotting of two data sets.
Update 12/02/2001 E.Vlieg (vlieg@sci.kun.nl)
		  Change function calls for generation of PLOT3D output file.
                  Add generation of MSI output file.
Update 21/12/2000 O. Svensson (svensson@esrf.fr)
                  Changed switch item numbers from 20 and 21 to
		  30 and 31 in order to be the same as in Elias
		  sources.
Update 26/09/2000 O. Svensson (svensson@esrf.fr)
                  Removed "ret" from commands sent to "plot_xye" when
                  plotting data (case 5) with errors=TRUE, otherwise the 
                  programs falls out of the PLOT> sub-menu.
Update 19/07/2000 R. Wilcke (wilcke@esrf.fr)
                  replaced everywhere the buffer size for filenames by
                  the ISO-C defined macro FILENAME_MAX.
*/
/***************************************************************************/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#define PLOT
#include "rod.h"

/*#define INCHES*/
#define METRIC
#define GRAPHIC

#ifdef IMSLEG
#define XL      1.0             /* length of x-axis */
#define YL      1.0             /* length of y-axis */
#endif
#if defined(GRAPHIC) && defined(INCHES)
#define XL      7.0             /* length of x-axis in inches */
#define YL      5.0             /* length of y-axis in inches */
#endif
#if defined(GRAPHIC) && defined(METRIC)
#define XL      18.             /* length of x-axis in cm */
#define YL      12.             /* length of y-axis in cm */
#endif

static  drawunit = TRUE;	/* Flag to denote drawing of unit cell */

#ifdef ALLOW_PLOT	/* around entire series of subroutines! */
/***************************************************************************/
void makefile_xyz(void)
/***************************************************************************/


    /*
    make output file of refined model of so-called xyz type for use with
    WebLab ViewerLite of MSI (now called ACCELRYS)

    Format:

    1-st line:   total number of atoms
    2-nd line:   comments
    other lines: element x y z (in Angstroms)

    */

    {

    char  title[INLLEN];
    int   ix, iy, iz, i;            /* index variables */
    float cart[3];
    static char  fname[128];   /* output file name */
    int         nx,ny,nz;
    FILE  *pltfile;		    /* output file */

    nx = get_int(1,"Number of repetitions in x-direction [1]: ");
    if (nx < 0) nx = 0;
    ny = get_int(1,"Number of repetitions in y-direction [1]: ");
    if (ny < 0) ny = 0;
    nz = get_int(1,"Number of bulk repetitions in z-direction [1]: ");
    if (nz < 0) nz = 0;

    /* get output file name */

    get_string(fname,"File name [.xyz]: ");
    if (strlen(fname) == 0)
	return;
    add_extension(fname,"xyz");

    /* and open output file */

    pltfile = fopen(fname, "w");
    if (pltfile == NULL)
	{
	errtype("ERROR, cannot open output file");
	return;
	}

    /* get title */

    get_string(title, "Comments: ");

    /* Write number of atoms to file */

    fprintf(pltfile, "%d\n",nx*ny*NSURF+nx*ny*nz*NBULK);

    /* write title */

    fprintf(pltfile, "%s\n", title);

    /* write all surface atoms to file */

    for (ix = 0; ix < nx; ix++)
	{
	for (iy = 0; iy < ny; iy++)
	    {
	    for (i = 0; i < NSURF; i++)
		{
		get_cartesian(cart,XSFIT[i]+ix,YSFIT[i]+iy,ZSFIT[i]);
		fprintf(pltfile,"%s %9.4f %9.4f %9.4f\n",
			ELEMENT[TS[i]],cart[0],cart[1],cart[2]);
		}
	    }
	}

    /* write all bulk atoms to file */

    for (ix = 0; ix < nx; ix++)
	{
	for (iy = 0; iy < ny; iy++)
	    {
	    for (iz = 0; iz < nz; iz++)
		{
		for (i = 0; i < NBULK; i++)
		    {
		    get_cartesian(cart,XB[i]+ix,YB[i]+iy,ZB[i]-iz);
		    fprintf(pltfile,"%s %9.4f %9.4f %9.4f\n",
			    ELEMENT[TB[i]],cart[0],cart[1],cart[2]);
                    }
		}
	    }
	}

    /* close output file */

    fclose(pltfile);

    }

/***************************************************************************/
void makefile_plot3d(int mode)
/***************************************************************************/

    /*
    make output file of refined model for use with
    PLOT3D ver. 1.02 (K. Hermann, Fritz-Haber-Institut, Berlin)

    mode = 1 - full 3D model of (relaxed) unit cells
    mode = 2 - cut trough scattering plane parallel to z-axis
               (for ion scattering simulations using VEGAS)
    */

    {
    char  title[INLLEN];
 
    int   nktot;                    /* total number of atoms */

    int   ix, iy, iz, i;            /* index variables */

    float xmin, xmax, ymin, ymax, zmin, zmax, cart[3];

    float xtot, ytot, ztot;         /* size of block containing all atoms */

    float theta     = 90.,          /* viewpoint definitions for PLOT3D */
	phi       = 0.,
	rot       = 0.,
	magnf     = 1.,
	persp     = 5.,
	hight     = 0.;

    int   M         = 6,            /* color mode */
	N         = 1,            /* 1st color index */
	ICLC      = 1,            /* label mode */
	IBFT      = 0,            /* title / frames */
	NSHX      = 0,            /* horz. shift */
	NSHY      = 0,            /* vert. shift */
	ICON      = 0;            /* no. of connects */

    static char  fname[128];   /* output file name */

    int		plane_atom;	    /* index of atom in scattering plane */
    float	pa_x, pa_y, pa_z;   /* coordinates of plane defining atom */
    float	distance;	    /* distance of atom from scattering plane */
    float	dist_a, dist_b;	    /* distance range */
    float	azimuth;            /* angle of scattering plane w.r. to x-axis */ 
    int         nx,ny,nz;
    FILE  *pltfile;		    /* output file */

    nx = get_int(1,"Number of repetitions in x-direction [1]: ");
    if (nx < 0) nx = 0;
    ny = get_int(1,"Number of repetitions in y-direction [1]: ");
    if (ny < 0) ny = 0;
    nz = get_int(1,"Number of bulk repetitions in z-direction [1]: ");
    if (nz < 0) nz = 0;

    /* in scattering plane mode: get scattering plane */

    if (mode == 2)

	{

	if (NBULK == 0)
	    {
	    errtype("ERROR, no bulk cell defined");
	    return;
	    }

	plane_atom = get_int(1, "Index of bulk atom in scattering plane [1]: ");
        plane_atom--;
	plane_atom %= NBULK;

	pa_x = XB[plane_atom] + ceil(0.5*nx + 0.50001);
	pa_y = YB[plane_atom] + ceil(0.5*ny + 0.50001);
	pa_z = ZB[plane_atom] + ceil(0.5*nz + 0.50001);

	get_cartesian(cart, pa_x, pa_y, pa_z);
	pa_x = cart[0]; pa_y = cart[1]; pa_z = cart[2];

	azimuth = get_real(0., "Azimuth with respect to x-axis in deg. [0.]: ");
        azimuth /= RAD;

	dist_a = get_real(-1., "Maximum neg. distance (Angstrom) [-1.]: ");
	dist_b = get_real(+1., "Maximum pos. distance (Angstrom) [+1.]: ");
      
	}

    /* get title */

    get_string(title, "Title of structure output: ");
    title[72]=0;	/* make sure string is not too long for PLOT3D */

    /* get output file name */

    sprintf(STRING, "Output file name [%s]: ", fname);
    get_string(fname, STRING);
    if (strlen(fname) == 0)
	return;

    /* and open output file */

    pltfile = fopen(fname, "w");
    if (pltfile == NULL)
        {
        errtype("ERROR, cannot open output file");
        return;
        }

    /* write title */

    fprintf(pltfile, "%s\n", title);

    /* calculate block size */

    xmin=xmax=ymin=ymax=zmin=zmax = 0.;
    nktot = 0;

    if (nz) { /* loop over bulk atoms first */

    for (iz=0; iz<nz; iz++) {
    for (iy=0; iy<ny; iy++) {
    for (ix=0; ix<nx; ix++) {
    for (i=0; i<NBULK; i++) {

    get_cartesian(cart, XB[i]+(float)ix, YB[i]+(float)iy, ZB[i]-(float)iz);

    if (mode==2)
	{
	distance = -(cart[0]-pa_x)*sin(azimuth) + (cart[1]-pa_y)*cos(azimuth);
	};

    if (mode==1 || (mode==2 && distance>=dist_a && distance<=dist_b) )
	{
	if (cart[0] < xmin)
	    xmin = cart[0];
	if (cart[0] > xmax)
	    xmax = cart[0];
	if (cart[1] < ymin)
	    ymin = cart[1];
	if (cart[1] > ymax)
	    ymax = cart[1];
	if (cart[2] < zmin)
	    zmin = cart[2];
	if (cart[2] > zmax)
	    zmax = cart[2];

	nktot++;
	}

    } /* endfor i */
    } /* endfor nx */
    } /* endfor ny */
    } /* endfor nz */

    } /* if nz */

    /* now do the surface atoms */

    for (iy=0; iy<ny; iy++) {
    for (ix=0; ix<nx; ix++) {
    for (i=0; i<NSURF; i++) {

    get_cartesian(cart, XSFIT[i]+(float)ix, YSFIT[i]+(float)iy, ZSFIT[i]);

    if (mode==2)
	{
	distance = -(cart[0]-pa_x)*sin(azimuth) + (cart[1]-pa_y)*cos(azimuth);
	};

    if (mode==1 || (mode==2 && distance>=dist_a && distance<=dist_b) )
	{
	if (cart[0] < xmin)
	    xmin = cart[0];
	if (cart[0] > xmax)
	    xmax = cart[0];
	if (cart[1] < ymin)
	    ymin = cart[1];
	if (cart[1] > ymax)
	    ymax = cart[1];
	if (cart[2] < zmin)
	    zmin = cart[2];
	if (cart[2] > zmax)
	    zmax = cart[2];

	nktot++;
	}

    } /* endfor i */
    } /* endfor ix */
    } /* endfor iy */

    xtot = xmax-xmin;
    ytot = ymax-ymin;
    ztot = zmax-zmin;

    /* write number of atoms + block size */

    fprintf(pltfile, "%5d%15.9f%15.9f%15.9f\n", nktot, xtot, ytot, ztot);

    /* write positions of atoms */

    if (nz) { /* loop over bulk atoms first */

    for (iz=0; iz<nz; iz++) {
    for (iy=0; iy<ny; iy++) {
    for (ix=0; ix<nx; ix++) {
    for (i=0; i<NBULK; i++) {

    get_cartesian(cart, XB[i]+(float)ix, YB[i]+(float)iy, ZB[i]-(float)iz);

    if (mode==2)
	{
	distance = -(cart[0]-pa_x)*sin(azimuth) + (cart[1]-pa_y)*cos(azimuth);
	};

    if (mode==1 || (mode==2 && distance>=dist_a && distance<=dist_b) )
	{
	fprintf(pltfile, "%15.9f%15.9f%15.9f%15.9f%4d\n",
		cart[0], cart[1], cart[2],
		DLAT[0]*ATRAD[TB[i]],
		get_element_number(ELEMENT[TB[i]]));
	}

    } /* endfor i */
    } /* endfor nx */
    } /* endfor ny */
    } /* endfor nz */

    } /* if nz */

    /* now do the surface atoms */

    for (iy=0; iy<ny; iy++) {
    for (ix=0; ix<nx; ix++) {
    for (i=0; i<NSURF; i++) {

    get_cartesian(cart, XSFIT[i]+(float)ix, YSFIT[i]+(float)iy, ZSFIT[i]);

    if (mode==2)
	{
	distance = -(cart[0]-pa_x)*sin(azimuth) + (cart[1]-pa_y)*cos(azimuth);
	};

    if (mode==1 || (mode==2 && distance>=dist_a && distance<=dist_b) )
	{
	fprintf(pltfile, "%15.9f%15.9f%15.9f%15.9f%4d\n",
		cart[0], cart[1], cart[2],
		DLAT[0]*ATRAD[TS[i]],
		get_element_number(ELEMENT[TS[i]]));
	}

    } /* endfor i */
    } /* endfor ix */
    } /* endfor iy */


    /* write view point info */

    fprintf(pltfile, "%12.5f%12.5f%12.5f%12.5f%12.5f%12.5f\n",
            theta, phi, rot, magnf, persp, hight);

    /* write graphics options */

    fprintf(pltfile, "%5d%5d%5d%5d%5d%5d%5d\n",
            M, N, ICLC, IBFT, NSHX, NSHY, ICON);

    /* close output file */

    fclose(pltfile);

    }

/***************************************************************************/
void    plot(void)
/***************************************************************************/

    /*
    Plotting menu.
    */

    {

    /* define plot_menu */

#define plot_length 27      /* number of commands in plot menu */

    static struct   MENU plot_menu[plot_length] =
	{
	"bulk",     1,  1,  "Bulk contribution (against l)",
	"surface",  3,  2,  "Surface contribution (against l)",
	"sum",      1,  3,  "Interference sum of bulk and surface",
	"all",      1,  4,  "Above three curves (against l)",
	"data",     1,  5,  "Rod data (against l)",
	"both",     2,  6,  "Data plus calculated interference sum",
	"ftheory",  2,  7,  "Theoretical structure factors",
	"fdata",    2,  8,  "Experimental structure factors",
	"fboth",    2,  9,  "Theoretical and experimental f's",
	"moriginal",2, 10,  "Original structure model",
	"mrefined", 2, 11,  "Refined structure model",
	"mboth",    2, 12,  "Original + refined structure model",
	"mlarge",   2, 13,  "Several unit cells of refined model",
	"m3d",      2, 22,  "Refined model, PLOT3D output file",
        "cut3d",    2, 23,  "Cut trough scattering plane, PLOT3D",
	"xyz",      3, 24,  "Refined model, XYZ output file",
	"dpatterson",2,14,  "Patterson function of experimental data",
	"tpatterson",2,15,  "Patterson of theoretical structure f's",
	"difference",2,16,  "Electron density difference map",
	"electron", 2, 17,  "Electron density map of model",
	"zdensity", 2, 171, "Z-projected electron density",
	"errors",   1, 18,  "Set error bar plotting on/off",
	"unit",     1, 19,  "Set drawing of unit cell on/off",
	"copy",     4, 20,  "Copy data to theory array: just a trick",
	"test",     4, 99,  "Play with electron density difference",
	"help",     1, 30,  "Display menu",
	"return",   1, 31,  "Return to main menu"
	};

    int     stop = FALSE;
    char    token[100];
    static float errth[MAXTHEO] = {0,}; /* In theory no errors */
    static      errors = FALSE;      /* Flag to denote error bar plotting */
    int i,j;
/*test*/
#define NDENSITY 100
#define ZLOW	-1.5
#define ZHIGH	 1.5
    float z[NDENSITY],dens[NDENSITY],err[NDENSITY];
/*test*/

    while (!stop)
	{
	if (!get_token(token,"ROD.PLOT>")) break;
	switch (cmnd_match(token,plot_menu,plot_length))
	    {
	    case -1:
		break;
	    case 0:
		break;
	    case 1:
		if (NTH > 0) plotxye(LTH,FTH[0],errth,NTH);
		return;
	    case 2:
		if (NTH > 0) plotxye(LTH,FTH[1],errth,NTH);
		return;
	    case 3:
		if (NTH > 0) plotxye(LTH,FTH[2],errth,NTH);
		return;
	    case 4:
		if (NTH > 0)
		    {
#ifdef IMSLEG
		    put_command("make no curve 1 line 0 plo ret");
		    plotxye(LTH,FTH[2],errth,NTH);
		    put_command("over ret");
		    plotxye(LTH,FTH[0],errth,NTH);
		    put_command("make yes over");
		    plotxye(LTH,FTH[1],errth,NTH);
#endif
#ifdef GRAPHIC
		    put_command("curve 0 line 1 plo break");
		    plotxye(LTH,FTH[2],errth,NTH);
		    put_command("line 2 over break");
		    plotxye(LTH,FTH[0],errth,NTH);
		    put_command("line 3 over return");
		    plotxye(LTH,FTH[1],errth,NTH);
#endif
		    }
		return;
	    case 5:
		if (NDAT > 0) 
		    {
		    if (errors)
			{
#ifdef IMSLEG
			put_command("make no cur 0 plo make yes er");
#endif
#ifdef GRAPHIC
			put_command("cur -1 plo er ret");
#endif
			plotxye(LDAT,FDAT,ERRDAT,NDAT);
			}
		    else
			{
			plotxye(LDAT,FDAT,ERRDAT,NDAT);
			}
		    }
		return;
	    case 6:
		if ((NDAT > 0) && (NTH > 0))
		    {
#ifdef IMSLEG
		    if (errors)
			put_command("make no curve 2 mark 4 plo er ret");
		    else
			put_command("make no curve 2 mark 4 plo ret");
		    plotxye(LDAT,FDAT,ERRDAT,NDAT);
		    put_command("make yes line 1 curve 1 over return");
		    plotxye(LTH,FTH[2],errth,NTH);
#endif
#ifdef GRAPHIC
		    if (errors)
			put_command("curve -1 plo er break");
		    else
			put_command("curve -1 plo break");
		    plotxye(LDAT,FDAT,ERRDAT,NDAT);
		    put_command("curve 0 over return");
		    plotxye(LTH,FTH[2],errth,NTH);
#endif
		    }
		return;
	    case 7:
		plot_sfac(1);
		return;
	    case 8:
		plot_sfac(2);
		return;
	    case 9:
		plot_sfac(3);
		return;
	    case 10:
		plot_model(1);
		return;
	    case 11:
		plot_model(2);
		return;
	    case 12:
		plot_model(3);
		return;
	    case 13:
		plot_model(4);
		return;
            case 22:
                makefile_plot3d(1);
		return;
	    case 23:
		makefile_plot3d(2);
		return;
            case 24:
		makefile_xyz();
                return;
	    case 14:
		plot_fourier(1);
		return;
	    case 15:
		plot_fourier(2);
		return;
	    case 16:
		plot_fourier(3);
		return;
	    case 17:
		plot_fourier(4);
		return;
	    case 171:
		plot_zdensity();
		return;
	    case 18:
		sprintf(STRING,"Error bar plotting [%s]: ",
			yesnostr(errors));
		errors = yesno(errors,STRING);
		break;
	    case 19:
		sprintf(STRING,"Draw unit cell [%s]: ",yesnostr(drawunit));
		drawunit = yesno(drawunit,STRING);
		break;
	    case 20:
		errtype("Temporary(?) trick to facilitate plotting two data sets");
		for (i=0;i<NDAT;i++)
		    {
		    HTH[i] = HDAT[i];
		    KTH[i] = KDAT[i];
		    LTH[i] = LDAT[i];
		    FTH[2][i] = FDAT[i];
		    }
		NTH = NDAT;
		break;
	    case 99:
		errtype("Temporary(?) routine to plot spec. density difference");
		for (i=0;i<NDENSITY;i++)
		    {
		    z[i] = ZLOW+i*(ZHIGH-ZLOW)/(NDENSITY-1);
		    dens[i] = 0;
		    for (j=0;j<NDAT;j++)
			{
			dens[i] += (FDAT[j]-FTH[2][j])*
				(cos(2*PI*LDAT[j]*z[i]-PHASE[j]));
			}
		    }
		    plotxye(z,dens,err,NDENSITY);

		break;
	    case 30:
		list_menu("PLOT MENU",plot_menu,plot_length);
		break;
	    case 31:
		stop = TRUE;
	    }
	}
    }

/***************************************************************************/
void    plot_circle(float xpos, float ypos, float radius, int mode, int fill)
/***************************************************************************/

    /*
    Plot a circle in predraw frame.
	mode -1         half-circle left of center
	mode  0         complete circle
	mode  1         half-circle right of center
        fill  0 / 1     empty / filled
    */

    {

    float       *x,*y,*e;

    if (fill)
        {
        sprintf(STRING, "draw fill -8 ret break");
        }
    else
        {
        sprintf(STRING, "draw fill 0 ret break");
        }
    put_command(STRING);
    plotxye(x,y,e,1);

    if (mode == -1)
	{
	sprintf(STRING,"draw rad %6.3f %6.3f %6.3f %6.3f break",
		xpos,ypos,radius,PI/2);
	put_command(STRING);
	plotxye(x,y,e,1);
	sprintf(STRING,"draw circle %6.3f %6.3f %6.3f %6.3f %6.3f break",
		xpos,ypos,radius,PI/2,3*PI/2);
	put_command(STRING);
	plotxye(x,y,e,1);
	sprintf(STRING,"draw rad %6.3f %6.3f %6.3f %6.3f break",
		xpos,ypos,radius,3*PI/2);
	put_command(STRING);
	plotxye(x,y,e,1);
	}
    if (mode == 0)
	{
	sprintf(STRING,"draw circle %6.3f %6.3f %6.3f %6.3f %6.3f break",
		xpos,ypos,radius,0.,2*PI);
	put_command(STRING);
	plotxye(x,y,e,1);
	}
    if (mode == 1)
	{
	sprintf(STRING,"draw rad %6.3f %6.3f %6.3f %6.3f break",
		xpos,ypos,radius,-PI/2);
	put_command(STRING);
	plotxye(x,y,e,1);
	sprintf(STRING,"draw circle %6.3f %6.3f %6.3f %6.3f %6.3f break",
		xpos,ypos,radius,-PI/2,PI/2);
	put_command(STRING);
	plotxye(x,y,e,1);
	sprintf(STRING,"draw rad %6.3f %6.3f %6.3f %6.3f break",
		xpos,ypos,radius,PI/2);
	put_command(STRING);
	plotxye(x,y,e,1);
	}
    }

/***************************************************************************/
void    plot_fourier(int mode)
/***************************************************************************/

    /*
    Plot Fourier contour plot of structure factors.
	mode 1  Patterson of experimental structure factors
	mode 2  Patterson of calculated structure factors
	mode 3  Electron density difference map
	mode 4  Electron density of model
    */

    {

//    float       *h,*k,*f;
//    int         nsymset;
    float       *z,*x,*y,zmin,zmax,zstep;
    float       cart,xcmin,xcmax,ycmin,ycmax,xstep,ystep,temp;
    float       xrange,yrange,ratio;
    float       xunit[5],yunit[5],eunit[5];
    float	tan5,sin5;
    long unsigned  /* done = 0, olddone = 0, total,*/ i, j;

#ifdef IMSLEG
    float	*cvalues;
#endif
#ifdef GRAPHIC
    int		*linestyles;
#endif
//    FILE	*patfile = NULL;

    if ((NSURF == 0) && (NBULK == 0))
	{
	errtype("No model read in");
	return;
	}

    /* Check number of steps */

    if (NXCON < 3) NXCON = 3;
    if (NYCON < 3) NYCON = 3;
#ifdef GRAPHIC
    if (NXCON%2 == 0) NXCON++;
    if (NYCON%2 == 0) NYCON++;
#endif

    /* Genetrate a set of symmetry-equivalent reflections from the
       data set */

    if (NTRANS == 0)
	{
	errtype("First set the symmetry group");
	set_symmetry();
	}

    /* Generate the set of symmetry-equivalent reflections */

    make_symmetry_set(mode);

    /* Allocate memory for the arrays neccesary for the Fourier map */

    if ((x = (float *)malloc(NXCON*sizeof(float))) == NULL)
	{
	errtype("Insufficient memory available");
	return;
	}
    if ((y = (float *)malloc(NYCON*sizeof(float))) == NULL)
	{
	errtype("Insufficient memory available");
	free(x);
	return;
	}
    if ((z = (float *)malloc(NXCON*NYCON*sizeof(float))) == NULL)
	{
	errtype("Insufficient memory available");
	free(x);
	free(y);
	return;
	}
#ifdef IMSLEG
    if ((cvalues = (float *)malloc((NLEVEL+5)*sizeof(float))) == NULL)
	{
	errtype("Insufficient memory available");
	free(x);
	free(y);
	free(z);
	return;
	}
#endif
#ifdef GRAPHIC
    if ((linestyles = (int *)malloc((NLEVEL+5)*sizeof(int))) == NULL)
	{
	errtype("Insufficient memory available");
	free(x);
	free(y);
	free(z);
	return;
	}
#endif

    /* Find the cartesian coordinates of the boundaries, such that
       the required unit cell fits in */

    xcmin = xcmax = XMINCON*DLAT[0]+YMINCON*DLAT[1]*cos(DLAT[5]);
    cart = XMAXCON*DLAT[0]+YMINCON*DLAT[1]*cos(DLAT[5]);
    if (cart < xcmin) xcmin = cart;
    if (cart > xcmax) xcmax = cart;
    cart = XMAXCON*DLAT[0]+YMAXCON*DLAT[1]*cos(DLAT[5]);
    if (cart < xcmin) xcmin = cart;
    if (cart > xcmax) xcmax = cart;
    cart = XMINCON*DLAT[0]+YMAXCON*DLAT[1]*cos(DLAT[5]);
    if (cart < xcmin) xcmin = cart;
    if (cart > xcmax) xcmax = cart;

    ycmin = ycmax = YMINCON*DLAT[1]*sin(DLAT[5]);
    cart = YMAXCON*DLAT[1]*sin(DLAT[5]);
    if (cart < ycmin) ycmin = cart;
    if (cart > ycmax) ycmax = cart;

    /* Compute arrays with x and y values */

    xstep = (xcmax-xcmin)/(NXCON-1);
    ystep = (ycmax-ycmin)/(NYCON-1);
    for (i = 0; i < NXCON; i++) x[i] = xcmin+i*xstep;
    for (i = 0; i < NYCON; i++) y[i] = ycmin+i*ystep;

    /* Compute the Patterson function */
/*
  if (strlen(PATFILENAME))
  {
  patfile = fopen(PATFILENAME,"w");
  }

  if (patfile!=NULL)
  {
  sprintf(STRING, "Writing map to output file \"%s\".\n", PATFILENAME);
  type_line(STRING);
  }

  if (patfile!=NULL)
  {
  fprintf(patfile,"! nx %d ny %d xmin %f xmax %f ymin %f ymax %f\n",
  NXCON, NYCON, xcmin, xcmax, ycmin, ycmax);
  }
*/
    tan5 = tan(DLAT[5]);
    sin5 = sin(DLAT[5]);
    zmin = zmax = 0;
    //total = (long)(NYCON)*(long)(NXCON);
    for (i = 0; i < NYCON; i++)
	{
	for (j = 0; j < NXCON; j++)
	    {
	    z[NXCON*i+j] = fourier((x[j]-y[i]/tan5)/DLAT[0],
				   y[i]/sin5/DLAT[1],mode);
	    if (z[NXCON*i+j] < zmin)  zmin = z[NXCON*i+j];
	    if (z[NXCON*i+j] > zmax)  zmax = z[NXCON*i+j];
/*
  if (patfile != NULL)
  fprintf(patfile, "%f ", z[NXCON*i+j]);
*/
            /* display percentage done */
/*
  done = 100*(i+1)*NYCON+(j+1);
  done /= total;
  if (done != olddone)
  {
  sprintf(STRING, "%3d%% done\r", done);
  type_line(STRING);
  olddone = done;
  }
*/
	    }	/* end j loop */
/*
  if (patfile != NULL)
  fprintf(patfile,"\n");
*/
	} /* end i loop */

    type_line("\n");
/*
  if (patfile != NULL)
  fclose(patfile);
*/
    sprintf(STRING,"Fourier map values ranging from %6.2f to %6.2f\n",
	    zmin,zmax);
    type_line(STRING);

    if (yesno(0, "Want me to plot map (may crash!) ? [NO] ") == TRUE)
	{

	/* Determine contour values to be plotted */

	if (MINCON < 0)
	    zmin = -MINCON*zmin;
	else
	    zmin = MINCON*zmax;
	if (MAXCON < 0)
	    zmax = -MAXCON*zmin;
	else
	    zmax = MAXCON*zmax;
	if (zmax < zmin)
	    {
	    temp = zmax;
	    zmax = zmin;
	    zmin = temp;
	    }
	if (NLEVEL < 2) NLEVEL = 2;
	zstep = (zmax-zmin)/(NLEVEL-1);
#ifdef IMSLEG
	for (i = 0; i < NLEVEL; i++)
	    {
	    cvalues[i] = zmin+zstep*i;
	    }
#endif
#ifdef GRAPHIC
	/* Set the line styles of the contour levels */

	for (i = 0; i < NLEVEL+5; i++)
	    {
	    if (zmin+i*zstep < 0)
		linestyles[i] = 141;
	    else
		linestyles[i] = 111;
	    }
#endif

	/* Define frame such that x and y scales have same units per length */

	xrange = xcmax-xcmin;
	yrange = ycmax-ycmin;
	if (xrange/yrange < XL/YL)
	    {
	    ratio = xcmin/xcmax;
	    xcmin = XL/YL*yrange*ratio/(1-ratio);
	    xcmax = XL/YL*yrange/(1-ratio);
	    }
	else
	    {
	    ratio = ycmin/ycmax;
	    ycmin = YL/XL*xrange*ratio/(1-ratio);
	    ycmax = YL/XL*xrange/(1-ratio);
	    }
 
	/* Define frame with manual axes */
 
#ifdef IMSLEG
	sprintf(STRING,"x man x low %6.3f x up %6.3f ret",xcmin,xcmax);
	put_command(STRING);
	plotxye(xunit,yunit,eunit,1);
	sprintf(STRING,"y man y low %6.3f y up %6.3f ret",ycmin,ycmax);
	put_command(STRING);
	plotxye(xunit,yunit,eunit,1);
#endif
#ifdef GRAPHIC
	sprintf(STRING,"x man x lin x low %6.3f x up %6.3f x tick %10.4e ret",
        	xcmin,xcmax,(xcmax-xcmin)/100.);
	put_command(STRING);
	plotxye(xunit,yunit,eunit,1);
	sprintf(STRING,"y man y lin y low %6.3f y up %6.3f y tick %10.4e ret",
        	ycmin,ycmax,(ycmax-ycmin)/100.);
	put_command(STRING);
	plotxye(xunit,yunit,eunit,1);
	sprintf(STRING,"x tit \"\" y tit \"\" title \"\" ret");
	put_command(STRING);
	plotxye(xunit,yunit,eunit,1);
	sprintf(STRING,
        	"layout width %6.2f height %6.2f xlen %6.2f ylen %6.2f ret ret",
#ifdef INCHES
        	XL+1.5,YL+1.5,XL,YL);
#endif
#ifdef METRIC
	XL+4,YL+4,XL,YL);
#endif
    put_command(STRING);
    plotxye(xunit,yunit,eunit,1);
    put_command("layout ax 1 fr 0 gr 0 sub 0 ret ret");
    plotxye(xunit,yunit,eunit,1);
#endif

    /* Make the actual contour plot */

#ifdef IMSLEG
    if (drawunit)
	put_command("make no cur 1 line 1 plo ret");
    else
	put_command("make yes cur 1 line 1 plo ret");
#endif
    /*
      #ifdef GRAPHIC
      if (drawunit)
      put_command("plo break");
      else
      put_command("plo ret");
      #endif
    */
#ifdef IMSLEG
    plotcon(z,x,NXCON,y,NYCON,NLEVEL,cvalues);
#endif
#ifdef GRAPHIC
    plotcon(z,x,NXCON,y,NYCON,zmin,zstep,zmax,linestyles,0);
#endif

    /* Draw unit cell in contour map */

    if (drawunit)
	{
	xunit[0] = yunit[0] = 0;
	xunit[1] = DLAT[0];
	yunit[1] = 0;
	xunit[2] = DLAT[0]+DLAT[1]*cos(DLAT[5]);
	yunit[2] = DLAT[1]*sin(DLAT[5]);
	xunit[3] = DLAT[1]*cos(DLAT[5]);
	yunit[3] = DLAT[1]*sin(DLAT[5]);
	xunit[4] = yunit[4] = 0;
#ifdef IMSLEG
	put_command("make yes cur 1 line 2 over");
#endif
#ifdef GRAPHIC
	put_command("col c black r cur 0 line 1 over ret");
#endif
	plotxye(xunit,yunit,eunit,5);
	}

    put_command("def return");
    plotxye(xunit,yunit,eunit,1);

    } /* end of yesno */

/* Free the previously allocated memory */

free(x);
free(y);
free(z);
#ifdef IMSLEG
free(cvalues);
#endif
#ifdef GRAPHIC
free(linestyles);
#endif
}

/***************************************************************************/
void    plot_model(int mode)
/***************************************************************************/

    /*
    Plot projection of structure model.
	mode 1  original model
	mode 2  refined model
	mode 3  original plus refined model
	mode 4  several unit cells of refined model
    */

    {

float       xmin,xmax,ymin,ymax,xrange,yrange,ratio;
int         i,j,k;
float       xunit[5],yunit[5],eunit[5];
float       x1,y1,marker_size;
int         nx,ny;

#ifdef IMSLEG
errtype("Not implemented");
#endif
#ifdef GRAPHIC
/* In modes 4/5/6 ask for number of repetitions in x and y directions */

if (mode == 4)
    {
nx = get_int(1,"Number of repetitions in x-direction [1]: ");
if (nx < 0) nx = 0;
ny = get_int(1,"Number of repetitions in y-direction [1]: ");
if (ny < 0) ny = 0;
}
else
    {
nx = ny = 1;
}


/* Find extrema of atomic positions in model */

xmin = ymin = 0.;   /* always include one unit cell */
xmax = ymax = 1.;
if ((mode == 1) || (mode == 3))
    {
for (i = 0; i < NSURF; i++)
    {
if (XS[i] < xmin) xmin = XS[i];
if (XS[i] > xmax) xmax = XS[i];
if (YS[i] < ymin) ymin = YS[i];
if (YS[i] > ymax) ymax = YS[i];
}
}
if ((mode == 2) || (mode == 3) || (mode == 4))
    {
for (i = 0; i < NSURF; i++)
    {
if (XSFIT[i] < xmin) xmin = XSFIT[i];
if (XSFIT[i] > xmax) xmax = XSFIT[i];
if (YSFIT[i] < ymin) ymin = YSFIT[i];
if (YSFIT[i] > ymax) ymax = YSFIT[i];
}
xmax += nx-1;
ymax += ny-1;
}

if (cos(DLAT[5]) < 0)
    {
xmin = xmin*DLAT[0]+ymax*DLAT[1]*cos(DLAT[5]);
xmax = xmax*DLAT[0]+ymin*DLAT[1]*cos(DLAT[5]);
}
else
    {
xmin = xmin*DLAT[0]+ymin*DLAT[1]*cos(DLAT[5]);
xmax = xmax*DLAT[0]+ymax*DLAT[1]*cos(DLAT[5]);
}
ymin = ymin*DLAT[1]*sin(DLAT[5]);
ymax = ymax*DLAT[1]*sin(DLAT[5]);

/* make frame somewhat larger than extreme values in reciprocal space */

xmin = xmin-0.5*DLAT[0];
xmax = xmax+0.5*DLAT[0];
ymin = ymin-0.5*DLAT[1]*sin(DLAT[5]);
ymax = ymax+0.5*DLAT[1]*sin(DLAT[5]);
xrange = xmax-xmin;
yrange = ymax-ymin;

/* Make frame such that x and y scales have same units per inch */

if (xrange/yrange < XL/YL)
    {
ratio = xmin/xmax;
xmin = XL/YL*yrange/(1/ratio-1);
xmax = XL/YL*yrange/(1-ratio);
}
else
    {
ratio = ymin/ymax;
ymin = YL/XL*xrange/(1/ratio-1);
ymax = YL/XL*xrange/(1-ratio);
}

/* Draw frame with unit cell */

sprintf(STRING,"def x man x low %6.3f x up %6.3f x tick %10.4e ret",
	xmin,xmax,(xmax-xmin)/100.);
put_command(STRING);
plotxye(xunit,yunit,eunit,1);
sprintf(STRING,"y man y low %6.3f y up %6.3f y tick %10.4e ret",
	ymin,ymax,(ymax-ymin)/100.);
put_command(STRING);
plotxye(xunit,yunit,eunit,1);
sprintf(STRING,"x tit \"\" y tit \"\" tit \"\" ret");
put_command(STRING);
plotxye(xunit,yunit,eunit,1);
sprintf(STRING,
	"layout width %6.2f height %6.2f xlen %6.2f ylen %6.2f ret ret",
#ifdef INCHES
	XL+1.5,YL+1.5,XL,YL);
#endif
#ifdef METRIC
XL+4,YL+4,XL,YL);
#endif
put_command(STRING);
plotxye(xunit,yunit,eunit,1);
xunit[0] = ((nx-1)/2)*DLAT[0]+((ny-1)/2)*DLAT[1]*cos(DLAT[5]);
yunit[0] = ((ny-1)/2)*DLAT[1]*sin(DLAT[5]);
xunit[1] = ((nx-1)/2+1)*DLAT[0]+((ny-1)/2)*DLAT[1]*cos(DLAT[5]);
yunit[1] = ((ny-1)/2)*DLAT[1]*sin(DLAT[5]);
xunit[2] = ((nx-1)/2+1)*DLAT[0]+((ny-1)/2+1)*DLAT[1]*cos(DLAT[5]);
yunit[2] = ((ny-1)/2+1)*DLAT[1]*sin(DLAT[5]);
xunit[3] = ((nx-1)/2)*DLAT[0]+((ny-1)/2+1)*DLAT[1]*cos(DLAT[5]);
yunit[3] = ((ny-1)/2+1)*DLAT[1]*sin(DLAT[5]);
xunit[4] = xunit[0];
yunit[4] = yunit[0];
put_command(
"layout ax 1 fr 0 gr 0 sub 0 ret curve 0 line 4 pl line 1 break");
plotxye(xunit,yunit,eunit,5);

    /* Draw original model */

if ((mode == 1) || (mode == 3))
    {
if (mode == 3)
    {
put_command("line 4 break");
plotxye(xunit,yunit,eunit,1);
}
for (i = 0; i < NSURF; i++)
    {
x1 = XS[i]*DLAT[0]+YS[i]*DLAT[1]*cos(DLAT[5]);
y1 = YS[i]*DLAT[1]*sin(DLAT[5]);
marker_size = DLAT[0]*ATRAD[TS[i]];
plot_circle(x1,y1,marker_size,0,0);
}
if (mode == 3)
    {
put_command("line 1 break");
plotxye(xunit,yunit,eunit,1);
}
}

/* Draw refined model */

if ((mode == 2) || (mode == 3) || (mode == 4))
    {
for (i = 0; i < NSURF; i++)
    {
marker_size = DLAT[0]*ATRAD[TS[i]];
for (j = 0; j < nx; j++)
    {
for (k = 0; k < ny; k++)
    {
x1 = (XSFIT[i]+j)*DLAT[0]+
(YSFIT[i]+k)*DLAT[1]*cos(DLAT[5]);
y1 = (YSFIT[i]+k)*DLAT[1]*sin(DLAT[5]);
plot_circle(x1,y1,marker_size,0,0);
}
}
}
}
put_command("def return");
plotxye(xunit,yunit,eunit,1);
#endif
}

/***************************************************************************/
void    plot_sfac(int mode)
/***************************************************************************/

    /*
    Plot magnitude of structure factors as circles in reciprocal space.
	mode 1  theoretical structure factors
	mode 2  experimental structure factors
	mode 3  theoretical plus experimental structure factors
    */

    {

float       fmax;
float       xmin,xmax,ymin,ymax,xrange,yrange,ratio;
int         i;
float       xunit[5],yunit[5],eunit[5];
float       x1,y1,marker_size;

#ifdef IMSLEG
errtype("Not implemented");
#endif
#ifdef GRAPHIC
/* Find extrema in reciprocal space and in structure factors */

if ((mode == 1) || (mode == 3))
    {
/*fmin = FTH[2][0];*/
fmax = FTH[2][0];
}
else
    {
/*fmin = FDAT[0];*/
fmax = FDAT[0];
}
xmin = ymin = 0.;   /* always include one unit cell */
xmax = ymax = 1.;
if ((mode == 1) || (mode == 3))
    {
for (i = 0; i < NTH; i++)
    {
/*if (FTH[2][i] < fmin) fmin = FTH[2][i];*/
if ((mode == 1) && (FTH[2][i] > fmax)) fmax = FTH[2][i];
if (HTH[i] < xmin) xmin = HTH[i];
if (HTH[i] > xmax) xmax = HTH[i];
if (KTH[i] < ymin) ymin = KTH[i];
if (KTH[i] > ymax) ymax = KTH[i];
}
}
if ((mode == 2) || (mode == 3))
    {
for (i = 0; i < NDAT; i++)
    {
/*if (FDAT[i] < fmin) fmin = FDAT[i];*/
if (FDAT[i] > fmax) fmax = FDAT[i];
if (HDAT[i] < xmin) xmin = HDAT[i];
if (HDAT[i] > xmax) xmax = HDAT[i];
if (KDAT[i] < ymin) ymin = KDAT[i];
if (KDAT[i] > ymax) ymax = KDAT[i];
}
}
if (cos(RLAT[5]) < 0)
    {
xmin = xmin*RLAT[0]+ymax*RLAT[1]*cos(RLAT[5]);
xmax = xmax*RLAT[0]+ymin*RLAT[1]*cos(RLAT[5]);
}
else
    {
xmin = xmin*RLAT[0]+ymin*RLAT[1]*cos(RLAT[5]);
xmax = xmax*RLAT[0]+ymax*RLAT[1]*cos(RLAT[5]);
}
ymin = ymin*RLAT[1]*sin(RLAT[5]);
ymax = ymax*RLAT[1]*sin(RLAT[5]);

/* make frame somewhat larger than extreme values in reciprocal space */

xmin = xmin-0.5*RLAT[0];
xmax = xmax+0.5*RLAT[0];
ymin = ymin-0.5*RLAT[1]*sin(RLAT[5]);
ymax = ymax+0.5*RLAT[1]*sin(RLAT[5]);
xrange = xmax-xmin;
yrange = ymax-ymin;

/* Make frame such that x and y scales have same units per inch */

if (xrange/yrange < XL/YL)
    {
ratio = xmin/xmax;
xmin = XL/YL*yrange/(1/ratio-1);
xmax = XL/YL*yrange/(1-ratio);
}
else
    {
ratio = ymin/ymax;
ymin = YL/XL*xrange/((1/ratio)-1);
ymax = YL/XL*xrange/(1-ratio);
}

/* Draw frame with unit cell */

sprintf(STRING,"def col curve black ret x man x low %6.3f x up %6.3f x tick %10.4e ret",
	xmin,xmax,(xmax-xmin)/100.);
put_command(STRING);
plotxye(xunit,yunit,eunit,1);
sprintf(STRING,"y man y low %6.3f y up %6.3f y tick %10.4e ret",
	ymin,ymax,(ymax-ymin)/100.);
put_command(STRING);
plotxye(xunit,yunit,eunit,1);
sprintf(STRING,"x t \"\" y t \"\" tit \"\" ret");
put_command(STRING);
plotxye(xunit,yunit,eunit,1);
sprintf(STRING,
	"layout width %6.2f height %6.2f xlen %6.2f ylen %6.2f ret ret",
#ifdef INCHES
	XL+1.5,YL+1.5,XL,YL);
#endif
#ifdef METRIC
XL+4,YL+4,XL,YL);
#endif
put_command(STRING);
plotxye(xunit,yunit,eunit,1);
xunit[0] = yunit[0] = 0.;
xunit[1] = RLAT[0];
yunit[1] = 0.;
xunit[2] = RLAT[0]+RLAT[1]*cos(RLAT[5]);
yunit[2] = RLAT[1]*sin(RLAT[5]);
xunit[3] = RLAT[1]*cos(RLAT[5]);
yunit[3] = RLAT[1]*sin(RLAT[5]);
xunit[4] = yunit[4] = 0.;
put_command(
"layout ax 1 fr 0 gr 0 sub 0 ret curve 0 line 4 pl line 1 break");
plotxye(xunit,yunit,eunit,5);


    /* Draw all structure factors in frame */

if ((mode == 1) || (mode == 3))
    {
for (i = 0; i < NTH; i++)
    {
if (FTH[2][i] > FTHRESHOLD*fmax)
    {
x1 = HTH[i]*RLAT[0]+KTH[i]*RLAT[1]*cos(RLAT[5]);
y1 = KTH[i]*RLAT[1]*sin(RLAT[5]);
/*marker_size = (MINSIZE*(fmax-FTH[2][i])+
  MAXSIZE*(FTH[2][i]-fmin))/(fmax-fmin);*/
marker_size = FSIZE*(xmax-xmin)*FTH[2][i]/fmax;
if (mode == 1) plot_circle(x1,y1,marker_size,0,0);
if (mode == 3) plot_circle(x1,y1,marker_size,-1,0);
}
}
}
if ((mode == 2) || (mode == 3))
    {
for (i = 0; i < NDAT; i++)
    {
if (FDAT[i] > FTHRESHOLD*fmax)
    {
x1 = HDAT[i]*RLAT[0]+KDAT[i]*RLAT[1]*cos(RLAT[5]);
y1 = KDAT[i]*RLAT[1]*sin(RLAT[5]);
/*marker_size = (MINSIZE*(fmax-FDAT[i])+
  MAXSIZE*(FDAT[i]-fmin))/(fmax-fmin);*/
marker_size = FSIZE*(xmax-xmin)*FDAT[i]/fmax;
if (mode == 2) plot_circle(x1,y1,marker_size,0,1);
if (mode == 3) plot_circle(x1,y1,marker_size,1,1);
}
}
}

put_command("def return");
plotxye(xunit,yunit,eunit,1);
#endif
}

/***************************************************************************/
void    plot_zdensity()
/***************************************************************************/

    /*
    Plot z-projected electron density, with strength depending on the
    in-plane momentum transfer.
    */

    {

//#define	NDENS	500
    float       h,k,zmin,qpar,zmax,zstep;
    double	usqr_perp,weight,dw_perp,dw_par,occupancy;
//    float	z[NDENS],dens[NDENS],e[NDENS];
    int	i,j;

    /* Get in-plane diffraction indices */

    h = get_real(0,"Diffraction index h [0]: ");
    k = get_real(0,"Diffraction index k [0]: ");
    qpar = q_length(h,k,0);

    /* Determine calculation range */

    zmin = zmax = 0.;
    for (i = 0; i < NBULK; i++)
	{
	if (ZB[i] < zmin) zmin = ZB[i];
	if (ZB[i] > zmax) zmax = ZB[i];
	}
    for (i = 0; i < NSURF; i++)
	{
	if (ZSFIT[i] < zmin) zmin = ZSFIT[i];
	if (ZSFIT[i] > zmax) zmax = ZSFIT[i];
	}
    zmin -= 0.1;
    zmax += 0.1;
    zstep = (zmax-zmin)/(NDENS-1);

    /* Initialize density array */

    for (i = 0; i < NDENS; i++)
	{
	DENS[i] = 0.;
	ZDENS[i] = zmin+i*zstep;
	}

    /* Sum the contributions of all the individual atoms */
    /* The vibration amplitude is expressed in fractional coordinates */

    for (i = 0; i < NBULK; i++)
	{
	if (NDWB[i] == 0)
	    usqr_perp = 0.0001;
	else
	    usqr_perp= DEBWAL[NDWB[i]-1]/(8*PI*PI*DLAT[2]*DLAT[2]);
	if (usqr_perp < 0.0001) usqr_perp = 0.0001;
	if (NDWB[i] == 0)
	    dw_par = 0.;
	else
	    dw_par = DEBWAL[NDWB[i]-1];
	weight = f_atomic(0.,TB[i])
		*exp(-qpar*qpar*dw_par/PIPI16)
		/sqrt(usqr_perp*PI);
	for (j = 0; j < NDENS; j++)
	    {
	    DENS[j] += weight*exp(-sqr(ZB[i]-ZDENS[j])/usqr_perp);
	    }
	}

    for (i = 0; i < NSURF; i++)
	{
	if (NDWS2[i] == 0) /* isotropic DW parameter */
	    {
	    if (NDWS[i] == 0)
		dw_perp = 0.;
	    else
		dw_perp = DEBWAL[NDWS[i]-1];
	    }
	else
	    dw_perp = DEBWAL2[NDWS2[i]-1];
	usqr_perp = dw_perp/(8*PI*PI*DLAT[2]*DLAT[2]);
	if (usqr_perp < 0.0001) usqr_perp = 0.0001;
	if (NOCCUP[i] == 0) occupancy = 1.;
	else occupancy = OCCUP[NOCCUP[i]-1];
	if (NDWS[i] == 0)
	    dw_par = 0.;
	else
	    dw_par = DEBWAL[NDWS[i]-1];
	weight = f_atomic(0.,TS[i])
		*occupancy
		*exp(-qpar*qpar*dw_par/PIPI16)
		/sqrt(usqr_perp*PI);
	for (j = 0; j < NDENS; j++)
	    {
	    DENS[j] += weight*exp(-sqr(ZSFIT[i]-ZDENS[j])/usqr_perp);
	    }
	}

    /* Convert the fractional z-coordinates to Angstroms */

    for (i = 0; i < NDENS; i++) ZDENS[i] *= DLAT[2];

    /* And now plot the results */

    plotxye(ZDENS,DENS,EDENS,NDENS);

    }

#endif  /* ALLOW_PLOT */
