/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                    lsqfit.h                         $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: lsqfit.h,v 1.3 2003/05/14 19:12:18 walker Exp $

****************************************************************************/

/* Defines */

#define	LSQ_NOFIT	0
#define LSQ_LEVENBERG	1
#define LSQ_COOLDOWN	2
#define LSQ_ASA		4
#define LSQ_BREAK_RESTORE		3

#define LSQ_FNAMETERMINAL       "<TERMINAL>"
//#define COOL
#define ASA

/* Type definitions */

/*
    The function type "FitFunction" is used by lsqfit() and cooldown() for
    computing the model function f(x).

    Arguments are as follows:
	float           x-value for which the function should be computed
	float *         array of parameter values
	float *         pointer to y-value to be computed

    The following arguments are optional and only used by lsqfit():

	float *         pointer to computed analytical derivatives dy/da
	int             total number of parameters (needed for comp. of deriv.)
	int             flag denoting whether analytical derivatives should
			be computed.

    The function type "FitFunctionASA is required for the ASA function
    minimisation. The required format is rather different, thus a second
    function type seemed the best way to support ASA.
*/

typedef void (*FitFunction)(float, float *, float *, float *, int, int);
#ifdef ASA
typedef float (*FitFunctionASA)(float *, int *);
typedef double (*RandomASA)(void);
#endif

/* global variables */

#ifndef LSQFIT
//extern int	LSQ_NSTEPS	; /* number of steps for every temperature step */
//extern int	LSQ_NLIST	; /* number of steps between lists in cooldown() */
//extern int	LSQ_NACC	; /* number of steps between eval. of acc. ratio */
//extern float	LSQ_TSTART	; /* initial temperature */
//extern float	LSQ_DCHICONV	; /* norm. chi^2 convergence criterion */
//extern float	LSQ_NDECADE	; /* number of anneals per temperature decade */
//extern FILE*	LSQ_LOGFILE	; /* list file for cooldown() */
//extern char     *LSQ_LOGFNAME   ; /* name of log file during fitting */
//extern int      LSQ_USELOG      ; /* use logarithm of data for chi^2 evaluation (cooldown only) */
extern	FILE	*FIT_LOGFILE;	/* File with summary of fit results */
extern	char    FIT_LOGFILE_NAME[128];	/* Name of the fit summary file */
extern	int	LOGFILE;	/* Flag to denote whether logfile is kept yes/no */
#ifdef ASA
extern int      TEMPERATURE_ANNEAL_SCALE;
extern float    ACCEPTED_LIMIT;
extern long int	LIMIT_ACCEPTANCES; /* ASA: max number of acceptances */
extern float    TEMPERATURE_RATIO_SCALE;
extern float    COST_PARAMETER_SCALE;
extern int      TESTING_FREQUENCY_MODULUS ;
extern int	ASA_NPRINT;	/* printing line frequency */
extern int	USER_INITIAL_PARAMETERS;
//extern   long int steps;
#endif /* ASA */
#endif /* ifndef LSQFIT */

/* Exported functions of lsqfit.c */

/* levenberg is called directly by ana */
int     levenberg(float x[], float y[], float wgt[], int ndata,
 	      float a[], int ma, int lista[], int mfit, float asig[],
	      float amin[], float amax[], float apen[], float *chisqr,
	      FitFunction funcs,
	      int derivatives);

/* lsqfit is called by rod; it allows various minimization schemes */
int     lsqfit(float x[], float y[], float wgt[], int ndata,
	          float a[], int ma, int lista[], int mfit, float asig[],
  	          float amin[], float amax[], float apen[], float *chisqr,
		  FitFunction funcs,
#ifdef ASA
		  FitFunctionASA funcsasa,
#endif
		  char *fittxt, int txtlength,
		  int derivatives, int method, int calcquality);

void    lsq_breakcontrol ( int command, FitFunction funcs, float *a, int na);
int     set_fitpar(char *prompt, int npar,
		   float *fpar, float *fmin, float *fmax,
		   int *check, int *fix, char *names, int namelength,
		   float *xdata, float *ydata, float *wgtdata,
		   int ndata, FitFunction funcs );

float    ffit_asa(float a[], int *cost_flag);
