/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                 walker.h                            $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: walker.h,v 1.5 2001/09/17 13:39:26 svensson Exp $

****************************************************************************/

/*

Update 17/09/2001 O. Svensson (svensson@esrf.fr)
                  Added missing function header for walker_write_initmac().
Update 13/11/2000 O. Svensson (svensson@esrf.fr)
                  Added new function header for walker_write_xyz(),
		  renamed functions to start with "walker_".
Update 25/10/2000 O. Svensson (svensson@esrf.fr)
                  Added function prototype for walker_init().
                  Renamed NXCELLS etc. to WALKER_NXCELLS etc.
*/


#ifndef _WALKER_H_
#define _WALKER_H_

#include "sockhelp.h"

SET int walker_flag;      /* flag for using Walker's extensions of ROD*/

/* Number of x, y and z cells in xyz output */

SET int WALKER_NXCELLS;
SET int WALKER_NYCELLS;
SET int WALKER_NZCELLS;
SET int WALKER_SECOND;

/* max chars in an internet hostname is something like 128, so have one more */
/* than this to allow for null terminator */
SET char RASMOL_PORT[129];            /* = "21069";          */
SET char RASMOL_HOST[129];            /* = "localhost";      */
SET char RASMOL_FILE[FILENAME_MAX+1]; /* = "rod_rasmol.xyz"; */

void walker(void);
void walker_init(void);
int  walker_write_initmac(FILE *file);
int  walker_write_xyz(char *filename);
void walker_send_xyz_to_rasmol(void);
void walker_set_rasmol(void);
void walker_rasmol_cmd(void); /* like opsys, but send user commands to rasmol */
void walker_set_menu(void);
int  walker_send_cmd_to_rasmol(char *command); /* internally used to send commands */
                                               /* to rasmol via a socket           */
void walker_rasmol_menu(void);
#endif









