/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                  robach.h                           $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: robach.h,v 1.13 2007/03/19 15:31:12 wilcke Exp $

****************************************************************************/

/*

Update 06/03/2007 R. Wilcke (wilcke@esrf.fr)
                  remove declaration of NPARAMTOT (no longer needed).
OR070103
add new occupancy profile for extended model
uniform occupancy up to n=nmax
then beta^(n-nmax) occ profile

OR100901
add possibility to use complex atomic scattering factors
in view of fitting magnetic diffraction rods later

Update 25/09/2001 O. Svensson (svensson@esrf.fr)
                  Moved definitions of dzplane, zplane, occ1plane
                  and occ2plane to robach.c

OR270201 add new type of extended model to fit the specular rod
(at "high") angles, when there are several layers. (slab model)

OR160201 add flag for multiplying or not the surface contribution
by the roughness factor of the bulk

OR071100
modif O. Robach 07/11/00. In ratio mode,
default = 	- all atoms of .FIT file are ADSORBATE atoms
		- all atoms of .BUL file are SUBSTRATE atoms
in other cases : define which atoms of the .FIT file are SUBSTRATE atoms
end OR071100

Update 25/10/2000 O. Svensson (svensson@esrf.fr)
                  Added #ifndef _ROBACH_H_ etc.
                  Added function prototype for robach_init().

*/

#ifndef _ROBACH_H_
#define _ROBACH_H_

SET int robach_flag;           /* flag for using Robach's extensions of ROD */

#define ROBACH_MACFILE "rob_ext.mac" /* file to store macros commands
                                        corresponding to Robach's extension */

/* general constants */
#define NSF_OR 7                /* Number of 'single' fitting parameters:
                                   SCALE, BETA, SURFFRAC,LSHIFT,
                                   SCALE3, SURF2FRAC, WIDTH */
#define MAXSURFLAYERS 5	        /* maximum number of non equivalent layers
                                   in surface unit cell for extended model */

/* roughness models */
#define APPROXERF 8             /* use erf roughness for bulk + surface
                                   cf ROD version PG */
/*OR160201*/
CALC int roughfsurf_flag;       /* flag for multiplying (1) or not (0) fsurf by
                                   the bulk roughness factor */
/*end OR160201*/

/* fitting parameters */

SET float SURF2FRACLIM[2];       /* Fit limits for 2nd surface fraction */
SET int SURF2FRACPEN;            /* Penalty factor for 2nd surface fraction */

/* allow linked z displacements */
FIT float ZCONST[MAXATOMS];      /* Multiplication factor of z-displacement
                                    parameter */
FIT int NZ2DIS[MAXATOMS];        /* Serial number of 2nd z-displacement par. */
FIT float Z2CONST[MAXATOMS];     /* Multiplication factor of 2nd z-displacement
                                    parameter */
FIT int NOCCUPB[MAXATOMS];       /* Serial number of bulk occupation fraction */

PLOT float LSHIFT;               /* lshift between theory and exp */
PLOT float LSHIFTLIM[2];         /* Fit limits for lshift parameter */
PLOT int LSHIFTPEN;              /* Penalty factor for lshift parameter */
PLOT float SCALE3;               /* scale factor for frac. order peaks*/
PLOT float SCALE3LIM[2];         /* Fit limits for scale 3 parameter */
PLOT int SCALE3PEN;              /* Penalty factor for scale 3 parameter */

/*
 * Things used in the PG extended model.
 *
 * Remark for the PG extended model: in "rod.h" we have the declaration
 *   PLOT float FTH[3][MAXTHEO];
 * with the comment:
 *   Structure factors for bulk, surface and interference sum
 *
 * In ratio mode, the comment becomes:
 *   - the structure factor for the interference sum for the substrate alone,
 *   - the structure factor for the interference sum for the substrate plus the
 *     adsorbate,
 *   - the ratio between these two quantitities.
*/

/*
 * The way each adsorbate atom in the .fit file gets extended onto several
 * planes.
 */
CALC struct {
  int MODE;            /* calculate in normal (false) or extended (true) mode */
  int ZDIS;            /* serial number of z distribution function */
  int NSTART;          /* the atom to be extended is in plane number NSTART of
                          the z distribution*/
  int NPLANS;          /* number of atomic planes to be calculated */
  int NLAYERS;         /* number of inequivalent layers */
                       /* translation of inequivalent planes */
  float XSHIFT[MAXSURFLAYERS],YSHIFT[MAXSURFLAYERS];
  int ODIS;            /* serial number of  occupancy distribution function */
  int ORIGIN;          /* atom number for the z distribution z origin */
  float ZSHIFT;        /* shift to enable a given occ. distr. to start at plane
                          number 0 whatever the extended atom considered */
} EXTAT[MAXATOMS];

/*
 * Adsorbate interplane distance profiles with their parameters.
 *
 * Meaning of the parameters of z function number k:
 * (we use 1 to 4 parameters depending on the dz function)
 *
 * ZFUNC[k].type = type of dz(z) function. Available types are:
 *
 * - no relaxation (dz independent of z) (1 param)
 * - exponential relaxation (3 param)
 * - erf relaxation with parameters linked to the one of the occ function #k
 *   (2 param)
 * - erf relaxation with parameters indep of the ones of the occ function
 *   (4 param)
 *
 * ZFUNC[k].ZPAR[0] = dzinf = dz which the function tends towards when z goes
 *                            to + infinite
 * ZFUNC[k].ZPAR[1] = dz0 = dz for first plane of model
 * ZFUNC[k].ZPAR[2] = sigmaz = approx. the width of the dz(z) function
 * ZFUNC[k].ZPAR[3] = zmeanz = the central value of the dz(z) function
 *                             (used only for erf profile)
 */
CALC struct {
  int type;
  float ZPAR[4];
  float ZPARLIM[4][2];
  int ZPARPEN[4];
} ZFUNC[MAXATOMS];

/*
 * Adsorbate occupancy profiles with their parameters.
 *
 * Meaning of the parameters of occ function number k:
 * (we use 1 to 2 parameters depending on the occ function)
 *
 * OFUNC[k].type = type of occ(z) function. Available types are:
 *
 * - uniform (occ=occ0 for z<zmeano, 0 for z>zmeano) (1 param = zmeano)
 * - erf occupancy with fit on total occupancy (2 param)
 * - gauss occupancy (2 param)
 * - exp occupancy (1 param sigmao)
 * - erf occupancy with fit on first plane occupancy (2 param)
 * - uniform occupancy then beta^n occupancy (2 param)
 *
 * OFUNC[k].OPAR[0] = zmeano = "central" value of the occ function
 * OFUNC[k].OPAR[1] = sigmao = approx. the width of the occ(z) function
 *
 * In all the occupancy functions, the scaling (total occupancy occtot of the
 * extended atom, or occupancy occ0 of the first plane of the extended atom) is
 * done by the standard occupancy parameter of the extended atom.
 *
 * occtot or occ0 is NOT a parameter of the occ function.
 */
CALC struct {
  int type;
  float OPAR[2];
  float OPARLIM[2][2];
  int OPARPEN[2];
} OFUNC[MAXATOMS];

CALC int NZFUNCTOT;
CALC int NOFUNCTOT;

/* Names of parameters in dz and occ functions */
CALC char FUNCTXT[4][TITLE_LENGTH];

/*
 * Parameters used when fitting the ratio
 *     "|F(after_deposit)| / |F(before_deposit)|"
 * instead of
 *     |F(after_deposit)|.
 *
 * The program calculates |F(bulk + surface)| as usual, and then divides it by
 * |F(bulk0 + surface0)|, where bulk0 may have a roughness BETA2 different from
 * that used for bulk, and surface0 has a zero occupancy for all the atoms of
 * the surface unit cell that are not substrate atoms.
 */

/* ratio_flag = 0 when fitting F(S+A), =1 when fitting F(S+A)/F(S) */
CALC int ratio_flag;

/*
 * for calculating the ratio F(S+A)/F(S), the routines of calc.c use :
 *   deposit_flag=AFTER_DEPOSIT for calculating F(S+A)
 *   deposit_flag=BEFORE_DEPOSIT for calculating F(S)
 */
CALC int deposit_flag;
#define BEFORE_DEPOSIT	0
#define AFTER_DEPOSIT 	1

CALC float BETA2;                    /* starting roughness of the substrate,
                                        used in calculating F(S) */

/* modif OR071100 */
/* for ratio option */
#define MAXSUBSTRATEATOMS 10          /* max number of substrate atoms in the
                                         .FIT file */
CALC int sub_atom[MAXSUBSTRATEATOMS]; /* numbers in the .FIT file of the
                                         substrate atoms */
CALC int NSUBSTRATE;                  /* total number of substrate atoms in the
                                         .FIT file */
/* end modif OR071100 */

/* for relaxed adsorbate */

CALC int relax_flag;                  /* flag to calculate in pseudomorphic
                                         (false) or relaxed (true) mode */
CALC float MISFIT;                    /* in relaxed mode, value of
                                         (a//ads-a//sub)/(a//sub) */
CALC float WIDTH;                     /* width of domains of relaxed adsorbate*/
CALC float WIDTHLIM[2];	              /* fit limits for width parameter */
CALC int WIDTHPEN;                    /* penalty factor for width parameter */

/*add220800*/
/*
 * New option for using a NLAYER (in the calculation of the roughness) that
 * varies with the data point HKL considered.
 *
 * This implies to use SIGMA (rms roughness) instead of BETA as the fitting
 * parameter. (If nl varies between the different CTRS and beta does not vary,
 * then sigma varies and that's bad.)
 *
 * For the moment this option works only for the APPROX BETA roughness model.
 * For this model we have the relation:
 *    sigma = [sqrt(beta)/(1-beta)]*[cs/nlayers]
 *
 * This option was implemented to treat the case of Si (001) because nl=2 for
 * 10L and 30L, and nl=4 for 20L and 11L. (empirically)
 *
 * One has to add to the data file a new column called "nlayer".
 */
SET float NL_OR[MAXDATA]; /* same as NLAYERS but for each data point */
CALC int var_nlayers;     /* flag to use a variable NLAYERS or not */
PLOT float SIGMA;         /* rms roughness, replaces BETA as the fitting
                             parameter when var_nlayers=1 */
PLOT float SIGMALIM[2];   /* Fit limits for rms roughness parameter */
PLOT int SIGMAPEN;	  /* Penalty factor for rms roughness parameter */

CALC float SIGMA2;        /* in ratio mode, replaces BETA2 when var_nlayers=1 */

float calc_nlayer(float h, float k, float l);

/*endadd220800*/

/* add230800 */
/* something useful for treating the interdiffusion */
FIT int NOCCUP2[MAXATOMS];      /* Serial number of 2nd. occupation fraction */
FIT float OCCUPTOT[MAXPAR];     /* Values of occupation parameters */
/* endadd230800 */

/* add270201 */
/*
 * Multislab model, for binary alloys.
 *
 * One needs to put two atoms in the fit file, at the same place, for example
 * one Pt and one Ni for slabs containing pure Ni, pure Pt, or a Ni-Pt alloy.
 *
 * For the moment this works only to model the specular rod (00L) because the
 * handling of x,y coordinates is not so straightforward when the different
 * slabs have different stackings
 */
#define MAXPLANE 20 	/* maximum number of planes in model */
#define MAXSLAB 5	/* maximum number of slabs in model */

/*
 * Define a slab.
 *
 * The 4 parameters of slab number j, SPAR[i][j], with i from 0 to 3, are:
 * SLAB[j].SPAR[0]: slab composition: %(atom #1) = COMP, %(atom #2) = 1-COMP
 * SLAB[j].SPAR[1]: maximum occupancy of one plane in the slab (at #1 + at #2)
 * SLAB[j].SPAR[2]: mean thickness of the slab, units = number of planes
 * SLAB[j].SPAR[3]: roughness of the top surface (or top interface) of the slab:
 *    - units = number of planes
 *    - here we use only erf occ profiles for both the bottom and the top of the
 *      slab, but with different roughnesses
 *    - the bottom roughness of slab i is set equal to the top roughness of
 *      slab i-1

 * Here, in contrast with the extended model, the occupancy parameter is
 * included in the slab model: one should put occupancy serial numbers equal to
 * 0 for the 2 alloy atoms in the .fit file.
 */
FIT struct {
  float SPAR[4];
  float SPARLIM[4][2];
  int SPARPEN[4];
} SLAB[MAXSLAB];

/*
 * Interplane distance along z for the two elements in the bulk phase.
 * For mixed planes, we assume that Vegard's Law applies:
 *    dz= [ occ(elt 1)*dz1 + occ(elt 2)*dz2 ] / [occ1+occ2]
 */
CALC float dz_bulk[2];
CALC int alloy_atom[2] ;            /* numbers in the fit file of the two atoms
                                       that get extended over several planes to
                                       create the alloy slabs */
CALC int NSLAB ;                    /* total number of slabs in model */

CALC char SLABTXT[4][TITLE_LENGTH]; /* Names of parameters in slabs */

CALC float dzplane[MAXPLANE];       /* dz around each particular plane of the
                                       slab model */
CALC float zplane[MAXPLANE];        /* z of each plane of the slab model */
CALC float occ1plane[MAXPLANE];     /* occupancy of alloy atom 0 for each plane
                                       of the slab model */
CALC float occ2plane[MAXPLANE];     /* occupancy of alloy atom 2 for each plane
                                       of the slab model */

void set_slab(void);
void list_slab_model(void);
void get_slab_occ(int planenum, int slabnum, float *occ1, float*occ2);
void f_slabs(int i, float h, float k, float l, float *re, float *im);

/* endadd270201 */

/* add160801 */

void calc_all_dzs(void);
void calc_all_zs(void);

/* endadd160801 */

/* add100901 */
/* this part is intended for:
 * - correcting the f_atomic of Pt near the LIII absorption edge
 *   (now f_atomic will be a complex for Pt)
 * - setting up the magnetic model (distribution of nm of the different Pt
 *   atoms)
 * - calculating and fitting the magnetic diffraction data
 *
 * similar to Mathcad calculation C8 p 140-142
 */
CALC int anomalous_flag;   /* flag to activate/deactivate anomalous calculation.
                              for the moment : only for Pt */
#define REAL_fat 0
#define COMPLEX_fat 1

CALC float LIII;           /* energy of resonance 11569 eV */
CALC float gamma_width;    /* width of resonance (in energy) 4 eV */
CALC float NC;             /* cf De Bergevin PRB 92, parameter used in fprime */
CALC float NCS;            /* idem, parameter used in fprime and fdoubleprime */
CALC float NS;             /* idem, parameter used in fdoubleprime */
CALC float NP;             /* idem, parameter used in ares */

CALC int diffraction_mode; /* flag to define the geometry of the scattering:
                              specular or fixed incidence */
#define SPECULAR 0
#define FIXED_INCIDENCE 1

CALC float MU;             /* fixed incidence angle, in degrees */

#ifdef SPEEDUP
/*
 * real and imaginary part of atomic scattering factor for all atom types of
 * i-th data point
 */
CALC float RE_FAT[MAXDATA][MAXTYPES];
CALC float IM_FAT[MAXDATA][MAXTYPES];
#endif /* SPEEDUP */

/* endadd100901 */

/* in robach.c */

void robach(void);
void robach_init(void);
void rob_write_mac(void);
void rob_set(void);
void set_adsorbate(void);
void set_ads_extended(void);
void set_ads_functions(void);
void set_ads_calc(void);
void rob_set_par(void);
void rob_set_fit(void);
void list_ext_model(void);
float f_erf_rough(float x);
void ratio_calc(float h, float k, float l, float atten, float lbragg,
  float *fsub, float *ftot, float *asratio);
float erfcc(float x);
void get(int i, int n, float *x, float *y, float*z, float *occ);
void f_extended(int i, float h, float k, float l, float *re, float *im);

/* add100901 */

void set_anomalous(void);

/* in robach_cx.cpp */

#ifdef SPEEDUP
float f_calc_fit_cx(float h, float k, float l, float lbragg, float q_par,
  float q_perp, float re_fat[], float im_fat[], float re_bulk[],
  float im_bulk[], float fbulk_sqr);
void f_calc_fit_init_cx(void);
#endif /* SPEEDUP */
void f_calc_cx(float h, float k, float l, float atten, float lbragg,
  float *fbulk, float *fsurf, float *fsum, float *phase);

/* endadd100901 */

#endif /* _ROBACH_H_ */
