/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/
/*$$$$$$$$$$                    ave.h                            $$$$$$$$$$*/
/*$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

/****************************************************************************

  CVS information:

  $Id: ave.h,v 1.8 2002/03/28 11:50:34 wilcke Exp $

****************************************************************************/

/*

Update 28/02/2002 R. Wilcke (wilcke@esrf.fr)
                  included "platform.h" on suggestion of E. Vlieg.
Update 26/11/2001 O. Svensson (svensson@esrf.fr)
                  Changed definition of INLLEN from 200 to 512 and
                  the length of STRING from 200 to INLLEN.
Update 21/12/2000 E. Vlieg (vlieg@sci.kun.nl)
                  Introduced two weighting schemes, changed function header
		  to "list_weight" to take a parameter weightmode.
Update 26/06/2000 R. Wilcke (wilcke@esrf.fr)
                  move definition of SCROLL to the file menu.h;
                  change type of COMMENTS from "int" to "char" and increase
                  dimension from 100 to 400.

*/

/***************************************************************************/
/*      include files                                                      */
/***************************************************************************/

#include <stdio.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <platform.h>
#include <menu.h>

/***************************************************************************/
/*      global parameters                                                  */
/***************************************************************************/

#define MAXDAT  1000           /* Maximum number of data points */
#define MAXEQU  30             /* Maximum # of equivalent reflections */
#define MAXNEQU 500            /* Maximum # of non-equivalent reflections */
#define INLLEN  512            /* Length of file read input buffer */
#define LMAX    20             /* Maximum value of Miller index l */
#define L_SEPARATION 0.005     /* Minimum separation in l to be averaged */
#define RODMIN	10	       /* Minimum points on rod in order to be listed */
#define FMIN	0.1	       /* F's smaller then this are given this value */
#define LINPLANE     0.5       /* Maximum l-value to be considered in inplane
			          data file */
#define WEIGHTNORMAL 1		/* Make ordinary weigth file */
#define WEIGHTSPECIAL 2		/* Make weight file with scannumber column and
				   extension .wgt */
EXT char INLINE[INLLEN];       /* Input buffer for reading files */
EXT char STRING[INLLEN];       /* General in/output buffer */

EXT struct                     /* Input reflections */
    {
    int         ID;            /* identification number of reflection */
    int         H;             /* Miller index h of reflection */
    int         K;             /* Miller index k of reflection */
    float       L;             /* Miller index l of reflection */
    float       F;             /* structure amplitude */
    float       SIG;           /* error in structure amplitude */
    int         DONE;          /* flag to denote processing */
    }
    REFIN[MAXDAT];
EXT int NIN;                   /* Number of input reflections */

EXT struct                     /* Averaged reflections */
    {
    int         H;             /* Miller index h of reflection */
    int         K;             /* Miller index k of reflection */
    float       L;             /* Miller index l of reflection */
    float       F;             /* structure amplitude */
    float       SIG1;          /* Variance in structure amplitude */
    float       SIG2;          /* Error in statistical average of f */
    int		LBRAGG;	       /* L-value of nearest Bragg peak */
    }
    REFAVE[MAXNEQU];
EXT int NAVE;                  /* Number of averaged reflections */
EXT int SORTAVE[MAXNEQU];      /* List with sorted serial numbers of
				  averaged reflections */

EXT float   TRANS[12][2][2];   /* The transformation matrices between all
				  symmetry equivalent reflections */
EXT char    PLANEGROUP[10];    /* Name of plane group */
EXT int     NTRANS;            /* Number of tranformation matrices */

EXT struct                     /* List of all equivalent reflections */
    {
    int     IDS[MAXEQU];       /* serial numbers of equivalent refl. set */
    int     NEQU;              /* Total number of reflections in set */
    }
    EQULIST[MAXNEQU];
EXT int NNONEQU;               /* Total number of non-equivalent refl. */

EXT struct                     /* All equivalent refl. for specific (hkl) */
    {
    int         H[MAXEQU];     /* Miller index h */
    int         K[MAXEQU];     /* Miller index k */
    float       L[MAXEQU];     /* Miller index l */
    int         NEQU;          /* Total number of equivalent reflections */
    }
    HKLEQU;

/* Averaging/weighting parameters */

EXT int     SIG2MODE;          /* Mode in which sigma_2 is computed */
EXT float   EPSCUTOFF;         /* Cutoff factor in agreement factor
				  calculation */
EXT float   EPSILON;           /* Agreement factor of data */
EXT float   LMULT;             /* Multiplication factor of l-values */
EXT int     NEPSILON;          /* Number of used reflections to evaluate
				  agreement factor */
EXT int     EQUMIN;            /* Minimum number of measured eq. refl. to
			          use own variance as error */
EXT int	    LIST_LBRAGG;       /* Flag to denote listing of l-value of
				  nearest Bragg peak in weighting file */
EXT int	    NOINTL;	       /* Flag to denote whether integer l-values
				  are listed in weighting file */
EXT char    COMMENTS[100];     /* Comments line in output file */
EXT int	    FRIEDEL;	       /* Flag to denote whether Friedels pairs are
				  average or not */

/* Parameters for reading data file */

EXT char    FILENAME[FILENAME_MAX]; /* Name of input file */
EXT int     NHEADER;           /* Number of header lines in data file */
EXT int     IDCOL;             /* Column number of identification numbers */
EXT int     HCOL;              /* Column number of Miller index h */
EXT int     KCOL;              /* Column number of Miller index k */
EXT int     LCOL;              /* Column number of Miller index l */
EXT int     FCOL;              /* Column number of structure factor */
EXT int     SIGCOL;            /* Column number of error in f */

/***************************************************************************/
/*      function prototypes                                                */
/***************************************************************************/

/* ave.c */

void    initialize(void);

/* execute.c */

void    average(void);
void    average_equivalents(void);
void    compute_agreement(void);
void    find_equivalents(void);
void    generate_equivalents(int h, int k, float l);
void    get_sorted_hkl(int *h, int *k, float *l);
int     in_equ_set(int h, int k, float l);
void    list_average(void);
void	list_inplane(void);
void	list_rods(void);
void    list_weight(int weightmode);
void    sort_average(void);
double  sqr(double x);

/* manipulate.c */

void    manipulate(void);

/* read.c */

int     read_f(void);

/* set.c */

void    set(void);
void    set_average(void);
void    set_read(void);
void    set_symmetry(void);
void    set_weight(void);

