;+
;  
; 
;===============================  Xop   ========================================
; 
; XOP is a widget based interface which drives different programs that
; calculates the synchrotron radiation source spectra
; (bending magnet, wigglers and undulators) and the reflection and
; transmission characteristics of optical elements as:
; mirror, filters, flat crystals, bent perfect crystals, and multilayers.
; XOP also contains programs for multi-purpose data analysis and
; visualization. 
;
; XOP runs under most Unix machines and Windows
;
; The point-and-click interface is used as a driver for a variety
; of codes from different authors written in different computer languages.
; The XOP interface and many of its applications are powered by IDL.
; XOP uses an embedding license of IDL.
; IDL is a programming language from  ITTVIS
;     http://www.ittvis.com/
; 
; The XOP interface largely simplifies the use of the codes and may be used
; without prior knowledge of how to run a particular program.
; 
; XOP includes a flexible DAta BAse for X-ray applications (DABAX), which is a 
; compilations of tables for x-ray applications with a collection of codes
; to access, visualize and process these tables. 
;
; DESCRIPTION OF THE MAIN WINDOW CONTROLS:
; ========================================
; 
; The main XOP window contains : 
; 1) A menu-bar that with the starting points for the differents applications 
;    included in the interface.
;    The menus are fully customizable, thus the final aspect may vary from
;    one XOP installation to another. For that, modify the file: 
;    $XOP_HOME/ifc/xop.men
; 2) several TAGS with: 
;    Logo: Main XOP logo image
;    Tree: A tree version of the menu-bar
;    PT: a periodic table
;    Cmd: a command window
;    CD: to set the current directory
; 
; 
; GENERAL INFORMATION:
; ====================
;
; The application driven by Xop are very numerous and in few cases redundant. 
;
; XOP and DABAX are fully extensible, and it is possible to create and
; integrate new applications. 
;
; XOP is written in IDL and is supported for Unix and PC platforms.
; XOP can be run in two modes:
;  Embedded mode: the default. The user has no access to the source code
;                 and the IDL license is integrated (embedded) in XOP. XOP
;		  is thus presented as a standalone application not requiring 
;                 any additional package or library.
;  Developer mode: for users that have a valid IDL license. The IDL code
;                 is compiled "on the fly". Users have access to the IDL
;                 code. 
;
; For more information read the README files in the main XOP directory
; and consult the XOP man page under Unix.
;
; COPYRIGHT:
; ==========
;	Please refer to the README_COPYRIGHT file in the manin XOP directory. 
;
; CREDITS:
; ========
;	Published calculations made with XOP should refer a suitable
;       publications. 
;       See the XOP web site for an updated version. 
;
;
;
; -----------------------------------------------------------------------
; MODIFICATION HISTORY: 
;        Created: M. Sanchez del Rio (srio@esrf.fr) , ESRF, Nov 1993
;        Modification history:
;                94/03/02 MSR Adds Xmlayer
;                94/03/03 MSR Adds Periodic Table call.
;                94/10/14 MSR changes the interface look. Recrates the
; 			main window by using wided. More logical
; 			rearrangement of the programs. Changes Periodic T.
;                95/03/31 MSR includes xfilter and releases xop 1.2
;                95/10/24 MSR updates to idl4.0  and releases xop 1.3beta:
; 			Main updates:
; 				-File saving of input data in many appl.
; 				-xop_defaults customized by user 
; 					file ~/.xop_defaults
; 				-Now we never use the idl widget editor (wided)
;                96/01/20 MSR prepares  xop 1.3
;                96/04/23 MSR adds xxcom and absorp. New version is 1.3.1
;                96/04/30 MSR adds xhenke, xatten and xtrans applications 
; 			which interface henke,atten and trans written by R.J.
; 			Dejus. They use Henke tables (xhenke) and the 
; 			EPDL (Evaluated Photon Data Library) from LLNL.
; 			New version is 1.3.2. Updates Xop/Help/Xop.
;                96/05/17 MSR adds theh function xop_users that wites
; 			the user host and time for each user that starts
; 			and quits XOP. The file with the users list 
; 			is $XOP_HOME/xop_users.lis (must have write
; 			permission for world).
;                96/05/17 MSR adds optics/tables/dabax. New version 1.3.3.
;                96/05/17 MSR adds xpenpol. New version 1.3.4.
;                96/10/23 MSR version 1.4. It runs under solaris. Scripts
; 			to call xop from the unix shell (not longer need
; 			of changing .cshrc)
;                96/12/19 MSR add sup-options to DABAX call
;                97/01/03 MSR add xcrystal_bent and removes xreflex and xpenpol
; 			version is now 1.5
;                97/01/08 MSR adds main page image.
;                97/01/13 MSR adds xhelp common block.
;                97/02/05 MSR adds Widget font selection. Version 1.7
;			(back from Windows version)
;                97/03/13 MSR introduces a customizable file  :
;			$XOP_HOME/data/xop_menu.dat to define the menus.
;			Version 1.8. Works under IDL 5.
;                97/09/27 MSR introduces XOP_WD (working directory)
;			environment variable. Eliminates case statement in 
;			xop_event. Adds xop_* routines. Uses SDEP.
;                97/10/01 MSR calls xfont() with the /modal keyword,
;			after receiving a debugged xfont.pro from rsi.
;                97/10/02 extracts xop_wd to an independent file and
;			add the /DEFAULT keyword.
;                97/11/07 srio@esrf.fr updated the doc. Menu data files
;			moved from $XOP_HOME/data to $XOP_HOME/ifc.
;		 98/11/04 srio@esrf.fr Use catch. Remove XHELP common
;			block (now in XOP_INI.PRO). Message window when 
;			Execute() fails. Updates doc. Changes for WWW.
;		 98/12/07 srio@esrf.fr Remove calls to xop_defaults.
;			Using now wnvironment variables. 
;		 98/12/10 srio@esrf.fr removes call to xop_wd (done in xop_ini)
;		 99/01/05 srio@esrf.fr changes colot part to use tek_color table
;		 01/10/09 srio@esrf.fr addes no_block keyword and set
;			default to 1 (required for running the INES extension).
;		  02/02/25 srio@esrf.fr changes gif by png image.
;                     Cleaning of the color table definition.
;		      xop_menu.dat renamed to xop.men
;		      Remove the XOP_IFC variable. Use XOP_PROJECT variable
;			to define the .men and .png files. 
;		 02/03/01 srio@esrf.fr XOP_VERSION environment variable
;			obsoleted. Use XOP_BARTITLE env variable for defining 
;			the bar title of the main window instead.
;                07/10/13 srio@esrf.eu changes main window (added tabs)
;			for xop 2.2
;                07/10/23 srio@esrf.eu added PT, Cmd, CD tabs
;
;-
;
;=====================================================================
;
FUNCTION Xop_Version,Group=group
IF Float(!version.release) GE 8 THEN RETURN,'2.4' 
IF Float(!version.release) GE 7 THEN RETURN,'2.3' 
RETURN,'2.2'
END ; Xop_Version
;
;=====================================================================
;
PRO xop_quit,wId,group=group
;
; quits xop
;

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'XOP_QUIT: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   Return
endif

IF N_Elements(group) GT 0 THEN widget_control,group,/destroy
IF N_Elements(wId) GT 0 THEN widget_control,wId,/destroy
delete_files,['xopcmd.pro']
end ; xop_quit
;
;=====================================================================
;
PRO XOP_Event, _Event
COMMON COLORS, _R_ORIG, _G_ORIG, _B_ORIG, _R_CURR, _G_CURR, _B_CURR

COMPILE_OPT IDL2

catch, _error_status
if _error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   _itmp = Dialog_Message(Dialog_Parent=_event.top, $
   /Error,'XOP_EVENT: error caught: '+!error_state.msg)
   catch, /cancel
   on_error,2
   Return
endif

CASE Tag_Names(_event,/STructure_Name) OF
  'WIDGET_TAB':  BEGIN
      RETURN
      END
  'WIDGET_TREE_SEL': BEGIN
      IF (_event.CLICKS NE 2) THEN RETURN
      END
  'WIDGET_TREE_EXPAND': RETURN
  'CW_PERIODICTABLE': BEGIN
    widget_control,_event.id,get_uvalue=_uval,get_value=_val
    END
   else: 
ENDCASE

;
;
;
widget_control,_event.id,get_uvalue = _uval, get_value = _val

IF N_Elements(_uval) EQ 0 THEN _uval=''

if tag_names(_event,/Structure_Name) eq 'WIDGET_TRACKING' then begin
  if _event.enter eq 1 then begin ; entry
      widget_control,_event.top,get_uvalue = _state
      tvlct,_state.red,_state.green,_state.blue
  endif else tvlct,_R_ORIG,_G_ORIG,_B_ORIG
  return
endif

CASE _uval OF
'CMD': BEGIN
  Widget_control,_event.top,get_uvalue=_state
  Widget_Control,_state.wids.cmd,Get_Value=_command
  IF !journal EQ 0 THEN BEGIN
    journal,'xopcmd.pro'
    flush,!journal 
  ENDIF 
  IF Not( Widget_Info(_state.wids.xDisplayFile1Cmd,/Valid_Id) ) THEN BEGIN
    xdisplayfile1,'xopcmd.pro',Parent=_parent, $
      Title='IDL log file: xopcmd.pro', Group=_event.top
    _state.wids.xdisplayfile1CMD=_parent
    Widget_control,_event.top,set_uvalue=_state
  ENDIF
  printf,!journal,_command[0]
  message,/info,' executing command: '+_command[0]
  _tmp = xop_execute(_command[0],Dialog_Parent=_event.top)
  IF _tmp EQ 1 THEN Widget_Control,_state.wids.cmd,Set_Value=''
  xdisplayfile1_reload,Parent=_state.wids.xDisplayFile1Cmd, flush=!journal
  END
'PT': BEGIN
  Widget_control,_event.top,get_uvalue=_state
  Widget_Control,_state.wids.PTtext,Set_Value=$
     StrCompress(_event.symbol,/Rem)+$
     ' Z='+StrCompress(_event.z,/Rem)+' '+_event.name
  IF _event.press NE 1 THEN RETURN
  IF Not( Widget_Info(_state.wids.xDisplayFile1PT,/Valid_Id) ) THEN BEGIN
    xdisplayfile1,Parent=_parent,Text='XOP Peridic Table log window', $
      Title='Periodic Table log window', Group=_event.top
    _state.wids.xdisplayfile1PT=_parent
    Widget_control,_event.top,set_uvalue=_state
  ENDIF
  xdisplayfile1_append,Parent=_state.wids.xdisplayfile1PT,$
    periodictable_data(_event.z)
  END
'SHELL': BEGIN
  case sdep() of
    'WINDOWS':  spawn
    'UNIX': spawn,'xterm',/sh
    else:
  endcase
  END
'CD': BEGIN
  Widget_control,_event.top,get_uvalue=_state
  Widget_Control,_state.wids.cd,Get_value=_tmp
  Xop_WD,setDir=_tmp,Group=_event.top
  END
'': 
else: BEGIN
  _command = _uval+',group='+strcompress(_event.top,/rem)+'L'
  message,/info,' executing command: '+_command[0]
  _tmp = execute(_command[0])
  IF _tmp NE 1 THEN _itmp = Dialog_Message(Dialog_Parent=_event.top,$
    /Error,['XOP_EVENT: error executing: ',_command[0]])
  END
ENDCASE


  

END ; xop_event
;
;=====================================================================
;
PRO xop, GROUP=Group, No_Block=no_block
COMMON COLORS, _R_ORIG, _G_ORIG, _B_ORIG, _R_CURR, _G_CURR, _B_CURR
;
;
COMPILE_OPT IDL2
;
catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!error_state.msg
   itmp = Dialog_Message(Dialog_Parent=group,$
     /Error,'XOP: error caught: '+!error_state.msg)
   If Type(stateid) EQ 3 THEN $
     IF Widget_Info(wWindow,/Valid_Id) EQ 1 THEN $
     Widget_Control,wWindow,/Destroy
   catch, /cancel
   on_error,2
   Return
endif

IF N_Elements(no_block) EQ 0 THEN no_block=1 ; use no_block by default
;
; change to working directory
;
; xop_wd,group=group,/default
;
; get xop defaults structure from xop_defaults
;
; xop_str = xop_defaults('xop')
IF N_ELEMENTS(Group) EQ 0 THEN GROUP=0


sep = sdep(/ds)

;
; get the image (this is the same code as in xop_load_image.
; (to be changed in a future version)
;
IF N_Elements(_r_orig) LE 0 THEN BEGIN 
  loadct,0
  tek_color
ENDIF


imagefile =  Xop_getenv('XOP_HOME')+sep+'ifc'+sep+Xop_getenv('XOP_PROJECT')+'.png'
IF CheckFile(imagefile) NE 1 THEN BEGIN
  tmp = Dialog_Message(/Error,'XOP: Image file not found: '+imagefile)
  image = dist(300)
ENDIF ELSE BEGIN
  image = read_png(imagefile,rr,gg,bb) 
  tvlct,rr,gg,bb
ENDELSE
xpix = n_elements(image[*,0])
ypix = n_elements(image[0,*])    

;
; widget definition
;
w = LonArr(100)
IF Xop_GetEnv('XOP_BARTITLE') NE '' THEN $
 wtitle=Xop_GetEnv('XOP_BARTITLE') ELSE $
 wtitle='XOP '+Xop_Version()
wWindow = Widget_base(title=wtitle,MBAR=wMenuBar, $
          Kill_Notify='xop_quit') ; base window
wTab =    Widget_Tab(wWindow)

wImageBase = Widget_base(wTab,Title='Logo',Column=1) ; base widget
wTreeBase  =  Widget_base(wTab,Title='Tree',Column=1) ; base widget
wPTBase  =  Widget_base(wTab,Title='PT',Column=1) ; base widget
wCmdBase  =  Widget_base(wTab,Title='Cmd',Column=1) ; base widget
wCDBase  =  Widget_base(wTab,Title='CD',Column=1) ; base widget



;
; build the menu bar
;
  w[0] = wMenuBar
  file = Xop_getenv('XOP_HOME')+sep+'ifc'+sep+Xop_getenv('XOP_PROJECT')+'.men'
  text = read_textfile(file)
  wtmp=0L
  ; auxiliar variales (just in case they are needed)
  a0=0 & a1=0 & a2=0 & a3=0 & a4=0 & a5=0 & a6=0  & a7=0  & a8=0  & a9=0
  for i=0,n_elements(text)-1 do begin
     itmp=execute(text[i])
     if itmp NE 1 then itmp = Dialog_Message(Dialog_Parent=group,$
     /Error,['Error executing:',text[i],'in file: ',file])
  endfor

;
; Create the image (xop-logo) 
;


  wDraw1 = widget_draw(wImageBase,xs=xpix,ys=ypix,/TRACKING_EVENTS,RETAIN=2)

;
; build the tree
;

  wTree = WIDGET_TREE(wTreeBase,Scr_XSize=xPix)
  w[0] = wTree
  for i=0,n_elements(text)-1 do begin
     line = StrCompress(text[i])
     line2=StrSubstitute(line,'WIDGET_BUTTON','WIDGET_TREE')
     line2=StrSubstitute(line2,'MENU','FOLDER,BITMAP=GETBMP("open.bmp")')
     line2=StrSubstitute(line2,'/HELP','/FOLDER,BITMAP=GETBMP("help.bmp")')
     line2=StrSubstitute(line2,',/SEPARATOR','')
     itmp=execute(line2)
     if itmp NE 1 then itmp = Dialog_Message(Dialog_Parent=group,$
     /Error,['Error executing:',line2,'in file: ',file])
  endfor

;
; build the periodic table
;

  periodictable_plot,/noPlot,out=tmp
  IF !version.os_family EQ 'Windows' THEN tmp.font=-1 ELSE tmp.font=0
  tmp.showZ=0
  tmp.background=0
  tmp.clrSymbol=0
  tmp.Fill=-1
  tmp.Border=1
  tmp.clrBorder=0
  wPT = cw_periodicTable(wPTBase,XSize=xPix,YSize=ypix-32,$
        VALUE=tmp,UVALUE='PT')
  ;wPTList = cw_droplist(wPTBase,Value=['0','Z','Atomic Properties','f0','f1'])
  wtmpB = Widget_Base(wPTBase,/Row)
  wPTText = Widget_Label(wtmpB,Value='                                     ', $
     /Align_Left)
  ;wtmp = widget_Button(wtmpB,Value='More>>', $
  ; UValue='xdisplayfile1,text=periodictable_data(26)',/Align_Right)

;
; build the Cmd
;

  wCmd = WIDGET_Text(wCmdBase,Value='',UVALUE='CMD',/Edit, $
         Scr_XSize=xPix,Scr_YSize=30)
  wDraw2 = widget_draw(wCmdBase,RETAIN=2,Scr_XSize=xPix,Scr_YSize=ypix-32)

;
; build the CD
;
cd,c=current
wtmp=Widget_Label(wCDBase,VALUE='Working directory: ',/Align_Left)
wCD = cw_pickfile(wCDBase,Title='',$
      UVALUE ='CD',VALUE=current,/Directory,SCR_XSIZE=xPix,/Column,$
      /Button_Last)
wtmp = Widget_Button(wCDBase,Value='Explore',UValue='xop_explore')



;
; realize widgets and display image
;

  WIDGET_CONTROL, wWindow, /REALIZE
  widget_control,/hourglass

  ; display logo image
  Widget_Control,wDraw1,Get_Value=windownum
  wset,windownum
  tv,image

  ; display periodic table
  Widget_Control, wPT, Set_Value=0



  Widget_Control,wDraw2,Get_Value=windownum
  wset,windownum

; 
; trace eventual problems
;
  tmp = Xop_getenv('XOP_HOME')
  if tmp[0] EQ '' then begin
    itmp = Dialog_Message( Dialog_Parent=group,  [$
	'XOP needs that the environment variable $XOP_HOME should be ',$
	'define. This is for findig several binaries of the called ',$
	'applications.',' ', $
	'$XOP_HOME environment variable IS NOT defined in your installation.',$
	' ', $
	'E-mail to srio@esrf.eu or dejus@aps.anl.gov if you have problems.'])
  endif


  wids = {cmd:wCmd, PT:wPT, PTtext:wPTtext, cd:wCD,  $
         xDisplayFile1Cmd:0L, xDisplayFile1PT:0L }
  state = { wids:wids, red:_r_orig, green:_g_orig, blue:_b_orig}
  widget_control,wWindow,set_uvalue=state

  IF Xop_GetEnv('XOP_ANNOUNCE') NE '' THEN Xop_Announce,Group=wWindow
  XMANAGER, 'xop', wWindow ,NO_BLOCK=no_block
END ; xop
