; $Id: cw_clr_index1.pro,v 1.3 2000/07/20 07:11:54 srio Exp $
;
; Copyright (c) 1993-1998, Research Systems, Inc.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:	
;	CW_CLR_INDEX1
;
; PURPOSE:
;	CW_CLR_INDEX1 is a compound widget for the selection of a color
;	index. A horizontal color bar is displayed. Clicking on the bar sets
;	the color index.
;
; CATEGORY:
;	Compound Widgets
;
; CALLING SEQUENCE:
;	Widget = CW_CLR_INDEX1(Parent)
;
; INPUTS:
;	Parent:	      ID of the parent widget.
;
; KEYWORD PARAMETERS:
;	COLOR_VALUES: A vector of color indices containing the colors to
;		      be displayed in the color bar. If omitted, NCOLORS
;		      and START_COLOR specify the range of color indices.
;	EVENT_FUNCT:  The name of an optional user-supplied event function.
;		      This function is called with the return value structure
;		      whenever a button is pressed, and follows the conventions ;		      for user-written event functions.
;	FRAME:        If set, a frame will be drawn around the widget.
;	LABEL:        A text label that appears to the left of the color bar.
;	NCOLORS:      The number of colors to place in the color bar.  
;		      The default = !D.TABLE_SIZE
;	START_COLOR:  The starting color index, placed at the left of the bar.
;	UVALUE:       The user value to be associated with the widget.
;	XSIZE:        The width of the color bar in pixels. The default =192.
;	YSIZE:        The height of the color bar in pixels. The default = 12.
;	UPDOWN:       If set, creates two buttons (labeled >> and <<) to
;		      increase and decrease on unit the color index. 

;
; OUTPUTS:
;       The ID of the created widget is returned.
;
; SIDE EFFECTS:
;	This widget generates event structures with the following definition:
;
;	Event = { CW_COLOR_INDEX1, ID: base, TOP: ev.top, HANDLER: 0L, VALUE: c}
;	Value is the color index selected.
;
; PROCEDURE:
;	Standard Compound widget.  Use WIDGET_CONTROL, SET_VALUE and GET_VALUE
;	to change/read the widget's value.
;
; EXAMPLE:
;	A = WIDGET_BASE(TITLE='Example', /COLUMN)
;	B = CW_CLR_INDEX1(A, LABEL='Color:')
;
; MODIFICATION HISTORY:
;	DMS,	June, 1993.	Written.
;	TAC,	Oct, 1993.	Changed name to cw_clr_index
;	99-01-08 srio@esrf.fr modifies it to allow entering the color 
;		index but typing it plus <enter>. Renamed from
;		cw_clr_index to cw_clr_index1
;	99-01-11 srio@esrf.fr added upDown keyword.
;	00-07-19 srio@esrf.fr modified to be used in 24-bit displays:
;		It now uses !d.table_size instaed of !d.n_colors
;-

function CW_COLOR_INDEXE1, ev		;Color index widget's event proc
;srio if ev.press ne 0 then return, 0

IF Widget_Info(ev.id,/Type) EQ 4 THEN if ev.press ne 0 then return, 0

base = ev.handler
widget_control, widget_info(base, /child), get_uvalue = state


CASE Widget_Info(ev.id,/Type) OF
  1: BEGIN ; Button widget
	tmp = 0
	Widget_Control,ev.id,Get_Value=tmp
	c = state.value
	IF tmp EQ '>>' THEN c=c+1 ELSE c=c-1
        c = (c > state.start_color )  < (state.ncolors)
	END
  4: BEGIN ; Draw widget
	c = long(state.start_color + (ev.x * state.scale))  ;New color
	END
  3: BEGIN ; Text widget
	Widget_Control, state.txt_id, Get_Value=tmp
	c = state.value
	c = Long(tmp[0])
	c = (c > state.start_color )  < (state.ncolors)
	END
  else: c=state.value ; just in case of errors
ENDCASE

if state.extra ne 0L then BEGIN
    WIDGET_CONTROL, state.extra, GET_UVALUE=cv
    c = cv[c]
    endif

CW_COLOR_INDEXS1, base, c	
ret =  { CW_COLOR_INDEX1, ID: base, TOP: ev.top, HANDLER: 0L, VALUE: c}
if state.efun eq '' then return, ret $
else return, CALL_FUNCTION(state.efun, ret)
end


function CW_COLOR_INDEXG1, id
	widget_control, widget_info(id, /child), get_uvalue = state
	return, state.value
end


pro CW_COLOR_INDEXS1, id, value		;Set color index widget value
widget_control, (draw = widget_info(id, /child)), get_uvalue = state, /NO_COPY
old_win = !d.window

if state.inited eq 0 then begin
    widget_control, state.pwin_id, get_value = i
    wset, i
    x = long(state.scale * findgen(!d.x_size))	;0 to n_colors-1
    if state.extra ne 0L then begin
	WIDGET_CONTROL, state.extra, GET_UVALUE=cv
	x = cv[x]
	ENDIF
    tv, x # replicate(1, !d.y_size) + state.start_color
    state.inited = 1
    endif

state.value = value			;Save new value
widget_control, state.rect_id, get_value = i
wset, i
tv, replicate(value, !d.x_size, !d.y_size)
wset, old_win
; widget_control, state.txt_id, set_value = '(' + strtrim(value,2) + ')'
widget_control, state.txt_id, set_value = strtrim(value,2)
widget_control, draw, set_uvalue = state, /NO_COPY
return
end


function CW_CLR_INDEX1, parent, LABEL = label, FRAME = frame, $
	UVALUE = uvalue, XSIZE = xsize, YSIZE = ysize, NCOLORS = ncolors, $
	START_COLOR = start_color, EVENT_FUNC = efun, COLOR_VALUES = cv, $
	UPDOWN = upDown


if n_elements(frame) eq 0 then frame = 0
if n_elements(uvalue) eq 0 then uvalue = 0
if n_elements(xsize) eq 0 then xsize = 192
if n_elements(ysize) eq 0 then ysize = 12
if n_elements(cv) gt 0 then begin
	ncolors = n_elements(cv)
	start_color = 0
	endif
; if n_elements(ncolors) eq 0 then ncolors = !d.N_COLORS
if n_elements(ncolors) eq 0 then ncolors = !d.table_size
if n_elements(start_color) eq 0 then start_color = 0
if n_elements(label) eq 0 then label = ''

base = widget_base(parent, /ROW, FRAME = frame, $
	EVENT_FUNC = 'CW_COLOR_INDEXE1', FUNC_GET_VALUE = 'CW_COLOR_INDEXG1', $
	PRO_SET_VALUE = 'CW_COLOR_INDEXS1', UVALUE = uvalue)
if n_elements(efun) le 0 then efun = ''
state = { CW_C_INDEX_STATE1, $
	txt_id : 0L, rect_id : 0L, pwin_id : 0L, inited : 0, efun: efun, $
	scale : float(ncolors) / xsize, value : 0L, $
	start_color : long(start_color), extra: 0L, $
	ncolors:ncolors }
child = widget_label(base, value = label)
;state.txt_id = widget_text(base, xsize=4, ysize = 1, value = '0',/Edit)
state.txt_id = widget_text(base, xsize=4, Scr_YSize = ysize , value = '0',/Edit)
IF keyword_Set(upDown) THEN BEGIN
  tmp = widget_base(base,/Col)
    wtmp1=widget_button(tmp,Value='>>',YSize=ySize/2)
    wtmp1=widget_button(tmp,Value='<<',YSize=ySize/2)
ENDIF
if n_elements(cv) gt 0 then BEGIN
    WIDGET_CONTROL, state.txt_id, SET_UVALUE=cv
    state.extra = state.txt_id
    endif

state.rect_id = widget_draw(base, /FRAME, XSIZE = 16, YSIZE = ysize, $
	UVALUE = 0, RETAIN=2)
state.pwin_id = widget_draw(base, /frame, xsize = xsize, $
	ysize = ysize, /BUTTON)
widget_control, child, set_uvalue = state
return, base
help,ncolors
end
