FUNCTION xplot2d2fit2d,xIn,pixel=p0,verbose=iverbose

;+
; NAME:
;	xplot2d2fit2d,xIn
; PURPOSE:
;	this function converts the CCD coordinate system used in XOP/XPLOT
;		to the fit2d one
; CATEGORY:
;
; CALLING SEQUENCE:
;    out = xplot2d2fit2d,input,pixel=pixel_microns,verbose=1
;
; INPUTS:
;	input:  input=[x0,y0,xs,ys,zs]
;
; OUTPUTS
;	out = [x0,y0,distance_mm,rotation_angle_deg,tilt_deg]
;
; KEYWORD PARAMETERS:
;	pixel: the pixel size in microns
;	verbose: set this keyword to 1 for printing the results on the screen
;
;	
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Februaty 2011
;	2011-02-25 srio@esrf.eu Documented
;-	

x0=[xIn[0:1],0.0D0]
xS=xIn[2:4]

IF N_ELEMENTS(p0) EQ 0 THEN p0=77.28
IF N_ELEMENTS(iverbose) EQ 0 THEN iverbose=0
IF N_ELEMENTS(xIn) NE 5 THEN  BEGIN
  print,'Usage:  out = xplot2d2fit2d,[x0,y0,xs,ys,zs],pixel=pixel_microns,verbose=1'
  print,'  with out=[x0,y0,distance_mm,rotation_angle_deg,tilt_deg]'
  RETURN,0
ENDIF


;x0=[1012.17,1041.17,0.0]
;xS=[1027.48,1035.88,1974.03]
;p=77.28e-3
p=p0*1e-3 ; mm

d = sqrt( (x0[0]-xS[0])^2+(x0[1]-xS[1])^2+(x0[2]-xS[2])^2 )*p
rotit = atan( (xS[1]-x0[1])/(xS[0]-x0[0]) )*180.0/!pi
tilt = atan( sqrt( (xS[0]-x0[0])^2+(xS[1]-x0[1])^2)/xS[2] )*180.0/!pi


; get quadrant
qq=1
IF ((xs[0]-x0[0]) GE 0) AND ((xs[1]-x0[1]) GE 0) THEN qq = 1
IF ((xs[0]-x0[0]) LE 0) AND ((xs[1]-x0[1]) GE 0) THEN qq = 2
IF ((xs[0]-x0[0]) LE 0) AND ((xs[1]-x0[1]) LE 0) THEN qq = 3
IF ((xs[0]-x0[0]) GE 0) AND ((xs[1]-x0[1]) LE 0) THEN qq = 4

case qq OF
 1: BEGIN
      rotit = +abs(rotit) 
      tilt  = -abs(tilt)
    END
 2: BEGIN
      rotit = -abs(rotit) 
      tilt  = +abs(tilt)
    END
 3: BEGIN
      rotit = +abs(rotit) 
      tilt  = +abs(tilt)
    END
 4: BEGIN
      rotit = -abs(rotit) 
      tilt  = -abs(tilt)
    END
endcase


IF (iverbose EQ 1) THEN BEGIN
  print,'d [mm] =', d
  print,'in plane angle, deg [rot]:  ', rotit
  print,'off-normal angle, deg [tilt]:', tilt
  print,' '
ENDIF


return,[x0[0],x0[1],d,rotit,tilt]

end
