function Read_spe, filename, xSize=xSize, ySize=ySize, swap=swap, $
  bytscale=bytscale

;+
; NAME:
;	READ_SPE
;
; PURPOSE:
;	this function reads an image file written by the Princeton CCD
;	format. 
;
; CATEGORY:
;       Readers
;
; CALLING SEQUENCE:
;	a=read_spe(file)
;
; INPUTS:
;	file:  name of the file with data. If undefines, a browser starts 
;
; KEYWORD PARAMETERS:
;
;	SWAP: If set, apply swap_endian
;		(unsed only for files containing multiple images)
;
;	VERBOSE: set this flag to print some working information (default=1)
;
;	These other keywords are obsolete and are kept for compatibility
;		reasons only:
;
;	BYTSCALE: when set to 1, data is scaled to a byte array.
;
;
; OUTPUT KEYWORD PARAMETERS:
;
;	xSize: the x size
;	ySize: the y size
;	
; 
; ALGORITHM
;
;     The PRINCETON CCD file is written with the WinView software. 
;     
;     A description of the data can be found, for example: 
;      http://forums.wolfram.com/student-support/topics/8778
;
;
; MODIFICATION HISTORY:
;
;	by M. Sanchez del Rio  srio@esrf.eu 11 March 2008
;
;-	
;  
;  
;-  

catch, error_status
if error_status ne 0 then begin
   itmp = Dialog_Message(/Error,$
       'READ_SPE: error caught: '+!error_state.msg)
   catch, /cancel
   RETURN,0
endif

image_data=0

IF N_Elements(filename) EQ 0 THEN BEGIN
  filename = Dialog_PickFile(Title='Select a file (Princeton CCD)',$
      filter='*.SPE')
  IF filename EQ '' THEN return,image_data
ENDIF


openr, lun, filename, /get_lun

xSize =  0U
ySize = 0U
dataType = 0L

point_lun, lun, 42
readu,lun,xSize

point_lun, lun, 108
readu,lun,dataType

point_lun, lun, 656
readu,lun,ySize

IF keyword_Set(swap) THEN BEGIN
  xSize=swap_endian(xSize)
  ySize=swap_endian(ySize)
  dataType=swap_endian(dataType)
ENDIF



CASE dataType OF
   0: image_data=FltArr(xSize,ySize,/NoZero)
   1: image_data=LonArr(xSize,ySize,/NoZero)
   2: image_data=IntArr(xSize,ySize,/NoZero)
   3: image_data=UIntArr(xSize,ySize,/NoZero)
   else: Message,'Data type not recognised: '+String(dataType)
ENDCASE

point_lun, lun,  4100L
readu, lun, image_data

free_lun, lun  


IF keyword_Set(swap) THEN image_data=swap_endian(image_data)

IF Keyword_Set(bytScale) THEN image_data=BytScl(image_data)

return,image_data  


END  

 
