FUNCTION read_rigaku,file,scale=scale

;+
; NAME:
;	READ_RIGAKU
; PURPOSE:
;	this function reads a file in the RIGAKU/RAXIS format 
;
; CATEGORY:
;
; CALLING SEQUENCE:
;	a=read_rigaku(input)
; INPUTS:
;	input:  name of the file with data (between quotes). 
;		It automatically handles compresses (gzip) files. They
;		must have the .gz file extension. 
; KEYWORD PARAMETERS:
;
;	SCALE: scaling factor. The read file is transormed using 
;		congrid. 
;
;	
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Nov 2007
;	2010-05-25 srio@esrf.eu adapts to read 1500x1500 images. 
;                      changed intarr by uintarr (to be checked!!)
;	2010-05-25 srio@esrf.eu rewrites based on read_raxis from 
;                  PROW (D. Bourgeois).
;-	

IF N_Elements(file) EQ 0 THEN file = Dialog_PickFile(filter='*.*')
IF file EQ '' THEN RETURN,0

OPENR,lun,file, ERROR = i, /GET_LUN, /BLOCK
IF i LT 0 THEN BEGIN 			; Something wrong, 
 IF lun GT 0 THEN FREE_LUN,lun
 lun = -1
 MESSAGE, 'Unable to open file: ' + file
 RETURN,0
ENDIF

swap=0
;Read the header:
rax_device=BYTARR(10,/NOZERO)
READU,lun,rax_device
rax_version=BYTARR(10,/NOZERO)
READU,lun,rax_version
rax_crystal=BYTARR(20,/NOZERO)
READU,lun,rax_crystal
rax_cryo=BYTARR(12,/NOZERO)
READU,lun,rax_cryo
rax_cell=FLTARR(6,/NOZERO)
READU,lun,rax_cell
rax_space=BYTARR(12,/NOZERO)
READU,lun,rax_space
rax_mosaic=FLTARR(1,/NOZERO)
READU,lun,rax_mosaic
rax_memo=BYTARR(80,/NOZERO)
READU,lun,rax_memo
rax_reserve1=BYTARR(84,/NOZERO)
READU,lun,rax_reserve1
rax_date=BYTARR(12,/NOZERO)
READU,lun,rax_date
rax_operator=BYTARR(20,/NOZERO)
READU,lun,rax_operator
rax_target=BYTARR(4,/NOZERO)
READU,lun,rax_target
rax_wavelength=FLTARR(1,/NOZERO)
READU,lun,rax_wavelength
rax_monochro=BYTARR(20,/NOZERO)
READU,lun,rax_monochro
rax_fmono_2=FLTARR(1,/NOZERO)
READU,lun,rax_fmono2
rax_collimator=BYTARR(20,/NOZERO)
READU,lun,rax_collimator
rax_filter=BYTARR(4,/NOZERO)
READU,lun,rax_filter
rax_camera=FLTARR(1,/NOZERO)
READU,lun,rax_camera
rax_fkv=FLTARR(1,/NOZERO)
READU,lun,rax_fkv
rax_fma=FLTARR(1,/NOZERO)
READU,lun,rax_fma
rax_focus=BYTARR(12,/NOZERO)
READU,lun,rax_focus
rax_xraymemo=BYTARR(80,/NOZERO)
READU,lun,rax_xraymemo
rax_ncylinder=LONARR(1,/NOZERO)
READU,lun,rax_ncylinder
rax_weissenberg=FLTARR(1,/NOZERO)
READU,lun,rax_weissenberg
rax_reserve2=BYTARR(56,/NOZERO)
READU,lun,rax_reserve2
rax_spindle=BYTARR(4,/NOZERO)
READU,lun,rax_spindle
rax_xrayaxis=BYTARR(4,/NOZERO)
READU,lun,rax_xrayaxis
rax_phi=FLTARR(3,/NOZERO)
READU,lun,rax_phi
rax_noscillations=LONARR(1,/NOZERO)
READU,lun,rax_noscillations
rax_exposure_time=FLTARR(1,/NOZERO)
READU,lun,rax_exposure_time
rax_xray=FLTARR(2,/NOZERO)
READU,lun,rax_xray
rax_circle=FLTARR(3,/NOZERO)
READU,lun,rax_circle
rax_mu=FLTARR(1,/NOZERO)
READU,lun,rax_mu
rax_scantemplate=BYTARR(204,/NOZERO)
READU,lun,rax_scantemplate
rax_pixnum=LONARR(2,/NOZERO)
READU,lun,rax_pixnum
rows=rax_pixnum(0) & columns=rax_pixnum(1)
IF ABS(rows) GT 10000. OR ABS(columns) GT 10000. THEN swap=1 
IF swap THEN BEGIN
 IF KEYWORD_SET(only_read_size) THEN PRINT,'*** Image will be byte swaped ! ***'
 BYTEORDER,rows,/LSWAP
 BYTEORDER,columns,/LSWAP
ENDIF
size_of_image=[rows,columns]
rax_pixsize=FLTARR(2,/NOZERO)
READU,lun,rax_pixsize
rax_record=LONARR(2,/NOZERO)
READU,lun,rax_record
IF swap THEN BYTEORDER,rax_record,/LSWAP
tmp_rows=rax_record(0)/2 & tmp_columns=rax_record(1)
;PRINT,tmp_rows,tmp_columns
rax_read_start=LONARR(1,/NOZERO)
READU,lun,rax_read_start
rax_ipnum=LONARR(1,/NOZERO)
READU,lun,rax_ipnum
rax_fratio=FLTARR(1,/NOZERO)
READU,lun,rax_fratio
rax_fading=FLTARR(2,/NOZERO)
READU,lun,rax_fading
rax_cpu=BYTARR(10,/NOZERO)
READU,lun,rax_cpu
rax_cip=BYTARR(10,/NOZERO)
READU,lun,rax_cip
rax_drxz=LONARR(3,/NOZERO)
READU,lun,rax_drxz
rax_reserve4=BYTARR(180,/NOZERO)
READU,lun,rax_reserve4
rax_reserve5=BYTARR(1024,/NOZERO)
READU,lun,rax_reserve5

;IF NOT KEYWORD_SET(only_read_size) THEN BEGIN
 PRINT,'READ_RIGAKU: Number of rows, columns are: ', rows, columns
 image = LONARR(tmp_rows,tmp_columns, /NOZERO)
 image_size = LONG(tmp_rows)*LONG(tmp_columns)
 offset=2*tmp_rows

 FREE_LUN, lun
 PRINT, 'READ_RIGAKU: Converting to Long Integer.'

;image_old = image
swap=0
; IF swap THEN $
; dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'ii_swap', image, image_size, file, long(offset)) $
; ELSE $
; dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'no_swap', image_old, image_size, file, long(offset)) 
;print,'>>>>>',file
;help,image,image_size,offset

;image = uint(image)
image = bytarr(tmp_rows*tmp_columns*2)

openr,unit,file,/get_lun
point_lun,unit,offset
readu,unit,image
free_lun,unit

;image = reform(image,2,tmp_rows,tmp_columns)


;print,'old: ',image_old[0:4,0]
nimage = n_elements(image)
image1=image[findgen(nimage/2)*2]
image2=image[findgen(nimage/2)*2+1]
image=long(image2)+256L*long(image1)
;print,'new1: ',image1[0:4]
;print,'new2: ',image2[0:4]
;print,'new: ',image[0:4]
image=reform(image,tmp_rows,tmp_columns)

;print,'max: ',max(double(image)-double(image_old) )
;print,'min: ',min(double(image)-double(image_old) )
;image=image_old




 ;image=image(0:rows-1,0:columns-1)
 PRINT,'READ_RIGAKU: Updating large pixels values ...'
 w_big=WHERE(image GE 2.0^15,ct_big)
 PRINT,'READ_RIGAKU: Number of pixels with large values: ',ct_big
 IF ct_big GE 1 THEN image(w_big)=(image(w_big)-2.0^15)*2.0^5

 ;IF NOT KEYWORD_SET(no_rotate) THEN BEGIN
 ; PRINT,'Rotating image ...'
 ; image=ROTATE(TEMPORARY(image),4)
 ;ENDIF

 ;shall we erase previous windows ?

IF N_Elements(scale) NE 0 THEN BEGIN
  sb = size(image)
  image=congrid(image,sb[1]*scale,sb[2]*scale)
ENDIF

RETURN,image
END
