function cs_synchro,x

;+
;
; NAME:
;	CS_SYNCHRO
;
; PURPOSE:
;	This function returns the synchronous map as defined by 
;       the Noda's theory for 2-dimensional correlation spectroscopy 
;
; CATEGORY:
;	Mathematics.
;
; CALLING SEQUENCE:
;	Result = CS_SYNCHRO(x)
;
; INPUTS:
;	x: the matrix with the input spectra
;
; REFERENCE:
;       Isao Noda and Yukuihiro Ozaki
;       Two-dimensional correlation spectroscopy
;       Applications in Vibrational and Optical Spectroscopy
;       John Wiley (2004) 
;       ISBN 0-471-62391-1
;
; PROCEDURE:
;       See formula 3.4 in pag 40 of the cited reference.	
;
; MODIFICATION HISTORY:
;	Written by Amalia fernandez-Pa~nella. ESRF 2009
;
;	2009-05-28 srio@esrf.eu added doc, cleaned for being used in xplot.
;
;-

on_error,2

; Obtener numero de columnas
n=size(x)
m=n[2]


; Obtener matriz sincronizada

cs=(1.0D/m-1.0D)*x##transpose(x)

cs1=(-1.0D*cs)

return, cs1

end
