; INTERNAL FUNCTIONS AND PROCEDURES
;___________________________________
;
; This procedure makes the scan specified by `scan_id' the current one.
; srio@esrf.fr: changes fix() by long()
pro __specload, handle, scan_id, errmsg, INDEX=idx

   aux = size(scan_id)
   if aux(0) ne 0 then begin
      message, 'Scan number must be a scalar value'
   endif

   n = handle.currscan
   if n ge 0 then begin
      curr_n = handle.scan(n).scan_n
      curr_ap = handle.scan(n).scan_ap
   endif else begin
      curr_n = -1
      curr_ap = -1
   endelse

   if aux(1) eq 0 then begin
   endif else if aux(1) eq 7 then begin
      Up_scan_id = strupcase(scan_id)
      case Up_scan_id of
         'CURRENT': begin
            if n lt 0 then begin
               errmsg = 'No current scan'
               !ERR = 1
               return 
            endif else begin
               goto, load
            endelse
         end

         'NEXT': begin
            if n ge 0 and n lt handle.total-1  then begin
               n = n + 1
               goto, load
            endif else begin
               errmsg = 'No next scan'
               !ERR = 1
               return 
            endelse
         end

         'FIRST': begin
            if handle.total gt 0  then begin
               n = 0 
               goto, load
            endif else begin
               errmsg = 'No first scan'
               !ERR = 1
               return 
            endelse
         end

         'LAST': begin
            if handle.total gt 0  then begin
               n = handle.total - 1 
               goto, load
            endif else begin
               errmsg = 'No last scan' 
               !ERR = 1
               return 
            endelse
         end

         else: begin
            s_no = 0
            on_ioerror, isastring
            s_no = long(scan_id)
isastring:  on_ioerror, null
            p = strpos(scan_id, '.') + 1
            if p gt 0 then begin 
               s_ap = long(strmid(scan_id, p, strlen(scan_id)-p))
            endif else begin
               s_ap = 0
            endelse
         end
      endcase
   endif else begin
      if aux(1) lt 1 or aux(1) gt 5 then begin
         errmsg = 'Not a valid scan number.'
         !ERR = 1
         return 
      endif
      s_no = long(scan_id)
      s_ap = round(100*(scan_id - s_no)) 
   endelse

   if s_no eq 0 or (s_no lt 0 and not keyword_set(idx)) then begin
      errmsg = 'Not a valid scan number.'
      !ERR = 1
      return 
   end

   if keyword_set(idx) then begin
      if s_no lt 0 then s_no = handle.total + s_no + 1
      if s_no gt 0 and s_no le handle.total then begin
         n = s_no - 1
         goto, load
      endif else begin
         errmsg = 'Not enough scans in "' + handle.specfile + '".'
         !ERR = 1
         return 
      endelse
   endif else if s_no eq curr_n and (s_ap eq 0 or s_ap eq curr_ap) then begin
      goto, load
   endif 
   if s_ap eq 0 then begin
      if n ge 0 then begin
         for n = n, handle.total-1 do begin
            if handle.scan(n).scan_n eq s_no then goto, load 
         endfor
      endif
      s_ap=1
   endif
   for n = 0, handle.total-1 do begin
      if handle.scan(n).scan_n  eq s_no and           $
         handle.scan(n).scan_ap eq s_ap then begin
            goto, load
      endif
   endfor
   
   errmsg = 'Scan '+strtrim(string(s_no),2)+'['+strtrim(string(s_ap),2)+ $
            '] not found in "'+ handle.specfile + '".'
   !ERR = 1
   return 

LOAD:
   if n ne handle.currscan then begin
      handle.label(*)=''

      if handle.scan(n).n_col gt 0 and handle.scan(n).labelpt gt 0 then begin
         openr,Unit,handle.specfile,/get_lun
         point_lun, Unit, handle.scan(n).labelpt+2
         line=''
         __readline, Unit, line
         free_lun, Unit

         aux = __linesplit(line, 2, handle.scan(n).n_col, handle.scan(n).n_col)
         handle.label=aux 
      endif

      handle.currscan = n
   endif
   !ERR = 0
end
