; INTERNAL FUNCTIONS AND PROCEDURES
;___________________________________
;
; This procedure loads `array' with the data in the string `line'. The data
; type depends on the initial type of array. If in `line' there are less data
; than the number of elements in `array', the remainder elements are filled
; with 0 or '' and the variable `error' is set to 1.
pro __reads, line, array, error
   if (size(array(0)))(1) ne 7 then begin
      array(*)=0
      on_ioerror, toofew
      !ERROR = 0
      reads, line, array
toofew: 
      on_ioerror, null
      if !ERROR eq 0 then error = 0 else error =1
   endif else begin
      array(*) = ''
      narr = n_elements(array)
      _line = strtrim(strcompress(' ' + line))
      pos = where(byte(_line) eq 32b)
      n = n_elements(pos)
      if n eq 1 then begin
         array(0) = strmid(_line, 1, strlen(_line) - 1)
      endif else begin
         length = [pos(1:*), strlen(_line)] - pos - 1
         nread = (narr < n)
         if n ge narr then error = 0 else error =1
         list = strarr(n)
         for i = 0, nread - 1 do begin
            array(i) = strmid(_line, pos(i) + 1, length(i))
         endfor
      endelse
   endelse
end
