;+
;
;==============================  Xinpro   ======================================
;
; Xinpro is a widget based graphical interface to calculate perfect crystal
; reflectivity profiles. 
;
; It interfaced the inpro (INtrinsic PROfiles) code. Inpro calculates the 
; diffracted and transmitted profiles in reflection (Bragg) and transmission 
; (Laue) geometries for plane perfect crystals. 
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;    Xinpro input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
; Set_Parameters:
;  Set Parameters: to define the parameters for the calculation.
;		The same result is obtained pressing the "Set Parameters"
;		button in the main Xinpro window. 
;               Please refer to the information under the HELP
;		button for a complete description of the parameters. After 
;		pressing the ACCEPT button, inpro starts running.
;  Set Defaults: Sets the default parameters.
;
;  Show: Display results
;    Diffraction curves: Plots the inpro results.
;    parameters: Displays some outputs from inpro.dat
;
;  Help:   Shows the Xinpro help (this text).
;
;
; COPYRIGHT:
;	xinpro  belongs to XOP package and it is distributed within XOP.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;
; CREDITS:
;	Published calculations made with XOP should refer:
;
;	  M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	  SPIE proceedings vol. 3448, pp.340-345, 1998.
;
; LAST MODIFICATION: msr/msr/99-03-16
;
;
;-
; ----------------------------------------------------------------------
;	Inpro has been written with the contribution of different 
;	people of the Optics Group at ESRF. The last responsible was 
;	C. Giles.
;	M. Sanchez del Rio (srio@esrf.fr) has generated the Unix 
;	versions and has written this graphical interface.
;
;	MSR 94-02-23
;       Modification history:
;		MSR 94/10/14 MSR removes common blocks and make automatic
;		call to Sun and HP inpro binaries.
;		MSR 95/11/07 MSR adds file in/out and updates to xop 1.3b
;               RJD 01/04/96, modified flag statement so that "-2" is
;                             stored instead of "-1" to correctly select
;                             the Laue transmission option.
;               MSR 97/01/18, adapts to Windows95. Cosmetics. Version 1.1.
;               MSR 97/10/27, updates documentation.
;		98/12/10 srio@esrf.fr adapts for xop2.0. Version 1.2.
;		99/03/16 srio@esrf.fr updates doc.
;
;		
;========================================================================
;
FUNCTION XINPRO_VERSION
return,'1.2'
end
;
;========================================================================
;
;-
PRO XINPRO_INP_WRITE,inp,NAME=name, Group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XINPRO_INP_WRITE: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
; write the contents of the structure with parameters for running inpro
;
IF NOT(KEYWORD_SET(name)) THEN name='inpro.inp'
;
OPENW,unit,name,/GET_LUN
;
;
;
sep = sdep(/ds)


;
; this is because the windows version has XOP_HOME finished
; by \ (required by imd) and the impro and xcom programs do not
; accept \\ in the file name. 
;
IF SDep() EQ 'WINDOWS' THEN sep2='' ELSE sep2=sep
PRINTF,unit,Xop_GetEnv('XOP_HOME')+sep2+'data'+sep+'inpro'+sep


;PRINTF,unit,Xop_GetEnv('XOP_HOME')+sep+'data'+sep+'inpro'+sep

flag = STRCOMPRESS(inp.Mode(0),/REMOVE_ALL)
if (flag eq '0') then PRINTF,unit,'+1'
if (flag eq '1') then PRINTF,unit,'-1'
if (flag eq '2') then PRINTF,unit,'+2'
if (flag eq '3') then PRINTF,unit,'-2'
;
PRINTF,unit,STRCOMPRESS(inp.Thickness,/REMOVE_ALL)
;
flag = fix(STRCOMPRESS(inp.Crystal_material(0),/REM))
PRINTF,unit,flag+1
;
PRINTF,unit,'EV'
PRINTF,unit,inp.Energy
;
PRINTF,unit,STRCOMPRESS(inp.Miller_index_h,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(inp.Miller_index_k,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(inp.Miller_index_l,/REMOVE_ALL)
;
PRINTF,unit,STRCOMPRESS(inp.Asymmetry_angle,/REMOVE_ALL)
;
PRINTF,unit,STRCOMPRESS(inp.Temperature,/REMOVE_ALL)
;
PRINTF,unit,'inpro.dat'
if (STRCOMPRESS(inp.Scale(0),/rem) EQ 0) then PRINTF,unit,'1' else begin
  PRINTF,unit,'2'
  PRINTF,unit,inp.xfrom ;/3600.
  PRINTF,unit,inp.xto ;/3600.
endelse
;
PRINTF,unit,STRCOMPRESS(inp.Npoints,/REMOVE_ALL)
;
;
FREE_LUN,unit
;
END
;
;=======================================================================
;
PRO XINPRO_EVENT,event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'XINPRO_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   If Type(stateid) EQ 3 THEN $
     If Widget_Info(stateid,/Valid_Id) AND N_Elements(state) NE 0 THEN $
     Widget_Control,stateid,Set_UValue=state,/No_Copy
   On_Error,2
   RETURN
ENDIF
;
; register the events
;
stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uvalue=state,/No_Copy

WIDGET_CONTROL, event.id, GET_UVALUE=eventuval
;widget_control, event.top, GET_UVALUE=inp


CASE eventuval OF
        'FILEINPUT': BEGIN
          action=''
          Widget_Control,event.id, Get_Value=action
          CASE action OF
            'Load from file...': BEGIN
              ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
	      filter='*.xop'
              str_par = Xop_Input_Load(Title=$
              'Select Xinpro input file...',$
              /NoConf,Filter=filter,Group=event.top)
              IF Type(str_par) EQ 8 THEN BEGIN
                tmp = state.str.parameters
                Copy_Structure,str_par, tmp, Group=event.top, /OnlyFirstField
                state.str.parameters = tmp
              ENDIF
            END
            'Save to file...': BEGIN
              str_par = state.str.parameters
              Xop_Input_Save,str_par,File='xinpro.xop',$
                /Write, Group=event.top, Comment='; xop/xinpro(v'+$
              xinpro_version()+') input file on '+SysTime()
            END
            'Save as default': BEGIN
              str_par = state.str.parameters
              Xop_Input_Save,str_par,Group=event.top, $
                Default='xinpro.xop',Comment='; xop/xinpro(v'+$
              xinpro_version()+') input file on '+SysTime()
            END
          ENDCASE
        END
	'QUIT': BEGIN
		Delete_Files,['inpro.dat','inpro.par','inpro.inp'], $
		  Group=event.top
		WIDGET_CONTROL,event.top,/DESTROY
		Return
		END
	'SETDEF': BEGIN
		itmp = widget_message(dialog_parent=event.top,$
		/Question,['This option initializes the',$
		'xinpro parameters to their default values.',$
		'Then you must click Set_parameters to run the program.',$
		'Please confirm.'],title='xinpro')
		if itmp eq 'No' then goto,out
		pars = state.str.parameters
		state.str.parameters = state.str_defaults
		END
	'SETPAR': BEGIN
		str_par = state.str.parameters

		sep = sdep(/ds)
                helpcmd = "xdisplayfile1,'"+Xop_GetEnv('XOP_HOME')+$
                  sep+'doc'+sep+'txt'+sep+"xinpro_par.txt'"
		Xscrmenu,str_par,ACTION=action,TITLES=state.str.titles, $
		  /NOTYPE,/INTERP,WTITLE='Xinpro input parameters',Ncol=2, $
		  FLAGS=state.str.flags,HElP=helpcmd
		IF (action EQ 'DONT') THEN GoTo,out
		XINPRO_INP_WRITE,str_par, Group=event.top

		command = 'inpro < inpro.inp'
		Xop_Spawn,command,CleanFiles=['inpro.par','inpro.dat']
		state.str.parameters = str_par 
		END
        'HELP': XHELP,'xinpro',GROUP=event.top
	'SHOW':	BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=eventval
		ffile = findfile('inpro.dat')
		size_inp = SIZE(state.str.parameters)
		IF (ffile(0) EQ '' OR  size_inp(1) EQ 0) THEN BEGIN
		  itmp = widget_message(dialog_parent=event.top,$
			/ERROR,['INPRO data not found...',$ 
			'Set Parameters before...  '])
		ENDIF ELSE BEGIN
		  inp = state.str.parameters
		  title='INPRO '+ $
inp.Crystal_material( fix(strcompress(inp.Crystal_material(0),/rem)) + 1) +$
' '+STRCOMPRESS(inp.Miller_index_h,/REM)+STRCOMPRESS(inp.Miller_index_k,/REM)+STRCOMPRESS(inp.Miller_index_l,/REM)+' E='+STRCOMPRESS(inp.Energy,/REM)+' eV, t='+STRCOMPRESS(inp.Thickness,/REM)+' microns'
		  CASE eventval OF
		  "Diffraction curves": BEGIN
		     XPLOT,'inpro.dat',YCOL=2,COLTITLES=$
		     ['!S!4h-h!LB!N!3[arc sec]','s-polarized','p-polarized'],$
		     TITLE=title,XTITLE='-1',YTITLE='-1',GROUP=event.top,$
		     WTITLE='xinpro results'
		     END
		  "Parameters": XDISPLAYFILE1,'inpro.par',GROUP=event.top
		    ENDCASE
		   ENDELSE
		  END
  ENDCASE

out:
Widget_Control, stateid, Set_Uvalue=state, /No_Copy
END
;
;==============================================================================
;
PRO XINPRO, GROUP=group, InputFile=inputFile

Forward_Function xop_defaults
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XINPRO: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
; create the base widget
;
if xregistered('xinpro') GT 0 then RETURN ; begin
;  tmp = widget_message(dialog_parent=group,$
;	/error,'Only one copy of Xinpro is allowed.')
;  return
;endif


base=WIDGET_BASE(/COLUMN,TITLE='Xinpro '+xinpro_version(),MBAR=wMenuBar)

wButtons = widget_base(base,/Column) ; also to store state

wFile = widget_button(wMenuBar,VALUE='File',/MENU)

  wtmp0 = widget_button(wFile,VALUE='Xinpro input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
  wtmp = widget_button(wFile,VALUE='Quit', UVALUE='QUIT',/SEPARATOR)

wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='SETPAR')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='SETDEF')

wResults = widget_button(wMenuBar,VALUE='Show',/MENU)
  wtmp = widget_button(wResults,VALUE='Diffraction curves', UVALUE='SHOW')
  wtmp = widget_button(wResults,VALUE='Parameters',UVALUE='SHOW')

wHelp = widget_button(wMenuBar,VALUE='Help', /Help)
  wtmp = widget_button(wHelp,VALUE='xinpro', UVALUE='HELP')
;

wtmp = widget_button(BASE,VALUE='Set Parameters', UVALUE='SETPAR')

if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else $
  font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

str = xop_defaults('xinpro')
str_defaults = str.parameters


IF KeyWord_Set(inputFile) THEN BEGIN
  str_par = Xop_Input_Load(InputFile=inputFile)
  IF Type(str_par) EQ 8 THEN BEGIN
    tmp = str.parameters
    Copy_Structure,str_par, tmp, Group=group
    str.parameters = tmp
  ENDIF
ENDIF
wids = {dummy:0L}
state = {str:str, str_defaults:str_defaults, wids:wids}

wtmp = WIDGET_LABEL( BASE, FONT=font, VALUE='Inpro')
wtmp = WIDGET_LABEL( BASE, FONT=font, VALUE='INtrinsic diffraction PROfiles')

Widget_control,Widget_Info(base,/CHILD),set_uvalue=state,/NO_COPY
Widget_control,base,/REALIZE
XMANAGER,'xinpro',base,GROUP_LEADER=group
end
;
