
;+
;
; =================================  xf1f2      ============================
;
; xf1f2 is a widget based graphical interface to calculate Elastic
; Anomalous Photon-Atom Scattering, and their derived parameters
; (refraction index, photoelectric absorption, reflectivity).
;
; ** VERY IMPORTANT **
;
; PLEASE NOTE THAT XF1F2 APPLICATION DOES NOT INCLUDE COMPTON SCATTERING
; CALCULATIONS. IF FOR YOUR CALCULATIONS COMPTON IS IMPORTANT, PLEASE
; USE XCROSSSEC OR XPOWER APPLICATIONS.
; THIS AFFECTS THE VALUES: BETA, MU, CROSS SECTION AND DELTA/BETA
;
;
;		Practical tip: 
;
;		For cross section, scattering factors and reflectivity, use
;		    xf1f2 and try to define your material in molecular
;		    form. 
;		For calculating attenuation coefficients, beta and cross
;                   sections use xCrossSec (and not xf1f2) because:
;		    i) it is more accurate in case of defining the material
;			by its weight fractions.
;		    ii) it used all channels in the attenuation (contrary to 
;		        xf1f2 that only uses photoelectron cross section). 
;
;
; The data are taken from the DABAX data base.
;
; Possible calculations:
;	       f1
;	       f2
;	       delta [n=1-delta-i beta]
;	       betaPh [n=1-delta-i beta, betaPh is the Photoelectric component]
;	       Photoelectric linear abs coeff (mu [cm^-1)]
;	       Photoelectric mass  abs coeff (mu [cm^2/g)]
;	       Photoelectric Cross Section [barns]
;	       s-pol reflectivity
;	       p-pol reflectivity
;	       unpolarized reflectivity
;              delta/betaPh (delta/beta from Photoelectric interaction only)
;
;
; CUSTOMIZATION OF Xf1f2 DABAX INPUT PARAMETERS:
;  -If you want to add(remove) another f1f2* file, just add(remove) it
;   in any(all) directory of $DABAX_PATH. 
; -If you want to modify the mixture table  list, do the following:
;     a) copy the Compounds.dat DABAX file to a given directory 
;        (e.g., current directory ".")
;     b) Modify this file to add/remove/change the entries.
;     c) Redefine $DABAX_PATH to include your new directoty:
;        setenv  DABAX_PATH = .:$DABAX_PATH
;     d) Restart the application.
;
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;    Xf1f2 input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where 
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
; Set_Parameters:
;  Set Parameters: to define the parameters for the calculation.
;		The same result is obtained pressing the "Set Parameters"
;		button in the main Xf1f2 window. 
;               Please refer to the information under the HELP
;		button for a complete description of the parameters. After 
;		pressing the ACCEPT button, xf1f2 start running and
;		presents a graphic display with results.
;  Set Defaults: Sets the default parameters.
;
;  Help:   Shows the xf1f2 help (this text).
;
;
;
;  COPYRIGHT:
; 	XF1F2 belongs to XOP package and it is distributed within XOP.
; 	PLEASE REFER TO THE XOP COPYRIGHT NOTICE
; 
;  REFERENCE:
; 	Published calculations made with XOP should refer:
; 
; 	M. Sanchez del Rio and R. J. Dejus 
;         "Status of XOP: an x-ray optics software toolkit"
;         SPIE Proceedings Vol. 5536 (2004) pp.171-174
; 
;         http://dx.doi.org/10.1117/12.560903
; 
;  LAST MODIFICATION: srio@esrf.eu 2012-03-28
; 
; 
;-
; =========================================================================
;	MODIFICATION HISTORY:
;       by  Manuel Sanchez del Rio. ESRF. September 1996.
;		96/11/22 MSR adds scanning vs theta and scanning vs
;		theta and energy options.
;		96/11/25 MSR Implements the Mixture options.
;		97/10/15 MSR makes some changes for xop 1.9.
;		98/12/15 MSR adapts for XOP2.0. Version 1.1
;		07/06/25 srio@esrf.eu makes some fixes for mixtures
;			version 1.11. Added delta/beta output.
;               28/03/12 srio@esrf.eu documents that Beta (in Delta/Beta) 
;                         considers only photoelectric 
;
;
;
Function xf1f2_version
return,'1.12'
end
;
;=====================================================================
;
PRO xf1f2_event,event


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
     'XfF1F2_EVENT: error caught: '+!err_string)
   Catch, /Cancel
   If Type(stateid) EQ 3 THEN $
     If Widget_Info(stateid,/Valid_Id) AND N_Elements(state) NE 0 THEN $
     Widget_Control,stateid,Set_UValue=state,/No_Copy
   On_Error,2
   RETURN
ENDIF

Widget_Control, event.id, get_UValue=eventUValue

if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''

stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy

case eventuvalue of

  'FILEINPUT': BEGIN
    action=''
    Widget_Control,event.id, Get_Value=action
    CASE action OF
      'Load from file...': BEGIN
        if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
        str_par = Xop_Input_Load(Title=$
        'Select xf1f2 input file...',$
        /NoConf,Filter=filter,Group=event.top)
        IF Type(str_par) EQ 8 THEN BEGIN
          tmp = state.str.parameters
          Copy_Structure,str_par, tmp, Group=event.top , /OnlyFirstField
          state.str.parameters = tmp
        ENDIF
      END
      'Save to file...': BEGIN
        str_par = state.str.parameters
        Xop_Input_Save,str_par,File='xf1f2.xop',$
          /Write, Group=event.top, Comment='; xop/xf1f2(v'+$
        xf1f2_version()+') input file on '+SysTime()
      END
      'Save as default': BEGIN
        str_par = state.str.parameters
        Xop_Input_Save,str_par,Group=event.top, $
          Default='xf1f2.xop',Comment='; xop/xf1f2(v'+$
        xf1f2_version()+') input file on '+SysTime()
      END
    ENDCASE
  END
  'QUIT':begin	
	widget_control,/destroy,event.top
	return
	end
  'HELP': xhelp,'xf1f2',GROUP=event.top


  'SETDEF': BEGIN
		itmp = Dialog_Message(Dialog_Parent=event.top,$
		/Question,['This option initializes the',$
		'xf1f2 parameters to their default values.',$
		'Then you must click Set_parameters to run the program.',$
		'Please confirm.'],title='xf1f2')
		if itmp eq 'No' then goto,out
		state.str.parameters = state.str_defaults
	END
  'SET':begin	
	str = state.str.parameters
        helpdir = Xop_GetEnv('XOP_HOME')+SDep(/ds)+'doc'
        helpcmd="xdisplayfile1,'"+helpdir+$
                 sdep(/ds)+'txt'+sdep(/ds)+"xf1f2_par.txt'
  	XScrMenu,str,/Interp,/NoType,action=action,Ncol=2, $
		titles=state.str.titles, $
		flags=state.str.flags,help=helpcmd, $
		wtitle='xf1f2 input parameters'
  	if  action EQ 'DONT' then goto,out
	state.str.parameters = str
	; mat_flag : 0=element, 1=mixture(form) 2=mixture(table)
	mat_flag = fix(str.mat_flag(0))
	case mat_flag of
	0: begin
	    iname = 0 
	    descriptor = strcompress(str.descriptor,/rem)
            if strlen(descriptor) EQ 1 then descriptor=descriptor+' '
	    imix = 0
	   end
	1: begin
	    iname = 0 
            descriptor = strcompress(str.descriptor,/rem)
            if strlen(descriptor) EQ 1 then descriptor=descriptor+' '
	    density = str.density
	    imix = 1
	   end
	2: begin
	    iname = 1 & descriptor = str.mat_list(fix(str.mat_list(0))+1)
	    imix = 1
	   end
	endcase
	
  	widget_control,/hourglass

	; if #sets > 1 and #magnitures > 1 then refuse the calculation.
	IF strcompress(str.datasets(0),/rem) EQ '0' AND $
	  strcompress(str.calculate(0),/rem) EQ '0' THEN BEGIN
	  itmp = widget_message(dialog_parent=event.top,$
	     /error,['Please do not select ALL datasets '+$
	     'and ALL calculations...','Too long calculations.'])
	  goto,out
	ENDIF

	; define an array with the selected datasets
	if strcompress(str.datasets(0),/rem) EQ '0' then $  
		datasets = str.datasets(2:N_elements(str.datasets)-1) else $
		datasets = str.datasets(fix(str.datasets(0))+1)
	case strcompress(str.grid(0),/rem) of
	  '0':
	  '1': begin
		if str.gridn EQ 1 then energy = [str.gridstart] else $
		energy = findgen(str.gridn)/(float(str.gridn)-1) * $
		(str.gridend-str.gridstart) + str.gridstart
		end
	  '2': energy = [str.gridstart]
	endcase
	; icalc is the magnitude array for calculations, to be
	; put in f1f2_calc,...,f=icalc
	icalc = fix(str.calculate(0))
	;if icalc eq 0 then icalc=indgen(10)+1
	if icalc eq 0 then icalc=indgen(N_Elements(str.calculate)-2)+1

	;flag to know the reflectivity case.
	; itheta=0 no reflectivity calculations
	; itheta=1 reflectivity calculations, single theta value
	; itheta=2 reflectivity calculations, multiple theta value
	itheta = 0 
	if (n_elements(icalc) GT 1) or (icalc(0) EQ 8 OR icalc(0) EQ 9 OR icalc(0) EQ 10)  then begin	
	  thetagrid = strcompress(str.thetagrid(0),/rem)
	  if thetagrid EQ '0' then begin
	    theta = str.theta1 
	    itheta = 1
	  endif else begin
	    theta = (findgen(str.thetan)+1)/str.thetan
	    theta = theta*(str.theta2-str.theta1)+ str.theta1
	    itheta = 2
	  endelse
	endif
	; refuse to calculate multiple datasets and multiple angles and
	; multiple energies
	IF strcompress(str.datasets(0),/rem) EQ '0' AND itheta EQ 2 $
	  and n_elements(energy) GT 1THEN BEGIN
	  itmp = widget_message(dialog_parent=event.top,$
	     /error,['Please do not select ALL datasets '+$
	     'with the reflectivity angular "user defined" option.',$
	     'Too long calculations.'])
	  goto,out
	ENDIF

	; 3d plot (refl vs E and angle)
	if (itheta EQ 2 and n_elements(energy) GT 1) OR $
	   (itheta EQ 2 and n_elements(energy) EQ 0) then begin
	  if imix then begin
	    fout = f1f2_calc_mix(datasets(0),descriptor,energy,f=icalc(0),$
	    theta=theta,rough=rough,name=iname,density=density,$
	    group=event.top) 
          endif else begin
	    fout = f1f2_calc(datasets(0),descriptor,energy,f=icalc(0),$
	    theta=theta,rough=rough,group=event.top)
          endelse
	  tmp = !p.charsize
	  !p.charsize = 2.0

	  xsurface1,fout,theta,energy,xtitle='theta',ytitle='energy',$
		group=event.top
	  !p.charsize=tmp
	  goto,out
	endif

	units = ['f1','f2','delta','betaPh','mu photoel [cm^-1]',$
	' mu  photoel [cm^2/g]','Cross Sec photoel [barns]', $
        's-pol refl',' p-pol refl','unpol refl','delta/betaPh']

	; 2d plot ( vs E)
	rough = str.rough
	IF ITHETA NE 2 THEN BEGIN
	FOR I = 0,n_elements(datasets)-1 DO BEGIN ; starts main loop
	  FOR J = 0,n_elements(icalc)-1 DO BEGIN ; starts loop on magnitudes
	    if imix then begin
	      fout = f1f2_calc_mix(datasets(i),descriptor,energy,f=icalc(j),$
	      theta=theta,rough=rough,name=iname,density=density,$
	      group=event.top) 
            endif else begin
	      fout = f1f2_calc(datasets(i),descriptor,energy,f=icalc(j),$
	      theta=theta,rough=rough,group=event.top)
            endelse
	    titlemore = ''
	    title= units(icalc(j)-1)
	    if icalc(j) EQ 8 OR icalc(j) EQ 9 OR icalc(j) EQ 10 then titlemore = $
		strcompress(theta,/rem)+' mrad; rough rms='+$
		strcompress(rough,/rem)+' Ang.'
	    if n_elements(labelsY) eq 0 then labelsY = datasets(i)+':'+title $
		else labelsY = [labelsY,datasets(i)+':'+title]
	    if I EQ 0 AND J EQ 0 then begin
	      out = fltarr(n_elements(datasets)+N_elements(icalc),$
		n_elements(energy))
	      out(0,*) = reform(energy)
	      out(1,*) = reform(fout)
	    endif else out(1+i+j,*) = reform(fout)
	  ENDFOR ; ends magnitudes loop
	ENDFOR ; ends main loop
        coltitles=['energy[eV]',labelsY]
        if (size(out))(0) EQ 1 then begin
          tmp = strarr(n_elements(out))
          for ii=0,n_elements(out)-1 do tmp(ii)=coltitles(ii)+'  = '+$
            strcompress(out(ii))
          xdisplayfile1,text=tmp,group=event.top,title='xf1f2 results'
        endif else begin
	  title = 'Material: '+descriptor+' '
	  xplot,out,coltitles=coltitles,xtitle='-1',ytitle='-1', $
	  group = event.top,/xlog,title=title+titlemore,$
	  wtitle='xf1f2 results',no_block=state.no_block
        endelse
	ENDIF ELSE BEGIN ; vs theta
	FOR I = 0,n_elements(datasets)-1 DO BEGIN ; starts main loop
	  if n_elements(icalc) gt 1 then begin
	    itmp = widget_message(dialog_parent=event.top,$
	     /error,['Please do not select CALCULATE ALL'+$
	     ' with the reflectivity angular "user defined" option.',$
	     'I do not how to get f1(theta)!!.'])
	    goto,out
	  endif
	  if imix then begin
	    fout = f1f2_calc_mix(datasets(i),descriptor,energy,f=icalc(0),$
	    theta=theta,rough=rough,name=iname,density=density,$
	    group=event.top) 
          endif else begin
	    fout = f1f2_calc(datasets(i),descriptor,energy,f=icalc(0),$
	    theta=theta,rough=rough,group=event.top)
          endelse
	  titlemore = ''
	  title= units(icalc(0)-1)
	  titlemore = 'Energy: '+strcompress(energy(0),/rem)+' eV; rough rms='+$
		strcompress(rough,/rem)+' Ang.'
	  if n_elements(labelsY) eq 0 then labelsY = datasets(i)+':'+title $
	    else labelsY = [labelsY,datasets(i)+':'+title]
	  if I EQ 0 then begin
	    out = fltarr(n_elements(datasets)+1,n_elements(theta))
	    out(0,*) = reform(theta)
	    out(1,*) = reform(fout)
	  endif else out(1+i,*) = reform(fout)
	ENDFOR ; ends main loop
        coltitles=['Theta[mrad]',labelsY]
        if (size(out))(0) EQ 1 then begin
          tmp = strarr(n_elements(out))
          for ii=0,n_elements(out)-1 do tmp(ii)=coltitles(ii)+'  = '+$
            strcompress(out(ii))
          xdisplayfile1,text=tmp,group=event.top
        endif else begin
	  title = 'Material: '+descriptor+' '
	  xplot,out,coltitles=coltitles,xtitle='-1',ytitle='-1', $
	  group = event.top,title=title+titlemore,no_block=state.no_block
        endelse
	ENDELSE
	end
  else:
endcase

out:
Widget_Control, stateid, set_UValue=state, /No_Copy
END
;
;=======================================================================
;
PRO xf1f2,GROUP=group, InputFile=inputFile, No_Block=no_Block
;
Forward_Function dabax_defaults
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'XF1F2: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
IF N_Elements(no_block) EQ 0 THEN no_block=1

wbase = widget_base(/COLUMN,TITLE='XF1F2 '+xf1f2_version(),$
        MBAR=wMenuBar)

;
;
; the blocks box
;
Bbox=widget_base(wbase,/Column) ; also to store state
 

;Menu bar
wFile =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)

  wtmp0 = widget_button(wFile,VALUE='Xf1f2 input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
  wtmp = widget_button(wFile,VALUE='Quit', UVALUE='QUIT',/SEPARATOR)

wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='SET')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='SETDEF')


wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
  wtmp = WIDGET_BUTTON(wHelpMenu, VALUE='xf1f2', UVALUE='HELP')

tmp = widget_button(Bbox,VALUE='Set Parameters',UVALUE='SET')


if sdep() EQ 'WINDOWS' then $
font = 'VERDANA*BOLD*ITALIC*24' else $
font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

junk = WIDGET_LABEL( Bbox, FONT=font, VALUE=' xF1F2')
junk = WIDGET_LABEL( Bbox, FONT=font, $
  VALUE='Elastic Anomalous Photon-Atom Scattering')


str = dabax_defaults('xf1f2',group=wbase)
str_defaults = str.parameters

IF KeyWord_Set(inputFile) THEN BEGIN
  str_par = Xop_Input_Load(InputFile=inputFile)
  IF Type(str_par) EQ 8 THEN BEGIN
    tmp = str.parameters
    Copy_Structure,str_par, tmp, Group=group, /OnlyFirstField
    str.parameters = tmp
  ENDIF
ENDIF

wids = {dummy:0L}
state = { wids:wids, str:str, str_defaults:str_defaults, $
          no_block:no_block }

widget_control,Widget_Info(wbase,/Child),set_uvalue=state
widget_control,wbase,/REALIZE
xmanager,'XF1F2',wbase,GROUP=group, No_Block=no_Block
;
end
