pro matr2presur, z,x,y, FILE=file
;+
; NAME:
;	matr2presur
; PURPOSE:
;	to write the idl z,x,y variables containing a surface in a file
;	with the SHADOW 'presurface' format.
; CATEGORY:
;       SHADOW's utilities
; CALLING SEQUENCE:
;	matr2presur,z,x,y
; INPUTS:
;	z,x,y variables z=fltarr(nx,ny), x=fltarr(nx) and y=fltarr(ny)
;	with the surface
; KEYWORD PARAMETERS:
;		FILE= The name of the output file where write the
; OUTPUTS:
;	A file is written to the disk.
; PROCEDURE:
;	Straightforward.
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Jun 1994
;-	
on_error,2
if not(keyword_set(file)) then file = 'PRESURFACE.DAT'
;
npointsx=n_elements(x)
npointsy=n_elements(y)
openw,Unit,file,/get_lun
printf,Unit,npointsx,npointsy
printf,Unit,y
for i=0,npointsx-1 do printf,Unit,x(i),z(i,*)
free_lun,Unit
;
print,'MATR2PRESURF: File ',file,' written to disk.'
end
