;+
;
; ** OBSOLETE FOR IDL 5.4 USE GET_COLOR INSTEAD **
;
; NAME:
;       SET_COLOR
;
; PURPOSE:
;       This function create widget_base with all the field necessary to control
;		a RGB color then return an 3-dimension array of integer
;
; CATEGORY:
;       WIDGET.
;
; CALLING SEQUENCE:
;       rgb=SET_COLOR, Parent, rgb=rgb.
;
; INPUTS:
;		Parent: a widget_base

; KEYWORD PARAMETERS:
;		rgb: the default rgb color.
;
; EXAMPLE:
;		oldrgb=[0,0,255] ;blue
;		newrgb=SET_COLOR(Parent, oldrgb)
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;
;-

pro set_color_event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'set_color_event: error caught: '+!error_state.msg)
   RETURN
ENDIF



Widget_Control,event.id,Get_UValue=uvalue
;
CASE uvalue OF
	'ok_color_work': BEGIN
		widget_control, event.top, get_uvalue=info
		(*(info.ptr)).ok=1
		widget_control, event.top, /destroy
		END

	'cancel_color_work': BEGIN
		widget_control, event.top, /destroy
		END

	'color_work': BEGIN
		widget_control, event.top, get_uvalue=info
		slider=widget_info( event.id,/uname)
		case slider of
			'r':begin
				widget_control, (info).sliderR, get_value=r
				(*(info.ptr)).rgb[0]=r
				end
			'g':begin
				widget_control, (info).sliderV, get_value=v
				(*(info.ptr)).rgb[1]=v
				end
			'b':begin
				widget_control, (info).sliderB, get_value=b
				(*(info.ptr)).rgb[2]=b
				end
			else:; nothing
		endcase
		(info.view)->setProperty, color=(*(info.ptr)).rgb
		(info.window)->draw, (info.view)
		END
ENDCASE


END

;
;===================================================================================================
;


FUNCTION set_color, parent, rgb=rgb, Title=title

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'set_color: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


if N_elements(rgb) eq 0 then rgb=[0,0,0]
if N_elements(title) eq 0 then title="RGB Colors"

IF N_Elements(parent) NE 0  THEN $
  base=widget_base(GROUP_LEADER=parent,/floating,/col,title=title,/modal,/TLB_Kill_Request_Events) ELSE $
  base=widget_base(/col,title=title,/TLB_Kill_Request_Events)

menu_fin=widget_base(base,/row)
	ok=widget_button(menu_fin,value='Accept', UValue='ok_color_work')
	cancel=widget_button(menu_fin,value='Cancel', UValue='cancel_color_work')

sliderR=widget_slider(base, minimum=0, maximum=255,value=rgb[0], $
		title='Red:',   uname='r', UValue='color_work')
sliderV=widget_slider(base, minimum=0, maximum=255,value=rgb[1], $
		title='Green:',   uname='g', UValue='color_work')
sliderB=widget_slider(base, minimum=0, maximum=255,value=rgb[2], $
		title='Blue:',   uname='b', UValue='color_work')
draw=widget_draw(base, GRAPHICS_LEVEL=2)

widget_control, base, /realize

view=obj_new('idlgrview',color=rgb)
widget_control, draw, get_value=window
window->draw, view

ptr=ptr_new({ok:0, rgb:rgb})
info={ptr:ptr, sliderR:sliderR, sliderV:sliderV, sliderB:sliderB, window:window, view:view}

widget_control, base, set_uvalue=info


xmanager,'set_color', base

color_info=*ptr
ptr_free, ptr
;view->CleanUp
Obj_Destroy,view

RETURN, color_info

end
