/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of IO.xs. Do not edit this file, edit IO.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "IO.xs"
/*
  Copyright (c) 1995-2004 Nick Ing-Simmons. All rights reserved.
  This program is free software; you can redistribute it and/or
  modify it under the same terms as Perl itself.
*/
#define PERL_NO_GET_CONTEXT
#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#include <patchlevel.h>
#include <fcntl.h>

#include "tkGlue.def"

#include "pTk/tkPort.h"
#include "pTk/tkInt.h"
#include "pTk/tkEvent.h"
#include "pTk/tkEvent_f.h"
#include "pTk/tkEvent.m"
#include "tkGlue.h"
#include "tkGlue.m"

DECLARE_EVENT;

#define InputStream PerlIO *
#define OutputStream PerlIO *


typedef struct
 {
  PerlIO *f;
  SV *buf;
  int len;
  int offset;
  int count;
  int error;
  int eof;
 } nIO_read;

static void read_handler _((ClientData clientData, int mask));
static void
read_handler(clientData, mask)
ClientData clientData;
int mask;
{
 dTHX; /* FIXME */
 if (mask & TCL_READABLE)
  {
   nIO_read *info = (nIO_read *) clientData;
   SV *buf = info->buf;
   int count;
   SvGROW(buf,(Size_t) (info->offset+info->len+1));
   count = read(PerlIO_fileno(info->f),SvPVX(buf)+info->offset,(size_t) info->len);
   if (count == 0)
    {
     info->eof = 1;
    }
   else if (count == -1)
    {
     perror("read_handler");
     if (errno == EAGAIN)
      {
       PerlIO_printf(PerlIO_stderr(),"%d would block\n",PerlIO_fileno(info->f));
      }
     else
      info->error = errno;
    }
   else
    {STRLEN len;
     SvCUR_set(buf,SvCUR(buf)+count);
     info->len    -= count;
     info->count  += count;
     info->offset += count;
    }
   SvPVX(buf)[SvCUR(buf)] = '\0';
  }
}


#if defined(__WIN32__) && !defined(__CYGWIN__)
static int
make_nonblock (pTHX_ PerlIO *f,int *mode,int *newmode)
{
 croak("Cannot make nonblocking on Win32 yet");
 return -1;
}

static int
restore_mode (pTHX_ PerlIO *f,int mode)
{
 croak("Cannot make nonblocking on Win32 yet");
 return -1;
}
#else
static int
make_nonblock (pTHX_ PerlIO *f,int *mode,int *newmode)
{
 int RETVAL = fcntl(PerlIO_fileno(f), F_GETFL, 0);
 if (RETVAL >= 0)
  {
   *newmode = *mode = RETVAL;
#ifdef O_NONBLOCK
   /* POSIX style */
#ifdef O_NDELAY
   /* Ooops has O_NDELAY too - make sure we don't
    * get SysV behaviour by mistake
    */
   if ((*mode & O_NDELAY) || !(*mode & O_NONBLOCK))
    {
     *newmode = (*mode & ~O_NDELAY) | O_NONBLOCK;
     RETVAL = fcntl(PerlIO_fileno(f),F_SETFL,*newmode);
    }
#else
   /* Standard POSIX */
   if (!(*mode & O_NONBLOCK))
    {
     *newmode = *mode | O_NONBLOCK;
     RETVAL = fcntl(PerlIO_fileno(f),F_SETFL,*newmode);
    }
#endif
#else
   /* Not POSIX - better have O_NDELAY or we can't cope.
    * for BSD-ish machines this is an acceptable alternative
    * for SysV we can't tell "would block" from EOF but that is
    * the way SysV is...
    */
   if (!(*mode & O_NDELAY))
    {
     *newmode = *mode | O_NDELAY;
     RETVAL = fcntl(PerlIO_fileno(f),F_SETFL,*newmode);
    }
#endif
  }
 return RETVAL;
}

static int
restore_mode (pTHX_ PerlIO *f,int mode)
{
 return fcntl(PerlIO_fileno(f), F_SETFL, mode);
}

#endif

static int has_nl _((SV *sv));

static int has_nl(sv)
SV *sv;
{
 STRLEN n = SvCUR(sv);
 char *p = SvPVX(sv);
 while (n-- > 0)
  {
   if (*p++ == '\n')
    return 1;
  }
 return 0;
}

#line 170 "IO.c"
XS(XS_Tk__IO_make_nonblock); /* prototype to pass -Wmissing-prototypes */
XS(XS_Tk__IO_make_nonblock)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: Tk::IO::make_nonblock(f, mode, newmode)");
    {
	InputStream	f = IoIFP(sv_2io(ST(0)));
	int	mode;
	int	newmode;
	int	RETVAL;
	dXSTARG;
#line 170 "IO.xs"
 {
  make_nonblock(aTHX_ f,&mode,&newmode);
 }
#line 187 "IO.c"
	sv_setiv(ST(1), (IV)mode);
	SvSETMAGIC(ST(1));
	sv_setiv(ST(2), (IV)newmode);
	SvSETMAGIC(ST(2));
    }
    XSRETURN(1);
}

XS(XS_Tk__IO_restore_mode); /* prototype to pass -Wmissing-prototypes */
XS(XS_Tk__IO_restore_mode)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: Tk::IO::restore_mode(f, mode)");
    {
	InputStream	f = IoIFP(sv_2io(ST(0)));
	int	mode = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 182 "IO.xs"
 {
  restore_mode(aTHX_ f,mode);
 }
#line 211 "IO.c"
    }
    XSRETURN(1);
}

XS(XS_Tk__IO_read); /* prototype to pass -Wmissing-prototypes */
XS(XS_Tk__IO_read)
{
    dXSARGS;
    if (items < 3 || items > 4)
	Perl_croak(aTHX_ "Usage: Tk::IO::read(f, buf, len, offset = 0)");
    {
	InputStream	f = IoIFP(sv_2io(ST(0)));
	SV *	buf = ST(1);
	int	len = (int)SvIV(ST(2));
	int	offset;
	SV *	RETVAL;

	if (items < 4)
	    offset = 0;
	else {
	    offset = (int)SvIV(ST(3));
	}
#line 193 "IO.xs"
  {
   int mode;
   int newmode;
   int count = make_nonblock(aTHX_ f,&mode,&newmode);
   /* Copy stuff out of PerlIO *  */
   ST(0) = &PL_sv_undef;
   if (count == 0)
    {
     int fd = PerlIO_fileno(f);
     nIO_read info;
     info.f   = f;
     info.buf = buf;
     info.len = len;
     info.offset = offset;
     info.count  = 0;
     info.error  = 0;
     info.eof    = 0;
     if (!SvUPGRADE(buf, SVt_PV))
      {
       RETVAL = &PL_sv_undef;
       return;
      }
     SvPOK_only(buf);		/* validate pointer */
     Tcl_CreateFileHandler(fd, TCL_READABLE, read_handler, (ClientData) &info);
     do
      {
       Tcl_DoOneEvent(0);
      } while (!info.eof && !info.error && info.count == 0);
     Tcl_DeleteFileHandler(fd);
     if (mode != newmode)
      {
       count = restore_mode(aTHX_ f,mode);
       if (count != 0)
        croak("Cannot make blocking");
      }
     if (!info.eof && !info.error)
      {
       ST(0) = sv_2mortal(newSViv(info.count));
      }
    }
   else
    croak("Cannot make non-blocking");
  }
#line 278 "IO.c"
    }
    XSRETURN(1);
}

XS(XS_Tk__IO_readline); /* prototype to pass -Wmissing-prototypes */
XS(XS_Tk__IO_readline)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: Tk::IO::readline(f)");
    {
	InputStream	f = IoIFP(sv_2io(ST(0)));
	SV *	RETVAL;
#line 241 "IO.xs"
  {
   int mode;
   int newmode;
   int count = make_nonblock(aTHX_ f,&mode,&newmode);
   /* Copy stuff out of PerlIO *  */
   ST(0) = &PL_sv_undef;
   if (count == 0)
    {
     SV *buf =  newSVpv("",0);
     int fd = PerlIO_fileno(f);
     nIO_read info;
     info.f   = f;
     info.buf = buf;
     info.len = 1;
     info.offset = 0;
     info.count  = 0;
     info.error  = 0;
     info.eof    = 0;
     Tcl_CreateFileHandler(fd, TCL_READABLE, read_handler, (ClientData) &info);
     while (!info.eof && !info.error && !has_nl(buf))
      {
       info.len = 1;
       info.count = 0;
       while (!info.eof && !info.error && !info.count)
        Tcl_DoOneEvent(0);
      }
     Tcl_DeleteFileHandler(fd);
     if (mode != newmode)
      {
       count = restore_mode(aTHX_ f,mode);
       if (count != 0)
        croak("Cannot make blocking");
      }
     if (!info.eof && !info.error)
      {
       sv_setiv(buf,1);
       SvPOK_on(buf);
       ST(0) = sv_2mortal(buf);
      }
     else if (info.error)
      {
       warn("error=%d",info.error);
      }
    }
   else
    {
     croak("Cannot make non-blocking");
    }
  }
#line 342 "IO.c"
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Tk__IO); /* prototype to pass -Wmissing-prototypes */
XS(boot_Tk__IO)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXSproto("Tk::IO::make_nonblock", XS_Tk__IO_make_nonblock, file, "$$$");
        newXSproto("Tk::IO::restore_mode", XS_Tk__IO_restore_mode, file, "$$");
        newXSproto("Tk::IO::read", XS_Tk__IO_read, file, "$$$;$");
        newXSproto("Tk::IO::readline", XS_Tk__IO_readline, file, "$");

    /* Initialisation Section */

#line 292 "IO.xs"
 {
  IMPORT_EVENT;
 }

#line 370 "IO.c"

    /* End of Initialisation Section */

    XSRETURN_YES;
}

