@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!perl
#line 15
    eval 'exec perl -S $0 "$@"'
        if 0;

##########################################################################
# Here starts the actual script

sub names {
  my ($module) = @_;
  my $name = (split '::', $module)[-1];
  my $pdname = lc $name . '.pd';
  return ($name,$pdname);
}

sub pdtmpl {
  return join '', <DATA>;
}

sub pdMakefile {
  my ($module,$name,$pdname,$internal) = @_;
  my $coredev = $internal ? 'PDL::Core::Dev->import()' : 'use PDL::Core::Dev';
  my $int = $internal ? '_int' : '';
  return << "EOM";

# Use this as a template for the Makefile.PL for
# any external PDL module.

use ExtUtils::MakeMaker;

$coredev;
\@pack = (["$pdname",$name,$module]);

\%hash = pdlpp_stdargs$int(\@::pack);
# \$hash{'OPTIMIZE'}  = '-g'; # If you want to debug, uncomment this.
# \$hash{INC} .= " -I/usr/local/include";  # uncomment as required
# \$hash{LIBS}[0] .= " -L/usr/local/lib -lmylib "; # uncomment as required

WriteMakefile(\%hash);

# Add genpp rule
# add other makefile additions as required (see also ExtUtils::MakeMaker)
sub MY::postamble {
	pdlpp_postamble$int(\@::pack);
}

EOM
}

sub usage {
  die << "EOU";

usage: $0 [option] modulename

Options:
  -i    internal mode - template for module that is in the PDL distribution

EOU

}

use Getopt::Std;
getopts('i');

usage unless $#ARGV > -1;
($module,$name,$pdname) = ($ARGV[0],names $ARGV[0]);

die "Makefile.PL exists; move out of the way if you want to proceed"
  if -f 'Makefile.PL';
die "$pdname exists; move out of the way if you want to proceed"
  if -f $pdname;

open $mkfl, '>Makefile.PL' or die "couldn't open Makefile.PL for writing";
open $pdfl, ">$pdname" or die "couldn't open $pdname for writing";

print $mkfl pdMakefile($module,$name,$pdname,$opt_i);
close $mkfl;

print $pdfl pdtmpl;
close $pdfl;

=head1 NAME

pptemplate - script to generate Makefile.PL and PP file skeleton

=head1 SYNOPSIS

        # generate Makefile.PL and mymodule.pd in CWD
	pptemplate PDL::MyModule;


=head1 DESCRIPTION

The B<pptemplate> script is the easiest way to start a new module
for PDL that contains PP code (see also L<PDL::PP>). The usage is simply

  pptemplate modulename;

As a result pptemplate will generate a perl Makefile for the new
module (F<Makefile.PL>) that contains the minimal structure to
generate a module from PP code and also a skeleton file
for your new module.

The file will be called F<mymod.pd> if you called C<pptemplate> as

  pptemplate PDL::CleverAlgs::Mymod;

I suppose you can work out the naming rule C<;)>. If not resort to
experimentation or the source code.

C<pptemplate> will refuse to overwrite existing files of the same name
to avoid accidents. Move them out of the way if you really want to scrap
them.

=head2 Options

Currently there is only the C<-i> option which switches C<pptemplate>
into the so called I<internal mode>.  It should only be used when you
are starting a new module within the main PDL tree that is supposed to
be part of the PDL distribution and the normal PDL build process, e.g.

   cd PDL/IO;
   mkdir Mpthree; cd Mpthree;
   pptemplate -i PDL::IO::Mpthree;

=head1 BUGS

Maybe C<;)>.
Feedback and bug reports are welcome.

=head1 COPYRIGHT

Copyright (c) 2001, Christian Soeller. All Rights Reserved.
This module is free software. It may be used, redistributed
and/or modified under the same terms as PDL itself
(see http://pdl.perl.org).

=cut

__END__
# template auto generated by pptemplate
# uncomment commands, copy and fill in as needed
# see also the PDL::PP manpage

# pp_bless('');       # package namespace of pp_def'ed functions
		      # defaults to 'PDL'

# pp_add_boot('');    # code to add to the XS boot section

# pp_addhdr('');      # add C code to the section preceding 
		      # the first MODULE keyword

# pp_addpm('');       # add perl code to the perl module that PP will create

# pp_add_exported(''); # add the list of function names
                       # to the list of exported functions 

# pp_addxs('');        # add plain XS code to the XS section

# pp_add_isa(qw//);    # inheritance business: add arglist to modules @ISA

# pp_def('name', Code => '');  # minimal pp_def to define function 

pp_done();  # you will need this to finish pp processing


__END__
:endofperl
