;+
; NAME:
;       blv_planes_control
;
; PURPOSE:
;       This function creates and returns a widget base with all the 
;		widget element necessary to control
;		the property of planes'module.
;
; CATEGORY:
;       optic.
;
; CALLING SEQUENCE:
;		wBase=blv_planes_control, pInfo
;
; INPUTS:
;       pInfo: A pointer on the blviewer uValue.
;
; KEYWORD PARAMETERS:
;		None.
;
; EXAMPLE:
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, 2001
;-

;
;====================================================================================================================;

pro blv_planes_control_close, pinfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_planes_control_close: error caught: '+!error_state.msg)
   RETURN
ENDIF


	temp=(*pInfo).wid.wPlanes
	(*pInfo).wid.wPlanes=(*pInfo).wid.tbl
	widget_control, temp, /destroy
end


;
;====================================================================================================================
;
pro blv_planes_control_print_property, info
;purpose: changes the property of the widget base function to the current plane

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_planes_control_print_property: error caught: '+!error_state.msg)
   RETURN
ENDIF


if (*info.pInfo).data.position eq -1 then return
module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
module->getProperty, planesSource=planesSource, $
					planesImage=planesImage, $
					planeElement=planeElement

widget_control, (*info.pInfo).wid.wPlanes, get_uvalue=infoBis

nb_planes=planesSource->count()+planesimage->count()+1
posi=(*infoBis.pInfoPlanes).position
; to get the good planes in the two container (it may has changed)
if posi gt planesSource->count()-1 then begin
	if posi eq nb_planes-1 then (*infoBis.pInfoPlanes).currentPlane=planeElement $
	else begin
		posi=posi-planesSource->count()
		(*infoBis.pInfoPlanes).currentPlane=planesImage->get(pos=posi)
	endelse
endif else (*infoBis.pInfoPlanes).currentPlane=planesSource->get(pos=posi)

value=nb_planes
widget_control, (*infoBis.pInfoPlanes).wNbPlanes, set_value=string(value)
widget_control, (*infoBis.pInfoPlanes).wSelectedplane, set_value=string((*infoBis.pInfoPlanes).position+1)

widget_control, (*infoBis.pInfoPlanes).wNSource, get_uvalue=text
resu=text + string( 1)
widget_control, (*infoBis.pInfoPlanes).wNSource, set_value=resu

widget_control, (*infoBis.pInfoPlanes).wNElement, get_uvalue=text
resu=text + string( nb_planes)
widget_control, (*infoBis.pInfoPlanes).wNElement, set_value=resu

widget_control, (*infoBis.pInfoPlanes).wNImage, get_uvalue=text
resu=text + string( planesSource->count()+1)
widget_control, (*infoBis.pInfoPlanes).wNImage, set_value=resu

if obj_isa((*infoBis.pInfoPlanes).currentPlane, 'optical_plane') then begin
(*infoBis.pInfoPlanes).currentPlane->getProperty, shImage=showImage, beam_file=beam_file
widget_control, (*infoBis.pInfoPlanes).wShowImage, set_button=abs(showImage-1)
widget_control, (*infoBis.pInfoPlanes).wFile, set_value=beam_file
endif

end

;
;====================================================================================================================
;
pro blv_planes_control_event, event
;purpose: defines events on the widget base: -kill

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_planes_control_event: error caught: '+!error_state.msg)
   RETURN
ENDIF


widget_control, event.top, get_uvalue=info
IF TAG_NAMES(event, /STRUCTURE_NAME) EQ 'WIDGET_KILL_REQUEST' THEN begin
	blv_planes_control_close, info.pinfo
	return
endif

Widget_Control,event.id, Get_UValue=uvalue

CASE uValue OF
	'COLOR': BEGIN
		;purpose : controls the color of the current plane
		widget_control, event.top, get_uvalue=info

		if (*info.pInfo).data.position eq -1 then return
		if not obj_isa((*info.pInfoPlanes).currentPlane, 'optical_plane') then return
		(*info.pInfoPlanes).currentPlane->getProperty, color=color
		
		dim=Get_RGB((*info.pInfoPlanes).wBase, rgb=color)
		if dim.ok eq 1 then (*info.pInfoPlanes).currentPlane->setProperty, color=dim.rgb
		module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
		module->trace
		blv_draw_system, info.pInfo
		END


	'select_plane': BEGIN
		;purpose : changes the selected plane (choised in the current module)
		widget_control, event.id, get_value=button
		widget_control, event.top, get_uvalue=info
		if (*info.pInfo).data.position eq -1 then return
		
		module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
		module->getProperty,	planesSource=planesSource, $
					planesImage=planesImage, $
					planeElement=planeElement
		
		nb_planes=planesSource->count()+planesimage->count()+1

		if nb_planes eq 0 then return

		posi=(*info.pInfoPlanes).position
		case button of
			'<< Back': begin
				if posi EQ 0 then posi=nb_planes-1 else posi=posi-1
				end
			'Next >>': begin
				if posi EQ nb_planes-1 then posi=0 else posi=posi+1
				end
			else:;nothing
		endcase

		(*info.pInfoPlanes).position=posi
		; to get the good planes in the two container
		if posi gt planesSource->count()-1 then begin
			if posi eq nb_planes-1 then (*info.pInfoPlanes).currentPlane=planeElement $
			else begin
				posi=posi-planesSource->count()
				(*info.pInfoPlanes).currentPlane=planesImage->get(pos=posi)
			endelse
		endif else (*info.pInfoPlanes).currentPlane=planesSource->get(pos=posi)
		
		blv_planes_control_print_property, info
		END

	'Image_plane': BEGIN
		;purpose: calls a procedure to change the picture associated with the current plane
		widget_control, event.top, get_uvalue=info
		if (*info.pInfo).data.position eq -1 then return
		
		widget_control, (*info.pInfo).wid.statut, set_value='Waiting...'
		blv_image_processing,(*info.pInfoPlanes).wBase, (*info.pInfoPlanes).currentPlane
		widget_control, (*info.pInfo).wid.statut, set_value='Ready'
		module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
		module->trace
		blv_draw_system, info.pInfo
		END

	'Image_showOrPaste': BEGIN
		;purpose : control if the picture of the current plane must be draw
		widget_control, event.top, get_uvalue=info
		if (*info.pInfo).data.position eq -1 then return
		if obj_isa((*info.pInfoPlanes).currentPlane, 'optical_plane') then  $
			(*info.pInfoPlanes).currentPlane->flip_paste_image
		module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
		module->trace
		(*info.pInfo).wid.window->draw, (*info.pInfo).wid.view
		END

	'add': BEGIN
		;purpose : add a free plane to the module
		widget_control, event.top, get_uvalue=info
		if (*info.pInfo).data.position eq -1 then return
		currentModule=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)

		var={location:1.0}
		xScrMenu, var, wTitle='Locate new plane position',/notype,group=(*info.pInfoPlanes).wBase, $
			action=action, Dialog_Parent=event.top, Titles='Distance from O.E. [cm]'

		if action eq 'DONT' then return

		currentModule->add_plane, var.location
		currentModule->trace
		(*info.pInfo).wid.window->draw, (*info.pInfo).wid.view
		blv_planes_control_print_property, info
		END


	'delete': BEGIN
		;purpose : remove the selected plane to the module. Basics plane cant be removed.
		widget_control, event.top, get_uvalue=info
		if (*info.pInfo).data.position eq -1 then return
		currentModule=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
		currentmodule->getProperty, planesSource=planesSource, planesImage=planesImage

		ns=0
		nel=planesSource->count()
		ni=planesSource->count()+planesImage->count()

		if (*info.pInfoPlanes).position eq ns or $
			(*info.pInfoPlanes).position eq nel or $
			(*info.pInfoPlanes).position eq ni then return



		if planesSource->isContained((*info.pInfoPlanes).currentPlane) then $ 
			planesSource->remove, (*info.pInfoPlanes).currentPlane
		if planesImage->isContained((*info.pInfoPlanes).currentPlane) then $
			planesImage->remove, (*info.pInfoPlanes).currentPlane

		obj_destroy, (*info.pInfoPlanes).currentPlane
		currentModule->trace
		(*info.pInfo).wid.window->draw, (*info.pInfo).wid.view
		blv_planes_control_print_property, info
		END
	'readBeam': BEGIN
		; purpose : read beam data function to the file field of the current plane
		widget_control, event.top, get_uvalue=info
		if (*info.pInfo).data.position eq -1 then return
		(*info.pInfoPlanes).currentPlane->getProperty, beam_file=file
		if file eq 'Undefined' then return
		beam=read_rays_file(file)
		(*info.pInfoPlanes).currentPlane->setProperty, rays=beam
		END
	'DISMISS': BEGIN
		widget_control, event.top, get_uvalue=info
		blv_planes_control_close, info.pinfo
		END

	'SHOW_HIDE': BEGIN
		;purpose: controls the show/Hide option of the selected plane
		
		widget_control, event.id, get_value=button
		widget_control, event.top, get_uvalue=info
		
		if (*info.pInfo).data.position eq -1 then return
		module=(*info.pInfo).data.system->get_module(pos=(*info.pInfo).data.position)
		
		case button of
			'Show':begin
				(*info.pInfoPlanes).currentPlane->setProperty, show=0
				end
			'Hide':begin
				(*info.pInfoPlanes).currentPlane->setProperty, show=1
				end
		endcase
		
		module->trace
		(*info.pInfo).wid.window->draw, (*info.pInfo).wid.view
		END

	else: 
ENDCASE

END


;srio ;**********************************
;srio pro blv_planes_control_apply_event, event
;srio widget_control, event.top, get_uvalue=info
;srio blv_planes_control_close, info.pinfo
;srio end
;srio ;**********************************



;
;====================================================================================================================
;
function blv_planes_control, pInfo
;purpose : define and return the widget base


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_planes_control: error caught: '+!error_state.msg)
   RETURN,0
ENDIF



	wBase=widget_base(GROUP_LEADER=(*pInfo).wid.tbl,title='Optical Planes Controls',/col, $
			/TLB_KILL_REQUEST_EVENTS, event_pro='blv_planes_control_event', /floating)

	if (*pInfo).data.position ne -1 then $
		currentModule=(*pInfo).data.system->get_module(pos=(*pInfo).data.position) $
		else currentModule=obj_new()

	wButton=widget_base(wBase,/row)
			wDone=widget_button(wButton, value='Dismiss',UValue='DISMISS')
;srio			wApply=widget_button(wButton, value='Apply', event_pro='blv_planes_control_apply_event')


	wInfo=widget_base(wBase, /col,/frame)
			wTemp=widget_base(wInfo, /col,/align_center,/base_align_right)
			wNbMod=widget_base(wTemp,/row,/base_align_center)
				wTitle=widget_label(wNbMod,value='Number Of Planes : ')
				wNbPlanes=widget_label(wNbMod,value=string(0),/align_right,/DYNAMIC_RESIZE)
			wSelectedMod=widget_base(wTemp,/row,/base_align_center)
				wSelectedplane=cw_field(wSelectedMod,title='Selected Plane : ',/Integer, uValue='selectedModule', $
				 	value=-1, xsize=5,/return_event)
			wRef=widget_base(wInfo,/col)
				wNSource=widget_label(wRef,uvalue='Source Plane Number: ', value='Source Plane Number : ',/DYNAMIC_RESIZE, /align_right)
				wNElement=widget_label(wRef,uvalue='Element Plane Number: ', value='Element Plane Number : ',/DYNAMIC_RESIZE, /align_right)
				wNImage=widget_label(wRef,uvalue='Image Plane Number: ', value='Image Plane Number : ',/DYNAMIC_RESIZE, /align_right)
			wEdit=widget_base(wInfo,/row)
				wBack=widget_button(wEdit, value='<< Back', UValue='select_plane')
				wNext=widget_button(wEdit, value='Next >>', UValue='select_plane')
				wDelete=widget_button(wEdit, value='Delete', $
					UValue='delete')
				wDeleteAll=widget_button(wEdit, value='Delete All', event_pro='blv_planes_control_delete_all_event')
				wAdd=widget_button(wEdit, value='Add...', UValue='add')

		wActionBase=widget_base(wBase, /row, /frame)

			wTitle=widget_label(wActionBase,value='Selected Plane : ')
			wtempBase=widget_base(wActionBase, /col, /align_right)
				wtempBaseBis=widget_base(wtempBase, /row, /align_right)
				wShowPlanes = WIDGET_BUTTON(wtempBaseBis, VALUE='Show', $
                        		UValue='SHOW_HIDE')
            		wHidePlanes = WIDGET_BUTTON(wtempBaseBis, VALUE='Hide', $
                        UValue='SHOW_HIDE')

				wColor=widget_button(wtempBase, value='Color...', UValue='COLOR')

				wtempBaseBis=widget_base(wtempBase, /row, /align_right)
					wImage=widget_button(wtempBaseBis, value='Image...', $
					UValue='Image_plane')
					wExclu=widget_base(wtempBaseBis, /NONEXCLUSIVE)
						wShowImage=widget_button(wExclu, value='Show', $
						UValue='Image_showOrPaste')
		wFileBase=widget_base(wBase, /col,/frame)
			wfile=widget_text(wFileBase,xsize='60',value='',$
				/ALIGN_RIGHT)
			wRead=widget_button(wFileBase,value='(Re)Load Beam Data', $
				UValue='readBeam')


if obj_isa(currentModule, 'optical_module') then begin
currentmodule->getProperty, planesSource=planesSource
currentPlane=planesSource->get(pos=0)
endif else currentPlane=obj_new()


pInfoPlanes=ptr_new({wBase:wBase, $
					wNbPlanes:wNbPlanes, $
					wSelectedplane:wSelectedplane, $
					position:0, $
					wNSource:wNSource, $
					wNImage:wNImage, $
					wNElement:wNElement, $
					currentPlane:currentPlane, $
					wShowImage:wShowImage, $
					wFile:wFile $
					})

info={pInfoPlanes:pInfoPlanes, pinfo:pinfo}

widget_control, wBase, set_uValue=info

widget_control, wBase, /realize
xmanager, 'blv_planes_control', wBase, /no_block

return, wBase
end
