FUNCTION xsh_defaults,program
;+
; NAME:
;	XSH_DEFAULTS
;
; PURPOSE:
;	Define the data structure for each program of the Xop application.
;	The purpose of this function is to contain all the default input 
;	parameter definition in order to allow different Xop users to
;	customize their particular input defaults. 
;
; CATEGORY:
;	Xop application.
;
; CALLING SEQUENCE:
;
;	inp = XSH_DEFAULTS('xprogram')
;
; INPUTS:
;	xprogram:	Name of the program interface in Xop.
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	The input structure with the data necessary to run the program.
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;	shadow contains the default xshgeom and xshoe for faster
;	       access.
;
; SIDE EFFECTS:
;
; RESTRICTIONS: *** WARNING  ***
;	If the user changes this defaults, be careful with the type
;	of variable. Saying for instance a:4 initializes a as short
;	integer and WILL NEVER be a float. Place a:4.0 to set it as
;	float.
;
; PROCEDURE:
;	Straightforward.
;
; EXAMPLE:
;	inp = xsh_defaults('xurgent')
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio
;	October, 1994	
;	95/10/24 MSR adds xopmap (mapping option)
;	95/10/31 MSR adds filedir keyword , to allow users to create
;		a file ~/.xop_defaults with his own customization.
;	96/11/05 MSR adds INITIALIZE
;       97/04/02 MSR adds ~/.xsh_defaults as defaults file.
;       98/01/06 MSR adds nrays in xsh_undul, converted to anonymous str.
;       98/03/19 MSR common block for faster access.
;       98/04/23 MSR adds default []range entry in plotxy and histo1. No
;		autorefresh by defaut.
;       98/04/30 MSR adds xsh_ray_prop
;	01/03/07 MSR fixes a bug in xshwig: ph1 and ph2 are now float.
;       2012/05/29 srio@esrf.eu adds rejection rays option (f_bound_sour)
;       2014/10/17 srio@esrf.eu search .00 files in pecise directory 
;                               (problems in Mac)
;
;-

common shadow, xshgeom, xshoe, shadow_start

on_error,2
program = strupcase(program)
ds = sdep(/ds)

case program of
        ; This is "just in case" because shadow_start is defined
        ; in shadowvui_preferences.pro
	'SHADOW_START': begin 
		case sdep() of
 		 'UNIX': BEGIN
		  if n_elements(shadow_start) EQ 0 then shadow_start = $
		   'source /scisoft/xop2.3/extensions/shadowvui/shadow-2.3.2m-linux/.shadowrc'
		  END
		 'WINDOWS':BEGIN
		  ;if n_elements(shadow_start) EQ 0 then shadow_start = $
		  shadow_start = $
		   ['set SHADOW_ROOT=c:/users/srio/shadow/SHADOW2.3.1',$
		   'set PATH=c:/users/srio/shadow/SHADOW2.3.1/bin;c:\windows\command.com',$
		     'SET SHADOW_ENV_FILE=xsh_env_file.inp']
		  END
		 else:
		endcase
		end
	'XSHUNDUL': begin 
		; when set flag to 0, then maps the corresponding program call
		xshundul  =  { $
			;epath
			lambdau : 0.032D0,  $
			k : .25D0,  $
			e_energy : 6.04,  $
			;undul_set
			nperiods : 50L,  $
			emin : 10500.0D0,  $
			emax : 10550.0D0,  $
			intensity : 0.2D0,  $
			maxangle : 0.015D0,  $
                        ; added srio@esrf.eu 20131216
                        ; number of grid points (phi,theta,energy)
                        ng_e : 101L, $
                        ng_t : 51L, $
                        ng_p : 11L, $
                        ng_plot : ['0','No','Yes'], $
			;undul_phot
			undul_phot_flag : ['0','Shadow code','Urgent code','SRW code','Gaussian Approx'],$ 
			;input_source
			seed : 36255L, $
			sx : 400D-4, $
			sz : 10D-4, $
			ex : 4D-7, $
			ez : 4D-9, $
                        flag_emittance:['1','No','Yes'], $
			nrays:15000L, $
                        f_bound_sour:0, $
                        file_bound:'NONESPECIFIED', $ 
                        slit_distance:1000D0, $
                        slit_xmin:-1D0, $
                        slit_xmax:1D0, $
                        slit_zmin:-1D0, $
                        slit_zmax:1D0, $
                        ntotalpoint:10000000L }
		end
	'XSHBM':begin
                 print,"XSH_DEFAULTS: Wanring: Using obsolete call XSHBM"
                 print,"XSH_DEFAULTS: Wanring: Use instead XSH_GEOM_BM"
                 xshbm = { npoint:5000L, $
                          istar1:567656L, $
                          sigmax:7.8e-3, $
                          sigmaz:3.6e-3, $
                          hdiv1:0.0005, $
                          hdiv2:0.0005, $                         
                          r_aladdin_flag:['1','Magnetic Radius [m]',$
				'Magnetic Field [T]'],$
                          r_aladdin:0.8,$
                          epsi_x:3.8e-7,$
                          epsi_z:3.8e-9,$
                          bener:6.04,$
                          ph1:5000.0,$
                          ph2:100000.0,$
                          f_bound_sour:0L,$
                          file_bound:'NONESPECIFIED', $
                          ntotalpoint:10000000L }
                end
         'XSHWIG':begin
                     xshwig = { npoint:5000L, $
                              istar1:5676561L, $
                              flag_emittance:['1','No','Yes'], $
                              sigmax:56D-4, $
                              sigmaz:5D-4, $
                              epsi_x:2.88D-7,$
                              epsi_z:2.88D-9,$
                              epsi_dx:0.0d0,$
                              epsi_dz:0.0d0,$
                              bener:2.01D0,$
                              ph1:10000.0D0,$
                              ph2:10010.0D0, $
                              periods:50, $
                              wavlen:0.04D0, $
                              K:7.85D0, $
                              wiggler_type:['0','conventional/sinusoidal','B from file','B from harmonics'],$
                              file_b:'wiggler.b', $
                              file_h:'wiggler.h', $
                              f_bound_sour:0, $
                              file_bound:'NONESPECIFIED', $ 
                              slit_distance:1000D0, $
                              slit_xmin:-1D0, $
                              slit_xmax:1D0, $
                              slit_zmin:-1D0, $
                              slit_zmax:1D0, $
                              ntotalpoint:10000000L }
         
                end 	
         'XSHGEOM':begin
		if n_elements(xshgeom) EQ 0 then begin
		  file = XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'data'+ds+$
                         'start_geom.00'
		  IF checkfile(file) EQ 0 THEN BEGIN
		    itmp = Dialog_Message(Dialog_Parent=group,/Error,$
			'File '+file+' not found')
		    Return,0
		  ENDIF
		  xshgeom=read_gfile(file)
		endif
		end

         'XSH_SOURCE_G':begin
		;if n_elements(xsh_source_g) EQ 0 then begin
		  file = XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'data'+ds+$
                         'start_geom.00'
		  IF checkfile(file) EQ 0 THEN BEGIN
		    itmp = Dialog_Message(Dialog_Parent=group,/Error,$
			'File '+file+' not found')
		    Return,0
		  ENDIF
		  xsh_source_g=read_gfile(file)
		;endif
		end

         'XSH_SOURCE_BM':begin
		;if n_elements(xsh_source_bm) EQ 0 then begin
		  file = XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'data'+ds+$
		         'start_bm.00'
		  IF checkfile(file) EQ 0 THEN BEGIN
		    itmp = Dialog_Message(Dialog_Parent=group,/Error,$
			'File '+file+' not found')
		    Return,0
		  ENDIF
		  xsh_source_bm=read_gfile(file)
		;endif
		end

         'XSHOE':begin
		if n_elements(xshoe) EQ 0 then begin
		  file = XOP_GetEnv('XOP_HOME')+ds+'extensions'+ds+'shadowvui'+ds+'data'+ds+$
		         'start_oe.nn'
		  IF checkfile(file) EQ 0 THEN BEGIN
		    itmp = Dialog_Message(Dialog_Parent=group,/Error,$
			'File '+file+' not found')
		    Return,0
		  ENDIF
		  xshoe=read_gfile(file)
		endif
		end


	'XSH_PLOTXY': BEGIN
		xsh_plotxy = { $
		;
		;general
		;
		shadow_in:'begin.dat',$
		retrace:0.0,$
		col1:1, $
		col2:3, $
		XRANGE :[0.0,0.0], $
		YRANGE:[0.0,0.0], $
		NOLOST :1, $
		CART:0, $
		CONTOUR:0, $
		;
		; histograms
		;
		HISTO :0, $
		NBINS :75L, $
		CALFWHM:1, $
		GAUSSFIT:0, $
		NC_BINS :25L, $
		NLEVELS :6, $
		NSPLIT :1, $
		;
		; color
		;
		CFILE:'' , $
		CBINS:100L, $
		CCOL:0, $
		CLIMITS:[0.0,0.0], $
		CREF:0, $
		;
		;presentation
		;
		TITLE :' ', $
		SLIT :[0.0,0.0,0.0,0.0], $
		NOCOMM :0, $
		CHARSIZE:0.0, $
		MULFAC :0.0, $
		PUBLISH :0, $
		SMOOTH :0, $
		; 
		; Other interface setups
		;
		AUTOREFRESH:0, $
		DEFAULT_XRANGE:1, $
		DEFAULT_YRANGE:1, $
		DEFAULT_CLIMITS:1 }
		;
		; not driven by the interface
		;
		;EXTRACT :0, INFOSH:0, NFILES :0, NOERASE :0, $
		;XYRANGE:[0.0,0.0], shadow_out:0 , FWHM_VAL :0, FWHM_FIT :0 }
		END
   'XSH_HISTO1':BEGIN		
		  xsh_histo1={ $
		  SHADOW_IN:'begin.dat', $
		  COL:6, $ 
		  NBINS:75L,$		  	  	  
		  GAUSSFIT:0,$
		  XRANGE:[0.0,0.0],$
		  YRANGE:[0.0,0.0],$		  
		  YLOG:0,$
		  NOLOST:1,$
		  WRITE:0,$
		  CALFWHM:1,$
		  CALERROR:0,$
		  CM:0,$
		  REFLECTIVITY:23,$ ;  values=0,1,22,23,24,25,30,31,32,33
		  PUBLISH:0,$
		  TITLE:'',$
		  XTITLE:'',$
		  YTITLE:'',$
		  AUTOREFRESH:0, $
		  DEFAULT_XRANGE:1, $
		  DEFAULT_YRANGE:1, $
		  DEFAULT_CLIMITS:1 }
		END

   'XSH_RAY_PROP':BEGIN		
		  xsh_ray_prop={ $
		  SHADOW_IN:'star.01', $
		  COL1:1, $ 
		  COL2:3, $ 
		  RANGE:[-10.0,10.0],$
		  ITERS:21,$
		  XRANGE:[0.0,0.0],$
		  YRANGE:[0.0,0.0],$		  
		  TITLE:'',$
		  XTITLE:'',$
		  YTITLE:'',$
		  NOLOST:1,$
		  CART:0,$
		  XPLOT:0,$
		  MPEG:0,$
		  WAIT:0.0,$
		  DEFAULT_RANGE:0, $
		  DEFAULT_XRANGE:1, $
		  DEFAULT_YRANGE:1,$
                  NBINS:0L }
		END


	else:   begin
		print,'XSH_DEFAULTS: ERROR: Program not found'
		out = 0
		end
	endcase


;
; rename the structure to out 
;
out = 0
command = 'out = '+program
;print,command
tmp = execute(command)

;
; Overwrite data with values from defaults files
;
sep = sdep(/ds)
filedir = [Xop_GetEnv('SHADOWVUI_HOME')+sep+'data']
filedir = [filedir]
IF Xop_GetEnv('XOP_DEFAULTS_DIR') NE '' THEN $
   filedir = [filedir,Xop_GetEnv('XOP_DEFAULTS_DIR')]

nfiles = n_elements(filedir)
if nfiles EQ 1 then filedir = [filedir]
tmp=0
for i=0,nfiles-1 do begin
  file = filedir[i]+sep+StrLowCase(program)+'.xop'
  tmp = checkfile(file)
  if tmp EQ 1 then begin
    str_par = Xop_Input_Load(inputFile=file)
    ;IF N_Tags(out.parameters) NE 0 THEN BEGIN
    IF (Where(StrUpCase(Tag_Names(out)) EQ 'PARAMETERS'))(0) NE -1 THEN BEGIN
      tmp = out.parameters
      Copy_Structure,str_par, tmp
      out.parameters = tmp
    ENDIF ELSE BEGIN
      tmp = out
      Copy_Structure,str_par, tmp
      out = tmp
    ENDELSE
    message,/info,'Defaults from file: '+file+'
  endif
endfor
;
; return
;

return,out
end
