;		
;========================================================================
;
PRO Shadow_RunTrace, input, Group=group, previous_oe=previous_oe, $
  star_file=star_file,run_single_oe=run_single_oe

;+
; NAME:
;	SHADOW_RUNTRACE
; PURPOSE:
;	Interface for system call to Shadow3
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	shadow_runtrace
; INPUTS:
; OPTIONAL INPUTS:
;	input: the macro parent widget ID or structure (usually from COMMON)
; KEYWORD PARAMETERS:
;       PREVIOUS_OE: the oe number to start with
;       STAR_FILE: If PREVIOUS_OE is set, set this keyword to the file 
;                  containing the input beam (default: begin.dat)
;       RUN_ONLY_OE: Set this flag for running a single o.e. Use 
;                    PREVIOUS_OE keyword to start from a given o.e.
; OUTPUTS:
; COMMON BLOCKS:
;       COMMON shadow_ifc,parent1
;       COMMON shadow3, shadow3_mode, shadow3_binary
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	
; MODOFICATION HISTORY:
;	srio@esrf.eu 20140627, added doc, separated from shadow.pro
;	srio@esrf.eu 20140918, added RUN_SINGLE_OE
;
;-
COMMON shadow_ifc,parent1
COMMON shadow3, shadow3_mode, shadow3_binary

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /Cancel
   Message,/Info,'Error caught: '+!err_string
   itmp = Dialog_Message('SHADOW_RUNTRACE: Error caught: '+$
	!err_string,/Error,Dialog_Parent=group)
   RETURN
ENDIF

IF XRegistered('XSHOE') THEN BEGIN
  itmp = Dialog_Message(/Error,Dialog_Parent=group,$
    ['SHADOW VUI has detected opened windows for o.e.s',$
    'Please close all of them before starting SHADOW/trace'])
  RETURN
ENDIF


CASE type(input) OF
  0: BEGIN ; undefined
     Widget_Control,parent1,Get_UValue=state
     END
  3: BEGIN ; widget_parent
     Widget_Control,input,Get_UValue=state
     END
  8: BEGIN ; state (structure)
     state=input
     END
  else: Message,'Bad input'
ENDCASE

IF (state.ifc.oe_n LE 0) THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group,$
    ['No optical elements defined.','Use "Add oe" before'])
  RETURN
ENDIF


; 
; single-oe case, user shadow-trace-batch
;
if keyword_set(run_single_oe) then begin

  i = previous_oe+1
  IF i LE 9 THEN file = 'start.0'+strcompress(i,/Rem) ELSE $
                 file = 'start.'+strcompress(i,/Rem)
  Write_GFile,*state.PtrTrc(i-1),file



  openw,unit,'shadow3.inp',/get_lun
  printf,unit,'trace'
  printf,unit,'batch'
  if keyword_set(previous_oe) then begin
      printf,unit,'1'
      printf,unit,strcompress(previous_oe,/remove_all)
      if keyword_set(star_file) then begin
          printf,unit,star_file
      endif else begin
          printf,unit,'begin.dat'
      endelse
      printf,unit,'0'
      printf,unit,'start.'+string(previous_oe+1,format='(I2.2)')
      printf,unit,'0'
      printf,unit,'exit'
      printf,unit,'exit'
  endif else begin
      printf,unit,'0'
      printf,unit,'start.01'
      printf,unit,'0'
      printf,unit,'exit'
      printf,unit,'exit'
  endelse
  free_lun,unit
  command = shadow3_binary+' < shadow3.inp'
  XSh_Run,command

  return
endif

; 
; normal case, user shadow-trace-systemfile
;
OpenW,lun,'systemfile.dat',/Get_Lun
FOR i=1,state.ifc.oe_n DO BEGIN
  IF i LE 9 THEN file = 'start.0'+strcompress(i,/Rem) ELSE $
                 file = 'start.'+strcompress(i,/Rem)
  ;file = 'start.0'+strcompress(i,/Rem)
  PrintF,lun,file
  Write_GFile,*state.PtrTrc(i-1),file
ENDFOR
Free_lun,lun

Widget_control,/hourglass
IF shadow3_mode EQ 0 THEN BEGIN
  command = 'echo 0 | trace -m menu'
ENDIF ELSE BEGIN
  openw,unit,'shadow3.inp',/get_lun
  printf,unit,'trace'
  printf,unit,'systemfile'
  if keyword_set(previous_oe) then begin
      printf,unit,'1'
      printf,unit,strcompress(previous_oe,/remove_all)
      if keyword_set(star_file) then begin
          printf,unit,star_file
      endif else begin
          printf,unit,'begin.dat'
      endelse
  endif else begin
      printf,unit,'0'
  endelse
  printf,unit,'exit'
  free_lun,unit
  command = shadow3_binary+' < shadow3.inp'
ENDELSE
XSh_Run,command

END ; Shadow_RunTrace
